//Einbinden der Bibliotheken
#include <Wire.h>
#include <LiquidCrystal_I2C.h>
#include <Servo.h> //Die Servobibliothek wird aufgerufen.


LiquidCrystal_I2C lcd(0x27, 16, 2);

Servo servo1;
Servo servo2;

int poti1 = A0;
int poti2 = A1;

//Anzahl der Werte in der Tabelle (256 für 0-255)
#define TABLE_SIZE 1025
uint8_t output;

uint8_t lookupTable[TABLE_SIZE];

// Definition der Pins für die Sensoren
const int pinVR = 10; // Rechter vorderer Sensor
const int pinVL = 11; // Linker vorderer Sensor
const int pinHR = 12; // Rechter hinterer Sensor
const int pinHL = 13; // Linker hinterer Sensor

void setup() {
  // Pins als Eingänge konfigurieren
  pinMode(pinVR, INPUT);
  pinMode(pinVL, INPUT);
  pinMode(pinHR, INPUT);
  pinMode(pinHL, INPUT);
  for (int i = 0; i <= 3; i++) {
      lcd.setCursor(i,1);
      lcd.print("X");
  }

  //Initialisierung des Displays
  lcd.init();
  lcd.backlight();
  lcd.setCursor(0,0);
  lcd.print("Passwort: ");

  //Initialisierung der Servos
  servo1.attach(8);
  servo2.attach(7);

  //Serielle Kommunikation für Debugging starten
  Serial.begin(9600);

}

void loop() {
  //Auslesen der Potentiometerwerte
  int Poti1Wert = analogRead(poti1);
  int Poti2Wert = analogRead(poti2);
  Serial.println(Poti1Wert);

  //Bestimmen der Ausgabewerte für die Servos mittels der Lookup-Tables
  int output1 = map(Poti1Wert, 0, 1023, 60, 120);
  servo1.write(output1);
  int output2 = map(Poti2Wert, 0, 1023, 60, 120);
  servo2.write(output2);
  
  //Setzen der Ziffern des Zahlencodes
  if(digitalRead(pinVR)==1)
  {
      lcd.setCursor(0,1);
      lcd.print("9");
  }

    if(digitalRead(pinVL)==1)
  {
      lcd.setCursor(1,1);
      lcd.print("9");
  }
  
  if(digitalRead(pinHR)==1)
  {
      lcd.setCursor(2,1);
      lcd.print("9");
  }
  
  if(digitalRead(pinHL)==1)
  {
      lcd.setCursor(3,1);
      lcd.print("9");
  }
  // Kurze Verzögerung
  delay(100);
}
