//Einbinden der Bibliotheken
#include <Wire.h>
#include <LiquidCrystal_I2C.h>
#include <Servo.h> //Die Servobibliothek wird aufgerufen.


LiquidCrystal_I2C lcd(0x27, 16, 2);

Servo servo1;
Servo servo2;

int poti1 = A0;
int poti2 = A1;

//Anzahl der Werte in der Tabelle (256 für 0-255)
#define TABLE_SIZE 1025
uint8_t output;

uint8_t lookupTable[TABLE_SIZE];

// Definition der Pins für die Sensoren
const int pinVR = 10; // Rechter vorderer Sensor
const int pinVL = 11; // Linker vorderer Sensor
const int pinHR = 12; // Rechter hinterer Sensor
const int pinHL = 13; // Linker hinterer Sensor

//Variablen für die Ziffern des Zahlencodes
int ersteZiffer = 0;
int zweiteZiffer = 0;
int dritteZiffer = 0;
int vierteZiffer = 0;

void setup() {
  // Pins als Eingänge konfigurieren
  pinMode(pinVR, INPUT);
  pinMode(pinVL, INPUT);
  pinMode(pinHR, INPUT);
  pinMode(pinHL, INPUT);

  //Initialisierung des Displays
  lcd.init();
  lcd.backlight();

  servo1.attach(8);
  servo2.attach(7);

  // Serielle Kommunikation für Debugging starten
  Serial.begin(9600);

}

void loop() {
  //Auslesen der Potentiometerwerte
  int Poti1Wert = analogRead(poti1);
  int Poti2Wert = analogRead(poti2);

  //Bestimmen der Ausgabewerte für die Servos mittels der Lookup-Tables
  int output1 = map(Poti1Wert, 0, 1023, 60, 120);
  servo1.write(output1);
  int output2 = map(Poti2Wert, 0, 1023, 60, 120);
  servo2.write(output2);
  
  //Setzen der Ziffern des Zahlencodes
  if(digitalRead(pinVR)==1)
  {
    ersteZiffer = 9;
  }

    if(digitalRead(pinVL)==1)
  {
    zweiteZiffer = 9;
  }
  
  if(digitalRead(pinHR)==1)
  {
    dritteZiffer = 9;
  }
  
  if(digitalRead(pinHL)==1)
  {
    vierteZiffer = 9;
  }

  // Berechnen des Passwortes
  int sum = (ersteZiffer*1000)+(zweiteZiffer*100)+(dritteZiffer*10)+vierteZiffer;
  
  // Ausgabe der Summe für Debugging
  Serial.print(output1);
  Serial.print("    ");
  Serial.println(output2);

  //Ausgabe des Passwortes auf dem LCD
  lcd.setCursor(0,0);
  lcd.print("Passwort: ");
  lcd.setCursor(0,1);
  lcd.print(sum);

  // Kurze Verzögerung
  delay(100);
}
