clear all; close all; clc

% Laden der CSV-Datei
dataTable = readtable('Messdaten_Strecke.csv');
n = length(dataTable.Zentral_x);
% Zugriff auf Spaltenwerte (nach Spaltennamen)
Timestamp = dataTable.Timestamp; % Zeitstempel
zeit = (Timestamp - Timestamp(1)); % Umwandlung in Sekunden
Zentral_Bild_x = dataTable.Zentral_Bild_x; % Spalte Zentral_Bild_x
Zentral_x = dataTable.Zentral_x - 88; % Spalte Zentral_x (mit Verschiebung)

% Darstellung der Daten
figure;
hold on;
plot(zeit, Zentral_x, 'r', 'LineWidth', 2); % Rote Kurve

% Einstellen der Achsenbereiche
xlim([0 2.5]);
ylim([0 500]);

% Achsenbeschriftungen und Titel setzen
xlabel('Zeit in s', 'FontSize', 14); % x-Achsenbeschriftung, Schriftgröße 14
ylabel('x Koordinate in m', 'FontSize', 14); % y-Achsenbeschriftung, Schriftgröße 14
title('Analyse der Strecke-Kamerahalterung', 'FontSize', 16); % Titel, Schriftgröße 16

% Schriftgröße der Achsen-Ticks einstellen
set(gca, 'FontSize', 12); % Schriftgröße der Achsen-Ticks auf 12 setzen

grid on; % Gitter hinzufügen
