def Camera_Video_Worker(cv_worker_result_queue):
    """
    Verarbeitung des Videostreams in Echtzeit, Anzeige von Körperskelett, Winkeln und Ellbogenkoordinaten.
    """
    mp_drawing = mp.solutions.drawing_utils  # Initialisierung der Zeichnungswerkzeuge
    mp_pose = mp.solutions.pose  # Initialisierung der Pose-Erkennungswerkzeuge
    mp_face_detection = mp.solutions.face_detection
    cap = cv2.VideoCapture(1)  # Öffnen der Kamera (Geräteindex 0)

    with mp_pose.Pose(min_detection_confidence=0.51, min_tracking_confidence=0.51) as pose:
        while cap.isOpened():
            ret, frame = cap.read()  # Aufnahme eines Kamerabildes
            if not ret:
                print("Kamerabild konnte nicht gelesen werden.")  # Fehlerausgabe
                break

            image = cv2.cvtColor(frame, cv2.COLOR_BGR2RGB)  # Umwandlung in RGB-Bild
            image.flags.writeable = False  # Bild auf schreibgeschützt setzen
            results = pose.process(image)  # Verarbeitung des Bildes zur Extraktion der Körperschlüsselpunkte
            image.flags.writeable = True  # Bild wieder beschreibbar setzen
            image = cv2.cvtColor(image, cv2.COLOR_RGB2BGR)  # Rückwandlung in BGR-Bild

            if results.pose_landmarks:  # Wenn Schlüsselpunkte erkannt wurden
                mp_drawing.draw_landmarks(image, results.pose_landmarks, mp_pose.POSE_CONNECTIONS)  # Zeichnen des Körperskeletts
                nose = results.pose_landmarks.landmark[mp.solutions.pose.PoseLandmark.NOSE]
                height, width, _ = frame.shape  # Abfrage der Bildmaße
                angle_data = getAngleFromVideo(results.pose_landmarks, height, width)  # Winkel- und Schlüsselpunktdaten abrufen
                image = GraphicalUserInterface.user_skeleton_visualisation(image, results.pose_landmarks)
                # Zeichne das Skelett auf das Bild
                cv_worker_result_queue.put(escape.PoseObject(results.pose_landmarks, image ))
                if platform.system()== 'Linux': 
                    Kamera_Regelung(image, nose)
            
            cv2.imshow('Body Landmarks with Angles', image)  # Anzeige des verarbeiteten Bildes
            time.sleep(0.1)
            if cv2.waitKey(1) & 0xFF == ord('q'):  # Beenden durch Drücken der Taste 'q'
                break

    cap.release()  # Freigeben der Kamera
    cv2.destroyAllWindows()  # Schließen aller Fenster
