//%*************************************************************** *
//%                   Hochschule Hamm-Lippstadt                    *
//%*************************************************************** *
//% Modul	        : sfun_SetLogicalValueForSevenSegementDisp.c   *
//%                                                                *
//% Datum           : 18.11.2024                                   *
//%                                                                *
//% Funktion        : Drei 7-Segment-Decoder steuern und die       *
//%                   jeweiligen vier Bits setzten für das Output  *
//%                                                                *
//% Implementation  : MATLAB 2023b                                 *
//%                                                                *
//% Req. Toolbox    : -                                            *
//%                                                                *
//% Author          : Oliver Scholze, Niklas Reeker, Johann Kismann*
//%                                                                *
//% Anpassung in    : mdlInitializeSizes(SimStruct *S)             *
//%                   mdlOutputs(SimStruct *S, int_T tid)          *
//%                                                                *
//% Letzte Änderung : 18.11.2024                                   *
//%****************************************************************

/*
 * You must specify the S_FUNCTION_NAME as the name of your S-function
 * (i.e. replace sfuntmpl_basic with the name of your S-function).
 */

#define S_FUNCTION_NAME  sfun_SetLogicalValueForSevenSegementDisp
#define S_FUNCTION_LEVEL 2

/*
 * Need to include simstruc.h for the definition of the SimStruct and
 * its associated macro definitions.
 */
#include "simstruc.h"



/* Error handling
 * --------------
 *
 * You should use the following technique to report errors encountered within
 * an S-function:
 *
 *       ssSetErrorStatus(S,"Error encountered due to ...");
 *       return;
 *
 * Note that the 2nd argument to ssSetErrorStatus must be persistent memory.
 * It cannot be a local variable. For example the following will cause
 * unpredictable errors:
 *
 *      mdlOutputs()
 *      {
 *         char msg[256];         {ILLEGAL: to fix use "static char msg[256];"}
 *         sprintf(msg,"Error due to %s", string);
 *         ssSetErrorStatus(S,msg);
 *         return;
 *      }
 *
 */

/*====================*
 * S-function methods *
 *====================*/

/* Function: mdlInitializeSizes ===============================================
 * Abstract:
 *    The sizes information is used by Simulink to determine the S-function
 *    block's characteristics (number of inputs, outputs, states, etc.).
 */
static void mdlInitializeSizes(SimStruct *S)
{
    ssSetNumSFcnParams(S, 0);  /* Number of expected parameters */
    if (ssGetNumSFcnParams(S) != ssGetSFcnParamsCount(S)) {
        /* Return if number of expected != number of actual parameters */
        return;
    }

    ssSetNumContStates(S, 0);
    ssSetNumDiscStates(S, 0);

    if (!ssSetNumInputPorts(S, 1)) return;
    ssSetInputPortWidth(S, 0, 1);
    ssSetInputPortRequiredContiguous(S, 0, true); /*direct input signal access*/
    /*
     * Set direct feedthrough flag (1=yes, 0=no).
     * A port has direct feedthrough if the input is used in either
     * the mdlOutputs or mdlGetTimeOfNextVarHit functions.
     */
    ssSetInputPortDirectFeedThrough(S, 0, 1);

    if (!ssSetNumOutputPorts(S, 12)) return;
    ssSetOutputPortWidth(S, 0, 1);
    ssSetOutputPortWidth(S, 1, 1);
    ssSetOutputPortWidth(S, 2, 1);
    ssSetOutputPortWidth(S, 3, 1);

    ssSetOutputPortWidth(S, 4, 1);
    ssSetOutputPortWidth(S, 5, 1);
    ssSetOutputPortWidth(S, 6, 1);
    ssSetOutputPortWidth(S, 7, 1);

    ssSetOutputPortWidth(S, 8, 1);
    ssSetOutputPortWidth(S, 9, 1);
    ssSetOutputPortWidth(S, 10, 1);
    ssSetOutputPortWidth(S, 11, 1);

    ssSetNumSampleTimes(S, 1);
    ssSetNumRWork(S, 0);
    ssSetNumIWork(S, 0);
    ssSetNumPWork(S, 0);
    ssSetNumModes(S, 0);
    ssSetNumNonsampledZCs(S, 0);

    /* Specify the operating point save/restore compliance to be same as a 
     * built-in block */
    ssSetOperatingPointCompliance(S, USE_DEFAULT_OPERATING_POINT);

    ssSetOptions(S, 0);
}



/* Function: mdlInitializeSampleTimes =========================================
 * Abstract:
 *    This function is used to specify the sample time(s) for your
 *    S-function. You must register the same number of sample times as
 *    specified in ssSetNumSampleTimes.
 */
static void mdlInitializeSampleTimes(SimStruct *S)
{
    ssSetSampleTime(S, 0, CONTINUOUS_SAMPLE_TIME);
    ssSetOffsetTime(S, 0, 0.0);

}



#define MDL_INITIALIZE_CONDITIONS   /* Change to #undef to remove function */
#if defined(MDL_INITIALIZE_CONDITIONS)
  /* Function: mdlInitializeConditions ========================================
   * Abstract:
   *    In this function, you should initialize the continuous and discrete
   *    states for your S-function block.  The initial states are placed
   *    in the state vector, ssGetContStates(S) or ssGetRealDiscStates(S).
   *    You can also perform any other initialization activities that your
   *    S-function may require. Note, this routine will be called at the
   *    start of simulation and if it is present in an enabled subsystem
   *    configured to reset states, it will be call when the enabled subsystem
   *    restarts execution to reset the states.
   */
  static void mdlInitializeConditions(SimStruct *S)
  {
  }
#endif /* MDL_INITIALIZE_CONDITIONS */



#define MDL_START  /* Change to #undef to remove function */
#if defined(MDL_START) 
  /* Function: mdlStart =======================================================
   * Abstract:
   *    This function is called once at start of model execution. If you
   *    have states that should be initialized once, this is the place
   *    to do it.
   */
  static void mdlStart(SimStruct *S)
  {
  }
#endif /*  MDL_START */



/* Function: mdlOutputs =======================================================
 * Abstract:
 *    In this function, you compute the outputs of your S-function
 *    block.
 */
static void mdlOutputs(SimStruct *S, int_T tid)
{
    const real_T *number = (const real_T*) ssGetInputPortSignal(S,0);

    real_T       *Xxx_D3 = ssGetOutputPortSignal(S,0);
    real_T       *Xxx_D2 = ssGetOutputPortSignal(S,1);
    real_T       *Xxx_D1 = ssGetOutputPortSignal(S,2);
    real_T       *Xxx_D0 = ssGetOutputPortSignal(S,3);

    real_T       *xXx_D3 = ssGetOutputPortSignal(S,4);
    real_T       *xXx_D2 = ssGetOutputPortSignal(S,5);
    real_T       *xXx_D1 = ssGetOutputPortSignal(S,6);
    real_T       *xXx_D0 = ssGetOutputPortSignal(S,7);

    real_T       *xxX_D3 = ssGetOutputPortSignal(S,8);
    real_T       *xxX_D2 = ssGetOutputPortSignal(S,9);
    real_T       *xxX_D1 = ssGetOutputPortSignal(S,10);
    real_T       *xxX_D0 = ssGetOutputPortSignal(S,11);
    
    // Rundung vor Ziffernextraktion
    double roundedValue;

    // Bedingung prüfen: Wenn der Eingabewert zwischen 9 und 11 liegt, gebe 10 aus
    if (number[0] >= 9.0 && number[0] <= 11.0) {
         roundedValue = 10.0;
    } else {
         // Andernfalls reguliere Rundungslogik
         if (number[0] - floor(number[0]) >= 0.5) {
        roundedValue = ceil(number[0]);  // Nach oben runden
    } else {
        roundedValue = floor(number[0]); // Nach unten runden
    }
    }

    // Zahl in Ganzzahl umwandeln
    int num = (int)roundedValue;
    
    /* Nummer in ihre Ziffern aufteilen und Gleitkommazahl zu Ganzzahl casten */
    int num_Xxx = num / 100;          // Erste Ziffer (Hunderterstelle)
    int num_xXx = (num / 10) % 10;    // Zweite Ziffer (Zehnerstelle)
    int num_xxX = num % 10; 

   /* Switch Case Anweisung für die erste Zahl Xxx */  
    switch (num_Xxx) {
        case 0:
           Xxx_D3[0] = 0;
           Xxx_D2[0] = 0;
           Xxx_D1[0] = 0;
           Xxx_D0[0] = 0;
           break;
        case 1:
           Xxx_D3[0] = 0;
           Xxx_D2[0] = 0;
           Xxx_D1[0] = 0;
           Xxx_D0[0] = 1;
           break;
        case 2:
           Xxx_D3[0] = 0;
           Xxx_D2[0] = 0;
           Xxx_D1[0] = 1;
           Xxx_D0[0] = 0;
           break;
        case 3:
           Xxx_D3[0] = 0;
           Xxx_D2[0] = 0;
           Xxx_D1[0] = 1;
           Xxx_D0[0] = 1;
           break;
        case 4:
           Xxx_D3[0] = 0;
           Xxx_D2[0] = 1;
           Xxx_D1[0] = 0;
           Xxx_D0[0] = 0;
           break;
        case 5:
           Xxx_D3[0] = 0;
           Xxx_D2[0] = 1;
           Xxx_D1[0] = 0;
           Xxx_D0[0] = 1;
           break;
        case 6:
           Xxx_D3[0] = 0;
           Xxx_D2[0] = 1;
           Xxx_D1[0] = 1;
           Xxx_D0[0] = 0;
           break;
        case 7:
           Xxx_D3[0] = 0;
           Xxx_D2[0] = 1;
           Xxx_D1[0] = 1;
           Xxx_D0[0] = 1;
           break;
        case 8:
           Xxx_D3[0] = 1;
           Xxx_D2[0] = 0;
           Xxx_D1[0] = 0;
           Xxx_D0[0] = 0;
           break;
        case 9:
           Xxx_D3[0] = 1;
           Xxx_D2[0] = 0;
           Xxx_D1[0] = 0;
           Xxx_D0[0] = 1;
           break;
       default:
           /* Bei ungültiger Zahl blank Anzeigen */
           Xxx_D3[0] = 1;
           Xxx_D2[0] = 0;
           Xxx_D1[0] = 1;
           Xxx_D0[0] = 0;
           break;}

     /* Switch Case Anweisung für die zweite Zahl xXx */                                           
     switch (num_xXx) {
        case 0:
           xXx_D3[0] = 0;
           xXx_D2[0] = 0;
           xXx_D1[0] = 0;
           xXx_D0[0] = 0;
           break;
        case 1:
           xXx_D3[0] = 0;
           xXx_D2[0] = 0;
           xXx_D1[0] = 0;
           xXx_D0[0] = 1;
           break;
        case 2:
           xXx_D3[0] = 0;
           xXx_D2[0] = 0;
           xXx_D1[0] = 1;
           xXx_D0[0] = 0;
           break;
        case 3:
           xXx_D3[0] = 0;
           xXx_D2[0] = 0;
           xXx_D1[0] = 1;
           xXx_D0[0] = 1;
           break;
        case 4:
           xXx_D3[0] = 0;
           xXx_D2[0] = 1;
           xXx_D1[0] = 0;
           xXx_D0[0] = 0;
           break;
        case 5:
           xXx_D3[0] = 0;
           xXx_D2[0] = 1;
           xXx_D1[0] = 0;
           xXx_D0[0] = 1;
           break;
        case 6:
           xXx_D3[0] = 0;
           xXx_D2[0] = 1;
           xXx_D1[0] = 1;
           xXx_D0[0] = 0;
           break;
        case 7:
           xXx_D3[0] = 0;
           xXx_D2[0] = 1;
           xXx_D1[0] = 1;
           xXx_D0[0] = 1;
           break;
        case 8:
           xXx_D3[0] = 1;
           xXx_D2[0] = 0;
           xXx_D1[0] = 0;
           xXx_D0[0] = 0;
           break;
        case 9:
           xXx_D3[0] = 1;
           xXx_D2[0] = 0;
           xXx_D1[0] = 0;
           xXx_D0[0] = 1;
           break;
       default:
           /* Bei ungültiger Zahl blank Anzeigen */
           xXx_D3[0] = 1;
           xXx_D2[0] = 0;
           xXx_D1[0] = 1;
           xXx_D0[0] = 0;
           break;}


     /* Switch Case Anweisung für die dritte Zahl xxX */                                           
     switch (num_xxX) {
        case 0: 
           xxX_D3[0] = 0;
           xxX_D2[0] = 0;
           xxX_D1[0] = 0;
           xxX_D0[0] = 0;
           break;
        case 1:
           xxX_D3[0] = 0;
           xxX_D2[0] = 0;
           xxX_D1[0] = 0;
           xxX_D0[0] = 1;
           break;
        case 2:
           xxX_D3[0] = 0;
           xxX_D2[0] = 0;
           xxX_D1[0] = 1;
           xxX_D0[0] = 0;
           break;
        case 3:
           xxX_D3[0] = 0;
           xxX_D2[0] = 0;
           xxX_D1[0] = 1;
           xxX_D0[0] = 1;
           break;
        case 4:
           xxX_D3[0] = 0;
           xxX_D2[0] = 1;
           xxX_D1[0] = 0;
           xxX_D0[0] = 0;
           break;
        case 5:
           xxX_D3[0] = 0;
           xxX_D2[0] = 1;
           xxX_D1[0] = 0;
           xxX_D0[0] = 1;
           break;
        case 6:
           xxX_D3[0] = 0;
           xxX_D2[0] = 1;
           xxX_D1[0] = 1;
           xxX_D0[0] = 0;
           break;
        case 7:
           xxX_D3[0] = 0;
           xxX_D2[0] = 1;
           xxX_D1[0] = 1;
           xxX_D0[0] = 1;
           break;
        case 8:
           xxX_D3[0] = 1;
           xxX_D2[0] = 0;
           xxX_D1[0] = 0;
           xxX_D0[0] = 0;
           break;
        case 9:
           xxX_D3[0] = 1;
           xxX_D2[0] = 0;
           xxX_D1[0] = 0;
           xxX_D0[0] = 1;
           break;
       default:
           /* Bei ungültiger Zahl blank Anzeigen */
           xxX_D3[0] = 1;
           xxX_D2[0] = 0;
           xxX_D1[0] = 1;
           xxX_D0[0] = 0;
           break;}
}



#define MDL_UPDATE  /* Change to #undef to remove function */
#if defined(MDL_UPDATE)
  /* Function: mdlUpdate ======================================================
   * Abstract:
   *    This function is called once for every major integration time step.
   *    Discrete states are typically updated here, but this function is useful
   *    for performing any tasks that should only take place once per
   *    integration step.
   */
  static void mdlUpdate(SimStruct *S, int_T tid)
  {
  }
#endif /* MDL_UPDATE */



#define MDL_DERIVATIVES  /* Change to #undef to remove function */
#if defined(MDL_DERIVATIVES)
  /* Function: mdlDerivatives =================================================
   * Abstract:
   *    In this function, you compute the S-function block's derivatives.
   *    The derivatives are placed in the derivative vector, ssGetdX(S).
   */
  static void mdlDerivatives(SimStruct *S)
  {
  }
#endif /* MDL_DERIVATIVES */



/* Function: mdlTerminate =====================================================
 * Abstract:
 *    In this function, you should perform any actions that are necessary
 *    at the termination of a simulation.  For example, if memory was
 *    allocated in mdlStart, this is the place to free it.
 */
static void mdlTerminate(SimStruct *S)
{
}


/*=============================*
 * Required S-function trailer *
 *=============================*/

#ifdef  MATLAB_MEX_FILE    /* Is this file being compiled as a MEX-file? */
#include "simulink.c"      /* MEX-file interface mechanism */
#else
#include "cg_sfun.h"       /* Code generation registration function */
#endif
