%****************************************************************
%                   Hochschule Hamm-Lippstadt                   *
%****************************************************************
% Modul	          : BerechnungderStandardunsicherheit.m         *
%                                                               *
% Datum           : 08.01.2025                                  *
%                                                               *
% Funktion        : Berechnung der Standarunsicherheiten und    *
%                   der Abweichungen vom Messergebnis (Zeit)    *
%                                                               *
% Implementation  : MATLAB 2023b                                *
%                                                               *
% Req. Toolbox    : Statistics and Machine Learning Toolbox     *
%                                                               *
% Author          : Oliver Scholze                              *
%                                                               *
% Bemerkung       :   -                                         *
%                                                               *
% Letzte Änderung : 08.01.2025                                  *
%****************************************************************
clc; clear all; close all;

%% Messungen laden und verarbeiten
Gesamtmessung = [5.125, 5.142, 5.105, 5.136, 5.152]; % Zeit in Sekunden

%% Mittelwerte berechnen
R = mean(Gesamtmessung(:));  % Mittelwert der Messwerte

%% Empirische Standardabweichung bestimmen
s = std(Gesamtmessung(:));  % Standardabweichung der Messwerte

%% Standardunsicherheit Typ A bestimmen
p = 0.95;  % Vertrauensniveau (95%)
n = length(Gesamtmessung); % Anzahl der Messwerte
nu = n - 1; % Freiheitsgrade
t = tinv((1 + p) / 2, nu); % t-Quantil
uA = s * t / sqrt(n);  % Standardunsicherheit Typ A

%% Standardunsicherheit Typ B bestimmen
% Annahmen für Typ-B-Unsicherheit
time_resolution = 0.01;  % Zeitauflösung des Systems in Sekunden
taster_uncertainty = 0.02;  % Latenz des Tasters in Sekunden

% Typ-B-Unsicherheit
uB = sqrt((time_resolution^2 / 3) + (taster_uncertainty^2 / 3));  % Typ-B-Unsicherheit

%% Kombinierte Standardunsicherheit Typ C bestimmen
uC = sqrt(uA^2 + uB^2);  % Kombinierte Unsicherheit

%% Grad des Vertrauens bestimmen
k = 2;  % Vertrauensfaktor für 95% Konfidenzniveau

% Absolute Messunsicherheit bestimmen
uAbs = k * uC;

% Relative Messunsicherheit berechnen (%)
uRel = (uAbs / R) * 100;

%% Ergebnisdarstellung Typ C
figure;
yline(R, 'Color', 'k', 'DisplayName', 'Mittelwert');
yline(5.14, 'Color', 'g', 'DisplayName', 'Referenzwert Oszilloskop (5.14s)');
xlim([0 n]);
grid on;
hold on;
plot([0 n], [R + uC R + uC], '--b', [0 n], [R - uC R - uC], '--b', 'DisplayName', 'Unsicherheit Typ C');
plot(1:n, Gesamtmessung, '*-', 'DisplayName', 'Messwerte');  % Mittelwerte plotten
xlabel('Anzahl der Messpunkte');
ylabel('Zeit in s');
xlim([1 5])
ylim([5.05 5.25]);
title(['Messergebnis der Zeitmessung (Mittelwert = ', num2str(R), 's, Unsicherheit = \pm', num2str(uC), 's, ', num2str(uRel), '%)']);
grid on;
legend;
