%****************************************************************
%                   Hochschule Hamm-Lippstadt                   *
%****************************************************************
% Modul	          : BerechnungderStandardunsicherheit.m         *
%                                                               *
% Datum           : 08.01.2025                                  *
%                                                               *
% Funktion        : Berechnung der Standarunsicherheiten und    *
%                   der Abweichungen vom Messergebnis (Abstand) *
%                                                               *
% Implementation  : MATLAB 2023b                                *
%                                                               *
% Req. Toolbox    : Statistics and Machine Learning Toolbox     *
%                                                               *
% Author          : Oliver Scholze                              *
%                                                               *
% Bemerkung       :   -                                         *
%                                                               *
% Letzte Änderung : 08.01.2025                                  *
%****************************************************************
clc; clear all, close all;
%% Messungen laden und verarbeiten
% Messung 1
load("20250108_MessungCm10.mat")
n = numel(gefiltertes_Signal.data(1,1,:)) ;  % Anzahl der Messungen
M1 = zeros(1, n - 100);  % Reduzierte Länge nach dem Verwerfen der ersten 100 Messwerte
for i = 101:n
    M1(i - 100) = gefiltertes_Signal.data(1,1,i); 
end

% Messung 2
load("20250108_MessungCm10_1.mat")
M2 = zeros(1, n - 100);
for i = 101:n
    M2(i - 100) = gefiltertes_Signal.data(1,1,i); 
end

% Messung 3
load("20250108_MessungCm10_2.mat")
M3 = zeros(1, n - 100);
for i = 101:n
    M3(i - 100) = gefiltertes_Signal.data(1,1,i); 
end

% Messung 4
open("20250108_MessungCm10_3.mat")
M4 = zeros(1, n - 100);
for i = 101:n
    M4(i - 100) = gefiltertes_Signal.data(1,1,i); 
end

% Messung 5
open("20250108_MessungCm10_4.mat")
M5 = zeros(1, n - 100);
for i = 101:n
    M5(i - 100) = gefiltertes_Signal.data(1,1,i); 
end

% Messung 6
open("20250108_MessungCm10_5.mat")
M2 = zeros(1, n - 100);
for i = 101:n
    M2(i - 100) = gefiltertes_Signal.data(1,1,i); 
end


%% Plotten aller Messungen in verschiedenen Farben
figure;
hold on;
plot(M1, 'DisplayName', 'Messung 1');
plot(M2, 'DisplayName', 'Messung 2');
plot(M3, 'DisplayName', 'Messung 3');
plot(M4, 'DisplayName', 'Messung 4');
plot(M5, 'DisplayName', 'Messung 5');
xlim([0 n-100]);
ylim([8 12]);
hold off;
legend('show');
xlabel('Zeit in s');
ylabel('Abstand in cm')
grid on;
title('Test der Widerholgenauigkeit der Messung');

%% Mittelwerte berechnen
% Alle Messwerte in eine Matrix
AlleMessungen = [M1, M2, M3, M4, M5];
n = length(AlleMessungen);

%% Messunsicherheiten und Auswertung
% Bester Schätzwert des Widerstandes berechnen
R = mean(AlleMessungen(:));  % Mittelwert der Messwerte

% Empirische Standardabweichung bestimmen
s = std(AlleMessungen(:));

% Standardunsicherheit Typ A bestimmen
p = 0.95;  % Vertrauensniveau (95%)
nu = n - 1; % Freiheitsgrade
t = tinv((1 + p) / 2, nu); % t-Quantil
uA = s * t / sqrt(n);

% Standardunsicherheit Typ B bestimmen (angenommen)
a = 0.6;      % Grundfehler in mm
b = 0.4;      % Fehler pro Meter
L = 1;        % Länge des Zollstocks in Meter
uB = (a + b * L) / sqrt(3);

% Kombinierte Standardunsicherheit Typ C bestimmen
uC = sqrt(uA^2 + uB^2);

% Grad des Vertrauens bestimmen
k = 2;  % Vertrauensfaktor

% Absolute Messunsicherheit bestimmen
uAbs = k * uC;

% Relative Messunsicherheit berechnen (%)
uRel = (uAbs / R) * 100;

%% Ergebnisdarstellung Typ C
figure;
yline(R, 'Color', 'k', 'DisplayName', 'Mittelwert');
yline(10, 'Color', 'g', 'DisplayName', 'Referenzwert Zollstock (10cm)');
xlim([0 n]);
grid on;
hold on;
plot([0 n], [R + uC R + uC], '--b', [0 n], [R - uC R - uC], '--b', 'DisplayName', 'Unsicherheit Typ C');
plot(1:n, AlleMessungen, '.-', 'DisplayName', 'Messwerte');  % Mittelwerte plotten
xlabel('Anzahl der Messpunkte');
ylabel('Abstand in cm');
xlim([0 n-100]);
ylim([9 11.5]);
title(['Messergebnis der Abstandssensorik (Mittelwert = ', num2str(R), 'cm, Unsicherheit = \pm', num2str(uC), 'cm, ', num2str(uRel), '%)']);
grid on;
legend;



