// Pin für den Buzzer
const int buzzerPin = 12;

// Notenfrequenzen (in Hertz)
const int NOTE_B3 = 254;
const int NOTE_FS3 = 185;
const int NOTE_F4 = 349;
const int NOTE_E4 = 330;
const int NOTE_D4 = 294;
const int NOTE_C4 = 262;

// Noten und Dauer
int melody[] = { 
  NOTE_F4, NOTE_F4, NOTE_F4, NOTE_C4, NOTE_C4, NOTE_B3, NOTE_FS3
};

int noteDurations[] = { 
  0, 300, 300, 200, 200, 250, 0
};

void setup() {
  pinMode(buzzerPin, OUTPUT);
}

void loop() {
  // Abspielen der Melodie
  for (int i = 0; i < sizeof(melody) / sizeof(melody[0]); i++) {
    int frequency = melody[i];
    int duration = noteDurations[i];
    playTone(frequency, duration);
    delay(duration * 0.3); // Kurze Pause zwischen den Noten
  }

  while (1); // Endlosschleife, damit der Song nur einmal abgespielt wird
}

// Funktion zum Erzeugen eines Tons
void playTone(int frequency, int duration) {
  int period = 1000000 / frequency; // Dauer eines Schwingungszyklus in Mikrosekunden
  int cycles = (duration * 1000L) / period; // Anzahl der Schwingungszyklen für die Dauer

  for (int i = 0; i < cycles; i++) {
    digitalWrite(buzzerPin, HIGH);
    delayMicroseconds(period / 2);
    digitalWrite(buzzerPin, LOW);
    delayMicroseconds(period / 2);
  }
}
