% Stellt die Konstanten für die Simulation bereit bereit
%
% Syntax:
% %% Simulations Komponente
% % Konstantenname
% % Einheit
% Name = Wert;
%
% Beschreibung:
% Es werden alle benötigten Konstanten für die Simulation
% bereitgestellt.
%
% Eingangswerte:
% Keine
%
% Ausgabewerte:
% Konstante = Wert;
%
% Beispiel:
% XXXXXXXX
%
% ***********************************************************\
%
% Modul : Paramter.m
%
% Datum : 22. Mai 2020
%
% Implementierung : MATLAB R2020a
%
% Toolbox : Keine
%
% Autor : Arndt, Lukas / Puls, Timo
%
% Bemerkung : Code-Review noch ausstehend
%
% Letzte Anderung : 09.06.2020
%
%************************************************************/
%% Manöverauswahl

% % Auswahloption Fahrmanöver
% % Integer
% %  1 = konstanter Lenkwinkelsprung
% %  2 = Slalomfahrt
% %  3 = Lenkimpuls 
% %  4 = Lenkwinkelsteigerung
% %  5 = Kurvenfahrt links
% %  6 = Kurvenfahrt rechts

Delta_In = input('Bitte wählen Sie einen Lenkwinkelverlauf aus (1-6): ')
if Delta_In >6
    error('Manöver unbekannt')
end
% % Festlegung der Fahrgeschwindigkeit
% % in [km/h]
V_In = input('Bitte geben Sie eine Geschwindigkeit in km/h ein: ')
% % Festlegung des Fahrerlenkwinkels für die Simulation
% % in [°]
x = input('Bitte geben Sie den Lenwinkelwert in Grad ein: ')

%% Kurve
% % Zeit für Kurve
% % in [s]
t = [0 0.5 1 1.5 2 2.5 3 3.5 4 4.5 5 ];
% % Multiplikator für Kurvenwinkel
% % in [ ]
Kurve_Rechts = [0 0.2 0.4 0.6 0.8 1 0.8 0.6 0.4 0.2 0];
Kurve_Links = [0 -0.2 -0.4 -0.6 -0.8 -1 -0.8 -0.6 -0.4 -0.2 -0];

%% Lenkübersetzung

% Übersetzungsverhältnis 
% in [   ]
LU_ueber = 1;

% Lenkwinkel hinterachse
% in [°]
K_delta_h = 0;

% Lenkwinkel maximum vorderachse
% in [°]
K_delta_v_max = 20;


%% Karosserie

% Masse des Fahrzeugs 
% in [kg]
m = 1978;

% Massentraegheitsmoment des Fahrzeugs
% in[kg/m^2]
Jzz = 3255.86;

% Radstand des Fahrzeugs
% in [m]
l = 2.8;

% Abstand Vorderachse zum Fahrzeugschwerpunkt
% in [m]
lv = 1.45;

% ABstand Hinterachse zum Fahrzeugschwerpunkt
% in [m]
lh = l -lv;

%% Achsen

% Achsseitensteifigkeit vorne 
% in [N/rad]
Cv = 1.2E5;

% Achsseitensteifigkeit hinten 
% in [N/rad]
Ch = 2.5E5;

%% Simulation des Einspurmodells

% Load Simulink model into memory
load_system('Entwicklung_GruppeH_2019a_V9');
% Simulate dynamic system
SimDaten = sim('Entwicklung_GruppeH_2019a_V9');

%% Darstellung der Ergebnisse

f = figure;
set(f, 'Units', 'normalized', 'Position', [0.2, 0.1, 0.7, 0.7]); 
subplot(6,1,1)
plot(SimDaten.AQuer.time, SimDaten.AQuer.Data);
title('GD AQuerY K');
ylabel('[m/s^2]');
xlabel('[s]');

subplot(6,1,2)
plot(SimDaten.Gierrate.time, SimDaten.Gierrate.Data);
title('GD Gierrate K');
ylabel('[m/s]');
xlabel('[s]');

subplot(6,1,3)
plot(SimDaten.beta.time, SimDaten.beta.Data);
title('SWB beta K');
ylabel('[°]');
xlabel('[s]');

subplot(6,1,4)
plot(SimDaten.ALaengs.time, SimDaten.ALaengs.Data);
title('GD ALängsX K');
ylabel('[m/s^2]');
xlabel('[s]');

subplot(6,1,5)
plot(SimDaten.RadKraftXC.time, SimDaten.RadKraftXC.Data);
title('RadKraftXC');
ylabel('[N]');
xlabel('[s]');

subplot(6,1,6)
plot(SimDaten.RadKraftYC.time, SimDaten.RadKraftYC.Data);
title('RadKraftYC');
ylabel('[N]');
xlabel('[s]');