import unittest
import numpy as np
import cv2
import mediapipe as mp
from mediapipe.framework.formats import landmark_pb2
from GraphicalUserInterface import user_skeleton_visualisation

class TestUserSkeletonVisualisation(unittest.TestCase):

    def setUp(self):
        # Create a blank image
        self.image = np.zeros((480, 640, 3), dtype=np.uint8)
        self.landmarks = landmark_pb2.NormalizedLandmarkList()
        for i in range(33):  # Assuming 33 landmarks for the pose
            landmark = self.landmarks.landmark.add()
            landmark.x = np.random.rand()
            landmark.y = np.random.rand()
            landmark.z = np.random.rand()

    def test_user_skeleton_visualisation_with_valid_input(self):
        # Test with valid image and landmarks
        output_image = user_skeleton_visualisation(self.image, self.landmarks)
        self.assertIsNotNone(output_image)
        self.assertEqual(output_image.shape, self.image.shape)

    def test_user_skeleton_visualisation_with_none_image(self):
        # Test with None image
        output_image = user_skeleton_visualisation(None, self.landmarks)
        self.assertIsNone(output_image)

    def test_user_skeleton_visualisation_with_empty_image(self):
        # Test with empty image
        empty_image = np.array([])
        output_image = user_skeleton_visualisation(empty_image, self.landmarks)
        self.assertTrue((output_image == empty_image).all())

    def test_user_skeleton_visualisation_with_none_landmarks(self):
        # Test with None landmarks
        output_image = user_skeleton_visualisation(self.image, None)
        self.assertTrue((output_image == self.image).all())

if __name__ == '__main__':
    unittest.main()