clear all; 
close all; 
clc

% CSV-Datei laden
% Die Daten aus der Datei "Messdaten.csv" werden in eine Tabelle geladen
% und die jeweiligen Spalten werden extrahiert.
dataTable = readtable('Messdaten.csv');

% Zugriff auf Spaltendaten (nach Spaltenname)
Timestamp = dataTable.Timestamp; % Zeitstempel aus der Tabelle
% Zeit in Sekunden umwandeln, beginnend bei t=0
zeit = (Timestamp - Timestamp(1)); 

Zentral_Bild_x = dataTable.Zentral_Bild_x; % Zentral_Bild_x Spalte
Zentral_x = dataTable.Zentral_x; % Zentral_x Spalte

% Daten visualisieren
figure;
% Erstellung eines Subplots: 2 Zeilen, 1 Spalte - erster Plot
subplot(2, 1, 1); 
hold on;
% Sollgröße (rote Linie) plotten
P1 = plot(zeit, Zentral_x, 'r', 'LineWidth', 2); 
% Istgröße (blaue Linie) plotten
P2 = plot(zeit, Zentral_Bild_x, 'b', 'LineWidth', 1.5); 

% Legende hinzufügen
legend([P1, P2], {'Istgröße', 'Sollgröße'}, 'FontSize', 12, 'Location', 'best');
% Achsenbeschriftungen und Titel hinzufügen
xlabel('Zeit in s', 'FontSize', 14);
ylabel('x Koordinate in m', 'FontSize', 14);
title('Analyse für Effekt-Regler', 'FontSize', 16);

% Raster aktivieren
grid on;

% Achsenbereich festlegen
xlim([0 12]); % x-Achse: von 0 bis 12 Sekunden
ylim([0 500]); % y-Achse: von 0 bis 500 Meter

% Achsenticks und Beschriftungsschriftgröße anpassen
set(gca, 'FontSize', 12); 

% Einfache Übertragung eines Systems definieren: G(s) = K / (T*s + 1)
K = 320; % Systemverstärkung
T = 0.6; % Zeitkonstante

% Zähler und Nenner des Übertragungsfunktionpolynoms
numerator = [K]; % Zähler
nenner = [T, 1]; % Nenner

% Nullstellen- und Polstellen-Diagramm plotten
subplot(2, 1, 2); 
pzmap(tf(numerator, nenner)); % Übertragungsfunktion visualisieren

% Titel und Achsenbeschriftungen für das Diagramm hinzufügen
title('Nullstellen- und Polstellen-Diagramm', 'FontSize', 16);
xlabel('Re', 'FontSize', 14); % Reelle Achse
ylabel('Im', 'FontSize', 14); % Imaginäre Achse

% Raster aktivieren
grid on;
