import unittest
from io import StringIO
from  BodyPoseEstimation import angleToLetter
# Dieser Komponententest bezieht sich auf Anforderung: 1.4 
#      ->  Das System muss die Winkel in Buchstaben einteilen.
#
#
# Getestet wird ob: 
#   1. Gültige Winkelkombinationen: Testet bekannte gültige Eingaben und überprüft die korrekten Rückgaben.
#   2. Toleranzbereich: Testet, ob die Funktion Winkel korrekt zuordnet, wenn sie sich innerhalb der definierten Toleranz befinden.
#   3. Winkel außerhalb der Toleranz: Testet, ob keine Zuordnung erfolgt, wenn die Winkel außerhalb der Toleranz liegen.
#   4. `None`-Eingaben: Testet, ob `None`-Eingaben ordnungsgemäß behandelt werden.
#   5. Ungültige Winkel: Testet die Funktion auf Eingaben, die außerhalb des zulässigen Bereichs liegen.
'''
..F..
======================================================================
FAIL: test_outside_tolerance (__main__.TestAngleToLetter.test_outside_tolerance)
Testet, ob Winkel außerhalb der Toleranz korrekt nicht zugeordnet werden.
----------------------------------------------------------------------'''

class TestAngleToLetter(unittest.TestCase):

    def test_valid_angles(self):
        """Testet gültige Winkelkombinationen."""
        self.assertEqual(angleToLetter(0, 45), "A")
        self.assertEqual(angleToLetter(0, 90), "B")
        self.assertEqual(angleToLetter(0, 135), "C")
        self.assertEqual(angleToLetter(0, 180), "D")
        self.assertEqual(angleToLetter(150, 0), "E")
        self.assertEqual(angleToLetter(90, 0), "F")
        self.assertEqual(angleToLetter(45, 0), "G")
        self.assertEqual(angleToLetter(340, 90), "H")
        self.assertEqual(angleToLetter(340, 135), "I")
        self.assertEqual(angleToLetter(90, 180), "J")
        self.assertEqual(angleToLetter(180, 45), "K")
        self.assertEqual(angleToLetter(130, 45), "L")
        self.assertEqual(angleToLetter(90, 45), "M")
        self.assertEqual(angleToLetter(45, 45), "N")
        self.assertEqual(angleToLetter(225, 90), "O")
        self.assertEqual(angleToLetter(180, 90), "P")
        self.assertEqual(angleToLetter(135, 90), "Q")
        self.assertEqual(angleToLetter(90, 90), "R")
        self.assertEqual(angleToLetter(45, 90), "S")
        self.assertEqual(angleToLetter(180, 135), "T")
        self.assertEqual(angleToLetter(135, 135), "U")
        self.assertEqual(angleToLetter(45, 180), "V")
        self.assertEqual(angleToLetter(90, 225), "W")
        self.assertEqual(angleToLetter(45, 225), "X")
        self.assertEqual(angleToLetter(90, 135), "Y")
        self.assertEqual(angleToLetter(45, 270), "Z")
        self.assertEqual(angleToLetter(45, 135), "CANCEL")
        self.assertEqual(angleToLetter(0, 0), "RUHESTELLUNG")

    def test_tolerance(self):
        """Testet, ob Winkel innerhalb der Toleranz korrekt zugeordnet werden."""
        self.assertEqual(angleToLetter(5, 50), "A")  # Innerhalb der Toleranz
        self.assertEqual(angleToLetter(50, 140), "CANCEL")  # Innerhalb der Toleranz

    def test_outside_tolerance(self):
        """Testet, ob Winkel außerhalb der Toleranz korrekt nicht zugeordnet werden."""
        self.assertIsNone(angleToLetter(10, 70))  # Außerhalb der Toleranz
        self.assertIsNone(angleToLetter(100, 140))  # Außerhalb der Toleranz

    def test_none_inputs(self):
        """Testet, ob None-Werte korrekt behandelt werden."""
        self.assertIsNone(angleToLetter(None, 0))
        self.assertIsNone(angleToLetter(0, None))
        self.assertIsNone(angleToLetter(None, None))

    def test_invalid_angles(self):
        """Testet, ob ungültige Winkel (außerhalb der erwarteten Bereiche) korrekt behandelt werden."""
        self.assertIsNone(angleToLetter(-10, 0))  # Negativer Winkel
        self.assertIsNone(angleToLetter(0, 400))  # Winkel größer als 360

if __name__ == "__main__":
    # Erstellen eines textbasierten Berichts
    report_output = StringIO()
    runner = unittest.TextTestRunner(stream=report_output, verbosity=2)
    test_suite = unittest.TestLoader().loadTestsFromTestCase(TestAngleToLetter)
    runner.run(test_suite)

    # Speichern des Berichts in einer Datei
    with open("TestReport.txt", "w") as report_file:
        report_file.write(report_output.getvalue())

    print("Der Testbericht wurde in 'TestReport.txt' gespeichert.")