##########################################################
#################### Show help on LCD ####################
##########################################################
def zeige_pfeil_auf_lcd(lcd_instance, angle_left, angle_right):
    # Unicode arrows in 45° increments
    arrows_counter_clockwise = ["↓", "↙", "←", "↖", "↑", "↗", "→", "↘"]
    arrows_clockwise = ["↓", "↘", "→", "↗", "↑", "↖", "←", "↙"]

    def angle_to_index(angle):
        """Calculates the index in the arrow array based on the angle with tolerance."""
        # Normalize the angle to 0-360°
        angle = angle % 360

        # Tolerance of ±20°
        tolerance = 20

        # Central angles for each section
        central_angles = [0, 45, 90, 135, 180, 225, 270, 315]

        # Find the matching range within tolerance
        for index, central in enumerate(central_angles):
            if central - tolerance <= angle <= central + tolerance:
                return index

        # Default value if no range matches (should not occur)
        return 0
