%% Funktion zur Erstellung der Variablen aus der Realtime-Schnittstelle
% Praktikum Produktionstechnik
% WS 2021/2022
% Gruppe: Haris Adrovic, Maik Spinnrath, Franziska Troja
% Datum: 02.12.2021
% Letzte Änderung: 02.12.2021

function realtime = struktur_realtime(Robot_IP, Port_NR)
    daten_realtime = realtime_schnittstelle(Robot_IP, Port_NR);
    A = daten_realtime;      %fuer Uebersichtlichkeit Daten der Realtime-Schnittstelle kuerzer abgespeichert
    
    % Struktur fuer Gelenkwinkel
    winkel_g(6)= zeros;
    %Gelenkwinkel in Radiant
    winkel_g(1)= typecast(uint8 ([ A(260), A(259), A(258) ,A(257), A(256), A(255), A(254), A(253)]),'double');
    winkel_g(2)= typecast(uint8 ([ A(268), A(267), A(266) ,A(265), A(264), A(263), A(262), A(261)]),'double');
    winkel_g(3)= typecast(uint8 ([ A(276), A(275), A(274) ,A(273), A(272), A(271), A(270), A(269)]),'double');
    winkel_g(4)= typecast(uint8 ([ A(284), A(283), A(282) ,A(281), A(280), A(279), A(278), A(277)]),'double');
    winkel_g(5)= typecast(uint8 ([ A(292), A(291), A(290) ,A(289), A(288), A(287), A(286), A(285)]),'double');
    winkel_g(6)= typecast(uint8 ([ A(300), A(299), A(298) ,A(297), A(296), A(295), A(294), A(293)]),'double');    
    
    % Struktur fuer Geschwindigkeiten der Gelenke
    v_g(6)= zeros;    
    v_g(1)= typecast(uint8 ([ A(308), A(307), A(306) ,A(305), A(304), A(303), A(302), A(301)]),'double');
    v_g(2)= typecast(uint8 ([ A(316), A(315), A(314) ,A(313), A(312), A(311), A(310), A(309)]),'double');
    v_g(3)= typecast(uint8 ([ A(324), A(323), A(322) ,A(321), A(320), A(319), A(318), A(317)]),'double');
    v_g(4)= typecast(uint8 ([ A(332), A(331), A(330) ,A(329), A(328), A(327), A(326), A(325)]),'double');
    v_g(5)= typecast(uint8 ([ A(340), A(339), A(338) ,A(337), A(336), A(335), A(334), A(333)]),'double');
    v_g(6)= typecast(uint8 ([ A(348), A(347), A(346) ,A(345), A(344), A(343), A(342), A(341)]),'double');
    
    %% Abspeicherung der Daten im Struct
    realtime.bogenmass = winkel_g;          % Info der Gelenkwinkel in Bogenmass
    realtime.gradmass = winkel_g * 180 /pi;    % Info der Gelenkwinkel in Grad
    realtime.v = v_g;                       % Info ueber Gelenkgeschwindigkeiten
end


