/*
 * Academic License - for use in teaching, academic research, and meeting
 * course requirements at degree granting institutions only.  Not for
 * government, commercial, or other organizational use.
 *
 * File: Schwungrad_Kickoff_Test.c
 *
 * Code generated for Simulink model 'Schwungrad_Kickoff_Test'.
 *
 * Model version                  : 1.4
 * Simulink Coder version         : 23.2 (R2023b) 01-Aug-2023
 * C/C++ source code generated on : Mon Jan 15 19:27:43 2024
 *
 * Target selection: ert.tlc
 * Embedded hardware selection: Atmel->AVR
 * Code generation objectives: Unspecified
 * Validation result: Not run
 */

#include "Schwungrad_Kickoff_Test.h"
#include "Schwungrad_Kickoff_Test_types.h"
#include "rtwtypes.h"
#include <string.h>
#include "Schwungrad_Kickoff_Test_private.h"
#include <math.h>
#include <stddef.h>

/* Block signals (default storage) */
B_Schwungrad_Kickoff_Test_T Schwungrad_Kickoff_Test_B;

/* Continuous states */
X_Schwungrad_Kickoff_Test_T Schwungrad_Kickoff_Test_X;

/* Disabled State Vector */
XDis_Schwungrad_Kickoff_Test_T Schwungrad_Kickoff_Test_XDis;

/* Block states (default storage) */
DW_Schwungrad_Kickoff_Test_T Schwungrad_Kickoff_Test_DW;

/* Real-time model */
static RT_MODEL_Schwungrad_Kickoff_T_T Schwungrad_Kickoff_Test_M_;
RT_MODEL_Schwungrad_Kickoff_T_T *const Schwungrad_Kickoff_Test_M =
  &Schwungrad_Kickoff_Test_M_;

/* Forward declaration for local functions */
static void Schwun_MedianFilterCG_resetImpl(c_dsp_internal_MedianFilterCG_T *obj);
static void S_MedianFilterCG_trickleDownMax(c_dsp_internal_MedianFilterCG_T *obj,
  real_T i);
static void S_MedianFilterCG_trickleDownMin(c_dsp_internal_MedianFilterCG_T *obj,
  real_T i);
static codertarget_arduinobase_inter_T *S_arduinoMPU6050_arduinoMPU6050
  (codertarget_arduinobase_inter_T *obj);
static void Schwungrad_Kic_SystemCore_setup(codertarget_arduinobase_inter_T *obj);

/*
 * This function updates continuous states using the ODE3 fixed-step
 * solver algorithm
 */
static void rt_ertODEUpdateContinuousStates(RTWSolverInfo *si )
{
  /* Solver Matrices */
  static const real_T rt_ODE3_A[3] = {
    1.0/2.0, 3.0/4.0, 1.0
  };

  static const real_T rt_ODE3_B[3][3] = {
    { 1.0/2.0, 0.0, 0.0 },

    { 0.0, 3.0/4.0, 0.0 },

    { 2.0/9.0, 1.0/3.0, 4.0/9.0 }
  };

  time_T t = rtsiGetT(si);
  time_T tnew = rtsiGetSolverStopTime(si);
  time_T h = rtsiGetStepSize(si);
  real_T *x = rtsiGetContStates(si);
  ODE3_IntgData *id = (ODE3_IntgData *)rtsiGetSolverData(si);
  real_T *y = id->y;
  real_T *f0 = id->f[0];
  real_T *f1 = id->f[1];
  real_T *f2 = id->f[2];
  real_T hB[3];
  int_T i;
  int_T nXc = 1;
  rtsiSetSimTimeStep(si,MINOR_TIME_STEP);

  /* Save the state values at time t in y, we'll use x as ynew. */
  (void) memcpy(y, x,
                (uint_T)nXc*sizeof(real_T));

  /* Assumes that rtsiSetT and ModelOutputs are up-to-date */
  /* f0 = f(t,y) */
  rtsiSetdX(si, f0);
  Schwungrad_Kickoff_Test_derivatives();

  /* f(:,2) = feval(odefile, t + hA(1), y + f*hB(:,1), args(:)(*)); */
  hB[0] = h * rt_ODE3_B[0][0];
  for (i = 0; i < nXc; i++) {
    x[i] = y[i] + (f0[i]*hB[0]);
  }

  rtsiSetT(si, t + h*rt_ODE3_A[0]);
  rtsiSetdX(si, f1);
  Schwungrad_Kickoff_Test_step();
  Schwungrad_Kickoff_Test_derivatives();

  /* f(:,3) = feval(odefile, t + hA(2), y + f*hB(:,2), args(:)(*)); */
  for (i = 0; i <= 1; i++) {
    hB[i] = h * rt_ODE3_B[1][i];
  }

  for (i = 0; i < nXc; i++) {
    x[i] = y[i] + (f0[i]*hB[0] + f1[i]*hB[1]);
  }

  rtsiSetT(si, t + h*rt_ODE3_A[1]);
  rtsiSetdX(si, f2);
  Schwungrad_Kickoff_Test_step();
  Schwungrad_Kickoff_Test_derivatives();

  /* tnew = t + hA(3);
     ynew = y + f*hB(:,3); */
  for (i = 0; i <= 2; i++) {
    hB[i] = h * rt_ODE3_B[2][i];
  }

  for (i = 0; i < nXc; i++) {
    x[i] = y[i] + (f0[i]*hB[0] + f1[i]*hB[1] + f2[i]*hB[2]);
  }

  rtsiSetT(si, tnew);
  rtsiSetSimTimeStep(si,MAJOR_TIME_STEP);
}

static void Schwun_MedianFilterCG_resetImpl(c_dsp_internal_MedianFilterCG_T *obj)
{
  real_T cnt1;
  real_T cnt2;
  int16_T i;
  for (i = 0; i < 5; i++) {
    obj->pBuf[i] = 0.0;
    obj->pPos[i] = 0.0;
    obj->pHeap[i] = 0.0;
  }

  /* Start for MATLABSystem: '<Root>/Median Filter' */
  obj->pWinLen = 5.0;
  obj->pIdx = obj->pWinLen;

  /* Start for MATLABSystem: '<Root>/Median Filter' */
  obj->pMidHeap = ceil((obj->pWinLen + 1.0) / 2.0);
  cnt1 = (obj->pWinLen - 1.0) / 2.0;

  /* Start for MATLABSystem: '<Root>/Median Filter' */
  if (cnt1 < 0.0) {
    obj->pMinHeapLength = ceil(cnt1);
  } else {
    obj->pMinHeapLength = floor(cnt1);
  }

  cnt1 = obj->pWinLen / 2.0;

  /* Start for MATLABSystem: '<Root>/Median Filter' */
  if (cnt1 < 0.0) {
    obj->pMaxHeapLength = ceil(cnt1);
  } else {
    obj->pMaxHeapLength = floor(cnt1);
  }

  cnt1 = 1.0;
  cnt2 = obj->pWinLen;
  for (i = 0; i < 5; i++) {
    /* Start for MATLABSystem: '<Root>/Median Filter' */
    if (fmod(5.0 - (real_T)i, 2.0) == 0.0) {
      obj->pPos[4 - i] = cnt1;
      cnt1++;
    } else {
      obj->pPos[4 - i] = cnt2;
      cnt2--;
    }

    obj->pHeap[(int16_T)obj->pPos[4 - i] - 1] = 5.0 - (real_T)i;
  }
}

static void S_MedianFilterCG_trickleDownMax(c_dsp_internal_MedianFilterCG_T *obj,
  real_T i)
{
  real_T ind2;
  real_T tmp;
  real_T u_tmp;
  boolean_T exitg1;
  exitg1 = false;
  while ((!exitg1) && (i >= -obj->pMaxHeapLength)) {
    if ((i < -1.0) && (i > -obj->pMaxHeapLength) && (obj->pBuf[(int16_T)
         obj->pHeap[(int16_T)(i + obj->pMidHeap) - 1] - 1] < obj->pBuf[(int16_T)
         obj->pHeap[(int16_T)((i - 1.0) + obj->pMidHeap) - 1] - 1])) {
      i--;
    }

    u_tmp = i / 2.0;
    if (u_tmp < 0.0) {
      Schwungrad_Kickoff_Test_B.temp_c = ceil(u_tmp);
    } else {
      Schwungrad_Kickoff_Test_B.temp_c = floor(u_tmp);
    }

    ind2 = i + obj->pMidHeap;
    tmp = obj->pHeap[(int16_T)ind2 - 1];
    if (!(obj->pBuf[(int16_T)obj->pHeap[(int16_T)
          (Schwungrad_Kickoff_Test_B.temp_c + obj->pMidHeap) - 1] - 1] <
          obj->pBuf[(int16_T)tmp - 1])) {
      exitg1 = true;
    } else {
      if (u_tmp < 0.0) {
        Schwungrad_Kickoff_Test_B.temp_c = ceil(u_tmp);
      } else {
        Schwungrad_Kickoff_Test_B.temp_c = floor(u_tmp);
      }

      u_tmp = Schwungrad_Kickoff_Test_B.temp_c + obj->pMidHeap;
      Schwungrad_Kickoff_Test_B.temp_c = obj->pHeap[(int16_T)u_tmp - 1];
      obj->pHeap[(int16_T)u_tmp - 1] = tmp;
      obj->pHeap[(int16_T)ind2 - 1] = Schwungrad_Kickoff_Test_B.temp_c;
      obj->pPos[(int16_T)obj->pHeap[(int16_T)u_tmp - 1] - 1] = u_tmp;
      obj->pPos[(int16_T)obj->pHeap[(int16_T)ind2 - 1] - 1] = ind2;
      i *= 2.0;
    }
  }
}

static void S_MedianFilterCG_trickleDownMin(c_dsp_internal_MedianFilterCG_T *obj,
  real_T i)
{
  real_T ind1;
  real_T tmp;
  real_T u_tmp;
  boolean_T exitg1;
  exitg1 = false;
  while ((!exitg1) && (i <= obj->pMinHeapLength)) {
    if ((i > 1.0) && (i < obj->pMinHeapLength) && (obj->pBuf[(int16_T)obj->
         pHeap[(int16_T)((i + 1.0) + obj->pMidHeap) - 1] - 1] < obj->pBuf
         [(int16_T)obj->pHeap[(int16_T)(i + obj->pMidHeap) - 1] - 1])) {
      i++;
    }

    u_tmp = i / 2.0;
    if (u_tmp < 0.0) {
      Schwungrad_Kickoff_Test_B.d = ceil(u_tmp);
    } else {
      Schwungrad_Kickoff_Test_B.d = floor(u_tmp);
    }

    ind1 = i + obj->pMidHeap;
    tmp = obj->pHeap[(int16_T)ind1 - 1];
    if (!(obj->pBuf[(int16_T)tmp - 1] < obj->pBuf[(int16_T)obj->pHeap[(int16_T)
          (Schwungrad_Kickoff_Test_B.d + obj->pMidHeap) - 1] - 1])) {
      exitg1 = true;
    } else {
      if (u_tmp < 0.0) {
        Schwungrad_Kickoff_Test_B.d = ceil(u_tmp);
      } else {
        Schwungrad_Kickoff_Test_B.d = floor(u_tmp);
      }

      u_tmp = Schwungrad_Kickoff_Test_B.d + obj->pMidHeap;
      obj->pHeap[(int16_T)ind1 - 1] = obj->pHeap[(int16_T)u_tmp - 1];
      obj->pHeap[(int16_T)u_tmp - 1] = tmp;
      obj->pPos[(int16_T)obj->pHeap[(int16_T)ind1 - 1] - 1] = ind1;
      obj->pPos[(int16_T)obj->pHeap[(int16_T)u_tmp - 1] - 1] = u_tmp;
      i *= 2.0;
    }
  }
}

real_T rt_roundd_snf(real_T u)
{
  real_T y;
  if (fabs(u) < 4.503599627370496E+15) {
    if (u >= 0.5) {
      y = floor(u + 0.5);
    } else if (u > -0.5) {
      y = u * 0.0;
    } else {
      y = ceil(u - 0.5);
    }
  } else {
    y = u;
  }

  return y;
}

static codertarget_arduinobase_inter_T *S_arduinoMPU6050_arduinoMPU6050
  (codertarget_arduinobase_inter_T *obj)
{
  codertarget_arduinobase_inter_T *b_obj;

  /* Start for MATLABSystem: '<S3>/Base sensor block' */
  obj->I2CReadWriteError = 0U;
  obj->InitError = false;
  obj->isInitialized = 0L;
  obj->SampleTime = -1.0;
  obj->IsFirstStep = false;
  b_obj = obj;
  obj->i2cObjmpu.DefaultMaximumBusSpeedInHz = 400000.0;
  obj->i2cObjmpu.isInitialized = 0L;
  obj->i2cObjmpu.I2CDriverObj.MW_I2C_HANDLE = NULL;
  obj->i2cObjmpu.matlabCodegenIsDeleted = false;
  obj->matlabCodegenIsDeleted = false;
  return b_obj;
}

static void Schwungrad_Kic_SystemCore_setup(codertarget_arduinobase_inter_T *obj)
{
  MW_I2C_Mode_Type modename;
  uint32_T i2cname;
  uint8_T SwappedDataBytes[2];
  uint8_T b_SwappedDataBytes[2];
  uint8_T CastedData;
  uint8_T SwappedDataBytes_0;
  uint8_T status;
  obj->isInitialized = 1L;

  /* Start for MATLABSystem: '<S3>/Base sensor block' */
  obj->InitializationFlag = true;
  modename = MW_I2C_MASTER;
  i2cname = 0;

  /* Start for MATLABSystem: '<S3>/Base sensor block' */
  obj->i2cObjmpu.I2CDriverObj.MW_I2C_HANDLE = MW_I2C_Open(i2cname, modename);
  obj->i2cObjmpu.BusSpeed = 100000UL;
  MW_I2C_SetBusSpeed(obj->i2cObjmpu.I2CDriverObj.MW_I2C_HANDLE,
                     obj->i2cObjmpu.BusSpeed);
  CastedData = 128U;
  memcpy((void *)&b_SwappedDataBytes[1], (void *)&CastedData, (size_t)1 * sizeof
         (uint8_T));
  b_SwappedDataBytes[0] = 107U;

  /* Start for MATLABSystem: '<S3>/Base sensor block' */
  memcpy((void *)&SwappedDataBytes[0], (void *)&b_SwappedDataBytes[0], (size_t)2
         * sizeof(uint8_T));
  status = MW_I2C_MasterWrite(obj->i2cObjmpu.I2CDriverObj.MW_I2C_HANDLE, 104UL,
    &SwappedDataBytes[0], 2UL, false, false);
  if (status != 0) {
    if (obj->InitializationFlag) {
      obj->InitError = true;
    } else if (obj->I2CReadWriteError == 0) {
      obj->I2CReadWriteError = status;
    }
  }

  MW_delay_in_milliseconds(1UL);
  CastedData = 0U;
  memcpy((void *)&b_SwappedDataBytes[1], (void *)&CastedData, (size_t)1 * sizeof
         (uint8_T));
  b_SwappedDataBytes[0] = 107U;

  /* Start for MATLABSystem: '<S3>/Base sensor block' */
  memcpy((void *)&SwappedDataBytes[0], (void *)&b_SwappedDataBytes[0], (size_t)2
         * sizeof(uint8_T));
  status = MW_I2C_MasterWrite(obj->i2cObjmpu.I2CDriverObj.MW_I2C_HANDLE, 104UL,
    &SwappedDataBytes[0], 2UL, false, false);
  if (status != 0) {
    if (obj->InitializationFlag) {
      obj->InitError = true;
    } else if (obj->I2CReadWriteError == 0) {
      obj->I2CReadWriteError = status;
    }
  }

  MW_delay_in_milliseconds(100UL);
  status = 117U;

  /* Start for MATLABSystem: '<S3>/Base sensor block' */
  memcpy((void *)&SwappedDataBytes_0, (void *)&status, (size_t)1 * sizeof
         (uint8_T));
  status = MW_I2C_MasterWrite(obj->i2cObjmpu.I2CDriverObj.MW_I2C_HANDLE, 104UL,
    &SwappedDataBytes_0, 1UL, true, false);
  if (status == 0) {
    MW_I2C_MasterRead(obj->i2cObjmpu.I2CDriverObj.MW_I2C_HANDLE, 104UL,
                      &SwappedDataBytes_0, 1UL, false, true);
    memcpy((void *)&CastedData, (void *)&SwappedDataBytes_0, (size_t)1 * sizeof
           (uint8_T));
  } else {
    CastedData = 0U;
  }

  if (status != 0) {
    if (obj->InitializationFlag) {
      obj->InitError = true;
    } else if (obj->I2CReadWriteError == 0) {
      obj->I2CReadWriteError = status;
    }
  }

  obj->MPUConnect = (CastedData == 104);
  if (obj->MPUConnect) {
    CastedData = 0U;
    memcpy((void *)&b_SwappedDataBytes[1], (void *)&CastedData, (size_t)1 *
           sizeof(uint8_T));
    b_SwappedDataBytes[0] = 25U;
    memcpy((void *)&SwappedDataBytes[0], (void *)&b_SwappedDataBytes[0], (size_t)
           2 * sizeof(uint8_T));
    status = MW_I2C_MasterWrite(obj->i2cObjmpu.I2CDriverObj.MW_I2C_HANDLE, 104UL,
      &SwappedDataBytes[0], 2UL, false, false);
    if (status != 0) {
      if (obj->InitializationFlag) {
        obj->InitError = true;
      } else if (obj->I2CReadWriteError == 0) {
        obj->I2CReadWriteError = status;
      }
    }

    status = 28U;
    memcpy((void *)&SwappedDataBytes_0, (void *)&status, (size_t)1 * sizeof
           (uint8_T));
    status = MW_I2C_MasterWrite(obj->i2cObjmpu.I2CDriverObj.MW_I2C_HANDLE, 104UL,
      &SwappedDataBytes_0, 1UL, true, false);
    if (status == 0) {
      MW_I2C_MasterRead(obj->i2cObjmpu.I2CDriverObj.MW_I2C_HANDLE, 104UL,
                        &SwappedDataBytes_0, 1UL, false, true);
      memcpy((void *)&CastedData, (void *)&SwappedDataBytes_0, (size_t)1 *
             sizeof(uint8_T));
    } else {
      CastedData = 0U;
    }

    if (status != 0) {
      if (obj->InitializationFlag) {
        obj->InitError = true;
      } else if (obj->I2CReadWriteError == 0) {
        obj->I2CReadWriteError = status;
      }
    }

    CastedData = (uint8_T)(CastedData & 231);
    memcpy((void *)&b_SwappedDataBytes[1], (void *)&CastedData, (size_t)1 *
           sizeof(uint8_T));
    b_SwappedDataBytes[0] = 28U;
    memcpy((void *)&SwappedDataBytes[0], (void *)&b_SwappedDataBytes[0], (size_t)
           2 * sizeof(uint8_T));
    status = MW_I2C_MasterWrite(obj->i2cObjmpu.I2CDriverObj.MW_I2C_HANDLE, 104UL,
      &SwappedDataBytes[0], 2UL, false, false);
    if (status != 0) {
      if (obj->InitializationFlag) {
        obj->InitError = true;
      } else if (obj->I2CReadWriteError == 0) {
        obj->I2CReadWriteError = status;
      }
    }

    status = 27U;
    memcpy((void *)&SwappedDataBytes_0, (void *)&status, (size_t)1 * sizeof
           (uint8_T));
    status = MW_I2C_MasterWrite(obj->i2cObjmpu.I2CDriverObj.MW_I2C_HANDLE, 104UL,
      &SwappedDataBytes_0, 1UL, true, false);
    if (status == 0) {
      MW_I2C_MasterRead(obj->i2cObjmpu.I2CDriverObj.MW_I2C_HANDLE, 104UL,
                        &SwappedDataBytes_0, 1UL, false, true);
      memcpy((void *)&CastedData, (void *)&SwappedDataBytes_0, (size_t)1 *
             sizeof(uint8_T));
    } else {
      CastedData = 0U;
    }

    if (status != 0) {
      if (obj->InitializationFlag) {
        obj->InitError = true;
      } else if (obj->I2CReadWriteError == 0) {
        obj->I2CReadWriteError = status;
      }
    }

    CastedData = (uint8_T)((CastedData & 231) | 8);
    memcpy((void *)&b_SwappedDataBytes[1], (void *)&CastedData, (size_t)1 *
           sizeof(uint8_T));
    b_SwappedDataBytes[0] = 27U;
    memcpy((void *)&SwappedDataBytes[0], (void *)&b_SwappedDataBytes[0], (size_t)
           2 * sizeof(uint8_T));
    status = MW_I2C_MasterWrite(obj->i2cObjmpu.I2CDriverObj.MW_I2C_HANDLE, 104UL,
      &SwappedDataBytes[0], 2UL, false, false);
    if (status != 0) {
      if (obj->InitializationFlag) {
        obj->InitError = true;
      } else if (obj->I2CReadWriteError == 0) {
        obj->I2CReadWriteError = status;
      }
    }

    status = 26U;
    memcpy((void *)&SwappedDataBytes_0, (void *)&status, (size_t)1 * sizeof
           (uint8_T));
    status = MW_I2C_MasterWrite(obj->i2cObjmpu.I2CDriverObj.MW_I2C_HANDLE, 104UL,
      &SwappedDataBytes_0, 1UL, true, false);
    if (status == 0) {
      MW_I2C_MasterRead(obj->i2cObjmpu.I2CDriverObj.MW_I2C_HANDLE, 104UL,
                        &SwappedDataBytes_0, 1UL, false, true);
      memcpy((void *)&CastedData, (void *)&SwappedDataBytes_0, (size_t)1 *
             sizeof(uint8_T));
    } else {
      CastedData = 0U;
    }

    if (status != 0) {
      if (obj->InitializationFlag) {
        obj->InitError = true;
      } else if (obj->I2CReadWriteError == 0) {
        obj->I2CReadWriteError = status;
      }
    }

    CastedData = (uint8_T)(CastedData & 248);
    memcpy((void *)&b_SwappedDataBytes[1], (void *)&CastedData, (size_t)1 *
           sizeof(uint8_T));
    b_SwappedDataBytes[0] = 26U;
    memcpy((void *)&SwappedDataBytes[0], (void *)&b_SwappedDataBytes[0], (size_t)
           2 * sizeof(uint8_T));
    status = MW_I2C_MasterWrite(obj->i2cObjmpu.I2CDriverObj.MW_I2C_HANDLE, 104UL,
      &SwappedDataBytes[0], 2UL, false, false);
    if (status != 0) {
      if (obj->InitializationFlag) {
        obj->InitError = true;
      } else if (obj->I2CReadWriteError == 0) {
        obj->I2CReadWriteError = status;
      }
    }
  } else {
    obj->InitError = true;
  }

  obj->InitializationFlag = false;
  obj->isSetupComplete = true;
}

/* Model step function */
void Schwungrad_Kickoff_Test_step(void)
{
  c_dsp_internal_MedianFilterCG_T *obj;
  l_codertarget_arduinobase_int_T *obj_tmp;
  int16_T i;
  uint8_T b_RegisterValue[6];
  uint8_T output_raw[6];
  uint8_T SwappedDataBytes;
  uint8_T status;
  boolean_T exitg1;
  boolean_T flag;
  if (rtmIsMajorTimeStep(Schwungrad_Kickoff_Test_M)) {
    /* set solver stop time */
    rtsiSetSolverStopTime(&Schwungrad_Kickoff_Test_M->solverInfo,
                          ((Schwungrad_Kickoff_Test_M->Timing.clockTick0+1)*
      Schwungrad_Kickoff_Test_M->Timing.stepSize0));
  }                                    /* end MajorTimeStep */

  /* Update absolute time of base rate at minor time step */
  if (rtmIsMinorTimeStep(Schwungrad_Kickoff_Test_M)) {
    Schwungrad_Kickoff_Test_M->Timing.t[0] = rtsiGetT
      (&Schwungrad_Kickoff_Test_M->solverInfo);
  }

  /* Reset subsysRan breadcrumbs */
  srClearBC(Schwungrad_Kickoff_Test_DW.IfActionSubsystem_SubsysRanBC);

  /* Reset subsysRan breadcrumbs */
  srClearBC(Schwungrad_Kickoff_Test_DW.IfActionSubsystem1_SubsysRanBC);
  if (rtmIsMajorTimeStep(Schwungrad_Kickoff_Test_M)) {
    /* Outputs for Atomic SubSystem: '<Root>/MPU6050 IMU Sensor' */
    /* Start for Atomic SubSystem: '<Root>/MPU6050 IMU Sensor' */
    /* MATLABSystem: '<S3>/Base sensor block' */
    if (Schwungrad_Kickoff_Test_DW.obj_i.SampleTime !=
        Schwungrad_Kickoff_Test_P.MPU6050IMUSensor_SampleTime) {
      Schwungrad_Kickoff_Test_DW.obj_i.SampleTime =
        Schwungrad_Kickoff_Test_P.MPU6050IMUSensor_SampleTime;
    }

    /* End of Start for SubSystem: '<Root>/MPU6050 IMU Sensor' */
    if (!Schwungrad_Kickoff_Test_DW.obj_i.IsFirstStep) {
      MW_getCurrentTime_in_milliseconds();
      Schwungrad_Kickoff_Test_DW.obj_i.IsFirstStep = true;
    }

    Schwungrad_Kickoff_Test_DW.obj_i.I2CReadWriteError = 0U;
    obj_tmp = &Schwungrad_Kickoff_Test_DW.obj_i.i2cObjmpu;
    status = 59U;
    memcpy((void *)&SwappedDataBytes, (void *)&status, (size_t)1 * sizeof
           (uint8_T));
    status = MW_I2C_MasterWrite(obj_tmp->I2CDriverObj.MW_I2C_HANDLE, 104UL,
      &SwappedDataBytes, 1UL, true, false);
    if (status == 0) {
      MW_I2C_MasterRead(obj_tmp->I2CDriverObj.MW_I2C_HANDLE, 104UL, &output_raw
                        [0], 6UL, false, true);
      memcpy((void *)&b_RegisterValue[0], (void *)&output_raw[0], (size_t)6 *
             sizeof(uint8_T));
    } else {
      for (i = 0; i < 6; i++) {
        b_RegisterValue[i] = 0U;
      }
    }

    if (status != 0) {
      if (Schwungrad_Kickoff_Test_DW.obj_i.InitializationFlag) {
        Schwungrad_Kickoff_Test_DW.obj_i.InitError = true;
      } else if (Schwungrad_Kickoff_Test_DW.obj_i.I2CReadWriteError == 0) {
        Schwungrad_Kickoff_Test_DW.obj_i.I2CReadWriteError = status;
      }
    }

    Schwungrad_Kickoff_Test_B.Basesensorblock_o1[0] = b_RegisterValue[0] << 8 |
      b_RegisterValue[1];
    Schwungrad_Kickoff_Test_B.Basesensorblock_o1[1] = b_RegisterValue[2] << 8 |
      b_RegisterValue[3];
    Schwungrad_Kickoff_Test_B.Basesensorblock_o1[2] = b_RegisterValue[4] << 8 |
      b_RegisterValue[5];
    if (Schwungrad_Kickoff_Test_DW.obj_i.InitError) {
      /* MATLABSystem: '<S3>/Base sensor block' */
      Schwungrad_Kickoff_Test_B.Basesensorblock_o1[0] = 0.0;
      Schwungrad_Kickoff_Test_B.Basesensorblock_o1[1] = 0.0;
      Schwungrad_Kickoff_Test_B.Basesensorblock_o1[2] = 0.0;
    } else {
      /* MATLABSystem: '<S3>/Base sensor block' */
      Schwungrad_Kickoff_Test_B.Basesensorblock_o1[0] =
        Schwungrad_Kickoff_Test_B.Basesensorblock_o1[0] * 9.80665 / 16384.0;
      Schwungrad_Kickoff_Test_B.Basesensorblock_o1[1] =
        Schwungrad_Kickoff_Test_B.Basesensorblock_o1[1] * 9.80665 / 16384.0;
      Schwungrad_Kickoff_Test_B.Basesensorblock_o1[2] =
        Schwungrad_Kickoff_Test_B.Basesensorblock_o1[2] * 9.80665 / 16384.0;
    }

    status = 67U;
    memcpy((void *)&SwappedDataBytes, (void *)&status, (size_t)1 * sizeof
           (uint8_T));
    status = MW_I2C_MasterWrite(obj_tmp->I2CDriverObj.MW_I2C_HANDLE, 104UL,
      &SwappedDataBytes, 1UL, true, false);
    if (status == 0) {
      MW_I2C_MasterRead(obj_tmp->I2CDriverObj.MW_I2C_HANDLE, 104UL, &output_raw
                        [0], 6UL, false, true);
      memcpy((void *)&b_RegisterValue[0], (void *)&output_raw[0], (size_t)6 *
             sizeof(uint8_T));
    } else {
      for (i = 0; i < 6; i++) {
        b_RegisterValue[i] = 0U;
      }
    }

    if (status != 0) {
      if (Schwungrad_Kickoff_Test_DW.obj_i.InitializationFlag) {
        Schwungrad_Kickoff_Test_DW.obj_i.InitError = true;
      } else if (Schwungrad_Kickoff_Test_DW.obj_i.I2CReadWriteError == 0) {
        Schwungrad_Kickoff_Test_DW.obj_i.I2CReadWriteError = status;
      }
    }

    Schwungrad_Kickoff_Test_B.Basesensorblock_o2[0] = b_RegisterValue[0] << 8 |
      b_RegisterValue[1];
    Schwungrad_Kickoff_Test_B.Basesensorblock_o2[1] = b_RegisterValue[2] << 8 |
      b_RegisterValue[3];
    Schwungrad_Kickoff_Test_B.Basesensorblock_o2[2] = b_RegisterValue[4] << 8 |
      b_RegisterValue[5];
    if (Schwungrad_Kickoff_Test_DW.obj_i.InitError) {
      /* MATLABSystem: '<S3>/Base sensor block' */
      Schwungrad_Kickoff_Test_B.Basesensorblock_o2[0] = 0.0;
      Schwungrad_Kickoff_Test_B.Basesensorblock_o2[1] = 0.0;
      Schwungrad_Kickoff_Test_B.Basesensorblock_o2[2] = 0.0;
    } else {
      /* MATLABSystem: '<S3>/Base sensor block' */
      Schwungrad_Kickoff_Test_B.Basesensorblock_o2[0] *= 0.0152587890625;
      Schwungrad_Kickoff_Test_B.Basesensorblock_o2[1] *= 0.0152587890625;
      Schwungrad_Kickoff_Test_B.Basesensorblock_o2[2] *= 0.0152587890625;
    }

    /* End of MATLABSystem: '<S3>/Base sensor block' */
    /* End of Outputs for SubSystem: '<Root>/MPU6050 IMU Sensor' */
    /* Gain: '<Root>/Gain' */
    Schwungrad_Kickoff_Test_B.GyroMesswert_m =
      Schwungrad_Kickoff_Test_P.Gain_Gain *
      Schwungrad_Kickoff_Test_B.Basesensorblock_o1[1];

    /* MATLABSystem: '<Root>/Median Filter' */
    obj = &Schwungrad_Kickoff_Test_DW.obj.pMID;
    if (Schwungrad_Kickoff_Test_DW.obj.pMID.isInitialized != 1L) {
      Schwungrad_Kickoff_Test_DW.obj.pMID.isInitialized = 1L;
      Schwungrad_Kickoff_Test_DW.obj.pMID.isSetupComplete = true;
      Schwun_MedianFilterCG_resetImpl(&Schwungrad_Kickoff_Test_DW.obj.pMID);
    }

    i = (int16_T)Schwungrad_Kickoff_Test_DW.obj.pMID.pIdx - 1;
    Schwungrad_Kickoff_Test_B.vprev = Schwungrad_Kickoff_Test_DW.obj.pMID.pBuf[i];
    Schwungrad_Kickoff_Test_DW.obj.pMID.pBuf[i] =
      Schwungrad_Kickoff_Test_B.GyroMesswert_m;
    Schwungrad_Kickoff_Test_B.p = Schwungrad_Kickoff_Test_DW.obj.pMID.pPos
      [(int16_T)Schwungrad_Kickoff_Test_DW.obj.pMID.pIdx - 1];
    Schwungrad_Kickoff_Test_DW.obj.pMID.pIdx++;
    if (Schwungrad_Kickoff_Test_DW.obj.pMID.pWinLen + 1.0 ==
        Schwungrad_Kickoff_Test_DW.obj.pMID.pIdx) {
      Schwungrad_Kickoff_Test_DW.obj.pMID.pIdx = 1.0;
    }

    if (Schwungrad_Kickoff_Test_B.p >
        Schwungrad_Kickoff_Test_DW.obj.pMID.pMidHeap) {
      if (Schwungrad_Kickoff_Test_B.vprev <
          Schwungrad_Kickoff_Test_B.GyroMesswert_m) {
        S_MedianFilterCG_trickleDownMin(&Schwungrad_Kickoff_Test_DW.obj.pMID,
          (Schwungrad_Kickoff_Test_B.p -
           Schwungrad_Kickoff_Test_DW.obj.pMID.pMidHeap) * 2.0);
      } else {
        Schwungrad_Kickoff_Test_B.GyroMesswert_m = Schwungrad_Kickoff_Test_B.p -
          Schwungrad_Kickoff_Test_DW.obj.pMID.pMidHeap;
        exitg1 = false;
        while ((!exitg1) && (Schwungrad_Kickoff_Test_B.GyroMesswert_m > 0.0)) {
          Schwungrad_Kickoff_Test_B.vprev = floor
            (Schwungrad_Kickoff_Test_B.GyroMesswert_m / 2.0);
          flag = (obj->pBuf[(int16_T)obj->pHeap[(int16_T)
                  (Schwungrad_Kickoff_Test_B.GyroMesswert_m + obj->pMidHeap) - 1]
                  - 1] < obj->pBuf[(int16_T)obj->pHeap[(int16_T)
                  (Schwungrad_Kickoff_Test_B.vprev + obj->pMidHeap) - 1] - 1]);
          if (!flag) {
            exitg1 = true;
          } else {
            Schwungrad_Kickoff_Test_B.p =
              Schwungrad_Kickoff_Test_B.GyroMesswert_m + obj->pMidHeap;
            Schwungrad_Kickoff_Test_B.ind2 = Schwungrad_Kickoff_Test_B.vprev +
              obj->pMidHeap;
            Schwungrad_Kickoff_Test_B.temp = obj->pHeap[(int16_T)
              Schwungrad_Kickoff_Test_B.p - 1];
            obj->pHeap[(int16_T)Schwungrad_Kickoff_Test_B.p - 1] = obj->pHeap
              [(int16_T)Schwungrad_Kickoff_Test_B.ind2 - 1];
            obj->pHeap[(int16_T)Schwungrad_Kickoff_Test_B.ind2 - 1] =
              Schwungrad_Kickoff_Test_B.temp;
            obj->pPos[(int16_T)obj->pHeap[(int16_T)Schwungrad_Kickoff_Test_B.p -
              1] - 1] = Schwungrad_Kickoff_Test_B.p;
            obj->pPos[(int16_T)obj->pHeap[(int16_T)
              Schwungrad_Kickoff_Test_B.ind2 - 1] - 1] =
              Schwungrad_Kickoff_Test_B.ind2;
            Schwungrad_Kickoff_Test_B.GyroMesswert_m = floor
              (Schwungrad_Kickoff_Test_B.GyroMesswert_m / 2.0);
          }
        }

        if (Schwungrad_Kickoff_Test_B.GyroMesswert_m == 0.0) {
          S_MedianFilterCG_trickleDownMax(&Schwungrad_Kickoff_Test_DW.obj.pMID,
            -1.0);
        }
      }
    } else if (Schwungrad_Kickoff_Test_B.p <
               Schwungrad_Kickoff_Test_DW.obj.pMID.pMidHeap) {
      if (Schwungrad_Kickoff_Test_B.GyroMesswert_m <
          Schwungrad_Kickoff_Test_B.vprev) {
        S_MedianFilterCG_trickleDownMax(&Schwungrad_Kickoff_Test_DW.obj.pMID,
          (Schwungrad_Kickoff_Test_B.p -
           Schwungrad_Kickoff_Test_DW.obj.pMID.pMidHeap) * 2.0);
      } else {
        Schwungrad_Kickoff_Test_B.GyroMesswert_m = Schwungrad_Kickoff_Test_B.p -
          Schwungrad_Kickoff_Test_DW.obj.pMID.pMidHeap;
        exitg1 = false;
        while ((!exitg1) && (Schwungrad_Kickoff_Test_B.GyroMesswert_m < 0.0)) {
          Schwungrad_Kickoff_Test_B.vprev =
            Schwungrad_Kickoff_Test_B.GyroMesswert_m / 2.0;
          if (Schwungrad_Kickoff_Test_B.vprev < 0.0) {
            Schwungrad_Kickoff_Test_B.p = ceil(Schwungrad_Kickoff_Test_B.vprev);
          } else {
            Schwungrad_Kickoff_Test_B.p = -0.0;
          }

          flag = (obj->pBuf[(int16_T)obj->pHeap[(int16_T)
                  (Schwungrad_Kickoff_Test_B.p + obj->pMidHeap) - 1] - 1] <
                  obj->pBuf[(int16_T)obj->pHeap[(int16_T)
                  (Schwungrad_Kickoff_Test_B.GyroMesswert_m + obj->pMidHeap) - 1]
                  - 1]);
          if (!flag) {
            exitg1 = true;
          } else {
            if (Schwungrad_Kickoff_Test_B.vprev < 0.0) {
              Schwungrad_Kickoff_Test_B.p = ceil(Schwungrad_Kickoff_Test_B.vprev);
            } else {
              Schwungrad_Kickoff_Test_B.p = -0.0;
            }

            Schwungrad_Kickoff_Test_B.p += obj->pMidHeap;
            Schwungrad_Kickoff_Test_B.ind2 =
              Schwungrad_Kickoff_Test_B.GyroMesswert_m + obj->pMidHeap;
            Schwungrad_Kickoff_Test_B.temp = obj->pHeap[(int16_T)
              Schwungrad_Kickoff_Test_B.p - 1];
            obj->pHeap[(int16_T)Schwungrad_Kickoff_Test_B.p - 1] = obj->pHeap
              [(int16_T)Schwungrad_Kickoff_Test_B.ind2 - 1];
            obj->pHeap[(int16_T)Schwungrad_Kickoff_Test_B.ind2 - 1] =
              Schwungrad_Kickoff_Test_B.temp;
            obj->pPos[(int16_T)obj->pHeap[(int16_T)Schwungrad_Kickoff_Test_B.p -
              1] - 1] = Schwungrad_Kickoff_Test_B.p;
            obj->pPos[(int16_T)obj->pHeap[(int16_T)
              Schwungrad_Kickoff_Test_B.ind2 - 1] - 1] =
              Schwungrad_Kickoff_Test_B.ind2;
            if (Schwungrad_Kickoff_Test_B.vprev < 0.0) {
              Schwungrad_Kickoff_Test_B.GyroMesswert_m = ceil
                (Schwungrad_Kickoff_Test_B.vprev);
            } else {
              Schwungrad_Kickoff_Test_B.GyroMesswert_m = -0.0;
            }
          }
        }

        if (Schwungrad_Kickoff_Test_B.GyroMesswert_m == 0.0) {
          S_MedianFilterCG_trickleDownMin(&Schwungrad_Kickoff_Test_DW.obj.pMID,
            1.0);
        }
      }
    } else {
      if (Schwungrad_Kickoff_Test_DW.obj.pMID.pMaxHeapLength != 0.0) {
        S_MedianFilterCG_trickleDownMax(&Schwungrad_Kickoff_Test_DW.obj.pMID,
          -1.0);
      }

      if (Schwungrad_Kickoff_Test_DW.obj.pMID.pMinHeapLength > 0.0) {
        S_MedianFilterCG_trickleDownMin(&Schwungrad_Kickoff_Test_DW.obj.pMID,
          1.0);
      }
    }

    /* MATLABSystem: '<Root>/Median Filter' */
    Schwungrad_Kickoff_Test_B.GyroMesswert =
      Schwungrad_Kickoff_Test_DW.obj.pMID.pBuf[(int16_T)
      Schwungrad_Kickoff_Test_DW.obj.pMID.pHeap[(int16_T)
      Schwungrad_Kickoff_Test_DW.obj.pMID.pMidHeap - 1] - 1];

    /* ManualSwitch: '<Root>/Manual Switch' */
    if (Schwungrad_Kickoff_Test_P.ManualSwitch_CurrentSetting == 1) {
      /* ManualSwitch: '<Root>/Manual Switch' incorporates:
       *  Constant: '<Root>/Constant4'
       */
      Schwungrad_Kickoff_Test_B.PWMSignal =
        Schwungrad_Kickoff_Test_P.Constant4_Value;
    } else {
      /* ManualSwitch: '<Root>/Manual Switch' incorporates:
       *  Constant: '<Root>/Constant2'
       */
      Schwungrad_Kickoff_Test_B.PWMSignal =
        Schwungrad_Kickoff_Test_P.Constant2_Value;
    }

    /* End of ManualSwitch: '<Root>/Manual Switch' */
  }

  /* Integrator: '<Root>/Integrator' */
  Schwungrad_Kickoff_Test_B.ZeitSignal =
    Schwungrad_Kickoff_Test_X.Integrator_CSTATE;

  /* If: '<Root>/If' */
  if (rtsiIsModeUpdateTimeStep(&Schwungrad_Kickoff_Test_M->solverInfo)) {
    Schwungrad_Kickoff_Test_DW.If_ActiveSubsystem = (int8_T)
      !(Schwungrad_Kickoff_Test_B.ZeitSignal < 0.5);
  }

  if (Schwungrad_Kickoff_Test_DW.If_ActiveSubsystem == 0) {
    /* Outputs for IfAction SubSystem: '<Root>/If Action Subsystem' incorporates:
     *  ActionPort: '<S1>/Action Port'
     */
    if (rtmIsMajorTimeStep(Schwungrad_Kickoff_Test_M)) {
      /* Merge: '<Root>/Merge' incorporates:
       *  Constant: '<Root>/Constant1'
       *  SignalConversion generated from: '<S1>/In1'
       */
      Schwungrad_Kickoff_Test_B.Drehrichtung =
        Schwungrad_Kickoff_Test_P.Constant1_Value;
    }

    if (rtsiIsModeUpdateTimeStep(&Schwungrad_Kickoff_Test_M->solverInfo)) {
      srUpdateBC(Schwungrad_Kickoff_Test_DW.IfActionSubsystem_SubsysRanBC);
    }

    /* End of Outputs for SubSystem: '<Root>/If Action Subsystem' */
  } else {
    /* Outputs for IfAction SubSystem: '<Root>/If Action Subsystem1' incorporates:
     *  ActionPort: '<S2>/Action Port'
     */
    if (rtmIsMajorTimeStep(Schwungrad_Kickoff_Test_M)) {
      /* Merge: '<Root>/Merge' incorporates:
       *  Constant: '<Root>/Constant3'
       *  SignalConversion generated from: '<S2>/In1'
       */
      Schwungrad_Kickoff_Test_B.Drehrichtung =
        Schwungrad_Kickoff_Test_P.Constant3_Value;
    }

    if (rtsiIsModeUpdateTimeStep(&Schwungrad_Kickoff_Test_M->solverInfo)) {
      srUpdateBC(Schwungrad_Kickoff_Test_DW.IfActionSubsystem1_SubsysRanBC);
    }

    /* End of Outputs for SubSystem: '<Root>/If Action Subsystem1' */
  }

  /* End of If: '<Root>/If' */
  if (rtmIsMajorTimeStep(Schwungrad_Kickoff_Test_M)) {
    /* S-Function (MotorDriverSF): '<Root>/Motor PWM1' */
    MotorDriverSF_Outputs_wrapper_cgen(&Schwungrad_Kickoff_Test_B.PWMSignal,
      &Schwungrad_Kickoff_Test_DW.MotorPWM1_DSTATE);

    /* MATLABSystem: '<Root>/Drehrichtung' */
    Schwungrad_Kickoff_Test_B.p = rt_roundd_snf
      (Schwungrad_Kickoff_Test_B.Drehrichtung);
    if (Schwungrad_Kickoff_Test_B.p < 256.0) {
      if (Schwungrad_Kickoff_Test_B.p >= 0.0) {
        status = (uint8_T)Schwungrad_Kickoff_Test_B.p;
      } else {
        status = 0U;
      }
    } else {
      status = MAX_uint8_T;
    }

    writeDigitalPin(11, status);

    /* End of MATLABSystem: '<Root>/Drehrichtung' */
    /* MATLABSystem: '<Root>/Bremse ' incorporates:
     *  Constant: '<Root>/Constant'
     */
    Schwungrad_Kickoff_Test_B.p = rt_roundd_snf
      (Schwungrad_Kickoff_Test_P.Constant_Value);
    if (Schwungrad_Kickoff_Test_B.p < 256.0) {
      if (Schwungrad_Kickoff_Test_B.p >= 0.0) {
        status = (uint8_T)Schwungrad_Kickoff_Test_B.p;
      } else {
        status = 0U;
      }
    } else {
      status = MAX_uint8_T;
    }

    writeDigitalPin(10, status);

    /* End of MATLABSystem: '<Root>/Bremse ' */

    /* DiscretePulseGenerator: '<Root>/Discrete Pulse Generator' */
    Schwungrad_Kickoff_Test_B.DiscretePulseGenerator =
      (Schwungrad_Kickoff_Test_DW.clockTickCounter <
       Schwungrad_Kickoff_Test_P.DiscretePulseGenerator_Duty) &&
      (Schwungrad_Kickoff_Test_DW.clockTickCounter >= 0L) ?
      Schwungrad_Kickoff_Test_P.DiscretePulseGenerator_Amp : 0.0;

    /* DiscretePulseGenerator: '<Root>/Discrete Pulse Generator' */
    if (Schwungrad_Kickoff_Test_DW.clockTickCounter >=
        Schwungrad_Kickoff_Test_P.DiscretePulseGenerator_Period - 1.0) {
      Schwungrad_Kickoff_Test_DW.clockTickCounter = 0L;
    } else {
      Schwungrad_Kickoff_Test_DW.clockTickCounter++;
    }
  }

  if (rtmIsMajorTimeStep(Schwungrad_Kickoff_Test_M)) {
    if (rtmIsMajorTimeStep(Schwungrad_Kickoff_Test_M)) {
      /* Update for S-Function (MotorDriverSF): '<Root>/Motor PWM1' */

      /* S-Function "MotorDriverSF_wrapper" Block: <Root>/Motor PWM1 */
      MotorDriverSF_Update_wrapper_cgen(&Schwungrad_Kickoff_Test_B.PWMSignal,
        &Schwungrad_Kickoff_Test_DW.MotorPWM1_DSTATE);
    }

    {                                  /* Sample time: [0.0s, 0.0s] */
      extmodeErrorCode_T errorCode = EXTMODE_SUCCESS;
      extmodeSimulationTime_T currentTime = (extmodeSimulationTime_T)
        ((Schwungrad_Kickoff_Test_M->Timing.clockTick0 * 1) + 0)
        ;

      /* Trigger External Mode event */
      errorCode = extmodeEvent(0,currentTime);
      if (errorCode != EXTMODE_SUCCESS) {
        /* Code to handle External Mode event errors
           may be added here */
      }
    }

    if (rtmIsMajorTimeStep(Schwungrad_Kickoff_Test_M)) {/* Sample time: [0.01s, 0.0s] */
      extmodeErrorCode_T errorCode = EXTMODE_SUCCESS;
      extmodeSimulationTime_T currentTime = (extmodeSimulationTime_T)
        ((Schwungrad_Kickoff_Test_M->Timing.clockTick1 * 1) + 0)
        ;

      /* Trigger External Mode event */
      errorCode = extmodeEvent(1,currentTime);
      if (errorCode != EXTMODE_SUCCESS) {
        /* Code to handle External Mode event errors
           may be added here */
      }
    }
  }                                    /* end MajorTimeStep */

  if (rtmIsMajorTimeStep(Schwungrad_Kickoff_Test_M)) {
    rt_ertODEUpdateContinuousStates(&Schwungrad_Kickoff_Test_M->solverInfo);

    /* Update absolute time for base rate */
    /* The "clockTick0" counts the number of times the code of this task has
     * been executed. The absolute time is the multiplication of "clockTick0"
     * and "Timing.stepSize0". Size of "clockTick0" ensures timer will not
     * overflow during the application lifespan selected.
     */
    ++Schwungrad_Kickoff_Test_M->Timing.clockTick0;
    Schwungrad_Kickoff_Test_M->Timing.t[0] = rtsiGetSolverStopTime
      (&Schwungrad_Kickoff_Test_M->solverInfo);

    {
      /* Update absolute timer for sample time: [0.01s, 0.0s] */
      /* The "clockTick1" counts the number of times the code of this task has
       * been executed. The resolution of this integer timer is 0.01, which is the step size
       * of the task. Size of "clockTick1" ensures timer will not overflow during the
       * application lifespan selected.
       */
      Schwungrad_Kickoff_Test_M->Timing.clockTick1++;
    }
  }                                    /* end MajorTimeStep */
}

/* Derivatives for root system: '<Root>' */
void Schwungrad_Kickoff_Test_derivatives(void)
{
  XDot_Schwungrad_Kickoff_Test_T *_rtXdot;
  _rtXdot = ((XDot_Schwungrad_Kickoff_Test_T *)
             Schwungrad_Kickoff_Test_M->derivs);

  /* Derivatives for Integrator: '<Root>/Integrator' */
  _rtXdot->Integrator_CSTATE = Schwungrad_Kickoff_Test_B.DiscretePulseGenerator;
}

/* Model initialize function */
void Schwungrad_Kickoff_Test_initialize(void)
{
  /* Registration code */
  {
    /* Setup solver object */
    rtsiSetSimTimeStepPtr(&Schwungrad_Kickoff_Test_M->solverInfo,
                          &Schwungrad_Kickoff_Test_M->Timing.simTimeStep);
    rtsiSetTPtr(&Schwungrad_Kickoff_Test_M->solverInfo, &rtmGetTPtr
                (Schwungrad_Kickoff_Test_M));
    rtsiSetStepSizePtr(&Schwungrad_Kickoff_Test_M->solverInfo,
                       &Schwungrad_Kickoff_Test_M->Timing.stepSize0);
    rtsiSetdXPtr(&Schwungrad_Kickoff_Test_M->solverInfo,
                 &Schwungrad_Kickoff_Test_M->derivs);
    rtsiSetContStatesPtr(&Schwungrad_Kickoff_Test_M->solverInfo, (real_T **)
                         &Schwungrad_Kickoff_Test_M->contStates);
    rtsiSetNumContStatesPtr(&Schwungrad_Kickoff_Test_M->solverInfo,
      &Schwungrad_Kickoff_Test_M->Sizes.numContStates);
    rtsiSetNumPeriodicContStatesPtr(&Schwungrad_Kickoff_Test_M->solverInfo,
      &Schwungrad_Kickoff_Test_M->Sizes.numPeriodicContStates);
    rtsiSetPeriodicContStateIndicesPtr(&Schwungrad_Kickoff_Test_M->solverInfo,
      &Schwungrad_Kickoff_Test_M->periodicContStateIndices);
    rtsiSetPeriodicContStateRangesPtr(&Schwungrad_Kickoff_Test_M->solverInfo,
      &Schwungrad_Kickoff_Test_M->periodicContStateRanges);
    rtsiSetContStateDisabledPtr(&Schwungrad_Kickoff_Test_M->solverInfo,
      (boolean_T**) &Schwungrad_Kickoff_Test_M->contStateDisabled);
    rtsiSetErrorStatusPtr(&Schwungrad_Kickoff_Test_M->solverInfo,
                          (&rtmGetErrorStatus(Schwungrad_Kickoff_Test_M)));
    rtsiSetRTModelPtr(&Schwungrad_Kickoff_Test_M->solverInfo,
                      Schwungrad_Kickoff_Test_M);
  }

  rtsiSetSimTimeStep(&Schwungrad_Kickoff_Test_M->solverInfo, MAJOR_TIME_STEP);
  Schwungrad_Kickoff_Test_M->intgData.y = Schwungrad_Kickoff_Test_M->odeY;
  Schwungrad_Kickoff_Test_M->intgData.f[0] = Schwungrad_Kickoff_Test_M->odeF[0];
  Schwungrad_Kickoff_Test_M->intgData.f[1] = Schwungrad_Kickoff_Test_M->odeF[1];
  Schwungrad_Kickoff_Test_M->intgData.f[2] = Schwungrad_Kickoff_Test_M->odeF[2];
  Schwungrad_Kickoff_Test_M->contStates = ((X_Schwungrad_Kickoff_Test_T *)
    &Schwungrad_Kickoff_Test_X);
  Schwungrad_Kickoff_Test_M->contStateDisabled =
    ((XDis_Schwungrad_Kickoff_Test_T *) &Schwungrad_Kickoff_Test_XDis);
  Schwungrad_Kickoff_Test_M->Timing.tStart = (0.0);
  rtsiSetSolverData(&Schwungrad_Kickoff_Test_M->solverInfo, (void *)
                    &Schwungrad_Kickoff_Test_M->intgData);
  rtsiSetIsMinorTimeStepWithModeChange(&Schwungrad_Kickoff_Test_M->solverInfo,
    false);
  rtsiSetSolverName(&Schwungrad_Kickoff_Test_M->solverInfo,"ode3");
  rtmSetTPtr(Schwungrad_Kickoff_Test_M,
             &Schwungrad_Kickoff_Test_M->Timing.tArray[0]);
  rtmSetTFinal(Schwungrad_Kickoff_Test_M, -1);
  Schwungrad_Kickoff_Test_M->Timing.stepSize0 = 0.01;

  /* External mode info */
  Schwungrad_Kickoff_Test_M->Sizes.checksums[0] = (2638188474U);
  Schwungrad_Kickoff_Test_M->Sizes.checksums[1] = (4286927916U);
  Schwungrad_Kickoff_Test_M->Sizes.checksums[2] = (3492106884U);
  Schwungrad_Kickoff_Test_M->Sizes.checksums[3] = (1870273946U);

  {
    static const sysRanDType rtAlwaysEnabled = SUBSYS_RAN_BC_ENABLE;
    static RTWExtModeInfo rt_ExtModeInfo;
    static const sysRanDType *systemRan[10];
    Schwungrad_Kickoff_Test_M->extModeInfo = (&rt_ExtModeInfo);
    rteiSetSubSystemActiveVectorAddresses(&rt_ExtModeInfo, systemRan);
    systemRan[0] = &rtAlwaysEnabled;
    systemRan[1] = &rtAlwaysEnabled;
    systemRan[2] = &rtAlwaysEnabled;
    systemRan[3] = (sysRanDType *)
      &Schwungrad_Kickoff_Test_DW.IfActionSubsystem_SubsysRanBC;
    systemRan[4] = (sysRanDType *)
      &Schwungrad_Kickoff_Test_DW.IfActionSubsystem1_SubsysRanBC;
    systemRan[5] = &rtAlwaysEnabled;
    systemRan[6] = &rtAlwaysEnabled;
    systemRan[7] = &rtAlwaysEnabled;
    systemRan[8] = &rtAlwaysEnabled;
    systemRan[9] = &rtAlwaysEnabled;
    rteiSetModelMappingInfoPtr(Schwungrad_Kickoff_Test_M->extModeInfo,
      &Schwungrad_Kickoff_Test_M->SpecialInfo.mappingInfo);
    rteiSetChecksumsPtr(Schwungrad_Kickoff_Test_M->extModeInfo,
                        Schwungrad_Kickoff_Test_M->Sizes.checksums);
    rteiSetTPtr(Schwungrad_Kickoff_Test_M->extModeInfo, rtmGetTPtr
                (Schwungrad_Kickoff_Test_M));
  }

  /* Start for If: '<Root>/If' */
  Schwungrad_Kickoff_Test_DW.If_ActiveSubsystem = -1;

  /* Start for S-Function (MotorDriverSF): '<Root>/Motor PWM1' */

  /* S-Function Block: <Root>/Motor PWM1 */
  MotorDriverSF_Start_wrapper_cgen(&Schwungrad_Kickoff_Test_DW.MotorPWM1_DSTATE);

  /* InitializeConditions for Integrator: '<Root>/Integrator' */
  Schwungrad_Kickoff_Test_X.Integrator_CSTATE =
    Schwungrad_Kickoff_Test_P.Integrator_IC;

  /* InitializeConditions for S-Function (MotorDriverSF): '<Root>/Motor PWM1' */

  /* S-Function Block: <Root>/Motor PWM1 */
  {
    real_T initVector[1] = { 0 };

    {
      int_T i1;
      for (i1=0; i1 < 1; i1++) {
        Schwungrad_Kickoff_Test_DW.MotorPWM1_DSTATE = initVector[0];
      }
    }
  }

  /* SystemInitialize for Atomic SubSystem: '<Root>/MPU6050 IMU Sensor' */
  /* Start for MATLABSystem: '<S3>/Base sensor block' */
  Schwungrad_Kickoff_Test_DW.obj_i.i2cObjmpu.matlabCodegenIsDeleted = true;
  Schwungrad_Kickoff_Test_DW.obj_i.matlabCodegenIsDeleted = true;
  S_arduinoMPU6050_arduinoMPU6050(&Schwungrad_Kickoff_Test_DW.obj_i);

  /* Start for Atomic SubSystem: '<Root>/MPU6050 IMU Sensor' */
  Schwungrad_Kickoff_Test_DW.obj_i.SampleTime =
    Schwungrad_Kickoff_Test_P.MPU6050IMUSensor_SampleTime;

  /* End of Start for SubSystem: '<Root>/MPU6050 IMU Sensor' */
  Schwungrad_Kic_SystemCore_setup(&Schwungrad_Kickoff_Test_DW.obj_i);

  /* End of SystemInitialize for SubSystem: '<Root>/MPU6050 IMU Sensor' */

  /* Start for MATLABSystem: '<Root>/Median Filter' */
  Schwungrad_Kickoff_Test_DW.obj.matlabCodegenIsDeleted = false;
  Schwungrad_Kickoff_Test_DW.obj.isInitialized = 1L;
  Schwungrad_Kickoff_Test_DW.obj.NumChannels = 1L;
  Schwungrad_Kickoff_Test_DW.obj.pMID.isInitialized = 0L;
  Schwungrad_Kickoff_Test_DW.obj.isSetupComplete = true;

  /* Start for MATLABSystem: '<Root>/Drehrichtung' */
  Schwungrad_Kickoff_Test_DW.obj_k.matlabCodegenIsDeleted = false;
  Schwungrad_Kickoff_Test_DW.obj_k.isInitialized = 1L;
  digitalIOSetup(11, 1);
  Schwungrad_Kickoff_Test_DW.obj_k.isSetupComplete = true;

  /* Start for MATLABSystem: '<Root>/Bremse ' */
  Schwungrad_Kickoff_Test_DW.obj_m.matlabCodegenIsDeleted = false;
  Schwungrad_Kickoff_Test_DW.obj_m.isInitialized = 1L;
  digitalIOSetup(10, 1);
  Schwungrad_Kickoff_Test_DW.obj_m.isSetupComplete = true;
}

/* Model terminate function */
void Schwungrad_Kickoff_Test_terminate(void)
{
  l_codertarget_arduinobase_int_T *obj;

  /* Terminate for Atomic SubSystem: '<Root>/MPU6050 IMU Sensor' */
  /* Terminate for MATLABSystem: '<S3>/Base sensor block' */
  if (!Schwungrad_Kickoff_Test_DW.obj_i.matlabCodegenIsDeleted) {
    Schwungrad_Kickoff_Test_DW.obj_i.matlabCodegenIsDeleted = true;
    if ((Schwungrad_Kickoff_Test_DW.obj_i.isInitialized == 1L) &&
        Schwungrad_Kickoff_Test_DW.obj_i.isSetupComplete) {
      obj = &Schwungrad_Kickoff_Test_DW.obj_i.i2cObjmpu;
      MW_I2C_Close(obj->I2CDriverObj.MW_I2C_HANDLE);
    }
  }

  obj = &Schwungrad_Kickoff_Test_DW.obj_i.i2cObjmpu;
  if (!obj->matlabCodegenIsDeleted) {
    obj->matlabCodegenIsDeleted = true;
    if (obj->isInitialized == 1L) {
      obj->isInitialized = 2L;
    }
  }

  /* End of Terminate for MATLABSystem: '<S3>/Base sensor block' */
  /* End of Terminate for SubSystem: '<Root>/MPU6050 IMU Sensor' */
  /* Terminate for MATLABSystem: '<Root>/Median Filter' */
  if (!Schwungrad_Kickoff_Test_DW.obj.matlabCodegenIsDeleted) {
    Schwungrad_Kickoff_Test_DW.obj.matlabCodegenIsDeleted = true;
    if ((Schwungrad_Kickoff_Test_DW.obj.isInitialized == 1L) &&
        Schwungrad_Kickoff_Test_DW.obj.isSetupComplete) {
      Schwungrad_Kickoff_Test_DW.obj.NumChannels = -1L;
      if (Schwungrad_Kickoff_Test_DW.obj.pMID.isInitialized == 1L) {
        Schwungrad_Kickoff_Test_DW.obj.pMID.isInitialized = 2L;
      }
    }
  }

  /* End of Terminate for MATLABSystem: '<Root>/Median Filter' */
  /* Terminate for MATLABSystem: '<Root>/Drehrichtung' */
  if (!Schwungrad_Kickoff_Test_DW.obj_k.matlabCodegenIsDeleted) {
    Schwungrad_Kickoff_Test_DW.obj_k.matlabCodegenIsDeleted = true;
  }

  /* End of Terminate for MATLABSystem: '<Root>/Drehrichtung' */
  /* Terminate for MATLABSystem: '<Root>/Bremse ' */
  if (!Schwungrad_Kickoff_Test_DW.obj_m.matlabCodegenIsDeleted) {
    Schwungrad_Kickoff_Test_DW.obj_m.matlabCodegenIsDeleted = true;
  }

  /* End of Terminate for MATLABSystem: '<Root>/Bremse ' */
}

/*
 * File trailer for generated code.
 *
 * [EOF]
 */
