#include "AVR_PWM.h"

#define BRAKE         10 
#define DIRECTION     11
#define pinToUse       8            // Timer4C on Mega

float frequency;
float dutyCycle;
int counter;

//Erstelle PWM Instanz
AVR_PWM* PWM_Instance;


void setup() {

  pinMode(BRAKE, OUTPUT);
  pinMode(DIRECTION, OUTPUT);
  digitalWrite(BRAKE, HIGH);

  frequency = 20000;
  
  PWM_Instance = new AVR_PWM(pinToUse, 20000, 0);
  dutyCycle = 99;
  counter = -100;
}

void loop() {
  // put your main code here, to run repeatedly:
    counter++;
    Motor_control(counter);
    if (counter == 100) {counter=-100;}
    delay(100);


}

void Motor_control(int pwm) {
  if (pwm <= 0) {
    digitalWrite(DIRECTION, LOW);
    pwm = -pwm;
  } else {
    digitalWrite(DIRECTION, HIGH);
  }
  PWM_Instance->setPWM(pinToUse, frequency, map(pwm, 0, 255, 100, 20));
}
