/*
 * Academic License - for use in teaching, academic research, and meeting
 * course requirements at degree granting institutions only.  Not for
 * government, commercial, or other organizational use.
 *
 * File: LabyrinthTasterEvent.c
 *
 * Code generated for Simulink model 'LabyrinthTasterEvent'.
 *
 * Model version                  : 3.3
 * Simulink Coder version         : 24.2 (R2024b) 21-Jun-2024
 * C/C++ source code generated on : Mon Jan  6 15:48:47 2025
 *
 * Target selection: ert.tlc
 * Embedded hardware selection: Atmel->AVR
 * Code generation objectives: Unspecified
 * Validation result: Not run
 */

#include "LabyrinthTasterEvent.h"
#include "rtwtypes.h"
#include "LabyrinthTasterEvent_private.h"
#include "zero_crossing_types.h"
#include <math.h>

/* Named constants for Chart: '<Root>/Labyrinth' */
#define LabyrinthT_IN_TasterEntprellen1 ((uint8_T)13U)
#define LabyrinthT_IN_TasterEntprellen2 ((uint8_T)14U)
#define LabyrinthT_IN_TasterEntprellen3 ((uint8_T)15U)
#define LabyrinthT_IN_TasterEntprellen4 ((uint8_T)16U)
#define LabyrinthTas_IN_NO_ACTIVE_CHILD ((uint8_T)0U)
#define LabyrinthTast_IN_FalscheAntwort ((uint8_T)5U)
#define LabyrinthTaste_event_Taster1Aus (118L)
#define LabyrinthTaste_event_Taster1Ein (165L)
#define LabyrinthTaste_event_Taster2Aus (115L)
#define LabyrinthTaste_event_Taster2Ein (166L)
#define LabyrinthTaste_event_Taster3Aus (119L)
#define LabyrinthTaste_event_Taster3Ein (167L)
#define LabyrinthTaste_event_Taster4Aus (120L)
#define LabyrinthTaste_event_Taster4Ein (168L)
#define LabyrinthTasterEven_IN_Antwort1 ((uint8_T)1U)
#define LabyrinthTasterEven_IN_Antwort2 ((uint8_T)2U)
#define LabyrinthTasterEven_IN_Antwort3 ((uint8_T)3U)
#define LabyrinthTasterEven_IN_Antwort4 ((uint8_T)4U)
#define LabyrinthTasterEven_IN_Neustart ((uint8_T)12U)
#define LabyrinthTasterEven_event_Timer (94L)
#define LabyrinthTasterEvent_IN_Aus    ((uint8_T)1U)
#define LabyrinthTasterEvent_IN_Fertig ((uint8_T)6U)
#define LabyrinthTasterEvent_IN_Frage1 ((uint8_T)7U)
#define LabyrinthTasterEvent_IN_Frage2 ((uint8_T)8U)
#define LabyrinthTasterEvent_IN_Frage3 ((uint8_T)9U)
#define LabyrinthTasterEvent_IN_Frage4 ((uint8_T)10U)
#define LabyrinthTasterEvent_IN_INIT   ((uint8_T)11U)
#define LabyrinthTasterEvent_IN_Rot    ((uint8_T)2U)
#define LabyrinthTasterEvent_IN_Warten1 ((uint8_T)17U)
#define LabyrinthTasterEvent_IN_Warten2 ((uint8_T)18U)
#define LabyrinthTasterEvent_IN_Warten3 ((uint8_T)19U)

/* Named constants for Chart: '<Root>/TimerBaustein' */
#define LabyrinthTasterEve_IN_TimerIdle ((uint8_T)1U)
#define LabyrinthTaster_IN_TimerRunning ((uint8_T)2U)

/* Block signals (default storage) */
B_LabyrinthTasterEvent_T LabyrinthTasterEvent_B;

/* Block states (default storage) */
DW_LabyrinthTasterEvent_T LabyrinthTasterEvent_DW;

/* Previous zero-crossings (trigger) states */
PrevZCX_LabyrinthTasterEvent_T LabyrinthTasterEvent_PrevZCX;

/* Real-time model */
static RT_MODEL_LabyrinthTasterEvent_T LabyrinthTasterEvent_M_;
RT_MODEL_LabyrinthTasterEvent_T *const LabyrinthTasterEvent_M =
  &LabyrinthTasterEvent_M_;

/* Forward declaration for local functions */
static void LabyrinthTasterE_FalscheAntwort(const int32_T *sfEvent);
static void chartstep_c3_LabyrinthTasterEve(const int32_T *sfEvent);
uint16_T look1_iu16lu32n16_binlcse(uint16_T u0, const uint16_T bp0[], const
  uint16_T table[], uint32_T maxIndex)
{
  uint32_T frac;
  uint32_T iLeft;
  uint32_T iRght;
  uint16_T bpLeftVar;
  uint16_T y;
  uint16_T yL_0d0;

  /* Column-major Lookup 1-D
     Search method: 'binary'
     Use previous index: 'off'
     Interpolation method: 'Linear point-slope'
     Extrapolation method: 'Clip'
     Use last breakpoint for index at or above upper limit: 'off'
     Remove protection against out-of-range input in generated code: 'off'
     Rounding mode: 'simplest'
   */
  /* Prelookup - Index and Fraction
     Index Search method: 'binary'
     Extrapolation method: 'Clip'
     Use previous index: 'off'
     Use last breakpoint for index at or above upper limit: 'off'
     Remove protection against out-of-range input in generated code: 'off'
     Rounding mode: 'simplest'
   */
  if (u0 <= bp0[0UL]) {
    iLeft = 0UL;
    frac = 0UL;
  } else if (u0 < bp0[maxIndex]) {
    /* Binary Search */
    frac = maxIndex >> 1UL;
    iLeft = 0UL;
    iRght = maxIndex;
    while (iRght - iLeft > 1UL) {
      if (u0 < bp0[frac]) {
        iRght = frac;
      } else {
        iLeft = frac;
      }

      frac = (iRght + iLeft) >> 1UL;
    }

    bpLeftVar = bp0[iLeft];
    frac = ((uint32_T)(u0 - bpLeftVar) << 16) / (bp0[iLeft + 1UL] - bpLeftVar);
  } else {
    iLeft = maxIndex - 1UL;
    frac = 65536UL;
  }

  /* Column-major Interpolation 1-D
     Interpolation method: 'Linear point-slope'
     Use last breakpoint for index at or above upper limit: 'off'
     Rounding mode: 'simplest'
     Overflow mode: 'wrapping'
   */
  bpLeftVar = table[iLeft + 1UL];
  yL_0d0 = table[iLeft];
  if (bpLeftVar >= yL_0d0) {
    y = (uint16_T)(((bpLeftVar - yL_0d0) * frac) >> 16) + yL_0d0;
  } else {
    y = yL_0d0 - (uint16_T)(((yL_0d0 - bpLeftVar) * frac) >> 16);
  }

  return y;
}

/* Function for Chart: '<Root>/Labyrinth' */
static void LabyrinthTasterE_FalscheAntwort(const int32_T *sfEvent)
{
  if (LabyrinthTasterEvent_DW.is_FalscheAntwort == LabyrinthTasterEvent_IN_Aus)
  {
    LabyrinthTasterEvent_B.LED1rot = 0.0;
    LabyrinthTasterEvent_B.LED2rot = 0.0;
    if (LabyrinthTasterEvent_DW.Frage == 2.0) {
      LabyrinthTasterEvent_B.LED1blau = 1.0;
      LabyrinthTasterEvent_DW.is_FalscheAntwort =
        LabyrinthTas_IN_NO_ACTIVE_CHILD;
      LabyrinthTasterEvent_DW.is_c3_LabyrinthTasterEvent =
        LabyrinthTasterEvent_IN_Frage2;
    } else if (LabyrinthTasterEvent_DW.Frage == 1.0) {
      LabyrinthTasterEvent_DW.is_FalscheAntwort =
        LabyrinthTas_IN_NO_ACTIVE_CHILD;
      LabyrinthTasterEvent_DW.is_c3_LabyrinthTasterEvent =
        LabyrinthTasterEvent_IN_Frage1;
      LabyrinthTasterEvent_B.LED3rot = 0.0;
      LabyrinthTasterEvent_B.LED4rot = 0.0;
    } else if (LabyrinthTasterEvent_DW.Frage == 4.0) {
      LabyrinthTasterEvent_B.LED3rot = 255.0;
      LabyrinthTasterEvent_B.LED3gruen = 45.0;
      LabyrinthTasterEvent_B.LED1blau = 1.0;
      LabyrinthTasterEvent_B.LED2gruen = 1.0;
      LabyrinthTasterEvent_DW.is_FalscheAntwort =
        LabyrinthTas_IN_NO_ACTIVE_CHILD;
      LabyrinthTasterEvent_DW.is_c3_LabyrinthTasterEvent =
        LabyrinthTasterEvent_IN_Frage4;
    } else if (LabyrinthTasterEvent_DW.Frage == 3.0) {
      LabyrinthTasterEvent_B.LED1blau = 1.0;
      LabyrinthTasterEvent_B.LED2gruen = 1.0;
      LabyrinthTasterEvent_DW.is_FalscheAntwort =
        LabyrinthTas_IN_NO_ACTIVE_CHILD;
      LabyrinthTasterEvent_DW.is_c3_LabyrinthTasterEvent =
        LabyrinthTasterEvent_IN_Frage3;
    }
  } else {
    /* case IN_Rot: */
    LabyrinthTasterEvent_B.LED1rot = 1.0;
    LabyrinthTasterEvent_B.LED2rot = 1.0;
    if (*sfEvent == LabyrinthTasterEven_event_Timer) {
      LabyrinthTasterEvent_DW.is_FalscheAntwort = LabyrinthTasterEvent_IN_Aus;
      LabyrinthTasterEvent_B.LED1rot = 0.0;
      LabyrinthTasterEvent_B.LED2rot = 0.0;
      LabyrinthTasterEvent_B.LED3rot = 0.0;
      LabyrinthTasterEvent_B.LED4rot = 0.0;
    }
  }
}

/* Function for Chart: '<Root>/Labyrinth' */
static void chartstep_c3_LabyrinthTasterEve(const int32_T *sfEvent)
{
  switch (LabyrinthTasterEvent_DW.is_c3_LabyrinthTasterEvent) {
   case LabyrinthTasterEven_IN_Antwort1:
    if (*sfEvent == LabyrinthTaste_event_Taster2Aus) {
      LabyrinthTasterEvent_B.StartTimer = 50U;
      LabyrinthTasterEvent_DW.is_c3_LabyrinthTasterEvent =
        LabyrinthT_IN_TasterEntprellen1;
    }
    break;

   case LabyrinthTasterEven_IN_Antwort2:
    if (*sfEvent == LabyrinthTaste_event_Taster2Aus) {
      LabyrinthTasterEvent_B.StartTimer = 50U;
      LabyrinthTasterEvent_DW.is_c3_LabyrinthTasterEvent =
        LabyrinthT_IN_TasterEntprellen2;
    }
    break;

   case LabyrinthTasterEven_IN_Antwort3:
    if (*sfEvent == LabyrinthTaste_event_Taster1Ein) {
      LabyrinthTasterEvent_DW.is_c3_LabyrinthTasterEvent =
        LabyrinthT_IN_TasterEntprellen3;
    }
    break;

   case LabyrinthTasterEven_IN_Antwort4:
    if (*sfEvent == LabyrinthTaste_event_Taster4Ein) {
      LabyrinthTasterEvent_DW.is_c3_LabyrinthTasterEvent =
        LabyrinthT_IN_TasterEntprellen4;
    }
    break;

   case LabyrinthTast_IN_FalscheAntwort:
    LabyrinthTasterE_FalscheAntwort(sfEvent);
    break;

   case LabyrinthTasterEvent_IN_Fertig:
    if ((*sfEvent == LabyrinthTaste_event_Taster1Ein) && (*sfEvent ==
         LabyrinthTaste_event_Taster4Ein)) {
      LabyrinthTasterEvent_B.StartTimer = 2000U;
      LabyrinthTasterEvent_DW.is_c3_LabyrinthTasterEvent =
        LabyrinthTasterEven_IN_Neustart;
      LabyrinthTasterEvent_B.LED1rot = 0.0;
      LabyrinthTasterEvent_B.LED1blau = 0.0;
      LabyrinthTasterEvent_B.LED2rot = 0.0;
      LabyrinthTasterEvent_B.LED2gruen = 0.0;
      LabyrinthTasterEvent_B.LED3rot = 0.0;
      LabyrinthTasterEvent_B.LED3gruen = 0.0;
      LabyrinthTasterEvent_B.LED4rot = 0.0;
      LabyrinthTasterEvent_B.LED4blau = 0.0;
    }
    break;

   case LabyrinthTasterEvent_IN_Frage1:
    LabyrinthTasterEvent_B.LED1rot = 0.0;
    LabyrinthTasterEvent_B.LED2rot = 0.0;
    if ((*sfEvent == LabyrinthTaste_event_Taster1Ein) || (*sfEvent ==
         LabyrinthTaste_event_Taster3Ein) || (*sfEvent ==
         LabyrinthTaste_event_Taster4Ein)) {
      LabyrinthTasterEvent_B.StartTimer = 1000U;
      LabyrinthTasterEvent_DW.is_c3_LabyrinthTasterEvent =
        LabyrinthTast_IN_FalscheAntwort;
      LabyrinthTasterEvent_DW.is_FalscheAntwort = LabyrinthTasterEvent_IN_Rot;
      LabyrinthTasterEvent_B.LED1rot = 1.0;
      LabyrinthTasterEvent_B.LED1blau = 0.0;
      LabyrinthTasterEvent_B.LED2rot = 1.0;
      LabyrinthTasterEvent_B.LED2gruen = 0.0;
      LabyrinthTasterEvent_B.LED3rot = 1.0;
      LabyrinthTasterEvent_B.LED3gruen = 0.0;
      LabyrinthTasterEvent_B.LED4rot = 1.0;
      LabyrinthTasterEvent_B.LED4blau = 0.0;
    } else if (*sfEvent == LabyrinthTaste_event_Taster2Ein) {
      LabyrinthTasterEvent_B.LED1blau = 1.0;
      LabyrinthTasterEvent_DW.is_c3_LabyrinthTasterEvent =
        LabyrinthTasterEven_IN_Antwort1;
    }
    break;

   case LabyrinthTasterEvent_IN_Frage2:
    if ((*sfEvent == LabyrinthTaste_event_Taster1Ein) || (*sfEvent ==
         LabyrinthTaste_event_Taster3Ein) || (*sfEvent ==
         LabyrinthTaste_event_Taster4Ein)) {
      LabyrinthTasterEvent_B.StartTimer = 1000U;
      LabyrinthTasterEvent_DW.is_c3_LabyrinthTasterEvent =
        LabyrinthTast_IN_FalscheAntwort;
      LabyrinthTasterEvent_DW.is_FalscheAntwort = LabyrinthTasterEvent_IN_Rot;
      LabyrinthTasterEvent_B.LED1rot = 1.0;
      LabyrinthTasterEvent_B.LED1blau = 0.0;
      LabyrinthTasterEvent_B.LED2rot = 1.0;
      LabyrinthTasterEvent_B.LED2gruen = 0.0;
      LabyrinthTasterEvent_B.LED3rot = 1.0;
      LabyrinthTasterEvent_B.LED3gruen = 0.0;
      LabyrinthTasterEvent_B.LED4rot = 1.0;
      LabyrinthTasterEvent_B.LED4blau = 0.0;
    } else if (*sfEvent == LabyrinthTaste_event_Taster2Ein) {
      LabyrinthTasterEvent_B.LED2gruen = 1.0;
      LabyrinthTasterEvent_DW.is_c3_LabyrinthTasterEvent =
        LabyrinthTasterEven_IN_Antwort2;
    }
    break;

   case LabyrinthTasterEvent_IN_Frage3:
    if (*sfEvent == LabyrinthTaste_event_Taster1Ein) {
      LabyrinthTasterEvent_B.LED3rot = 1.0;
      LabyrinthTasterEvent_B.LED3gruen = 45.0;
      LabyrinthTasterEvent_DW.is_c3_LabyrinthTasterEvent =
        LabyrinthTasterEven_IN_Antwort3;
    } else if ((*sfEvent == LabyrinthTaste_event_Taster2Ein) || (*sfEvent ==
                LabyrinthTaste_event_Taster3Ein) || (*sfEvent ==
                LabyrinthTaste_event_Taster4Ein)) {
      LabyrinthTasterEvent_B.StartTimer = 1000U;
      LabyrinthTasterEvent_DW.is_c3_LabyrinthTasterEvent =
        LabyrinthTast_IN_FalscheAntwort;
      LabyrinthTasterEvent_DW.is_FalscheAntwort = LabyrinthTasterEvent_IN_Rot;
      LabyrinthTasterEvent_B.LED1rot = 1.0;
      LabyrinthTasterEvent_B.LED1blau = 0.0;
      LabyrinthTasterEvent_B.LED2rot = 1.0;
      LabyrinthTasterEvent_B.LED2gruen = 0.0;
      LabyrinthTasterEvent_B.LED3rot = 1.0;
      LabyrinthTasterEvent_B.LED3gruen = 0.0;
      LabyrinthTasterEvent_B.LED4rot = 1.0;
      LabyrinthTasterEvent_B.LED4blau = 0.0;
    }
    break;

   case LabyrinthTasterEvent_IN_Frage4:
    if ((*sfEvent == LabyrinthTaste_event_Taster1Ein) || (*sfEvent ==
         LabyrinthTaste_event_Taster2Ein) || (*sfEvent ==
         LabyrinthTaste_event_Taster3Ein)) {
      LabyrinthTasterEvent_B.StartTimer = 1000U;
      LabyrinthTasterEvent_DW.is_c3_LabyrinthTasterEvent =
        LabyrinthTast_IN_FalscheAntwort;
      LabyrinthTasterEvent_DW.is_FalscheAntwort = LabyrinthTasterEvent_IN_Rot;
      LabyrinthTasterEvent_B.LED1rot = 1.0;
      LabyrinthTasterEvent_B.LED1blau = 0.0;
      LabyrinthTasterEvent_B.LED2rot = 1.0;
      LabyrinthTasterEvent_B.LED2gruen = 0.0;
      LabyrinthTasterEvent_B.LED3rot = 1.0;
      LabyrinthTasterEvent_B.LED3gruen = 0.0;
      LabyrinthTasterEvent_B.LED4rot = 1.0;
      LabyrinthTasterEvent_B.LED4blau = 0.0;
    } else if (*sfEvent == LabyrinthTaste_event_Taster4Ein) {
      LabyrinthTasterEvent_B.LED4rot = 1.0;
      LabyrinthTasterEvent_B.LED4blau = 70.0;
      LabyrinthTasterEvent_DW.is_c3_LabyrinthTasterEvent =
        LabyrinthTasterEven_IN_Antwort4;
    }
    break;

   case LabyrinthTasterEvent_IN_INIT:
    LabyrinthTasterEvent_B.LED1rot = 1.0;
    LabyrinthTasterEvent_B.LED2rot = 1.0;
    if (*sfEvent == LabyrinthTasterEven_event_Timer) {
      LabyrinthTasterEvent_DW.is_c3_LabyrinthTasterEvent =
        LabyrinthTasterEvent_IN_Frage1;
      LabyrinthTasterEvent_DW.Frage = 1.0;
      LabyrinthTasterEvent_B.LED1rot = 0.0;
      LabyrinthTasterEvent_B.LED2rot = 0.0;
      LabyrinthTasterEvent_B.LED3rot = 0.0;
      LabyrinthTasterEvent_B.LED4rot = 0.0;
    }
    break;

   case LabyrinthTasterEven_IN_Neustart:
    LabyrinthTasterEvent_B.LED1rot = 0.0;
    LabyrinthTasterEvent_B.LED2rot = 0.0;
    if (*sfEvent == LabyrinthTasterEven_event_Timer) {
      LabyrinthTasterEvent_DW.is_c3_LabyrinthTasterEvent =
        LabyrinthTasterEvent_IN_INIT;
      LabyrinthTasterEvent_B.LED1rot = 1.0;
      LabyrinthTasterEvent_B.LED1blau = 0.0;
      LabyrinthTasterEvent_B.LED2rot = 1.0;
      LabyrinthTasterEvent_B.LED2gruen = 0.0;
      LabyrinthTasterEvent_B.LED3rot = 1.0;
      LabyrinthTasterEvent_B.LED3gruen = 0.0;
      LabyrinthTasterEvent_B.LED4rot = 1.0;
      LabyrinthTasterEvent_B.LED4blau = 0.0;
      LabyrinthTasterEvent_B.StartTimer = 1000U;
    }
    break;

   case LabyrinthT_IN_TasterEntprellen1:
    switch (*sfEvent) {
     case LabyrinthTasterEven_event_Timer:
      LabyrinthTasterEvent_DW.is_c3_LabyrinthTasterEvent =
        LabyrinthTasterEvent_IN_Warten1;
      LabyrinthTasterEvent_B.StartTimer = 1000U;
      break;

     case LabyrinthTaste_event_Taster2Ein:
      LabyrinthTasterEvent_DW.is_c3_LabyrinthTasterEvent =
        LabyrinthTasterEven_IN_Antwort1;
      break;
    }
    break;

   case LabyrinthT_IN_TasterEntprellen2:
    switch (*sfEvent) {
     case LabyrinthTasterEven_event_Timer:
      LabyrinthTasterEvent_DW.is_c3_LabyrinthTasterEvent =
        LabyrinthTasterEvent_IN_Warten2;
      LabyrinthTasterEvent_B.StartTimer = 1000U;
      break;

     case LabyrinthTaste_event_Taster2Ein:
      LabyrinthTasterEvent_DW.is_c3_LabyrinthTasterEvent =
        LabyrinthTasterEven_IN_Antwort2;
      break;
    }
    break;

   case LabyrinthT_IN_TasterEntprellen3:
    switch (*sfEvent) {
     case LabyrinthTaste_event_Taster1Aus:
      LabyrinthTasterEvent_B.StartTimer = 50U;
      LabyrinthTasterEvent_DW.is_c3_LabyrinthTasterEvent =
        LabyrinthTasterEven_IN_Antwort3;
      break;

     case LabyrinthTasterEven_event_Timer:
      LabyrinthTasterEvent_DW.is_c3_LabyrinthTasterEvent =
        LabyrinthTasterEvent_IN_Warten3;
      LabyrinthTasterEvent_B.StartTimer = 1000U;
      break;
    }
    break;

   case LabyrinthT_IN_TasterEntprellen4:
    switch (*sfEvent) {
     case LabyrinthTaste_event_Taster4Aus:
      LabyrinthTasterEvent_B.StartTimer = 50U;
      LabyrinthTasterEvent_DW.is_c3_LabyrinthTasterEvent =
        LabyrinthTasterEven_IN_Antwort4;
      break;

     case LabyrinthTasterEven_event_Timer:
      LabyrinthTasterEvent_DW.is_c3_LabyrinthTasterEvent =
        LabyrinthTasterEvent_IN_Fertig;
      break;
    }
    break;

   case LabyrinthTasterEvent_IN_Warten1:
    if (*sfEvent == LabyrinthTasterEven_event_Timer) {
      LabyrinthTasterEvent_DW.is_c3_LabyrinthTasterEvent =
        LabyrinthTasterEvent_IN_Frage2;
      LabyrinthTasterEvent_DW.Frage = 2.0;
    }
    break;

   case LabyrinthTasterEvent_IN_Warten2:
    if (*sfEvent == LabyrinthTasterEven_event_Timer) {
      LabyrinthTasterEvent_DW.is_c3_LabyrinthTasterEvent =
        LabyrinthTasterEvent_IN_Frage3;
      LabyrinthTasterEvent_DW.Frage = 3.0;
    }
    break;

   default:
    /* case IN_Warten3: */
    if (*sfEvent == LabyrinthTasterEven_event_Timer) {
      LabyrinthTasterEvent_DW.is_c3_LabyrinthTasterEvent =
        LabyrinthTasterEvent_IN_Frage4;
      LabyrinthTasterEvent_DW.Frage = 4.0;
    }
    break;
  }
}

real_T rt_roundd_snf(real_T u)
{
  real_T y;
  if (fabs(u) < 4.503599627370496E+15) {
    if (u >= 0.5) {
      y = floor(u + 0.5);
    } else if (u > -0.5) {
      y = u * 0.0;
    } else {
      y = ceil(u - 0.5);
    }
  } else {
    y = u;
  }

  return y;
}

/* Model step function */
void LabyrinthTasterEvent_step(void)
{
  real_T y;
  int32_T sfEvent;
  int16_T i;
  uint16_T rtb_Taster4_o;
  int8_T rtb_inputevents[9];
  uint8_T tmp;
  boolean_T zcEvent[9];
  boolean_T rtb_Compare;
  boolean_T rtb_Compare_d;
  boolean_T rtb_Compare_ed;
  boolean_T rtb_Compare_f;
  boolean_T rtb_Compare_g;
  boolean_T rtb_Compare_i;
  boolean_T rtb_Compare_ig;
  boolean_T rtb_Compare_ln;
  boolean_T zcEvent_0;

  /* MATLABSystem: '<Root>/PWM' */
  LabyrinthTasterEvent_DW.obj_e.PWMDriverObj.MW_PWM_HANDLE = MW_PWM_GetHandle
    (11UL);

  /* Start for MATLABSystem: '<Root>/PWM' incorporates:
   *  Constant: '<Root>/Constant'
   */
  if (LabyrinthTasterEvent_P.Constant_Value <= 255.0) {
    y = LabyrinthTasterEvent_P.Constant_Value;
  } else {
    y = 255.0;
  }

  if (!(y >= 0.0)) {
    y = 0.0;
  }

  /* MATLABSystem: '<Root>/PWM' */
  MW_PWM_SetDutyCycle(LabyrinthTasterEvent_DW.obj_e.PWMDriverObj.MW_PWM_HANDLE,
                      y);

  /* MATLABSystem: '<Root>/Taster1' */
  LabyrinthTasterEvent_DW.obj_bc.AnalogInDriverObj.MW_ANALOGIN_HANDLE =
    MW_AnalogIn_GetHandle(14UL);
  MW_AnalogInSingle_ReadResult
    (LabyrinthTasterEvent_DW.obj_bc.AnalogInDriverObj.MW_ANALOGIN_HANDLE,
     &rtb_Taster4_o, MW_ANALOGIN_UINT16);

  /* Lookup_n-D: '<Root>/LookUp1' incorporates:
   *  MATLABSystem: '<Root>/Taster1'
   * */
  rtb_Taster4_o = look1_iu16lu32n16_binlcse(rtb_Taster4_o,
    LabyrinthTasterEvent_P.LookUp1_bp01Data,
    LabyrinthTasterEvent_P.LookUp1_tableData, 1UL);

  /* RelationalOperator: '<S2>/Compare' incorporates:
   *  Constant: '<S2>/Constant'
   */
  rtb_Compare = (rtb_Taster4_o == LabyrinthTasterEvent_P.Constant_Value_m);

  /* MATLABSystem: '<Root>/Timer' */
  rtb_Compare_i = readDigitalPin(12);

  /* Chart: '<Root>/TimerBaustein' incorporates:
   *  TriggerPort: '<S10>/CLOCK'
   */
  /* Start for MATLABSystem: '<Root>/Timer' incorporates:
   *  UnitDelay: '<Root>/Unit Delay1'
   */
  if (rtb_Compare_i && (LabyrinthTasterEvent_PrevZCX.TimerBaustein_Trig_ZCE !=
                        POS_ZCSIG)) {
    if (LabyrinthTasterEvent_DW.temporalCounter_i1 < MAX_uint32_T) {
      LabyrinthTasterEvent_DW.temporalCounter_i1++;
    }

    if (LabyrinthTasterEvent_DW.is_c1_LabyrinthTasterEvent ==
        LabyrinthTasterEve_IN_TimerIdle) {
      if (LabyrinthTasterEvent_DW.UnitDelay1_DSTATE != 0U) {
        LabyrinthTasterEvent_DW.timerValue =
          LabyrinthTasterEvent_DW.UnitDelay1_DSTATE;
        LabyrinthTasterEvent_B.Timer = false;
        LabyrinthTasterEvent_DW.temporalCounter_i1 = 0UL;
        LabyrinthTasterEvent_DW.is_c1_LabyrinthTasterEvent =
          LabyrinthTaster_IN_TimerRunning;
      }

      /* case IN_TimerRunning: */
    } else if (LabyrinthTasterEvent_DW.UnitDelay1_DSTATE !=
               LabyrinthTasterEvent_DW.timerValue) {
      if (LabyrinthTasterEvent_DW.UnitDelay1_DSTATE != 0U) {
        LabyrinthTasterEvent_DW.timerValue =
          LabyrinthTasterEvent_DW.UnitDelay1_DSTATE;
        LabyrinthTasterEvent_B.Timer = false;
        LabyrinthTasterEvent_DW.temporalCounter_i1 = 0UL;
        LabyrinthTasterEvent_DW.is_c1_LabyrinthTasterEvent =
          LabyrinthTaster_IN_TimerRunning;
      } else {
        LabyrinthTasterEvent_DW.is_c1_LabyrinthTasterEvent =
          LabyrinthTasterEve_IN_TimerIdle;
      }
    } else if (LabyrinthTasterEvent_DW.temporalCounter_i1 >=
               LabyrinthTasterEvent_DW.UnitDelay1_DSTATE) {
      LabyrinthTasterEvent_B.Timer = true;
      LabyrinthTasterEvent_DW.is_c1_LabyrinthTasterEvent =
        LabyrinthTasterEve_IN_TimerIdle;
    }
  }

  LabyrinthTasterEvent_PrevZCX.TimerBaustein_Trig_ZCE = rtb_Compare_i;

  /* RelationalOperator: '<S3>/Compare' incorporates:
   *  Constant: '<S3>/Constant'
   */
  rtb_Compare_i = (rtb_Taster4_o > LabyrinthTasterEvent_P.Constant_Value_o);

  /* MATLABSystem: '<Root>/Taster2' */
  LabyrinthTasterEvent_DW.obj_l.AnalogInDriverObj.MW_ANALOGIN_HANDLE =
    MW_AnalogIn_GetHandle(15UL);
  MW_AnalogInSingle_ReadResult
    (LabyrinthTasterEvent_DW.obj_l.AnalogInDriverObj.MW_ANALOGIN_HANDLE,
     &rtb_Taster4_o, MW_ANALOGIN_UINT16);

  /* Lookup_n-D: '<Root>/LookUp2' incorporates:
   *  MATLABSystem: '<Root>/Taster2'
   * */
  rtb_Taster4_o = look1_iu16lu32n16_binlcse(rtb_Taster4_o,
    LabyrinthTasterEvent_P.LookUp2_bp01Data,
    LabyrinthTasterEvent_P.LookUp2_tableData, 1UL);

  /* RelationalOperator: '<S4>/Compare' incorporates:
   *  Constant: '<S4>/Constant'
   */
  rtb_Compare_d = (rtb_Taster4_o == LabyrinthTasterEvent_P.Constant_Value_l);

  /* RelationalOperator: '<S5>/Compare' incorporates:
   *  Constant: '<S5>/Constant'
   */
  rtb_Compare_ig = (rtb_Taster4_o > LabyrinthTasterEvent_P.Constant_Value_b);

  /* MATLABSystem: '<Root>/Taster 3' */
  LabyrinthTasterEvent_DW.obj_p.AnalogInDriverObj.MW_ANALOGIN_HANDLE =
    MW_AnalogIn_GetHandle(16UL);
  MW_AnalogInSingle_ReadResult
    (LabyrinthTasterEvent_DW.obj_p.AnalogInDriverObj.MW_ANALOGIN_HANDLE,
     &rtb_Taster4_o, MW_ANALOGIN_UINT16);

  /* Lookup_n-D: '<Root>/LookUp3' incorporates:
   *  MATLABSystem: '<Root>/Taster 3'
   * */
  rtb_Taster4_o = look1_iu16lu32n16_binlcse(rtb_Taster4_o,
    LabyrinthTasterEvent_P.LookUp3_bp01Data,
    LabyrinthTasterEvent_P.LookUp3_tableData, 1UL);

  /* RelationalOperator: '<S6>/Compare' incorporates:
   *  Constant: '<S6>/Constant'
   */
  rtb_Compare_f = (rtb_Taster4_o == LabyrinthTasterEvent_P.Constant_Value_g);

  /* RelationalOperator: '<S7>/Compare' incorporates:
   *  Constant: '<S7>/Constant'
   */
  rtb_Compare_ed = (rtb_Taster4_o > LabyrinthTasterEvent_P.Constant_Value_gl);

  /* MATLABSystem: '<Root>/Taster4' */
  LabyrinthTasterEvent_DW.obj_oy.AnalogInDriverObj.MW_ANALOGIN_HANDLE =
    MW_AnalogIn_GetHandle(17UL);
  MW_AnalogInSingle_ReadResult
    (LabyrinthTasterEvent_DW.obj_oy.AnalogInDriverObj.MW_ANALOGIN_HANDLE,
     &rtb_Taster4_o, MW_ANALOGIN_UINT16);

  /* Lookup_n-D: '<Root>/LookUp4' incorporates:
   *  MATLABSystem: '<Root>/Taster4'
   * */
  rtb_Taster4_o = look1_iu16lu32n16_binlcse(rtb_Taster4_o,
    LabyrinthTasterEvent_P.LookUp4_bp01Data,
    LabyrinthTasterEvent_P.LookUp4_tableData, 1UL);

  /* RelationalOperator: '<S8>/Compare' incorporates:
   *  Constant: '<S8>/Constant'
   */
  rtb_Compare_ln = (rtb_Taster4_o == LabyrinthTasterEvent_P.Constant_Value_i);

  /* RelationalOperator: '<S9>/Compare' incorporates:
   *  Constant: '<S9>/Constant'
   */
  rtb_Compare_g = (rtb_Taster4_o > LabyrinthTasterEvent_P.Constant_Value_p);

  /* Chart: '<Root>/Labyrinth' incorporates:
   *  TriggerPort: '<S1>/input events'
   */
  zcEvent[0] = (LabyrinthTasterEvent_B.Timer &&
                (LabyrinthTasterEvent_PrevZCX.Labyrinth_Trig_ZCE[0] != POS_ZCSIG));
  zcEvent[1] = (rtb_Compare && (LabyrinthTasterEvent_PrevZCX.Labyrinth_Trig_ZCE
    [1] != POS_ZCSIG));
  zcEvent[2] = (rtb_Compare_i &&
                (LabyrinthTasterEvent_PrevZCX.Labyrinth_Trig_ZCE[2] != POS_ZCSIG));
  zcEvent[3] = (rtb_Compare_d &&
                (LabyrinthTasterEvent_PrevZCX.Labyrinth_Trig_ZCE[3] != POS_ZCSIG));
  zcEvent[4] = (rtb_Compare_ig &&
                (LabyrinthTasterEvent_PrevZCX.Labyrinth_Trig_ZCE[4] != POS_ZCSIG));
  zcEvent[5] = (rtb_Compare_f &&
                (LabyrinthTasterEvent_PrevZCX.Labyrinth_Trig_ZCE[5] != POS_ZCSIG));
  zcEvent[6] = (rtb_Compare_ed &&
                (LabyrinthTasterEvent_PrevZCX.Labyrinth_Trig_ZCE[6] != POS_ZCSIG));
  zcEvent[7] = (rtb_Compare_ln &&
                (LabyrinthTasterEvent_PrevZCX.Labyrinth_Trig_ZCE[7] != POS_ZCSIG));
  zcEvent[8] = (rtb_Compare_g &&
                (LabyrinthTasterEvent_PrevZCX.Labyrinth_Trig_ZCE[8] != POS_ZCSIG));
  zcEvent_0 = false;
  for (i = 0; i < 9; i++) {
    zcEvent_0 = (zcEvent_0 || zcEvent[i]);
  }

  if (zcEvent_0) {
    for (i = 0; i < 9; i++) {
      rtb_inputevents[i] = (int8_T)zcEvent[i];
    }

    if (rtb_inputevents[0UL] == 1) {
      sfEvent = LabyrinthTasterEven_event_Timer;
      chartstep_c3_LabyrinthTasterEve(&sfEvent);
    }

    if (rtb_inputevents[1UL] == 1) {
      sfEvent = LabyrinthTaste_event_Taster1Aus;
      chartstep_c3_LabyrinthTasterEve(&sfEvent);
    }

    if (rtb_inputevents[2UL] == 1) {
      sfEvent = LabyrinthTaste_event_Taster1Ein;
      chartstep_c3_LabyrinthTasterEve(&sfEvent);
    }

    if (rtb_inputevents[3UL] == 1) {
      sfEvent = LabyrinthTaste_event_Taster2Aus;
      chartstep_c3_LabyrinthTasterEve(&sfEvent);
    }

    if (rtb_inputevents[4UL] == 1) {
      sfEvent = LabyrinthTaste_event_Taster2Ein;
      chartstep_c3_LabyrinthTasterEve(&sfEvent);
    }

    if (rtb_inputevents[5UL] == 1) {
      sfEvent = LabyrinthTaste_event_Taster3Aus;
      chartstep_c3_LabyrinthTasterEve(&sfEvent);
    }

    if (rtb_inputevents[6UL] == 1) {
      sfEvent = LabyrinthTaste_event_Taster3Ein;
      chartstep_c3_LabyrinthTasterEve(&sfEvent);
    }

    if (rtb_inputevents[7UL] == 1) {
      sfEvent = LabyrinthTaste_event_Taster4Aus;
      chartstep_c3_LabyrinthTasterEve(&sfEvent);
    }

    if (rtb_inputevents[8UL] == 1) {
      sfEvent = LabyrinthTaste_event_Taster4Ein;
      chartstep_c3_LabyrinthTasterEve(&sfEvent);
    }
  }

  LabyrinthTasterEvent_PrevZCX.Labyrinth_Trig_ZCE[0] =
    LabyrinthTasterEvent_B.Timer;
  LabyrinthTasterEvent_PrevZCX.Labyrinth_Trig_ZCE[1] = rtb_Compare;
  LabyrinthTasterEvent_PrevZCX.Labyrinth_Trig_ZCE[2] = rtb_Compare_i;
  LabyrinthTasterEvent_PrevZCX.Labyrinth_Trig_ZCE[3] = rtb_Compare_d;
  LabyrinthTasterEvent_PrevZCX.Labyrinth_Trig_ZCE[4] = rtb_Compare_ig;
  LabyrinthTasterEvent_PrevZCX.Labyrinth_Trig_ZCE[5] = rtb_Compare_f;
  LabyrinthTasterEvent_PrevZCX.Labyrinth_Trig_ZCE[6] = rtb_Compare_ed;
  LabyrinthTasterEvent_PrevZCX.Labyrinth_Trig_ZCE[7] = rtb_Compare_ln;
  LabyrinthTasterEvent_PrevZCX.Labyrinth_Trig_ZCE[8] = rtb_Compare_g;

  /* MATLABSystem: '<Root>/LED1blau' */
  y = rt_roundd_snf(LabyrinthTasterEvent_B.LED1blau);
  if (y < 256.0) {
    if (y >= 0.0) {
      tmp = (uint8_T)y;
    } else {
      tmp = 0U;
    }
  } else {
    tmp = MAX_uint8_T;
  }

  writeDigitalPin(3, tmp);

  /* End of MATLABSystem: '<Root>/LED1blau' */

  /* MATLABSystem: '<Root>/LED1rot' */
  y = rt_roundd_snf(LabyrinthTasterEvent_B.LED1rot);
  if (y < 256.0) {
    if (y >= 0.0) {
      tmp = (uint8_T)y;
    } else {
      tmp = 0U;
    }
  } else {
    tmp = MAX_uint8_T;
  }

  writeDigitalPin(2, tmp);

  /* End of MATLABSystem: '<Root>/LED1rot' */

  /* MATLABSystem: '<Root>/LED2gruen' */
  y = rt_roundd_snf(LabyrinthTasterEvent_B.LED2gruen);
  if (y < 256.0) {
    if (y >= 0.0) {
      tmp = (uint8_T)y;
    } else {
      tmp = 0U;
    }
  } else {
    tmp = MAX_uint8_T;
  }

  writeDigitalPin(5, tmp);

  /* End of MATLABSystem: '<Root>/LED2gruen' */

  /* MATLABSystem: '<Root>/LED2rot' */
  y = rt_roundd_snf(LabyrinthTasterEvent_B.LED2rot);
  if (y < 256.0) {
    if (y >= 0.0) {
      tmp = (uint8_T)y;
    } else {
      tmp = 0U;
    }
  } else {
    tmp = MAX_uint8_T;
  }

  writeDigitalPin(4, tmp);

  /* End of MATLABSystem: '<Root>/LED2rot' */

  /* MATLABSystem: '<Root>/LED3rot' */
  y = rt_roundd_snf(LabyrinthTasterEvent_B.LED3rot);
  if (y < 256.0) {
    if (y >= 0.0) {
      tmp = (uint8_T)y;
    } else {
      tmp = 0U;
    }
  } else {
    tmp = MAX_uint8_T;
  }

  writeDigitalPin(6, tmp);

  /* End of MATLABSystem: '<Root>/LED3rot' */

  /* MATLABSystem: '<Root>/LED4blau' */
  LabyrinthTasterEvent_DW.obj_j.PWMDriverObj.MW_PWM_HANDLE = MW_PWM_GetHandle
    (10UL);

  /* Start for MATLABSystem: '<Root>/LED4blau' */
  if (LabyrinthTasterEvent_B.LED4blau <= 255.0) {
    y = LabyrinthTasterEvent_B.LED4blau;
  } else {
    y = 255.0;
  }

  if (!(y >= 0.0)) {
    y = 0.0;
  }

  /* MATLABSystem: '<Root>/LED4blau' */
  MW_PWM_SetDutyCycle(LabyrinthTasterEvent_DW.obj_j.PWMDriverObj.MW_PWM_HANDLE,
                      y);

  /* MATLABSystem: '<Root>/LED4rot' */
  y = rt_roundd_snf(LabyrinthTasterEvent_B.LED4rot);
  if (y < 256.0) {
    if (y >= 0.0) {
      tmp = (uint8_T)y;
    } else {
      tmp = 0U;
    }
  } else {
    tmp = MAX_uint8_T;
  }

  writeDigitalPin(7, tmp);

  /* End of MATLABSystem: '<Root>/LED4rot' */

  /* MATLABSystem: '<Root>/LEED3gruen' */
  LabyrinthTasterEvent_DW.obj_b.PWMDriverObj.MW_PWM_HANDLE = MW_PWM_GetHandle
    (9UL);

  /* Start for MATLABSystem: '<Root>/LEED3gruen' */
  if (LabyrinthTasterEvent_B.LED3gruen <= 255.0) {
    y = LabyrinthTasterEvent_B.LED3gruen;
  } else {
    y = 255.0;
  }

  if (!(y >= 0.0)) {
    y = 0.0;
  }

  /* MATLABSystem: '<Root>/LEED3gruen' */
  MW_PWM_SetDutyCycle(LabyrinthTasterEvent_DW.obj_b.PWMDriverObj.MW_PWM_HANDLE,
                      y);

  /* Update for UnitDelay: '<Root>/Unit Delay1' */
  LabyrinthTasterEvent_DW.UnitDelay1_DSTATE = LabyrinthTasterEvent_B.StartTimer;

  /* Update absolute time for base rate */
  /* The "clockTick0" counts the number of times the code of this task has
   * been executed. The absolute time is the multiplication of "clockTick0"
   * and "Timing.stepSize0". Size of "clockTick0" ensures timer will not
   * overflow during the application lifespan selected.
   */
  LabyrinthTasterEvent_M->Timing.t[0] =
    ((time_T)(++LabyrinthTasterEvent_M->Timing.clockTick0)) *
    LabyrinthTasterEvent_M->Timing.stepSize0;

  {
    /* Update absolute timer for sample time: [0.001s, 0.0s] */
    /* The "clockTick1" counts the number of times the code of this task has
     * been executed. The resolution of this integer timer is 0.001, which is the step size
     * of the task. Size of "clockTick1" ensures timer will not overflow during the
     * application lifespan selected.
     */
    LabyrinthTasterEvent_M->Timing.clockTick1++;
  }
}

/* Model initialize function */
void LabyrinthTasterEvent_initialize(void)
{
  /* Registration code */
  {
    /* Setup solver object */
    rtsiSetSimTimeStepPtr(&LabyrinthTasterEvent_M->solverInfo,
                          &LabyrinthTasterEvent_M->Timing.simTimeStep);
    rtsiSetTPtr(&LabyrinthTasterEvent_M->solverInfo, &rtmGetTPtr
                (LabyrinthTasterEvent_M));
    rtsiSetStepSizePtr(&LabyrinthTasterEvent_M->solverInfo,
                       &LabyrinthTasterEvent_M->Timing.stepSize0);
    rtsiSetErrorStatusPtr(&LabyrinthTasterEvent_M->solverInfo,
                          (&rtmGetErrorStatus(LabyrinthTasterEvent_M)));
    rtsiSetRTModelPtr(&LabyrinthTasterEvent_M->solverInfo,
                      LabyrinthTasterEvent_M);
  }

  rtsiSetSimTimeStep(&LabyrinthTasterEvent_M->solverInfo, MAJOR_TIME_STEP);
  rtsiSetIsMinorTimeStepWithModeChange(&LabyrinthTasterEvent_M->solverInfo,
    false);
  rtsiSetIsContModeFrozen(&LabyrinthTasterEvent_M->solverInfo, false);
  rtsiSetSolverName(&LabyrinthTasterEvent_M->solverInfo,"FixedStepDiscrete");
  rtmSetTPtr(LabyrinthTasterEvent_M, &LabyrinthTasterEvent_M->Timing.tArray[0]);
  LabyrinthTasterEvent_M->Timing.stepSize0 = 0.001;

  {
    int16_T i;
    for (i = 0; i < 9; i++) {
      LabyrinthTasterEvent_PrevZCX.Labyrinth_Trig_ZCE[i] = POS_ZCSIG;
    }

    LabyrinthTasterEvent_PrevZCX.TimerBaustein_Trig_ZCE = POS_ZCSIG;

    /* InitializeConditions for UnitDelay: '<Root>/Unit Delay1' */
    LabyrinthTasterEvent_DW.UnitDelay1_DSTATE =
      LabyrinthTasterEvent_P.UnitDelay1_InitialCondition;

    /* Chart: '<Root>/TimerBaustein' */
    LabyrinthTasterEvent_DW.is_c1_LabyrinthTasterEvent =
      LabyrinthTasterEve_IN_TimerIdle;

    /* Chart: '<Root>/Labyrinth' */
    LabyrinthTasterEvent_DW.is_c3_LabyrinthTasterEvent =
      LabyrinthTasterEvent_IN_INIT;
    LabyrinthTasterEvent_B.LED1rot = 1.0;
    LabyrinthTasterEvent_B.LED2rot = 1.0;
    LabyrinthTasterEvent_B.LED3rot = 1.0;
    LabyrinthTasterEvent_B.LED4rot = 1.0;
    LabyrinthTasterEvent_B.StartTimer = 1000U;

    /* Start for MATLABSystem: '<Root>/PWM' */
    LabyrinthTasterEvent_DW.obj_e.matlabCodegenIsDeleted = false;
    LabyrinthTasterEvent_DW.obj_e.isInitialized = 1L;
    LabyrinthTasterEvent_DW.obj_e.PWMDriverObj.MW_PWM_HANDLE = MW_PWM_Open(11UL,
      0.0, 0.0);
    LabyrinthTasterEvent_DW.obj_e.isSetupComplete = true;

    /* Start for MATLABSystem: '<Root>/Taster1' */
    LabyrinthTasterEvent_DW.obj_bc.matlabCodegenIsDeleted = false;
    LabyrinthTasterEvent_DW.obj_bc.isInitialized = 1L;
    LabyrinthTasterEvent_DW.obj_bc.AnalogInDriverObj.MW_ANALOGIN_HANDLE =
      MW_AnalogInSingle_Open(14UL);
    LabyrinthTasterEvent_DW.obj_bc.isSetupComplete = true;

    /* Start for MATLABSystem: '<Root>/Timer' */
    LabyrinthTasterEvent_DW.obj_c.matlabCodegenIsDeleted = false;
    LabyrinthTasterEvent_DW.obj_c.isInitialized = 1L;
    digitalIOSetup(12, 0);
    LabyrinthTasterEvent_DW.obj_c.isSetupComplete = true;

    /* Start for MATLABSystem: '<Root>/Taster2' */
    LabyrinthTasterEvent_DW.obj_l.matlabCodegenIsDeleted = false;
    LabyrinthTasterEvent_DW.obj_l.isInitialized = 1L;
    LabyrinthTasterEvent_DW.obj_l.AnalogInDriverObj.MW_ANALOGIN_HANDLE =
      MW_AnalogInSingle_Open(15UL);
    LabyrinthTasterEvent_DW.obj_l.isSetupComplete = true;

    /* Start for MATLABSystem: '<Root>/Taster 3' */
    LabyrinthTasterEvent_DW.obj_p.matlabCodegenIsDeleted = false;
    LabyrinthTasterEvent_DW.obj_p.isInitialized = 1L;
    LabyrinthTasterEvent_DW.obj_p.AnalogInDriverObj.MW_ANALOGIN_HANDLE =
      MW_AnalogInSingle_Open(16UL);
    LabyrinthTasterEvent_DW.obj_p.isSetupComplete = true;

    /* Start for MATLABSystem: '<Root>/Taster4' */
    LabyrinthTasterEvent_DW.obj_oy.matlabCodegenIsDeleted = false;
    LabyrinthTasterEvent_DW.obj_oy.isInitialized = 1L;
    LabyrinthTasterEvent_DW.obj_oy.AnalogInDriverObj.MW_ANALOGIN_HANDLE =
      MW_AnalogInSingle_Open(17UL);
    LabyrinthTasterEvent_DW.obj_oy.isSetupComplete = true;

    /* Start for MATLABSystem: '<Root>/LED1blau' */
    LabyrinthTasterEvent_DW.obj_n.matlabCodegenIsDeleted = false;
    LabyrinthTasterEvent_DW.obj_n.isInitialized = 1L;
    digitalIOSetup(3, 1);
    LabyrinthTasterEvent_DW.obj_n.isSetupComplete = true;

    /* Start for MATLABSystem: '<Root>/LED1rot' */
    LabyrinthTasterEvent_DW.obj_fk.matlabCodegenIsDeleted = false;
    LabyrinthTasterEvent_DW.obj_fk.isInitialized = 1L;
    digitalIOSetup(2, 1);
    LabyrinthTasterEvent_DW.obj_fk.isSetupComplete = true;

    /* Start for MATLABSystem: '<Root>/LED2gruen' */
    LabyrinthTasterEvent_DW.obj_m.matlabCodegenIsDeleted = false;
    LabyrinthTasterEvent_DW.obj_m.isInitialized = 1L;
    digitalIOSetup(5, 1);
    LabyrinthTasterEvent_DW.obj_m.isSetupComplete = true;

    /* Start for MATLABSystem: '<Root>/LED2rot' */
    LabyrinthTasterEvent_DW.obj_o.matlabCodegenIsDeleted = false;
    LabyrinthTasterEvent_DW.obj_o.isInitialized = 1L;
    digitalIOSetup(4, 1);
    LabyrinthTasterEvent_DW.obj_o.isSetupComplete = true;

    /* Start for MATLABSystem: '<Root>/LED3rot' */
    LabyrinthTasterEvent_DW.obj_f.matlabCodegenIsDeleted = false;
    LabyrinthTasterEvent_DW.obj_f.isInitialized = 1L;
    digitalIOSetup(6, 1);
    LabyrinthTasterEvent_DW.obj_f.isSetupComplete = true;

    /* Start for MATLABSystem: '<Root>/LED4blau' */
    LabyrinthTasterEvent_DW.obj_j.matlabCodegenIsDeleted = false;
    LabyrinthTasterEvent_DW.obj_j.isInitialized = 1L;
    LabyrinthTasterEvent_DW.obj_j.PWMDriverObj.MW_PWM_HANDLE = MW_PWM_Open(10UL,
      0.0, 0.0);
    LabyrinthTasterEvent_DW.obj_j.isSetupComplete = true;

    /* Start for MATLABSystem: '<Root>/LED4rot' */
    LabyrinthTasterEvent_DW.obj.matlabCodegenIsDeleted = false;
    LabyrinthTasterEvent_DW.obj.isInitialized = 1L;
    digitalIOSetup(7, 1);
    LabyrinthTasterEvent_DW.obj.isSetupComplete = true;

    /* Start for MATLABSystem: '<Root>/LEED3gruen' */
    LabyrinthTasterEvent_DW.obj_b.matlabCodegenIsDeleted = false;
    LabyrinthTasterEvent_DW.obj_b.isInitialized = 1L;
    LabyrinthTasterEvent_DW.obj_b.PWMDriverObj.MW_PWM_HANDLE = MW_PWM_Open(9UL,
      0.0, 0.0);
    LabyrinthTasterEvent_DW.obj_b.isSetupComplete = true;
  }
}

/* Model terminate function */
void LabyrinthTasterEvent_terminate(void)
{
  /* Terminate for MATLABSystem: '<Root>/PWM' */
  if (!LabyrinthTasterEvent_DW.obj_e.matlabCodegenIsDeleted) {
    LabyrinthTasterEvent_DW.obj_e.matlabCodegenIsDeleted = true;
    if ((LabyrinthTasterEvent_DW.obj_e.isInitialized == 1L) &&
        LabyrinthTasterEvent_DW.obj_e.isSetupComplete) {
      LabyrinthTasterEvent_DW.obj_e.PWMDriverObj.MW_PWM_HANDLE =
        MW_PWM_GetHandle(11UL);
      MW_PWM_SetDutyCycle
        (LabyrinthTasterEvent_DW.obj_e.PWMDriverObj.MW_PWM_HANDLE, 0.0);
      LabyrinthTasterEvent_DW.obj_e.PWMDriverObj.MW_PWM_HANDLE =
        MW_PWM_GetHandle(11UL);
      MW_PWM_Close(LabyrinthTasterEvent_DW.obj_e.PWMDriverObj.MW_PWM_HANDLE);
    }
  }

  /* End of Terminate for MATLABSystem: '<Root>/PWM' */

  /* Terminate for MATLABSystem: '<Root>/Taster1' */
  if (!LabyrinthTasterEvent_DW.obj_bc.matlabCodegenIsDeleted) {
    LabyrinthTasterEvent_DW.obj_bc.matlabCodegenIsDeleted = true;
    if ((LabyrinthTasterEvent_DW.obj_bc.isInitialized == 1L) &&
        LabyrinthTasterEvent_DW.obj_bc.isSetupComplete) {
      LabyrinthTasterEvent_DW.obj_bc.AnalogInDriverObj.MW_ANALOGIN_HANDLE =
        MW_AnalogIn_GetHandle(14UL);
      MW_AnalogIn_Close
        (LabyrinthTasterEvent_DW.obj_bc.AnalogInDriverObj.MW_ANALOGIN_HANDLE);
    }
  }

  /* End of Terminate for MATLABSystem: '<Root>/Taster1' */

  /* Terminate for MATLABSystem: '<Root>/Timer' */
  if (!LabyrinthTasterEvent_DW.obj_c.matlabCodegenIsDeleted) {
    LabyrinthTasterEvent_DW.obj_c.matlabCodegenIsDeleted = true;
  }

  /* End of Terminate for MATLABSystem: '<Root>/Timer' */

  /* Terminate for MATLABSystem: '<Root>/Taster2' */
  if (!LabyrinthTasterEvent_DW.obj_l.matlabCodegenIsDeleted) {
    LabyrinthTasterEvent_DW.obj_l.matlabCodegenIsDeleted = true;
    if ((LabyrinthTasterEvent_DW.obj_l.isInitialized == 1L) &&
        LabyrinthTasterEvent_DW.obj_l.isSetupComplete) {
      LabyrinthTasterEvent_DW.obj_l.AnalogInDriverObj.MW_ANALOGIN_HANDLE =
        MW_AnalogIn_GetHandle(15UL);
      MW_AnalogIn_Close
        (LabyrinthTasterEvent_DW.obj_l.AnalogInDriverObj.MW_ANALOGIN_HANDLE);
    }
  }

  /* End of Terminate for MATLABSystem: '<Root>/Taster2' */

  /* Terminate for MATLABSystem: '<Root>/Taster 3' */
  if (!LabyrinthTasterEvent_DW.obj_p.matlabCodegenIsDeleted) {
    LabyrinthTasterEvent_DW.obj_p.matlabCodegenIsDeleted = true;
    if ((LabyrinthTasterEvent_DW.obj_p.isInitialized == 1L) &&
        LabyrinthTasterEvent_DW.obj_p.isSetupComplete) {
      LabyrinthTasterEvent_DW.obj_p.AnalogInDriverObj.MW_ANALOGIN_HANDLE =
        MW_AnalogIn_GetHandle(16UL);
      MW_AnalogIn_Close
        (LabyrinthTasterEvent_DW.obj_p.AnalogInDriverObj.MW_ANALOGIN_HANDLE);
    }
  }

  /* End of Terminate for MATLABSystem: '<Root>/Taster 3' */

  /* Terminate for MATLABSystem: '<Root>/Taster4' */
  if (!LabyrinthTasterEvent_DW.obj_oy.matlabCodegenIsDeleted) {
    LabyrinthTasterEvent_DW.obj_oy.matlabCodegenIsDeleted = true;
    if ((LabyrinthTasterEvent_DW.obj_oy.isInitialized == 1L) &&
        LabyrinthTasterEvent_DW.obj_oy.isSetupComplete) {
      LabyrinthTasterEvent_DW.obj_oy.AnalogInDriverObj.MW_ANALOGIN_HANDLE =
        MW_AnalogIn_GetHandle(17UL);
      MW_AnalogIn_Close
        (LabyrinthTasterEvent_DW.obj_oy.AnalogInDriverObj.MW_ANALOGIN_HANDLE);
    }
  }

  /* End of Terminate for MATLABSystem: '<Root>/Taster4' */

  /* Terminate for MATLABSystem: '<Root>/LED1blau' */
  if (!LabyrinthTasterEvent_DW.obj_n.matlabCodegenIsDeleted) {
    LabyrinthTasterEvent_DW.obj_n.matlabCodegenIsDeleted = true;
  }

  /* End of Terminate for MATLABSystem: '<Root>/LED1blau' */

  /* Terminate for MATLABSystem: '<Root>/LED1rot' */
  if (!LabyrinthTasterEvent_DW.obj_fk.matlabCodegenIsDeleted) {
    LabyrinthTasterEvent_DW.obj_fk.matlabCodegenIsDeleted = true;
  }

  /* End of Terminate for MATLABSystem: '<Root>/LED1rot' */

  /* Terminate for MATLABSystem: '<Root>/LED2gruen' */
  if (!LabyrinthTasterEvent_DW.obj_m.matlabCodegenIsDeleted) {
    LabyrinthTasterEvent_DW.obj_m.matlabCodegenIsDeleted = true;
  }

  /* End of Terminate for MATLABSystem: '<Root>/LED2gruen' */

  /* Terminate for MATLABSystem: '<Root>/LED2rot' */
  if (!LabyrinthTasterEvent_DW.obj_o.matlabCodegenIsDeleted) {
    LabyrinthTasterEvent_DW.obj_o.matlabCodegenIsDeleted = true;
  }

  /* End of Terminate for MATLABSystem: '<Root>/LED2rot' */

  /* Terminate for MATLABSystem: '<Root>/LED3rot' */
  if (!LabyrinthTasterEvent_DW.obj_f.matlabCodegenIsDeleted) {
    LabyrinthTasterEvent_DW.obj_f.matlabCodegenIsDeleted = true;
  }

  /* End of Terminate for MATLABSystem: '<Root>/LED3rot' */

  /* Terminate for MATLABSystem: '<Root>/LED4blau' */
  if (!LabyrinthTasterEvent_DW.obj_j.matlabCodegenIsDeleted) {
    LabyrinthTasterEvent_DW.obj_j.matlabCodegenIsDeleted = true;
    if ((LabyrinthTasterEvent_DW.obj_j.isInitialized == 1L) &&
        LabyrinthTasterEvent_DW.obj_j.isSetupComplete) {
      LabyrinthTasterEvent_DW.obj_j.PWMDriverObj.MW_PWM_HANDLE =
        MW_PWM_GetHandle(10UL);
      MW_PWM_SetDutyCycle
        (LabyrinthTasterEvent_DW.obj_j.PWMDriverObj.MW_PWM_HANDLE, 0.0);
      LabyrinthTasterEvent_DW.obj_j.PWMDriverObj.MW_PWM_HANDLE =
        MW_PWM_GetHandle(10UL);
      MW_PWM_Close(LabyrinthTasterEvent_DW.obj_j.PWMDriverObj.MW_PWM_HANDLE);
    }
  }

  /* End of Terminate for MATLABSystem: '<Root>/LED4blau' */

  /* Terminate for MATLABSystem: '<Root>/LED4rot' */
  if (!LabyrinthTasterEvent_DW.obj.matlabCodegenIsDeleted) {
    LabyrinthTasterEvent_DW.obj.matlabCodegenIsDeleted = true;
  }

  /* End of Terminate for MATLABSystem: '<Root>/LED4rot' */

  /* Terminate for MATLABSystem: '<Root>/LEED3gruen' */
  if (!LabyrinthTasterEvent_DW.obj_b.matlabCodegenIsDeleted) {
    LabyrinthTasterEvent_DW.obj_b.matlabCodegenIsDeleted = true;
    if ((LabyrinthTasterEvent_DW.obj_b.isInitialized == 1L) &&
        LabyrinthTasterEvent_DW.obj_b.isSetupComplete) {
      LabyrinthTasterEvent_DW.obj_b.PWMDriverObj.MW_PWM_HANDLE =
        MW_PWM_GetHandle(9UL);
      MW_PWM_SetDutyCycle
        (LabyrinthTasterEvent_DW.obj_b.PWMDriverObj.MW_PWM_HANDLE, 0.0);
      LabyrinthTasterEvent_DW.obj_b.PWMDriverObj.MW_PWM_HANDLE =
        MW_PWM_GetHandle(9UL);
      MW_PWM_Close(LabyrinthTasterEvent_DW.obj_b.PWMDriverObj.MW_PWM_HANDLE);
    }
  }

  /* End of Terminate for MATLABSystem: '<Root>/LEED3gruen' */
}

/*
 * File trailer for generated code.
 *
 * [EOF]
 */
