// Programm zum Senden von Can-Botschaften 
// Autoren: Block, Abulkhair
// in Anlehnung an Beispiel der Bibliothek

#include <Canbus.h>
#include <defaults.h>
#include <global.h>
#include <mcp2515.h>
#include <mcp2515_defs.h>

// Variablen deklarieren
  // Botschaften
unsigned char txBufferDrehzahl[8];
unsigned char txBufferTemp[8];
unsigned char txBufferTuer[5];
unsigned char txBufferGeschw[8];
unsigned char txBufferGeStat[8];
unsigned char txBufferAirbag[4];
unsigned char txBufferBremseStat[8];

  // Arduino Pins
int ledPin = 3;    // LED connected to digital pin 3
int TastPin=5;
int PotiPin=0;
int PedalPin=1;

  // Variablen
int valPoti=0;
int valPedal=0;
int valTast=0;

void setup(){
  // Initailisierung der seriellen Kommunikation über Tools-->Serial Monitor
  Serial.begin(9600);
  if(mcp2515_init(CANSPEED_500)) {
    Serial.println("CAN OK");
  } else {
    Serial.println("CAN ERROR");
  }
  
  // Pin Modus: OUT or IN
  pinMode(ledPin,OUTPUT);
  pinMode(TastPin,INPUT);
}

void loop() {

      // Potis einlesen
     valPoti=analogRead(PotiPin)/8;
     valPedal=(analogRead(PedalPin)-612)/3;//mal 1,85 ergibt Geschwindigkeit auf Tacho
     
     // serielle Kommunikation (Debugging)
     Serial.println(valPedal);

    // Botschaften erstellen
      // Airbag-Kontrollleuchte ausschalten
     txBufferAirbag[0]=0xE0;  
     txBufferAirbag[1]=0xF0;  
     txBufferAirbag[2]=0x00;  
     txBufferAirbag[3]=0xFF;  
     CanBus_send(0x50,4,txBufferAirbag);
    
      // Drehzahl
     txBufferDrehzahl[0]=0xFA; 
     txBufferDrehzahl[1]=0xC0; 
     txBufferDrehzahl[2]=0x00; //LSB Drehzahl
     // Unterscheidung, ob Pedal gedrückt
       // wenn nicht, dann Poti-Wert
     if (valPedal<4 && valPedal>-20)
     {
       txBufferDrehzahl[3]=valPoti; //MSB Drehzahl
     }
       // wenn ja, dann Pedal-Ansteuerung
     else if (valPedal>3)
     {
       txBufferDrehzahl[3]=valPedal; //MSB Drehzahl
     }
     txBufferDrehzahl[4]=0x00; 
     txBufferDrehzahl[5]=0x00; 
     txBufferDrehzahl[6]=0x00; 
     txBufferDrehzahl[7]=0x00; 
     CanBus_send(0x280,8, txBufferDrehzahl);
     
     // Kühlmittel-Temperatur
     txBufferTemp[0]=0xFA;
     txBufferTemp[1]=0xCC; //Temperatur
     txBufferTemp[2]=0x0C;
     txBufferTemp[3]=0xFF;
     txBufferTemp[4]=0x00;
     txBufferTemp[5]=0x80;
     txBufferTemp[6]=0x00;
     txBufferTemp[7]=0x00;
     CanBus_send(0x288,8, txBufferTemp);
     
     // Tür-Piktogramm
       // Schalter einlesen
     valTast=digitalRead(TastPin);
       // Wert senden an Seriellen Monitor
     Serial.println(valTast);
       // wenn eingeschlatet, Tür auf
    if (digitalRead(TastPin)==HIGH)
    {
       txBufferTuer[0]=0x00;
       txBufferTuer[1]=0xFF;
       txBufferTuer[2]=0xFF;
       txBufferTuer[3]=0xFF;
       txBufferTuer[4]=0x00;
       CanBus_send(0x470,5, txBufferTuer);
     }
       // wenn ausgeschaltet, dann Tür zu
     else
    {
      txBufferTuer[0]=0x00;
      txBufferTuer[1]=0xF0;
      txBufferTuer[2]=0xFF;
      txBufferTuer[3]=0xFF;
      txBufferTuer[4]=0x00;
   CanBus_send(0x470,5, txBufferTuer);
     }
     
       // Botschaft erforderlich für Geschwindigkeit
       // ist statisch
     txBufferGeStat[0]=0x25;
     txBufferGeStat[1]=0x00;
     txBufferGeStat[2]=0x01;
     txBufferGeStat[3]=0x00;
     txBufferGeStat[4]=0x00;
     txBufferGeStat[5]=0x30;
     txBufferGeStat[6]=0x00;
     txBufferGeStat[7]=0x11;
     CanBus_send(0x1A0,8,txBufferGeStat);
     
       // Bremseleuchte anschalten, wenn gebremst
     if (valPedal<-25)
     {
         digitalWrite(ledPin,HIGH); 
     }
       // Bremsleuchte ausschalten, wenn nicht gebremst
     else
     {
         digitalWrite(ledPin,LOW);
     }
        // Fehler ausschließen
     if (valPedal<-75)
     {
         valPedal=0; 
     }
       
       // Geschwindigkeits- Signal
     txBufferGeschw[0]=0x00;
     txBufferGeschw[1]=0x00;
     txBufferGeschw[2]=valPedal;
     txBufferGeschw[3]=0x00;
     txBufferGeschw[4]=0x00;
     txBufferGeschw[5]=0x00;
     txBufferGeschw[6]=0x00;
     txBufferGeschw[7]=0x00;
     CanBus_send(0x5A0,8,txBufferGeschw);
     
//     txBufferBremseStat[0]=0x00;
//     txBufferBremseStat[1]=0x80;
//     txBufferBremseStat[2]=0x7F;
//     txBufferBremseStat[3]=0x7F;
//     txBufferBremseStat[4]=0x69;
//     txBufferBremseStat[5]=0xA1;
//     txBufferBremseStat[6]=0x00;
//     txBufferBremseStat[7]=0xC2;
//     CanBus_send(0x1AC,8,txBufferBremseStat);
  
        // Airbag wieder senden, weil sonst zurückgesetzt
     CanBus_send(0x50,4,txBufferAirbag);
}

// Sende Funktion
void CanBus_send(int ID, int laenge, unsigned char *Botschaft)
{
  tCAN message; //struct Variable anlegen
  message.id=ID; //ID
   message.header.rtr=0; 
   message.header.length=laenge; //Bit-Anzahl
   
   //Bits in Nachricht speichern
   for (int i=0;i<laenge;i++)
   {
      message.data[i]=Botschaft[i]; 
   }
   
   //Funktion aus Bibliothek zum Senden der struct-Variable mit der Botschaft
   mcp2515_send_message(&message);
}

