//%*************************************************************** *
//%                   Hochschule Hamm-Lippstadt                    *
//%*************************************************************** *
//% Modul	        : Simulink model of LCD Display with I2C       *
//%                                                                *
//% Datum           : 18.12.2024                                   *
//%                                                                *
//% Funktion        : Code for the display block in Simulink with  *
//%                   the rules for when to display what.          *
//%                                                                *
//% Implementation  : MATLAB 2024b                                 *
//%                                                                *
//% Req. Toolbox    : LiquidCrystal_I2C from Arduino IDE           *
//%                                                                *
//% Author          : Jan van Pels                                 *
//%                                                                *
//% Letzte Änderung : 29.12.2024                                   *
//%****************************************************************

#include "LCD_I2C.h"
#include <Wire.h>
#include <LiquidCrystal_I2C.h>

LiquidCrystal_I2C lcd(0x27, 16, 2); // Adress 0x27, 16 columns, 2 rows
bool show_code = false; // True if all 7 LEDs are on and the COde is shown
                        // on Display

// Setup Function for LCD
void setupFunctionLCD_I2C(){
  lcd.init();
  lcd.backlight();
  // Insert initial state
  lcd.setCursor(0, 0); // Cursor on row 0, column 0 
  lcd.print("LEDs on:  /7");
}

// Function to check what needs to be displayed with the currently 
// active number of LEDs. 
void stepFunctionLCD_I2C(int8_T Input,int size_vector_a){
  // Insert the number of LEDs that are currently on
  lcd.setCursor(9, 0);
  lcd.print(Input);
  // Are all 7 LEDs on?
  if (Input == 7){
    lcd.setCursor(0, 1); // Cursor on row 1, column 0 
    lcd.print("Code: 1768"); // Show the Code
    show_code = true;
  }else if (show_code){ // Only if the Code was shown before
    lcd.setCursor(0, 1); // Cursor on row 1, column 0 
    lcd.print("          "); // Hide the Code
    show_code = false;
  }
}