/*
 * Academic License - for use in teaching, academic research, and meeting
 * course requirements at degree granting institutions only.  Not for
 * government, commercial, or other organizational use.
 *
 * File: Hauptprogramm_PJ.c
 *
 * Code generated for Simulink model 'Hauptprogramm_PJ'.
 *
 * Model version                  : 1.10
 * Simulink Coder version         : 23.2 (R2023b) 01-Aug-2023
 * C/C++ source code generated on : Tue Jan 16 23:44:29 2024
 *
 * Target selection: ert.tlc
 * Embedded hardware selection: Atmel->AVR
 * Code generation objectives: Unspecified
 * Validation result: Not run
 */

#include "Hauptprogramm_PJ.h"
#include "Hauptprogramm_PJ_types.h"
#include "rtwtypes.h"
#include <string.h>
#include <math.h>
#include "Hauptprogramm_PJ_private.h"
#include <stddef.h>
#include "rt_nonfinite.h"

/* Block signals (default storage) */
B_Hauptprogramm_PJ_T Hauptprogramm_PJ_B;

/* Continuous states */
X_Hauptprogramm_PJ_T Hauptprogramm_PJ_X;

/* Disabled State Vector */
XDis_Hauptprogramm_PJ_T Hauptprogramm_PJ_XDis;

/* Block states (default storage) */
DW_Hauptprogramm_PJ_T Hauptprogramm_PJ_DW;

/* Real-time model */
static RT_MODEL_Hauptprogramm_PJ_T Hauptprogramm_PJ_M_;
RT_MODEL_Hauptprogramm_PJ_T *const Hauptprogramm_PJ_M = &Hauptprogramm_PJ_M_;

/* Forward declaration for local functions */
static void Hauptp_MedianFilterCG_resetImpl(c_dsp_internal_MedianFilterCG_T *obj);
static void H_MedianFilterCG_trickleDownMax(c_dsp_internal_MedianFilterCG_T *obj,
  real_T i);
static void H_MedianFilterCG_trickleDownMin(c_dsp_internal_MedianFilterCG_T *obj,
  real_T i);
static codertarget_arduinobase_inter_T *H_arduinoMPU6050_arduinoMPU6050
  (codertarget_arduinobase_inter_T *obj);
static void Hauptprogramm__SystemCore_setup(codertarget_arduinobase_inter_T *obj);

/*
 * This function updates continuous states using the ODE3 fixed-step
 * solver algorithm
 */
static void rt_ertODEUpdateContinuousStates(RTWSolverInfo *si )
{
  /* Solver Matrices */
  static const real_T rt_ODE3_A[3] = {
    1.0/2.0, 3.0/4.0, 1.0
  };

  static const real_T rt_ODE3_B[3][3] = {
    { 1.0/2.0, 0.0, 0.0 },

    { 0.0, 3.0/4.0, 0.0 },

    { 2.0/9.0, 1.0/3.0, 4.0/9.0 }
  };

  time_T t = rtsiGetT(si);
  time_T tnew = rtsiGetSolverStopTime(si);
  time_T h = rtsiGetStepSize(si);
  real_T *x = rtsiGetContStates(si);
  ODE3_IntgData *id = (ODE3_IntgData *)rtsiGetSolverData(si);
  real_T *y = id->y;
  real_T *f0 = id->f[0];
  real_T *f1 = id->f[1];
  real_T *f2 = id->f[2];
  real_T hB[3];
  int_T i;
  int_T nXc = 1;
  rtsiSetSimTimeStep(si,MINOR_TIME_STEP);

  /* Save the state values at time t in y, we'll use x as ynew. */
  (void) memcpy(y, x,
                (uint_T)nXc*sizeof(real_T));

  /* Assumes that rtsiSetT and ModelOutputs are up-to-date */
  /* f0 = f(t,y) */
  rtsiSetdX(si, f0);
  Hauptprogramm_PJ_derivatives();

  /* f(:,2) = feval(odefile, t + hA(1), y + f*hB(:,1), args(:)(*)); */
  hB[0] = h * rt_ODE3_B[0][0];
  for (i = 0; i < nXc; i++) {
    x[i] = y[i] + (f0[i]*hB[0]);
  }

  rtsiSetT(si, t + h*rt_ODE3_A[0]);
  rtsiSetdX(si, f1);
  Hauptprogramm_PJ_step();
  Hauptprogramm_PJ_derivatives();

  /* f(:,3) = feval(odefile, t + hA(2), y + f*hB(:,2), args(:)(*)); */
  for (i = 0; i <= 1; i++) {
    hB[i] = h * rt_ODE3_B[1][i];
  }

  for (i = 0; i < nXc; i++) {
    x[i] = y[i] + (f0[i]*hB[0] + f1[i]*hB[1]);
  }

  rtsiSetT(si, t + h*rt_ODE3_A[1]);
  rtsiSetdX(si, f2);
  Hauptprogramm_PJ_step();
  Hauptprogramm_PJ_derivatives();

  /* tnew = t + hA(3);
     ynew = y + f*hB(:,3); */
  for (i = 0; i <= 2; i++) {
    hB[i] = h * rt_ODE3_B[2][i];
  }

  for (i = 0; i < nXc; i++) {
    x[i] = y[i] + (f0[i]*hB[0] + f1[i]*hB[1] + f2[i]*hB[2]);
  }

  rtsiSetT(si, tnew);
  rtsiSetSimTimeStep(si,MAJOR_TIME_STEP);
}

static void Hauptp_MedianFilterCG_resetImpl(c_dsp_internal_MedianFilterCG_T *obj)
{
  real_T cnt1;
  real_T cnt2;
  int16_T i;
  for (i = 0; i < 5; i++) {
    obj->pBuf[i] = 0.0;
    obj->pPos[i] = 0.0;
    obj->pHeap[i] = 0.0;
  }

  /* Start for MATLABSystem: '<Root>/Median Filter' incorporates:
   *  MATLABSystem: '<S3>/Median Filter'
   */
  obj->pWinLen = 5.0;
  obj->pIdx = obj->pWinLen;

  /* Start for MATLABSystem: '<Root>/Median Filter' incorporates:
   *  MATLABSystem: '<S3>/Median Filter'
   */
  obj->pMidHeap = ceil((obj->pWinLen + 1.0) / 2.0);
  cnt1 = (obj->pWinLen - 1.0) / 2.0;

  /* Start for MATLABSystem: '<Root>/Median Filter' incorporates:
   *  MATLABSystem: '<S3>/Median Filter'
   */
  if (cnt1 < 0.0) {
    obj->pMinHeapLength = ceil(cnt1);
  } else {
    obj->pMinHeapLength = floor(cnt1);
  }

  cnt1 = obj->pWinLen / 2.0;

  /* Start for MATLABSystem: '<Root>/Median Filter' incorporates:
   *  MATLABSystem: '<S3>/Median Filter'
   */
  if (cnt1 < 0.0) {
    obj->pMaxHeapLength = ceil(cnt1);
  } else {
    obj->pMaxHeapLength = floor(cnt1);
  }

  cnt1 = 1.0;
  cnt2 = obj->pWinLen;
  for (i = 0; i < 5; i++) {
    /* Start for MATLABSystem: '<Root>/Median Filter' incorporates:
     *  MATLABSystem: '<S3>/Median Filter'
     */
    if (fmod(5.0 - (real_T)i, 2.0) == 0.0) {
      obj->pPos[4 - i] = cnt1;
      cnt1++;
    } else {
      obj->pPos[4 - i] = cnt2;
      cnt2--;
    }

    obj->pHeap[(int16_T)obj->pPos[4 - i] - 1] = 5.0 - (real_T)i;
  }
}

static void H_MedianFilterCG_trickleDownMax(c_dsp_internal_MedianFilterCG_T *obj,
  real_T i)
{
  real_T ind2;
  real_T tmp;
  boolean_T exitg1;
  exitg1 = false;
  while ((!exitg1) && (i >= -obj->pMaxHeapLength)) {
    if ((i < -1.0) && (i > -obj->pMaxHeapLength) && (obj->pBuf[(int16_T)
         obj->pHeap[(int16_T)(i + obj->pMidHeap) - 1] - 1] < obj->pBuf[(int16_T)
         obj->pHeap[(int16_T)((i - 1.0) + obj->pMidHeap) - 1] - 1])) {
      i--;
    }

    Hauptprogramm_PJ_B.u_tmp = i / 2.0;
    if (Hauptprogramm_PJ_B.u_tmp < 0.0) {
      Hauptprogramm_PJ_B.temp_c = ceil(Hauptprogramm_PJ_B.u_tmp);
    } else {
      Hauptprogramm_PJ_B.temp_c = floor(Hauptprogramm_PJ_B.u_tmp);
    }

    ind2 = i + obj->pMidHeap;
    tmp = obj->pHeap[(int16_T)ind2 - 1];
    if (!(obj->pBuf[(int16_T)obj->pHeap[(int16_T)(Hauptprogramm_PJ_B.temp_c +
          obj->pMidHeap) - 1] - 1] < obj->pBuf[(int16_T)tmp - 1])) {
      exitg1 = true;
    } else {
      if (Hauptprogramm_PJ_B.u_tmp < 0.0) {
        Hauptprogramm_PJ_B.temp_c = ceil(Hauptprogramm_PJ_B.u_tmp);
      } else {
        Hauptprogramm_PJ_B.temp_c = floor(Hauptprogramm_PJ_B.u_tmp);
      }

      Hauptprogramm_PJ_B.u_tmp = Hauptprogramm_PJ_B.temp_c + obj->pMidHeap;
      Hauptprogramm_PJ_B.temp_c = obj->pHeap[(int16_T)Hauptprogramm_PJ_B.u_tmp -
        1];
      obj->pHeap[(int16_T)Hauptprogramm_PJ_B.u_tmp - 1] = tmp;
      obj->pHeap[(int16_T)ind2 - 1] = Hauptprogramm_PJ_B.temp_c;
      obj->pPos[(int16_T)obj->pHeap[(int16_T)Hauptprogramm_PJ_B.u_tmp - 1] - 1] =
        Hauptprogramm_PJ_B.u_tmp;
      obj->pPos[(int16_T)obj->pHeap[(int16_T)ind2 - 1] - 1] = ind2;
      i *= 2.0;
    }
  }
}

static void H_MedianFilterCG_trickleDownMin(c_dsp_internal_MedianFilterCG_T *obj,
  real_T i)
{
  real_T tmp;
  real_T u_tmp;
  boolean_T exitg1;
  exitg1 = false;
  while ((!exitg1) && (i <= obj->pMinHeapLength)) {
    if ((i > 1.0) && (i < obj->pMinHeapLength) && (obj->pBuf[(int16_T)obj->
         pHeap[(int16_T)((i + 1.0) + obj->pMidHeap) - 1] - 1] < obj->pBuf
         [(int16_T)obj->pHeap[(int16_T)(i + obj->pMidHeap) - 1] - 1])) {
      i++;
    }

    u_tmp = i / 2.0;
    if (u_tmp < 0.0) {
      Hauptprogramm_PJ_B.d = ceil(u_tmp);
    } else {
      Hauptprogramm_PJ_B.d = floor(u_tmp);
    }

    Hauptprogramm_PJ_B.ind1 = i + obj->pMidHeap;
    tmp = obj->pHeap[(int16_T)Hauptprogramm_PJ_B.ind1 - 1];
    if (!(obj->pBuf[(int16_T)tmp - 1] < obj->pBuf[(int16_T)obj->pHeap[(int16_T)
          (Hauptprogramm_PJ_B.d + obj->pMidHeap) - 1] - 1])) {
      exitg1 = true;
    } else {
      if (u_tmp < 0.0) {
        Hauptprogramm_PJ_B.d = ceil(u_tmp);
      } else {
        Hauptprogramm_PJ_B.d = floor(u_tmp);
      }

      u_tmp = Hauptprogramm_PJ_B.d + obj->pMidHeap;
      obj->pHeap[(int16_T)Hauptprogramm_PJ_B.ind1 - 1] = obj->pHeap[(int16_T)
        u_tmp - 1];
      obj->pHeap[(int16_T)u_tmp - 1] = tmp;
      obj->pPos[(int16_T)obj->pHeap[(int16_T)Hauptprogramm_PJ_B.ind1 - 1] - 1] =
        Hauptprogramm_PJ_B.ind1;
      obj->pPos[(int16_T)obj->pHeap[(int16_T)u_tmp - 1] - 1] = u_tmp;
      i *= 2.0;
    }
  }
}

real_T rt_roundd_snf(real_T u)
{
  real_T y;
  if (fabs(u) < 4.503599627370496E+15) {
    if (u >= 0.5) {
      y = floor(u + 0.5);
    } else if (u > -0.5) {
      y = u * 0.0;
    } else {
      y = ceil(u - 0.5);
    }
  } else {
    y = u;
  }

  return y;
}

static codertarget_arduinobase_inter_T *H_arduinoMPU6050_arduinoMPU6050
  (codertarget_arduinobase_inter_T *obj)
{
  codertarget_arduinobase_inter_T *b_obj;

  /* Start for MATLABSystem: '<S2>/Base sensor block' */
  obj->I2CReadWriteError = 0U;
  obj->InitError = false;
  obj->isInitialized = 0L;
  obj->SampleTime = -1.0;
  obj->IsFirstStep = false;
  b_obj = obj;
  obj->i2cObjmpu.DefaultMaximumBusSpeedInHz = 400000.0;
  obj->i2cObjmpu.isInitialized = 0L;
  obj->i2cObjmpu.I2CDriverObj.MW_I2C_HANDLE = NULL;
  obj->i2cObjmpu.matlabCodegenIsDeleted = false;
  obj->matlabCodegenIsDeleted = false;
  return b_obj;
}

static void Hauptprogramm__SystemCore_setup(codertarget_arduinobase_inter_T *obj)
{
  MW_I2C_Mode_Type modename;
  uint32_T i2cname;
  uint8_T SwappedDataBytes[2];
  uint8_T b_SwappedDataBytes[2];
  uint8_T CastedData;
  uint8_T SwappedDataBytes_0;
  uint8_T status;
  obj->isInitialized = 1L;

  /* Start for MATLABSystem: '<S2>/Base sensor block' */
  obj->InitializationFlag = true;
  modename = MW_I2C_MASTER;
  i2cname = 0;

  /* Start for MATLABSystem: '<S2>/Base sensor block' */
  obj->i2cObjmpu.I2CDriverObj.MW_I2C_HANDLE = MW_I2C_Open(i2cname, modename);
  obj->i2cObjmpu.BusSpeed = 100000UL;
  MW_I2C_SetBusSpeed(obj->i2cObjmpu.I2CDriverObj.MW_I2C_HANDLE,
                     obj->i2cObjmpu.BusSpeed);
  CastedData = 128U;
  memcpy((void *)&b_SwappedDataBytes[1], (void *)&CastedData, (size_t)1 * sizeof
         (uint8_T));
  b_SwappedDataBytes[0] = 107U;

  /* Start for MATLABSystem: '<S2>/Base sensor block' */
  memcpy((void *)&SwappedDataBytes[0], (void *)&b_SwappedDataBytes[0], (size_t)2
         * sizeof(uint8_T));
  status = MW_I2C_MasterWrite(obj->i2cObjmpu.I2CDriverObj.MW_I2C_HANDLE, 104UL,
    &SwappedDataBytes[0], 2UL, false, false);
  if (status != 0) {
    if (obj->InitializationFlag) {
      obj->InitError = true;
    } else if (obj->I2CReadWriteError == 0) {
      obj->I2CReadWriteError = status;
    }
  }

  MW_delay_in_milliseconds(1UL);
  CastedData = 0U;
  memcpy((void *)&b_SwappedDataBytes[1], (void *)&CastedData, (size_t)1 * sizeof
         (uint8_T));
  b_SwappedDataBytes[0] = 107U;

  /* Start for MATLABSystem: '<S2>/Base sensor block' */
  memcpy((void *)&SwappedDataBytes[0], (void *)&b_SwappedDataBytes[0], (size_t)2
         * sizeof(uint8_T));
  status = MW_I2C_MasterWrite(obj->i2cObjmpu.I2CDriverObj.MW_I2C_HANDLE, 104UL,
    &SwappedDataBytes[0], 2UL, false, false);
  if (status != 0) {
    if (obj->InitializationFlag) {
      obj->InitError = true;
    } else if (obj->I2CReadWriteError == 0) {
      obj->I2CReadWriteError = status;
    }
  }

  MW_delay_in_milliseconds(100UL);
  status = 117U;

  /* Start for MATLABSystem: '<S2>/Base sensor block' */
  memcpy((void *)&SwappedDataBytes_0, (void *)&status, (size_t)1 * sizeof
         (uint8_T));
  status = MW_I2C_MasterWrite(obj->i2cObjmpu.I2CDriverObj.MW_I2C_HANDLE, 104UL,
    &SwappedDataBytes_0, 1UL, true, false);
  if (status == 0) {
    MW_I2C_MasterRead(obj->i2cObjmpu.I2CDriverObj.MW_I2C_HANDLE, 104UL,
                      &SwappedDataBytes_0, 1UL, false, true);
    memcpy((void *)&CastedData, (void *)&SwappedDataBytes_0, (size_t)1 * sizeof
           (uint8_T));
  } else {
    CastedData = 0U;
  }

  if (status != 0) {
    if (obj->InitializationFlag) {
      obj->InitError = true;
    } else if (obj->I2CReadWriteError == 0) {
      obj->I2CReadWriteError = status;
    }
  }

  obj->MPUConnect = (CastedData == 104);
  if (obj->MPUConnect) {
    CastedData = 0U;
    memcpy((void *)&b_SwappedDataBytes[1], (void *)&CastedData, (size_t)1 *
           sizeof(uint8_T));
    b_SwappedDataBytes[0] = 25U;
    memcpy((void *)&SwappedDataBytes[0], (void *)&b_SwappedDataBytes[0], (size_t)
           2 * sizeof(uint8_T));
    status = MW_I2C_MasterWrite(obj->i2cObjmpu.I2CDriverObj.MW_I2C_HANDLE, 104UL,
      &SwappedDataBytes[0], 2UL, false, false);
    if (status != 0) {
      if (obj->InitializationFlag) {
        obj->InitError = true;
      } else if (obj->I2CReadWriteError == 0) {
        obj->I2CReadWriteError = status;
      }
    }

    status = 28U;
    memcpy((void *)&SwappedDataBytes_0, (void *)&status, (size_t)1 * sizeof
           (uint8_T));
    status = MW_I2C_MasterWrite(obj->i2cObjmpu.I2CDriverObj.MW_I2C_HANDLE, 104UL,
      &SwappedDataBytes_0, 1UL, true, false);
    if (status == 0) {
      MW_I2C_MasterRead(obj->i2cObjmpu.I2CDriverObj.MW_I2C_HANDLE, 104UL,
                        &SwappedDataBytes_0, 1UL, false, true);
      memcpy((void *)&CastedData, (void *)&SwappedDataBytes_0, (size_t)1 *
             sizeof(uint8_T));
    } else {
      CastedData = 0U;
    }

    if (status != 0) {
      if (obj->InitializationFlag) {
        obj->InitError = true;
      } else if (obj->I2CReadWriteError == 0) {
        obj->I2CReadWriteError = status;
      }
    }

    CastedData = (uint8_T)(CastedData & 231);
    memcpy((void *)&b_SwappedDataBytes[1], (void *)&CastedData, (size_t)1 *
           sizeof(uint8_T));
    b_SwappedDataBytes[0] = 28U;
    memcpy((void *)&SwappedDataBytes[0], (void *)&b_SwappedDataBytes[0], (size_t)
           2 * sizeof(uint8_T));
    status = MW_I2C_MasterWrite(obj->i2cObjmpu.I2CDriverObj.MW_I2C_HANDLE, 104UL,
      &SwappedDataBytes[0], 2UL, false, false);
    if (status != 0) {
      if (obj->InitializationFlag) {
        obj->InitError = true;
      } else if (obj->I2CReadWriteError == 0) {
        obj->I2CReadWriteError = status;
      }
    }

    status = 26U;
    memcpy((void *)&SwappedDataBytes_0, (void *)&status, (size_t)1 * sizeof
           (uint8_T));
    status = MW_I2C_MasterWrite(obj->i2cObjmpu.I2CDriverObj.MW_I2C_HANDLE, 104UL,
      &SwappedDataBytes_0, 1UL, true, false);
    if (status == 0) {
      MW_I2C_MasterRead(obj->i2cObjmpu.I2CDriverObj.MW_I2C_HANDLE, 104UL,
                        &SwappedDataBytes_0, 1UL, false, true);
      memcpy((void *)&CastedData, (void *)&SwappedDataBytes_0, (size_t)1 *
             sizeof(uint8_T));
    } else {
      CastedData = 0U;
    }

    if (status != 0) {
      if (obj->InitializationFlag) {
        obj->InitError = true;
      } else if (obj->I2CReadWriteError == 0) {
        obj->I2CReadWriteError = status;
      }
    }

    CastedData = (uint8_T)(CastedData & 248);
    memcpy((void *)&b_SwappedDataBytes[1], (void *)&CastedData, (size_t)1 *
           sizeof(uint8_T));
    b_SwappedDataBytes[0] = 26U;
    memcpy((void *)&SwappedDataBytes[0], (void *)&b_SwappedDataBytes[0], (size_t)
           2 * sizeof(uint8_T));
    status = MW_I2C_MasterWrite(obj->i2cObjmpu.I2CDriverObj.MW_I2C_HANDLE, 104UL,
      &SwappedDataBytes[0], 2UL, false, false);
    if (status != 0) {
      if (obj->InitializationFlag) {
        obj->InitError = true;
      } else if (obj->I2CReadWriteError == 0) {
        obj->I2CReadWriteError = status;
      }
    }
  } else {
    obj->InitError = true;
  }

  obj->InitializationFlag = false;
  obj->isSetupComplete = true;
}

/* Model step function */
void Hauptprogramm_PJ_step(void)
{
  if (rtmIsMajorTimeStep(Hauptprogramm_PJ_M)) {
    /* set solver stop time */
    rtsiSetSolverStopTime(&Hauptprogramm_PJ_M->solverInfo,
                          ((Hauptprogramm_PJ_M->Timing.clockTick0+1)*
      Hauptprogramm_PJ_M->Timing.stepSize0));
  }                                    /* end MajorTimeStep */

  /* Update absolute time of base rate at minor time step */
  if (rtmIsMinorTimeStep(Hauptprogramm_PJ_M)) {
    Hauptprogramm_PJ_M->Timing.t[0] = rtsiGetT(&Hauptprogramm_PJ_M->solverInfo);
  }

  {
    c_dsp_internal_MedianFilterCG_T *obj;
    l_codertarget_arduinobase_int_T *obj_0;
    real_T *lastU;
    int16_T i;
    int8_T rtAction;
    uint8_T b_RegisterValue[6];
    uint8_T output_raw[6];
    uint8_T SwappedDataBytes;
    uint8_T status;
    boolean_T exitg1;
    boolean_T flag;

    /* Reset subsysRan breadcrumbs */
    srClearBC(Hauptprogramm_PJ_DW.IfActionSubsystem_SubsysRanBC);

    /* Reset subsysRan breadcrumbs */
    srClearBC(Hauptprogramm_PJ_DW.IfActionSubsystem1_SubsysRanBC);

    /* Outputs for Atomic SubSystem: '<Root>/MPU6050 IMU Sensor' */
    /* Start for Atomic SubSystem: '<Root>/MPU6050 IMU Sensor' */
    /* MATLABSystem: '<S2>/Base sensor block' */
    if (Hauptprogramm_PJ_DW.obj_c.SampleTime !=
        Hauptprogramm_PJ_P.MPU6050IMUSensor_SampleTime) {
      Hauptprogramm_PJ_DW.obj_c.SampleTime =
        Hauptprogramm_PJ_P.MPU6050IMUSensor_SampleTime;
    }

    /* End of Start for SubSystem: '<Root>/MPU6050 IMU Sensor' */
    if (!Hauptprogramm_PJ_DW.obj_c.IsFirstStep) {
      MW_getCurrentTime_in_milliseconds();
      Hauptprogramm_PJ_DW.obj_c.IsFirstStep = true;
    }

    Hauptprogramm_PJ_DW.obj_c.I2CReadWriteError = 0U;
    obj_0 = &Hauptprogramm_PJ_DW.obj_c.i2cObjmpu;
    status = 59U;
    memcpy((void *)&SwappedDataBytes, (void *)&status, (size_t)1 * sizeof
           (uint8_T));
    status = MW_I2C_MasterWrite(obj_0->I2CDriverObj.MW_I2C_HANDLE, 104UL,
      &SwappedDataBytes, 1UL, true, false);
    if (status == 0) {
      MW_I2C_MasterRead(obj_0->I2CDriverObj.MW_I2C_HANDLE, 104UL, &output_raw[0],
                        6UL, false, true);
      memcpy((void *)&b_RegisterValue[0], (void *)&output_raw[0], (size_t)6 *
             sizeof(uint8_T));
    } else {
      for (i = 0; i < 6; i++) {
        b_RegisterValue[i] = 0U;
      }
    }

    if (status != 0) {
      if (Hauptprogramm_PJ_DW.obj_c.InitializationFlag) {
        Hauptprogramm_PJ_DW.obj_c.InitError = true;
      } else if (Hauptprogramm_PJ_DW.obj_c.I2CReadWriteError == 0) {
        Hauptprogramm_PJ_DW.obj_c.I2CReadWriteError = status;
      }
    }

    if (Hauptprogramm_PJ_DW.obj_c.InitError) {
      Hauptprogramm_PJ_B.vprev = 0.0;
    } else {
      Hauptprogramm_PJ_B.vprev = (real_T)(b_RegisterValue[2] << 8 |
        b_RegisterValue[3]) * 9.80665 / 16384.0;
    }

    /* Gain: '<Root>/Gain' incorporates:
     *  MATLABSystem: '<S2>/Base sensor block'
     * */
    Hauptprogramm_PJ_B.GyroMesswert_m = Hauptprogramm_PJ_P.Gain_Gain *
      Hauptprogramm_PJ_B.vprev;

    /* End of Outputs for SubSystem: '<Root>/MPU6050 IMU Sensor' */

    /* MATLABSystem: '<Root>/Median Filter' */
    obj = &Hauptprogramm_PJ_DW.obj_a.pMID;
    if (Hauptprogramm_PJ_DW.obj_a.pMID.isInitialized != 1L) {
      Hauptprogramm_PJ_DW.obj_a.pMID.isInitialized = 1L;
      Hauptprogramm_PJ_DW.obj_a.pMID.isSetupComplete = true;
      Hauptp_MedianFilterCG_resetImpl(&Hauptprogramm_PJ_DW.obj_a.pMID);
    }

    i = (int16_T)Hauptprogramm_PJ_DW.obj_a.pMID.pIdx - 1;
    Hauptprogramm_PJ_B.vprev = Hauptprogramm_PJ_DW.obj_a.pMID.pBuf[i];
    Hauptprogramm_PJ_DW.obj_a.pMID.pBuf[i] = Hauptprogramm_PJ_B.GyroMesswert_m;
    Hauptprogramm_PJ_B.p = Hauptprogramm_PJ_DW.obj_a.pMID.pPos[(int16_T)
      Hauptprogramm_PJ_DW.obj_a.pMID.pIdx - 1];
    Hauptprogramm_PJ_DW.obj_a.pMID.pIdx++;
    if (Hauptprogramm_PJ_DW.obj_a.pMID.pWinLen + 1.0 ==
        Hauptprogramm_PJ_DW.obj_a.pMID.pIdx) {
      Hauptprogramm_PJ_DW.obj_a.pMID.pIdx = 1.0;
    }

    if (Hauptprogramm_PJ_B.p > Hauptprogramm_PJ_DW.obj_a.pMID.pMidHeap) {
      if (Hauptprogramm_PJ_B.vprev < Hauptprogramm_PJ_B.GyroMesswert_m) {
        H_MedianFilterCG_trickleDownMin(&Hauptprogramm_PJ_DW.obj_a.pMID,
          (Hauptprogramm_PJ_B.p - Hauptprogramm_PJ_DW.obj_a.pMID.pMidHeap) * 2.0);
      } else {
        Hauptprogramm_PJ_B.vprev = Hauptprogramm_PJ_B.p -
          Hauptprogramm_PJ_DW.obj_a.pMID.pMidHeap;
        exitg1 = false;
        while ((!exitg1) && (Hauptprogramm_PJ_B.vprev > 0.0)) {
          Hauptprogramm_PJ_B.GyroMesswert_m = floor(Hauptprogramm_PJ_B.vprev /
            2.0);
          flag = (obj->pBuf[(int16_T)obj->pHeap[(int16_T)
                  (Hauptprogramm_PJ_B.vprev + obj->pMidHeap) - 1] - 1] <
                  obj->pBuf[(int16_T)obj->pHeap[(int16_T)
                  (Hauptprogramm_PJ_B.GyroMesswert_m + obj->pMidHeap) - 1] - 1]);
          if (!flag) {
            exitg1 = true;
          } else {
            Hauptprogramm_PJ_B.p = Hauptprogramm_PJ_B.vprev + obj->pMidHeap;
            Hauptprogramm_PJ_B.ind2 = Hauptprogramm_PJ_B.GyroMesswert_m +
              obj->pMidHeap;
            Hauptprogramm_PJ_B.temp = obj->pHeap[(int16_T)Hauptprogramm_PJ_B.p -
              1];
            obj->pHeap[(int16_T)Hauptprogramm_PJ_B.p - 1] = obj->pHeap[(int16_T)
              Hauptprogramm_PJ_B.ind2 - 1];
            obj->pHeap[(int16_T)Hauptprogramm_PJ_B.ind2 - 1] =
              Hauptprogramm_PJ_B.temp;
            obj->pPos[(int16_T)obj->pHeap[(int16_T)Hauptprogramm_PJ_B.p - 1] - 1]
              = Hauptprogramm_PJ_B.p;
            obj->pPos[(int16_T)obj->pHeap[(int16_T)Hauptprogramm_PJ_B.ind2 - 1]
              - 1] = Hauptprogramm_PJ_B.ind2;
            Hauptprogramm_PJ_B.vprev = floor(Hauptprogramm_PJ_B.vprev / 2.0);
          }
        }

        if (Hauptprogramm_PJ_B.vprev == 0.0) {
          H_MedianFilterCG_trickleDownMax(&Hauptprogramm_PJ_DW.obj_a.pMID, -1.0);
        }
      }
    } else if (Hauptprogramm_PJ_B.p < Hauptprogramm_PJ_DW.obj_a.pMID.pMidHeap) {
      if (Hauptprogramm_PJ_B.GyroMesswert_m < Hauptprogramm_PJ_B.vprev) {
        H_MedianFilterCG_trickleDownMax(&Hauptprogramm_PJ_DW.obj_a.pMID,
          (Hauptprogramm_PJ_B.p - Hauptprogramm_PJ_DW.obj_a.pMID.pMidHeap) * 2.0);
      } else {
        Hauptprogramm_PJ_B.vprev = Hauptprogramm_PJ_B.p -
          Hauptprogramm_PJ_DW.obj_a.pMID.pMidHeap;
        exitg1 = false;
        while ((!exitg1) && (Hauptprogramm_PJ_B.vprev < 0.0)) {
          Hauptprogramm_PJ_B.GyroMesswert_m = Hauptprogramm_PJ_B.vprev / 2.0;
          if (Hauptprogramm_PJ_B.GyroMesswert_m < 0.0) {
            Hauptprogramm_PJ_B.p = ceil(Hauptprogramm_PJ_B.GyroMesswert_m);
          } else {
            Hauptprogramm_PJ_B.p = -0.0;
          }

          flag = (obj->pBuf[(int16_T)obj->pHeap[(int16_T)(Hauptprogramm_PJ_B.p +
                   obj->pMidHeap) - 1] - 1] < obj->pBuf[(int16_T)obj->pHeap
                  [(int16_T)(Hauptprogramm_PJ_B.vprev + obj->pMidHeap) - 1] - 1]);
          if (!flag) {
            exitg1 = true;
          } else {
            if (Hauptprogramm_PJ_B.GyroMesswert_m < 0.0) {
              Hauptprogramm_PJ_B.p = ceil(Hauptprogramm_PJ_B.GyroMesswert_m);
            } else {
              Hauptprogramm_PJ_B.p = -0.0;
            }

            Hauptprogramm_PJ_B.p += obj->pMidHeap;
            Hauptprogramm_PJ_B.ind2 = Hauptprogramm_PJ_B.vprev + obj->pMidHeap;
            Hauptprogramm_PJ_B.temp = obj->pHeap[(int16_T)Hauptprogramm_PJ_B.p -
              1];
            obj->pHeap[(int16_T)Hauptprogramm_PJ_B.p - 1] = obj->pHeap[(int16_T)
              Hauptprogramm_PJ_B.ind2 - 1];
            obj->pHeap[(int16_T)Hauptprogramm_PJ_B.ind2 - 1] =
              Hauptprogramm_PJ_B.temp;
            obj->pPos[(int16_T)obj->pHeap[(int16_T)Hauptprogramm_PJ_B.p - 1] - 1]
              = Hauptprogramm_PJ_B.p;
            obj->pPos[(int16_T)obj->pHeap[(int16_T)Hauptprogramm_PJ_B.ind2 - 1]
              - 1] = Hauptprogramm_PJ_B.ind2;
            if (Hauptprogramm_PJ_B.GyroMesswert_m < 0.0) {
              Hauptprogramm_PJ_B.vprev = ceil(Hauptprogramm_PJ_B.GyroMesswert_m);
            } else {
              Hauptprogramm_PJ_B.vprev = -0.0;
            }
          }
        }

        if (Hauptprogramm_PJ_B.vprev == 0.0) {
          H_MedianFilterCG_trickleDownMin(&Hauptprogramm_PJ_DW.obj_a.pMID, 1.0);
        }
      }
    } else {
      if (Hauptprogramm_PJ_DW.obj_a.pMID.pMaxHeapLength != 0.0) {
        H_MedianFilterCG_trickleDownMax(&Hauptprogramm_PJ_DW.obj_a.pMID, -1.0);
      }

      if (Hauptprogramm_PJ_DW.obj_a.pMID.pMinHeapLength > 0.0) {
        H_MedianFilterCG_trickleDownMin(&Hauptprogramm_PJ_DW.obj_a.pMID, 1.0);
      }
    }

    Hauptprogramm_PJ_B.vprev = Hauptprogramm_PJ_DW.obj_a.pMID.pBuf[(int16_T)
      Hauptprogramm_PJ_DW.obj_a.pMID.pHeap[(int16_T)
      Hauptprogramm_PJ_DW.obj_a.pMID.pMidHeap - 1] - 1];

    /* Sum: '<Root>/Sum' incorporates:
     *  Constant: '<Root>/Gyro_Soll'
     *  MATLABSystem: '<Root>/Median Filter'
     */
    Hauptprogramm_PJ_B.Messabweichung = Hauptprogramm_PJ_P.Gyro_Soll_Value -
      Hauptprogramm_PJ_B.vprev;

    /* Gain: '<S3>/K_D' */
    Hauptprogramm_PJ_B.K_D = Hauptprogramm_PJ_P.K_D_Gain *
      Hauptprogramm_PJ_B.Messabweichung;

    /* Derivative: '<S3>/Ableitung' */
    Hauptprogramm_PJ_B.p = Hauptprogramm_PJ_M->Timing.t[0];
    if ((Hauptprogramm_PJ_DW.TimeStampA >= Hauptprogramm_PJ_B.p) &&
        (Hauptprogramm_PJ_DW.TimeStampB >= Hauptprogramm_PJ_B.p)) {
      Hauptprogramm_PJ_B.GyroMesswert_m = 0.0;
    } else {
      Hauptprogramm_PJ_B.vprev = Hauptprogramm_PJ_DW.TimeStampA;
      lastU = &Hauptprogramm_PJ_DW.LastUAtTimeA;
      if (Hauptprogramm_PJ_DW.TimeStampA < Hauptprogramm_PJ_DW.TimeStampB) {
        if (Hauptprogramm_PJ_DW.TimeStampB < Hauptprogramm_PJ_B.p) {
          Hauptprogramm_PJ_B.vprev = Hauptprogramm_PJ_DW.TimeStampB;
          lastU = &Hauptprogramm_PJ_DW.LastUAtTimeB;
        }
      } else if (Hauptprogramm_PJ_DW.TimeStampA >= Hauptprogramm_PJ_B.p) {
        Hauptprogramm_PJ_B.vprev = Hauptprogramm_PJ_DW.TimeStampB;
        lastU = &Hauptprogramm_PJ_DW.LastUAtTimeB;
      }

      Hauptprogramm_PJ_B.GyroMesswert_m = (Hauptprogramm_PJ_B.K_D - *lastU) /
        (Hauptprogramm_PJ_B.p - Hauptprogramm_PJ_B.vprev);
    }

    /* End of Derivative: '<S3>/Ableitung' */

    /* MATLABSystem: '<S3>/Median Filter' */
    obj = &Hauptprogramm_PJ_DW.obj.pMID;
    if (Hauptprogramm_PJ_DW.obj.pMID.isInitialized != 1L) {
      Hauptprogramm_PJ_DW.obj.pMID.isInitialized = 1L;
      Hauptprogramm_PJ_DW.obj.pMID.isSetupComplete = true;
      Hauptp_MedianFilterCG_resetImpl(&Hauptprogramm_PJ_DW.obj.pMID);
    }

    i = (int16_T)Hauptprogramm_PJ_DW.obj.pMID.pIdx - 1;
    Hauptprogramm_PJ_B.vprev = Hauptprogramm_PJ_DW.obj.pMID.pBuf[i];
    Hauptprogramm_PJ_DW.obj.pMID.pBuf[i] = Hauptprogramm_PJ_B.GyroMesswert_m;
    Hauptprogramm_PJ_B.p = Hauptprogramm_PJ_DW.obj.pMID.pPos[(int16_T)
      Hauptprogramm_PJ_DW.obj.pMID.pIdx - 1];
    Hauptprogramm_PJ_DW.obj.pMID.pIdx++;
    if (Hauptprogramm_PJ_DW.obj.pMID.pWinLen + 1.0 ==
        Hauptprogramm_PJ_DW.obj.pMID.pIdx) {
      Hauptprogramm_PJ_DW.obj.pMID.pIdx = 1.0;
    }

    if (Hauptprogramm_PJ_B.p > Hauptprogramm_PJ_DW.obj.pMID.pMidHeap) {
      if (Hauptprogramm_PJ_B.vprev < Hauptprogramm_PJ_B.GyroMesswert_m) {
        H_MedianFilterCG_trickleDownMin(&Hauptprogramm_PJ_DW.obj.pMID,
          (Hauptprogramm_PJ_B.p - Hauptprogramm_PJ_DW.obj.pMID.pMidHeap) * 2.0);
      } else {
        Hauptprogramm_PJ_B.vprev = Hauptprogramm_PJ_B.p -
          Hauptprogramm_PJ_DW.obj.pMID.pMidHeap;
        exitg1 = false;
        while ((!exitg1) && (Hauptprogramm_PJ_B.vprev > 0.0)) {
          Hauptprogramm_PJ_B.GyroMesswert_m = floor(Hauptprogramm_PJ_B.vprev /
            2.0);
          flag = (obj->pBuf[(int16_T)obj->pHeap[(int16_T)
                  (Hauptprogramm_PJ_B.vprev + obj->pMidHeap) - 1] - 1] <
                  obj->pBuf[(int16_T)obj->pHeap[(int16_T)
                  (Hauptprogramm_PJ_B.GyroMesswert_m + obj->pMidHeap) - 1] - 1]);
          if (!flag) {
            exitg1 = true;
          } else {
            Hauptprogramm_PJ_B.p = Hauptprogramm_PJ_B.vprev + obj->pMidHeap;
            Hauptprogramm_PJ_B.ind2 = Hauptprogramm_PJ_B.GyroMesswert_m +
              obj->pMidHeap;
            Hauptprogramm_PJ_B.temp = obj->pHeap[(int16_T)Hauptprogramm_PJ_B.p -
              1];
            obj->pHeap[(int16_T)Hauptprogramm_PJ_B.p - 1] = obj->pHeap[(int16_T)
              Hauptprogramm_PJ_B.ind2 - 1];
            obj->pHeap[(int16_T)Hauptprogramm_PJ_B.ind2 - 1] =
              Hauptprogramm_PJ_B.temp;
            obj->pPos[(int16_T)obj->pHeap[(int16_T)Hauptprogramm_PJ_B.p - 1] - 1]
              = Hauptprogramm_PJ_B.p;
            obj->pPos[(int16_T)obj->pHeap[(int16_T)Hauptprogramm_PJ_B.ind2 - 1]
              - 1] = Hauptprogramm_PJ_B.ind2;
            Hauptprogramm_PJ_B.vprev = floor(Hauptprogramm_PJ_B.vprev / 2.0);
          }
        }

        if (Hauptprogramm_PJ_B.vprev == 0.0) {
          H_MedianFilterCG_trickleDownMax(&Hauptprogramm_PJ_DW.obj.pMID, -1.0);
        }
      }
    } else if (Hauptprogramm_PJ_B.p < Hauptprogramm_PJ_DW.obj.pMID.pMidHeap) {
      if (Hauptprogramm_PJ_B.GyroMesswert_m < Hauptprogramm_PJ_B.vprev) {
        H_MedianFilterCG_trickleDownMax(&Hauptprogramm_PJ_DW.obj.pMID,
          (Hauptprogramm_PJ_B.p - Hauptprogramm_PJ_DW.obj.pMID.pMidHeap) * 2.0);
      } else {
        Hauptprogramm_PJ_B.vprev = Hauptprogramm_PJ_B.p -
          Hauptprogramm_PJ_DW.obj.pMID.pMidHeap;
        exitg1 = false;
        while ((!exitg1) && (Hauptprogramm_PJ_B.vprev < 0.0)) {
          Hauptprogramm_PJ_B.GyroMesswert_m = Hauptprogramm_PJ_B.vprev / 2.0;
          if (Hauptprogramm_PJ_B.GyroMesswert_m < 0.0) {
            Hauptprogramm_PJ_B.p = ceil(Hauptprogramm_PJ_B.GyroMesswert_m);
          } else {
            Hauptprogramm_PJ_B.p = -0.0;
          }

          flag = (obj->pBuf[(int16_T)obj->pHeap[(int16_T)(Hauptprogramm_PJ_B.p +
                   obj->pMidHeap) - 1] - 1] < obj->pBuf[(int16_T)obj->pHeap
                  [(int16_T)(Hauptprogramm_PJ_B.vprev + obj->pMidHeap) - 1] - 1]);
          if (!flag) {
            exitg1 = true;
          } else {
            if (Hauptprogramm_PJ_B.GyroMesswert_m < 0.0) {
              Hauptprogramm_PJ_B.p = ceil(Hauptprogramm_PJ_B.GyroMesswert_m);
            } else {
              Hauptprogramm_PJ_B.p = -0.0;
            }

            Hauptprogramm_PJ_B.p += obj->pMidHeap;
            Hauptprogramm_PJ_B.ind2 = Hauptprogramm_PJ_B.vprev + obj->pMidHeap;
            Hauptprogramm_PJ_B.temp = obj->pHeap[(int16_T)Hauptprogramm_PJ_B.p -
              1];
            obj->pHeap[(int16_T)Hauptprogramm_PJ_B.p - 1] = obj->pHeap[(int16_T)
              Hauptprogramm_PJ_B.ind2 - 1];
            obj->pHeap[(int16_T)Hauptprogramm_PJ_B.ind2 - 1] =
              Hauptprogramm_PJ_B.temp;
            obj->pPos[(int16_T)obj->pHeap[(int16_T)Hauptprogramm_PJ_B.p - 1] - 1]
              = Hauptprogramm_PJ_B.p;
            obj->pPos[(int16_T)obj->pHeap[(int16_T)Hauptprogramm_PJ_B.ind2 - 1]
              - 1] = Hauptprogramm_PJ_B.ind2;
            if (Hauptprogramm_PJ_B.GyroMesswert_m < 0.0) {
              Hauptprogramm_PJ_B.vprev = ceil(Hauptprogramm_PJ_B.GyroMesswert_m);
            } else {
              Hauptprogramm_PJ_B.vprev = -0.0;
            }
          }
        }

        if (Hauptprogramm_PJ_B.vprev == 0.0) {
          H_MedianFilterCG_trickleDownMin(&Hauptprogramm_PJ_DW.obj.pMID, 1.0);
        }
      }
    } else {
      if (Hauptprogramm_PJ_DW.obj.pMID.pMaxHeapLength != 0.0) {
        H_MedianFilterCG_trickleDownMax(&Hauptprogramm_PJ_DW.obj.pMID, -1.0);
      }

      if (Hauptprogramm_PJ_DW.obj.pMID.pMinHeapLength > 0.0) {
        H_MedianFilterCG_trickleDownMin(&Hauptprogramm_PJ_DW.obj.pMID, 1.0);
      }
    }

    /* MATLABSystem: '<S3>/Median Filter' */
    Hauptprogramm_PJ_B.GyroMesswert = Hauptprogramm_PJ_DW.obj.pMID.pBuf[(int16_T)
      Hauptprogramm_PJ_DW.obj.pMID.pHeap[(int16_T)
      Hauptprogramm_PJ_DW.obj.pMID.pMidHeap - 1] - 1];

    /* Abs: '<Root>/Abs' incorporates:
     *  Gain: '<S3>/K_P'
     *  Integrator: '<S3>/Integrator1'
     *  Sum: '<S3>/Sum1'
     */
    Hauptprogramm_PJ_B.PWMSignal = fabs((Hauptprogramm_PJ_P.K_P_Gain *
      Hauptprogramm_PJ_B.Messabweichung + Hauptprogramm_PJ_X.Integrator1_CSTATE)
      + Hauptprogramm_PJ_B.GyroMesswert);

    /* Saturate: '<Root>/Saturation' */
    if (Hauptprogramm_PJ_B.PWMSignal > Hauptprogramm_PJ_P.Saturation_UpperSat) {
      /* Abs: '<Root>/Abs' incorporates:
       *  Saturate: '<Root>/Saturation'
       */
      Hauptprogramm_PJ_B.PWMSignal = Hauptprogramm_PJ_P.Saturation_UpperSat;
    } else if (Hauptprogramm_PJ_B.PWMSignal <
               Hauptprogramm_PJ_P.Saturation_LowerSat) {
      /* Abs: '<Root>/Abs' incorporates:
       *  Saturate: '<Root>/Saturation'
       */
      Hauptprogramm_PJ_B.PWMSignal = Hauptprogramm_PJ_P.Saturation_LowerSat;
    }

    /* End of Saturate: '<Root>/Saturation' */

    /* S-Function (MotorDriverSF): '<Root>/Motor PWM' */
    MotorDriverSF_Outputs_wrapper_cgen(&Hauptprogramm_PJ_B.PWMSignal,
      &Hauptprogramm_PJ_DW.MotorPWM_DSTATE);
    if (rtmIsMajorTimeStep(Hauptprogramm_PJ_M)) {
      /* Constant: '<Root>/Constant' */
      Hauptprogramm_PJ_B.Constant = Hauptprogramm_PJ_P.Constant_Value;
    }

    /* If: '<S1>/If' */
    rtAction = -1;
    if (rtsiIsModeUpdateTimeStep(&Hauptprogramm_PJ_M->solverInfo)) {
      if (Hauptprogramm_PJ_B.Messabweichung > 0.0) {
        rtAction = 0;
      } else if (Hauptprogramm_PJ_B.Messabweichung < 0.0) {
        rtAction = 1;
      }

      Hauptprogramm_PJ_DW.If_ActiveSubsystem = rtAction;
    } else {
      rtAction = Hauptprogramm_PJ_DW.If_ActiveSubsystem;
    }

    switch (rtAction) {
     case 0:
      /* Outputs for IfAction SubSystem: '<S1>/If Action Subsystem' incorporates:
       *  ActionPort: '<S4>/Action Port'
       */
      if (rtmIsMajorTimeStep(Hauptprogramm_PJ_M)) {
        /* Merge: '<S1>/Merge' incorporates:
         *  Constant: '<S1>/Constant2'
         *  SignalConversion generated from: '<S4>/In1'
         */
        Hauptprogramm_PJ_B.Drehrichtung = Hauptprogramm_PJ_P.Constant2_Value;
      }

      if (rtsiIsModeUpdateTimeStep(&Hauptprogramm_PJ_M->solverInfo)) {
        srUpdateBC(Hauptprogramm_PJ_DW.IfActionSubsystem_SubsysRanBC);
      }

      /* End of Outputs for SubSystem: '<S1>/If Action Subsystem' */
      break;

     case 1:
      /* Outputs for IfAction SubSystem: '<S1>/If Action Subsystem1' incorporates:
       *  ActionPort: '<S5>/Action Port'
       */
      if (rtmIsMajorTimeStep(Hauptprogramm_PJ_M)) {
        /* Merge: '<S1>/Merge' incorporates:
         *  Constant: '<S1>/Constant1'
         *  SignalConversion generated from: '<S5>/In1'
         */
        Hauptprogramm_PJ_B.Drehrichtung = Hauptprogramm_PJ_P.Constant1_Value;
      }

      if (rtsiIsModeUpdateTimeStep(&Hauptprogramm_PJ_M->solverInfo)) {
        srUpdateBC(Hauptprogramm_PJ_DW.IfActionSubsystem1_SubsysRanBC);
      }

      /* End of Outputs for SubSystem: '<S1>/If Action Subsystem1' */
      break;
    }

    /* End of If: '<S1>/If' */
    if (rtmIsMajorTimeStep(Hauptprogramm_PJ_M)) {
      /* MATLABSystem: '<Root>/Bremse' */
      Hauptprogramm_PJ_B.p = rt_roundd_snf(Hauptprogramm_PJ_B.Constant);
      if (Hauptprogramm_PJ_B.p < 256.0) {
        if (Hauptprogramm_PJ_B.p >= 0.0) {
          status = (uint8_T)Hauptprogramm_PJ_B.p;
        } else {
          status = 0U;
        }
      } else {
        status = MAX_uint8_T;
      }

      writeDigitalPin(10, status);

      /* End of MATLABSystem: '<Root>/Bremse' */
    }

    /* Gain: '<S3>/K_I' */
    Hauptprogramm_PJ_B.K_I = Hauptprogramm_PJ_P.K_I_Gain *
      Hauptprogramm_PJ_B.Messabweichung;
    if (rtmIsMajorTimeStep(Hauptprogramm_PJ_M)) {
      /* MATLABSystem: '<S1>/Drehrichtung' */
      Hauptprogramm_PJ_B.p = rt_roundd_snf(Hauptprogramm_PJ_B.Drehrichtung);
      if (Hauptprogramm_PJ_B.p < 256.0) {
        if (Hauptprogramm_PJ_B.p >= 0.0) {
          status = (uint8_T)Hauptprogramm_PJ_B.p;
        } else {
          status = 0U;
        }
      } else {
        status = MAX_uint8_T;
      }

      writeDigitalPin(11, status);

      /* End of MATLABSystem: '<S1>/Drehrichtung' */
    }
  }

  if (rtmIsMajorTimeStep(Hauptprogramm_PJ_M)) {
    real_T *lastU;

    /* Update for Derivative: '<S3>/Ableitung' */
    if (Hauptprogramm_PJ_DW.TimeStampA == (rtInf)) {
      Hauptprogramm_PJ_DW.TimeStampA = Hauptprogramm_PJ_M->Timing.t[0];
      lastU = &Hauptprogramm_PJ_DW.LastUAtTimeA;
    } else if (Hauptprogramm_PJ_DW.TimeStampB == (rtInf)) {
      Hauptprogramm_PJ_DW.TimeStampB = Hauptprogramm_PJ_M->Timing.t[0];
      lastU = &Hauptprogramm_PJ_DW.LastUAtTimeB;
    } else if (Hauptprogramm_PJ_DW.TimeStampA < Hauptprogramm_PJ_DW.TimeStampB)
    {
      Hauptprogramm_PJ_DW.TimeStampA = Hauptprogramm_PJ_M->Timing.t[0];
      lastU = &Hauptprogramm_PJ_DW.LastUAtTimeA;
    } else {
      Hauptprogramm_PJ_DW.TimeStampB = Hauptprogramm_PJ_M->Timing.t[0];
      lastU = &Hauptprogramm_PJ_DW.LastUAtTimeB;
    }

    *lastU = Hauptprogramm_PJ_B.K_D;

    /* End of Update for Derivative: '<S3>/Ableitung' */

    /* Update for S-Function (MotorDriverSF): '<Root>/Motor PWM' */

    /* S-Function "MotorDriverSF_wrapper" Block: <Root>/Motor PWM */
    MotorDriverSF_Update_wrapper_cgen(&Hauptprogramm_PJ_B.PWMSignal,
      &Hauptprogramm_PJ_DW.MotorPWM_DSTATE);

    {                                  /* Sample time: [0.0s, 0.0s] */
      extmodeErrorCode_T errorCode = EXTMODE_SUCCESS;
      extmodeSimulationTime_T currentTime = (extmodeSimulationTime_T)
        ((Hauptprogramm_PJ_M->Timing.clockTick0 * 1) + 0)
        ;

      /* Trigger External Mode event */
      errorCode = extmodeEvent(0,currentTime);
      if (errorCode != EXTMODE_SUCCESS) {
        /* Code to handle External Mode event errors
           may be added here */
      }
    }

    if (rtmIsMajorTimeStep(Hauptprogramm_PJ_M)) {/* Sample time: [0.2s, 0.0s] */
      extmodeErrorCode_T errorCode = EXTMODE_SUCCESS;
      extmodeSimulationTime_T currentTime = (extmodeSimulationTime_T)
        ((Hauptprogramm_PJ_M->Timing.clockTick1 * 1) + 0)
        ;

      /* Trigger External Mode event */
      errorCode = extmodeEvent(1,currentTime);
      if (errorCode != EXTMODE_SUCCESS) {
        /* Code to handle External Mode event errors
           may be added here */
      }
    }
  }                                    /* end MajorTimeStep */

  if (rtmIsMajorTimeStep(Hauptprogramm_PJ_M)) {
    rt_ertODEUpdateContinuousStates(&Hauptprogramm_PJ_M->solverInfo);

    /* Update absolute time for base rate */
    /* The "clockTick0" counts the number of times the code of this task has
     * been executed. The absolute time is the multiplication of "clockTick0"
     * and "Timing.stepSize0". Size of "clockTick0" ensures timer will not
     * overflow during the application lifespan selected.
     */
    ++Hauptprogramm_PJ_M->Timing.clockTick0;
    Hauptprogramm_PJ_M->Timing.t[0] = rtsiGetSolverStopTime
      (&Hauptprogramm_PJ_M->solverInfo);

    {
      /* Update absolute timer for sample time: [0.2s, 0.0s] */
      /* The "clockTick1" counts the number of times the code of this task has
       * been executed. The resolution of this integer timer is 0.2, which is the step size
       * of the task. Size of "clockTick1" ensures timer will not overflow during the
       * application lifespan selected.
       */
      Hauptprogramm_PJ_M->Timing.clockTick1++;
    }
  }                                    /* end MajorTimeStep */
}

/* Derivatives for root system: '<Root>' */
void Hauptprogramm_PJ_derivatives(void)
{
  XDot_Hauptprogramm_PJ_T *_rtXdot;
  _rtXdot = ((XDot_Hauptprogramm_PJ_T *) Hauptprogramm_PJ_M->derivs);

  /* Derivatives for Integrator: '<S3>/Integrator1' */
  _rtXdot->Integrator1_CSTATE = Hauptprogramm_PJ_B.K_I;
}

/* Model initialize function */
void Hauptprogramm_PJ_initialize(void)
{
  /* Registration code */

  /* initialize non-finites */
  rt_InitInfAndNaN(sizeof(real_T));

  {
    /* Setup solver object */
    rtsiSetSimTimeStepPtr(&Hauptprogramm_PJ_M->solverInfo,
                          &Hauptprogramm_PJ_M->Timing.simTimeStep);
    rtsiSetTPtr(&Hauptprogramm_PJ_M->solverInfo, &rtmGetTPtr(Hauptprogramm_PJ_M));
    rtsiSetStepSizePtr(&Hauptprogramm_PJ_M->solverInfo,
                       &Hauptprogramm_PJ_M->Timing.stepSize0);
    rtsiSetdXPtr(&Hauptprogramm_PJ_M->solverInfo, &Hauptprogramm_PJ_M->derivs);
    rtsiSetContStatesPtr(&Hauptprogramm_PJ_M->solverInfo, (real_T **)
                         &Hauptprogramm_PJ_M->contStates);
    rtsiSetNumContStatesPtr(&Hauptprogramm_PJ_M->solverInfo,
      &Hauptprogramm_PJ_M->Sizes.numContStates);
    rtsiSetNumPeriodicContStatesPtr(&Hauptprogramm_PJ_M->solverInfo,
      &Hauptprogramm_PJ_M->Sizes.numPeriodicContStates);
    rtsiSetPeriodicContStateIndicesPtr(&Hauptprogramm_PJ_M->solverInfo,
      &Hauptprogramm_PJ_M->periodicContStateIndices);
    rtsiSetPeriodicContStateRangesPtr(&Hauptprogramm_PJ_M->solverInfo,
      &Hauptprogramm_PJ_M->periodicContStateRanges);
    rtsiSetContStateDisabledPtr(&Hauptprogramm_PJ_M->solverInfo, (boolean_T**)
      &Hauptprogramm_PJ_M->contStateDisabled);
    rtsiSetErrorStatusPtr(&Hauptprogramm_PJ_M->solverInfo, (&rtmGetErrorStatus
      (Hauptprogramm_PJ_M)));
    rtsiSetRTModelPtr(&Hauptprogramm_PJ_M->solverInfo, Hauptprogramm_PJ_M);
  }

  rtsiSetSimTimeStep(&Hauptprogramm_PJ_M->solverInfo, MAJOR_TIME_STEP);
  Hauptprogramm_PJ_M->intgData.y = Hauptprogramm_PJ_M->odeY;
  Hauptprogramm_PJ_M->intgData.f[0] = Hauptprogramm_PJ_M->odeF[0];
  Hauptprogramm_PJ_M->intgData.f[1] = Hauptprogramm_PJ_M->odeF[1];
  Hauptprogramm_PJ_M->intgData.f[2] = Hauptprogramm_PJ_M->odeF[2];
  Hauptprogramm_PJ_M->contStates = ((X_Hauptprogramm_PJ_T *) &Hauptprogramm_PJ_X);
  Hauptprogramm_PJ_M->contStateDisabled = ((XDis_Hauptprogramm_PJ_T *)
    &Hauptprogramm_PJ_XDis);
  Hauptprogramm_PJ_M->Timing.tStart = (0.0);
  rtsiSetSolverData(&Hauptprogramm_PJ_M->solverInfo, (void *)
                    &Hauptprogramm_PJ_M->intgData);
  rtsiSetIsMinorTimeStepWithModeChange(&Hauptprogramm_PJ_M->solverInfo, false);
  rtsiSetSolverName(&Hauptprogramm_PJ_M->solverInfo,"ode3");
  rtmSetTPtr(Hauptprogramm_PJ_M, &Hauptprogramm_PJ_M->Timing.tArray[0]);
  rtmSetTFinal(Hauptprogramm_PJ_M, -1);
  Hauptprogramm_PJ_M->Timing.stepSize0 = 0.2;

  /* External mode info */
  Hauptprogramm_PJ_M->Sizes.checksums[0] = (3721434041U);
  Hauptprogramm_PJ_M->Sizes.checksums[1] = (3893627350U);
  Hauptprogramm_PJ_M->Sizes.checksums[2] = (3600443868U);
  Hauptprogramm_PJ_M->Sizes.checksums[3] = (2071228939U);

  {
    static const sysRanDType rtAlwaysEnabled = SUBSYS_RAN_BC_ENABLE;
    static RTWExtModeInfo rt_ExtModeInfo;
    static const sysRanDType *systemRan[9];
    Hauptprogramm_PJ_M->extModeInfo = (&rt_ExtModeInfo);
    rteiSetSubSystemActiveVectorAddresses(&rt_ExtModeInfo, systemRan);
    systemRan[0] = &rtAlwaysEnabled;
    systemRan[1] = &rtAlwaysEnabled;
    systemRan[2] = (sysRanDType *)
      &Hauptprogramm_PJ_DW.IfActionSubsystem_SubsysRanBC;
    systemRan[3] = (sysRanDType *)
      &Hauptprogramm_PJ_DW.IfActionSubsystem1_SubsysRanBC;
    systemRan[4] = &rtAlwaysEnabled;
    systemRan[5] = &rtAlwaysEnabled;
    systemRan[6] = &rtAlwaysEnabled;
    systemRan[7] = &rtAlwaysEnabled;
    systemRan[8] = &rtAlwaysEnabled;
    rteiSetModelMappingInfoPtr(Hauptprogramm_PJ_M->extModeInfo,
      &Hauptprogramm_PJ_M->SpecialInfo.mappingInfo);
    rteiSetChecksumsPtr(Hauptprogramm_PJ_M->extModeInfo,
                        Hauptprogramm_PJ_M->Sizes.checksums);
    rteiSetTPtr(Hauptprogramm_PJ_M->extModeInfo, rtmGetTPtr(Hauptprogramm_PJ_M));
  }

  /* Start for S-Function (MotorDriverSF): '<Root>/Motor PWM' */

  /* S-Function Block: <Root>/Motor PWM */
  MotorDriverSF_Start_wrapper_cgen(&Hauptprogramm_PJ_DW.MotorPWM_DSTATE);

  /* Start for If: '<S1>/If' */
  Hauptprogramm_PJ_DW.If_ActiveSubsystem = -1;

  /* InitializeConditions for Integrator: '<S3>/Integrator1' */
  Hauptprogramm_PJ_X.Integrator1_CSTATE = Hauptprogramm_PJ_P.Integrator1_IC;

  /* InitializeConditions for Derivative: '<S3>/Ableitung' */
  Hauptprogramm_PJ_DW.TimeStampA = (rtInf);
  Hauptprogramm_PJ_DW.TimeStampB = (rtInf);

  /* InitializeConditions for S-Function (MotorDriverSF): '<Root>/Motor PWM' */

  /* S-Function Block: <Root>/Motor PWM */
  {
    real_T initVector[1] = { 0 };

    {
      int_T i1;
      for (i1=0; i1 < 1; i1++) {
        Hauptprogramm_PJ_DW.MotorPWM_DSTATE = initVector[0];
      }
    }
  }

  /* SystemInitialize for Atomic SubSystem: '<Root>/MPU6050 IMU Sensor' */
  /* Start for MATLABSystem: '<S2>/Base sensor block' */
  Hauptprogramm_PJ_DW.obj_c.i2cObjmpu.matlabCodegenIsDeleted = true;
  Hauptprogramm_PJ_DW.obj_c.matlabCodegenIsDeleted = true;
  H_arduinoMPU6050_arduinoMPU6050(&Hauptprogramm_PJ_DW.obj_c);

  /* Start for Atomic SubSystem: '<Root>/MPU6050 IMU Sensor' */
  Hauptprogramm_PJ_DW.obj_c.SampleTime =
    Hauptprogramm_PJ_P.MPU6050IMUSensor_SampleTime;

  /* End of Start for SubSystem: '<Root>/MPU6050 IMU Sensor' */
  Hauptprogramm__SystemCore_setup(&Hauptprogramm_PJ_DW.obj_c);

  /* End of SystemInitialize for SubSystem: '<Root>/MPU6050 IMU Sensor' */

  /* SystemInitialize for Merge: '<S1>/Merge' */
  Hauptprogramm_PJ_B.Drehrichtung = Hauptprogramm_PJ_P.Merge_InitialOutput;

  /* Start for MATLABSystem: '<Root>/Median Filter' */
  Hauptprogramm_PJ_DW.obj_a.matlabCodegenIsDeleted = false;
  Hauptprogramm_PJ_DW.obj_a.isInitialized = 1L;
  Hauptprogramm_PJ_DW.obj_a.NumChannels = 1L;
  Hauptprogramm_PJ_DW.obj_a.pMID.isInitialized = 0L;
  Hauptprogramm_PJ_DW.obj_a.isSetupComplete = true;

  /* Start for MATLABSystem: '<S3>/Median Filter' */
  Hauptprogramm_PJ_DW.obj.matlabCodegenIsDeleted = false;
  Hauptprogramm_PJ_DW.obj.isInitialized = 1L;
  Hauptprogramm_PJ_DW.obj.NumChannels = 1L;
  Hauptprogramm_PJ_DW.obj.pMID.isInitialized = 0L;
  Hauptprogramm_PJ_DW.obj.isSetupComplete = true;

  /* Start for MATLABSystem: '<Root>/Bremse' */
  Hauptprogramm_PJ_DW.obj_g.matlabCodegenIsDeleted = false;
  Hauptprogramm_PJ_DW.obj_g.isInitialized = 1L;
  digitalIOSetup(10, 1);
  Hauptprogramm_PJ_DW.obj_g.isSetupComplete = true;

  /* Start for MATLABSystem: '<S1>/Drehrichtung' */
  Hauptprogramm_PJ_DW.obj_l.matlabCodegenIsDeleted = false;
  Hauptprogramm_PJ_DW.obj_l.isInitialized = 1L;
  digitalIOSetup(11, 1);
  Hauptprogramm_PJ_DW.obj_l.isSetupComplete = true;
}

/* Model terminate function */
void Hauptprogramm_PJ_terminate(void)
{
  l_codertarget_arduinobase_int_T *obj;

  /* Terminate for Atomic SubSystem: '<Root>/MPU6050 IMU Sensor' */
  /* Terminate for MATLABSystem: '<S2>/Base sensor block' */
  if (!Hauptprogramm_PJ_DW.obj_c.matlabCodegenIsDeleted) {
    Hauptprogramm_PJ_DW.obj_c.matlabCodegenIsDeleted = true;
    if ((Hauptprogramm_PJ_DW.obj_c.isInitialized == 1L) &&
        Hauptprogramm_PJ_DW.obj_c.isSetupComplete) {
      obj = &Hauptprogramm_PJ_DW.obj_c.i2cObjmpu;
      MW_I2C_Close(obj->I2CDriverObj.MW_I2C_HANDLE);
    }
  }

  obj = &Hauptprogramm_PJ_DW.obj_c.i2cObjmpu;
  if (!obj->matlabCodegenIsDeleted) {
    obj->matlabCodegenIsDeleted = true;
    if (obj->isInitialized == 1L) {
      obj->isInitialized = 2L;
    }
  }

  /* End of Terminate for MATLABSystem: '<S2>/Base sensor block' */
  /* End of Terminate for SubSystem: '<Root>/MPU6050 IMU Sensor' */

  /* Terminate for MATLABSystem: '<Root>/Median Filter' */
  if (!Hauptprogramm_PJ_DW.obj_a.matlabCodegenIsDeleted) {
    Hauptprogramm_PJ_DW.obj_a.matlabCodegenIsDeleted = true;
    if ((Hauptprogramm_PJ_DW.obj_a.isInitialized == 1L) &&
        Hauptprogramm_PJ_DW.obj_a.isSetupComplete) {
      Hauptprogramm_PJ_DW.obj_a.NumChannels = -1L;
      if (Hauptprogramm_PJ_DW.obj_a.pMID.isInitialized == 1L) {
        Hauptprogramm_PJ_DW.obj_a.pMID.isInitialized = 2L;
      }
    }
  }

  /* End of Terminate for MATLABSystem: '<Root>/Median Filter' */

  /* Terminate for MATLABSystem: '<S3>/Median Filter' */
  if (!Hauptprogramm_PJ_DW.obj.matlabCodegenIsDeleted) {
    Hauptprogramm_PJ_DW.obj.matlabCodegenIsDeleted = true;
    if ((Hauptprogramm_PJ_DW.obj.isInitialized == 1L) &&
        Hauptprogramm_PJ_DW.obj.isSetupComplete) {
      Hauptprogramm_PJ_DW.obj.NumChannels = -1L;
      if (Hauptprogramm_PJ_DW.obj.pMID.isInitialized == 1L) {
        Hauptprogramm_PJ_DW.obj.pMID.isInitialized = 2L;
      }
    }
  }

  /* End of Terminate for MATLABSystem: '<S3>/Median Filter' */

  /* Terminate for MATLABSystem: '<Root>/Bremse' */
  if (!Hauptprogramm_PJ_DW.obj_g.matlabCodegenIsDeleted) {
    Hauptprogramm_PJ_DW.obj_g.matlabCodegenIsDeleted = true;
  }

  /* End of Terminate for MATLABSystem: '<Root>/Bremse' */
  /* Terminate for MATLABSystem: '<S1>/Drehrichtung' */
  if (!Hauptprogramm_PJ_DW.obj_l.matlabCodegenIsDeleted) {
    Hauptprogramm_PJ_DW.obj_l.matlabCodegenIsDeleted = true;
  }

  /* End of Terminate for MATLABSystem: '<S1>/Drehrichtung' */
}

/*
 * File trailer for generated code.
 *
 * [EOF]
 */
