%**************************************************************************
%                   Hochschule Hamm-Lippstadt                             *
%**************************************************************************
% Modul	          : Grove_Water_Sensor_MATLAB                             *
%                                                                         *
% Datum           : 25. Juli 2024                                         *
%                                                                         *
% Funktion        : Berechnung des Mess und Vertrauensbereich             *
%                   des Grove-Water-Sensor                                *
%                                                                         *
% Implementation  : MATLAB 2023b                                          *
%                                                                         *
% Req. Toolbox    :                                                       *
%                                                                         *
% Author          : Denim Hilz                                            *
%                                                                         *
% Bemerkung       :                                                       *
%                                                                         *
% Letzte Änderung : 25-07-2024                                            *
%                                                                         *
%**************************************************************************
%% open('Grove_Water_Sensor')

%% Script überarbeiten

%% Daten aus Simulink extrahieren
Spannung = Spannung_gefiltert;
Messwerte = length(Spannung)

%% Berechnung der Standardunsicherheit

% Mittelwert und Standardabweichung
mS = mean(Spannung);        % Mittelwert
sE = std(Spannung);         %Standardabweichung

% Berechnen der Standardunsicherheit Typ A
alpha = 1 - 0.6827;         % Messunsicherheit mit 68,27% Prozent Aussagesicherheit, da Messtechnnik
p = 1 - (alpha / 2);
t = tinv(p, Messwerte - 1);
uA = sE * t / sqrt(Messwerte);

% Werte des Microprozessors Atmega328p
Uref = 5;                       % Referenzspannung
Aufloesung = 10;                % Auflösung des Atmega328p
Ulsb = Uref / (2^Aufloesung-1)

% Standardunsicherheit Typ B
uB = Ulsb / sqrt(3) 

% Berechnen der Standardunsicherheit Typ C
uC = sqrt(uA^2 + uB^2)  

% Vertrauenfaktor
k = 2;              % Vertrauensniveau 0.9545

% Berechnen der Messunsicherheit 
uAbs = k * uC       % absolute Messunsicherheit 
uRel = 100*(uAbs/mS)  % relative Messunsicherheit

% Vollständiges Messergebnis ausgeben
disp(['Vollständige Messergebnis: U = ', num2str(mS), ' ± ', num2str(uAbs), ' V ']);

h = figure;
set(h, 'Name', 'Ergebnisdarstellung', 'NumberTitle', 'off');
xlabel('Anzahl der Messwerte')
ylabel('Spannung in V')
hold on

p1 = plot(Spannung,'r.-');
p2 = yline(mS, 'LineWidth', 2);
p3 = yline(mS + uC, 'Color', 'blue');
p4 = yline(mS - uC, 'Color', 'blue');
title(['Messergebnis: Mittelwert = ', num2str(mS), ' \pm ', num2str(sE), ' V, Spannung = ', num2str(mean(Spannung)), ' \pm ', num2str(uRel), '%'])

% Legende einfügen
h = legend([p1, p2, p3], "Messwerte", "Mittelwert", "Unsicherheit Typ C", 'Location', 'northeast');
hold off