var dataJson = {"arch":{"ispc":true,"isunix":false,"ismac":false},"build":"Abstandsensor","ref":false,"files":[{"name":"ert_main.c","type":"source","group":"main","path":"C:\\Users\\Sophie\\Documents\\Hochschule\\Master\\Semester 2\\Praktikum\\Versuche\\Projekte\\172-184\\184_Das_Geheimnis_der_Feder\\Abstandsensor_ert_rtw","tag":"","groupDisplay":"Main file","code":"/*\r\n * ert_main.c\r\n *\r\n * Academic License - for use in teaching, academic research, and meeting\r\n * course requirements at degree granting institutions only.  Not for\r\n * government, commercial, or other organizational use.\r\n *\r\n * Code generation for model \"Abstandsensor\".\r\n *\r\n * Model version              : 10.15\r\n * Simulink Coder version : 24.1 (R2024a) 19-Nov-2023\r\n * C source code generated on : Mon Jan 13 17:19:51 2025\r\n *\r\n * Target selection: ert.tlc\r\n * Embedded hardware selection: Atmel->AVR\r\n * Code generation objectives: Unspecified\r\n * Validation result: Not run\r\n */\r\n\r\n#include \"Abstandsensor.h\"\r\n#include \"rtwtypes.h\"\r\n#include \"xcp.h\"\r\n#include \"ext_mode.h\"\r\n#include \"MW_target_hardware_resources.h\"\r\n\r\nvolatile int IsrOverrun = 0;\r\nstatic boolean_T OverrunFlag = 0;\r\nvoid rt_OneStep(void)\r\n{\r\n  extmodeSimulationTime_T currentTime = (extmodeSimulationTime_T) 0;\r\n\r\n  /* Check for overrun. Protect OverrunFlag against preemption */\r\n  if (OverrunFlag++) {\r\n    IsrOverrun = 1;\r\n    OverrunFlag--;\r\n    return;\r\n  }\r\n\r\n#ifndef _MW_ARDUINO_LOOP_\r\n\r\n  sei();\r\n\r\n#endif;\r\n\r\n  currentTime = (extmodeSimulationTime_T) (Abstandsensor_M->Timing.clockTick0+\r\n    Abstandsensor_M->Timing.clockTickH0* 4294967296.0);\r\n  Abstandsensor_step();\r\n\r\n  /* Get model outputs here */\r\n\r\n  /* Trigger External Mode event */\r\n  extmodeEvent(0, currentTime);\r\n\r\n#ifndef _MW_ARDUINO_LOOP_\r\n\r\n  cli();\r\n\r\n#endif;\r\n\r\n  OverrunFlag--;\r\n}\r\n\r\nextern void rtIOStreamResync();\r\nvolatile boolean_T stopRequested;\r\nvolatile boolean_T runModel;\r\nint main(void)\r\n{\r\n  float modelBaseRate = 0.2;\r\n  float systemClock = 0;\r\n  extmodeErrorCode_T errorCode = EXTMODE_SUCCESS;\r\n\r\n  /* Initialize variables */\r\n  stopRequested = false;\r\n  runModel = false;\r\n  init();\r\n  MW_Arduino_Init();\r\n  rtmSetErrorStatus(Abstandsensor_M, 0);\r\n\r\n  /* Set Final Simulation Time in Ticks */\r\n  errorCode = extmodeSetFinalSimulationTime((extmodeSimulationTime_T) -1);\r\n\r\n  /* Parse External Mode command line arguments */\r\n  errorCode = extmodeParseArgs(0, NULL);\r\n  if (errorCode != EXTMODE_SUCCESS) {\r\n    return (errorCode);\r\n  }\r\n\r\n  Abstandsensor_initialize();\r\n  cli();\r\n  sei ();\r\n\r\n  /* External Mode initialization */\r\n  errorCode = extmodeInit(Abstandsensor_M->extModeInfo, &rtmGetTFinal\r\n    (Abstandsensor_M));\r\n  if (errorCode != EXTMODE_SUCCESS) {\r\n    /* Code to handle External Mode initialization errors\r\n       may be added here */\r\n  }\r\n\r\n  if (errorCode == EXTMODE_SUCCESS) {\r\n    /* Wait until a Start or Stop Request has been received from the Host */\r\n    extmodeWaitForHostRequest(EXTMODE_WAIT_FOREVER);\r\n    if (extmodeStopRequested()) {\r\n      rtmSetStopRequested(Abstandsensor_M, true);\r\n    }\r\n  }\r\n\r\n  cli();\r\n  configureArduinoAVRTimer();\r\n  runModel =\r\n    !extmodeSimulationComplete()&& !extmodeStopRequested()&&\r\n    !rtmGetStopRequested(Abstandsensor_M);\r\n\r\n#ifndef _MW_ARDUINO_LOOP_\r\n\r\n  sei();\r\n\r\n#endif;\r\n\r\n  XcpStatus lastXcpState = xcpStatusGet();\r\n  sei ();\r\n  while (runModel) {\r\n    /* Run External Mode background activities */\r\n    errorCode = extmodeBackgroundRun();\r\n    if (errorCode != EXTMODE_SUCCESS) {\r\n      /* Code to handle External Mode background task errors\r\n         may be added here */\r\n    }\r\n\r\n    stopRequested = !(\r\n                      !extmodeSimulationComplete()&& !extmodeStopRequested()&&\r\n                      !rtmGetStopRequested(Abstandsensor_M));\r\n    runModel = !(stopRequested);\r\n    if (stopRequested)\r\n      disable_rt_OneStep();\r\n    if (lastXcpState==XCP_CONNECTED && xcpStatusGet()==XCP_DISCONNECTED)\r\n      rtIOStreamResync();\r\n    lastXcpState = xcpStatusGet();\r\n    MW_Arduino_Loop();\r\n  }\r\n\r\n  /* Terminate model */\r\n  Abstandsensor_terminate();\r\n\r\n  /* External Mode reset */\r\n  extmodeReset();\r\n  cli();\r\n  return 0;\r\n}\r\n"},{"name":"Abstandsensor.c","type":"source","group":"model","path":"C:\\Users\\Sophie\\Documents\\Hochschule\\Master\\Semester 2\\Praktikum\\Versuche\\Projekte\\172-184\\184_Das_Geheimnis_der_Feder\\Abstandsensor_ert_rtw","tag":"","groupDisplay":"Model files","code":"/*\r\n * Abstandsensor.c\r\n *\r\n * Academic License - for use in teaching, academic research, and meeting\r\n * course requirements at degree granting institutions only.  Not for\r\n * government, commercial, or other organizational use.\r\n *\r\n * Code generation for model \"Abstandsensor\".\r\n *\r\n * Model version              : 10.15\r\n * Simulink Coder version : 24.1 (R2024a) 19-Nov-2023\r\n * C source code generated on : Mon Jan 13 17:19:51 2025\r\n *\r\n * Target selection: ert.tlc\r\n * Embedded hardware selection: Atmel->AVR\r\n * Code generation objectives: Unspecified\r\n * Validation result: Not run\r\n */\r\n\r\n#include \"Abstandsensor.h\"\r\n#include \"Abstandsensor_types.h\"\r\n#include \"rtwtypes.h\"\r\n#include <math.h>\r\n#include <string.h>\r\n#include \"Abstandsensor_private.h\"\r\n\r\n/* Block signals (default storage) */\r\nB_Abstandsensor_T Abstandsensor_B;\r\n\r\n/* Block states (default storage) */\r\nDW_Abstandsensor_T Abstandsensor_DW;\r\n\r\n/* Real-time model */\r\nstatic RT_MODEL_Abstandsensor_T Abstandsensor_M_;\r\nRT_MODEL_Abstandsensor_T *const Abstandsensor_M = &Abstandsensor_M_;\r\n\r\n/* Forward declaration for local functions */\r\nstatic void Abstan_MedianFilterCG_resetImpl(c_dsp_internal_MedianFilterCG_T *obj);\r\nstatic void A_MedianFilterCG_trickleDownMax(c_dsp_internal_MedianFilterCG_T *obj,\r\n  real_T i);\r\nstatic void A_MedianFilterCG_trickleDownMin(c_dsp_internal_MedianFilterCG_T *obj,\r\n  real_T i);\r\nreal_T look1_binlxpw(real_T u0, const real_T bp0[], const real_T table[],\r\n                     uint32_T maxIndex)\r\n{\r\n  real_T frac;\r\n  real_T yL_0d0;\r\n  uint32_T bpIdx;\r\n  uint32_T iLeft;\r\n  uint32_T iRght;\r\n\r\n  /* Column-major Lookup 1-D\r\n     Search method: 'binary'\r\n     Use previous index: 'off'\r\n     Interpolation method: 'Linear point-slope'\r\n     Extrapolation method: 'Linear'\r\n     Use last breakpoint for index at or above upper limit: 'off'\r\n     Remove protection against out-of-range input in generated code: 'off'\r\n   */\r\n  /* Prelookup - Index and Fraction\r\n     Index Search method: 'binary'\r\n     Extrapolation method: 'Linear'\r\n     Use previous index: 'off'\r\n     Use last breakpoint for index at or above upper limit: 'off'\r\n     Remove protection against out-of-range input in generated code: 'off'\r\n   */\r\n  if (u0 <= bp0[0UL]) {\r\n    iLeft = 0UL;\r\n    frac = (u0 - bp0[0UL]) / (bp0[1UL] - bp0[0UL]);\r\n  } else if (u0 < bp0[maxIndex]) {\r\n    /* Binary Search */\r\n    bpIdx = maxIndex >> 1UL;\r\n    iLeft = 0UL;\r\n    iRght = maxIndex;\r\n    while (iRght - iLeft > 1UL) {\r\n      if (u0 < bp0[bpIdx]) {\r\n        iRght = bpIdx;\r\n      } else {\r\n        iLeft = bpIdx;\r\n      }\r\n\r\n      bpIdx = (iRght + iLeft) >> 1UL;\r\n    }\r\n\r\n    frac = (u0 - bp0[iLeft]) / (bp0[iLeft + 1UL] - bp0[iLeft]);\r\n  } else {\r\n    iLeft = maxIndex - 1UL;\r\n    frac = (u0 - bp0[maxIndex - 1UL]) / (bp0[maxIndex] - bp0[maxIndex - 1UL]);\r\n  }\r\n\r\n  /* Column-major Interpolation 1-D\r\n     Interpolation method: 'Linear point-slope'\r\n     Use last breakpoint for index at or above upper limit: 'off'\r\n     Overflow mode: 'portable wrapping'\r\n   */\r\n  yL_0d0 = table[iLeft];\r\n  return (table[iLeft + 1UL] - yL_0d0) * frac + yL_0d0;\r\n}\r\n\r\nstatic void Abstan_MedianFilterCG_resetImpl(c_dsp_internal_MedianFilterCG_T *obj)\r\n{\r\n  real_T cnt1;\r\n  real_T cnt2;\r\n  int16_T i;\r\n  memset(&obj->pBuf[0], 0, 30U * sizeof(real_T));\r\n  memset(&obj->pPos[0], 0, 30U * sizeof(real_T));\r\n  memset(&obj->pHeap[0], 0, 30U * sizeof(real_T));\r\n\r\n  /* Start for MATLABSystem: '<Root>/Median Filter' */\r\n  obj->pWinLen = 30.0;\r\n  obj->pIdx = obj->pWinLen;\r\n\r\n  /* Start for MATLABSystem: '<Root>/Median Filter' */\r\n  obj->pMidHeap = ceil((obj->pWinLen + 1.0) / 2.0);\r\n  cnt1 = (obj->pWinLen - 1.0) / 2.0;\r\n\r\n  /* Start for MATLABSystem: '<Root>/Median Filter' */\r\n  if (cnt1 < 0.0) {\r\n    obj->pMinHeapLength = ceil(cnt1);\r\n  } else {\r\n    obj->pMinHeapLength = floor(cnt1);\r\n  }\r\n\r\n  cnt1 = obj->pWinLen / 2.0;\r\n\r\n  /* Start for MATLABSystem: '<Root>/Median Filter' */\r\n  if (cnt1 < 0.0) {\r\n    obj->pMaxHeapLength = ceil(cnt1);\r\n  } else {\r\n    obj->pMaxHeapLength = floor(cnt1);\r\n  }\r\n\r\n  cnt1 = 1.0;\r\n  cnt2 = obj->pWinLen;\r\n  for (i = 0; i < 30; i++) {\r\n    /* Start for MATLABSystem: '<Root>/Median Filter' */\r\n    if (fmod(30.0 - (real_T)i, 2.0) == 0.0) {\r\n      obj->pPos[29 - i] = cnt1;\r\n      cnt1++;\r\n    } else {\r\n      obj->pPos[29 - i] = cnt2;\r\n      cnt2--;\r\n    }\r\n\r\n    obj->pHeap[(int16_T)obj->pPos[29 - i] - 1] = 30.0 - (real_T)i;\r\n  }\r\n}\r\n\r\nstatic void A_MedianFilterCG_trickleDownMax(c_dsp_internal_MedianFilterCG_T *obj,\r\n  real_T i)\r\n{\r\n  real_T ind2;\r\n  real_T temp;\r\n  real_T tmp;\r\n  real_T u_tmp;\r\n  boolean_T exitg1;\r\n  exitg1 = false;\r\n  while ((!exitg1) && (i >= -obj->pMaxHeapLength)) {\r\n    if ((i < -1.0) && (i > -obj->pMaxHeapLength) && (obj->pBuf[(int16_T)\r\n         obj->pHeap[(int16_T)(i + obj->pMidHeap) - 1] - 1] < obj->pBuf[(int16_T)\r\n         obj->pHeap[(int16_T)((i - 1.0) + obj->pMidHeap) - 1] - 1])) {\r\n      i--;\r\n    }\r\n\r\n    u_tmp = i / 2.0;\r\n    if (u_tmp < 0.0) {\r\n      temp = ceil(u_tmp);\r\n    } else {\r\n      temp = floor(u_tmp);\r\n    }\r\n\r\n    ind2 = i + obj->pMidHeap;\r\n    tmp = obj->pHeap[(int16_T)ind2 - 1];\r\n    if (!(obj->pBuf[(int16_T)obj->pHeap[(int16_T)(temp + obj->pMidHeap) - 1] - 1]\r\n          < obj->pBuf[(int16_T)tmp - 1])) {\r\n      exitg1 = true;\r\n    } else {\r\n      if (u_tmp < 0.0) {\r\n        temp = ceil(u_tmp);\r\n      } else {\r\n        temp = floor(u_tmp);\r\n      }\r\n\r\n      u_tmp = temp + obj->pMidHeap;\r\n      temp = obj->pHeap[(int16_T)u_tmp - 1];\r\n      obj->pHeap[(int16_T)u_tmp - 1] = tmp;\r\n      obj->pHeap[(int16_T)ind2 - 1] = temp;\r\n      obj->pPos[(int16_T)obj->pHeap[(int16_T)u_tmp - 1] - 1] = u_tmp;\r\n      obj->pPos[(int16_T)obj->pHeap[(int16_T)ind2 - 1] - 1] = ind2;\r\n      i *= 2.0;\r\n    }\r\n  }\r\n}\r\n\r\nstatic void A_MedianFilterCG_trickleDownMin(c_dsp_internal_MedianFilterCG_T *obj,\r\n  real_T i)\r\n{\r\n  real_T ind1;\r\n  real_T tmp;\r\n  real_T tmp_0;\r\n  real_T u_tmp;\r\n  boolean_T exitg1;\r\n  exitg1 = false;\r\n  while ((!exitg1) && (i <= obj->pMinHeapLength)) {\r\n    if ((i > 1.0) && (i < obj->pMinHeapLength) && (obj->pBuf[(int16_T)obj->\r\n         pHeap[(int16_T)((i + 1.0) + obj->pMidHeap) - 1] - 1] < obj->pBuf\r\n         [(int16_T)obj->pHeap[(int16_T)(i + obj->pMidHeap) - 1] - 1])) {\r\n      i++;\r\n    }\r\n\r\n    u_tmp = i / 2.0;\r\n    if (u_tmp < 0.0) {\r\n      tmp = ceil(u_tmp);\r\n    } else {\r\n      tmp = floor(u_tmp);\r\n    }\r\n\r\n    ind1 = i + obj->pMidHeap;\r\n    tmp_0 = obj->pHeap[(int16_T)ind1 - 1];\r\n    if (!(obj->pBuf[(int16_T)tmp_0 - 1] < obj->pBuf[(int16_T)obj->pHeap[(int16_T)\r\n          (tmp + obj->pMidHeap) - 1] - 1])) {\r\n      exitg1 = true;\r\n    } else {\r\n      if (u_tmp < 0.0) {\r\n        tmp = ceil(u_tmp);\r\n      } else {\r\n        tmp = floor(u_tmp);\r\n      }\r\n\r\n      u_tmp = tmp + obj->pMidHeap;\r\n      obj->pHeap[(int16_T)ind1 - 1] = obj->pHeap[(int16_T)u_tmp - 1];\r\n      obj->pHeap[(int16_T)u_tmp - 1] = tmp_0;\r\n      obj->pPos[(int16_T)obj->pHeap[(int16_T)ind1 - 1] - 1] = ind1;\r\n      obj->pPos[(int16_T)obj->pHeap[(int16_T)u_tmp - 1] - 1] = u_tmp;\r\n      i *= 2.0;\r\n    }\r\n  }\r\n}\r\n\r\n/* Model step function */\r\nvoid Abstandsensor_step(void)\r\n{\r\n  real_T LED3;\r\n  real_T temp;\r\n  real_T tmp;\r\n  int16_T LED5;\r\n  uint16_T b_varargout_1;\r\n  boolean_T exitg1;\r\n\r\n  /* MATLABSystem: '<Root>/IR_Signal_roh' */\r\n  if (Abstandsensor_DW.obj_b.SampleTime !=\r\n      Abstandsensor_P.IR_Signal_roh_SampleTime) {\r\n    Abstandsensor_DW.obj_b.SampleTime = Abstandsensor_P.IR_Signal_roh_SampleTime;\r\n  }\r\n\r\n  Abstandsensor_DW.obj_b.AnalogInDriverObj.MW_ANALOGIN_HANDLE =\r\n    MW_AnalogIn_GetHandle(14UL);\r\n  MW_AnalogInSingle_ReadResult\r\n    (Abstandsensor_DW.obj_b.AnalogInDriverObj.MW_ANALOGIN_HANDLE, &b_varargout_1,\r\n     MW_ANALOGIN_UINT16);\r\n\r\n  /* MATLABSystem: '<Root>/Median Filter' incorporates:\r\n   *  DataTypeConversion: '<Root>/Data Type Conversion'\r\n   *  MATLABSystem: '<Root>/IR_Signal_roh'\r\n   * */\r\n  if (Abstandsensor_DW.obj.pMID.isInitialized != 1L) {\r\n    Abstandsensor_DW.obj.pMID.isInitialized = 1L;\r\n    Abstandsensor_DW.obj.pMID.isSetupComplete = true;\r\n    Abstan_MedianFilterCG_resetImpl(&Abstandsensor_DW.obj.pMID);\r\n  }\r\n\r\n  Abstandsensor_B.vprev = Abstandsensor_DW.obj.pMID.pBuf[(int16_T)\r\n    Abstandsensor_DW.obj.pMID.pIdx - 1];\r\n  Abstandsensor_DW.obj.pMID.pBuf[(int16_T)Abstandsensor_DW.obj.pMID.pIdx - 1] =\r\n    b_varargout_1;\r\n  Abstandsensor_B.p = Abstandsensor_DW.obj.pMID.pPos[(int16_T)\r\n    Abstandsensor_DW.obj.pMID.pIdx - 1];\r\n  Abstandsensor_DW.obj.pMID.pIdx++;\r\n  if (Abstandsensor_DW.obj.pMID.pWinLen + 1.0 == Abstandsensor_DW.obj.pMID.pIdx)\r\n  {\r\n    Abstandsensor_DW.obj.pMID.pIdx = 1.0;\r\n  }\r\n\r\n  if (Abstandsensor_B.p > Abstandsensor_DW.obj.pMID.pMidHeap) {\r\n    if (Abstandsensor_B.vprev < b_varargout_1) {\r\n      A_MedianFilterCG_trickleDownMin(&Abstandsensor_DW.obj.pMID,\r\n        (Abstandsensor_B.p - Abstandsensor_DW.obj.pMID.pMidHeap) * 2.0);\r\n    } else {\r\n      Abstandsensor_B.vprev = Abstandsensor_B.p -\r\n        Abstandsensor_DW.obj.pMID.pMidHeap;\r\n      exitg1 = false;\r\n      while ((!exitg1) && (Abstandsensor_B.vprev > 0.0)) {\r\n        Abstandsensor_B.p = Abstandsensor_B.vprev +\r\n          Abstandsensor_DW.obj.pMID.pMidHeap;\r\n        LED3 = floor(Abstandsensor_B.vprev / 2.0) +\r\n          Abstandsensor_DW.obj.pMID.pMidHeap;\r\n        tmp = Abstandsensor_DW.obj.pMID.pHeap[(int16_T)Abstandsensor_B.p - 1];\r\n        temp = Abstandsensor_DW.obj.pMID.pHeap[(int16_T)LED3 - 1];\r\n        if (!(Abstandsensor_DW.obj.pMID.pBuf[(int16_T)tmp - 1] <\r\n              Abstandsensor_DW.obj.pMID.pBuf[(int16_T)temp - 1])) {\r\n          exitg1 = true;\r\n        } else {\r\n          Abstandsensor_DW.obj.pMID.pHeap[(int16_T)Abstandsensor_B.p - 1] = temp;\r\n          Abstandsensor_DW.obj.pMID.pHeap[(int16_T)LED3 - 1] = tmp;\r\n          Abstandsensor_DW.obj.pMID.pPos[(int16_T)\r\n            Abstandsensor_DW.obj.pMID.pHeap[(int16_T)Abstandsensor_B.p - 1] - 1]\r\n            = Abstandsensor_B.p;\r\n          Abstandsensor_DW.obj.pMID.pPos[(int16_T)\r\n            Abstandsensor_DW.obj.pMID.pHeap[(int16_T)LED3 - 1] - 1] = LED3;\r\n          Abstandsensor_B.vprev = floor(Abstandsensor_B.vprev / 2.0);\r\n        }\r\n      }\r\n\r\n      if (Abstandsensor_B.vprev == 0.0) {\r\n        A_MedianFilterCG_trickleDownMax(&Abstandsensor_DW.obj.pMID, -1.0);\r\n      }\r\n    }\r\n  } else if (Abstandsensor_B.p < Abstandsensor_DW.obj.pMID.pMidHeap) {\r\n    if (b_varargout_1 < Abstandsensor_B.vprev) {\r\n      A_MedianFilterCG_trickleDownMax(&Abstandsensor_DW.obj.pMID,\r\n        (Abstandsensor_B.p - Abstandsensor_DW.obj.pMID.pMidHeap) * 2.0);\r\n    } else {\r\n      Abstandsensor_B.vprev = Abstandsensor_B.p -\r\n        Abstandsensor_DW.obj.pMID.pMidHeap;\r\n      exitg1 = false;\r\n      while ((!exitg1) && (Abstandsensor_B.vprev < 0.0)) {\r\n        temp = Abstandsensor_B.vprev / 2.0;\r\n        if (temp < 0.0) {\r\n          Abstandsensor_B.p = ceil(temp);\r\n        } else {\r\n          Abstandsensor_B.p = -0.0;\r\n        }\r\n\r\n        LED3 = Abstandsensor_B.vprev + Abstandsensor_DW.obj.pMID.pMidHeap;\r\n        tmp = Abstandsensor_DW.obj.pMID.pHeap[(int16_T)LED3 - 1];\r\n        if (!(Abstandsensor_DW.obj.pMID.pBuf[(int16_T)\r\n              Abstandsensor_DW.obj.pMID.pHeap[(int16_T)(Abstandsensor_B.p +\r\n              Abstandsensor_DW.obj.pMID.pMidHeap) - 1] - 1] <\r\n              Abstandsensor_DW.obj.pMID.pBuf[(int16_T)tmp - 1])) {\r\n          exitg1 = true;\r\n        } else {\r\n          if (temp < 0.0) {\r\n            Abstandsensor_B.p = ceil(temp);\r\n            Abstandsensor_B.vprev = Abstandsensor_B.p;\r\n          } else {\r\n            Abstandsensor_B.p = -0.0;\r\n            Abstandsensor_B.vprev = -0.0;\r\n          }\r\n\r\n          Abstandsensor_B.p += Abstandsensor_DW.obj.pMID.pMidHeap;\r\n          temp = Abstandsensor_DW.obj.pMID.pHeap[(int16_T)Abstandsensor_B.p - 1];\r\n          Abstandsensor_DW.obj.pMID.pHeap[(int16_T)Abstandsensor_B.p - 1] = tmp;\r\n          Abstandsensor_DW.obj.pMID.pHeap[(int16_T)LED3 - 1] = temp;\r\n          Abstandsensor_DW.obj.pMID.pPos[(int16_T)\r\n            Abstandsensor_DW.obj.pMID.pHeap[(int16_T)Abstandsensor_B.p - 1] - 1]\r\n            = Abstandsensor_B.p;\r\n          Abstandsensor_DW.obj.pMID.pPos[(int16_T)\r\n            Abstandsensor_DW.obj.pMID.pHeap[(int16_T)LED3 - 1] - 1] = LED3;\r\n        }\r\n      }\r\n\r\n      if (Abstandsensor_B.vprev == 0.0) {\r\n        A_MedianFilterCG_trickleDownMin(&Abstandsensor_DW.obj.pMID, 1.0);\r\n      }\r\n    }\r\n  } else {\r\n    if (Abstandsensor_DW.obj.pMID.pMaxHeapLength != 0.0) {\r\n      A_MedianFilterCG_trickleDownMax(&Abstandsensor_DW.obj.pMID, -1.0);\r\n    }\r\n\r\n    if (Abstandsensor_DW.obj.pMID.pMinHeapLength > 0.0) {\r\n      A_MedianFilterCG_trickleDownMin(&Abstandsensor_DW.obj.pMID, 1.0);\r\n    }\r\n  }\r\n\r\n  /* MATLABSystem: '<Root>/Median Filter' */\r\n  Abstandsensor_B.MedianFilter = (Abstandsensor_DW.obj.pMID.pBuf[(int16_T)\r\n    Abstandsensor_DW.obj.pMID.pHeap[(int16_T)(Abstandsensor_DW.obj.pMID.pMidHeap\r\n    - 1.0) - 1] - 1] + Abstandsensor_DW.obj.pMID.pBuf[(int16_T)\r\n    Abstandsensor_DW.obj.pMID.pHeap[(int16_T)Abstandsensor_DW.obj.pMID.pMidHeap\r\n    - 1] - 1]) / 2.0;\r\n\r\n  /* Product: '<Root>/Divide' incorporates:\r\n   *  Constant: '<Root>/Constant'\r\n   *  Lookup_n-D: '<Root>/1-D Lookup Table'\r\n   *  MATLABSystem: '<Root>/Median Filter'\r\n   */\r\n  Abstandsensor_B.Divide = Abstandsensor_P.Constant_Value / look1_binlxpw\r\n    (Abstandsensor_B.MedianFilter, Abstandsensor_P.uDLookupTable_bp01Data,\r\n     Abstandsensor_P.uDLookupTable_tableData, 7UL);\r\n\r\n  /* MATLAB Function: '<Root>/controlLED' */\r\n  /* MATLAB Function 'controlLED': '<S1>:1' */\r\n  /* '<S1>:1:30' [LED1, LED2, LED3, LED4, LED5] = deal(0, 0, 0, 0, 0); */\r\n  Abstandsensor_B.vprev = 0.0;\r\n  Abstandsensor_B.p = 0.0;\r\n  LED3 = 0.0;\r\n  temp = 0.0;\r\n  LED5 = 0;\r\n\r\n  /* '<S1>:1:33' if sensorValue <= 1.58*10^-5 */\r\n  if (Abstandsensor_B.Divide <= 1.5799999999999998E-5) {\r\n    /* '<S1>:1:34' [LED1, LED2, LED3, LED4, LED5] = deal(255, 0, 0, 0, 0); */\r\n    Abstandsensor_B.vprev = 255.0;\r\n  } else if (Abstandsensor_B.Divide <= 1.61E-5) {\r\n    /* '<S1>:1:35' elseif sensorValue <= 1.61*10^-5 */\r\n    /* '<S1>:1:36' [LED1, LED2, LED3, LED4, LED5] = deal(0, 255, 0, 0, 0); */\r\n    Abstandsensor_B.p = 255.0;\r\n  } else if (Abstandsensor_B.Divide <= 1.64E-5) {\r\n    /* '<S1>:1:37' elseif sensorValue <= 1.64*10^-5 */\r\n    /* '<S1>:1:38' [LED1, LED2, LED3, LED4, LED5] = deal(0, 0, 255, 0, 0); */\r\n    LED3 = 255.0;\r\n  } else if (Abstandsensor_B.Divide <= 1.6999999999999996E-5) {\r\n    /* '<S1>:1:39' elseif sensorValue <= 1.70*10^-5 */\r\n    /* '<S1>:1:40' [LED1, LED2, LED3, LED4, LED5] = deal(0, 0, 0, 255, 0); */\r\n    temp = 255.0;\r\n  } else if (Abstandsensor_B.Divide > 1.6999999999999996E-5) {\r\n    /* '<S1>:1:41' elseif sensorValue > 1.70*10^-5 */\r\n    /* '<S1>:1:42' [LED1, LED2, LED3, LED4, LED5] = deal(0, 0, 0, 0, 255); */\r\n    LED5 = 255;\r\n  }\r\n\r\n  /* End of MATLAB Function: '<Root>/controlLED' */\r\n\r\n  /* MATLABSystem: '<Root>/LED1_rotVielzuschwer' */\r\n  writeDigitalPin(3, (uint8_T)Abstandsensor_B.vprev);\r\n\r\n  /* MATLABSystem: '<Root>/LED2_gelbZuschwer' */\r\n  writeDigitalPin(4, (uint8_T)Abstandsensor_B.p);\r\n\r\n  /* MATLABSystem: '<Root>/LED3_gruenPassend' */\r\n  writeDigitalPin(5, (uint8_T)LED3);\r\n\r\n  /* MATLABSystem: '<Root>/LED4_gelbZuleicht' */\r\n  writeDigitalPin(6, (uint8_T)temp);\r\n\r\n  /* MATLABSystem: '<Root>/LED5_rotVielzuleicht' */\r\n  writeDigitalPin(7, (uint8_T)LED5);\r\n\r\n  /* Update absolute time for base rate */\r\n  /* The \"clockTick0\" counts the number of times the code of this task has\r\n   * been executed. The absolute time is the multiplication of \"clockTick0\"\r\n   * and \"Timing.stepSize0\". Size of \"clockTick0\" ensures timer will not\r\n   * overflow during the application lifespan selected.\r\n   * Timer of this task consists of two 32 bit unsigned integers.\r\n   * The two integers represent the low bits Timing.clockTick0 and the high bits\r\n   * Timing.clockTickH0. When the low bit overflows to 0, the high bits increment.\r\n   */\r\n  if (!(++Abstandsensor_M->Timing.clockTick0)) {\r\n    ++Abstandsensor_M->Timing.clockTickH0;\r\n  }\r\n\r\n  Abstandsensor_M->Timing.taskTime0 = Abstandsensor_M->Timing.clockTick0 *\r\n    Abstandsensor_M->Timing.stepSize0 + Abstandsensor_M->Timing.clockTickH0 *\r\n    Abstandsensor_M->Timing.stepSize0 * 4294967296.0;\r\n}\r\n\r\n/* Model initialize function */\r\nvoid Abstandsensor_initialize(void)\r\n{\r\n  /* Registration code */\r\n\r\n  /* initialize real-time model */\r\n  (void) memset((void *)Abstandsensor_M, 0,\r\n                sizeof(RT_MODEL_Abstandsensor_T));\r\n  rtmSetTFinal(Abstandsensor_M, -1);\r\n  Abstandsensor_M->Timing.stepSize0 = 0.2;\r\n\r\n  /* External mode info */\r\n  Abstandsensor_M->Sizes.checksums[0] = (2049694028U);\r\n  Abstandsensor_M->Sizes.checksums[1] = (2300151249U);\r\n  Abstandsensor_M->Sizes.checksums[2] = (1223485843U);\r\n  Abstandsensor_M->Sizes.checksums[3] = (3579557617U);\r\n\r\n  {\r\n    static const sysRanDType rtAlwaysEnabled = SUBSYS_RAN_BC_ENABLE;\r\n    static RTWExtModeInfo rt_ExtModeInfo;\r\n    static const sysRanDType *systemRan[9];\r\n    Abstandsensor_M->extModeInfo = (&rt_ExtModeInfo);\r\n    rteiSetSubSystemActiveVectorAddresses(&rt_ExtModeInfo, systemRan);\r\n    systemRan[0] = &rtAlwaysEnabled;\r\n    systemRan[1] = &rtAlwaysEnabled;\r\n    systemRan[2] = &rtAlwaysEnabled;\r\n    systemRan[3] = &rtAlwaysEnabled;\r\n    systemRan[4] = &rtAlwaysEnabled;\r\n    systemRan[5] = &rtAlwaysEnabled;\r\n    systemRan[6] = &rtAlwaysEnabled;\r\n    systemRan[7] = &rtAlwaysEnabled;\r\n    systemRan[8] = &rtAlwaysEnabled;\r\n    rteiSetModelMappingInfoPtr(Abstandsensor_M->extModeInfo,\r\n      &Abstandsensor_M->SpecialInfo.mappingInfo);\r\n    rteiSetChecksumsPtr(Abstandsensor_M->extModeInfo,\r\n                        Abstandsensor_M->Sizes.checksums);\r\n    rteiSetTPtr(Abstandsensor_M->extModeInfo, rtmGetTPtr(Abstandsensor_M));\r\n  }\r\n\r\n  /* block I/O */\r\n  (void) memset(((void *) &Abstandsensor_B), 0,\r\n                sizeof(B_Abstandsensor_T));\r\n\r\n  /* states (dwork) */\r\n  (void) memset((void *)&Abstandsensor_DW, 0,\r\n                sizeof(DW_Abstandsensor_T));\r\n\r\n  /* Start for MATLABSystem: '<Root>/IR_Signal_roh' */\r\n  Abstandsensor_DW.obj_b.matlabCodegenIsDeleted = false;\r\n  Abstandsensor_DW.obj_b.SampleTime = Abstandsensor_P.IR_Signal_roh_SampleTime;\r\n  Abstandsensor_DW.obj_b.isInitialized = 1L;\r\n  Abstandsensor_DW.obj_b.AnalogInDriverObj.MW_ANALOGIN_HANDLE =\r\n    MW_AnalogInSingle_Open(14UL);\r\n  Abstandsensor_DW.obj_b.isSetupComplete = true;\r\n\r\n  /* Start for MATLABSystem: '<Root>/Median Filter' */\r\n  Abstandsensor_DW.obj.matlabCodegenIsDeleted = false;\r\n  Abstandsensor_DW.obj.isInitialized = 1L;\r\n  Abstandsensor_DW.obj.NumChannels = 1L;\r\n  Abstandsensor_DW.obj.pMID.isInitialized = 0L;\r\n  Abstandsensor_DW.obj.isSetupComplete = true;\r\n\r\n  /* Start for MATLABSystem: '<Root>/LED1_rotVielzuschwer' */\r\n  Abstandsensor_DW.obj_o.matlabCodegenIsDeleted = false;\r\n  Abstandsensor_DW.obj_o.isInitialized = 1L;\r\n  digitalIOSetup(3, 1);\r\n  Abstandsensor_DW.obj_o.isSetupComplete = true;\r\n\r\n  /* Start for MATLABSystem: '<Root>/LED2_gelbZuschwer' */\r\n  Abstandsensor_DW.obj_p.matlabCodegenIsDeleted = false;\r\n  Abstandsensor_DW.obj_p.isInitialized = 1L;\r\n  digitalIOSetup(4, 1);\r\n  Abstandsensor_DW.obj_p.isSetupComplete = true;\r\n\r\n  /* Start for MATLABSystem: '<Root>/LED3_gruenPassend' */\r\n  Abstandsensor_DW.obj_l.matlabCodegenIsDeleted = false;\r\n  Abstandsensor_DW.obj_l.isInitialized = 1L;\r\n  digitalIOSetup(5, 1);\r\n  Abstandsensor_DW.obj_l.isSetupComplete = true;\r\n\r\n  /* Start for MATLABSystem: '<Root>/LED4_gelbZuleicht' */\r\n  Abstandsensor_DW.obj_e.matlabCodegenIsDeleted = false;\r\n  Abstandsensor_DW.obj_e.isInitialized = 1L;\r\n  digitalIOSetup(6, 1);\r\n  Abstandsensor_DW.obj_e.isSetupComplete = true;\r\n\r\n  /* Start for MATLABSystem: '<Root>/LED5_rotVielzuleicht' */\r\n  Abstandsensor_DW.obj_n.matlabCodegenIsDeleted = false;\r\n  Abstandsensor_DW.obj_n.isInitialized = 1L;\r\n  digitalIOSetup(7, 1);\r\n  Abstandsensor_DW.obj_n.isSetupComplete = true;\r\n}\r\n\r\n/* Model terminate function */\r\nvoid Abstandsensor_terminate(void)\r\n{\r\n  /* Terminate for MATLABSystem: '<Root>/IR_Signal_roh' */\r\n  if (!Abstandsensor_DW.obj_b.matlabCodegenIsDeleted) {\r\n    Abstandsensor_DW.obj_b.matlabCodegenIsDeleted = true;\r\n    if ((Abstandsensor_DW.obj_b.isInitialized == 1L) &&\r\n        Abstandsensor_DW.obj_b.isSetupComplete) {\r\n      Abstandsensor_DW.obj_b.AnalogInDriverObj.MW_ANALOGIN_HANDLE =\r\n        MW_AnalogIn_GetHandle(14UL);\r\n      MW_AnalogIn_Close\r\n        (Abstandsensor_DW.obj_b.AnalogInDriverObj.MW_ANALOGIN_HANDLE);\r\n    }\r\n  }\r\n\r\n  /* End of Terminate for MATLABSystem: '<Root>/IR_Signal_roh' */\r\n\r\n  /* Terminate for MATLABSystem: '<Root>/Median Filter' */\r\n  if (!Abstandsensor_DW.obj.matlabCodegenIsDeleted) {\r\n    Abstandsensor_DW.obj.matlabCodegenIsDeleted = true;\r\n    if ((Abstandsensor_DW.obj.isInitialized == 1L) &&\r\n        Abstandsensor_DW.obj.isSetupComplete) {\r\n      Abstandsensor_DW.obj.NumChannels = -1L;\r\n      if (Abstandsensor_DW.obj.pMID.isInitialized == 1L) {\r\n        Abstandsensor_DW.obj.pMID.isInitialized = 2L;\r\n      }\r\n    }\r\n  }\r\n\r\n  /* End of Terminate for MATLABSystem: '<Root>/Median Filter' */\r\n\r\n  /* Terminate for MATLABSystem: '<Root>/LED1_rotVielzuschwer' */\r\n  if (!Abstandsensor_DW.obj_o.matlabCodegenIsDeleted) {\r\n    Abstandsensor_DW.obj_o.matlabCodegenIsDeleted = true;\r\n  }\r\n\r\n  /* End of Terminate for MATLABSystem: '<Root>/LED1_rotVielzuschwer' */\r\n\r\n  /* Terminate for MATLABSystem: '<Root>/LED2_gelbZuschwer' */\r\n  if (!Abstandsensor_DW.obj_p.matlabCodegenIsDeleted) {\r\n    Abstandsensor_DW.obj_p.matlabCodegenIsDeleted = true;\r\n  }\r\n\r\n  /* End of Terminate for MATLABSystem: '<Root>/LED2_gelbZuschwer' */\r\n\r\n  /* Terminate for MATLABSystem: '<Root>/LED3_gruenPassend' */\r\n  if (!Abstandsensor_DW.obj_l.matlabCodegenIsDeleted) {\r\n    Abstandsensor_DW.obj_l.matlabCodegenIsDeleted = true;\r\n  }\r\n\r\n  /* End of Terminate for MATLABSystem: '<Root>/LED3_gruenPassend' */\r\n\r\n  /* Terminate for MATLABSystem: '<Root>/LED4_gelbZuleicht' */\r\n  if (!Abstandsensor_DW.obj_e.matlabCodegenIsDeleted) {\r\n    Abstandsensor_DW.obj_e.matlabCodegenIsDeleted = true;\r\n  }\r\n\r\n  /* End of Terminate for MATLABSystem: '<Root>/LED4_gelbZuleicht' */\r\n\r\n  /* Terminate for MATLABSystem: '<Root>/LED5_rotVielzuleicht' */\r\n  if (!Abstandsensor_DW.obj_n.matlabCodegenIsDeleted) {\r\n    Abstandsensor_DW.obj_n.matlabCodegenIsDeleted = true;\r\n  }\r\n\r\n  /* End of Terminate for MATLABSystem: '<Root>/LED5_rotVielzuleicht' */\r\n}\r\n"},{"name":"Abstandsensor.h","type":"header","group":"model","path":"C:\\Users\\Sophie\\Documents\\Hochschule\\Master\\Semester 2\\Praktikum\\Versuche\\Projekte\\172-184\\184_Das_Geheimnis_der_Feder\\Abstandsensor_ert_rtw","tag":"","groupDisplay":"Model files","code":"/*\r\n * Abstandsensor.h\r\n *\r\n * Academic License - for use in teaching, academic research, and meeting\r\n * course requirements at degree granting institutions only.  Not for\r\n * government, commercial, or other organizational use.\r\n *\r\n * Code generation for model \"Abstandsensor\".\r\n *\r\n * Model version              : 10.15\r\n * Simulink Coder version : 24.1 (R2024a) 19-Nov-2023\r\n * C source code generated on : Mon Jan 13 17:19:51 2025\r\n *\r\n * Target selection: ert.tlc\r\n * Embedded hardware selection: Atmel->AVR\r\n * Code generation objectives: Unspecified\r\n * Validation result: Not run\r\n */\r\n\r\n#ifndef Abstandsensor_h_\r\n#define Abstandsensor_h_\r\n#ifndef Abstandsensor_COMMON_INCLUDES_\r\n#define Abstandsensor_COMMON_INCLUDES_\r\n#include \"rtwtypes.h\"\r\n#include \"rtw_extmode.h\"\r\n#include \"sysran_types.h\"\r\n#include \"rtw_continuous.h\"\r\n#include \"rtw_solver.h\"\r\n#include \"MW_AnalogIn.h\"\r\n#include \"MW_arduino_digitalio.h\"\r\n#endif                                 /* Abstandsensor_COMMON_INCLUDES_ */\r\n\r\n#include \"Abstandsensor_types.h\"\r\n#include <string.h>\r\n#include \"MW_target_hardware_resources.h\"\r\n\r\n/* Macros for accessing real-time model data structure */\r\n#ifndef rtmGetFinalTime\r\n#define rtmGetFinalTime(rtm)           ((rtm)->Timing.tFinal)\r\n#endif\r\n\r\n#ifndef rtmGetRTWExtModeInfo\r\n#define rtmGetRTWExtModeInfo(rtm)      ((rtm)->extModeInfo)\r\n#endif\r\n\r\n#ifndef rtmGetErrorStatus\r\n#define rtmGetErrorStatus(rtm)         ((rtm)->errorStatus)\r\n#endif\r\n\r\n#ifndef rtmSetErrorStatus\r\n#define rtmSetErrorStatus(rtm, val)    ((rtm)->errorStatus = (val))\r\n#endif\r\n\r\n#ifndef rtmGetStopRequested\r\n#define rtmGetStopRequested(rtm)       ((rtm)->Timing.stopRequestedFlag)\r\n#endif\r\n\r\n#ifndef rtmSetStopRequested\r\n#define rtmSetStopRequested(rtm, val)  ((rtm)->Timing.stopRequestedFlag = (val))\r\n#endif\r\n\r\n#ifndef rtmGetStopRequestedPtr\r\n#define rtmGetStopRequestedPtr(rtm)    (&((rtm)->Timing.stopRequestedFlag))\r\n#endif\r\n\r\n#ifndef rtmGetT\r\n#define rtmGetT(rtm)                   ((rtm)->Timing.taskTime0)\r\n#endif\r\n\r\n#ifndef rtmGetTFinal\r\n#define rtmGetTFinal(rtm)              ((rtm)->Timing.tFinal)\r\n#endif\r\n\r\n#ifndef rtmGetTPtr\r\n#define rtmGetTPtr(rtm)                (&(rtm)->Timing.taskTime0)\r\n#endif\r\n\r\n/* Block signals (default storage) */\r\ntypedef struct {\r\n  real_T Divide;                       /* '<Root>/Divide' */\r\n  real_T MedianFilter;                 /* '<Root>/Median Filter' */\r\n  real_T vprev;\r\n  real_T p;\r\n} B_Abstandsensor_T;\r\n\r\n/* Block states (default storage) for system '<Root>' */\r\ntypedef struct {\r\n  dsp_simulink_MedianFilter_Abs_T obj; /* '<Root>/Median Filter' */\r\n  codertarget_arduinobase_inter_T obj_b;/* '<Root>/IR_Signal_roh' */\r\n  codertarget_arduinobase_block_T obj_n;/* '<Root>/LED5_rotVielzuleicht' */\r\n  codertarget_arduinobase_block_T obj_e;/* '<Root>/LED4_gelbZuleicht' */\r\n  codertarget_arduinobase_block_T obj_l;/* '<Root>/LED3_gruenPassend' */\r\n  codertarget_arduinobase_block_T obj_p;/* '<Root>/LED2_gelbZuschwer' */\r\n  codertarget_arduinobase_block_T obj_o;/* '<Root>/LED1_rotVielzuschwer' */\r\n  struct {\r\n    void *LoggedData;\r\n  } Scope1_PWORK;                      /* '<Root>/Scope1' */\r\n\r\n  struct {\r\n    void *LoggedData;\r\n  } Scope2_PWORK;                      /* '<Root>/Scope2' */\r\n} DW_Abstandsensor_T;\r\n\r\n/* Parameters (default storage) */\r\nstruct P_Abstandsensor_T_ {\r\n  real_T IR_Signal_roh_SampleTime;     /* Expression: -1\r\n                                        * Referenced by: '<Root>/IR_Signal_roh'\r\n                                        */\r\n  real_T Constant_Value;               /* Expression: -1\r\n                                        * Referenced by: '<Root>/Constant'\r\n                                        */\r\n  real_T uDLookupTable_tableData[8];\r\n                                /* Expression: [625;500;350;270;220;180;142;120]\r\n                                 * Referenced by: '<Root>/1-D Lookup Table'\r\n                                 */\r\n  real_T uDLookupTable_bp01Data[8];\r\n                             /* Expression: [0.06;0.1;0.15;0.2;0.25;0.3;0.4;0.5]\r\n                              * Referenced by: '<Root>/1-D Lookup Table'\r\n                              */\r\n};\r\n\r\n/* Real-time Model Data Structure */\r\nstruct tag_RTM_Abstandsensor_T {\r\n  const char_T *errorStatus;\r\n  RTWExtModeInfo *extModeInfo;\r\n\r\n  /*\r\n   * Sizes:\r\n   * The following substructure contains sizes information\r\n   * for many of the model attributes such as inputs, outputs,\r\n   * dwork, sample times, etc.\r\n   */\r\n  struct {\r\n    uint32_T checksums[4];\r\n  } Sizes;\r\n\r\n  /*\r\n   * SpecialInfo:\r\n   * The following substructure contains special information\r\n   * related to other components that are dependent on RTW.\r\n   */\r\n  struct {\r\n    const void *mappingInfo;\r\n  } SpecialInfo;\r\n\r\n  /*\r\n   * Timing:\r\n   * The following substructure contains information regarding\r\n   * the timing information for the model.\r\n   */\r\n  struct {\r\n    time_T taskTime0;\r\n    uint32_T clockTick0;\r\n    uint32_T clockTickH0;\r\n    time_T stepSize0;\r\n    time_T tFinal;\r\n    boolean_T stopRequestedFlag;\r\n  } Timing;\r\n};\r\n\r\n/* Block parameters (default storage) */\r\nextern P_Abstandsensor_T Abstandsensor_P;\r\n\r\n/* Block signals (default storage) */\r\nextern B_Abstandsensor_T Abstandsensor_B;\r\n\r\n/* Block states (default storage) */\r\nextern DW_Abstandsensor_T Abstandsensor_DW;\r\n\r\n/* Model entry point functions */\r\nextern void Abstandsensor_initialize(void);\r\nextern void Abstandsensor_step(void);\r\nextern void Abstandsensor_terminate(void);\r\n\r\n/* Real-time Model object */\r\nextern RT_MODEL_Abstandsensor_T *const Abstandsensor_M;\r\nextern volatile boolean_T stopRequested;\r\nextern volatile boolean_T runModel;\r\n\r\n/*-\r\n * The generated code includes comments that allow you to trace directly\r\n * back to the appropriate location in the model.  The basic format\r\n * is <system>/block_name, where system is the system number (uniquely\r\n * assigned by Simulink) and block_name is the name of the block.\r\n *\r\n * Use the MATLAB hilite_system command to trace the generated code back\r\n * to the model.  For example,\r\n *\r\n * hilite_system('<S3>')    - opens system 3\r\n * hilite_system('<S3>/Kp') - opens and selects block Kp which resides in S3\r\n *\r\n * Here is the system hierarchy for this model\r\n *\r\n * '<Root>' : 'Abstandsensor'\r\n * '<S1>'   : 'Abstandsensor/controlLED'\r\n */\r\n#endif                                 /* Abstandsensor_h_ */\r\n"},{"name":"Abstandsensor_private.h","type":"header","group":"model","path":"C:\\Users\\Sophie\\Documents\\Hochschule\\Master\\Semester 2\\Praktikum\\Versuche\\Projekte\\172-184\\184_Das_Geheimnis_der_Feder\\Abstandsensor_ert_rtw","tag":"","groupDisplay":"Model files","code":"/*\r\n * Abstandsensor_private.h\r\n *\r\n * Academic License - for use in teaching, academic research, and meeting\r\n * course requirements at degree granting institutions only.  Not for\r\n * government, commercial, or other organizational use.\r\n *\r\n * Code generation for model \"Abstandsensor\".\r\n *\r\n * Model version              : 10.15\r\n * Simulink Coder version : 24.1 (R2024a) 19-Nov-2023\r\n * C source code generated on : Mon Jan 13 17:19:51 2025\r\n *\r\n * Target selection: ert.tlc\r\n * Embedded hardware selection: Atmel->AVR\r\n * Code generation objectives: Unspecified\r\n * Validation result: Not run\r\n */\r\n\r\n#ifndef Abstandsensor_private_h_\r\n#define Abstandsensor_private_h_\r\n#include \"rtwtypes.h\"\r\n#include \"multiword_types.h\"\r\n#include \"Abstandsensor_types.h\"\r\n#include \"Abstandsensor.h\"\r\n#include \"rtw_continuous.h\"\r\n#include \"rtw_solver.h\"\r\n\r\n/* Private macros used by the generated code to access rtModel */\r\n#ifndef rtmSetTFinal\r\n#define rtmSetTFinal(rtm, val)         ((rtm)->Timing.tFinal = (val))\r\n#endif\r\n\r\nextern real_T look1_binlxpw(real_T u0, const real_T bp0[], const real_T table[],\r\n  uint32_T maxIndex);\r\n\r\n#endif                                 /* Abstandsensor_private_h_ */\r\n"},{"name":"Abstandsensor_types.h","type":"header","group":"model","path":"C:\\Users\\Sophie\\Documents\\Hochschule\\Master\\Semester 2\\Praktikum\\Versuche\\Projekte\\172-184\\184_Das_Geheimnis_der_Feder\\Abstandsensor_ert_rtw","tag":"","groupDisplay":"Model files","code":"/*\r\n * Abstandsensor_types.h\r\n *\r\n * Academic License - for use in teaching, academic research, and meeting\r\n * course requirements at degree granting institutions only.  Not for\r\n * government, commercial, or other organizational use.\r\n *\r\n * Code generation for model \"Abstandsensor\".\r\n *\r\n * Model version              : 10.15\r\n * Simulink Coder version : 24.1 (R2024a) 19-Nov-2023\r\n * C source code generated on : Mon Jan 13 17:19:51 2025\r\n *\r\n * Target selection: ert.tlc\r\n * Embedded hardware selection: Atmel->AVR\r\n * Code generation objectives: Unspecified\r\n * Validation result: Not run\r\n */\r\n\r\n#ifndef Abstandsensor_types_h_\r\n#define Abstandsensor_types_h_\r\n#include \"MW_SVD.h\"\r\n#include \"rtwtypes.h\"\r\n\r\n/* Custom Type definition for MATLABSystem: '<Root>/IR_Signal_roh' */\r\n#include \"MW_SVD.h\"\r\n#ifndef struct_tag_UTG5XI0vJCsmjbgura8BP\r\n#define struct_tag_UTG5XI0vJCsmjbgura8BP\r\n\r\nstruct tag_UTG5XI0vJCsmjbgura8BP\r\n{\r\n  MW_Handle_Type MW_ANALOGIN_HANDLE;\r\n};\r\n\r\n#endif                                 /* struct_tag_UTG5XI0vJCsmjbgura8BP */\r\n\r\n#ifndef typedef_g_arduinodriver_ArduinoAnalog_T\r\n#define typedef_g_arduinodriver_ArduinoAnalog_T\r\n\r\ntypedef struct tag_UTG5XI0vJCsmjbgura8BP g_arduinodriver_ArduinoAnalog_T;\r\n\r\n#endif                             /* typedef_g_arduinodriver_ArduinoAnalog_T */\r\n\r\n#ifndef struct_tag_8ohiN1FAOgR98njPNu14NC\r\n#define struct_tag_8ohiN1FAOgR98njPNu14NC\r\n\r\nstruct tag_8ohiN1FAOgR98njPNu14NC\r\n{\r\n  boolean_T matlabCodegenIsDeleted;\r\n  int32_T isInitialized;\r\n  boolean_T isSetupComplete;\r\n  g_arduinodriver_ArduinoAnalog_T AnalogInDriverObj;\r\n  real_T SampleTime;\r\n};\r\n\r\n#endif                                 /* struct_tag_8ohiN1FAOgR98njPNu14NC */\r\n\r\n#ifndef typedef_codertarget_arduinobase_inter_T\r\n#define typedef_codertarget_arduinobase_inter_T\r\n\r\ntypedef struct tag_8ohiN1FAOgR98njPNu14NC codertarget_arduinobase_inter_T;\r\n\r\n#endif                             /* typedef_codertarget_arduinobase_inter_T */\r\n\r\n#ifndef struct_tag_04b6x6tDldj9IrIH2gmbjG\r\n#define struct_tag_04b6x6tDldj9IrIH2gmbjG\r\n\r\nstruct tag_04b6x6tDldj9IrIH2gmbjG\r\n{\r\n  int16_T __dummy;\r\n};\r\n\r\n#endif                                 /* struct_tag_04b6x6tDldj9IrIH2gmbjG */\r\n\r\n#ifndef typedef_b_arduinodriver_ArduinoDigita_T\r\n#define typedef_b_arduinodriver_ArduinoDigita_T\r\n\r\ntypedef struct tag_04b6x6tDldj9IrIH2gmbjG b_arduinodriver_ArduinoDigita_T;\r\n\r\n#endif                             /* typedef_b_arduinodriver_ArduinoDigita_T */\r\n\r\n#ifndef struct_tag_AYWgtFscQm3mLUJYb3A20C\r\n#define struct_tag_AYWgtFscQm3mLUJYb3A20C\r\n\r\nstruct tag_AYWgtFscQm3mLUJYb3A20C\r\n{\r\n  boolean_T matlabCodegenIsDeleted;\r\n  int32_T isInitialized;\r\n  boolean_T isSetupComplete;\r\n  b_arduinodriver_ArduinoDigita_T DigitalIODriverObj;\r\n};\r\n\r\n#endif                                 /* struct_tag_AYWgtFscQm3mLUJYb3A20C */\r\n\r\n#ifndef typedef_codertarget_arduinobase_block_T\r\n#define typedef_codertarget_arduinobase_block_T\r\n\r\ntypedef struct tag_AYWgtFscQm3mLUJYb3A20C codertarget_arduinobase_block_T;\r\n\r\n#endif                             /* typedef_codertarget_arduinobase_block_T */\r\n\r\n#ifndef struct_tag_rn8hp99KB14Up87gfU4GGG\r\n#define struct_tag_rn8hp99KB14Up87gfU4GGG\r\n\r\nstruct tag_rn8hp99KB14Up87gfU4GGG\r\n{\r\n  int32_T isInitialized;\r\n  boolean_T isSetupComplete;\r\n  real_T pWinLen;\r\n  real_T pBuf[30];\r\n  real_T pHeap[30];\r\n  real_T pMidHeap;\r\n  real_T pIdx;\r\n  real_T pPos[30];\r\n  real_T pMinHeapLength;\r\n  real_T pMaxHeapLength;\r\n};\r\n\r\n#endif                                 /* struct_tag_rn8hp99KB14Up87gfU4GGG */\r\n\r\n#ifndef typedef_c_dsp_internal_MedianFilterCG_T\r\n#define typedef_c_dsp_internal_MedianFilterCG_T\r\n\r\ntypedef struct tag_rn8hp99KB14Up87gfU4GGG c_dsp_internal_MedianFilterCG_T;\r\n\r\n#endif                             /* typedef_c_dsp_internal_MedianFilterCG_T */\r\n\r\n#ifndef struct_tag_BlgwLpgj2bjudmbmVKWwDE\r\n#define struct_tag_BlgwLpgj2bjudmbmVKWwDE\r\n\r\nstruct tag_BlgwLpgj2bjudmbmVKWwDE\r\n{\r\n  uint32_T f1[8];\r\n};\r\n\r\n#endif                                 /* struct_tag_BlgwLpgj2bjudmbmVKWwDE */\r\n\r\n#ifndef typedef_cell_wrap_Abstandsensor_T\r\n#define typedef_cell_wrap_Abstandsensor_T\r\n\r\ntypedef struct tag_BlgwLpgj2bjudmbmVKWwDE cell_wrap_Abstandsensor_T;\r\n\r\n#endif                                 /* typedef_cell_wrap_Abstandsensor_T */\r\n\r\n#ifndef struct_tag_ZmjZODaMij0KiNsNKxzJBC\r\n#define struct_tag_ZmjZODaMij0KiNsNKxzJBC\r\n\r\nstruct tag_ZmjZODaMij0KiNsNKxzJBC\r\n{\r\n  boolean_T matlabCodegenIsDeleted;\r\n  int32_T isInitialized;\r\n  boolean_T isSetupComplete;\r\n  cell_wrap_Abstandsensor_T inputVarSize;\r\n  int32_T NumChannels;\r\n  c_dsp_internal_MedianFilterCG_T pMID;\r\n};\r\n\r\n#endif                                 /* struct_tag_ZmjZODaMij0KiNsNKxzJBC */\r\n\r\n#ifndef typedef_dsp_simulink_MedianFilter_Abs_T\r\n#define typedef_dsp_simulink_MedianFilter_Abs_T\r\n\r\ntypedef struct tag_ZmjZODaMij0KiNsNKxzJBC dsp_simulink_MedianFilter_Abs_T;\r\n\r\n#endif                             /* typedef_dsp_simulink_MedianFilter_Abs_T */\r\n\r\n/* Parameters (default storage) */\r\ntypedef struct P_Abstandsensor_T_ P_Abstandsensor_T;\r\n\r\n/* Forward declaration for rtModel */\r\ntypedef struct tag_RTM_Abstandsensor_T RT_MODEL_Abstandsensor_T;\r\n\r\n#endif                                 /* Abstandsensor_types_h_ */\r\n"},{"name":"Abstandsensor_data.c","type":"source","group":"data","path":"C:\\Users\\Sophie\\Documents\\Hochschule\\Master\\Semester 2\\Praktikum\\Versuche\\Projekte\\172-184\\184_Das_Geheimnis_der_Feder\\Abstandsensor_ert_rtw","tag":"","groupDisplay":"Data files","code":"/*\r\n * Abstandsensor_data.c\r\n *\r\n * Academic License - for use in teaching, academic research, and meeting\r\n * course requirements at degree granting institutions only.  Not for\r\n * government, commercial, or other organizational use.\r\n *\r\n * Code generation for model \"Abstandsensor\".\r\n *\r\n * Model version              : 10.15\r\n * Simulink Coder version : 24.1 (R2024a) 19-Nov-2023\r\n * C source code generated on : Mon Jan 13 17:19:51 2025\r\n *\r\n * Target selection: ert.tlc\r\n * Embedded hardware selection: Atmel->AVR\r\n * Code generation objectives: Unspecified\r\n * Validation result: Not run\r\n */\r\n\r\n#include \"Abstandsensor.h\"\r\n\r\n/* Block parameters (default storage) */\r\nP_Abstandsensor_T Abstandsensor_P = {\r\n  /* Expression: -1\r\n   * Referenced by: '<Root>/IR_Signal_roh'\r\n   */\r\n  -1.0,\r\n\r\n  /* Expression: -1\r\n   * Referenced by: '<Root>/Constant'\r\n   */\r\n  -1.0,\r\n\r\n  /* Expression: [625;500;350;270;220;180;142;120]\r\n   * Referenced by: '<Root>/1-D Lookup Table'\r\n   */\r\n  { 625.0, 500.0, 350.0, 270.0, 220.0, 180.0, 142.0, 120.0 },\r\n\r\n  /* Expression: [0.06;0.1;0.15;0.2;0.25;0.3;0.4;0.5]\r\n   * Referenced by: '<Root>/1-D Lookup Table'\r\n   */\r\n  { 0.06, 0.1, 0.15, 0.2, 0.25, 0.3, 0.4, 0.5 }\r\n};\r\n"},{"name":"multiword_types.h","type":"header","group":"utility","path":"C:\\Users\\Sophie\\Documents\\Hochschule\\Master\\Semester 2\\Praktikum\\Versuche\\Projekte\\172-184\\184_Das_Geheimnis_der_Feder\\Abstandsensor_ert_rtw","tag":"","groupDisplay":"Utility files","code":"/*\r\n * multiword_types.h\r\n *\r\n * Academic License - for use in teaching, academic research, and meeting\r\n * course requirements at degree granting institutions only.  Not for\r\n * government, commercial, or other organizational use.\r\n *\r\n * Code generation for model \"Abstandsensor\".\r\n *\r\n * Model version              : 10.15\r\n * Simulink Coder version : 24.1 (R2024a) 19-Nov-2023\r\n * C source code generated on : Mon Jan 13 17:19:51 2025\r\n *\r\n * Target selection: ert.tlc\r\n * Embedded hardware selection: Atmel->AVR\r\n * Code generation objectives: Unspecified\r\n * Validation result: Not run\r\n */\r\n\r\n#ifndef MULTIWORD_TYPES_H\r\n#define MULTIWORD_TYPES_H\r\n#include \"rtwtypes.h\"\r\n\r\n/*\r\n * Definitions supporting external data access\r\n */\r\ntypedef int32_T chunk_T;\r\ntypedef uint32_T uchunk_T;\r\n\r\n#endif                                 /* MULTIWORD_TYPES_H */\r\n"},{"name":"rtwtypes.h","type":"header","group":"utility","path":"C:\\Users\\Sophie\\Documents\\Hochschule\\Master\\Semester 2\\Praktikum\\Versuche\\Projekte\\172-184\\184_Das_Geheimnis_der_Feder\\Abstandsensor_ert_rtw","tag":"","groupDisplay":"Utility files","code":"/*\r\n * rtwtypes.h\r\n *\r\n * Academic License - for use in teaching, academic research, and meeting\r\n * course requirements at degree granting institutions only.  Not for\r\n * government, commercial, or other organizational use.\r\n *\r\n * Code generation for model \"Abstandsensor\".\r\n *\r\n * Model version              : 10.15\r\n * Simulink Coder version : 24.1 (R2024a) 19-Nov-2023\r\n * C source code generated on : Mon Jan 13 17:19:51 2025\r\n *\r\n * Target selection: ert.tlc\r\n * Embedded hardware selection: Atmel->AVR\r\n * Code generation objectives: Unspecified\r\n * Validation result: Not run\r\n */\r\n\r\n#ifndef RTWTYPES_H\r\n#define RTWTYPES_H\r\n\r\n/* Logical type definitions */\r\n#if (!defined(__cplusplus))\r\n#ifndef false\r\n#define false                          (0U)\r\n#endif\r\n\r\n#ifndef true\r\n#define true                           (1U)\r\n#endif\r\n#endif\r\n\r\n/*=======================================================================*\r\n * Target hardware information\r\n *   Device type: Atmel->AVR\r\n *   Number of bits:     char:   8    short:   16    int:  16\r\n *                       long:  32\r\n *                       native word size:   8\r\n *   Byte ordering: LittleEndian\r\n *   Signed integer division rounds to: Zero\r\n *   Shift right on a signed integer as arithmetic shift: on\r\n *=======================================================================*/\r\n\r\n/*=======================================================================*\r\n * Fixed width word size data types:                                     *\r\n *   int8_T, int16_T, int32_T     - signed 8, 16, or 32 bit integers     *\r\n *   uint8_T, uint16_T, uint32_T  - unsigned 8, 16, or 32 bit integers   *\r\n *   real32_T, real64_T           - 32 and 64 bit floating point numbers *\r\n *=======================================================================*/\r\ntypedef signed char int8_T;\r\ntypedef unsigned char uint8_T;\r\ntypedef int int16_T;\r\ntypedef unsigned int uint16_T;\r\ntypedef long int32_T;\r\ntypedef unsigned long uint32_T;\r\ntypedef float real32_T;\r\ntypedef double real64_T;\r\n\r\n/*===========================================================================*\r\n * Generic type definitions: boolean_T, char_T, byte_T, int_T, uint_T,       *\r\n *                           real_T, time_T, ulong_T.                        *\r\n *===========================================================================*/\r\ntypedef double real_T;\r\ntypedef double time_T;\r\ntypedef unsigned char boolean_T;\r\ntypedef int int_T;\r\ntypedef unsigned int uint_T;\r\ntypedef unsigned long ulong_T;\r\ntypedef char char_T;\r\ntypedef unsigned char uchar_T;\r\ntypedef char_T byte_T;\r\n\r\n/*===========================================================================*\r\n * Complex number type definitions                                           *\r\n *===========================================================================*/\r\n#define CREAL_T\r\n\r\ntypedef struct {\r\n  real32_T re;\r\n  real32_T im;\r\n} creal32_T;\r\n\r\ntypedef struct {\r\n  real64_T re;\r\n  real64_T im;\r\n} creal64_T;\r\n\r\ntypedef struct {\r\n  real_T re;\r\n  real_T im;\r\n} creal_T;\r\n\r\n#define CINT8_T\r\n\r\ntypedef struct {\r\n  int8_T re;\r\n  int8_T im;\r\n} cint8_T;\r\n\r\n#define CUINT8_T\r\n\r\ntypedef struct {\r\n  uint8_T re;\r\n  uint8_T im;\r\n} cuint8_T;\r\n\r\n#define CINT16_T\r\n\r\ntypedef struct {\r\n  int16_T re;\r\n  int16_T im;\r\n} cint16_T;\r\n\r\n#define CUINT16_T\r\n\r\ntypedef struct {\r\n  uint16_T re;\r\n  uint16_T im;\r\n} cuint16_T;\r\n\r\n#define CINT32_T\r\n\r\ntypedef struct {\r\n  int32_T re;\r\n  int32_T im;\r\n} cint32_T;\r\n\r\n#define CUINT32_T\r\n\r\ntypedef struct {\r\n  uint32_T re;\r\n  uint32_T im;\r\n} cuint32_T;\r\n\r\n/*=======================================================================*\r\n * Min and Max:                                                          *\r\n *   int8_T, int16_T, int32_T     - signed 8, 16, or 32 bit integers     *\r\n *   uint8_T, uint16_T, uint32_T  - unsigned 8, 16, or 32 bit integers   *\r\n *=======================================================================*/\r\n#define MAX_int8_T                     ((int8_T)(127))\r\n#define MIN_int8_T                     ((int8_T)(-128))\r\n#define MAX_uint8_T                    ((uint8_T)(255U))\r\n#define MAX_int16_T                    ((int16_T)(32767))\r\n#define MIN_int16_T                    ((int16_T)(-32768))\r\n#define MAX_uint16_T                   ((uint16_T)(65535U))\r\n#define MAX_int32_T                    ((int32_T)(2147483647L))\r\n#define MIN_int32_T                    ((int32_T)(-2147483647L-1L))\r\n#define MAX_uint32_T                   ((uint32_T)(0xFFFFFFFFUL))\r\n\r\n/* Block D-Work pointer type */\r\ntypedef void * pointer_T;\r\n\r\n#endif                                 /* RTWTYPES_H */\r\n"},{"name":"ext_mode_types.h","type":"header","group":"interface","path":"C:\\Users\\Sophie\\Documents\\Hochschule\\Master\\Semester 2\\Praktikum\\Versuche\\Projekte\\172-184\\184_Das_Geheimnis_der_Feder\\Abstandsensor_ert_rtw","tag":"","groupDisplay":"Interface files","code":"/*\r\n * ext_mode_types.h\r\n *\r\n * Academic License - for use in teaching, academic research, and meeting\r\n * course requirements at degree granting institutions only.  Not for\r\n * government, commercial, or other organizational use.\r\n *\r\n * Code generation for model \"Abstandsensor\".\r\n *\r\n * Model version              : 10.15\r\n * Simulink Coder version : 24.1 (R2024a) 19-Nov-2023\r\n * C source code generated on : Mon Jan 13 17:19:51 2025\r\n *\r\n * Target selection: ert.tlc\r\n * Embedded hardware selection: Atmel->AVR\r\n * Code generation objectives: Unspecified\r\n * Validation result: Not run\r\n */\r\n\r\n#ifndef EXT_MODE_TYPES_H\r\n#define EXT_MODE_TYPES_H\r\n#include \"rtwtypes.h\"\r\n\r\n/** External Mode Event ID */\r\ntypedef uint16_T extmodeEventId_T;\r\n\r\n/** External Mode real time, measured using the target's clock */\r\ntypedef uint32_T extmodeRealTime_T;\r\n\r\n/** External Mode simulation time */\r\ntypedef uint32_T extmodeSimulationTime_T;\r\n\r\n/** External Mode double data type */\r\ntypedef real_T extmodeDouble_T;\r\n\r\n/** External Mode classic trigger signal */\r\ntypedef real_T extmodeClassicTriggerSignal_T;\r\n\r\n/** Run the simulation forever (infinite simulation end time) */\r\n#define EXTMODE_SIMULATION_RUN_FOREVER ((extmodeSimulationTime_T) -1)\r\n\r\n/* Define max value of 32-bit unsigned type */\r\n#define XCP_UINT32_MAX                 0xFFFFFFFFU\r\n\r\n/** External Mode MAX simulation time */\r\n#define MAX_extmodeSimulationTime_T    XCP_UINT32_MAX\r\n\r\n/** External Mode MAX base rate simulation time */\r\n#define EXTMODE_MAX_BASE_RATE_SIMULATION_TIME XCP_UINT32_MAX\r\n\r\n/** External Mode Step Size in microseconds */\r\n#define EXTMODE_STEP_SIZE_IN_MICROSECONDS 200000\r\n\r\n/** External Mode Base rate event id */\r\n#define EXTMODE_BASE_RATE_EVENT_ID     0\r\n\r\n/** External Mode Max Event Id */\r\n#define EXTMODE_MAX_EVENT_ID           0xFF\r\n#endif                                 /* EXT_MODE_TYPES_H */\r\n\r\n/* [EOF] ext_mode_types.h */\r\n"},{"name":"rtmodel.h","type":"header","group":"interface","path":"C:\\Users\\Sophie\\Documents\\Hochschule\\Master\\Semester 2\\Praktikum\\Versuche\\Projekte\\172-184\\184_Das_Geheimnis_der_Feder\\Abstandsensor_ert_rtw","tag":"","groupDisplay":"Interface files","code":"/*\r\n * rtmodel.h\r\n *\r\n * Code generation for Simulink model \"Abstandsensor\".\r\n *\r\n * Simulink Coder version                : 24.1 (R2024a) 19-Nov-2023\r\n * C source code generated on : Mon Jan 13 17:19:51 2025\r\n *\r\n * Note that the generated code is not dependent on this header file.\r\n * The file is used in cojuction with the automatic build procedure.\r\n * It is included by the sample main executable harness\r\n * MATLAB/rtw/c/src/common/rt_main.c.\r\n *\r\n */\r\n\r\n#ifndef rtmodel_h_\r\n#define rtmodel_h_\r\n#include \"Abstandsensor.h\"\r\n#endif                                 /* rtmodel_h_ */\r\n"},{"name":"ArduinoPinHandleMap.cpp","type":"source","group":"legacy","path":"C:\\Users\\Sophie\\Documents\\Hochschule\\Master\\Semester 2\\Praktikum\\Versuche\\Projekte\\172-184\\184_Das_Geheimnis_der_Feder\\Abstandsensor_ert_rtw\\..\\..\\..\\..\\..\\..\\..\\..\\..\\..\\..\\..\\ProgramData\\MATLAB\\SupportPackages\\R2024a\\toolbox\\target\\supportpackages\\arduinobase\\src","tag":"","groupDisplay":"Other files","code":"#include \"rtwtypes.h\"\n\n#define ANALOG_MODULES_MAX 70  /* For Mega and Due. Other boards have less number of Modules */\n#define PWM_MODULES_MAX 70  /* For Mega and Due. Other boards have less number of Modules */\n\n#ifdef __cplusplus\nextern \"C\" {\n#endif\n    \ntypedef uint8_T PeripheralHandleMapType;\nPeripheralHandleMapType analogPinHandleMap[(ANALOG_MODULES_MAX/8)+1] = {0};\nPeripheralHandleMapType PWMPinHandleMap[(PWM_MODULES_MAX/8)+1] = {0};\n\n#ifdef __cplusplus\n}\n#endif\n"},{"name":"MW_AnalogInput.cpp","type":"source","group":"legacy","path":"C:\\Users\\Sophie\\Documents\\Hochschule\\Master\\Semester 2\\Praktikum\\Versuche\\Projekte\\172-184\\184_Das_Geheimnis_der_Feder\\Abstandsensor_ert_rtw\\..\\..\\..\\..\\..\\..\\..\\..\\..\\..\\..\\..\\ProgramData\\MATLAB\\SupportPackages\\R2024a\\toolbox\\target\\supportpackages\\arduinobase\\src","tag":"","groupDisplay":"Other files","code":"/* Copyright 2017-2020 The MathWorks, Inc. */\n\n#include \"MW_AnalogIn.h\"\n\n#if !(( defined(MATLAB_MEX_FILE) || defined(RSIM_PARAMETER_LOADING) ||  defined(RSIM_WITH_SL_SOLVER) ))\n#include \"Arduino.h\"\n#endif\n\n#ifdef __cplusplus\nextern \"C\" {\n#endif\n    \n#define ANALOG_MODULES_MAX 70  /* For Mega and Due. Other boards have less number of Modules */\n    \n    typedef uint8_T PeripheralHandleMapType;\n    extern PeripheralHandleMapType analogPinHandleMap[];    /* The array is defined in ArduinoPinHandleMap.cpp */\n    \n    void setHandle(uint32_T Pin, MW_Handle_Type handle);\n    \n    /* Create AnalogIn group with Channels and Conversion time */\n    MW_Handle_Type MW_AnalogInSingle_Open(uint32_T Pin)\n    {\n#if ( defined(MATLAB_MEX_FILE) || defined(RSIM_PARAMETER_LOADING) ||  defined(RSIM_WITH_SL_SOLVER) )\n        /* This will be run in Rapid Accelerator Mode */\n        return NULL;\n#else\n        if (Pin < A0)\n        {\n            pinMode(Pin+A0, INPUT);\n        }\n        else{\n            pinMode(Pin, INPUT);\n        }\n        /* handle is stored as Pin+1 because, to reset the handle of a pin, 0 is passed as handle. Otherwise it will create confusion for Pin number 0. */\n        setHandle(Pin, (MW_Handle_Type)(Pin+1));\n        return (MW_Handle_Type)(Pin+1);\n#endif\n        \n    }\n    \n    /* Select trigger source for AnalogIn group to start conversion */\n    void MW_AnalogIn_SetTriggerSource(MW_Handle_Type AnalogInHandle, MW_AnalogIn_TriggerSource_Type TriggerType, uint32_T TriggerValue)\n    {\n        (void)AnalogInHandle;\n        (void)TriggerType;\n        (void)TriggerValue;\n    }\n    \n    /* Enable Conversion complete notification */\n    void MW_AnalogIn_EnableNotification(MW_Handle_Type AnalogInHandle)\n    {\n        (void)AnalogInHandle;\n    }\n    \n    /* Disable notifications */\n    void MW_AnalogIn_DisableNotification(MW_Handle_Type AnalogInHandle)\n    {\n        (void)AnalogInHandle;\n    }\n    \n    /* Enable continuous conversion */\n    void MW_AnalogIn_EnableContConversion(MW_Handle_Type AnalogInHandle)\n    {\n        (void)AnalogInHandle;\n    }\n    \n    /* Set channel conversion priority */\n    void MW_AnalogIn_SetChannelConvRank(MW_Handle_Type AnalogInHandle, uint32_T Channel, uint32_T Rank)\n    {\n        (void)AnalogInHandle;\n        (void)Channel;\n        (void)Rank;\n    }\n    \n    /* Get status of AnalogIn conversion group */\n    MW_AnalogIn_Status_Type MW_AnalogIn_GetStatus(MW_Handle_Type AnalogInHandle)\n    {\n        return MW_ANALOGIN_CONVERSION_COMPLETE;\n    }\n    \n    /* Read channel conversion result */\n    void MW_AnalogInSingle_ReadResult(MW_Handle_Type AnalogInHandle, void * Result_ptr, MW_AnalogIn_ResultDataType_Type ResultDataType)\n    {\n#if ( defined(MATLAB_MEX_FILE) || defined(RSIM_PARAMETER_LOADING) ||  defined(RSIM_WITH_SL_SOLVER) )\n        /* This will be run in Rapid Accelerator Mode */\n        return;\n#else\n        uint8_T pin;\n        /* If a non zero handle is passed then read the analog input. Otherwise return 0. This\n     is useful for MATLAB codegen is the user tries to read without configuring. In Simulink\n     this situation should never arise*/\n        if(*((uint8_T*)(&AnalogInHandle)))\n        {\n            /* The handle of a Pin is stored as (Pin+1) */\n            pin = *((uint8_T*)(&AnalogInHandle)) - 1;\n            /*Use 12-bit read resolution for Due, MKR1000*/\n#if defined(ARDUINO_ARM) || defined(ARDUINO_ARDUINO_NANO33BLE)\n            analogReadResolution(12);\n#endif\n            int sensorValue = analogRead(pin);\n            *(uint16_T *)Result_ptr = sensorValue;\n        }\n        else{\n            *(uint16_T *)Result_ptr = 0;\n        }\n#endif\n    }\n    \n    /* Start conversion */\n    void MW_AnalogIn_Start(MW_Handle_Type AnalogInHandle)\n    {\n        (void)AnalogInHandle;\n    }\n    \n    /* Stop conversion */\n    void MW_AnalogIn_Stop(MW_Handle_Type AnalogInHandle)\n    {\n        (void)AnalogInHandle;\n    }\n    \n    /* De-initialise */\n    void MW_AnalogIn_Close(MW_Handle_Type AnalogInHandle)\n    {\n#if ( defined(MATLAB_MEX_FILE) || defined(RSIM_PARAMETER_LOADING) ||  defined(RSIM_WITH_SL_SOLVER) )\n        return;\n#else\n        /* If the analog handle is 0 then do nothing. */\n        if(*((uint8_T*)(&AnalogInHandle)))\n        {\n            uint8_T pin = 0;\n            /* The handle of a Pin is stored as (Pin+1) */\n            pin = *((uint8_T*)(&AnalogInHandle)) - 1;\n            /* Reset the handle for that particular pin */\n            setHandle(pin, (MW_Handle_Type)0);\n        }\n        (void)AnalogInHandle;\n#endif\n    }\n    \n    MW_Handle_Type MW_AnalogIn_GetHandle(uint32_T Pin)\n    {\n#if ( defined(MATLAB_MEX_FILE) || defined(RSIM_PARAMETER_LOADING) ||  defined(RSIM_WITH_SL_SOLVER) )\n        return NULL;\n#else\n        uint16_T ByteNo=0, handleValue=0;\n        \n        uint8_T BitPositionNo=0;\n        \n        ByteNo = Pin/8;\n        BitPositionNo = Pin%8;\n        \n        handleValue = analogPinHandleMap[ByteNo] & (PeripheralHandleMapType)(1<<BitPositionNo);\n        \n        if(handleValue)\n        {\n            /*\n             * Returns the value of the module if the pin is opened earlier\n             */\n            /* What will happen if Pin value is 0 itself? */\n            handleValue = Pin+1;\n            /*\n             * This allows to differentiate between pin zero and a Null condition\n             *\n             * Another option - return true, and then remove the decrement in the SVD of all functions in Arduino\n             */\n        }\n        else\n        {\n            handleValue = 0;\n        }\n        return (MW_Handle_Type)handleValue;\n#endif\n    }\n    \n    void setHandle(uint32_T module, MW_Handle_Type handle)\n    {\n#if ( defined(MATLAB_MEX_FILE) || defined(RSIM_PARAMETER_LOADING) ||  defined(RSIM_WITH_SL_SOLVER) )\n        return;\n#else\n        /*\n    Assumes pin number from count zero\n         */\n        uint16_T ByteNo=0;\n        uint8_T BitPositionNo=0;\n        PeripheralHandleMapType tempVar=0;\n        /*\n         * Integer division rounds off to value providing the abs byte no\n         */\n        ByteNo = module/8;\n        BitPositionNo = module%8;\n        \n        tempVar = (1<<BitPositionNo);\n        /*\n         * The assumption is module number is the handle,\n         * but when handle is Null, reset the handle\n         */\n        if(!handle)\n        {\n            /*reset the handle*/\n            tempVar = ~tempVar;\n            analogPinHandleMap[ByteNo] = analogPinHandleMap[ByteNo] & tempVar;\n        }\n        else\n        {\n            /*set the handle*/\n            analogPinHandleMap[ByteNo] = analogPinHandleMap[ByteNo] | tempVar;\n        }\n#endif\n    }\n    \n#ifdef __cplusplus\n}\n#endif\n"},{"name":"MW_ArduinoHWInit.cpp","type":"source","group":"legacy","path":"C:\\Users\\Sophie\\Documents\\Hochschule\\Master\\Semester 2\\Praktikum\\Versuche\\Projekte\\172-184\\184_Das_Geheimnis_der_Feder\\Abstandsensor_ert_rtw\\..\\..\\..\\..\\..\\..\\..\\..\\..\\..\\..\\..\\ProgramData\\MATLAB\\SupportPackages\\R2024a\\toolbox\\target\\supportpackages\\arduinotarget\\src","tag":"","groupDisplay":"Other files","code":"/* Arduino AVR Bareboard scheduler\n*\n* Copyright 2014-2023 The MathWorks, Inc.\n*/\n\n#include \"Arduino.h\"\n#include \"io_wrappers.h\"\n#if defined(ARDUINO_ARM_CORTEX_M0_PLUS)\n#include \"arduinoARM_M0plusScheduler.h\"\n#elif defined(ARDUINO_ARM_CORTEX_M3)\n#include \"arduinoARMScheduler.h\"\n#include \"watchdog.h\"\n#else\n#include \"arduinoAVRScheduler.h\"\n#endif\n\n#if defined(ESP_PLATFORM)\n#include \"esp_wpa2.h\" //wpa2 library for connections to Enterprise networks\n#endif\n\n#ifdef _RTT_NUMI2C_\n#include \"MW_arduinoI2C.h\"\n#endif\n\n#if defined(ARDUINO_ARDUINO_NANO33BLE)\n#include \"MW_PWM_NANO33BLE.h\"\n#endif\n\n#if (defined(MW_ARDUINO_OV2640CSPIN)) || (defined(_RTT_SPI_SSPIN_)) || (defined(_RTT_DUE_SPI_SSPIN4_)) || (defined(_RTT_DUE_SPI_SSPIN10_)) || (defined(_RTT_DUE_SPI_SSPIN52_))\n#include \"MW_SPIwriteRead.h\"\n#endif\n\n#if (defined(_RTT_RS485_INUSE_))\n#include \"ArduinoRS485.h\"\n#endif\n\n#if (defined(_RTT_MODBUS_MASTER_)) || (defined(_RTT_MODBUS_SLAVE_))\n#include \"ArduinoModbus.h\"\n#endif\n\n#ifdef NANO_MOTOR_CARRIER\n#include <Wire.h>\n#define PMIC_ADDRESS  0x6B\n#define PMIC_REG00    0x00\n#define PMIC_REG01    0x01\n#define PMIC_REG02    0x02\n#define PMIC_REG04    0x04\n#define PMIC_REG05    0x05\nvoid MW_EnableNanoCarrierBatteryCharging(void);\n#endif\n\n// Wifi init routines\n#include <inttypes.h>\n#if (defined(_RTT_WIFI_EXTMODE_) && (_RTT_WIFI_EXTMODE_ == 1)) || (defined(_RTT_WIFI_UDP_) && (_RTT_WIFI_UDP_ != 0)) || (defined(_RTT_WIFI_TCP_) && (_RTT_WIFI_TCP_ != 0))|| defined(_RTT_THINGSPEAK_WIFI_) || defined(_RTT_WEBSOCKET_PORT_) || defined(_RTT_MQTT_WIFI_) || defined(_RTT_HTTP_CLIENT_)\n#if defined(ARDUINO_WIFI_LIB_101)\n#include <WiFi101.h>\n#elif defined(ARDUINO_WIFI_LIB_NINA)\n#include <WiFiNINA.h>\n#else\n#include <WiFi.h>\n#endif\n#include <SPI.h>\n\n/*#define that helps to stringify build flags\n//Double evaluation is needed so that the double quotes can be derived out\n//of the build flag and can be assigned to a character array */\n#define RTT_StringifyBuildFlag(x) RTT_StringParamExpanded(x)\n#define RTT_StringParamExpanded(x)  #x\n\n#if (_RTT_DISABLE_Wifi_DHCP_ == 1)\nIPAddress wifiLocalIpAddress(_RTT_WIFI_Local_IP1, _RTT_WIFI_Local_IP2, _RTT_WIFI_Local_IP3, _RTT_WIFI_Local_IP4);\n#endif\n\n#if (_RTT_DISABLE_Wifi_DHCP_ == 2)\nIPAddress wifiLocalIpAddress(_RTT_WIFI_Local_IP1, _RTT_WIFI_Local_IP2, _RTT_WIFI_Local_IP3, _RTT_WIFI_Local_IP4);\nIPAddress wifiGatewayAddress(_RTT_WIFI_Gateway_IP1, _RTT_WIFI_Gateway_IP2, _RTT_WIFI_Gateway_IP3, _RTT_WIFI_Gateway_IP4);\nIPAddress wifiSubnetMask(_RTT_WIFI_Subnet_IP1, _RTT_WIFI_Subnet_IP2, _RTT_WIFI_Subnet_IP3, _RTT_WIFI_Subnet_IP4);\nIPAddress wifiDNSAddress(_RTT_WIFI_DNS_IP1, _RTT_WIFI_DNS_IP2, _RTT_WIFI_DNS_IP3, _RTT_WIFI_DNS_IP4);\n#endif\n\n#ifdef ESP_PLATFORM\nIPAddress wifigateway(_RTT_WIFI_Local_IP1, _RTT_WIFI_Local_IP2, _RTT_WIFI_Local_IP3, uint8_t(1));\nIPAddress subnet(uint8_t(255),uint8_t(255),uint8_t(255),uint8_t(0));\nIPAddress dns1 = (uint32_t)0x00000000;\nIPAddress dns2 = (uint32_t)0x00000000;\n#endif\n\nchar ssid[] = RTT_StringifyBuildFlag(_RTT_WIFI_SSID);\nint configureSuccess = WL_IDLE_STATUS;\nint trialcount;\n\n#ifdef _RTT_WIFI_WEP\nchar key[] = RTT_StringifyBuildFlag(_RTT_WIFI_KEY);\nint keyIndex = _RTT_WIFI_KEY_INDEX;\n#endif //_RTT_WIFI_WEP\n\n#ifdef _RTT_WIFI_WPA\nchar wpapass[] = RTT_StringifyBuildFlag(_RTT_WIFI_WPA_PASSWORD);\n#endif //_RTT_WIFI_WPA\n\n#ifdef _RTT_WIFI_WPA2_ENTERPRISE\nchar wpa2username[] = RTT_StringifyBuildFlag(_RTT_WIFI_WPA2_USERNAME);\nchar wpa2password[] = RTT_StringifyBuildFlag(_RTT_WIFI_WPA2_PASSWORD);\n#endif //_RTT_WIFI_WPA2_ENTERPRISE\n#endif //(defined(_RTT_THINGSPEAK_WIFI_) || (_RTT_WIFI_TCP_ !=0) || defined(_RTT_WEBSOCKET_PORT_))\n\n#include \"MW_ArduinoHWInit.h\"\n#ifdef _MW_DASHBOARD_BLOCK_PRESENT_\n#include \"MW_graphicPrimitive.h\"\n#endif\n\n\n\nvoid MW_Modbus_Slave_Poll(void)\n{\n    #if defined(_RTT_MODBUS_SLAVE_)\n    ModbusRTUServer.poll();\n    #endif\n}\n\nvoid MW_ArduinoNano33BLESenseInit(void)\n{\n    #if (defined(ARDUINO_ARDUINO_NANO33BLE))\n    initVariant();\n    #if defined(SERIAL_CDC)\n    PluggableUSBD().begin();\n    SerialUSB.begin(115200);\n    #endif\n    #if defined(_RTT_PWM_NANO33BLE_INUSE)\n    MW_NANO33BLE_PWM_Setup();\n    #endif\n    #endif\n}\n\nvoid MW_Arduino_Init(void)\n{\n    //Hardware specific init for Arduino nano 33 ble sense\n    #if (defined(ARDUINO_ARDUINO_NANO33BLE))\n    MW_ArduinoNano33BLESenseInit();\n    #endif\n    //Disable watchdog for Arduino Due. watchdog\n    #if (defined(_ROTH_DUE_))\n    watchdogDisable();\n    #endif\n    //Disable watchdog for ESP32\n    #if (defined(ESP_PLATFORM))\n    initArduino();\n    disableCore0WDT();\n    #endif\n\n    /*\n    * Initialize Serial Peripheral\n    */\n    // Always Initialize Serial0\n    #if(defined(ESP_PLATFORM))\n    #else\n    Serial_begin(0, _RTT_BAUDRATE_SERIAL0_, _RTT_CONFIG_SERIAL0_);\n    #endif\n\n    /* Overrun Detection Initialization */\n    #ifdef _RTT_OVERRUN_DIGITAL_PIN_\n    pinMode(_RTT_OVERRUN_DIGITAL_PIN_, OUTPUT);\n\n    /* Init the overrun detection pin to zero or else the Pin is always in a\n    * high/tristate giving the user a wrong indication of overrun conditions */\n    digitalWrite(_RTT_OVERRUN_DIGITAL_PIN_, LOW);\n    #endif\n\n    /*\n    * Initialize Analog Reference Voltage\n    * Default - Due\n    * Default, Internal 1.1, Internal 2.56, External -  Mega 2560, Mega ADK\n    * Default, Internal, External - Other Arduino targets\n    */\n    #if (defined(_ROTH_MEGA2560_))\n    #if (defined(_RTT_ANALOG_REF_) && (_RTT_ANALOG_REF_ == 1))\n    analogReference(INTERNAL1V1);\n    #elif (defined(_RTT_ANALOG_REF_) && (_RTT_ANALOG_REF_ == 2))\n    analogReference(INTERNAL2V56);\n    #elif (defined(_RTT_ANALOG_REF_) && (_RTT_ANALOG_REF_ == 3))\n    analogReference(EXTERNAL);\n    #endif\n    #elif defined(ARDUINO_ARM_CORTEX_M0_PLUS)\n    #if (defined(_RTT_ANALOG_REF_) && (_RTT_ANALOG_REF_ == 1))\n    analogReference(AR_INTERNAL1V0);\n    #elif (defined(_RTT_ANALOG_REF_) && (_RTT_ANALOG_REF_ == 2))\n    analogReference(AR_INTERNAL1V65);\n    #elif (defined(_RTT_ANALOG_REF_) && (_RTT_ANALOG_REF_ == 3))\n    analogReference(AR_INTERNAL2V23);\n    #elif (defined(_RTT_ANALOG_REF_) && (_RTT_ANALOG_REF_ == 4))\n    analogReference(AR_EXTERNAL);\n    #endif\n    #else\n    #if (defined(_RTT_ANALOG_REF_) && (_RTT_ANALOG_REF_ == 1))\n    analogReference(INTERNAL);\n    #elif (defined(_RTT_ANALOG_REF_) && (_RTT_ANALOG_REF_ == 2))\n    analogReference(EXTERNAL);\n    #endif\n    #endif\n\n    /*\n    * Initialize SPI bus\n    */\n    //_RTT_SPI_SSPIN_ definition is applicable for all boards excluding Due\n    #if (defined(_RTT_SPI_SSPIN_)) || (defined(MW_ARDUINO_OV2640CSPIN))\n    MW_SPIwriteReadSetup();\n    #endif\n\n    //Initialize Modbus\n    int modStatus;\n    #if defined(_RTT_MODBUS_MASTER_)\n    modStatus = ModbusRTUClient.begin(_RTT_RS485_BAUD_, _RTT_RS485_CONFIG_);\n    ModbusRTUClient.setTimeout(_RTT_MODBUS_MASTERTIMEOUT_/1000);\n    #endif\n\n    #if defined(_RTT_MODBUS_SLAVE_)\n    modStatus = ModbusRTUServer.begin(_RTT_MODBUS_SLAVEID_, _RTT_RS485_BAUD_, _RTT_RS485_CONFIG_);\n    #if defined(_RTT_MODBUS_CONFIGCOIL_)\n    ModbusRTUServer.configureCoils(_RTT_MODBUS_COILADDR_,_RTT_MODBUS_COILNUM_);\n    #endif\n    #if defined(_RTT_MODBUS_CONFIGINPUT_)\n    ModbusRTUServer.configureDiscreteInputs(_RTT_MODBUS_INPUPTADDR_,_RTT_MODBUS_INPUTNUM_);\n    #endif\n    #if defined(_RTT_MODBUS_CONFIGHOLDINGREG_)\n    ModbusRTUServer.configureHoldingRegisters(_RTT_MODBUS_HOLDINGREGADDR_,_RTT_MODBUS_HOLDINGREGNUM_);\n    #endif\n    #if defined(_RTT_MODBUS_CONFIGINPUTREG_)\n    ModbusRTUServer.configureInputRegisters(_RTT_MODBUS_INPUTREGADDR_,_RTT_MODBUS_INPUTREGNUM_);\n    #endif\n    #endif\n\n    /*\n    * Initialize wifi\n    */\n    #if (defined(_RTT_WIFI_UDP_) && (_RTT_WIFI_UDP_ != 0)) || (defined(_RTT_WIFI_TCP_) && (_RTT_WIFI_TCP_ != 0))|| defined(_RTT_THINGSPEAK_WIFI_) || defined(_RTT_WEBSOCKET_PORT_) || defined(_RTT_MQTT_WIFI_) || defined(_RTT_HTTP_CLIENT_)\n    /* Begin WiFi*/\n    while(configureSuccess!=WL_CONNECTED)\n    {\n        #if (defined(_RTT_DISABLE_Wifi_DHCP_) && (_RTT_DISABLE_Wifi_DHCP_ !=0))\n            #ifdef ESP_PLATFORM\n                #if (_RTT_DISABLE_Wifi_DHCP_ == 1)\n                WiFi.config(wifiLocalIpAddress,wifigateway, subnet, dns1, dns2);\n                #else\n                WiFi.config(wifiLocalIpAddress, wifiGatewayAddress, wifiSubnetMask, wifiDNSAddress);\n                #endif\n            #elif (_RTT_DISABLE_Wifi_DHCP_ == 1)\n            WiFi.config(wifiLocalIpAddress);\n            #else\n            WiFi.config(wifiLocalIpAddress, wifiDNSAddress, wifiGatewayAddress, wifiSubnetMask);\n            #endif\n        #endif\n\n        #ifdef _RTT_WIFI_WEP\n        configureSuccess=WiFi.begin(ssid,keyIndex,key);\n        #endif //_RTT_WIFI_WEP\n\n        #ifdef _RTT_WIFI_WPA\n        configureSuccess=WiFi.begin(ssid,wpapass);\n        #endif //_RTT_WIFI_WPA\n\n        #ifdef _RTT_WIFI_WPA2_ENTERPRISE\n        #if defined(ESP_PLATFORM)\n        WiFi.disconnect(true);  //disconnect form wifi to set new wifi connection\n        WiFi.mode(WIFI_STA); //init wifi mode\n        configureSuccess = WiFi.begin(ssid, WPA2_AUTH_PEAP, wpa2username, wpa2username, wpa2password); //connect to wifi\n        #elif defined(ARDUINO_WIFI_LIB_NINA)\n        configureSuccess=WiFi.beginEnterprise(ssid,wpa2username,wpa2password);\n        #endif\n        #endif //_RTT_WIFI_WPA2_ENTERPRISE\n\n        #ifdef _RTT_WIFI_NONE\n        configureSuccess=WiFi.begin(ssid);\n        #endif //_RTT_WIFI_NONE\n\n        #if (defined(ESP_PLATFORM))\n        while (WiFi.status() != WL_CONNECTED) {\n            delay(500);\n        }\n        configureSuccess=WL_CONNECTED;\n        #else\n        //Wait for 10 seconds for Wifi connection to happen\n        unsigned long startMillis  = millis();\n        while(millis()- startMillis < 1000)\n        {\n        };\n        #endif\n    }\n\n    /* Wait for Serial0 to be up*/\n    for(trialcount=0;trialcount<5;trialcount++)\n    {\n        if(Serial)\n        {\n            break;\n        }else\n        {\n            unsigned long startMillis  = millis();\n            while(millis()- startMillis < 1000)\n            {\n            };\n        }\n    }\n\n    #if (!(defined(_RTT_WIFI_EXTMODE_) && (_RTT_WIFI_EXTMODE_ == 1)))\n    if (configureSuccess==WL_CONNECTED)\n    {\n        // If the Configuration is successful, relay back the assigned IP address.\n        #if(defined(ESP_PLATFORM))\n        Serial_begin(0, _RTT_BAUDRATE_SERIAL0_, _RTT_CONFIG_SERIAL0_);\n        #endif\n        IPAddress ip = WiFi.localIP();\n        //Adding a precautionary check using a Serial command so as to print the IP address so that it is available at least 6 times \n        //and the chances of it not being assigned to Target are minimised.\n        for(int ipSendcounter=0; ipSendcounter<6; ipSendcounter++)\n        {\n            Serial.print(\"<<< IP address :\");\n            Serial.print(ip);\n            Serial.println(\" >>>\");\n            delay(500);\n        }\n    }\n    else\n    {\n        // If the Configuration failed,relay back the error message.\n        Serial.println(\"<<< IP address :Failed to configure. >>>\");\n    }\n    #endif //(!(defined(_RTT_WIFI_EXTMODE_) && (_RTT_WIFI_EXTMODE_ == 1)))\n\n    #endif /*Initialize wifi*/\n    #ifdef NANO_MOTOR_CARRIER\n    MW_EnableNanoCarrierBatteryCharging();\n    #endif\n    #ifdef _MW_DASHBOARD_BLOCK_PRESENT_\n    MW_initScreen();\n    #endif\n\n    #if defined(ARDUINO_ARCH_SAMD) && defined(MW_SAMD_EVSYS_ENABLE)\n    PM->APBCMASK.reg |= PM_APBCMASK_EVSYS;                                              // Switch on the event system peripheral\n    #if defined(MW_SAMD_EVSYS_CH0)\n    EVSYS->USER.reg = EVSYS_USER_CHANNEL(1) |                                           // Attach the event user (receiver) to channel 0 (n + 1)\n        EVSYS_USER_USER(EVSYS_CH0_USER_EVENT);                            // Set the event user (receiver) as EVSYS_CH1_USER_EVENT\n    EVSYS->CHANNEL.reg = EVSYS_CHANNEL_EDGSEL_NO_EVT_OUTPUT |                           // No event edge detection\n        EVSYS_CHANNEL_PATH_ASYNCHRONOUS |                              // Set event path as asynchronous\n        EVSYS_CHANNEL_EVGEN(EVSYS_CH0_GEN_EVENT) |                     // Set event generator (sender) as EVSYS_CH1_GEN_EVENT\n        EVSYS_CHANNEL_CHANNEL(0);                                      // Attach the generator (sender) to channel 0\n    EVSYS_CH0_USER->EVCTRL.reg |= EVSYS_CH0_USER_START_CMD;\n    EVSYS_CH0_GEN->EVCTRL.reg |= EVSYS_CH0_GEN_START_CMD;\n    #endif\n    #if defined(MW_SAMD_EVSYS_CH1)\n    EVSYS->USER.reg = EVSYS_USER_CHANNEL(2) |                                           // Attach the event user (receiver) to channel 1 (n + 1)\n        EVSYS_USER_USER(EVSYS_CH1_USER_EVENT);                            // Set the event user (receiver) as EVSYS_CH2_USER_EVENT\n    EVSYS->CHANNEL.reg = EVSYS_CHANNEL_EDGSEL_NO_EVT_OUTPUT |                           // No event edge detection\n        EVSYS_CHANNEL_PATH_ASYNCHRONOUS |                              // Set event path as asynchronous\n        EVSYS_CHANNEL_EVGEN(EVSYS_CH1_GEN_EVENT) |                     // Set event generator (sender) as EVSYS_CH2_GEN_EVENT\n        EVSYS_CHANNEL_CHANNEL(1);                                      // Attach the generator (sender) to channel 1\n    EVSYS_CH1_USER->EVCTRL.reg |= EVSYS_CH1_USER_START_CMD;\n    EVSYS_CH1_GEN->EVCTRL.reg |= EVSYS_CH1_GEN_START_CMD;\n    #endif\n    #if defined(MW_SAMD_EVSYS_CH2)\n    EVSYS->USER.reg = EVSYS_USER_CHANNEL(3) |                                           // Attach the event user (receiver) to channel 2 (n + 1)\n        EVSYS_USER_USER(EVSYS_CH2_USER_EVENT);                            // Set the event user (receiver) as EVSYS_CH3_USER_EVENT\n    EVSYS->CHANNEL.reg = EVSYS_CHANNEL_EDGSEL_NO_EVT_OUTPUT |                           // No event edge detection\n        EVSYS_CHANNEL_PATH_ASYNCHRONOUS |                              // Set event path as asynchronous\n        EVSYS_CHANNEL_EVGEN(EVSYS_CH2_GEN_EVENT) |                     // Set event generator (sender) as EVSYS_CH3_GEN_EVENT\n        EVSYS_CHANNEL_CHANNEL(2);                                      // Attach the generator (sender) to channel 2\n    EVSYS_CH2_USER->EVCTRL.reg |= EVSYS_CH2_USER_START_CMD;\n    EVSYS_CH2_GEN->EVCTRL.reg |= EVSYS_CH2_GEN_START_CMD;\n    #endif\n    #if defined(MW_SAMD_EVSYS_CH3)\n    EVSYS->USER.reg = EVSYS_USER_CHANNEL(4) |                                           // Attach the event user (receiver) to channel 3 (n + 1)\n        EVSYS_USER_USER(EVSYS_CH3_USER_EVENT);                            // Set the event user (receiver) as EVSYS_CH4_USER_EVENT\n    EVSYS->CHANNEL.reg = EVSYS_CHANNEL_EDGSEL_NO_EVT_OUTPUT |                           // No event edge detection\n        EVSYS_CHANNEL_PATH_ASYNCHRONOUS |                              // Set event path as asynchronous\n        EVSYS_CHANNEL_EVGEN(EVSYS_CH3_GEN_EVENT) |                     // Set event generator (sender) as EVSYS_CH4_GEN_EVENT\n        EVSYS_CHANNEL_CHANNEL(3);                                      // Attach the generator (sender) to channel 3\n    EVSYS_CH3_USER->EVCTRL.reg |= EVSYS_CH3_USER_START_CMD;\n    EVSYS_CH3_GEN->EVCTRL.reg |= EVSYS_CH3_GEN_START_CMD;\n    #endif\n    #endif\n}\n/* Function: MW_Arduino_Terminate ================================================\n* For Arduino MKR/Leonardo and its variants, the Virtual COM port is handled\n* by the controller. In case the code running on the target exits main,\n* the COM port cannot be accessed until a hard reset is performed.\n* To over come this issue, a while loop is added to make sure that\n* upon getting a stop command from external mode, the code running on\n* the target stops but the code will not exit the main.\n* This will ensure that the COM port is accessible even after the\n* external mode has been stopped. */\nvoid MW_Arduino_Terminate(void){\n    #if defined(ARDUINO_VIRTUAL_COM_PORT) || (defined(ARDUINO_ARDUINO_NANO33BLE) && (!defined(USE_MBEDRTOS)))\n    disable_rt_OneStep();\n    while(1){};     /* To continue virtual COM port functionality */\n    #endif\n}\n\n#ifdef NANO_MOTOR_CARRIER\nvoid MW_EnableNanoCarrierBatteryCharging(void) {\n    Wire.begin();\n    Wire.beginTransmission(PMIC_ADDRESS);\n    Wire.write(PMIC_REG00);\n    Wire.write(0x06); // min sys voltage 3.88V + max input current 2.0 A\n    Wire.endTransmission();\n    Wire.beginTransmission(PMIC_ADDRESS);\n    Wire.write(PMIC_REG01);\n    Wire.write(0x1B); // Charge Battery + Minimum System Voltage 3.5V\n    Wire.endTransmission();\n    Wire.beginTransmission(PMIC_ADDRESS);\n    Wire.write(PMIC_REG02);\n    Wire.write(0x00); // Charge current  512 mA\n    Wire.endTransmission();\n    Wire.beginTransmission(PMIC_ADDRESS);\n    Wire.write(PMIC_REG04);\n    Wire.write(0x9E); // Charge Voltage Limit 4.128V\n    Wire.endTransmission();\n    Wire.beginTransmission(PMIC_ADDRESS);\n    Wire.write(PMIC_REG05);\n    Wire.write(0x8A); // Enable Battery Charge termination + disable watchdog\n    Wire.endTransmission();\n}\n#endif\n\n\n// Overrun detection function for ESP32\n#if defined(ESP_PLATFORM) && defined(_RTT_OVERRUN_DIGITAL_PIN_)\nvoid onOverrunDetect(int id)\n{\n    digitalWrite(_RTT_OVERRUN_DIGITAL_PIN_, HIGH);\n}\n#endif\n// LocalWords:  AVR Bareboard ADK SPI RTT SSPIN Modbus MKR"},{"name":"MW_arduino_digitalio.cpp","type":"source","group":"legacy","path":"C:\\Users\\Sophie\\Documents\\Hochschule\\Master\\Semester 2\\Praktikum\\Versuche\\Projekte\\172-184\\184_Das_Geheimnis_der_Feder\\Abstandsensor_ert_rtw\\..\\..\\..\\..\\..\\..\\..\\..\\..\\..\\..\\..\\ProgramData\\MATLAB\\SupportPackages\\R2024a\\toolbox\\target\\supportpackages\\arduinobase\\src","tag":"","groupDisplay":"Other files","code":"#ifndef MATLAB_MEX_FILE\n#include <Arduino.h>\n#include \"MW_arduino_digitalio.h\"\n#endif\n#include \"rtwtypes.h\"\n\n// Digital I/O initialization\nextern \"C\" void digitalIOSetup(uint8_T pin, uint8_T mode) \n{ \n    #ifndef MATLAB_MEX_FILE\n    // mode = 0: Input\n    // mode = 1: Output\n    // mode = 2: Input pullup\n    if (mode==0) {\n        pinMode(pin, INPUT);\n    }\n    else if (mode==1) {\n        pinMode(pin, OUTPUT);\n    }\n    else {\n        // mode = 2 is for input pullup\n        pinMode(pin, INPUT_PULLUP);\n    }\n    #endif\n}\n\n// Write a logic value to pin\nextern \"C\" void writeDigitalPin(uint8_T pin, boolean_T val)\n{\n    #ifndef MATLAB_MEX_FILE\n    if (val) {\n        digitalWrite(pin, HIGH);\n    } \n    else {\n        digitalWrite(pin, LOW);\n    }\n    #endif\n}\n\n// Read logical state of a digital pin\nextern \"C\" boolean_T readDigitalPin(uint8_T pin)\n{\n    #ifndef MATLAB_MEX_FILE\n    boolean_T ret;\n     \n    ret = (digitalRead(pin) == HIGH) ? 1:0;\n    return ret;\n    #else\n    return (boolean_T)0;\n    #endif\n}\n"},{"name":"MW_target_hardware_resources.h","type":"header","group":"other","path":"C:\\Users\\Sophie\\Documents\\Hochschule\\Master\\Semester 2\\Praktikum\\Versuche\\Projekte\\172-184\\184_Das_Geheimnis_der_Feder\\Abstandsensor_ert_rtw","tag":"","groupDisplay":"Other files","code":"#ifndef PORTABLE_WORDSIZES\n#ifdef __MW_TARGET_USE_HARDWARE_RESOURCES_H__\n#ifndef __MW_TARGET_HARDWARE_RESOURCES_H__\n#define __MW_TARGET_HARDWARE_RESOURCES_H__\n\n#define MW_MULTI_TASKING_MODE 1\n#include \"arduinoAVRScheduler.h\"\n\n#define MW_USECODERTARGET 1\n#define MW_TARGETHARDWARE Arduino Uno\n#define MW_EXTMODEPROTOCOLINFO_XCPONSERIAL_HOSTINTERFACE Simulink\n#define MW_EXTMODEPROTOCOLINFO_XCPONSERIAL_LOGGINGBUFFERAUTO 1\n#define MW_EXTMODEPROTOCOLINFO_XCPONSERIAL_LOGGINGBUFFERSIZE 250\n#define MW_EXTMODEPROTOCOLINFO_XCPONSERIAL_LOGGINGBUFFERNUM 2\n#define MW_EXTMODEPROTOCOLINFO_XCPONSERIAL_MAXCONTIGSAMPLES 10\n#define MW_EXTMODEPROTOCOLINFO_XCPONTCPIP_HOSTINTERFACE Simulink\n#define MW_EXTMODEPROTOCOLINFO_XCPONTCPIP_LOGGINGBUFFERAUTO 1\n#define MW_EXTMODEPROTOCOLINFO_XCPONTCPIP_LOGGINGBUFFERSIZE 250\n#define MW_EXTMODEPROTOCOLINFO_XCPONTCPIP_LOGGINGBUFFERNUM 2\n#define MW_EXTMODEPROTOCOLINFO_XCPONTCPIP_MAXCONTIGSAMPLES 10\n#define MW_EXTMODEPROTOCOLINFO_XCPONWIFI_HOSTINTERFACE Simulink\n#define MW_EXTMODEPROTOCOLINFO_XCPONWIFI_LOGGINGBUFFERAUTO 1\n#define MW_EXTMODEPROTOCOLINFO_XCPONWIFI_LOGGINGBUFFERSIZE 250\n#define MW_EXTMODEPROTOCOLINFO_XCPONWIFI_LOGGINGBUFFERNUM 2\n#define MW_EXTMODEPROTOCOLINFO_XCPONWIFI_MAXCONTIGSAMPLES 10\n#define MW_CONNECTIONINFO_XCPONSERIAL_BAUDRATE codertarget.arduinobase.registry.getBaudRate\n#define MW_CONNECTIONINFO_XCPONSERIAL_COMPORT codertarget.arduinobase.internal.getExternalModeMexArgs('Serial')\n#define MW_CONNECTIONINFO_XCPONSERIAL_VERBOSE 0\n#define MW_CONNECTIONINFO_XCPONTCPIP_IPADDRESS codertarget.arduinobase.internal.getExternalModeMexArgs('Ethernet')\n#define MW_CONNECTIONINFO_XCPONTCPIP_PORT 17725\n#define MW_CONNECTIONINFO_XCPONTCPIP_VERBOSE 0\n#define MW_CONNECTIONINFO_XCPONWIFI_IPADDRESS codertarget.arduinobase.internal.getExternalModeMexArgs('Wifi')\n#define MW_CONNECTIONINFO_XCPONWIFI_PORT 17725\n#define MW_CONNECTIONINFO_XCPONWIFI_VERBOSE 0\n#define MW_EXTMODE_CONFIGURATION XCP on Serial\n#define MW_EXTMODE_COMPORTBAUD 115200\n#define MW_EXTMODE_USEREALTIMESTAMPLOGGING 0\n#define MW_EXTMODE_RUNNING on\n#define MW_RTOS Baremetal\n#define MW_SCHEDULER_INTERRUPT_SOURCE 0\n#define MW_RUNTIME_BUILDACTION 1\n#define MW_RUNTIME_DISABLEPARALLELBUILD 0\n#define MW_RUNTIME_FORCEBUILDSTATICLIBRARY 0\n#define MW_RUNTIME_VERBOSEOUTPUT 0\n#define MW_HOSTBOARDCONNECTION_APPDOWNLOAD_PORT_SOURCE 0\n#define MW_HOSTBOARDCONNECTION_APPDOWNLOAD_COMPORT_SELECT -1\n#define MW_HOSTBOARDCONNECTION_APPDOWNLOAD_COMPORT_SPECIFY 1\n#define MW_HOSTBOARDCONNECTION_APPDOWNLOAD_BAUD 0\n#define MW_HOSTBOARDCONNECTION_APPDOWNLOAD_BAUD_SPECIFY \n#define MW_HOSTBOARDCONNECTION_CONNECTEDIO_SERIAL_PORT 0\n#define MW_HOSTBOARDCONNECTION_CONNECTEDIO_PORT_SOURCE1 0\n#define MW_HOSTBOARDCONNECTION_CONNECTEDIO_PORT_SOURCE2 0\n#define MW_HOSTBOARDCONNECTION_CONNECTEDIO_COMPORT_SELECT -1\n#define MW_HOSTBOARDCONNECTION_CONNECTEDIO_COMPORT_SPECIFY 1\n#define MW_HOSTBOARDCONNECTION_CONNECTEDIO_BAUD 0\n#define MW_HOSTBOARDCONNECTION_CONNECTEDIO_BAUD_SPECIFY \n#define MW_HOSTBOARDCONNECTION_EXTERNALMODE_SERIAL_PORT 0\n#define MW_HOSTBOARDCONNECTION_EXTERNALMODE_PORT_SOURCE1 0\n#define MW_HOSTBOARDCONNECTION_EXTERNALMODE_PORT_SOURCE2 0\n#define MW_HOSTBOARDCONNECTION_EXTERNALMODE_COMPORT_SELECT -1\n#define MW_HOSTBOARDCONNECTION_EXTERNALMODE_COMPORT_SPECIFY 1\n#define MW_HOSTBOARDCONNECTION_EXTERNALMODE_BAUD -1\n#define MW_HOSTBOARDCONNECTION_EXTERNALMODE_BAUD_SPECIFY \n#define MW_HOSTBOARDCONNECTION_PIL_SERIAL_PORT 0\n#define MW_HOSTBOARDCONNECTION_PIL_PORT_SOURCE1 0\n#define MW_HOSTBOARDCONNECTION_PIL_PORT_SOURCE2 0\n#define MW_HOSTBOARDCONNECTION_PIL_COMPORT_SELECT -1\n#define MW_HOSTBOARDCONNECTION_PIL_COMPORT_SPECIFY 1\n#define MW_HOSTBOARDCONNECTION_PIL_BAUD 0\n#define MW_HOSTBOARDCONNECTION_PIL_BAUD_SPECIFY \n#define MW_CONNECTEDIO_CONNECTEDIOMODE 0\n#define MW_CONNECTEDIO_ACTIONONOVERRUN 0\n#define MW_OVERRUNDETECTION_ENABLE_OVERRUN_DETECTION 0\n#define MW_OVERRUNDETECTION_DIGITAL_OUTPUT_TO_SET_ON_OVERRUN 13\n#define MW_ANALOGINREFVOLTAGE_ANALOG_INPUT_REFERENCE_VOLTAGE 0.000000\n#define MW_SERIAL_SERIAL0_BAUD_RATE 8\n#define MW_SERIAL_SERIAL0_BAUD_SPECIFY 921600\n#define MW_SERIAL_SERIAL0_CONFIG 3\n#define MW_I2C_I2C0BUSSPEEDHZ 100000\n#define MW_SPI_SPI0_CLOCK_OUT_FREQUENCY 1\n#define MW_SPI_SPI0_MODE 0\n#define MW_SPI_SPI0_BITORDER 0\n#define MW_SPI_SDSLAVESELECT 4.000000\n#define MW_SPI_CANCHIPSELECT 9.000000\n#define MW_ETHERNET_DISABLE_DHCP_ETHERNET 0\n#define MW_ETHERNET_LOCAL_IP_ADDRESS 192.168.0.20\n#define MW_ETHERNET_LOCAL_MAC_ADDRESS DE:AD:BE:EF:FE:ED\n#define MW_WIFI_WIFI_HARDWARE 0\n#define MW_WIFI_WIFI_SSID yourNetwork\n#define MW_WIFI_SET_WIFI_ENCRYPTION 0\n#define MW_WIFI_WIFI_WEP_KEY D0D0DEADF00DABBADEAFBEADED\n#define MW_WIFI_WIFI_WEP_KEY_INDEX 0\n#define MW_WIFI_WIFI_WPA_PASSWORD secretPassword\n#define MW_WIFI_WIFI_ESP8266_HW_SERIAL_PORT 0\n#define MW_WIFI_IP_ADDRESS_ASSIGNMENT 0\n#define MW_WIFI_WIFI_IP_ADDRESS 192.168.1.20\n#define MW_THINGSPEAK_ENABLE_CUSTOMSERVER 48\n#define MW_THINGSPEAK_IP_ADDRESS 184.106.153.149\n#define MW_THINGSPEAK_PORT 80\n#define MW_CAN_CANBUSSPEED 10\n#define MW_CAN_CANOSCILLATORFREQUENCY 1\n#define MW_CAN_INTERRUPTPIN 2.000000\n#define MW_CAN_ALLOWALLFILTER 0\n#define MW_CAN_BUFFER0IDTYPE 0\n#define MW_CAN_ACCEPTANCEMASK0_NOR 0\n#define MW_CAN_ACCEPTANCEFILTER0_NOR 255\n#define MW_CAN_ACCEPTANCEFILTER1_NOR 255\n#define MW_CAN_ACCEPTANCEMASK0_EXT 0\n#define MW_CAN_ACCEPTANCEFILTER0_EXT 255\n#define MW_CAN_ACCEPTANCEFILTER1_EXT 255\n#define MW_CAN_BUFFER1IDTYPE 0\n#define MW_CAN_ACCEPTANCEMASK1_NOR 0\n#define MW_CAN_ACCEPTANCEFILTER2_NOR 255\n#define MW_CAN_ACCEPTANCEFILTER3_NOR 255\n#define MW_CAN_ACCEPTANCEFILTER4_NOR 255\n#define MW_CAN_ACCEPTANCEFILTER5_NOR 255\n#define MW_CAN_ACCEPTANCEMASK1_EXT 0\n#define MW_CAN_ACCEPTANCEFILTER2_EXT 255\n#define MW_CAN_ACCEPTANCEFILTER3_EXT 255\n#define MW_CAN_ACCEPTANCEFILTER4_EXT 255\n#define MW_CAN_ACCEPTANCEFILTER5_EXT 255\n#define MW_MODBUS_MODBUS_COMMS 0\n#define MW_MODBUS_MODBUS_MODE 0\n#define MW_MODBUS_MODBUS_SLAVEID 1\n#define MW_MODBUS_MODBUS_CONFIGCOIL 49\n#define MW_MODBUS_MODBUS_COILADDR 0\n#define MW_MODBUS_MODBUS_COILNUM 1\n#define MW_MODBUS_MODBUS_CONFIGINPUT 49\n#define MW_MODBUS_MODBUS_INPUTADDR 0\n#define MW_MODBUS_MODBUS_INPUTNUM 1\n#define MW_MODBUS_MODBUS_CONFIGHOLDINGREG 49\n#define MW_MODBUS_MODBUS_HOLDINGREGADDR 0\n#define MW_MODBUS_MODBUS_HOLDINGREGNUM 1\n#define MW_MODBUS_MODBUS_CONFIGINPUTREG 49\n#define MW_MODBUS_MODBUS_INPUTREGADDR 0\n#define MW_MODBUS_MODBUS_INPUTREGNUM 1\n#define MW_MODBUS_MODBUS_MASTERTIMEOUT 100\n#define MW_RS485_RS485_SERIAL 0\n#define MW_RS485_RS485_BAUD 9600\n#define MW_RS485_RS485_CONFIG 3\n#define MW_RS485_RS485_DEPIN 8\n#define MW_RS485_RS485_REPIN 9\n#define MW_DISPLAY_ENABLECODEGEN 0\n#define MW_DISPLAY_APPLAUNCHBUTTON \n#define MW_IOBLOCKSMODE deployed\n#define MW_DATAVERSION 2016.02\n#define MW_DASHBOARDCODEGENINFO_ENABLECODEGEN 0\n#define MW_DASHBOARDCODEGENINFO_CIRCULARGAUGE_CODEGEN 1\n#define MW_DASHBOARDCODEGENINFO_CIRCULARGAUGE_BLOCKCLASS codertarget.targetHiddenBlkInsert.internal.circularGauge\n#define MW_DASHBOARDCODEGENINFO_CIRCULARGAUGE_REGFCN codertarget.arduinobase.blocks.registerDashboardBlk\n#define MW_DASHBOARDCODEGENINFO_CIRCULARGAUGE_VALIDATEFCN codertarget.targetHiddenBlkInsert.internal.isDashboardBlockCodegenEnabled\n#define MW_DASHBOARDCODEGENINFO_DISPLAYBLOCK_CODEGEN 1\n#define MW_DASHBOARDCODEGENINFO_DISPLAYBLOCK_BLOCKCLASS codertarget.targetHiddenBlkInsert.internal.lcdTextDisplay\n#define MW_DASHBOARDCODEGENINFO_DISPLAYBLOCK_REGFCN codertarget.arduinobase.blocks.registerDashboardBlk\n#define MW_DASHBOARDCODEGENINFO_DISPLAYBLOCK_VALIDATEFCN codertarget.targetHiddenBlkInsert.internal.isDashboardBlockCodegenEnabled\n#define MW_DASHBOARDCODEGENINFO_PUSHBUTTON_CODEGEN 1\n#define MW_DASHBOARDCODEGENINFO_PUSHBUTTON_BLOCKCLASS codertarget.targetHiddenBlkInsert.internal.pushButton\n#define MW_DASHBOARDCODEGENINFO_PUSHBUTTON_REGFCN codertarget.arduinobase.blocks.registerDashboardBlk\n#define MW_DASHBOARDCODEGENINFO_PUSHBUTTON_VALIDATEFCN codertarget.targetHiddenBlkInsert.internal.isDashboardBlockCodegenEnabled\n\n#endif /* __MW_TARGET_HARDWARE_RESOURCES_H__ */\n\n#endif\n\n#endif\n"},{"name":"arduinoAVRScheduler.cpp","type":"source","group":"legacy","path":"C:\\Users\\Sophie\\Documents\\Hochschule\\Master\\Semester 2\\Praktikum\\Versuche\\Projekte\\172-184\\184_Das_Geheimnis_der_Feder\\Abstandsensor_ert_rtw\\..\\..\\..\\..\\..\\..\\..\\..\\..\\..\\..\\..\\ProgramData\\MATLAB\\SupportPackages\\R2024a\\toolbox\\target\\supportpackages\\arduinotarget\\scheduler\\src","tag":"","groupDisplay":"Other files","code":"/* Arduino AVR Bareboard scheduler\n *\n * Copyright 2013-2015 The MathWorks, Inc.\n */\n\n#include \"Arduino.h\"\n#include \"arduinoAVRScheduler.h\"\n\nextern volatile int IsrOverrun;\nunsigned long oldtime = 0L;\nunsigned long actualtime;\n\n\n#if (defined(MW_SCHEDULERCOUNTER) &&  (MW_SCHEDULERCOUNTER > 1))\n   #if (MW_SCHEDULERCOUNTER >= 65536)\n      volatile uint32_t scheduler_counter = 0;\n    #elif (MW_SCHEDULERCOUNTER >= 256)\n      volatile uint16_t scheduler_counter = 0;\n    #else\n      volatile uint8_t scheduler_counter = 0;\n    #endif\n#endif\n                                  \n/*\n * Call the rt_Onestep function when the timer interrupt hits\n *\n */\n#ifndef _MW_ARDUINO_LOOP_\nISR(INTERRUPT_VECTOR)\n{\n    RESET_TIMER;\n    \n    #if (defined(MW_SCHEDULERCOUNTER) && (MW_SCHEDULERCOUNTER > 1))\n      if ((++scheduler_counter) == MW_SCHEDULERCOUNTER) {\n         scheduler_counter = 0;\n    #endif\n\n    #ifdef _RTT_OVERRUN_DIGITAL_PIN_\n        if (IsrOverrun == 1)\n        {\n          // Overrun detected\n          digitalWrite(_RTT_OVERRUN_DIGITAL_PIN_, HIGH);\n        }\n    #endif\n      rt_OneStep();\n         \n    #if (defined(MW_SCHEDULERCOUNTER) && (MW_SCHEDULERCOUNTER > 1))\n      }\n    #endif\n}\n#endif    \n\nvoid configureArduinoAVRTimer(void)\n{\n#ifndef _MW_ARDUINO_LOOP_\n  // Sets up the timer overflow interrupt.\n  RESET_TIMER;\n\n  // Initially disable the overflow interrupt (before configuration).\n  DISABLE_SCHEDULER_INT();\n\n  // Set the timer to normal mode.\n  TIMER_NORMAL_MODE;\n\n  // Set the prescaler.\n  SETUP_PRESCALER;\n\n  // Enable the overflow interrupt.\n  ENABLE_SCHEDULER_INT();    \n#endif  \n}\n\nboolean disable_rt_OneStep(void)\n{\n    boolean t_return = 0U;\n#ifndef _MW_ARDUINO_LOOP_\n    t_return = GET_SCHEDULER_INT_EN_STATUS();\n  // Disable the overflow interrupt for XCP External Mode\n  DISABLE_SCHEDULER_INT();  \n#endif \n  return t_return;\n}\n\nvoid enable_rt_OneStep(void)\n{\n#ifndef _MW_ARDUINO_LOOP_\n  // Enable the overflow interrupt\n  ENABLE_SCHEDULER_INT();  \n#endif \n}\n\nboolean MW_Arduino_Loop(void)\n{\n    boolean ret = 0;\n\n#ifdef _MW_ARDUINO_LOOP_\n    unsigned long overruntime;\n#if (defined(MW_ARDUINO_MICROS))\n    actualtime = micros();\n#else\n    actualtime = millis();\n#endif\n  \n    if ((unsigned long) (actualtime - oldtime) >= MW_ARDUINO_STEP_SIZE)\n    {\n        oldtime = actualtime;\n        \n#ifdef _RTT_OVERRUN_DIGITAL_PIN_\n        if (IsrOverrun == 1)\n        {\n            // Overrun detected\n            digitalWrite(_RTT_OVERRUN_DIGITAL_PIN_, HIGH);\n        }\n#endif\n        rt_OneStep();\n            #if (defined(_MW_ARDUINO_LOOP_))\n                #if (defined(MW_ARDUINO_MICROS))\n                        overruntime = micros();\n                #else\n                        overruntime = millis();\n                #endif\n                if ((unsigned long) (overruntime - oldtime) >= MW_ARDUINO_STEP_SIZE)   \n                  IsrOverrun = 1;\n                else\n                  IsrOverrun = 0;\n            #endif\n}\n#endif\n\n    ret = 1;\n    return ret;\n}\n\n"},{"name":"io_wrappers.cpp","type":"source","group":"legacy","path":"C:\\Users\\Sophie\\Documents\\Hochschule\\Master\\Semester 2\\Praktikum\\Versuche\\Projekte\\172-184\\184_Das_Geheimnis_der_Feder\\Abstandsensor_ert_rtw\\..\\..\\..\\..\\..\\..\\..\\..\\..\\..\\..\\..\\ProgramData\\MATLAB\\SupportPackages\\R2024a\\toolbox\\target\\supportpackages\\arduinobase\\src","tag":"","groupDisplay":"Other files","code":"/*\n* Wrappers to make I/O functions available with C linkage. This allows C++\n* methods to be called from C code.\n*\n* Copyright 2011-2022 The MathWorks, Inc. */\n\n#include <inttypes.h>\n#include \"Arduino.h\"\n#include \"rtwtypes.h\"\n\n#if (defined(_RTT_TCPIP_EXTMODE_) && (_RTT_TCPIP_EXTMODE_ == 1)) || (defined(_RTT_UDP_) && (_RTT_UDP_ != 0)) || (defined(_RTT_TCP_) && (_RTT_TCP_ != 0) || defined(_RTT_THINGSPEAK_))\n#include <Ethernet.h>\n#include <EthernetUdp.h>\n#include <SPI.h>\n#endif\n\n#if defined(ARDUINO_ARM_CORTEX_M0_PLUS)\nextern \"C\" void __libc_init_array(void);\n#endif\n\nextern \"C\" {\n    void __cxa_pure_virtual(void);\n}\n\nextern \"C\" void Serial_begin(int port, long r, int c)\n{\n    static int serialInit=0;\n    #if !(defined(ESP_PLATFORM))\n    serialInit=0;   //Reset serialInit flag for all targets except ESP32\n    #endif\n    #if defined(ARDUINO_ARCH_SAM)\n    UARTClass::UARTModes config = UARTClass::UARTModes(c);\n    #else\n    int config = c;\n    #endif\n    #if defined(ARDUINO_NUM_SERIAL_PORTS)\n    switch(port) {\n        case 0:\n            if(serialInit & 1)return;\n            serialInit |= 1;\n            #if defined(ESP_PLATFORM)\n            Serial.begin(r,config,_RTT_RX_PIN_SERIAL0_,_RTT_TX_PIN_SERIAL0_);\n            #elif (defined(ARDUINO_TEENSY40) ||defined(ARDUINO_TEENSY41))\n            Serial.begin(r);\n            #else\n            Serial.begin(r,config);\n            #endif\n            break;\n        case 1:\n            if(serialInit & 2)return;\n            serialInit |= 2;\n            #if(ARDUINO_NUM_SERIAL_PORTS >= 2)\n            #if defined(ESP_PLATFORM)\n            Serial1.begin(r,config,_RTT_RX_PIN_SERIAL1_,_RTT_TX_PIN_SERIAL1_);\n            #elif (defined(ARDUINO_TEENSY40) ||defined(ARDUINO_TEENSY41))\n            Serial1.begin(r);\n            #else\n            Serial1.begin(r,config);\n            #endif\n            #endif\n            break;\n        case 2:\n            if(serialInit & 4)return;\n            serialInit |= 4;\n            #if(ARDUINO_NUM_SERIAL_PORTS >= 3)\n            #if defined(ESP_PLATFORM)\n            Serial2.begin(r,config,_RTT_RX_PIN_SERIAL2_,_RTT_TX_PIN_SERIAL2_);\n            #elif (defined(ARDUINO_TEENSY40) ||defined(ARDUINO_TEENSY41))\n            Serial2.begin(r);\n            #else\n            Serial2.begin(r,config);\n            #endif\n            #endif\n            break;\n        case 3:\n            if(serialInit & 8)return;\n            serialInit |= 8;\n            #if(ARDUINO_NUM_SERIAL_PORTS >= 4)\n            #if (defined(ARDUINO_TEENSY40) ||defined(ARDUINO_TEENSY41))\n            Serial3.begin(r);\n            #else\n            Serial3.begin(r,config);\n            #endif\n            #endif\n\n            break;\n        case 4:\n            if(serialInit & 16)return;\n            serialInit |= 16;\n            #if(ARDUINO_NUM_SERIAL_PORTS >= 5)\n            #if (defined(ARDUINO_TEENSY40) ||defined(ARDUINO_TEENSY41))\n            Serial4.begin(r);\n            #else\n            Serial4.begin(r,config);\n            #endif\n            #endif\n            break;\n       case 5:\n            if(serialInit & 32)return;\n            serialInit |= 32;\n            #if(ARDUINO_NUM_SERIAL_PORTS >= 6)\n            #if (defined(ARDUINO_TEENSY40) ||defined(ARDUINO_TEENSY41))\n            Serial5.begin(r);\n            #else\n            Serial5.begin(r,config);\n            #endif\n            #endif\n\n            break;\n       case 6:\n            if(serialInit & 64)return;\n            serialInit |= 64;\n            #if(ARDUINO_NUM_SERIAL_PORTS >= 7)\n            #if (defined(ARDUINO_TEENSY40) ||defined(ARDUINO_TEENSY41))\n            Serial6.begin(r);\n            #else\n            Serial6.begin(r,config);\n            #endif\n            #endif\n\n            break;\n        case 7:\n            if(serialInit & 128)return;\n            serialInit |= 128;\n            #if(ARDUINO_NUM_SERIAL_PORTS >= 8)\n            #if (defined(ARDUINO_TEENSY40) ||defined(ARDUINO_TEENSY41))\n            Serial7.begin(r);\n            #else\n            Serial7.begin(r,config);\n            #endif\n            #endif\n      case 8:\n            if(serialInit & 256)return;\n            serialInit |= 256;\n            #if(ARDUINO_NUM_SERIAL_PORTS >= 9)\n            #if (defined(ARDUINO_TEENSY41))\n            Serial8.begin(r);\n            #else\n            Serial8.begin(r,config);\n            #endif\n            #endif\n\n            break;\n\n            break;\n    }\n    #else\n    if(serialInit & 1)return;\n    serialInit |= 1;\n    Serial.begin(r,SERIAL_8N1);\n    #endif\n}\n\nextern \"C\" void Serial_read(int port, int showOutStatus, uint8_t *outData, int16_t *outStatus)\n{\n    int libFcnOutput;\n    #if defined(ARDUINO_NUM_SERIAL_PORTS)\n    switch(port) {\n        case 0:\n            libFcnOutput = Serial.read();\n            break;\n        case 1:\n            #if(ARDUINO_NUM_SERIAL_PORTS >= 2)\n            libFcnOutput = Serial1.read();\n            #endif\n            break;\n        case 2:\n            #if(ARDUINO_NUM_SERIAL_PORTS >= 3)\n            libFcnOutput = Serial2.read();\n            #endif\n            break;\n        case 3:\n            #if(ARDUINO_NUM_SERIAL_PORTS >= 4)\n            libFcnOutput = Serial3.read();\n            #endif\n            break;\n        case 4:\n            #if(ARDUINO_NUM_SERIAL_PORTS >= 5)\n            libFcnOutput = Serial4.read();\n            #endif\n            break;\n        case 5:\n            #if(ARDUINO_NUM_SERIAL_PORTS >= 6)\n            libFcnOutput = Serial5.read();\n            #endif\n            break;\n        case 6:\n            #if(ARDUINO_NUM_SERIAL_PORTS >= 7)\n            libFcnOutput = Serial6.read();\n            #endif\n            break;\n       case 7:\n            #if(ARDUINO_NUM_SERIAL_PORTS >= 8)\n            libFcnOutput = Serial7.read();\n            #endif\n            break;\n       case 8:\n            #if(ARDUINO_NUM_SERIAL_PORTS >= 9)\n            libFcnOutput = Serial8.read();\n            #endif\n            break;\n    }\n    #else\n    libFcnOutput = Serial.read();\n    #endif\n    *outData = (uint8_t) libFcnOutput;\n    *outStatus = (libFcnOutput != -1);\n}\n\nextern \"C\" void Serial_write(int port, uint8_t * c, size_t s)\n{\n    #if defined(ARDUINO_NUM_SERIAL_PORTS)\n    switch(port) {\n        case 0:\n            Serial.write(c, s);\n            break;\n        case 1:\n            #if(ARDUINO_NUM_SERIAL_PORTS >= 2)\n            Serial1.write(c, s);\n            #endif\n            break;\n        case 2:\n            #if(ARDUINO_NUM_SERIAL_PORTS >= 3)\n            Serial2.write(c, s);\n            #endif\n            break;\n        case 3:\n            #if(ARDUINO_NUM_SERIAL_PORTS >= 4)\n            Serial3.write(c, s);\n            #endif\n            break;\n        case 4:\n            #if(ARDUINO_NUM_SERIAL_PORTS >= 5)\n            Serial4.write(c, s);\n            #endif\n            break;\n        case 5:\n            #if(ARDUINO_NUM_SERIAL_PORTS >= 6)\n            Serial5.write(c, s);\n            #endif\n            break;\n        case 6:\n            #if(ARDUINO_NUM_SERIAL_PORTS >= 7)\n            Serial6.write(c, s);\n            #endif\n            break;\n        case 7:\n            #if(ARDUINO_NUM_SERIAL_PORTS >= 8)\n            Serial7.write(c, s);\n            #endif\n            break;\n        case 8:\n            #if(ARDUINO_NUM_SERIAL_PORTS >= 9)\n            Serial8.write(c, s);\n            #endif\n            break;\n    }\n    #else\n    Serial.write(c, s);\n    #endif\n}\n\n#if _RTT_UDP_ != 0\nEthernetUDP Udp[_RTT_UDP_];\nIPAddress localIpAddress(_RTT_Local_IP1, _RTT_Local_IP2, _RTT_Local_IP3, _RTT_Local_IP4);\nbyte mac[] = { _RTT_Local_MAC1, _RTT_Local_MAC2, _RTT_Local_MAC3, _RTT_Local_MAC4, _RTT_Local_MAC5, _RTT_Local_MAC6 };\nunsigned int localport[_RTT_UDP_] = {_RTT_UDP_LOCAL_PORT_ORDERED};\nint configureSuccess;\nint trialcount=0;\nextern \"C\" uint8_t MW_EthernetAndUDPBegin(uint8_t udpindex, uint32_t localPort)\n{\n    static int only_one_ethernet_begin;\n    if (only_one_ethernet_begin==0)\n    {\n        #if (defined(_RTT_DISABLE_Ethernet_DHCP_) && (_RTT_DISABLE_Ethernet_DHCP_ !=0))\n        Ethernet.begin(mac, localIpAddress);\n        configureSuccess = 1;\n        #else\n        configureSuccess = Ethernet.begin(mac);\n        #endif\n        only_one_ethernet_begin++;\n\n        for(trialcount=0;trialcount<5;trialcount++)\n        {\n            if(Serial)\n            {\n                break;\n            }else\n            {\n                delay(1000);\n            }\n        }\n        // Depending on if the IP address assignment using DHCP has been successful or not,\n        // send the appropriate information back to the host.\n        // If External mode over TCP/IP or Wifi, do not print this Info. Information of IP address will be printed as\n        // a part of rtiostream_open\n        #if (!(defined(_RTT_TCPIP_EXTMODE_) && (_RTT_TCPIP_EXTMODE_ == 1)))\n        if (configureSuccess==1)\n        {\n            if(Ethernet.localIP()[0] == 0 || Ethernet.localIP()[0] == 255)\n            {\n                /*Tried to assign Static IP, failed due to one of the following reasons :\n                * 1. Ethernet shield is not connected properly with Arduino.\n                * 2. Ethernet shield is not connected to a network.\n                **/\n                Serial.println(\"<<<IP address: Failed to configure.>>>\");\n            }\n            else\n            {\n                // If the Configuration is successful, relay back the assigned IP address.\n                Serial.print(\"<<<IP address: \");\n                for (byte thisByte = 0; thisByte < 4; thisByte++)\n                {\n                    // Print the value of each byte of the IP address:\n                    Serial.print(Ethernet.localIP()[thisByte], DEC);\n                    if (thisByte<3)\n                    {\n                        Serial.print(\".\");\n                    }\n                }\n                Serial.println(\">>>\");\n            }\n        }\n        else\n        {\n            // If the Configuration failed,relay back the error message.\n            Serial.println(\"<<<IP address: Failed to configure.>>>\");\n        }\n        Serial.flush();\n        #endif\n    }\n    return (Udp[udpindex].begin(localport[udpindex]));\n}\n\nextern \"C\" int MW_UDPFinalWrite(uint8_t udpindex, uint8_t data, uint8_t remoteIPOctect1,uint8_t remoteIPOctect2,uint8_t remoteIPOctect3,uint8_t remoteIPOctect4, uint32_t remoteport)\n{\n    IPAddress remoteIpAddress(remoteIPOctect1,remoteIPOctect2, remoteIPOctect3, remoteIPOctect4);\n    Udp[udpindex].beginPacket(remoteIpAddress, remoteport);\n    Udp[udpindex].write(data);\n    return(Udp[udpindex].endPacket());\n}\n\nextern \"C\" void MW_UDPFinalRead(uint8_t udpindex, uint8_t *data, int32_t *outStatus)\n{\n    int packetSize = Udp[udpindex].parsePacket();\n    if(packetSize)\n    {\n        int libFcnOutput;\n        libFcnOutput = Udp[udpindex].read();\n        *data = (uint8_t) libFcnOutput;\n        *outStatus = (libFcnOutput != -1);\n    }\n\n    else\n    {\n        //When the client is not connected the status flag is accordingly toggled.\n        *outStatus = 0;\n    }\n}\n#endif\n\n#if defined(_RTT_THINGSPEAK_) || (_RTT_TCP_ != 0)\nIPAddress localIpAddress(_RTT_Local_IP1, _RTT_Local_IP2, _RTT_Local_IP3, _RTT_Local_IP4);\nbyte mac[] = { _RTT_Local_MAC1, _RTT_Local_MAC2, _RTT_Local_MAC3, _RTT_Local_MAC4, _RTT_Local_MAC5, _RTT_Local_MAC6 };\nint configureSuccess;\nint trialcount;\n#if _RTT_TCP_ != 0\nEthernetServer server[_RTT_TCP_] = {_RTT_TCP_SERVER_PORT_ORDERED};\n#endif\nextern \"C\" void MW_EthernetAndTCPServerBegin(uint8_t tcpindex, uint32_t serverport)\n{\n    static int only_one_tcp_server_and_ethernet_begin = 0;\n\n    if (only_one_tcp_server_and_ethernet_begin==0)\n    {\n        #if (defined(_RTT_DISABLE_Ethernet_DHCP_) && (_RTT_DISABLE_Ethernet_DHCP_ !=0))\n        Ethernet.begin(mac, localIpAddress);\n        configureSuccess = 1;\n        #else\n        configureSuccess = Ethernet.begin(mac);\n        #endif\n        only_one_tcp_server_and_ethernet_begin++;\n\n        for(trialcount=0;trialcount<5;trialcount++)\n        {\n            if(Serial)\n            {\n                break;\n            }else\n            {\n                delay(1000);\n            }\n        }\n\n        // Depending on if the IP address assignment using DHCP has been successful or not,\n        // send the appropriate information back to the host.\n        // If External mode over TCP/IP or Wifi, do not print this Info. Information of IP address will be printed as\n        // a part of rtiostream_open\n        #if (!(defined(_RTT_TCPIP_EXTMODE_) && (_RTT_TCPIP_EXTMODE_ == 1)))\n        if (configureSuccess==1)\n        {\n            if(Ethernet.localIP()[0] == 0 || Ethernet.localIP()[0] == 255)\n            {\n                /*Tried to assign Static IP, failed due to one of the following reasons :\n                * 1. Ethernet shield is not connected properly with Arduino.\n                * 2. Ethernet shield is not connected to a network.\n                **/\n                Serial.println(\"<<<IP address: Failed to configure.>>>\");\n            }\n            else\n            {\n                // If the Configuration is successful, relay back the assigned IP address.\n                Serial.print(\"<<<IP address: \");\n                for (byte thisByte = 0; thisByte < 4; thisByte++)\n                {\n                    // Print the value of each byte of the IP address:\n                    Serial.print(Ethernet.localIP()[thisByte], DEC);\n                    if (thisByte<3)\n                    {\n                        Serial.print(\".\");\n                    }\n                }\n                Serial.println(\">>>\");\n            }\n        }\n        else\n        {\n            // If the Configuration failed,relay back the error message.\n            Serial.println(\"<<<IP address: Failed to configure.>>>\");\n        }\n        Serial.flush();\n        #endif\n\n        #if _RTT_TCP_ != 0\n        // Begin all servers based on the number of different TCP ports.\n        for (int i = 0;i < _RTT_TCP_;i++)\n        {\n            server[i].begin();\n        }\n        #endif\n        only_one_tcp_server_and_ethernet_begin = 1;\n    }\n}\n#endif\n#if _RTT_TCP_ != 0\nextern \"C\" void MW_TCPFinalread(uint8_t tcpindex, uint8_t *data, uint32_t serverport, int32_t *outStatus)\n{\n    int libFcnOutput;\n    EthernetClient client = server[tcpindex].available();\n    if (int(client) == true) {\n        libFcnOutput = client.read();\n        *data = (uint8_t) libFcnOutput;\n        *outStatus = (libFcnOutput != -1);\n\n    }\n    else\n    {\n        //When the client is not connected the status flag is accordingly toggled.\n        *outStatus = 0;\n    }\n\n}\nextern \"C\" void MW_TCPFinalWrite(uint8_t tcpindex, uint8_t data, uint32_t serverport)\n{\n    server[tcpindex].write(data);\n}\n#endif\n\n\n#if defined(_ROTH_LEONARDO_)\nextern \"C\" void MW_usbattach()\n{\n    USBDevice.attach();\n}\n#elif defined(ARDUINO_VIRTUAL_COM_PORT)\nextern \"C\" void MW_usbattach()\n{\n    __libc_init_array();\n    USBDevice.init();\n    USBDevice.attach();\n\n}\n#endif\n\nextern \"C\" void MW_pinModeAnalogInput(uint32_t pinNumber)\n{\n    if (pinNumber < A0)\n        pinNumber += A0;\n    pinMode(pinNumber, INPUT);\n}\n\nextern \"C\" void MW_delay_in_milliseconds(uint32_T period)\n{\n    uint32_T start_time = 0;\n    start_time = millis();\n    while(millis()- start_time <= period)\n    {\n        1;\n    }\n}\n\nextern \"C\" void MW_delay_in_microseconds(uint32_T period)\n{\n    uint32_T start_time = 0;\n    start_time = micros();\n    while(micros()- start_time <= period)\n    {\n        1;\n    }\n}\n\nextern \"C\" uint32_T MW_getCurrentTime_in_milliseconds()\n{\n   return (uint32_T)millis();\n}\n\n\n// #if defined(ARDUINO_ARDUINO_NANO33BLE)\n// #include \"Arduino.h\"\n// #include \"pins_arduino.h\"\n// #include \"mbed/drivers/AnalogIn.h\"\n// #include \"mbed.h\"\n//\n// extern uint8_t nano33BLE_dutycycle[21];\n// extern uint16_t nano33BLE_period[21];\n//\n//\n// events::EventQueue queue(32 * EVENTS_EVENT_SIZE);\n// rtos::Thread t;\n// mbed::Ticker tick;\n//\n// static int write_resolution = 8;\n// static int read_resolution = 10;\n//\n// extern \"C\" void MW_NANO33BLE_analogWrite_1(pin_size_t pin, int val, uint16_t period)\n// {\n//   if (pin >= PINS_COUNT) {\n//     return;\n//   }\n//   float percent = (float)val/(float)((1 << write_resolution)-1);\n//   mbed::PwmOut* pwm = digitalPinToPwm(pin);\n//   if (pwm == NULL) {\n//     pwm = new mbed::PwmOut(digitalPinToPinName(pin));\n//     digitalPinToPwm(pin) = pwm;\n//     pwm->period_ms(period);\n//   }\n//   pwm->write(percent);\n// }\n//\n// extern \"C\" void MW_NANO33BLE_PWM_Handler()\n// {\n//     MW_NANO33BLE_analogWrite_1(5, nano33BLE_dutycycle[5], nano33BLE_period[5]);\n// }\n//\n// extern \"C\" void MW_NANO33BLE_PWM_Setup()\n// {\n//   t.start(callback(&queue, &events::EventQueue::dispatch_forever));\n//   tick.attach(queue.event(MW_NANO33BLE_PWM_Handler),_RTT_PWM_PIN5_CST );\n// }\n//\n//\n//\n//\n// extern \"C\" void MW_NANO33BLE_analogWrite(PinName pin, int val, uint16_t period)\n// {\n// //   pin_size_t idx = PinNameToIndex(pin);\n// //   if (idx != NOT_A_PIN) {\n// //     MW_NANO33BLE_analogWrite_1(idx, 50, period);\n// //   } else {\n// //     mbed::PwmOut* pwm = new mbed::PwmOut(pin);\n// //     pwm->period_ms(2);\n// //     float percent = (float)50/(float)((1 << write_resolution)-1);\n// //     pwm->write(percent);\n// //   }\n// }\n//\n// #endif\n"},{"name":"platform_timer.c","type":"source","group":"legacy","path":"C:\\Users\\Sophie\\Documents\\Hochschule\\Master\\Semester 2\\Praktikum\\Versuche\\Projekte\\172-184\\184_Das_Geheimnis_der_Feder\\Abstandsensor_ert_rtw\\..\\..\\..\\..\\..\\..\\..\\..\\..\\..\\..\\..\\ProgramData\\MATLAB\\SupportPackages\\R2024a\\toolbox\\target\\supportpackages\\arduinotarget\\src","tag":"","groupDisplay":"Other files","code":"/* Copyright 2023 The MathWorks, Inc. */\n#include \"rtwtypes.h\"\n\n#define MW_StringifyDefine(x) MW_StringifyDefineExpanded(x)\n#define MW_StringifyDefineExpanded(x)  #x\n\n#define MW_StringifyDefineHeader(x) MW_StringifyDefineHeaderExpand(x)\n#define MW_StringifyDefineHeaderExpand(x)  x.h\n\n#include MW_StringifyDefine(MW_StringifyDefineHeader(MODEL))\n\nstatic volatile uint32_T timestampInitialized = 0;\nstatic volatile uint32_T timestampStartTime = 0;\n\nstatic void timestampInit(void)\n{\n    if (0 == timestampInitialized)\n    {\n        timestampStartTime =  micros();\n        timestampInitialized = 1;\n    }\n}\n\n__attribute__((optimize(\"O3\"))) static uint32_T returnTimeElapsed(uint32_T timestampStartTime)\n{\n    uint32_T currentTime;\n    uint32_T ret = 0;\n    \n    currentTime = micros();\n    \n    if (currentTime >= timestampStartTime)\n    {\n        ret = (uint32_T) (currentTime - timestampStartTime);\n    }\n    else\n    {\n        ret = (uint32_T) (MAX_uint32_T - timestampStartTime + currentTime);\n    }\n    return ret ;\n}\n\n__attribute__((optimize(\"O3\"))) uint32_T getCurrentTimestamp(void)\n{\n    uint32_T ret = 0;\n    if ((1 == runModel) || (1 == timestampInitialized))\n    {\n        if (0 == timestampInitialized)\n        {\n            timestampInit();\n        }\n        ret = returnTimeElapsed(timestampStartTime);\n    }\n    else\n    {\n        timestampStartTime =  micros();\n    }\n    return ret;\n}"},{"name":"rtiostream_serial_daemon.cpp","type":"source","group":"legacy","path":"C:\\Users\\Sophie\\Documents\\Hochschule\\Master\\Semester 2\\Praktikum\\Versuche\\Projekte\\172-184\\184_Das_Geheimnis_der_Feder\\Abstandsensor_ert_rtw\\..\\..\\..\\..\\..\\..\\..\\..\\..\\..\\..\\..\\ProgramData\\MATLAB\\SupportPackages\\R2024a\\toolbox\\target\\supportpackages\\arduinotarget\\src","tag":"","groupDisplay":"Other files","code":"/*\n * File: rtiostream_serial.cpp\n * Copyright 2011-2022 The MathWorks, Inc.\n */\n\n#include \"Arduino.h\"\n#include \"MW_target_hardware_resources.h\"\n#include \"io_wrappers.h\"\n\n#ifndef _rtiostream\n\nextern \"C\" {                 /* sbcheck:ok:extern_c */\n#include \"rtiostream.h\"\nvoid rtIOStreamResync(void);\n}\n#define _rtiostream\n#endif\n\nextern \"C\" void __cxa_pure_virtual(void);   /* sbcheck:ok:extern_c */\n\n#if defined(XCP_CALIBRATION_SUPPORT)\n    #define SYNC_BYTE 0x02\n#else\n    #define SYNC_BYTE 'e'\n#endif\n\nvolatile boolean receivedSyncByteE = false;\n\nvoid rtIOStreamResync(){\n    receivedSyncByteE = false;\n}\n\n/* Function: rtIOStreamOpen =================================================\n * Abstract:\n *  Open the connection with the target.\n */\nint rtIOStreamOpen(int argc, void * argv[])\n{\n    /* ASCII character a is 65 */\n    #define RTIOSTREAM_OPEN_COMPLETE 65\n    static const uint8_t init_complete = RTIOSTREAM_OPEN_COMPLETE;\n    \n    int result = RTIOSTREAM_NO_ERROR;\n    int flushedData;\n    \n//     #ifndef MW_PIL_ARUDINOSERIAL //commented due to Serial1 not working with external mode in MKR1000\n//     init();\n//     #endif\n\n    #if defined(MW_PIL_ARUDINOSERIAL)\n        #if defined(MW_RTIO_SERIAL0)\n            Serial_begin(0, MW_PIL_SERIAL_BAUDRATE, SERIAL_8N1);\n        #elif defined(MW_RTIO_SERIAL1)\n            Serial_begin(1, MW_PIL_SERIAL_BAUDRATE, SERIAL_8N1);\n        #elif defined(MW_RTIO_SERIAL2)\n            Serial_begin(2, MW_PIL_SERIAL_BAUDRATE, SERIAL_8N1);\n        #elif defined(MW_RTIO_SERIAL3)\n            Serial_begin(3, MW_PIL_SERIAL_BAUDRATE, SERIAL_8N1);\n        #else\n            Serial_begin(0, MW_PIL_SERIAL_BAUDRATE, SERIAL_8N1);\n        #endif\n\n        \n        /* At high baud rates (i.e. 115200), the Arduino is receiving an \n         * initial byte of spurious data (0xF0 / 240) when opening a connection\n         * even though the host has not transmitted this data! This is causing\n         * an issue for PIL to read wrong init bytes at the beginning and\n         * loosing sync with host. Adding delay of 1 sec to wait for host to\n         * open the connection and then flush the spurious data from receive\n         * buffer. A delay of 5Sec(rtiostream postopenpause) is given on the\n         * host between opening the connection and init bytes.\n        */ \n        delay(1000);\n    #else\n        #if defined(MW_RTIO_SERIAL0)\n            Serial_begin(0, MW_EXTMODE_COMPORTBAUD, SERIAL_8N1);\n        #elif defined(MW_RTIO_SERIAL1)\n            Serial_begin(1, MW_EXTMODE_COMPORTBAUD, SERIAL_8N1);\n        #elif defined(MW_RTIO_SERIAL2)\n            Serial_begin(2, MW_EXTMODE_COMPORTBAUD, SERIAL_8N1);\n        #elif defined(MW_RTIO_SERIAL3)\n            Serial_begin(3, MW_EXTMODE_COMPORTBAUD, SERIAL_8N1);\n        #elif defined(MW_RTIO_SERIAL4)\n            Serial_begin(4, MW_EXTMODE_COMPORTBAUD, SERIAL_8N1);\n        #elif defined(MW_RTIO_SERIAL5)\n            Serial_begin(5, MW_EXTMODE_COMPORTBAUD, SERIAL_8N1);\n        #elif defined(MW_RTIO_SERIAL6)\n            Serial_begin(6, MW_EXTMODE_COMPORTBAUD, SERIAL_8N1);\n        #elif defined(MW_RTIO_SERIAL7)\n            Serial_begin(7, MW_EXTMODE_COMPORTBAUD, SERIAL_8N1);\n        #elif defined(MW_RTIO_SERIAL8)\n            Serial_begin(8, MW_EXTMODE_COMPORTBAUD, SERIAL_8N1);\n        #else\n            Serial_begin(0, MW_EXTMODE_COMPORTBAUD, SERIAL_8N1);\n        #endif\n    #endif\n   \n    /* Flush out the serial receive buffer when opening a connection. This\n     * works around an issue we've noticed with Arduino at high baud rates.\n     * At high baud rates (i.e. 115200), the Arduino is receiving an \n     * initial byte of spurious data (0xF0 / 240) even though the host has\n     * not transmitted this data! This may cause an issue for PIL and \n     * External mode during the handshaking process.\n     */\n        #if defined(MW_RTIO_SERIAL0)\n            while (Serial.available()) {\n                flushedData = Serial.read();\n            }\n        #elif defined(MW_RTIO_SERIAL1)\n            while (Serial1.available()) {\n                flushedData = Serial1.read();\n            }\n        #elif defined(MW_RTIO_SERIAL2)\n            while (Serial2.available()) {\n                flushedData = Serial2.read();\n            }\n        #elif defined(MW_RTIO_SERIAL3)\n            while (Serial3.available()) {\n                flushedData = Serial3.read();\n            }\n        #elif defined(MW_RTIO_SERIAL4)\n            while (Serial4.available()) {\n                flushedData = Serial4.read();\n            }\n        #elif defined(MW_RTIO_SERIAL5)\n            while (Serial5.available()) {\n                flushedData = Serial5.read();\n            }\n        #elif defined(MW_RTIO_SERIAL6)\n            while (Serial6.available()) {\n                flushedData = Serial6.read();\n            }\n        #elif defined(MW_RTIO_SERIAL7)\n            while (Serial7.available()) {\n                flushedData = Serial7.read();\n            }\n        #elif defined(MW_RTIO_SERIAL8)\n            while (Serial8.available()) {\n                flushedData = Serial8.read();\n            }\n        #else\n            while (Serial.available()) {\n                flushedData = Serial.read();\n            }\n        #endif\n   \n\n    return result;\n}\n\n/* Function: rtIOStreamSend =====================================================\n * Abstract:\n *  Sends the specified number of bytes on the serial line. Returns the number of\n *  bytes sent (if successful) or a negative value if an error occurred.\n */\nint rtIOStreamSend(\n    int          streamID,\n    const void * src,\n    size_t       size,\n    size_t     * sizeSent)\n{\n    #if defined(MW_RTIO_SERIAL0)\n        Serial.write( (const uint8_t *)src, (int16_t)size);\n    #elif defined(MW_RTIO_SERIAL1)\n        Serial1.write( (const uint8_t *)src, (int16_t)size);\n    #elif defined(MW_RTIO_SERIAL2)\n        Serial2.write( (const uint8_t *)src, (int16_t)size);\n    #elif defined(MW_RTIO_SERIAL3)\n        Serial3.write( (const uint8_t *)src, (int16_t)size);\n    #elif defined(MW_RTIO_SERIAL4)\n        Serial4.write( (const uint8_t *)src, (int16_t)size);\n    #elif defined(MW_RTIO_SERIAL5)\n        Serial5.write( (const uint8_t *)src, (int16_t)size);\n    #elif defined(MW_RTIO_SERIAL6)\n        Serial6.write( (const uint8_t *)src, (int16_t)size);\n    #elif defined(MW_RTIO_SERIAL7)\n        Serial7.write( (const uint8_t *)src, (int16_t)size);\n    #elif defined(MW_RTIO_SERIAL8)\n        Serial8.write( (const uint8_t *)src, (int16_t)size);\n    #else\n        Serial.write( (const uint8_t *)src, (int16_t)size);\n    #endif\n    \n    \n    *sizeSent = size;\n     \n    return RTIOSTREAM_NO_ERROR;\n}\n\n/* Function: rtIOStreamRecv ================================================\n * Abstract: receive data\n *\n */\nint rtIOStreamRecv(\n    int      streamID,\n    void   * dst,\n    size_t   size,\n    size_t * sizeRecvd)\n{\n    int data;\n    uint8_t * ptr = (uint8_t *)dst;\n  \n    *sizeRecvd = 0U;\n    #if defined(MW_RTIO_SERIAL0)\n            if (!Serial.available()) {\n                return RTIOSTREAM_NO_ERROR;\n            }\n        \n            while( !receivedSyncByteE ){\n                data = Serial.read();\n                if(data == SYNC_BYTE){\n                    receivedSyncByteE = true;\n                    *ptr++ = (uint8_t)data;\n                    (*sizeRecvd)++;\n                }\n            }\n        \n            while ((*sizeRecvd < size)) {\n                data = Serial.read();\n                if (data!=-1) {\n                    *ptr++ = (uint8_t) data;\n                    (*sizeRecvd)++;\n                }\n            }\n    #elif defined(MW_RTIO_SERIAL1)\n            if (!Serial1.available()) {\n                return RTIOSTREAM_NO_ERROR;\n            }\n        \n            while( !receivedSyncByteE ){\n                data = Serial1.read();\n                if(data == SYNC_BYTE){\n                    receivedSyncByteE = true;\n                    *ptr++ = (uint8_t)data;\n                    (*sizeRecvd)++;\n                }\n            }\n        \n            while ((*sizeRecvd < size)) {\n                data = Serial1.read();\n                if (data!=-1) {\n                    *ptr++ = (uint8_t) data;\n                    (*sizeRecvd)++;\n                }\n            }\n    #elif defined(MW_RTIO_SERIAL2)\n            if (!Serial2.available()) {\n                return RTIOSTREAM_NO_ERROR;\n            }\n        \n            while( !receivedSyncByteE ){\n                data = Serial2.read();\n                if(data == SYNC_BYTE){\n                    receivedSyncByteE = true;\n                    *ptr++ = (uint8_t)data;\n                    (*sizeRecvd)++;\n                }\n            }\n        \n            while ((*sizeRecvd < size)) {\n                data = Serial2.read();\n                if (data!=-1) {\n                    *ptr++ = (uint8_t) data;\n                    (*sizeRecvd)++;\n                }\n            }\n    #elif defined(MW_RTIO_SERIAL3)\n            if (!Serial3.available()) {\n                return RTIOSTREAM_NO_ERROR;\n            }\n        \n            while( !receivedSyncByteE ){\n                data = Serial3.read();\n                if(data == SYNC_BYTE){\n                    receivedSyncByteE = true;\n                    *ptr++ = (uint8_t)data;\n                    (*sizeRecvd)++;\n                }\n            }\n        \n            while ((*sizeRecvd < size)) {\n                data = Serial3.read();\n                if (data!=-1) {\n                    *ptr++ = (uint8_t) data;\n                    (*sizeRecvd)++;\n                }\n            }\n    #elif defined(MW_RTIO_SERIAL4)\n            if (!Serial4.available()) {\n                return RTIOSTREAM_NO_ERROR;\n            }\n        \n            while( !receivedSyncByteE ){\n                data = Serial4.read();\n                if(data == SYNC_BYTE){\n                    receivedSyncByteE = true;\n                    *ptr++ = (uint8_t)data;\n                    (*sizeRecvd)++;\n                }\n            }\n        \n            while ((*sizeRecvd < size)) {\n                data = Serial4.read();\n                if (data!=-1) {\n                    *ptr++ = (uint8_t) data;\n                    (*sizeRecvd)++;\n                }\n            }\n      #elif defined(MW_RTIO_SERIAL5)\n            if (!Serial5.available()) {\n                return RTIOSTREAM_NO_ERROR;\n            }\n        \n            while( !receivedSyncByteE ){\n                data = Serial5.read();\n                if(data == SYNC_BYTE){\n                    receivedSyncByteE = true;\n                    *ptr++ = (uint8_t)data;\n                    (*sizeRecvd)++;\n                }\n            }\n        \n            while ((*sizeRecvd < size)) {\n                data = Serial5.read();\n                if (data!=-1) {\n                    *ptr++ = (uint8_t) data;\n                    (*sizeRecvd)++;\n                }\n            }\n     #elif defined(MW_RTIO_SERIAL6)\n            if (!Serial6.available()) {\n                return RTIOSTREAM_NO_ERROR;\n            }\n        \n            while( !receivedSyncByteE ){\n                data = Serial6.read();\n                if(data == SYNC_BYTE){\n                    receivedSyncByteE = true;\n                    *ptr++ = (uint8_t)data;\n                    (*sizeRecvd)++;\n                }\n            }\n        \n            while ((*sizeRecvd < size)) {\n                data = Serial6.read();\n                if (data!=-1) {\n                    *ptr++ = (uint8_t) data;\n                    (*sizeRecvd)++;\n                }\n            }\n      #elif defined(MW_RTIO_SERIAL7)\n            if (!Serial7.available()) {\n                return RTIOSTREAM_NO_ERROR;\n            }\n        \n            while( !receivedSyncByteE ){\n                data = Serial7.read();\n                if(data == SYNC_BYTE){\n                    receivedSyncByteE = true;\n                    *ptr++ = (uint8_t)data;\n                    (*sizeRecvd)++;\n                }\n            }\n        \n            while ((*sizeRecvd < size)) {\n                data = Serial7.read();\n                if (data!=-1) {\n                    *ptr++ = (uint8_t) data;\n                    (*sizeRecvd)++;\n                }\n            }\n     #elif defined(MW_RTIO_SERIAL8)\n            if (!Serial8.available()) {\n                return RTIOSTREAM_NO_ERROR;\n            }\n        \n            while( !receivedSyncByteE ){\n                data = Serial8.read();\n                if(data == SYNC_BYTE){\n                    receivedSyncByteE = true;\n                    *ptr++ = (uint8_t)data;\n                    (*sizeRecvd)++;\n                }\n            }\n        \n            while ((*sizeRecvd < size)) {\n                data = Serial8.read();\n                if (data!=-1) {\n                    *ptr++ = (uint8_t) data;\n                    (*sizeRecvd)++;\n                }\n            }\n    #else\n            if (!Serial.available()) {\n                return RTIOSTREAM_NO_ERROR;\n            }\n        \n            while( !receivedSyncByteE ){\n                data = Serial.read();\n                if(data == SYNC_BYTE){\n                    receivedSyncByteE = true;\n                    *ptr++ = (uint8_t)data;\n                    (*sizeRecvd)++;\n                }\n            }\n        \n            while ((*sizeRecvd < size)) {\n                data = Serial.read();\n                if (data!=-1) {\n                    *ptr++ = (uint8_t) data;\n                    (*sizeRecvd)++;\n                }\n            }\n    #endif\n\n   \n    \n    return RTIOSTREAM_NO_ERROR;\n}\n\n/* Function: rtIOStreamClose ================================================\n * Abstract: close the connection.\n * For External mode over serial, Arduino MKR and its variants require\n * a flush out the serial receive buffer. This is done to get the last \n * acknowledgment \n *\n */\nint rtIOStreamClose(int streamID)\n{\n#if (defined(ARDUINO_ARDUINO_NANO33BLE))\n    #if defined(MW_RTOS) && (MW_RTOS == 'Baremetal')\n        //Do not let the program terminate\n        while(1);\n    #endif\n#else\n    delay(1000);\n    #if defined(ARDUINO_VIRTUAL_COM_PORT)\n        int flushedData;\n        while (Serial.available()) {\n            flushedData = Serial.read();\n        }\n    #endif\n#endif\n    return RTIOSTREAM_NO_ERROR;\n}"},{"name":"xcp.c","type":"source","group":"legacy","path":"C:\\Users\\Sophie\\Documents\\Hochschule\\Master\\Systeme und Programme\\toolbox\\coder\\xcp\\src\\target\\server\\protocol\\src","tag":"","groupDisplay":"Other files","code":"/*\n* Copyright 2016-2023 The MathWorks, Inc.\n*\n* File: xcp.c\n*\n* Abstract:\n*  Implementation of XCP Protocol Layer\n*/\n\n#include \"xcp_common.h\"\n#include \"xcp.h\"\n#include \"xcp_internal.h\"\n#include \"xcp_transport_internal.h\"\n#include \"xcp_cfg.h\"\n#include \"xcp_types.h\"\n#include \"xcp_standard.h\"\n#include \"xcp_daq.h\"\n#include \"xcp_calibration.h\"\n#include \"xcp_mem.h\"\n\n\n/*****************************************************************************\n    Internal Global variables\n******************************************************************************/\n/* Initialization status */\nstatic boolean_T initialized = false;\n\n/** Current Status of the XCP Server according to the Protocol Layer */\nstatic XcpStatus xcpStatus = XCP_DISCONNECTED;\n\n/** Current Session Status of the XCP Server according to the Protocol Layer\n(see XCP Session Status bit masks) */\nstatic uint8_T xcpSessionStatus = 0;\n\n/** XCP Server Resource Protection Status (see XCP Resource bit masks) */\nstatic uint8_T xcpResourceProtectionStatus = 0;\n\n/** XCP Session configuration Id\n@note xcpSessionConfigurationId has to be set with an XCP SET_REQUEST\n      before a STORE_DAQ_REQ set. This allows the client device to verify that\n      automatically started DAQ lists contain the expected data transfer\n      configuration.\n      However the (optional) SET_REQUEST command is not supported at the\n      moment, so this value is hard-coded to 0 and never changed. */\nstatic uint16_T xcpSessionConfigurationId = 0;\n\n/** This table contains the list of XcpPacketLookupFunction to be used\n    (for each packets group) to get access to the corresponding\n    Packet Input and Output handlers */\nstatic XcpPacketLookupFunction groupPacketLookup[XCP_PACKETS_GROUP_NUMBER];\n\n/*****************************************************************************\n    Internal Functions\n******************************************************************************/\n/** Free the msgBuffer and allocate a new buffer to host a XCP packet of newPacketSize */\nstatic XcpErrorCode msgBufferRealloc(void **msgBuffer, size_t *msgBufferSize, size_t *packetOffset, size_t newPacketSize)\n{\n    XcpErrorCode errorCode = XCP_SUCCESS;\n    xcpPoolId_T reservedPoolId = xcpTransportCtoReservedMemPoolId();\n\n    /* Free the original buffer */\n    xcpMemFree(*msgBuffer);\n\n    /* Allocate a new buffer with the proper size */\n    *msgBufferSize = xcpTransportMsgBufferSize(newPacketSize, XCP_CTO);\n    *packetOffset = xcpTransportPacketOffset();\n\n    if (*msgBufferSize > 0) {\n        /* Using a reserved memory pool, to guarantee that the reply\n           gets always delivered to the XCP Client */\n        *msgBuffer = xcpMemAllocFromPool(reservedPoolId, *msgBufferSize);\n        if (*msgBuffer == NULL) {\n            errorCode = XCP_NO_MEMORY;\n        }\n    }\n    else {\n        errorCode = XCP_INV_SIZE;\n    }\n\n    return errorCode;\n}\n\n/** Input Packet Handler to be used for packets that need to be discarded */\nstatic XcpProtoErrorCode discardInputPacketHandler(void   *msgBuffer,\n                                                   size_t  xcpPacketOffset,\n                                                   size_t *outputPacketSize)\n{\n    XCP_UNUSED_PARAM(xcpPacketOffset);\n\n    XCP_PRINTF(\"Detected attempt to send packet ID %xH when the XCP connection has not been established\\n\", \n               *((uint8_T *) msgBuffer + xcpPacketOffset));\n\n    if (msgBuffer != NULL) {\n        xcpMemFree(msgBuffer);\n    }\n\n    *outputPacketSize = 0;\n\n    return XCP_PROTO_SUCCESS;\n}\n\n/** Input Packet Handler to be used for unknown commands */\nstatic XcpProtoErrorCode unknownInputPacketHandler(void   *msgBuffer,\n                                                   size_t  xcpPacketOffset,\n                                                   size_t *outputPacketSize)\n{\n    XCP_UNUSED_PARAM(msgBuffer);\n    XCP_UNUSED_PARAM(xcpPacketOffset);\n\n    XCP_PRINTF(\"Packet ID  %xH is not supported at the moment\\n\",\n    *((uint8_T *) msgBuffer + xcpPacketOffset));\n\n    *outputPacketSize = XCP_ERROR_PACKET_SIZE_IN_BYTES;\n\n    return XCP_PROTO_CMD_UNKNOWN;\n}\n\n/** The function returns the Group Id corresponding to a given Packet ID */\nstatic XcpPacketsGroupIdType xcpGetPacketGroupID(uint8_T pid, uint8_T level1Code)\n{\n    XcpPacketsGroupIdType groupId = XCP_UNKNOWN_PACKET_GROUP_ID;\n\n    if ((pid >= XCP_STANDARD_PACKETS_ID_MIN) /* && (pid <= XCP_STANDARD_PACKETS_ID_MAX) */) {\n        groupId = XCP_STANDARD_PACKETS_ID;\n    }\n    else if ((pid >= XCP_CALIBRATION_PACKETS_ID_MIN) && (pid <= XCP_CALIBRATION_PACKETS_ID_MAX)) {\n        groupId = XCP_CALIBRATION_PACKETS_ID;\n    }\n    else if (((pid >= XCP_DAQ_PACKETS_ID_MIN) && (pid <= XCP_DAQ_PACKETS_ID_MAX)) ||\n             ((pid == XCP_PID_LEVEL1_COMMAND) && \n             (level1Code >= XCP_DAQ_LEVEL1_CODE_MIN) && (level1Code <= XCP_DAQ_LEVEL1_CODE_MAX))) {\n        groupId = XCP_DAQ_PACKETS_ID;\n    }\n    else if ((pid >= XCP_PROGRAM_PACKETS_ID_MIN) && (pid <= XCP_PROGRAM_PACKETS_ID_MAX)) {\n        groupId = XCP_PROGRAM_PACKETS_ID;\n    }\n\n    return groupId;\n}\n\n/** Identify the internal packet handler functions responsible for processing a specific XCP packet.\n    @note If the status is XCP_DISCONNECTED, no packets are accepted except XCP_PID_CONNECT\n          If the command is not supported, the XCP server has to reply with a ERR response packet\n          and ERR_CMD_UNKNOWN error code */\nstatic void xcpGetPacketHandlers(const uint8_T *packet,\n                                 size_t packetSize,\n                                 XcpInputPacketHandler  *inputHandler,\n                                 XcpOutputPacketHandler *outputHandler)\n{\n    /* uint8_T gets promoted to a higher data-type. On C2000, it is \n     * unsigned int. Since data is packed, a non-zero MSB in packet[0]\n     * can then make PID an invalid identifier. Explicitly mask to\n     * remove the upper byte if any.\n     */\n     const XcpLevel1CommandPacketFrame* command = (const XcpLevel1CommandPacketFrame*) packet;\n\n    uint8_T PID = command->PID; /* Retrieve Packet ID */\n    uint8_T level1CommandCode = 0;\n    if ((PID == XCP_PID_LEVEL1_COMMAND) && (packetSize > 1)) {\n        level1CommandCode = command->level1Code;\n    }\n\n    if (xcpStatus != XCP_DISCONNECTED) {\n        /* Check if the received XCP packet is supported and\n           retrieve the corresponding handler */\n        XcpPacketsGroupIdType groupId = xcpGetPacketGroupID(PID, level1CommandCode);\n        boolean_T found = false;\n\n        if (groupId != XCP_UNKNOWN_PACKET_GROUP_ID) {\n            XcpPacketLookupFunction getPacket = groupPacketLookup[groupId];\n            const XcpPacketHandlers *packetInfo = NULL;\n\n            if (getPacket != NULL) {\n                packetInfo = getPacket(PID);\n                found = (packetInfo != NULL);\n                if (found) {\n                    *inputHandler = packetInfo->inputHandler;\n                    *outputHandler = packetInfo->outputHandler;\n                }\n            }\n        }\n\n        if (!found) {\n            /* Packet is not supported*/\n            *inputHandler = unknownInputPacketHandler;\n            *outputHandler = genericOutputPacketHandler;\n        }\n    }\n    else {\n        /* If the XCP Server is in the XCP_DISCONNECTED status,\n        * no other XCP packets are accepted except XCP_PID_CONNECT */\n        if (PID == XCP_PID_CONNECT) {\n            XcpPacketLookupFunction getPacket = groupPacketLookup[XCP_STANDARD_PACKETS_ID];\n\n            *inputHandler = NULL;\n            *outputHandler = NULL;\n\n            if (getPacket != NULL) {\n                const XcpPacketHandlers *connect = getPacket(XCP_PID_CONNECT);\n                if (connect != NULL) {\n                    /* Note: if the Protocol layer is correctly configured,\n                       the CONNECT command should be always implemented */\n                    *inputHandler = connect->inputHandler;\n                    *outputHandler = connect->outputHandler;\n                }\n            }\n        }\n        else {\n            /* Input packet must be ignored and discarded */\n            *inputHandler = discardInputPacketHandler;\n            *outputHandler = NULL;\n        }\n    }\n}\n\n/*****************************************************************************\n    Public Functions (shared across different XCP commands)\n******************************************************************************/\nXcpStatus xcpStatusGet(void)\n{\n    return xcpStatus;\n}\n\nvoid xcpStatusSet(XcpStatus status)\n{\n    xcpStatus = status;\n}\n\nuint8_T xcpSessionStatusGet(void)\n{\n    return xcpSessionStatus;\n}\n\nvoid xcpSessionStatusSet(uint8_T status)\n{\n    xcpSessionStatus = status;\n}\n\nvoid xcpSessionStatusSetMask(uint8_T mask)\n{\n    XCP_SET_MASK(xcpSessionStatus, mask);\n}\n\nvoid xcpSessionStatusClearMask(uint8_T mask)\n{\n    XCP_CLEAR_MASK(xcpSessionStatus, mask);\n}\n\nuint8_T xcpResourceProtectionStatusGet(void)\n{\n    return xcpResourceProtectionStatus;\n}\n\nvoid xcpResourceProtectionStatusSet(uint8_T status)\n{\n    xcpResourceProtectionStatus = status;\n}\n\nvoid xcpResourceProtectionSetMask(uint8_T mask)\n{\n    XCP_SET_MASK(xcpResourceProtectionStatus, mask);\n}\n\nvoid xcpResourceProtectionClearMask(uint8_T mask)\n{\n    XCP_CLEAR_MASK(xcpResourceProtectionStatus, mask);\n}\n\nuint16_T xcpSessionConfigurationIdGet(void)\n{\n    return xcpSessionConfigurationId;\n}\n\nvoid xcpSessionConfigurationIdSet(uint16_T id)\n{\n    xcpSessionConfigurationId = id;\n}\n\nvoid genericOutputPacketHandler(XcpProtoErrorCode inputCode, void *packet, size_t packetSize)\n{\n    XCP_UNUSED_PARAM(packetSize);\n\n    if (inputCode == XCP_PROTO_SUCCESS) {\n        /* Send back a generic RES packet */\n        XcpGenericResPacketFrame *frame = (XcpGenericResPacketFrame *)packet;\n        frame->PID = XCP_PID_RES;\n    }\n    else {\n        XcpErrorPacketFrame *frame = (XcpErrorPacketFrame *)packet;\n        frame->PID = XCP_PID_ERR;\n\n        switch (inputCode) {\n        case XCP_PROTO_MEMORY_OVERFLOW:\n            frame->errorCode = XCP_ERR_MEMORY_OVERFLOW;\n            break;\n        case XCP_PROTO_SEQUENCE_ERROR:\n            frame->errorCode = XCP_ERR_SEQUENCE;\n            break;\n        case XCP_PROTO_OUT_OF_RANGE:\n            frame->errorCode = XCP_ERR_OUT_OF_RANGE;\n            break;\n        case XCP_PROTO_CMD_UNKNOWN:\n            frame->errorCode = XCP_ERR_CMD_UNKNOWN;\n            break;\n        case XCP_PROTO_SYNCH:\n            frame->errorCode = XCP_ERR_CMD_SYNC;\n            break;\n        case XCP_PROTO_WRITE_PROTECTED:\n            frame->errorCode = XCP_ERR_WRITE_PROTECTED;\n            break;\n        case XCP_PROTO_CMD_SYNTAX:\n            frame->errorCode = XCP_ERR_CMD_SYNTAX;\n            break;\n        case XCP_PROTO_DAQ_ACTIVE:\n            frame->errorCode = XCP_ERR_DAQ_ACTIVE;\n            break;\n        case XCP_PROTO_MODE_NOT_VALID:\n            frame->errorCode = XCP_ERR_MODE_NOT_VALID;\n            break;\n        case XCP_PROTO_DAQ_CONFIG_ERROR:\n            frame->errorCode = XCP_ERR_DAQ_CONFIG;\n            break;\n        case XCP_PROTO_BUSY:\n            frame->errorCode = XCP_ERR_CMD_BUSY;\n            break;\n        case XCP_PROTO_ACCESS_DENIED:\n            frame->errorCode = XCP_ERR_ACCESS_DENIED;\n            break;\n        case XCP_PROTO_SEGMENT_UNKNOWN:\n            frame->errorCode = XCP_ERR_SEGMENT_NOT_VALID;\n            break;\n        case XCP_PROTO_PAGE_UNKNOWN:\n            frame->errorCode = XCP_ERR_PAGE_NOT_VALID;\n            break;\n        case XCP_PROTO_GENERIC_ERROR:\n            frame->errorCode = XCP_ERR_GENERIC;\n            break;\n        case XCP_PROTO_RESOURCE_NOT_ACCESSIBLE:\n            frame->errorCode = XCP_ERR_RESOURCE_NOT_ACCESSIBLE;\n            break;\n        default:\n            /* This should never happen */\n            XCP_PRINTF(\"genericOutputPacketHandler error: %d input code is not supported\", inputCode);\n            frame->errorCode = XCP_ERR_CMD_UNKNOWN;\n        }\n    }\n}\n\n\nconst XcpPacketHandlers* xcpFindPacket(XcpRxPidCode pid, const XcpPacketHandlers* packets, size_t packetsNumber)\n{\n    const XcpPacketHandlers* packet = NULL;\n\n    if (packets != NULL) {\n        size_t i = 0;\n        for (i = 0; (i < packetsNumber) && (packet == NULL); i++) {\n            if (pid == packets[i].PID) {\n                packet = &packets[i];\n            }\n        }\n    }\n\n    return packet;\n}\n\n/*****************************************************************************\n    Public Functions (implementing the Protocol Layer interface)\n******************************************************************************/\nXcpErrorCode xcpInit(\n    int   argc,   /**< [in] number of init parameters              */\n    void *argv[]  /**< [in] array of parameters values (C strings) */\n    )\n{\n    XCP_UNUSED_PARAM(argc);\n    XCP_UNUSED_PARAM(argv);\n\n    XCP_ERROR_IF(initialized, XCP_ERROR, \"xcpInit: protocol layer already initialized\\n\");\n\n    /* Initialize Standard Commands support */\n    xcpStandardInit();\n    groupPacketLookup[XCP_STANDARD_PACKETS_ID] = xcpStandardGetPacketLookup();\n\n    /* Initialize DAQ lists (and STIM) support */\n    xcpDaqInit();\n    groupPacketLookup[XCP_DAQ_PACKETS_ID] = xcpDaqGetPacketLookup();\n\n    /* Initialize Calibration support */\n    xcpCalibrationInit();\n    groupPacketLookup[XCP_CALIBRATION_PACKETS_ID] = xcpCalibrationGetPacketLookup();\n\n    initialized = true;\n\n    return XCP_SUCCESS;\n}\n\nXcpErrorCode xcpRun(void)\n{\n    XcpErrorCode errorCode = XCP_SUCCESS;\n    XcpProtoErrorCode protoErrorCode = XCP_PROTO_SUCCESS;\n    uint8_T *msgBuffer = NULL;\n    size_t   msgBufferSize = 0;\n    size_t   packetOffset = 0;\n    size_t   packetSize = 0;\n    size_t   outputPacketSize = 0;\n    uint8_T *packet = NULL;\n    XcpInputPacketHandler  inputHandler  = NULL;\n    XcpOutputPacketHandler outputHandler = NULL;\n\n    XCP_ERROR_IF(!initialized, XCP_NOT_INITIALIZED, \"xcpRun: protocol layer not initialized\\n\");\n\n    /* Extract a packet from the transport layer */\n    errorCode = xcpTransportRxPacketGet(XCP_TRANSPORT_RX_DEFAULT_QUEUE,\n                                       (void**)&msgBuffer, &msgBufferSize,\n                                       &packetOffset, &packetSize);\n    if ((errorCode != XCP_SUCCESS) &&\n        (errorCode != XCP_PKT_OUT_OF_SEQUENCE) && /* If a wrong packet counter is detected,       */\n        (errorCode != XCP_PKT_LOST)) {            /* the packet content is still considered valid */\n        goto error;\n    }\n\n    /* Check buffer sizes and retrieve the pointer to the XCP packet area */\n    if ((msgBuffer == NULL) || ((packetOffset + XCP_IN_HW_AG(packetSize)) > msgBufferSize)) { \n        errorCode = XCP_INV_SIZE;\n        goto error;\n    }\n\n    /* Identify the handler suitable for processing the given XCP packet */\n    packet = msgBuffer + packetOffset;\n    xcpGetPacketHandlers(packet, packetSize, &inputHandler, &outputHandler);\n\n    /* An input handler needs to be always present */\n    if (inputHandler == NULL) {\n        XCP_PRINTF(\"xcpRun: missing input handler for packet ID %xH\", packet[0]);\n        errorCode = XCP_ERROR;\n        goto error;\n    }\n\n    /* Process input packet */\n    protoErrorCode = inputHandler(msgBuffer, packetOffset, &outputPacketSize);\n\n    if ((outputHandler != NULL) && (outputPacketSize > 0)) {\n        errorCode = XCP_SUCCESS;\n\n        /* An Output Packet needs to be generated -> check if current message buffer is big enough for the response packet */\n        if (packetSize < outputPacketSize) {\n            errorCode = msgBufferRealloc((void **)&msgBuffer, &msgBufferSize, &packetOffset, outputPacketSize);\n        }\n\n        XCP_MEMSET(packet, 0, XCP_IN_HW_AG(packetSize));\n\n        if (errorCode == XCP_SUCCESS) {\n            /* Fill the response packet */\n            packet = msgBuffer + packetOffset;\n            outputHandler(protoErrorCode, packet, outputPacketSize);\n\n            /* Send the response back to the Transport Layer\n               @note to guarantee the maximum responsiveness even when the TX traffic\n                     is maxed out, the highest priority queue is used */\n            errorCode = xcpTransportTxPacketSet(XCP_TRANSPORT_TX_HIGHEST_PRIO_QUEUE,\n                                                XCP_TRANSPORT_NOT_A_DAQ,\n                                                msgBuffer, msgBufferSize,\n                                                packetOffset, outputPacketSize);\n            if (errorCode != XCP_SUCCESS) {\n                goto error;\n            }\n        }\n    }\n\n    return errorCode;\n\nerror:\n    if (msgBuffer != NULL) {\n        xcpMemFree(msgBuffer);\n    }\n\n    return errorCode;\n}\n\nXcpErrorCode xcpEvent(XcpEventIdType eventId)\n{\n    XcpErrorCode errorCode = XCP_SUCCESS;\n    uint32_T timestamp = 0;\n\n    XCP_ERROR_IF(!initialized, XCP_NOT_INITIALIZED, \"xcpEvent: protocol layer not initialized\\n\");\n\n    timestamp = (uint32_T)XCP_TIMESTAMP_GET();\n    \n    /* Process DAQ Lists associated to the event */\n    errorCode = xcpDaqEvent(eventId, timestamp, false);\n\n    return errorCode;\n}\n\nXcpErrorCode xcpEventExternalTimestamp(XcpEventIdType eventId, uint32_T timestamp)\n{\n    XcpErrorCode errorCode = XCP_SUCCESS;\n\n    XCP_ERROR_IF(!initialized, XCP_NOT_INITIALIZED, \"xcpEvent: protocol layer not initialized\\n\");\n\n    /* Process DAQ Lists associated to the event */\n    errorCode = xcpDaqEvent(eventId, timestamp, false);\n\n    return errorCode;\n}\n\nXcpErrorCode xcpEventNotificationReq(XcpEventCode eventCode, const void *eventData, size_t eventDataSize)\n{\n    XcpErrorCode errorCode = XCP_SUCCESS;\n    size_t packetOffset = xcpTransportPacketOffset();\n    size_t maxEventDataSize = xcpTransportMaxCtoSize() - XCP_EVENT_PACKET_SIZE_IN_BYTES;\n    size_t packetSize = 0;\n    uint8_T *msgBuffer = NULL;\n    size_t msgBufferSize = 0;\n\n    /* Validate input parameters */\n    XCP_ERROR_IF((eventDataSize > 0) && (eventData == NULL), XCP_INV_ARG, \"xcpEventNotificationReq: invalid eventData buffer\\n\");\n    XCP_ERROR_IF(eventDataSize > maxEventDataSize, XCP_INV_ARG, \"xcpEventNotificationReq: invalid eventDataSize\\n\");\n\n    /* Calculate the required message buffer size */\n    packetSize = eventDataSize + XCP_EVENT_PACKET_SIZE_IN_BYTES;\n\n    /* Allocate the message buffer */\n    msgBufferSize = xcpTransportMsgBufferSize(packetSize, XCP_CTO);\n    msgBuffer = (uint8_T *)xcpMemAlloc(msgBufferSize);\n\n    if (msgBuffer != NULL) {\n        XcpEventPacketFrame *frame = (XcpEventPacketFrame *) (msgBuffer + packetOffset);\n\n        /* Fill the EV packet information */\n        frame->PID = XCP_PID_EV;\n        frame->eventCode = eventCode;\n\n        if (eventDataSize > 0) {\n            uint8_T *packetEventData = msgBuffer + packetOffset + XCP_IN_HW_AG(XCP_EVENT_PACKET_SIZE_IN_BYTES);\n\n            /* Copy the optional event data */\n            XCP_MEMCPY(packetEventData, eventData, XCP_IN_HW_AG(eventDataSize));\n        }\n\n        /* Send the EV packet to the Transport Layer\n           @note to guarantee that this packet gets delivered as soon as possible\n                 to the XCP Client, the highest priority queue is used */\n        errorCode = xcpTransportTxPacketSet(XCP_TRANSPORT_TX_HIGHEST_PRIO_QUEUE,\n                                            XCP_TRANSPORT_NOT_A_DAQ,\n                                            msgBuffer, msgBufferSize,\n                                            packetOffset, packetSize);\n        if (errorCode != XCP_SUCCESS) {\n            xcpMemFree(msgBuffer);\n        }\n    }\n    else\n    {\n        errorCode = XCP_NO_MEMORY;\n    }\n\n    return errorCode;\n}\n\nXcpErrorCode xcpRemoteServiceReq(XcpReqServiceCode serviceReqCode, const void *serviceReqData, size_t serviceReqDataSize)\n{\n    XcpErrorCode errorCode = XCP_SUCCESS;\n    size_t packetOffset = xcpTransportPacketOffset();\n    size_t maxServiceReqDataSize = xcpTransportMaxCtoSize() - XCP_SERVICE_REQ_PACKET_SIZE_IN_BYTES;\n    size_t packetSize = 0;\n    uint8_T *msgBuffer = NULL;\n    size_t msgBufferSize = 0;\n\n    /* Validate input parameters */\n    XCP_ERROR_IF((serviceReqDataSize > 0) && (serviceReqData == NULL), XCP_INV_ARG, \"xcpRemoteServiceReq: invalid serviceReqData buffer\\n\");\n    XCP_ERROR_IF(serviceReqDataSize > maxServiceReqDataSize, XCP_INV_ARG, \"xcpRemoteServiceReq: invalid serviceReqDataSize\\n\");\n\n    /* Calculate the required message buffer size */\n    packetSize = serviceReqDataSize + XCP_SERVICE_REQ_PACKET_SIZE_IN_BYTES;\n\n    /* Allocate the message buffer */\n    msgBufferSize = xcpTransportMsgBufferSize(packetSize, XCP_CTO);\n    msgBuffer = (uint8_T *)xcpMemAlloc(msgBufferSize);\n\n    if (msgBuffer != NULL) {\n        XcpServiceReqPacketFrame *frame = (XcpServiceReqPacketFrame *) (msgBuffer + packetOffset);\n\n        /* Fill the SERV packet information */\n        frame->PID = XCP_PID_SERV;\n        frame->serviceReqCode = serviceReqCode;\n\n        if (serviceReqDataSize > 0) {\n            uint8_T *packetServiceReqData = msgBuffer + packetOffset + XCP_IN_HW_AG(XCP_SERVICE_REQ_PACKET_SIZE_IN_BYTES);\n\n            /* Copy the optional event data */\n            XCP_MEMCPY(packetServiceReqData, serviceReqData, XCP_IN_HW_AG(serviceReqDataSize));\n        }\n\n        /* Send the SERV packet to the Transport Layer\n           @note to guarantee that this packet gets delivered as soon as possible\n                 to the XCP Client, the highest priority queue is used */\n        errorCode = xcpTransportTxPacketSet(XCP_TRANSPORT_TX_HIGHEST_PRIO_QUEUE,\n                                            XCP_TRANSPORT_NOT_A_DAQ,\n                                            msgBuffer, msgBufferSize,\n                                            packetOffset, packetSize);\n        if (errorCode != XCP_SUCCESS) {\n            xcpMemFree(msgBuffer);\n        }\n    }\n    else\n    {\n        errorCode = XCP_NO_MEMORY;\n    }\n\n    return errorCode;\n}\n\nXcpStatus xcpGetStatus(void)\n{\n    return xcpStatus;\n}\n\nXcpErrorCode xcpReset(void)\n{\n    if (!initialized) {\n        XCP_PRINTF(\"xcpReset: protocol layer already reset\\n\");\n        /* Nothing to do: just printing out a warning message*/\n    }\n\n    /* Reset Calibration support */\n    xcpCalibrationReset();\n\n    /* Reset DAQ lists (and STIM) support */\n    xcpDaqReset();\n\n    /* Reset Standard Commands support */\n    xcpStandardReset();\n\n    XCP_MEMSET((void*)groupPacketLookup, 0, sizeof(groupPacketLookup));\n\n    initialized = false;\n\n    return XCP_SUCCESS;\n}\n\nXcpErrorCode xcpSetCustomPoolMemoryManager(XcpEventIdType eventId, XcpCustomAllocHandler allocHandler, XcpCustomFreeHandler freeHandler)\n{\n    XcpErrorCode errorCode;\n\n    /* Forward registration to DAQ list */\n    errorCode = xcpDaqSetCustomPoolMemoryManager(eventId, allocHandler, freeHandler);\n\n    return errorCode;\n}\n\nXcpErrorCode xcpGetCustomPoolMemoryManager(XcpEventIdType *eventId, XcpCustomAllocHandler *allocHandler, XcpCustomFreeHandler *freeHandler)\n{\n    XcpErrorCode errorCode;\n\n    /* Forward query to DAQ list */\n    errorCode = xcpDaqGetCustomPoolMemoryManager(eventId, allocHandler, freeHandler);\n\n    return errorCode;\n}\n\nXcpErrorCode xcpPackedModeEventsFlush(uint32_T timestamp)\n{\n    XcpErrorCode errorCode;\n\n    errorCode = xcpDaqEventsFlush(timestamp);\n\n    return errorCode;\n}\n\nXcpErrorCode xcpPackedModeEventReset(XcpEventIdType eventId)\n{\n    XcpErrorCode errorCode;\n    boolean_T resetSamples = true;\n\n    /* Reset the status of pending packed DAQ lists,\n       discarding incomplete packets. */\n    errorCode = xcpDaqEvent(eventId, 0, resetSamples);\n\n    return errorCode;\n}\n\n#ifdef XCP_INTERNAL_DAQ_CONFIG_ACCESS_SUPPORT\n\nXcpErrorCode xcpGetDaqOdtEntries(XcpEventIdType eventId,\n                                 XcpOdtEntry* entries,\n                                 size_t* entriesNumber,\n                                 size_t maxEntriesNumber)\n{\n    XcpErrorCode errorCode = XCP_SUCCESS;\n\n    errorCode = xcpDaqGetOdtEntries(eventId, XCP_DIRECTION_DAQ,\n                                 entries, entriesNumber,\n                                 maxEntriesNumber);\n    return errorCode;\n}\n\n#endif /* XCP_INTERNAL_DAQ_CONFIG_ACCESS_SUPPORT */\n\n\n#ifndef XCP_DAQ_SUPPORT\n\nvoid xcpDaqInit(void) {}\nXcpPacketLookupFunction xcpDaqGetPacketLookup(void) {return NULL;}\nvoid xcpDaqSetPacketLookup(XcpPacketLookupFunction getPacket) {XCP_UNUSED_PARAM(getPacket);}\nXcpErrorCode xcpDaqEvent(XcpEventIdType eventId, uint32_T timestamp, boolean_T resetSamples) {XCP_UNUSED_PARAM(eventId); XCP_UNUSED_PARAM(timestamp); XCP_UNUSED_PARAM(resetSamples); return XCP_SUCCESS;}\nboolean_T xcpResetDaqListStatus(void) {return true;}\nXcpErrorCode xcpDaqEventsFlush(uint32_T timestamp) {XCP_UNUSED_PARAM(timestamp); return XCP_SUCCESS;}\nboolean_T xcpDaqLock(void) {return true;}\nvoid xcpDaqUnlock(void) {}\nvoid xcpDaqReset(void) {}\nXcpErrorCode xcpDaqSetCustomPoolMemoryManager(XcpEventIdType eventId, XcpCustomAllocHandler allocHandler, XcpCustomFreeHandler freeHandler) {\n    XCP_UNUSED_PARAM(eventId); XCP_UNUSED_PARAM(allocHandler); XCP_UNUSED_PARAM(freeHandler); return XCP_SUCCESS;}\nXcpErrorCode xcpDaqGetCustomPoolMemoryManager(XcpEventIdType *eventId, XcpCustomAllocHandler *allocHandler, XcpCustomFreeHandler *freeHandler) {\n    XCP_UNUSED_PARAM(eventId); XCP_UNUSED_PARAM(allocHandler); XCP_UNUSED_PARAM(freeHandler); return XCP_SUCCESS;}\n\n#ifdef XCP_INTERNAL_DAQ_CONFIG_ACCESS_SUPPORT\nXcpErrorCode xcpGetDaqOdtEntries(XcpEventIdType eventId, XcpOdtEntry* entries, size_t* entriesNumber, size_t maxEntriesNumber){\n    XCP_UNUSED_PARAM(eventId); XCP_UNUSED_PARAM(entries); XCP_UNUSED_PARAM(entriesNumber); XCP_UNUSED_PARAM(maxEntriesNumber); return XCP_SUCCESS;}\n#endif /* XCP_INTERNAL_DAQ_CONFIG_ACCESS_SUPPORT */\n\n#endif\n\n\n#ifndef XCP_CALIBRATION_SUPPORT\n\nvoid xcpCalibrationInit(void) {}\nXcpPacketLookupFunction xcpCalibrationGetPacketLookup(void) {return NULL;}\nvoid xcpCalibrationSetPacketLookup(XcpPacketLookupFunction getPacket) {XCP_UNUSED_PARAM(getPacket);}\nvoid xcpCalibrationReset(void) {}\n\n#endif\n"},{"name":"xcp_calibration.c","type":"source","group":"legacy","path":"C:\\Users\\Sophie\\Documents\\Hochschule\\Master\\Systeme und Programme\\toolbox\\coder\\xcp\\src\\target\\server\\protocol\\src","tag":"","groupDisplay":"Other files","code":"/*\n* Copyright 2017-2020 The MathWorks, Inc.\n*\n* File: xcp_calibration.c\n*\n* Abstract:\n*  Implementation of XCP Protocol Layer Calibration support\n*/\n\n#include \"xcp_common.h\"\n#include \"xcp.h\"\n#include \"xcp_cfg.h\"\n#include \"xcp_calibration.h\"\n\n#ifdef XCP_CALIBRATION_SUPPORT\n\n#ifdef XCP_CALIBRATION_EXTENDED_SUPPORT\n#include \"xcp_calibration_ext.h\"\n#endif\n\n#include \"xcp_types.h\"\n#include \"xcp_calibration_types.h\"\n#include \"xcp_standard.h\"\n#include \"xcp_transport_internal.h\"\n\n/*****************************************************************************\n    Internal Functions specific to Calibration support\n******************************************************************************/\nstatic boolean_T isValidShortDownloadSize(uint8_T size)\n{\n    size_t addressGranularity = XCP_ADDRESS_GRANULARITY_BYTES_NUMBER;\n    size_t maxCtoSize = xcpTransportMaxCtoSize();\n\n    return (size <= ((maxCtoSize - 8) / addressGranularity));\n}\n\n#if XCP_SET_MTA_ENABLE == 1\n    static boolean_T isValidDownloadSize(uint8_T size)\n    {\n        size_t addressGranularity = XCP_ADDRESS_GRANULARITY_BYTES_NUMBER;\n        size_t maxCtoSize = xcpTransportMaxCtoSize();\n        \n        return ( (size >= 1)  && (size <= (maxCtoSize-2) / addressGranularity ) );\n    }\n#endif  /* XCP_SET_MTA_ENABLE == 1 */\n\n/** memcpy function used to copy data from packet to MTA address */\nstatic void xcpMemcpyToMTA(uint8_T *packet, uint8_T size)\n{\n    /* Retrieve memory address */\n    uint8_T *xcpMTARawPointer = xcpStandardGetAddressFromMta();\n\n    XCP_PRINTF(\"writing at address %p\\n\", xcpMTARawPointer);\n\n#ifdef XCP_EMULATE_BYTE_ADDRESSABLE_TARGET\n{\n    uint32_T address;\n    uint8_T addressExtension;\n    uint8_T dstOffsetBytes;\n    xcpStandardGetMta(&address, &addressExtension);\n    dstOffsetBytes = XCP_BYTE_OFFSET_GET(address);\n    xcpMemcpyByte(xcpMTARawPointer, dstOffsetBytes, packet, 0, size);\n}\n#else\n    XCP_MEMCPY(xcpMTARawPointer, packet, size);\n#endif\n}\n\n/*****************************************************************************\n    XCP DOWNLOAD\n******************************************************************************/\n#if XCP_SET_MTA_ENABLE == 1\n    static XcpProtoErrorCode downloadInputPacketHandler(void   *msgBuffer,\n        size_t  xcpPacketOffset,\n        size_t *outputPacketSize)\n    {\n        XcpProtoErrorCode protoErrorCode = XCP_PROTO_SUCCESS;\n        uint8_T *packet = (uint8_T *)msgBuffer + xcpPacketOffset;\n        XcpDownloadCmdPacketFrame *frame = (XcpDownloadCmdPacketFrame *)packet;\n        boolean_T ok = false;\n        uint8_T *xcpMTARawPointer = xcpStandardGetAddressFromMta();\n\n        /* Check if the number of data elements is valid */\n        ok = isValidDownloadSize((uint8_T)frame->size);\n        XCP_INPUT_PKT_ERROR_IF(!ok, XCP_PROTO_OUT_OF_RANGE,\n            (\"DOWNLOAD: invalid number of data elements (%d)\\n\", frame->size));\n            \n        /* Check if a valid MTA address is available */\n        XCP_INPUT_PKT_ERROR_IF((xcpMTARawPointer == 0) || (xcpMTARawPointer == NULL), \n            XCP_PROTO_ACCESS_DENIED, (\"DOWNLOAD: invalid address\\n\"));\n\n        XCP_PRINTF(\"DOWNLOAD: \");\n    \n        /* Update the value of the parameter with the data element content */\n        xcpMemcpyToMTA(packet + sizeof(XcpDownloadCmdPacketFrame), (uint8_T)frame->size);\n    \n        /* Post-increment MTA by the frame size in address granularity units */\n        xcpStandardIncrementMta((uint8_T)frame->size);\n        \n        *outputPacketSize = XCP_GENERIC_RES_PACKET_SIZE_IN_BYTES;\n\n        return protoErrorCode;\n    }\n#endif  /* XCP_SET_MTA_ENABLE == 1 */\n\n/*****************************************************************************\n    XCP SHORT_DOWNLOAD\n******************************************************************************/\nstatic XcpProtoErrorCode shortDownloadInputPacketHandler(void   *msgBuffer,\n    size_t  xcpPacketOffset,\n    size_t *outputPacketSize)\n{\n    XcpProtoErrorCode protoErrorCode = XCP_PROTO_SUCCESS;\n    uint8_T *packet = (uint8_T *)msgBuffer + xcpPacketOffset;\n    XcpShortDownloadCmdPacketFrame *frame = (XcpShortDownloadCmdPacketFrame *)packet;\n    boolean_T ok = false;\n\n    /* Check if the number of data elements is valid */\n    ok = isValidShortDownloadSize((uint8_T)frame->size);\n    XCP_INPUT_PKT_ERROR_IF(!ok, XCP_PROTO_OUT_OF_RANGE,\n        (\"SHORT_DOWNLOAD: invalid number of data elements (%d)\\n\", frame->size));\n\n    /* Check if the memory address is valid and set the MTA pointer */\n    ok = xcpStandardSetMta(frame->address, (uint8_T)frame->addressExtension);\n    XCP_INPUT_PKT_ERROR_IF(!ok, XCP_PROTO_ACCESS_DENIED, (\"SHORT_DOWNLOAD: invalid address\\n\"));\n\n    XCP_PRINTF(\"SHORT_DOWNLOAD: \");\n\n    /* Update the value of the parameter with the data element content */\n    xcpMemcpyToMTA(packet + sizeof(XcpShortDownloadCmdPacketFrame), (uint8_T)frame->size);\n\n    /* Post-increment MTA by the frame size in address granularity units */\n    xcpStandardIncrementMta((uint8_T)frame->size);\n\n    *outputPacketSize = XCP_GENERIC_RES_PACKET_SIZE_IN_BYTES;\n\n    return protoErrorCode;\n}\n\n\n/** This table contains the list of supported Rx packets and the corresponding handlers */\nstatic const XcpPacketHandlers calibrationSupportedRxPacket[] =\n{\n#if XCP_SET_MTA_ENABLE == 1\n    { XCP_PID_DOWNLOAD,       downloadInputPacketHandler,     genericOutputPacketHandler },\n#endif\n    { XCP_PID_SHORT_DOWNLOAD, shortDownloadInputPacketHandler, genericOutputPacketHandler }\n};\n\n\n/*****************************************************************************\n    XCP Packet Lookup Function for basic calibration commands\n******************************************************************************/\n\n/* Default Calibration Packet Lookup function, supporting only basic commands\n   listed in the table above */\nstatic const XcpPacketHandlers* getPacket(XcpRxPidCode pid)\n{\n    return xcpFindPacket(pid, calibrationSupportedRxPacket,\n                         XCP_ELEMENTS_NUMBER(calibrationSupportedRxPacket));\n}\n\nstatic XcpPacketLookupFunction packetLookup = NULL;\n\n\n\n/*****************************************************************************\n    Public Functions (invoked within the Protocol Layer)\n******************************************************************************/\nvoid xcpCalibrationInit(void)\n{\n    /* Initialize the packet lookup function to support only basic\n       calibration commands */\n    xcpCalibrationSetPacketLookup(getPacket);\n\n#ifdef XCP_CALIBRATION_EXTENDED_SUPPORT\n    /* Initialize support for the extended list of calibration commands */\n    xcpCalibrationExtendedInit();\n#endif\n}\n\n\nXcpPacketLookupFunction xcpCalibrationGetPacketLookup(void)\n{\n    return packetLookup;\n}\n\n\nvoid xcpCalibrationSetPacketLookup(XcpPacketLookupFunction getPacketFcn)\n{\n    packetLookup = getPacketFcn;\n}\n\nvoid xcpCalibrationReset(void)\n{\n#ifdef XCP_CALIBRATION_EXTENDED_SUPPORT\n    /* Reset support for the extended list of calibration commands */\n    xcpCalibrationExtendedReset();\n#endif\n}\n\n#endif\n"},{"name":"xcp_daq.c","type":"source","group":"legacy","path":"C:\\Users\\Sophie\\Documents\\Hochschule\\Master\\Systeme und Programme\\toolbox\\coder\\xcp\\src\\target\\server\\protocol\\src","tag":"","groupDisplay":"Other files","code":"/*\n* Copyright 2016-2023 The MathWorks, Inc.\n*\n* File: xcp_daq.c\n*\n* Abstract:\n*  Implementation of XCP Protocol Layer DAQ Lists (and STIM) support\n*/\n\n#include \"xcp_common.h\"\n#include \"xcp.h\"\n#include \"xcp_internal.h\"\n#include \"xcp_cfg.h\"\n#include \"xcp_daq.h\"\n\n#ifdef XCP_DAQ_SUPPORT\n#include \"xcp_daq_ext.h\"\n#include \"xcp_transport_internal.h\"\n#include \"xcp_types.h\"\n#include \"xcp_daq_types.h\"\n#include \"xcp_mem.h\"\n\n/*****************************************************************************\n    Internal Global variables specific to DAQ support\n******************************************************************************/\n\n/** Dynamic DAQ Lists data structures */\nstatic XcpDaqLists xcpDynamicDaqLists;\n\n/** Number of event threads currently in execution */\nstatic size_t xcpRunningEventCounter = 0;\n\n/** ID of the selected DAQ List on START_STOP_DAQ_LIST command */\n#define XCP_INVALID_DAQ_LIST_ID -1\nstatic int32_T startStopDaqListId = XCP_INVALID_DAQ_LIST_ID;\n\n/** Pointer to current ODT entry */\nstatic XcpDaqPtr   xcpCurrentDaq = { 0xFFFF, 0xFF, 0xFF };\n\nstatic XcpEventCustomMemoryManager xcpEventCustomMemoryManager = {XCP_DAQ_CUSTOM_MEMORY_INVALID_EVENT_ID, NULL, NULL};\n\n#ifndef XCP_DAQ_LIST_INDEPENDENT_EVENT_LOCK\n#ifdef XCP_LOCKLESS_SYNC_DATA_TRANSFER_SUPPORT\n/* XCP_LOCKLESS_SYNC_DATA_TRANSFER_SUPPORT is typically enabled\n   for multi-core applications, where it is critical to limit\n   the interference between threads streaming data.\n   For this reason, by default we enable the independent lock\n   of the DAQ list data structures between events */\n#define XCP_DAQ_LIST_INDEPENDENT_EVENT_LOCK 1\n#else\n/* XCP_LOCKLESS_SYNC_DATA_TRANSFER_SUPPORT is typically disabled\n   for single-core bare-metal applications, where it is critical\n   to limit the memory footprint of the target executable.\n   For this reason, by default we disable the independent lock\n   of the DAQ list data structures between events and use a single\n   mutex to protect the DAQ lists data structures */\n#define XCP_DAQ_LIST_INDEPENDENT_EVENT_LOCK 0\n#endif\n\n#endif\n\n\n#if !defined(XCP_DAQ_LIST_INDEPENDENT_EVENT_LOCK) || (XCP_DAQ_LIST_INDEPENDENT_EVENT_LOCK == 0)\n/* Mutex protecting against the concurrent access to DAQ Lists data structures */\nstatic XCP_MUTEX_DEFINE(daqLock);\n\nstatic boolean_T xcpDaqWriteLock(XcpEventIdType eventId)\n{\n    boolean_T locked = false;\n    XCP_UNUSED_PARAM(eventId);\n    XCP_WRITE_TRY_LOCK(daqLock, xcpRunningEventCounter, locked);\n\n    return locked;\n}\n\nstatic void xcpDaqWriteUnlock(XcpEventIdType eventId)\n{\n    XCP_UNUSED_PARAM(eventId);\n    XCP_WRITE_UNLOCK(daqLock);\n}\n\nstatic void xcpDaqReadLock(XcpEventIdType eventId)\n{\n    XCP_UNUSED_PARAM(eventId);\n    XCP_READ_LOCK(daqLock, xcpRunningEventCounter);\n}\n\nstatic void xcpDaqReadUnlock(XcpEventIdType eventId)\n{\n    XCP_UNUSED_PARAM(eventId);\n    XCP_READ_UNLOCK(daqLock, xcpRunningEventCounter);\n}\n\n#else\n/* Each XCP event has an independent mutex to protect the read/write access\n   to the DAQ list data structures */\n#ifndef XCP_MAX_EVENT_DATA_NUMBER\n#define XCP_MAX_EVENT_DATA_NUMBER XCP_MAX_EVENT_CHANNEL\n#endif\n\ntypedef struct XcpEventData {\n    XCP_MUTEX_DEFINE(lock);\n} XcpEventData;\n\n/** Array of event-specific data */\nstatic XcpEventData xcpEventData[XCP_MAX_EVENT_DATA_NUMBER];\n\nstatic boolean_T xcpDaqWriteLock(XcpEventIdType eventId)\n{\n    XCP_MUTEX_LOCK(xcpEventData[eventId].lock);\n    return true;\n}\n\nstatic void xcpDaqWriteUnlock(XcpEventIdType eventId)\n{\n    XCP_MUTEX_UNLOCK(xcpEventData[eventId].lock);\n}\n\nstatic void xcpDaqReadLock(XcpEventIdType eventId)\n{\n    XCP_MUTEX_LOCK(xcpEventData[eventId].lock);\n}\n\nstatic void xcpDaqReadUnlock(XcpEventIdType eventId)\n{\n    XCP_MUTEX_UNLOCK(xcpEventData[eventId].lock);\n}\n\n#endif\n\n#ifndef XCP_MIN_EVENT_NO_RESERVED_POOL\n#define XCP_MIN_EVENT_NO_RESERVED_POOL 0xFFFF\n#endif\n\n/*****************************************************************************\n    Internal Functions specific to DAQ support\n******************************************************************************/\n\n/* When enabled, timestamp is required for first ODT in the DAQ list */\n#if XCP_TIMESTAMP_FIXED == 0\n#define IS_TIMESTAMP_REQUIRED(mode, odtNumber) ((odtNumber == 0) && \\\n            XCP_READ_BIT_VALUE(mode, XCP_DAQ_MODE_TIMESTAMP_MASK))\n#else\n#define IS_TIMESTAMP_REQUIRED(mode, odtNumber) (odtNumber == 0)\n#endif\n\n/* Incrementing pointer. byteOffset argument will have a valid value only when\n   we are emulating as a BYTE addressable target. Otherwise, it is 0. */\n#ifdef XCP_EMULATE_BYTE_ADDRESSABLE_TARGET\n#define XCP_HW_PTR_INCREMENT(ptr, incr, byteOffset) (uint8_T *)(byteOffset ? (ptr + XCP_IN_HW_AG(incr - 1)) : (ptr + XCP_IN_HW_AG(incr)))\n#else\n#define XCP_HW_PTR_INCREMENT(ptr, incr, byteOffset) (uint8_T *)(ptr + incr)\n#endif\n\n/* Update byteOffset when emulating as a BYTE addressable target */\n#ifdef XCP_EMULATE_BYTE_ADDRESSABLE_TARGET\n#define XCP_HW_BYTE_OFFSET_UPDATE(offset, size) ((offset + size) % XCP_HARDWARE_ADDRESS_GRANULARITY_BYTES_NUMBER)\n#else\n#define XCP_HW_BYTE_OFFSET_UPDATE(offset, size) 0\n#endif\n\n#define IS_USING_CUSTOM_POOL(x) (x == xcpEventCustomMemoryManager.eventId)\n\nstatic boolean_T isActiveDaqList(uint16_T daqListId)\n{\n    return (xcpDynamicDaqLists.daq[daqListId].status == XCP_DAQ_SELECTED) ||\n           (xcpDynamicDaqLists.daq[daqListId].status == XCP_DAQ_STARTED);\n}\n\nstatic boolean_T noActiveDaqLists(void)\n{\n    boolean_T found = 0;\n    uint16_T i = 0;\n\n    for (i = 0; (i < xcpDynamicDaqLists.daqCount) && !found; i++) {\n        found = isActiveDaqList(i);\n    }\n\n    return !found;\n}\n\nstatic boolean_T isValidDaqPtr(uint16_T daqListId, uint8_T odtId, uint8_T odtEntryId)\n{\n    boolean_T ret = (xcpDynamicDaqLists.daq != NULL) &&\n                    (daqListId < xcpDynamicDaqLists.daqCount) &&\n                    (xcpDynamicDaqLists.daq[daqListId].odt != NULL) &&\n                    (odtId < xcpDynamicDaqLists.daq[daqListId].odtCount) &&\n                    (xcpDynamicDaqLists.daq[daqListId].odt[odtId].entry != NULL) &&\n                    (odtEntryId < xcpDynamicDaqLists.daq[daqListId].odt[odtId].entriesCount);\n\n    return ret;\n}\n\nstatic boolean_T isValidDaqEntry(uint8_T bitOffset, uint8_T size, uint32_T address)\n{\n    boolean_T ret = false;\n    uint16_T  entrySize = size;     /* cast to 16-bit avoids -Werror=type-limits */\n\n    if (bitOffset == 0xFF) {\n        /* \"Normal\" (non-bitwise) access has been selected */\n        if ( (entrySize <= XCP_MAX_ODT_ENTRY_SIZE) &&\n             (entrySize % (XCP_ODT_ENTRY_SIZE_GRANULARITY/XCP_ADDRESS_GRANULARITY_BYTES_NUMBER) == 0) &&\n             (  address % (XCP_ODT_ENTRY_SIZE_GRANULARITY/XCP_ADDRESS_GRANULARITY_BYTES_NUMBER) == 0) ) {\n            ret = true;\n        }\n    }\n    else {\n        /* Bitwise access has been selected */\n        if ((bitOffset <= 0x1F) && (address % XCP_ODT_ENTRY_SIZE_GRANULARITY) &&\n            (entrySize == XCP_ODT_ENTRY_SIZE_GRANULARITY)) {\n            ret = true;\n        }\n    }\n\n    return ret;\n}\n\n/** The current supported mode includes:\n- alternating = 0\n- direction = 0 (DAQ only)\n- timestamp = 1 or 0\n- PID OFF = 0\n*/\nstatic boolean_T isSupportedDaqListMode(uint8_T mode)\n{\n    #if XCP_TIMESTAMP_FIXED == 0\n        return ( (mode & ~XCP_DAQ_MODE_TIMESTAMP_MASK) == 0 );\n    #else\n        return (mode == XCP_DAQ_MODE_TIMESTAMP_MASK);\n    #endif\n}\n\nstatic boolean_T isValidStartStopMode(uint8_T mode)\n{\n    boolean_T ret = false;\n\n    if ((mode == XCP_DAQ_LIST_STOP) ||\n        (mode == XCP_DAQ_LIST_START) ||\n        (mode == XCP_DAQ_LIST_SELECT))\n        ret = true;\n\n    return ret;\n}\n\nstatic boolean_T isValidStartStopSynchMode(uint8_T mode)\n{\n    boolean_T ret = false;\n\n    if ((mode == XCP_DAQ_LIST_STOP_ALL) ||\n        (mode == XCP_DAQ_LIST_START_SELECTED) ||\n        (mode == XCP_DAQ_LIST_STOP_SELECTED))\n        ret = true;\n\n    return ret;\n}\n\nstatic boolean_T absoluteOdtNumberIdentification(void)\n{\n    return (XCP_ID_FIELD_TYPE == XCP_ID_ABSOLUTE_ODT_NUMBER);\n}\n\nstatic boolean_T isDaqPackedModeEnabled(uint16_T daqListId)\n{\n    /* DAQ Packed Mode is only supported for event-grouped packing and \n       reserved memory pool */\n\n    boolean_T isEnabled = (xcpDynamicDaqLists.daq[daqListId].packedMode == XCP_DAQ_EVENT_GROUPED_PACKING) &&\n                          !IS_USING_CUSTOM_POOL(xcpDynamicDaqLists.daq[daqListId].eventId);\n    \n#if XCP_MEM_DAQ_RESERVED_POOLS_NUMBER > 0\n    isEnabled = isEnabled && (daqListId < XCP_MEM_DAQ_RESERVED_POOLS_NUMBER);\n#endif\n\n    return isEnabled;\n}\n\n/* Return size of packet associated with the odt at the protocol layer */\nstatic size_t odtPacketSize(XcpDaq *daq, uint8_T odtNumber) {\n    XcpOdt *odt = &daq->odt[odtNumber];\n    size_t packetSize = XCP_IN_BYTES(odt->size * daq->sampleCount + XCP_IN_AG(XCP_ID_FIELD_SIZE));\n\n    if (IS_TIMESTAMP_REQUIRED(daq->mode, odtNumber)) {\n        packetSize += XCP_TIMESTAMP_SIZE;\n    }\n\n    return packetSize;\n}\n\n/* Try to allocate a reserved memory pool dedicated to the packets in the DAQ list.\n   @note depending on the configuration of the memory allocator, this may fail\n         so we just set daq->poolId to XCP_INVALID_POOL_ID in that case */\nstatic XcpErrorCode createDaqReservedPool(XcpDaq *daq)\n{\n    XcpErrorCode errorCode = XCP_SUCCESS;\n    size_t poolBlockSize = 0;\n    uint8_T i = 0;\n\n    /* Calculate the max size for the ODT packets in the given DAQ list */\n    for (i = 0; i < daq->odtCount; i++) {\n        /* Calculate the required message buffer size */\n        size_t packetSize = odtPacketSize(daq, i);\n        size_t msgBufferSize = 0;\n\n        msgBufferSize = xcpTransportMsgBufferSize(packetSize, XCP_DTO);\n\n        if (msgBufferSize > poolBlockSize) {\n            poolBlockSize = msgBufferSize;\n        }\n    }\n\n    /* Try the allocation of the dedicate pool */\n    errorCode = xcpMemReservedPoolCreate(poolBlockSize,\n        (size_t)XCP_MEM_DAQ_RESERVED_POOL_BLOCKS_NUMBER * daq->odtCount,\n        &daq->poolId);\n    if (errorCode != XCP_SUCCESS) {\n        daq->poolId = XCP_INVALID_POOL_ID;\n    }\n\n    #ifdef XCP_DEBUG_SUPPORT\n    xcpMemPrintDiagnostics();\n    #endif\n\n    return errorCode;\n}\n\nstatic void destroyDaqReservedPool(XcpDaq *daq)\n{\n    if (daq->poolId != XCP_INVALID_POOL_ID) {\n        xcpMemReservedPoolDestroy(daq->poolId);\n    }\n\n    daq->poolId = XCP_INVALID_POOL_ID;\n}\n\n\n/*****************************************************************************\n    XCP SET DAQ PTR\n******************************************************************************/\nstatic XcpProtoErrorCode setDaqPtrInputPacketHandler(void   *msgBuffer,\n                                                     size_t  xcpPacketOffset,\n                                                     size_t *outputPacketSize)\n{\n    XcpProtoErrorCode protoErrorCode = XCP_PROTO_SUCCESS;\n    uint8_T *packet = (uint8_T *)msgBuffer + xcpPacketOffset;\n    XcpSetDaqPtrCmdPacketFrame *frame = (XcpSetDaqPtrCmdPacketFrame *) packet;\n    uint16_T daqListId  = (uint16_T)frame->daqListId;\n    uint8_T  odtId      = (uint8_T)frame->odtId;\n    uint8_T  odtEntryId = (uint8_T)frame->odtEntryId;\n    boolean_T ok = false;\n\n    /* Check if the selected ODT Entry is available */\n    ok = isValidDaqPtr(daqListId, odtId, odtEntryId);\n    XCP_INPUT_PKT_ERROR_IF(!ok, XCP_PROTO_OUT_OF_RANGE,\n        (\"SET_DAQ_PTR: ODT entry not available (DAQ %d, ODT %d, Entry %d)\\n\", daqListId, odtId, odtEntryId));\n\n    /* Check if the DAQ list is currently active */\n    ok = !isActiveDaqList(daqListId);\n    XCP_INPUT_PKT_ERROR_IF(!ok, XCP_PROTO_DAQ_ACTIVE, (\"SET_DAQ_PTR: DAQ list %d is currently active\\n\", daqListId));\n\n    /* Everything is fine -> proceed and update the current ODT entry pointer */\n    XCP_PRINTF(\"SET_DAQ_PTR: updating current ODT entry pointer to DAQ %d, ODT %d, Entry %d\\n\",\n               daqListId, odtId, odtEntryId);\n\n    xcpCurrentDaq.daqListId  = daqListId;\n    xcpCurrentDaq.odtId      = odtId;\n    xcpCurrentDaq.odtEntryId = odtEntryId;\n\n    *outputPacketSize = XCP_GENERIC_RES_PACKET_SIZE_IN_BYTES;\n\n    return protoErrorCode;\n}\n\n/*****************************************************************************\n    XCP WRITE DAQ\n******************************************************************************/\nstatic XcpProtoErrorCode writeDaqInputPacketHandler(void   *msgBuffer,\n                                                    size_t  xcpPacketOffset,\n                                                    size_t *outputPacketSize)\n{\n    XcpProtoErrorCode protoErrorCode = XCP_PROTO_SUCCESS;\n    uint8_T *packet = (uint8_T *)msgBuffer + xcpPacketOffset;\n    XcpWriteDaqCmdPacketFrame *frame = (XcpWriteDaqCmdPacketFrame *)packet;\n    uint16_T daqListId = xcpCurrentDaq.daqListId;\n    uint8_T  odtId = xcpCurrentDaq.odtId;\n    uint8_T  odtEntryId = xcpCurrentDaq.odtEntryId;\n    XcpOdtEntry *entry = NULL;\n    boolean_T ok = false;\n\n    /* Check if the selected ODT Entry is available */\n    ok = isValidDaqPtr(daqListId, odtId, odtEntryId);\n    XCP_INPUT_PKT_ERROR_IF(!ok, XCP_PROTO_WRITE_PROTECTED,\n        (\"WRITE_DAQ: current ODT entry not available for write operations (DAQ %d, ODT %d, Entry %d)\\n\", daqListId, odtId, odtEntryId));\n\n    /* Check if the DAQ list is currently active */\n    ok = !isActiveDaqList(daqListId);\n    XCP_INPUT_PKT_ERROR_IF(!ok, XCP_PROTO_DAQ_ACTIVE, (\"XCP_WRITE_DAQ: DAQ list %d is currently active\\n\", daqListId));\n\n    /* Check if the Entry values are valid */\n    ok = isValidDaqEntry((uint8_T)frame->bitOffset, (uint8_T)frame->size, (uint32_T)frame->address);\n    XCP_INPUT_PKT_ERROR_IF(!ok, XCP_PROTO_OUT_OF_RANGE,\n        (\"XCP_WRITE_DAQ: invalid DAQ %d ODT %d Entry %d value: bitOffset = %xH size = %d addressExtension = %dH address = %xH\\n\",\n         daqListId, odtId, odtEntryId, frame->bitOffset, frame->size, frame->addressExtension, frame->address));\n\n    /* Everything is fine -> proceed and write the entry */\n    XCP_PRINTF(\"XCP_WRITE_DAQ: writing DAQ %d ODT %d Entry %d: bitOffset = %xH size = %d addressExtension = %dH address = %xH\\n\",\n               daqListId, odtId, odtEntryId, frame->bitOffset, frame->size, frame->addressExtension, frame->address);\n\n    entry = &(xcpDynamicDaqLists.daq[daqListId].odt[odtId].entry[odtEntryId]);\n\n    entry->bitOffset        = (uint8_T)frame->bitOffset;\n    entry->size             = (uint8_T)frame->size;\n    entry->addressExtension = (uint8_T)frame->addressExtension;\n    entry->address          = (uint32_T)frame->address;\n\n    /* After a successful WRITE_DAQ, the xcpDaqPtr odtEntryId needs to be post incremented */\n    xcpCurrentDaq.odtEntryId++;\n\n    *outputPacketSize = XCP_GENERIC_RES_PACKET_SIZE_IN_BYTES;\n\n    return protoErrorCode;\n}\n\n/*****************************************************************************\n    XCP SET DAQ LIST MODE\n******************************************************************************/\nstatic XcpProtoErrorCode setDaqListModeInputPacketHandler(void   *msgBuffer,\n                                                          size_t  xcpPacketOffset,\n                                                          size_t *outputPacketSize)\n{\n    XcpProtoErrorCode protoErrorCode = XCP_PROTO_SUCCESS;\n    uint8_T *packet = (uint8_T *)msgBuffer + xcpPacketOffset;\n    XcpSetDaqListModeCmdPacketFrame *frame = (XcpSetDaqListModeCmdPacketFrame *)packet;\n    XcpDaq *daqList = NULL;\n    boolean_T ok = false;\n\n    /* Check if the DAQ List is available */\n    ok = (xcpDynamicDaqLists.daq != NULL) && (frame->daqListId < xcpDynamicDaqLists.daqCount);\n    XCP_INPUT_PKT_ERROR_IF(!ok, XCP_PROTO_OUT_OF_RANGE, (\"SET_DAQ_LIST_MODE: DAQ list %d not available\\n\", frame->daqListId));\n\n    daqList = &(xcpDynamicDaqLists.daq[frame->daqListId]);\n\n    /* Check if the DAQ list is currently active */\n    ok = !isActiveDaqList((uint16_T)frame->daqListId);\n    XCP_INPUT_PKT_ERROR_IF(!ok, XCP_PROTO_DAQ_ACTIVE, (\"SET_DAQ_LIST_MODE: DAQ list %d is currently active\\n\", frame->daqListId));\n\n    /* Check if the Event Id is valid */\n    ok = (frame->eventId < XCP_MAX_EVENT_CHANNEL);\n    XCP_INPUT_PKT_ERROR_IF(!ok, XCP_PROTO_OUT_OF_RANGE, (\"SET_DAQ_LIST_MODE: invalid event channel Id %d\\n\", frame->eventId));\n\n    /* Check DAQ list priority */\n    ok = (frame->priority == 0);\n    XCP_INPUT_PKT_ERROR_IF(!ok, XCP_PROTO_OUT_OF_RANGE, (\"SET_DAQ_LIST_MODE: priority not supported, must be zero\\n\"));\n\n    /* Check if DAQ list mode is supported */\n    ok = isSupportedDaqListMode((uint8_T)frame->mode);\n    XCP_INPUT_PKT_ERROR_IF(!ok, XCP_PROTO_MODE_NOT_VALID, (\"SET_DAQ_LIST_MODE: DAQ list mode not supported %xH\\n\", frame->mode));\n\n    /* Everything is fine -> proceed and set the DAQ list mode */\n    XCP_PRINTF(\"SET_DAQ_LIST_MODE: setting DAQ list %d: mode = %xH, eventId = %d, prescaler = %d, priority = %d\\n\",\n        frame->daqListId, frame->mode, frame->eventId, frame->prescaler, frame->priority);\n\n    daqList->mode       = (uint8_T)frame->mode;\n    daqList->eventId    = (uint16_T)frame->eventId;\n    daqList->prescaler  = (uint8_T)frame->prescaler;\n    daqList->priority   = (uint8_T)frame->priority;\n\n    /* Assuming that prescaler = 0 means value that you are not interested in using it */\n    if (daqList->prescaler <= 1)\n        daqList->prescaler = 1;\n\n    *outputPacketSize = XCP_GENERIC_RES_PACKET_SIZE_IN_BYTES;\n\n    return protoErrorCode;\n}\n\n/*****************************************************************************\n    XCP START_STOP_DAQ_LIST\n******************************************************************************/\nstatic XcpProtoErrorCode startStopDaqListInputPacketHandler(void   *msgBuffer,\n                                                            size_t  xcpPacketOffset,\n                                                            size_t *outputPacketSize)\n{\n    XcpProtoErrorCode protoErrorCode = XCP_PROTO_SUCCESS;\n    uint8_T *packet = (uint8_T *)msgBuffer + xcpPacketOffset;\n    XcpStartStopDaqListCmdPacketFrame *frame = (XcpStartStopDaqListCmdPacketFrame *)packet;\n    XcpDaq *daqList = NULL;\n    int32_T daqListId = frame->daqListId;\n    boolean_T ok = false;\n    boolean_T locked = false;\n\n    /* Check if the DAQ List is available */\n    ok = (xcpDynamicDaqLists.daq != NULL) && (daqListId < xcpDynamicDaqLists.daqCount);\n    XCP_INPUT_PKT_ERROR_IF(!ok, XCP_PROTO_OUT_OF_RANGE,\n        (\"START_STOP_DAQ_LIST: DAQ list %d not available\\n\", daqListId));\n\n    startStopDaqListId = daqListId;\n    daqList = &(xcpDynamicDaqLists.daq[daqListId]);\n\n    /* Check if requested mode is valid */\n    ok = isValidStartStopMode((uint8_T)frame->mode);\n    XCP_INPUT_PKT_ERROR_IF(!ok, XCP_PROTO_MODE_NOT_VALID,\n        (\"START_STOP_DAQ_LIST: invalid mode %d selected \\n\", frame->mode));\n\n    /* Assign the Absolute ODT number */\n    if (absoluteOdtNumberIdentification()) {\n        if (daqList->status == XCP_DAQ_INIT) {\n            /* The DAQ list has never been started/stopped/selected before\n            -> PIDs for the ODTs needs to be reserved */\n            if (XCP_READ_BIT_VALUE(daqList->mode, XCP_DAQ_MODE_DIRECTION_MASK)) {\n                /* STIM */\n                ok = (daqList->odt != NULL) &&\n                       ((xcpDynamicDaqLists.firstAvailableStimPid +\n                        daqList->odtCount) <= XCP_MAX_STIM_ODT_NUMBER);\n\n                if (ok) {\n                    daqList->firstPid = xcpDynamicDaqLists.firstAvailableStimPid;\n                    xcpDynamicDaqLists.firstAvailableStimPid += daqList->odtCount;\n                }\n            }\n            else {\n                /* DAQ */\n                ok = (daqList->odt != NULL) &&\n                       ((xcpDynamicDaqLists.firstAvailableDaqPid +\n                        daqList->odtCount) <= XCP_MAX_DAQ_ODT_NUMBER);\n\n                if (ok) {\n                    daqList->firstPid = xcpDynamicDaqLists.firstAvailableDaqPid;\n                    xcpDynamicDaqLists.firstAvailableDaqPid += daqList->odtCount;\n                }\n            }\n\n            XCP_INPUT_PKT_ERROR_IF(!ok, XCP_PROTO_DAQ_CONFIG_ERROR,\n                (\"START_STOP_DAQ_LIST: cannot assign PIDs for DAQ list %d \\n\", daqListId));\n        }\n    }\n\n    /* Check the ODT configuration and also if the ODT sizes fits the Max DTO size */\n    if ((frame->mode == XCP_DAQ_LIST_START) || (frame->mode == XCP_DAQ_LIST_SELECT)) {\n        int i = 0;\n\n        ok = true;\n        for (i = 0; (i < daqList->odtCount) && ok; i++) {\n            int j = 0;\n            size_t odtSize = 0;\n\n            /* Calculate the resulting ODT size */\n            for (j = 0; j < daqList->odt[i].entriesCount; j++) {\n                odtSize += daqList->odt[i].entry[j].size;\n            }\n\n            /* Check that the resulting ODT size is valid */\n            if (IS_TIMESTAMP_REQUIRED(daqList->mode, i)){\n                ok = (XCP_IN_BYTES(odtSize * daqList->sampleCount + XCP_IN_AG(XCP_ID_FIELD_SIZE)) + XCP_TIMESTAMP_SIZE) <= xcpTransportMaxDtoSize();\n            }\n            else{\n                ok = (XCP_IN_BYTES(odtSize * daqList->sampleCount + XCP_IN_AG(XCP_ID_FIELD_SIZE))) <= xcpTransportMaxDtoSize();\n            }\n            XCP_INPUT_PKT_ERROR_IF(!ok, XCP_PROTO_DAQ_CONFIG_ERROR,\n                (\"START_STOP_DAQ_LIST: in DAQ list %d the ODT entries size is larger than Max DTO size for ODT %d \\n\", daqListId, i));\n\n            /* Update the ODT size */\n            daqList->odt[i].size = odtSize;\n        }\n    }\n\n    /* Everything is fine -> proceed and change the DAQ list status */\n    locked = xcpDaqWriteLock(daqList->eventId);\n\n    if (locked) {\n        XcpErrorCode createPoolError = XCP_SUCCESS;\n\n        switch (frame->mode) {\n        case XCP_DAQ_LIST_STOP:\n            XCP_PRINTF(\"START_STOP_DAQ_LIST: stopping DAQ list %d\\n\", daqListId);\n            daqList->status = XCP_DAQ_STOPPED;\n            if (noActiveDaqLists()) {\n                /* update status if this was the only active DAQ list */\n                xcpStatusSet(XCP_CONNECTED);\n                xcpSessionStatusClearMask(XCP_SESSION_DAQ_RUNNING_MASK);\n            }\n            break;\n\n        case XCP_DAQ_LIST_START:\n            XCP_PRINTF(\"START_STOP_DAQ_LIST: starting DAQ list %d\\n\", daqListId);\n\n            /* daqList->poolId is initialized with XCP_INVALID_POOL_ID in\n               allocDaqInputPacketHandler.\n\n               Allocate a reserved memory pool for the DAQ list, if needed. */\n            if (daqList->poolId == XCP_INVALID_POOL_ID) {\n                if (IS_USING_CUSTOM_POOL(daqList->eventId)) {\n                    /* Forward custom memory information to the memory manager */\n                    createPoolError = xcpMemCustomPoolCreate(\n                                          xcpEventCustomMemoryManager.allocHandler, \n                                          xcpEventCustomMemoryManager.freeHandler,\n                                          &daqList->poolId);\n                } else if (daqListId < XCP_MEM_DAQ_RESERVED_POOLS_NUMBER\n                    && daqList->eventId < XCP_MIN_EVENT_NO_RESERVED_POOL) {\n                    /* Create a reserved memory pool, if not already created */\n                    createPoolError = createDaqReservedPool(daqList);\n                    daqList->currentSample = 0;\n                }\n            }\n\n            if (createPoolError == XCP_SUCCESS) {\n                daqList->status = XCP_DAQ_STARTED;\n                xcpStatusSet(XCP_SYNC_DATA_TRANSFER);\n                xcpSessionStatusSetMask(XCP_SESSION_DAQ_RUNNING_MASK);\n            }\n            break;\n\n        case XCP_DAQ_LIST_SELECT:\n            XCP_PRINTF(\"START_STOP_DAQ_LIST: selected DAQ list %d\\n\", frame->daqListId);\n            daqList->status = XCP_DAQ_SELECTED;\n            break;\n        }\n\n        xcpDaqWriteUnlock(daqList->eventId);\n\n        *outputPacketSize = XCP_START_STOP_DAQ_LIST_RES_PACKET_SIZE_IN_BYTES;\n        XCP_INPUT_PKT_ERROR_IF(createPoolError != XCP_SUCCESS, XCP_PROTO_MEMORY_OVERFLOW,\n                (\"START_STOP_DAQ_LIST: cannot allocate reserved memory pool for the DAQ list\\n\"));\n    }\n\n    /* Error if the command cannot be executed as the processing of\n       at least one event was in progress */\n    XCP_INPUT_PKT_ERROR_IF(!locked, XCP_PROTO_BUSY,\n        (\"START_STOP_DAQ_LIST: cannot be carried out as an event was processed\\n\"));\n\n    return protoErrorCode;\n}\n\nstatic void startStopDaqListOutputPacketHandler(XcpProtoErrorCode inputCode, void *packet, size_t packetSize)\n{\n    if (inputCode == XCP_PROTO_SUCCESS) {\n        XcpStartStopDaqListResPacketFrame *frame = (XcpStartStopDaqListResPacketFrame *)packet;\n\n        /* Fill the response */\n        frame->PID      = XCP_PID_RES;\n        frame->firstPid = xcpDynamicDaqLists.daq[startStopDaqListId].firstPid;\n    }\n    else {\n        genericOutputPacketHandler(inputCode, packet, packetSize);\n    }\n}\n\n/*****************************************************************************\n    XCP START_STOP_SYNCH\n******************************************************************************/\nstatic XcpProtoErrorCode startStopSynchInputPacketHandler(void   *msgBuffer,\n                                                          size_t  xcpPacketOffset,\n                                                          size_t *outputPacketSize)\n{\n    XcpProtoErrorCode protoErrorCode = XCP_PROTO_SUCCESS;\n    uint8_T *packet = (uint8_T *)msgBuffer + xcpPacketOffset;\n    XcpStartStopSynchCmdPacketFrame *frame = (XcpStartStopSynchCmdPacketFrame *)packet;\n    boolean_T ok = false;\n    boolean_T locked = false;\n    int32_T i = 0;\n\n    /* Check if requested mode is valid */\n    ok = isValidStartStopSynchMode((uint8_T)frame->mode);\n    XCP_INPUT_PKT_ERROR_IF(!ok, XCP_PROTO_MODE_NOT_VALID,\n        (\"START_STOP_SYNCH: invalid mode %d selected \\n\", frame->mode));\n\n    /* Check if the DAQ Lists are available */\n    ok = (xcpDynamicDaqLists.daq != NULL) && (xcpDynamicDaqLists.daqCount > 0);\n    XCP_INPUT_PKT_ERROR_IF(!ok, XCP_PROTO_OUT_OF_RANGE,\n        (\"START_STOP_SYNCH: DAQ lists not available\\n\"));\n\n    /* Everything is fine -> proceed and try to change the DAQ list status */\n\n    /* Need to get the lock to guarantee that they are all done in the same cycle */\n    locked = xcpDaqLock();\n\n    if (locked) {\n        XcpErrorCode createPoolError = XCP_SUCCESS;\n        uint16_T daqListId = 0;\n\n        switch (frame->mode) {\n        case XCP_DAQ_LIST_STOP_ALL:\n            for (i = 0; i < xcpDynamicDaqLists.daqCount; i++) {\n                if (xcpDynamicDaqLists.daq[i].status != XCP_DAQ_INIT) {\n                    XCP_PRINTF(\"START_STOP_SYNCH: stopping DAQ list %d\\n\", i);\n                    xcpDynamicDaqLists.daq[i].status = XCP_DAQ_STOPPED;\n                }\n            }\n\n            /* update status as there are no more active DAQ list */\n            xcpStatusSet(XCP_CONNECTED);\n            xcpSessionStatusClearMask(XCP_SESSION_DAQ_RUNNING_MASK);\n            break;\n\n        case XCP_DAQ_LIST_START_SELECTED:\n            /* xcpDynamicDaqLists.daq[i].poolId is initialized with\n               XCP_INVALID_POOL_ID in allocDaqInputPacketHandler.\n\n               Allocate a reserved memory pool for the DAQ list, if needed. */\n            for (i = 0; (i < xcpDynamicDaqLists.daqCount) && (createPoolError == XCP_SUCCESS); i++) {\n                if ((xcpDynamicDaqLists.daq[i].status == XCP_DAQ_SELECTED) && \n                    (xcpDynamicDaqLists.daq[i].poolId == XCP_INVALID_POOL_ID)) {\n                    if (IS_USING_CUSTOM_POOL(xcpDynamicDaqLists.daq[i].eventId)) {\n                        /* Allocate custom pool if custom memory functions are\n                           provided for this eventId */\n                        createPoolError = xcpMemCustomPoolCreate(\n                                              xcpEventCustomMemoryManager.allocHandler,\n                                              xcpEventCustomMemoryManager.freeHandler,\n                                              &xcpDynamicDaqLists.daq[i].poolId);\n                    } else if (i < XCP_MEM_DAQ_RESERVED_POOLS_NUMBER\n                        && xcpDynamicDaqLists.daq[i].eventId < XCP_MIN_EVENT_NO_RESERVED_POOL) {\n                        /* Create a reserved memory pool, if not already created */\n                        createPoolError = createDaqReservedPool(&xcpDynamicDaqLists.daq[i]);\n                        xcpDynamicDaqLists.daq[i].currentSample = 0;\n                        daqListId = (uint16_T) i;\n                    }\n                }\n            }\n\n            if (createPoolError == XCP_SUCCESS) {\n                /* If the allocation went well for all the DAQ lists, start them */\n                for (i = 0; (i < xcpDynamicDaqLists.daqCount); i++) {\n                    if (xcpDynamicDaqLists.daq[i].status == XCP_DAQ_SELECTED) {\n                        XCP_PRINTF(\"START_STOP_SYNCH: starting DAQ list %d\\n\", i);\n\n                        xcpDynamicDaqLists.daq[i].status = XCP_DAQ_STARTED;\n                        xcpStatusSet(XCP_SYNC_DATA_TRANSFER);\n                        xcpSessionStatusSetMask(XCP_SESSION_DAQ_RUNNING_MASK);\n                    }\n                }\n            }\n            break;\n\n        case XCP_DAQ_LIST_STOP_SELECTED:\n            for (i = 0; i < xcpDynamicDaqLists.daqCount; i++) {\n                if (xcpDynamicDaqLists.daq[i].status == XCP_DAQ_SELECTED) {\n                    XCP_PRINTF(\"START_STOP_SYNCH: stopping DAQ list %d\\n\", i);\n                    xcpDynamicDaqLists.daq[i].status = XCP_DAQ_STOPPED;\n                }\n            }\n\n            if (noActiveDaqLists()) {\n                /* update status if this was the only active DAQ list */\n                xcpStatusSet(XCP_CONNECTED);\n                xcpSessionStatusClearMask(XCP_SESSION_DAQ_RUNNING_MASK);\n            }\n            break;\n        }\n\n        /* Unlock all the events */\n        xcpDaqUnlock();\n\n        (void)daqListId; /* to suppress unused-but-set-variable when XCP_PRINTF is empty */\n        XCP_INPUT_PKT_ERROR_IF(createPoolError != XCP_SUCCESS, XCP_PROTO_MEMORY_OVERFLOW,\n                (\"START_STOP_SYNCH: cannot allocate reserved memory pool for the DAQ list %d\\n\", daqListId));\n\n        *outputPacketSize = XCP_GENERIC_RES_PACKET_SIZE_IN_BYTES;\n    }\n\n    /* Error if the command cannot be executed as the processing of\n       at least one event was in progress */\n    XCP_INPUT_PKT_ERROR_IF(!locked, XCP_PROTO_BUSY,\n        (\"START_STOP_SYNCH: cannot be carried out as an event was processed\\n\"));\n\n    return protoErrorCode;\n}\n\n/*****************************************************************************\n    XCP GET DAQ PROCESSOR INFO\n******************************************************************************/\nstatic XcpProtoErrorCode getDaqProcessorInfoInputPacketHandler(void   *msgBuffer,\n                                                               size_t  xcpPacketOffset,\n                                                               size_t *outputPacketSize)\n{\n    XCP_UNUSED_PARAM(msgBuffer);\n    XCP_UNUSED_PARAM(xcpPacketOffset);\n\n    XCP_PRINTF(\"GET DAQ PROCESSOR INFO\\n\");\n\n    *outputPacketSize =  XCP_GET_DAQ_PROCESSOR_INFO_RES_PACKET_SIZE_IN_BYTES;\n\n    return XCP_PROTO_SUCCESS;\n}\n\nstatic void getDaqProcessorInfoOutputPacketHandler(XcpProtoErrorCode inputCode, void *packet, size_t packetSize)\n{\n    XcpGetDaqProcessorInfoResPacketFrame *frame = (XcpGetDaqProcessorInfoResPacketFrame *)packet;\n\n    XCP_UNUSED_PARAM(inputCode);\n    XCP_UNUSED_PARAM(packetSize);\n\n    /* Fill Get Daq Processor Info response */\n    XCP_MEMSET(frame, 0, sizeof(*frame));\n\n    frame->PID = XCP_PID_RES;\n    frame->daqProperties = XCP_DAQ_PROPERTIES_VALUE;\n    frame->maxDaq = XCP_MAX_DAQ;\n    frame->maxEventChannel = XCP_MAX_EVENT_CHANNEL;\n    frame->minDaq = XCP_MIN_DAQ;\n    frame->daqKeyByte = XCP_DAQ_KEY_VALUE;\n\n    XCP_PRINTF(\"* DAQ Properties:    %xH\\n\", frame->daqProperties);\n    XCP_PRINTF(\"* MAX_DAQ:           %d\\n\", frame->maxDaq);\n    XCP_PRINTF(\"* MAX_EVENT_CHANNEL: %d\\n\", frame->maxEventChannel);\n    XCP_PRINTF(\"* MIN_DAQ:           %d\\n\", frame->minDaq);\n    XCP_PRINTF(\"* Daq Key Byte:      %xH\\n\", frame->daqKeyByte);\n}\n\n/*****************************************************************************\n    XCP GET DAQ RESOLUTION INFO\n******************************************************************************/\nstatic XcpProtoErrorCode getDaqResolutionInfoInputPacketHandler(void   *msgBuffer,\n    size_t  xcpPacketOffset,\n    size_t *outputPacketSize)\n{\n    XCP_UNUSED_PARAM(msgBuffer);\n    XCP_UNUSED_PARAM(xcpPacketOffset);\n\n    XCP_PRINTF(\"GET DAQ RESOLUTION INFO\\n\");\n\n    *outputPacketSize = XCP_GET_DAQ_RESOLUTION_INFO_RES_PACKET_SIZE_IN_BYTES;\n\n    return XCP_PROTO_SUCCESS;\n}\n\nstatic void getDaqResolutionInfoOutputPacketHandler(XcpProtoErrorCode inputCode, void *packet, size_t packetSize)\n{\n    XcpGetDaqResolutionInfoResPacketFrame *frame = (XcpGetDaqResolutionInfoResPacketFrame *)packet;\n\n    XCP_UNUSED_PARAM(inputCode);\n    XCP_UNUSED_PARAM(packetSize);\n\n    /* Fill Get Daq Resolution Info response */\n    XCP_MEMSET(frame, 0, sizeof(*frame));\n\n    frame->PID = XCP_PID_RES;\n\n    /* @note in the current version the same limits apply for DAQ and STIM */\n    frame->daqOdtEntrySizeGranularity = XCP_ODT_ENTRY_SIZE_GRANULARITY;\n    frame->maxDaqOdtEntrySize = XCP_MAX_ODT_ENTRY_SIZE;\n    frame->stimOdtEntrySizeGranularity = XCP_ODT_ENTRY_SIZE_GRANULARITY;\n    frame->maxStimOdtEntrySize = XCP_MAX_ODT_ENTRY_SIZE;\n    frame->timestampMode = XCP_TIMESTAMP_MODE_VALUE;\n    frame->timestampTicks = XCP_TIMESTAMP_TICKS;\n\n    XCP_PRINTF(\"* DAQ ODT Entry size granularity:   %d\\n\",  frame->daqOdtEntrySizeGranularity);\n    XCP_PRINTF(\"* Max DAQ ODT Entry size:           %d\\n\",  frame->maxDaqOdtEntrySize);\n    XCP_PRINTF(\"* STIM ODT Entry size granularity:  %d\\n\",  frame->stimOdtEntrySizeGranularity);\n    XCP_PRINTF(\"* Max STIM ODT Entry size:          %d\\n\",  frame->maxStimOdtEntrySize);\n    XCP_PRINTF(\"* Timestamp Mode =                  %xH\\n\", frame->timestampMode);\n    XCP_PRINTF(\"* Timestamp Ticks =                 %d\\n\",  frame->timestampTicks);\n}\n\n/*****************************************************************************\n    XCP FREE_DAQ\n******************************************************************************/\nstatic XcpProtoErrorCode freeDaqInputPacketHandler(void   *msgBuffer,\n                                                   size_t  xcpPacketOffset,\n                                                   size_t *outputPacketSize)\n{\n    XcpProtoErrorCode protoErrorCode = XCP_PROTO_SUCCESS;\n    boolean_T ok = false;\n\n    XCP_UNUSED_PARAM(msgBuffer);\n    XCP_UNUSED_PARAM(xcpPacketOffset);\n\n    XCP_PRINTF(\"FREE_DAQ: clearing existing dynamic DAQ lists\\n\");\n    ok = xcpResetDaqListStatus();\n\n    XCP_INPUT_PKT_ERROR_IF(!ok, XCP_PROTO_BUSY,\n        (\"FREE_DAQ: cannot be carried out as an event was processed\\n\"));\n\n    /* No DAQ lists are running -> XCP_SYNC_DATA_TRANSFER cannot be active anymore */\n    xcpStatusSet(XCP_CONNECTED);\n\n    /* Everything is fine -> send positive response */\n    *outputPacketSize = XCP_GENERIC_RES_PACKET_SIZE_IN_BYTES;\n\n    return protoErrorCode;\n}\n\n/*****************************************************************************\n    XCP ALLOC_DAQ\n******************************************************************************/\nstatic XcpProtoErrorCode allocDaqInputPacketHandler(void   *msgBuffer,\n                                                    size_t  xcpPacketOffset,\n                                                    size_t *outputPacketSize)\n{\n    XcpProtoErrorCode protoErrorCode = XCP_PROTO_SUCCESS;\n    uint8_T *packet = (uint8_T *)msgBuffer + xcpPacketOffset;\n    XcpAllocDaqCmdPacketFrame *frame = (XcpAllocDaqCmdPacketFrame *) packet;\n    int32_T daqCount = (uint16_T)frame->daqCount;\n    XcpDaq *daq = NULL;\n    boolean_T ok = false;\n    int i = 0;\n\n    /* Check if DAQ lists have already been allocated */\n    ok = xcpDynamicDaqLists.daq == NULL;\n    XCP_INPUT_PKT_ERROR_IF(!ok, XCP_PROTO_SEQUENCE_ERROR,\n        (\"ALLOC_DAQ: sequence error detected, DAQ lists already allocated\\n\"));\n\n    /* Check if the number of DAQ lists requested is supported */\n    ok = (daqCount > 0) && (daqCount <= (XCP_MAX_DAQ - XCP_MIN_DAQ));\n    XCP_INPUT_PKT_ERROR_IF(!ok, XCP_PROTO_OUT_OF_RANGE,\n        (\"ALLOC_DAQ: invalid number of DAQ lists (%d)\\n\", daqCount));\n\n    XCP_PRINTF(\"ALLOC_DAQ: allocating %d DAQ lists (%lu B)\\n\", daqCount, (unsigned long) ((size_t)daqCount * sizeof(XcpDaq)));\n\n    /* Proceed and allocate the DAQ lists */\n    daq = (XcpDaq *)xcpMemAlloc((size_t) daqCount * sizeof(XcpDaq));\n    XCP_INPUT_PKT_ERROR_IF(daq == NULL, XCP_PROTO_MEMORY_OVERFLOW,\n        (\"ALLOC_DAQ: not enough memory to allocate %d DAQ lists\\n\", daqCount));\n\n    XCP_MEMSET(daq, 0, (size_t)daqCount * sizeof(XcpDaq));\n\n    /* Make sure that the DAQ lists are available for use */\n    xcpDynamicDaqLists.daq = daq;\n    xcpDynamicDaqLists.daqCount = (uint16_T) daqCount;\n\n    for (i = 0; i < daqCount; i++) {\n        daq[i].poolId        = XCP_INVALID_POOL_ID;\n        daq[i].packedMode    = XCP_DAQ_DATA_NOT_PACKED;\n        daq[i].timestampMode = XCP_DAQ_SINGLE_TIMESTAMP_FIRST_SAMPLE;\n        daq[i].sampleCount   = 1;\n        daq[i].currentSample = 0;\n    }\n\n    *outputPacketSize = XCP_GENERIC_RES_PACKET_SIZE_IN_BYTES;\n\n    return protoErrorCode;\n}\n\n/*****************************************************************************\n    XCP ALLOC_ODT\n******************************************************************************/\nstatic XcpProtoErrorCode allocOdtInputPacketHandler(void   *msgBuffer,\n                                                    size_t  xcpPacketOffset,\n                                                    size_t *outputPacketSize)\n{\n    XcpProtoErrorCode protoErrorCode = XCP_PROTO_SUCCESS;\n    uint8_T *packet = (uint8_T *)msgBuffer + xcpPacketOffset;\n    XcpAllocOdtCmdPacketFrame *frame = (XcpAllocOdtCmdPacketFrame *)packet;\n    uint16_T daqListId = (uint16_T)frame->daqListId;\n    uint8_T  odtCount  = (uint8_T)frame->odtCount;\n    boolean_T ok = false;\n\n    /* Check if DAQ lists have already been allocated */\n    ok = (xcpDynamicDaqLists.daq != NULL);\n    XCP_INPUT_PKT_ERROR_IF(!ok, XCP_PROTO_SEQUENCE_ERROR,\n        (\"ALLOC_ODT: sequence error detected, DAQ lists not allocated\\n\"));\n\n    /* Check if the DAQ List Id is valid */\n    ok = (daqListId < xcpDynamicDaqLists.daqCount);\n    XCP_INPUT_PKT_ERROR_IF(!ok, XCP_PROTO_OUT_OF_RANGE,\n        (\"ALLOC_ODT: DAQ list id %d is out of range\\n\", daqListId));\n\n    /* Check if the number of ODTs is valid */\n    ok = (odtCount > 0) && (odtCount <= XCP_MAX_DAQ_ODT_NUMBER);\n    XCP_INPUT_PKT_ERROR_IF(!ok, XCP_PROTO_OUT_OF_RANGE,\n        (\"ALLOC_ODT: invalid number of ODT (%d) for DAQ list id %d\\n\", odtCount, daqListId));\n\n    /* Check if the ODTs have already been allocated */\n    ok = (xcpDynamicDaqLists.daq[daqListId].odt == NULL);\n    XCP_INPUT_PKT_ERROR_IF(!ok, XCP_PROTO_SEQUENCE_ERROR,\n        (\"ALLOC_ODT: sequence error detected, ODT already allocated\\n\"));\n\n    XCP_PRINTF(\"ALLOC_ODT: allocating %d ODTs in DAQ list %d (%lu B)\\n\",\n        odtCount, daqListId, (unsigned long)(odtCount * sizeof(XcpOdt)));\n\n    /* Everything is fine -> proceed and allocate the ODTs */\n    xcpDynamicDaqLists.daq[daqListId].odt = (XcpOdt *)xcpMemAlloc(odtCount * sizeof(XcpOdt));\n    XCP_INPUT_PKT_ERROR_IF(xcpDynamicDaqLists.daq[daqListId].odt == NULL, XCP_PROTO_MEMORY_OVERFLOW,\n        (\"ALLOC_ODT: not enough memory to allocate %d ODT in DAQ list %d\\n\", odtCount, daqListId));\n\n    XCP_MEMSET(xcpDynamicDaqLists.daq[daqListId].odt, 0, odtCount * sizeof(XcpOdt));\n\n    xcpDynamicDaqLists.daq[daqListId].odtCount = odtCount;\n\n    *outputPacketSize = XCP_GENERIC_RES_PACKET_SIZE_IN_BYTES;\n\n    return protoErrorCode;\n}\n\n/*****************************************************************************\n    XCP ALLOC_ODT_ENTRY\n******************************************************************************/\nstatic XcpProtoErrorCode allocOdtEntryInputPacketHandler(void   *msgBuffer,\n    size_t  xcpPacketOffset,\n    size_t *outputPacketSize)\n{\n    XcpProtoErrorCode protoErrorCode = XCP_PROTO_SUCCESS;\n    uint8_T *packet = (uint8_T *)msgBuffer + xcpPacketOffset;\n    XcpAllocOdtEntryCmdPacketFrame *frame = (XcpAllocOdtEntryCmdPacketFrame *)packet;\n    uint16_T daqListId       = (uint16_T)frame->daqListId;\n    uint8_T  odtId           = (uint8_T)frame->odtId;\n    uint8_T  odtEntriesCount = (uint8_T)frame->odtEntriesCount;\n    boolean_T ok = false;\n\n    /* Check if the DAQ lists have already been allocated */\n    ok = (xcpDynamicDaqLists.daq != NULL);\n    XCP_INPUT_PKT_ERROR_IF(!ok, XCP_PROTO_SEQUENCE_ERROR,\n        (\"ALLOC_ODT_ENTRY: sequence error detected, DAQ lists not allocated\\n\"));\n\n    /* Check if the DAQ List Id is valid */\n    ok = (daqListId < xcpDynamicDaqLists.daqCount);\n    XCP_INPUT_PKT_ERROR_IF(!ok, XCP_PROTO_OUT_OF_RANGE,\n        (\"ALLOC_ODT_ENTRY: DAQ list id %d is out of range\\n\", daqListId));\n\n    /* Check if the ODTs have already been allocated */\n    ok = (xcpDynamicDaqLists.daq[daqListId].odt != NULL);\n    XCP_INPUT_PKT_ERROR_IF(!ok, XCP_PROTO_SEQUENCE_ERROR,\n        (\"ALLOC_ODT_ENTRY: sequence error detected, ODTs not allocated\\n\"));\n\n    /* Check if the ODT Id is valid */\n    ok = (odtId < xcpDynamicDaqLists.daq[daqListId].odtCount);\n    XCP_INPUT_PKT_ERROR_IF(!ok, XCP_PROTO_OUT_OF_RANGE,\n        (\"ALLOC_ODT_ENTRY: ODT id %d is out of range\\n\", odtId));\n\n    /* Check if the ODT entries have already been allocated */\n    ok = (xcpDynamicDaqLists.daq[daqListId].odt[odtId].entry == NULL);\n    XCP_INPUT_PKT_ERROR_IF(!ok, XCP_PROTO_SEQUENCE_ERROR,\n        (\"ALLOC_ODT_ENTRY: sequence error detected, ODT Entries already allocated\\n\"));\n\n    /* Check if the number of ODT Entries is valid */\n    ok = (odtEntriesCount > 0);\n    XCP_INPUT_PKT_ERROR_IF(!ok, XCP_PROTO_OUT_OF_RANGE,\n        (\"ALLOC_ODT_ENTRY: invalid number of ODT entries (%d) for ODT %d in DAQ list %d\\n\", odtEntriesCount, odtId, daqListId));\n\n    XCP_PRINTF(\"ALLOC_ODT_ENTRY: allocating %d ODT Entries in DAQ list %d ODT %d (%lu B)\\n\", \n        odtEntriesCount, daqListId, odtId, (unsigned long)(odtEntriesCount * sizeof(XcpOdtEntry)));\n\n    /* Everything is fine -> proceed and allocate the ODT entries */\n    xcpDynamicDaqLists.daq[daqListId].odt[odtId].entry = (XcpOdtEntry *)xcpMemAlloc(odtEntriesCount * sizeof(XcpOdtEntry));\n\n    XCP_INPUT_PKT_ERROR_IF(xcpDynamicDaqLists.daq[daqListId].odt[odtId].entry == NULL, XCP_PROTO_MEMORY_OVERFLOW,\n        (\"ALLOC_ODT_ENTRY: not enough memory to allocate %d ODT in DAQ list %d ODT %d\\n\", odtEntriesCount, daqListId, odtId));\n\n    XCP_MEMSET(xcpDynamicDaqLists.daq[daqListId].odt[odtId].entry, 0, odtEntriesCount * sizeof(XcpOdtEntry));\n\n    xcpDynamicDaqLists.daq[daqListId].odt[odtId].entriesCount = odtEntriesCount;\n\n    *outputPacketSize = XCP_GENERIC_RES_PACKET_SIZE_IN_BYTES;\n\n    return protoErrorCode;\n}\n\n/*****************************************************************************\n    XCP GET DAQ CLOCK\n******************************************************************************/\n\nstatic XcpProtoErrorCode getDaqClockInputPacketHandler(void *msgBuffer,\n                                                       size_t xcpPacketOffset,\n                                                       size_t *outputPacketSize)\n{\n    XCP_UNUSED_PARAM(msgBuffer);\n    XCP_UNUSED_PARAM(xcpPacketOffset);\n    *outputPacketSize = XCP_ERROR_PACKET_SIZE_IN_BYTES;\n    return XCP_PROTO_RESOURCE_NOT_ACCESSIBLE;\n}\n\n/*****************************************************************************\n    XCP LEVEL1 COMMAND\n******************************************************************************/\n\n/* The only supported Level 1 command is SET DAQ PACKED MODE */\nstatic XcpProtoErrorCode setDaqPackedModeInputPacketHandler(void   *msgBuffer,\n                                                            size_t  xcpPacketOffset,\n                                                            size_t *outputPacketSize)\n{\n    XcpProtoErrorCode protoErrorCode = XCP_PROTO_SUCCESS;\n    uint8_T *packet = (uint8_T *)msgBuffer + xcpPacketOffset;\n    XcpSetDaqPackedModeCmdPacketFrame *frame = (XcpSetDaqPackedModeCmdPacketFrame *)packet;\n    uint16_T daqListId        = (uint16_T) frame->daqListId;\n    uint8_T  daqPackedMode    = (uint8_T)  frame->daqPackedMode;\n    uint8_T  dpmTimestampMode = (uint8_T)  frame->dpmTimestampMode;\n    uint16_T dpmSampleCount   = (uint16_T) frame->dpmSampleCount;\n    boolean_T ok = true;\n\n    /* Check if the DAQ lists have already been allocated */\n    ok = (xcpDynamicDaqLists.daq != NULL);\n    XCP_INPUT_PKT_ERROR_IF(!ok, XCP_PROTO_SEQUENCE_ERROR,\n        (\"SET_DAQ_PACKED_MODE: sequence error detected, DAQ lists not allocated\\n\"));\n\n    /* Check if the DAQ List Id is valid */\n    ok = (daqListId < xcpDynamicDaqLists.daqCount);\n    XCP_INPUT_PKT_ERROR_IF(!ok, XCP_PROTO_OUT_OF_RANGE,\n        (\"SET_DAQ_PACKED_MODE: DAQ list id %d is out of range\\n\", daqListId));\n\n#if XCP_MEM_DAQ_RESERVED_POOLS_NUMBER > 0\n    /* DAQ Packed Mode is only supported for DAQ lists with a reserved memory pool */\n    ok = (daqListId < XCP_MEM_DAQ_RESERVED_POOLS_NUMBER);\n    XCP_INPUT_PKT_ERROR_IF(!ok, XCP_PROTO_MODE_NOT_VALID,\n        (\"SET_DAQ_PACKED_MODE: packed mode is not supported for DAQ list id %d, with no reserved memory pool\\n\", daqListId));\n#else\n    ok = false;\n    XCP_INPUT_PKT_ERROR_IF(!ok, XCP_PROTO_MODE_NOT_VALID,\n        (\"SET_DAQ_PACKED_MODE: packed mode is not supported for DAQ list id %d, with no reserved memory pool\\n\", daqListId));\n#endif\n\n    /* Check if the selected DAQ packed mode is valid. \n       Currently we only support event-grouped data packing */\n    ok = ((daqPackedMode == XCP_DAQ_DATA_NOT_PACKED) || \n          (daqPackedMode == XCP_DAQ_EVENT_GROUPED_PACKING));\n    XCP_INPUT_PKT_ERROR_IF(!ok, XCP_PROTO_MODE_NOT_VALID,\n        (\"SET_DAQ_PACKED_MODE: DAQ Packed mode %d is not supported\\n\", daqPackedMode));\n\n    /* Check if the selected DAQ Timestamp mode is valid. \n       Currently we only support single timestamp of the first sample */\n    ok = (dpmTimestampMode == XCP_DAQ_SINGLE_TIMESTAMP_FIRST_SAMPLE);\n    XCP_INPUT_PKT_ERROR_IF(!ok, XCP_PROTO_MODE_NOT_VALID,\n        (\"SET_DAQ_PACKED_MODE: DAQ Packed timestamp mode %d is not supported\\n\", dpmTimestampMode));\n\n    /* Check if the selected DAQ Packed sample count is valid. */\n    ok = ((daqPackedMode == XCP_DAQ_DATA_NOT_PACKED && (dpmSampleCount == 1)) ||\n         ((daqPackedMode != XCP_DAQ_DATA_NOT_PACKED) && (dpmSampleCount >= XCP_DAQ_PACKED_SAMPLE_COUNT_MIN)));\n    XCP_INPUT_PKT_ERROR_IF(!ok, XCP_PROTO_MODE_NOT_VALID,\n        (\"SET_DAQ_PACKED_MODE: DAQ Packed sample count %d is not supported.\\n\", dpmSampleCount));\n\n    /* Check that the DAQ list is not already running */\n    ok = !isActiveDaqList(daqListId);\n    XCP_INPUT_PKT_ERROR_IF(!ok, XCP_PROTO_DAQ_ACTIVE,\n        (\"SET_DAQ_PACKED_MODE: packed mode configuration cannot be changed if the DAQ is running.\\n\"));\n\n    /* Finally: select the new configuration */\n    XCP_PRINTF(\"SET_DAQ_PACKED_MODE: setting packed mode %d timestamp mode %d sample count %d\\n\", \n               daqPackedMode, dpmTimestampMode, dpmSampleCount);\n\n    xcpDynamicDaqLists.daq[daqListId].packedMode    = daqPackedMode;\n    xcpDynamicDaqLists.daq[daqListId].timestampMode = dpmTimestampMode;\n    xcpDynamicDaqLists.daq[daqListId].sampleCount   = dpmSampleCount;\n    xcpDynamicDaqLists.daq[daqListId].currentSample = 0;\n\n    *outputPacketSize = XCP_GENERIC_RES_PACKET_SIZE_IN_BYTES;\n\n    return protoErrorCode;\n}\n\nstatic XcpProtoErrorCode level1CommandInputPacketHandler(void  *msgBuffer,\n                                                        size_t  xcpPacketOffset,\n                                                        size_t *outputPacketSize)\n{\n    XcpProtoErrorCode protoErrorCode = XCP_PROTO_SUCCESS;\n    XcpLevel1CommandPacketFrame* command = (XcpLevel1CommandPacketFrame*) ((uint8_T *)msgBuffer + xcpPacketOffset);\n    boolean_T ok = (command->level1Code == XCP_DAQ_LEVEL1_CODE_SET_DAQ_PACKED_MODE);\n\n    XCP_INPUT_PKT_ERROR_IF(!ok, XCP_PROTO_CMD_UNKNOWN,\n        (\"DAQ LEVEL1 COMMAND: command code %d is not supported\\n\", command->level1Code));\n\n    /* The only supported Level 1 command is SET_DAQ_PACKED_MODE */\n    protoErrorCode = setDaqPackedModeInputPacketHandler(msgBuffer, xcpPacketOffset, outputPacketSize);\n\n    return protoErrorCode;\n}\n\n\n/** This table contains the list of supported Rx packets and the corresponding handlers */\nstatic const XcpPacketHandlers daqSupportedRxPacket[] =\n{\n    { XCP_PID_START_STOP_DAQ_LIST,     startStopDaqListInputPacketHandler,     startStopDaqListOutputPacketHandler },\n    { XCP_PID_START_STOP_SYNCH,        startStopSynchInputPacketHandler,       genericOutputPacketHandler },\n    { XCP_PID_GET_DAQ_PROCESSOR_INFO,  getDaqProcessorInfoInputPacketHandler,  getDaqProcessorInfoOutputPacketHandler},\n    { XCP_PID_GET_DAQ_RESOLUTION_INFO, getDaqResolutionInfoInputPacketHandler, getDaqResolutionInfoOutputPacketHandler },\n    { XCP_PID_SET_DAQ_PTR,             setDaqPtrInputPacketHandler,            genericOutputPacketHandler },\n    { XCP_PID_WRITE_DAQ,               writeDaqInputPacketHandler,             genericOutputPacketHandler },\n    { XCP_PID_SET_DAQ_LIST_MODE,       setDaqListModeInputPacketHandler,       genericOutputPacketHandler },\n    { XCP_PID_FREE_DAQ,                freeDaqInputPacketHandler,              genericOutputPacketHandler },\n    { XCP_PID_ALLOC_DAQ,               allocDaqInputPacketHandler,             genericOutputPacketHandler },\n    { XCP_PID_ALLOC_ODT,               allocOdtInputPacketHandler,             genericOutputPacketHandler },\n    { XCP_PID_ALLOC_ODT_ENTRY,         allocOdtEntryInputPacketHandler,        genericOutputPacketHandler },\n    { XCP_PID_GET_DAQ_CLOCK,           getDaqClockInputPacketHandler,          genericOutputPacketHandler },\n    { XCP_PID_LEVEL1_COMMAND,          level1CommandInputPacketHandler,        genericOutputPacketHandler }\n};\n\n\n\n/*****************************************************************************\n    XCP Packet Lookup Function for basic DAQ commands\n******************************************************************************/\n\n/* Default DAQ Packet Lookup function, supporting only basic commands\n   listed in the table above */\nstatic const XcpPacketHandlers* getPacket(XcpRxPidCode pid)\n{\n    return xcpFindPacket(pid, daqSupportedRxPacket,\n                         XCP_ELEMENTS_NUMBER(daqSupportedRxPacket));\n}\n\nstatic XcpPacketLookupFunction packetLookup = NULL;\n\n\n\n/*****************************************************************************\n    Public Functions (invoked within the Protocol Layer)\n******************************************************************************/\nvoid xcpDaqInit(void)\n{\n#if !defined(XCP_DAQ_LIST_INDEPENDENT_EVENT_LOCK) || (XCP_DAQ_LIST_INDEPENDENT_EVENT_LOCK == 0)\n    XCP_MUTEX_INIT(daqLock);\n#else\n    uint16_T i = 0;\n\n    /* Initialize Event locks */\n    for (i = 0; i < XCP_MAX_EVENT_DATA_NUMBER; i++) {\n        XCP_MUTEX_INIT(xcpEventData[i].lock);\n    }\n#endif\n\n    xcpRunningEventCounter = 0;\n    XCP_MEMSET(&xcpDynamicDaqLists, 0, sizeof(xcpDynamicDaqLists));\n\n    /* Initialize the packet lookup function to support only basic\n       DAQ commands */\n    xcpDaqSetPacketLookup(getPacket);\n\n    /* Initialize support for the extended list of DAQ commands\n       @note this may override the default Packet lookup function\n             by adding support for more (optional) commands */\n    xcpDaqExtendedInit();\n}\n\n\nXcpPacketLookupFunction xcpDaqGetPacketLookup(void)\n{\n    return packetLookup;\n}\n\n\nvoid xcpDaqSetPacketLookup(XcpPacketLookupFunction getPacketFcn)\n{\n    packetLookup = getPacketFcn;\n}\n\n/**\n Reset a DAQ list, deleting any partial packet associated with it. This can only happen if the DAQ\n list is using packed mode.\n*/\nstatic XcpErrorCode xcpResetDaq(uint16_T daqIndex) {\n    int i = 0;\n    XcpDaq *daq = NULL;\n\n    XCP_ERROR_IF(\n        xcpDynamicDaqLists.daq == NULL || xcpDynamicDaqLists.daqCount <= daqIndex,\n        XCP_INV_ARG,\n        \"xcpProcessDaq: invalid daqIndex\");\n\n    daq = &xcpDynamicDaqLists.daq[daqIndex];\n\n    /* Resetting only needs to do something if a DAQ list is using packed mode and has started\n        writing the packet */\n    if (!isDaqPackedModeEnabled(daqIndex) || daq->currentSample == 0) {\n        return XCP_SUCCESS;\n    }\n\n    for (i = 0; i < daq->odtCount; ++i) {\n        xcpMemFree(daq->odt[i].msgBuffer);\n    }\n\n    daq->currentSample = 0;\n\n    return XCP_SUCCESS;\n}\n\n/**\n Writes xcp data needed at the beginning of an XCP packet for the given ODT. `currentValuePtr` and\n `offsetBytes` are updated accordingly.\n @note The current implementation only supports absolute ODT number.\n*/\nstatic void daqWriteXCPDataForOdt(XcpDaq* daq, uint8_T odtNumber, uint32_T timestamp) {\n    XcpOdt *odt = &daq->odt[odtNumber];\n    uint8_T *packet = odt->currentValuePtr;\n\n#ifdef XCP_EMULATE_BYTE_ADDRESSABLE_TARGET\n    odt->offsetBytes = (XCP_IN_AG(XCP_ID_FIELD_SIZE)) % XCP_HARDWARE_ADDRESS_GRANULARITY_BYTES_NUMBER;\n#else\n    /* Dummy variable used when we are not emulating as BYTE addressable target */\n    odt->offsetBytes = 0;\n#endif\n\n    /* Fill the Identification Field first\n    @note this is hard-coded to support absolute ODT number at the moment */\n    *packet = (uint8_T)(daq->firstPid + odtNumber);\n    packet = XCP_HW_PTR_INCREMENT(packet, XCP_IN_AG(XCP_ID_FIELD_SIZE), odt->offsetBytes);\n\n    /* Add the timestamp for the first DTO\n    @note this is hard-coded to support timestamp size of 4 bytes */\n    if (IS_TIMESTAMP_REQUIRED(daq->mode, odtNumber)) {\n    #ifdef XCP_EMULATE_BYTE_ADDRESSABLE_TARGET\n        size_t srcOffsetBytes = 0;\n        xcpMemcpyByte(packet, odt->offsetBytes, &timestamp, srcOffsetBytes, XCP_IN_HW_BYTES(sizeof(timestamp)));\n    #else\n        XCP_MEMCPY(packet, &timestamp, sizeof(timestamp));\n    #endif\n\n        packet = XCP_HW_PTR_INCREMENT(packet, XCP_IN_AG(XCP_TIMESTAMP_SIZE + odt->offsetBytes), odt->offsetBytes);\n        odt->offsetBytes = XCP_HW_BYTE_OFFSET_UPDATE(odt->offsetBytes, XCP_IN_AG(XCP_TIMESTAMP_SIZE));\n    }\n    odt->currentValuePtr = packet;\n}\n\n/**\n Writes the value of the entries for the given ODT, at the memory pointed by `currentValuePtr` and\n `offsetBytes`, which are updated accordingly.\n*/\nstatic void odtWriteEntries(XcpOdt *odt) {\n    uint8_T entryIndex = 0;\n    uint8_T *packet = odt->currentValuePtr;\n\n    for (entryIndex = 0; entryIndex < odt->entriesCount; ++entryIndex) {\n        XcpOdtEntry *entry = &(odt->entry[entryIndex]);\n        uint8_T const* address = XCP_ADDRESS_GET_READ(entry->addressExtension, entry->address);\n\n        if (entry->bitOffset != 0xFF) {\n            /* Bitwise access has been selected */\n        #ifdef XCP_EMULATE_BYTE_ADDRESSABLE_TARGET\n            uint32_T dword;\n            uint8_T bitValue;\n            size_t srcOffsetBytes = XCP_BYTE_OFFSET_GET(entry->address);\n            xcpMemcpyByte(&dword, 0, address, srcOffsetBytes, 4);\n            bitValue = (uint8_T) ((dword & ((uint32_T)(1 << entry->bitOffset))) != 0);\n            xcpMemcpyByte(packet, odt->offsetBytes, &bitValue, 0, entry->size);\n        #else\n            uint32_T const* dword = (uint32_T const*)address;\n            *packet = (uint8_T) ((*dword & ((uint32_T)(1 << entry->bitOffset))) != 0);\n        #endif\n        }\n        else {\n            /* 'Normal' (non-bitwise) access has been selected */\n        #ifdef XCP_EMULATE_BYTE_ADDRESSABLE_TARGET\n            size_t srcOffsetBytes = XCP_BYTE_OFFSET_GET(entry->address);\n            xcpMemcpyByte(packet, odt->offsetBytes, address, srcOffsetBytes, entry->size);\n        #else\n            XCP_MEMCPY(packet, address, entry->size);\n        #endif\n        }\n\n        packet = XCP_HW_PTR_INCREMENT(packet, entry->size + odt->offsetBytes, odt->offsetBytes);\n        odt->offsetBytes = XCP_HW_BYTE_OFFSET_UPDATE(odt->offsetBytes, entry->size);\n    }\n\n    odt->currentValuePtr = packet;\n}\n\n/**\n Process a DAQ, allocate memory, write pid and timestamp if needed, and copies variables values in\n the XCP packet.\n */\nstatic XcpErrorCode xcpProcessDaq(uint16_T daqIndex, uint32_T timestamp, XcpTransportQueueType_T txQueue) {\n    XcpErrorCode errorCode = XCP_SUCCESS;\n    boolean_T error = false;\n    XcpDaq *daq = NULL;\n    uint8_T odtIndex = 0;\n    boolean_T daqPackedModeEnabled = false;\n    boolean_T transmitRequest = false;\n\n    XCP_ERROR_IF(\n        xcpDynamicDaqLists.daq == NULL || xcpDynamicDaqLists.daqCount <= daqIndex,\n        XCP_INV_ARG,\n        \"xcpProcessDaq: invalid daqIndex\");\n\n    daq = &xcpDynamicDaqLists.daq[daqIndex];\n\n    daqPackedModeEnabled = isDaqPackedModeEnabled(daqIndex);\n    /* In packed Mode we only want to transmit when the expected number of \n        samples has been reached */\n    transmitRequest = !daqPackedModeEnabled ||\n                                ((daq->currentSample + 1) == daq->sampleCount);\n\n    /* @note prescaler is not supported at the moment */\n    for (odtIndex = 0; (odtIndex < daq->odtCount) && !error; odtIndex++) {\n        XcpOdt *odt = &daq->odt[odtIndex];\n        size_t packetOffset = xcpTransportPacketOffset();\n        size_t msgBufferSize = 0;\n\n        /* when packed mode is active the allocation occurs at the first sample */\n        boolean_T requestNewMessageBuffer = !daqPackedModeEnabled || (daq->currentSample == 0);\n\n        if (requestNewMessageBuffer) {\n            /* Calculate the required XCP packet size */\n            odt->packetSize = odtPacketSize(daq, odtIndex);\n\n            /* Calculate the overall message buffer */\n            msgBufferSize = xcpTransportMsgBufferSize(odt->packetSize, XCP_DTO);\n\n            if (daq->poolId != XCP_INVALID_POOL_ID) {\n                /* A dedicated memory pool is available */\n                odt->msgBuffer = (uint8_T *)xcpMemAllocFromPool(daq->poolId, msgBufferSize);\n            } else {\n                /* No memory pool available, use the Main memory instead */\n                odt->msgBuffer = (uint8_T *)xcpMemAlloc(msgBufferSize);\n            }\n\n            if (odt->msgBuffer != NULL) {\n                /* Allocation went well, set current pointer to the beginning of the XCP packet */\n                odt->currentValuePtr = odt->msgBuffer + packetOffset;\n\n                /* let's fill the PID and timestamp field if required */\n                daqWriteXCPDataForOdt(daq, odtIndex, timestamp);\n\n            } else {\n                /* An issue occurred during the memory allocation */\n                error = true;\n                errorCode = XCP_NO_MEMORY;\n            }\n        }\n\n        if (!error && (odt->msgBuffer != NULL)) {\n            if (!IS_USING_CUSTOM_POOL(daq->eventId)) {\n                odtWriteEntries(odt);\n            }\n\n            if (transmitRequest) {\n                /* Send the response back to the Transport Layer */\n                /* Calculate the overall message buffer */\n                msgBufferSize = xcpTransportMsgBufferSize(odt->packetSize, XCP_DTO);\n\n                errorCode = xcpTransportTxPacketSet(txQueue,\n                                                    daqIndex,\n                                                    odt->msgBuffer, msgBufferSize,\n                                                    packetOffset, odt->packetSize);\n                if (errorCode != XCP_SUCCESS) {\n                    xcpMemFree(odt->msgBuffer);\n                }\n            }\n        }\n    }\n\n    daq->currentSample = (daq->currentSample + 1) % daq->sampleCount;\n\n    return errorCode;\n}\n\nXcpErrorCode xcpDaqEvent(XcpEventIdType eventId, uint32_T timestamp, boolean_T resetSamples)\n{\n    XcpErrorCode errorCode = XCP_SUCCESS;\n\n    /* The lock is used to protect against the concurrent execution of XCP commands\n    (within xcpRun()) that can modify the DAQ list data structures */\n    xcpDaqReadLock(eventId);\n\n    if ((xcpDynamicDaqLists.daq != NULL) && (xcpDynamicDaqLists.daqCount > 0)) {\n        uint16_T i = 0;\n        XcpDaq *daq = xcpDynamicDaqLists.daq;\n\n        for (i = 0; (i < xcpDynamicDaqLists.daqCount) && errorCode == XCP_SUCCESS; i++) {\n            if (!XCP_READ_BIT_VALUE(daq[i].mode, XCP_DAQ_MODE_DIRECTION_MASK) && /* it's a DAQ list */\n                (daq[i].status == XCP_DAQ_STARTED) &&                            /* it's running */\n                (daq[i].eventId == eventId)) {                                   /* and associated to this event */\n\n                boolean_T txReady = xcpTransportTxReady(XCP_TRANSPORT_TX_DEFAULT_QUEUE, i);\n                XcpTransportQueueType_T txQueue = txReady ? XCP_TRANSPORT_TX_DEFAULT_QUEUE :\n                                                            XCP_TRANSPORT_DEFERRED_TX_QUEUE;\n\n            #ifdef XCP_LOCKLESS_SYNC_DATA_TRANSFER_SUPPORT\n                if (txReady &&\n                    (daq[i].poolId != XCP_INVALID_POOL_ID)) {\n                    /* If the Tx queue is ready, it is safe to flush the free memory,\n                        so that the deferred free blocks become available for subsequent allocations */\n                    xcpMemReservedPoolFlushFreeMem(daq[i].poolId);\n                }\n            #endif\n\n                if (resetSamples) {\n                    errorCode = xcpResetDaq(i);\n                } else {\n                    errorCode = xcpProcessDaq(i, timestamp, txQueue);\n                }\n\n                if (txReady) {\n                /* Trigger the transmission of the packets that have been enqueued\n                    for this DAQ list */\n                    xcpTransportTxTrigger(XCP_TRANSPORT_TX_DEFAULT_QUEUE, i);\n                }\n\n            }\n        }\n    }\n\n    xcpDaqReadUnlock(eventId);\n\n    return errorCode;\n}\n\nXcpErrorCode xcpDaqEventsFlush(uint32_T timestamp)\n{\n    XcpErrorCode errorCode = XCP_SUCCESS;\n\n    XCP_UNUSED_PARAM(timestamp);\n\n    if (xcpDynamicDaqLists.daq != NULL) {\n        boolean_T locked = xcpDaqLock();\n\n        if (locked) {\n            XcpDaq  *daq = xcpDynamicDaqLists.daq;\n            int32_T  daqCount = xcpDynamicDaqLists.daqCount;\n            uint16_T i = 0;\n\n            for (i = 0; i < daqCount; i++) {\n                boolean_T daqPackedModeEnabled = isDaqPackedModeEnabled(i);\n\n                if (daqPackedModeEnabled &&\n                    (daq[i].status == XCP_DAQ_STARTED) &&\n                    (daq[i].currentSample > 0)) {\n                    \n                    boolean_T txReady = xcpTransportTxReady(XCP_TRANSPORT_TX_DEFAULT_QUEUE, i);\n                    XcpTransportQueueType_T txQueue = txReady ? XCP_TRANSPORT_TX_DEFAULT_QUEUE :\n                                                            XCP_TRANSPORT_DEFERRED_TX_QUEUE;\n                    uint16_T j = 0;\n\n                    for (j = 0; j < daq[i].odtCount; j++) {\n                        if (daq[i].odt[j].msgBuffer != NULL) {\n                            size_t msgBufferSize = xcpTransportMsgBufferSize(daq[i].odt[j].packetSize, XCP_DTO);\n                            size_t packetOffset = xcpTransportPacketOffset();\n                            uint8_T *packet = daq[i].odt[j].msgBuffer + packetOffset;\n                            size_t notInitializedDataSize = XCP_IN_HW_AG(daq[i].odt[j].packetSize) - \n                                                             ((size_t) (daq[i].odt[j].currentValuePtr - packet));\n\n                            XCP_MEMSET(daq[i].odt[j].currentValuePtr, 0, notInitializedDataSize);\n\n                            errorCode = xcpTransportTxPacketSet(txQueue,\n                                                                i,\n                                                                daq[i].odt[j].msgBuffer, msgBufferSize,\n                                                                packetOffset, daq[i].odt[j].packetSize);\n                            if (errorCode != XCP_SUCCESS) {\n                                xcpMemFree(daq[i].odt[j].msgBuffer);\n                            }\n\n                        }\n                    }\n\n                    daq[i].currentSample = 0;\n                }\n            }\n\n            xcpDaqUnlock();\n        } else {\n            errorCode = XCP_BUSY;\n        }\n    }\n\n    return errorCode;\n}\n\n\n\nboolean_T xcpDaqLock(void)\n{\n    boolean_T locked = true;\n#if !defined(XCP_DAQ_LIST_INDEPENDENT_EVENT_LOCK) || (XCP_DAQ_LIST_INDEPENDENT_EVENT_LOCK == 0)\n    locked = xcpDaqWriteLock(0);\n#else\n    XcpEventIdType i = 0;\n\n    for(i = 0; i < XCP_MAX_EVENT_DATA_NUMBER; i++) {\n        xcpDaqWriteLock(i);\n    }\n#endif\n    return locked;\n}\n\n\n/* Unlock DAQ list transmission */\nvoid xcpDaqUnlock(void)\n{\n#if !defined(XCP_DAQ_LIST_INDEPENDENT_EVENT_LOCK) || (XCP_DAQ_LIST_INDEPENDENT_EVENT_LOCK == 0)\n    xcpDaqWriteUnlock(0);\n#else\n    XcpEventIdType i = 0;\n\n    for(i = 0; i < XCP_MAX_EVENT_DATA_NUMBER; i++) {\n        /* Unlock in reverse order, to prevent deadlock */\n    \txcpDaqWriteUnlock(XCP_MAX_EVENT_DATA_NUMBER - 1 - i);\n    }\n#endif\n}\n\n\nboolean_T xcpResetDaqListStatus(void)\n{\n    boolean_T locked = true;\n\n    if (xcpDynamicDaqLists.daq != NULL) {\n        XcpDaq *daq = xcpDynamicDaqLists.daq;\n        int32_T  daqCount = xcpDynamicDaqLists.daqCount;\n\n        locked = xcpDaqLock();\n\n        if (locked) {\n            /* No events were processed, it's safe to remove the DAQ lists */\n            int32_T i = 0;\n            int32_T j = 0;\n\n            /* No events are currently running,\n               it's safe to remove the DAQ lists */\n            xcpDynamicDaqLists.daq = NULL;\n            xcpDynamicDaqLists.daqCount = 0;\n            xcpDynamicDaqLists.firstAvailableDaqPid = 0;\n            xcpDynamicDaqLists.firstAvailableStimPid = 0;\n            \n            /* Reset ID of the DAQ List selected by START_STOP_DAQ_LIST command */\n            startStopDaqListId = XCP_INVALID_DAQ_LIST_ID;\n\n            /* Let's release the locks */\n            xcpDaqUnlock();\n\n            /* Prepare the Transport Layer for subsequent connections\n               (by resetting the Frame Handler counters and deleting the\n               existing packets in TX/RX fifos) */\n            xcpTransportRestart();\n\n            /* Delete all the Dynamic DAQ data structures and\n               reserved  memory pools */\n            for (i = 0; i < daqCount; i++) {\n                if (IS_USING_CUSTOM_POOL(daq[i].eventId)) {\n                    xcpMemCustomPoolDestroy(daq[i].poolId);\n                } else if (i < XCP_MEM_DAQ_RESERVED_POOLS_NUMBER\n                 && daq[i].eventId < XCP_MIN_EVENT_NO_RESERVED_POOL) {\n                    destroyDaqReservedPool(&daq[i]);\n                }\n\n                if (daq[i].odt != NULL) {\n                    for (j = 0; j < daq[i].odtCount; j++) {\n                        if (daq[i].odt[j].entry != NULL) {\n                            xcpMemFree(daq[i].odt[j].entry);\n                        }\n                    }\n\n                    xcpMemFree(daq[i].odt);\n                }\n            }\n\n            xcpMemFree(daq);\n\n            xcpSessionStatusClearMask(XCP_SESSION_DAQ_RUNNING_MASK);\n        }\n    }\n\n    return locked;\n}\n\n\nvoid xcpDaqReset(void)\n{\n    xcpResetDaqListStatus();\n\n    /* reset support for the extended list of DAQ commands */\n    xcpDaqExtendedReset();\n\n    /* Restore the original value for the lookup function */\n    xcpDaqSetPacketLookup(NULL);\n\n#if !defined(XCP_DAQ_LIST_INDEPENDENT_EVENT_LOCK) || (XCP_DAQ_LIST_INDEPENDENT_EVENT_LOCK == 0)\n    XCP_MUTEX_INIT(daqLock);\n#else\n    {\n        uint16_T i = 0;\n\n        for (i = 0; i < XCP_MAX_EVENT_DATA_NUMBER; i++) {\n            XCP_MUTEX_INIT(xcpEventData[i].lock);\n        }\n    }\n#endif\n}\n\n\nXcpErrorCode xcpDaqSetCustomPoolMemoryManager(XcpEventIdType eventId, \n                                              XcpCustomAllocHandler allocHandler, \n                                              XcpCustomFreeHandler freeHandler)\n{\n    if (allocHandler == NULL || freeHandler == NULL) {\n        return XCP_INV_ARG;\n    }\n\n    xcpEventCustomMemoryManager.eventId = eventId;\n    xcpEventCustomMemoryManager.allocHandler = allocHandler;\n    xcpEventCustomMemoryManager.freeHandler = freeHandler;\n\n    return XCP_SUCCESS;\n}\n\n\nXcpErrorCode xcpDaqGetCustomPoolMemoryManager(XcpEventIdType *eventId,\n                                              XcpCustomAllocHandler *allocHandler,\n                                              XcpCustomFreeHandler *freeHandler)\n{\n    if (xcpEventCustomMemoryManager.eventId == XCP_DAQ_CUSTOM_MEMORY_INVALID_EVENT_ID) {\n        return XCP_NOT_INITIALIZED;\n    }\n    if (allocHandler == NULL || freeHandler == NULL) {\n        return XCP_INV_ARG;\n    }\n\n    *eventId = xcpEventCustomMemoryManager.eventId;\n    *allocHandler = xcpEventCustomMemoryManager.allocHandler;\n    *freeHandler = xcpEventCustomMemoryManager.freeHandler;\n\n    return XCP_SUCCESS;\n}\n\n\n#ifdef XCP_INTERNAL_DAQ_CONFIG_ACCESS_SUPPORT\n\nXcpErrorCode xcpDaqGetOdtEntries(XcpEventIdType eventId, \n                                 XcpDaqDirection direction, \n                                 XcpOdtEntry* entries,\n                                 size_t* entriesNumber,\n                                 size_t maxEntriesNumber)\n{\n    XcpErrorCode errorCode = XCP_SUCCESS;\n    XcpOdtEntry* currentEntry = entries;\n    size_t entriesCount = 0;\n    boolean_T memOverflow = false;\n\n    XCP_ERROR_IF(eventId >= XCP_MAX_EVENT_CHANNEL, XCP_INV_ARG, \"xcpDaqGetOdtEntries: invalid eventId\\n\");\n    XCP_ERROR_IF(direction != XCP_DIRECTION_DAQ, XCP_NOT_SUPPORTED, \"xcpDaqGetOdtEntries: direction not supported\\n\");\n    XCP_ERROR_IF(entries == NULL, XCP_INV_ARG, \"xcpDaqGetOdtEntries: invalid entries\\n\");\n    XCP_ERROR_IF(entriesNumber == NULL, XCP_INV_ARG, \"xcpDaqGetOdtEntries: invalid entriesNumber\\n\");\n    XCP_ERROR_IF(maxEntriesNumber == 0, XCP_INV_ARG, \"xcpDaqGetOdtEntries: invalid maxEntriesNumber\\n\");\n\n    /* Extract the ODT entries by navigating the whole DAQ List hierarchy */\n    if (xcpDynamicDaqLists.daq != NULL) {\n        uint16_T daqId = 0;\n        for (daqId = 0; (daqId < xcpDynamicDaqLists.daqCount) && !memOverflow; daqId++) {\n            XcpDaq *daq = &xcpDynamicDaqLists.daq[daqId];\n\n            if ((daq->eventId == eventId) &&\n                ((direction == XCP_DIRECTION_DAQ) &&\n                 !XCP_READ_BIT_VALUE(daq[daqId].mode, XCP_DAQ_MODE_DIRECTION_MASK)) &&\n                 isActiveDaqList(daqId)) {\n                /* only active DAQ lists are considered */\n                if (daq->odt != NULL) {\n                    uint8_T odtId = 0;\n\n                    for (odtId = 0; (odtId < daq->odtCount) && !memOverflow; odtId++) {\n                        XcpOdt *odt = &daq->odt[odtId];\n  \n                        if (odt->entry != NULL) {\n                            uint8_T entryId = 0;\n\n                            for (entryId = 0; (entryId < odt->entriesCount) && !memOverflow; entryId++) {\n                                XcpOdtEntry *odtEntry = &odt->entry[entryId];\n                                \n                                if (entriesCount < maxEntriesNumber) {\n                                    XCP_MEMCPY(currentEntry, odtEntry, sizeof(XcpOdtEntry));\n                                    currentEntry++;\n                                    entriesCount++;\n                                } else {\n                                    memOverflow = true;\n                                }\n                            }\n                        }\n                    }\n                }\n            }\n        }\n    }\n    \n    /* update number of entries copied and error code */\n    *entriesNumber = entriesCount;\n    if (memOverflow) {\n        errorCode = XCP_NO_MEMORY;\n    }\n\n    return errorCode;\n}\n\n#endif /* XCP_INTERNAL_DAQ_CONFIG_ACCESS_SUPPORT */\n\n\n#ifndef XCP_DAQ_EXTENDED_SUPPORT\n\nvoid xcpDaqExtendedInit(void) {}\nvoid xcpDaqExtendedReset(void) {}\n\n#endif\n\n#endif\n"},{"name":"xcp_drv_rtiostream.c","type":"source","group":"legacy","path":"C:\\Users\\Sophie\\Documents\\Hochschule\\Master\\Systeme und Programme\\toolbox\\coder\\xcp\\src\\target\\server\\platform\\default","tag":"","groupDisplay":"Other files","code":"/*\n* Copyright 2016-2023 The MathWorks, Inc.\n*\n* File: xcp_drv_rtiostream.c\n*\n* Abstract:\n*  Implementation of XCP driver based on rtIOStream\n*/\n\n#include \"rtiostream.h\"\n#include \"xcp_common.h\"\n#include \"xcp.h\"\n#include \"xcp_drv.h\"\n\n#define INVALID_DRV_ID  -1\n\n/* Timeout expected for the reception of a packet, once the reception has started */\nstatic const uint32_T XCP_RECEIVE_PACKET_TIMEOUT_IN_MICROSECONDS  = 1000000L;  /* 1s */\n\n/* Delay before attempting the reception of new data */\nstatic const uint32_T XCP_RECEIVE_RETRY_TIME_IN_MICROSECONDS = 10L;  /* 10us */\n\n/* Timeout expected for the transmission of a packet, once the transmission has started */\nstatic const uint32_T XCP_SEND_PACKET_TIMEOUT_IN_MICROSECONDS = 2000000L;   /* 2s */\n\n/* Delay before attempting the transmission of new data */\nstatic const uint32_T XCP_SEND_RETRY_TIME_IN_MICROSECONDS = 10L;  /* 10us */\n\n\n/* According to the XCP standard, the XCP server only supports the connection\n   with one XCP Client at a time. The active connection is identified by\n   a specific drvID */\nstatic int drvID = INVALID_DRV_ID;\n\n\n/* If set to true, force the xcpDrvSend and xcpDrvRecv APIs to be blocking */\nstatic boolean_T  forceBlocking = false;\n\n\nXcpErrorCode xcpDrvOpen(\n    int   argc,\n    void *argv[]\n    )\n{\n    XcpErrorCode errorCode = XCP_SUCCESS;\n\n    if (drvID != INVALID_DRV_ID) {\n        XCP_PRINTF(\"xcpDrvOpen: XCP driver already initialized\\n\");\n        return XCP_ERROR;\n    }\n\n    /* Open the actual communication channel */\n    drvID = rtIOStreamOpen(argc, argv);\n    if (drvID < 0) {\n        XCP_PRINTF(\"xcpDrvOpen: unable to open communication channel\\n\");\n        drvID = INVALID_DRV_ID;\n        errorCode = XCP_ERROR;\n    }\n\n    return errorCode;\n}\n\n\nXcpErrorCode xcpDrvIoctl(XcpDrvIoctlCommand cmd)\n{\n    XcpErrorCode errorCode = XCP_SUCCESS;\n\n    XCP_ERROR_IF((cmd != XCP_DRV_RESTORE_DEFAULT_BLOCKING_SETUP) &&\n                 (cmd != XCP_DRV_FORCE_BLOCKING), XCP_INV_ARG,\n                 \"xcpDrvIoctl: invalid command\\n\");\n\n    forceBlocking = (cmd == XCP_DRV_FORCE_BLOCKING);\n\n    return errorCode;\n}\n\n\nXcpErrorCode xcpDrvSend(const void *src, size_t size)\n{\n    int ret = RTIOSTREAM_NO_ERROR;\n    XcpErrorCode errorCode = XCP_SUCCESS;\n    size_t   sent = 0;\n    size_t sentBytesCounter = 0;\n    uint32_T elapsedTime = 0;\n    const uint8_T *dataPtr = NULL;\n    boolean_T done = false;\n\n    XCP_ERROR_IF(src == NULL, XCP_INV_ARG, \"xcpDrvSend: invalid src buffer\\n\");\n    XCP_ERROR_IF(size == 0, XCP_INV_ARG, \"xcpDrvSend: invalid size\\n\");\n    XCP_ERROR_IF(drvID == INVALID_DRV_ID, XCP_NOT_INITIALIZED, \"xcpDrvSend: XCP driver not initialized\\n\");\n\n    while (!done) {\n        dataPtr = (const uint8_T *)src + sentBytesCounter;\n        ret = rtIOStreamSend(drvID, dataPtr, (size - sentBytesCounter), &sent);\n\n        if (ret == RTIOSTREAM_NO_ERROR) {\n            if ((sent == 0) && (sentBytesCounter == 0) && !forceBlocking) {\n                /* This will only happen if the rtIOStreamSend function\n                   is non-blocking and we haven't started sending data yet */\n                errorCode = XCP_BUSY;\n            } else {\n                /* Send packet in progress, we need to complete it */\n                sentBytesCounter += sent;\n\n                done = (sentBytesCounter >= size) ;\n\n                if (!done) {\n                    if (elapsedTime >= XCP_SEND_PACKET_TIMEOUT_IN_MICROSECONDS) {\n                        errorCode = XCP_PKT_TX_TIMEOUT_ERROR;\n                    } else {\n                        XCP_SLEEP(0, XCP_SEND_RETRY_TIME_IN_MICROSECONDS);\n                        elapsedTime += XCP_SEND_RETRY_TIME_IN_MICROSECONDS;\n                    }\n                }\n            }\n        } else {\n            errorCode = XCP_ERROR;\n        }\n\n        done = done || (errorCode == XCP_BUSY) || (errorCode == XCP_ERROR) ||\n               (errorCode == XCP_PKT_TX_TIMEOUT_ERROR);\n    }\n\n    return errorCode;\n}\n\n\nXcpErrorCode xcpDrvRecv(void *dst, size_t size)\n{\n    int ret = RTIOSTREAM_NO_ERROR;\n    XcpErrorCode errorCode = XCP_SUCCESS;\n    size_t receivedBytesCounter = 0;\n    size_t received = 0;\n    uint32_T elapsedTime = 0;\n    uint8_T *dataPtr = NULL;\n    boolean_T done = false;\n\n    XCP_ERROR_IF(dst == NULL, XCP_INV_ARG, \"xcpDrvRecv: invalid src buffer\\n\");\n    XCP_ERROR_IF(size == 0, XCP_INV_ARG, \"xcpDrvRecv: invalid size\\n\");\n    XCP_ERROR_IF(drvID == INVALID_DRV_ID, XCP_NOT_INITIALIZED, \"xcpDrvRecv: XCP driver not initialized\\n\");\n\n    while (!done) {\n        dataPtr = (uint8_T *)dst + receivedBytesCounter;\n\n        ret = rtIOStreamRecv(drvID, dataPtr, (size - receivedBytesCounter), &received);\n        if (ret == RTIOSTREAM_NO_ERROR) {\n            if ((received == 0) && (receivedBytesCounter == 0) && !forceBlocking) {\n                /* This will only happen if the rtIOStreamRecv function\n                   is non-blocking and we haven't started receiving data yet */\n                errorCode = XCP_EMPTY;\n            } else {\n                /* Receive packet in progress, we need to complete it */\n                receivedBytesCounter += received;\n                done = (receivedBytesCounter >= size);\n\n                if (!done) {\n                    if (elapsedTime >= XCP_RECEIVE_PACKET_TIMEOUT_IN_MICROSECONDS) {\n                        errorCode = XCP_PKT_RX_TIMEOUT_ERROR;\n                    } else {\n                        XCP_SLEEP(0, XCP_RECEIVE_RETRY_TIME_IN_MICROSECONDS);\n                        elapsedTime += XCP_RECEIVE_RETRY_TIME_IN_MICROSECONDS;\n                    }\n                }\n            }\n        }\n        else {\n            errorCode = XCP_ERROR;\n        }\n        \n        done = done || (errorCode == XCP_EMPTY) || (errorCode == XCP_ERROR) ||\n               (errorCode ==  XCP_PKT_RX_TIMEOUT_ERROR);\n    }\n\n    return errorCode;\n}\n\n\nXcpErrorCode xcpDrvRecvUnknownSize(void *dst, size_t *size, size_t maxSize)\n{\n    int ret = RTIOSTREAM_NO_ERROR;\n    XcpErrorCode errorCode = XCP_SUCCESS;\n    size_t receivedBytes = 0;\n    uint8_T *dataPtr = NULL;\n\n    XCP_ERROR_IF(dst == NULL, XCP_INV_ARG, \"xcpDrvRecvUnknownSize: invalid dst buffer\\n\");\n    XCP_ERROR_IF(size == NULL, XCP_INV_ARG, \"xcpDrvRecvUnknownSize: invalid size pointer\\n\");\n    XCP_ERROR_IF(maxSize == 0, XCP_INV_ARG, \"xcpDrvRecvUnknownSize: invalid maxSize\\n\");\n    XCP_ERROR_IF(drvID == INVALID_DRV_ID, XCP_NOT_INITIALIZED, \"xcpDrvRecvUnknownSize: XCP driver not initialized\\n\");\n\n    dataPtr = (uint8_T *)dst;\n\n    ret = rtIOStreamRecv(drvID, dataPtr, maxSize, &receivedBytes);\n    if (ret == RTIOSTREAM_NO_ERROR) {\n        if (receivedBytes == 0) {\n            /* This will only happen if we haven't yet started receiving data */\n            errorCode = XCP_EMPTY;\n        }\n        else if (receivedBytes <= maxSize) {\n            /* Packet received. Hence, update the actual size */\n            *size = receivedBytes;\n            errorCode = XCP_SUCCESS;\n        }\n        else {\n            errorCode = XCP_ERROR;\n        }\n    }\n    else {\n        errorCode = XCP_ERROR;\n    }\n\n    return errorCode;\n}\n\n\nXcpErrorCode xcpDrvClose(void)\n{\n    int ret = RTIOSTREAM_NO_ERROR;\n    XcpErrorCode errorCode = XCP_SUCCESS;\n\n    if (drvID == INVALID_DRV_ID) {\n        XCP_PRINTF(\"xcpDrvClose: XCP driver already closed\\n\");\n        return XCP_SUCCESS; /* Nothing to do: just printing out a warning message*/\n    }\n\n    ret = rtIOStreamClose(drvID);\n\n    if (ret == RTIOSTREAM_NO_ERROR) {\n        drvID = INVALID_DRV_ID;\n        errorCode = XCP_SUCCESS;\n    }\n    else {\n        errorCode = XCP_ERROR;\n    }\n\n    return errorCode;\n}\n\n"},{"name":"xcp_ext_classic_trigger.c","type":"source","group":"legacy","path":"C:\\Users\\Sophie\\Documents\\Hochschule\\Master\\Systeme und Programme\\toolbox\\coder\\xcp\\src\\target\\ext_mode\\src","tag":"","groupDisplay":"Other files","code":"/*\n * Copyright 2020-2023 The MathWorks, Inc.\n *\n * File: xcp_ext_classic_trigger.c\n *\n * Abstract:\n *  This file contains the implementation of the External Mode\n *  \"Classic Trigger\" logic.\n *\n */\n\n#include \"xcp_ext_classic_trigger.h\"\n#include \"xcp_ext_common.h\"\n\n#define EXTMODE_TRIG_BASE_RATE_EVENT_ID EXTMODE_BASE_RATE_EVENT_ID\n\n#define DEFAULT_XCP_CLASSIC_TRIGGER_DURATION 1000\n\n\n/* Global variables directly accessible by the XCP Client */\nextmodeEventId_T volatile xcpClassicTriggerEventId = 0;\n\nuint32_T volatile xcpClassicTriggerSignalAddress = 0;\nuint8_T volatile  xcpClassicTriggerSignalAddressExtension = 0;\n\nextmodeClassicTriggerSignal_T volatile xcpClassicTriggerLevel = 0;\n\nuint32_T volatile xcpClassicTriggerDuration = DEFAULT_XCP_CLASSIC_TRIGGER_DURATION;\nuint32_T volatile xcpClassicTriggerHoldOff  = 0;\nint32_T  volatile xcpClassicTriggerDelay    = 0;\n\nXcpClassicTriggerDirection volatile xcpClassicTriggerDirection = XCP_EXTMODE_TRIGGER_RISING;\n\n#if defined(EXTMODE_TRIG_ARMED_ON_START) && EXTMODE_TRIG_ARMED_ON_START == 0\nboolean_T volatile xcpClassicTriggerArmRequest = false;\n#else\n/* Classic Trigger is armed by default */\nboolean_T volatile xcpClassicTriggerArmRequest = true;\n#endif\n\nboolean_T volatile xcpClassicTriggerCancelRequest = false;\n\nXcpClassicTriggerSource volatile xcpClassicTriggerSource = XCP_EXTMODE_TRIGGER_MANUAL;\n\nXcpClassicTriggerMode volatile xcpClassicTriggerMode = XCP_EXTMODE_TRIGGER_NORMAL;\n\nXcpClassicTriggerStatus volatile xcpClassicTriggerStatus = XCP_EXTMODE_TRIGGER_UNARMED;\n\n\nXCP_STATIC extmodeClassicTriggerSignal_T xcpOldSignalValue = 0;\nXCP_STATIC boolean_T                     xcpOldSignalValueAvailable = false;\n\nXCP_STATIC XcpClassicTriggerSource       xcpOldClassicTriggerSource = XCP_EXTMODE_TRIGGER_MANUAL;\n\nXCP_STATIC boolean_T                     xcpTriggerEnabled = false;\nXCP_STATIC boolean_T                     xcpSignalTriggerFired = false;\nXCP_STATIC uint32_T                      xcpTriggerCount = 0;\n\nXCP_STATIC boolean_T                     xcpForcedTriggerEnabled = false;\nXCP_STATIC boolean_T                     xcpForceTriggerEnableRequest = false;\n\n/** The function is responsible for sampling the signal trigger value\n    and setting the xcpSignalTriggerFired boolean to true if\n    the trigger signal has the expected transition across the xcpClassicTriggerLevel.\n    The boolean will always be restored back to false by the base rate\n    when the event is acknowledged and the state transition completed.\n    The function is also setting xcpTriggerEnabled to true if no Delay is required. */\nstatic void sampleSignalTrigger(void)\n{\n    extmodeClassicTriggerSignal_T const* signal = (extmodeClassicTriggerSignal_T const*)\n                                            XCP_ADDRESS_GET_READ(xcpClassicTriggerSignalAddressExtension,\n                                                            xcpClassicTriggerSignalAddress);\n    if ((signal != NULL) &&\n       ((xcpClassicTriggerSignalAddressExtension != 0) ||\n        (xcpClassicTriggerSignalAddress != 0))) {\n        if ((xcpClassicTriggerStatus ==\tXCP_EXTMODE_TRIGGER_ARMED) &&\n            !xcpSignalTriggerFired) {\n            /* Read the new signal value */\n            extmodeClassicTriggerSignal_T signalValue = *signal;\n\n            if (xcpOldSignalValueAvailable) {\n                /* If the trigger is armed and not already fired,\n                   check for the expected transition */\n                boolean_T checkForRising =  (xcpClassicTriggerDirection == XCP_EXTMODE_TRIGGER_RISING) ||\n                                            (xcpClassicTriggerDirection == XCP_EXTMODE_TRIGGER_RISING_OR_FALLING);\n\n                boolean_T checkForFalling = (xcpClassicTriggerDirection == XCP_EXTMODE_TRIGGER_FALLING) ||\n                                            (xcpClassicTriggerDirection == XCP_EXTMODE_TRIGGER_RISING_OR_FALLING);\n\n                if (checkForRising &&\n                   (((signalValue >= xcpClassicTriggerLevel) && (xcpOldSignalValue <  xcpClassicTriggerLevel)) ||\n                    ((signalValue >  xcpClassicTriggerLevel) && (xcpOldSignalValue == xcpClassicTriggerLevel)))) {\n\n                    if (xcpClassicTriggerDelay == 0) {\n                        /* fire the event immediately if needed no Delay is required */\n                        xcpTriggerEnabled = true;\n                    }\n                    xcpSignalTriggerFired   = true; /* the transition from ARMED to FIRING is updated in base rate */\n                }\n                if (checkForFalling &&\n                   (((signalValue < xcpClassicTriggerLevel)  && (xcpOldSignalValue >= xcpClassicTriggerLevel)) ||\n                    ((signalValue == xcpClassicTriggerLevel) && (xcpOldSignalValue >  xcpClassicTriggerLevel)))) {\n\n                    if (xcpClassicTriggerDelay == 0) {\n                        /* fire the event immediately if needed no Delay is required */\n                        xcpTriggerEnabled = true;\n                    }\n                    xcpSignalTriggerFired   = true; /* the transition from ARMED to FIRING is updated in base rate */\n                }\n            }\n\n            /* Update the old signal value. Note: if we just fired, the sampling will start\n               next time the trigger is armed and therefore we reset xcpOldSignalValueAvailable */\n            xcpOldSignalValueAvailable = !xcpSignalTriggerFired;\n            xcpOldSignalValue = signalValue;\n        }\n    }\n}\n\n\n/** The function is executed in the base rate and it is responsible\n    for the handling of the triggering status transitions */\nstatic void updateTriggerStatus(void)\n{\n    /* Process user Arm/Cancel requests common to all states\n       and update the triggerFired variable (depending on the\n       active triggering source) */\n    boolean_T triggerFired = false;\n\n    if (xcpClassicTriggerStatus == XCP_EXTMODE_TRIGGER_UNARMED) {\n        /* This case deserves a separate handling\n           because we would like the transition to the ARMED status\n           to occur in the same cycle.\n           Since we are already UNARMED, any request to cancel \n           the trigger can be ignored */\n        xcpClassicTriggerCancelRequest = false;\n        xcpSignalTriggerFired = false;\n\n        if (xcpClassicTriggerArmRequest) {\n            /* Process arm request */\n            xcpClassicTriggerStatus = XCP_EXTMODE_TRIGGER_ARMED;\n            xcpClassicTriggerArmRequest = false;\n\n            /* If we are using MANUAL trigger, we want to start \n               firing the trigger event straightaway, e.g.\n               when the user selects ExtModeArmWhenConnect */\n            if (xcpClassicTriggerSource == XCP_EXTMODE_TRIGGER_MANUAL) {\n                triggerFired = true;\n            }\n        }\n    } else {\n        /* We are already armed, ignore any request to arm the trigger */\n        xcpClassicTriggerArmRequest = false;\n\n        if (xcpClassicTriggerCancelRequest) {\n            /* No matter what the Status is, a cancel request should\n               always bring the status to UNARMED.\n               We implement the transition here, to avoid code\n               duplication in the states. */\n            xcpTriggerEnabled = false;\n            xcpClassicTriggerStatus = XCP_EXTMODE_TRIGGER_UNARMED;\n            xcpClassicTriggerCancelRequest = false;\n        } else {\n            if (xcpClassicTriggerSource == XCP_EXTMODE_TRIGGER_MANUAL) {\n                /* when manual triggering is selected, we assume that\n                   the trigger event has always been fired when armed */\n                triggerFired = true;\n            } else {\n                /* when signal triggering is selected, we check the status\n                   of the xcpSignalTriggerFired (updated by the\n                   sampleSignalTrigger() logic */\n                triggerFired = xcpSignalTriggerFired;\n                xcpSignalTriggerFired = false;\n            }\n        }\n    }\n\n    /* Handle the remaining state transitions */\n    switch (xcpClassicTriggerStatus) {\n    case XCP_EXTMODE_TRIGGER_UNARMED:\n        if (xcpClassicTriggerArmRequest) {\n            /* Process arm request */\n            xcpClassicTriggerStatus = XCP_EXTMODE_TRIGGER_ARMED;\n            xcpClassicTriggerArmRequest = false;\n        }\n        break;\n\n    case XCP_EXTMODE_TRIGGER_ARMED:\n        if (triggerFired) {\n            if ((xcpClassicTriggerDelay > 0) &&\n                (xcpClassicTriggerSource == XCP_EXTMODE_TRIGGER_SIGNAL)) {\n                /* We need to postpone the enabling of the trigger\n                   by xcpClassicTriggerDelay base periods */\n                xcpTriggerCount = (uint32_T) xcpClassicTriggerDelay;\n                xcpClassicTriggerStatus = XCP_EXTMODE_TRIGGER_DELAYED;\n            } else {\n                /* Negative xcpClassicTriggerDelay are ignored.\n                   The parameter is also ignored if the xcpClassicTriggerSource\n                   is XCP_EXTMODE_TRIGGER_MANUAL\n                   If xcpClassicTriggerDelay is 0 we enable the trigger straight away */\n                if (xcpClassicTriggerDuration > 0) {\n                    xcpTriggerEnabled = true;\n                    xcpTriggerCount = xcpClassicTriggerDuration;\n                    xcpClassicTriggerStatus = XCP_EXTMODE_TRIGGER_FIRING;\n                } else {\n                    /* If duration is 0, we would never be able to send any data.\n                       This situation should be prevented on the host,\n                       we just handle it gracefully here, in case it happens */\n                    XCP_PRINTF(\"Invalid duration value (0) detected.\\n\");\n                    xcpTriggerEnabled = false;\n                    xcpClassicTriggerStatus = XCP_EXTMODE_TRIGGER_UNARMED;\n                }\n            }\n        }\n        break;\n\n    case XCP_EXTMODE_TRIGGER_FIRING:\n        /* Update the base rate counter */\n        if (xcpTriggerCount > 0) {\n            xcpTriggerCount--;\n        }\n\n        if (xcpTriggerCount == 0) {\n            /* Duration has expired */\n            if (xcpClassicTriggerMode == XCP_EXTMODE_TRIGGER_ONESHOT) {\n                /* In the one-shot scenario we just disable the trigger */\n                xcpTriggerEnabled = false;\n                xcpClassicTriggerStatus  = XCP_EXTMODE_TRIGGER_UNARMED;\n            } else {\n                /* In normal mode, we might have to handle the HoldOff and\n                   pause the triggering  */\n                if (xcpClassicTriggerHoldOff > 0) {\n                    xcpTriggerEnabled = false;\n                    xcpTriggerCount = xcpClassicTriggerHoldOff;\n                    xcpClassicTriggerStatus = XCP_EXTMODE_TRIGGER_HOLDING_OFF;\n                } else {\n                    if (triggerFired) {\n                        /* If the trigger has been fired, we start another duration\n                           straight away */\n                        xcpTriggerCount = xcpClassicTriggerDuration;\n                        xcpClassicTriggerStatus = XCP_EXTMODE_TRIGGER_FIRING;\n                    } else {\n                        /* We wait for the next trigger to be fired */\n                        xcpTriggerEnabled = false;\n                        xcpClassicTriggerStatus = XCP_EXTMODE_TRIGGER_ARMED;\n                    }\n                }\n            }\n        }\n        break;\n\n    case XCP_EXTMODE_TRIGGER_DELAYED:\n        /* Update the base rate counter */\n        if (xcpTriggerCount > 0) {\n            xcpTriggerCount--;\n        }\n\n        if (xcpTriggerCount == 0) {\n            /* Delay is over, we can enable the trigger now */\n            if (xcpClassicTriggerDuration > 0) {\n                xcpTriggerEnabled = true;\n                xcpTriggerCount = xcpClassicTriggerDuration;\n                xcpClassicTriggerStatus = XCP_EXTMODE_TRIGGER_FIRING;\n            } else {\n                /* If duration is 0, we would never be able to send any data.\n                   This situation should be prevented on the host,\n                   we just handle it gracefully here, in case it happens */\n                XCP_PRINTF(\"Invalid duration value (0) detected.\\n\");\n                xcpTriggerEnabled = false;\n                xcpClassicTriggerStatus = XCP_EXTMODE_TRIGGER_UNARMED;\n            }\n        }\n        break;\n\n    case XCP_EXTMODE_TRIGGER_HOLDING_OFF:\n        /* Update the base rate counter */\n        if (xcpTriggerCount > 0) {\n            xcpTriggerCount--;\n        }\n\n        if (xcpTriggerCount == 0) {\n            /* HoldOff time has expired */\n            if (triggerFired) {\n                /* If the trigger has been fired, we start another duration\n                   straight away */\n                if (xcpClassicTriggerDuration > 0) {\n                    xcpTriggerEnabled = true;\n                    xcpTriggerCount = xcpClassicTriggerDuration;\n                    xcpClassicTriggerStatus = XCP_EXTMODE_TRIGGER_FIRING;\n                } else {\n                    /* If duration is 0, we would never be able to send any data.\n                       This situation should be prevented on the host,\n                       we just handle it gracefully here, in case it happens */\n                    XCP_PRINTF(\"Invalid duration value (0) detected.\\n\");\n                    xcpTriggerEnabled = false;\n                    xcpClassicTriggerStatus = XCP_EXTMODE_TRIGGER_UNARMED;\n                }\n            } else {\n                /* We wait for the next trigger to be fired */\n                xcpClassicTriggerStatus = XCP_EXTMODE_TRIGGER_ARMED;\n            }\n        }\n        break;\n\n    default:\n        XCP_PRINTF(\"Invalid Trigger Status %u detected\\n\", xcpClassicTriggerStatus);\n        xcpTriggerEnabled = false;\n        xcpSignalTriggerFired = false;\n        xcpClassicTriggerCancelRequest = false;\n        xcpClassicTriggerStatus = XCP_EXTMODE_TRIGGER_UNARMED;\n    }\n}\n\n\n\nXcpErrorCode xcpExtModeClassicTriggerInit(void)\n{\n    xcpOldSignalValue = 0;\n    xcpOldSignalValueAvailable = false;\n\n    xcpOldClassicTriggerSource = xcpClassicTriggerSource;\n\n    xcpTriggerEnabled = false;\n    xcpSignalTriggerFired = false;\n    xcpTriggerCount = 0;\n\n    xcpClassicTriggerStatus  = XCP_EXTMODE_TRIGGER_UNARMED;\n\n    return XCP_SUCCESS;\n}\n\n\n/** The function returns true if the external mode event must be triggered */\nboolean_T xcpExtModeClassicTriggerEnabled(extmodeEventId_T eventId)\n{\n    if (eventId == EXTMODE_TRIG_BASE_RATE_EVENT_ID) {\n        /* Whenever a change of the xcpClassicTriggerSource is detected\n           the xcpClassicTriggerStatus is reset */\n        boolean_T triggerSrcChangeDetected = (xcpClassicTriggerSource != xcpOldClassicTriggerSource);\n        xcpOldClassicTriggerSource = xcpClassicTriggerSource;\n\n        if (triggerSrcChangeDetected) {\n            xcpTriggerEnabled     = false;\n            xcpSignalTriggerFired = false;\n            xcpTriggerCount       = 0;\n\n            xcpClassicTriggerStatus  = XCP_EXTMODE_TRIGGER_UNARMED;\n        }\n\n        /* If XCP_EXTMODE_TRIGGER_SIGNAL is selected we want to start\n           processing the Arm request (or the Hold-off expiration) \n           straightaway and carry out the state transition before \n           sampling for the first time */\n        if ((xcpClassicTriggerSource == XCP_EXTMODE_TRIGGER_SIGNAL)  &&\n            (((xcpClassicTriggerStatus == XCP_EXTMODE_TRIGGER_UNARMED) &&\n               xcpClassicTriggerArmRequest) ||\n             ((xcpClassicTriggerStatus == XCP_EXTMODE_TRIGGER_HOLDING_OFF) &&\n              (xcpTriggerCount == 1)))) {\n               xcpTriggerCount = 0;\n               xcpClassicTriggerArmRequest = false;\n               xcpClassicTriggerStatus = XCP_EXTMODE_TRIGGER_ARMED;\n        }\n    }\n\n    if ((xcpClassicTriggerSource == XCP_EXTMODE_TRIGGER_SIGNAL) &&\n        (eventId == xcpClassicTriggerEventId))  {\n        /* Since we are running at the correct eventID, sample the\n           trigger signal value to determine if the trigger signal\n           needs to be enabled.\n           Note: this will update the boolean straight away and request\n           the state transition (updated at the next base rate) */\n        sampleSignalTrigger();\n    }\n\n    if (eventId == EXTMODE_TRIG_BASE_RATE_EVENT_ID) {\n        /* update trigger status to fulfill user requests */\n        updateTriggerStatus();\n\n        /* If the base rate task has run, then reset the\n         * xcpForceTriggerEnableRequest flag.  The state machine\n         * is up to date. */\n        xcpForceTriggerEnableRequest = false;\n    } else if (xcpForceTriggerEnableRequest) {\n        return xcpForcedTriggerEnabled;\n    }\n\n    return xcpTriggerEnabled;\n}\n\n\n/** Reset External Mode classic triggering logic, by restoring the default status */\nXcpErrorCode xcpExtModeClassicTriggerReset(void)\n{\n    xcpOldSignalValue = 0;\n    xcpOldSignalValueAvailable = false;\n\n    xcpClassicTriggerStatus  = XCP_EXTMODE_TRIGGER_UNARMED;\n    xcpOldClassicTriggerSource = XCP_EXTMODE_TRIGGER_MANUAL;\n    xcpClassicTriggerEventId = 0;\n    xcpTriggerEnabled = false;\n    xcpSignalTriggerFired = false;\n    xcpTriggerCount = 0;\n    xcpForcedTriggerEnabled = false;\n    xcpForceTriggerEnableRequest = false;\n\n    xcpClassicTriggerSignalAddress = 0;\n    xcpClassicTriggerSignalAddressExtension = 0;\n\n    xcpClassicTriggerLevel    = 0;\n    xcpClassicTriggerDuration = DEFAULT_XCP_CLASSIC_TRIGGER_DURATION;\n    xcpClassicTriggerHoldOff  = 0;\n    xcpClassicTriggerDelay    = 0;\n\n    xcpClassicTriggerDirection = XCP_EXTMODE_TRIGGER_RISING;\n\n#if defined(EXTMODE_TRIG_ARMED_ON_START) && EXTMODE_TRIG_ARMED_ON_START == 0\n    xcpClassicTriggerArmRequest = false;\n#else\n/* Classic Trigger is armed by default */\n    xcpClassicTriggerArmRequest = true;\n#endif\n\n    xcpClassicTriggerCancelRequest = false;\n\n    xcpClassicTriggerSource = XCP_EXTMODE_TRIGGER_MANUAL;\n    xcpClassicTriggerMode = XCP_EXTMODE_TRIGGER_NORMAL;\n\n    return XCP_SUCCESS;\n}\n\n\n/** When Manual triggering is enabled, force output of xcpExtModeClassicTriggerEnabled to\n *  match pending Arm or Cancel request for all non-base rate events until requests are \n *  processed at the next base rate event.\n * \n *  In the concurrent execution workflow, it is used to avoid omission\n *  of logging data points if a non-base rate task completes\n *  before the base rate at t = 0.\n * \n *  This is a NO-OP when XCP_EXTMODE_TRIGGER_SIGNAL is active.\n */\nvoid xcpExtModeClassicTriggerForceEnableStatusUpdate(void) {\n    if (xcpClassicTriggerSource == XCP_EXTMODE_TRIGGER_MANUAL) {\n        if (xcpClassicTriggerArmRequest && !xcpClassicTriggerCancelRequest) {\n            /* Force xcpExtModeClassicTriggerEnabled to return true\n            * until the next base rate event. */\n            xcpForcedTriggerEnabled = true;\n            xcpForceTriggerEnableRequest = true;\n        } else if (xcpClassicTriggerCancelRequest & !xcpClassicTriggerArmRequest) {\n            xcpForcedTriggerEnabled = false;\n            xcpForceTriggerEnableRequest = true;\n        } else {\n            xcpForceTriggerEnableRequest = false;\n        }\n    }\n}\n"},{"name":"xcp_ext_common.c","type":"source","group":"legacy","path":"C:\\Users\\Sophie\\Documents\\Hochschule\\Master\\Systeme und Programme\\toolbox\\coder\\xcp\\src\\target\\ext_mode\\src","tag":"","groupDisplay":"Other files","code":"/*\n * Copyright 2018-2023 The MathWorks, Inc.\n *\n * File: xcp_ext_common.c\n *\n * Abstract:\n *  This file contains the implementation of the common functionalities\n *  used within the XCP External Mode Platform Abstraction layer.\n *\n *  This includes the handling of absolute simulation time and the global\n *  variables to control the execution of the model on the target\n *  (and accessed remotely via XCP communication protocol).\n */\n#if !defined(INTEGER_CODE) || INTEGER_CODE == 0\n#include <float.h>         /* for DBL_EPSILON */\n#include <math.h>\n#endif\n\n#include \"xcp_ext_common.h\"\n#include \"xcp_ext_param.h\"\n#include \"xcp.h\"\n#include \"xcp_internal.h\"\n#include \"xcp_transport.h\"\n#include \"xcp_cfg.h\"\n\n#include \"rtw_extmode.h\"\n\n#ifdef XCP_CUSTOM_ADDRESS_TRANSLATION\nvoid xcpInitCustomAddressGet(void);\n#endif\n\n#ifndef EXTMODE_FLUSH_ALL_DATA_DELAY_TIME_IN_MICROSECONDS\n/* Dummy delay, that forces the background task to pause the execution\n   and reduces the packets transmission rate. \n   This is useful for host-based targets to prevent the saturation\n   of transmission buffers */\n#define EXTMODE_FLUSH_ALL_DATA_DELAY_TIME_IN_MICROSECONDS  10L  /* 10us */\n#endif\n\n\n/* XCP Client can 'directly' access these global variables, in order to control\n   the model state machine */\n\n#if defined(ON_TARGET_WAIT_FOR_START) && ON_TARGET_WAIT_FOR_START == 1\nboolean_T volatile xcpModelStartRequest = false;\n#else\nboolean_T volatile xcpModelStartRequest = true;\n#endif\nboolean_T volatile xcpModelStopRequest = false;\nXcpExtModeStatus volatile xcpModelStatus = XCP_EXTMODE_STATUS_RESET;\n\nuint32_T volatile xcpModelChecksum0   = 0;\nuint32_T volatile xcpModelChecksum1   = 0;\nuint32_T volatile xcpModelChecksum2   = 0;\nuint32_T volatile xcpModelChecksum3   = 0;\nuint32_T volatile xcpModelIntegerCode = 0;\n\n/* Global variable defined when a non-BYTE addressable target is\n   being emulated as a BYTE addressable target. Currently defined \n   only for WORD addressable targets (Eg.:C2000). But, can be\n   extended to DWORD addressable targets */\n#ifdef XCP_EMULATE_BYTE_ADDRESSABLE_TARGET\nuint8_T volatile xcpEmulateWordTargetAsByteTarget = 1;\n#endif\n\n#if defined(INTEGER_CODE) && INTEGER_CODE == 1\nextmodeSimulationTime_T volatile xcpExtmodeFinalSimulationTime = EXTMODE_SIMULATION_RUN_FOREVER;\n#else\nextmodeSimulationTime_T volatile xcpExtmodeFinalSimulationTime = EXTMODE_SIMULATION_TIME_NOT_INITIALIZED;\n#endif\n\nboolean_T               volatile xcpExtmodeSimulationComplete  = false;\n\n#if !defined(INTEGER_CODE) || INTEGER_CODE == 0\n/* Dummy double variable, required to obtain the size of double data type on the target \n   using the symbols parser. */\nextmodeDouble_T volatile xcpDummyDoubleVariable = (extmodeDouble_T) 0;\n#endif\n\n/* Definition of a dummy printf function */\nvoid xcp_void_printf(const char_T *fmt,...){UNUSED_PARAMETER(fmt);}\n\n\n#if (defined(INTEGER_CODE) && INTEGER_CODE == 1) || defined(XCP_EXTMODE_SIMULATION_TIME_IN_TICKS)\n\n/* The mutex is used to protect against the concurrent access to the global\n   variables (related to the simulation time) when xcpExtModeUpdateTime()\n   is executed by different threads.\n   In particular it guarantees that the state of the variables is updated\n   atomically and it is always consistent when the function is executed */\nstatic XCP_MUTEX_DEFINE(xcpExtModeLock);\n\n\nuint32_T xcpCurrentSimulationTimeInTicks[2] = {0};\n\n/* The variable contains the last value of model simulation time \n   received via extmodeEvent() for the Base Rate thread.\n   In particular, the extmodeSimulationTime_T represents absolute time \n   (in baserate ticks)\n   Note: xcpBaseRateSimulationTime is assumed to be monotonically increasing, \n         but a counter overflow could occur */\nXCP_STATIC extmodeSimulationTime_T xcpBaseRateSimulationTime = 0;\n\n/* When LifeSpan is short, the xcpBaseRateSimulationTime variable could \n  \"overflow earlier than expected\", as the generated code may use only \n  a 16bit counter to store the baserate ticks.\n\n  The purpose of xcpTicksCounterL is to convert the xcpBaseRateSimulationTime \n  into a \"normal\" 32bit variable (and it relies on the EXTMODE_MAX_BASE_RATE_SIMULATION_TIME\n  value to understand when the overflow is supposed to occur).\n\n  xcpTicksCounterL and xcpTicksCounterH are then used to obtain \n  the xcpCurrentSimulationTimeInTicks global tick counter */\nXCP_STATIC uint32_T xcpTicksCounterL = 0;\nXCP_STATIC uint32_T xcpTicksCounterH = 0;\n\n/* The variable contains the last value of simulation time converted into a 32 bit\n   value with XCP_TIMESTAMP_UNIT resolution. This variable is only updated when\n   base rate is executed */\nXCP_STATIC uint32_T xcpBaseRateSimulationTimestamp = 0;\n\n#else /* INTEGER_CODE == 0 */\n\nuint32_T xcpCurrentSimulationTimeInMs[2] = {0};\nXCP_STATIC extmodeSimulationTime_T xcpBaseRateSimulationTime = 0;\n\n#endif\n\n#ifndef XCP_BIG_ENDIAN\n\nXCP_STATIC void xcpCopyTimeValue(volatile uint32_T *dst, uint32_T lsb, uint32_T msb)\n{\n    dst[0] = lsb;\n    dst[1] = msb;\n}\n\n#else /* BIG ENDIAN*/\n\n#define XCP_BYTES_SWAP(value)    ((((value) >> 24) & 0x000000ff)| \\\n                                  (((value) >> 8)  & 0x0000ff00)| \\\n                                  (((value) << 8)  & 0x00ff0000)| \\\n                                  (((value) << 24) & 0xff000000))\n\nXCP_STATIC void xcpCopyTimeValue(volatile uint32_T *dst, uint32_T lsb, uint32_T msb)\n{\n    dst[0] = XCP_BYTES_SWAP(lsb);\n    dst[1] = XCP_BYTES_SWAP(msb);\n}\n\n#endif /* BIG ENDIAN*/\n\n\n#if (defined(INTEGER_CODE) && INTEGER_CODE == 1) || defined(XCP_EXTMODE_SIMULATION_TIME_IN_TICKS)\n\n/* Define the XCP_TIMESTAMP_UNITS_PER_MICROSECOND value based on the\n   selected XCP_TIMESTAMP_UNIT */\n#if (XCP_TIMESTAMP_UNIT == XCP_TIMESTAMP_UNIT_1US)\n#define XCP_TIMESTAMP_UNITS_PER_MICROSECOND     1\n#elif (XCP_TIMESTAMP_UNIT == XCP_TIMESTAMP_UNIT_10US)\n#define XCP_TIMESTAMP_UNITS_PER_MICROSECOND     10\n#elif (XCP_TIMESTAMP_UNIT == XCP_TIMESTAMP_UNIT_100US)\n#define XCP_TIMESTAMP_UNITS_PER_MICROSECOND     100\n#elif (XCP_TIMESTAMP_UNIT == XCP_TIMESTAMP_UNIT_1MS)\n#define XCP_TIMESTAMP_UNITS_PER_MICROSECOND     1000\n#elif (XCP_TIMESTAMP_UNIT == XCP_TIMESTAMP_UNIT_10MS)\n#define XCP_TIMESTAMP_UNITS_PER_MICROSECOND     10000\n#elif (XCP_TIMESTAMP_UNIT == XCP_TIMESTAMP_UNIT_100MS)\n#define XCP_TIMESTAMP_UNITS_PER_MICROSECOND     100000\n#elif (XCP_TIMESTAMP_UNIT == XCP_TIMESTAMP_UNIT_1S)\n#define XCP_TIMESTAMP_UNITS_PER_MICROSECOND     1000000\n#else\n#error \"Invalid XCP_TIMESTAMP_UNIT value. When Purely Integer code is selected, it must be greater than or equal to XCP_TIMESTAMP_UNIT_1US.\"\n#endif\n\n\nstatic extmodeSimulationTime_T xcpExtModeMaxBaseRateSimulationTime = EXTMODE_MAX_BASE_RATE_SIMULATION_TIME;\n\n\n/* Internal function that updates absolute simulation time variables:\n   - xcpCurrentSimulationTimeInTicks \n   - xcpBaseRateSimulationTime\n   - xcpBaseRateSimulationTimestamp\n   and detect if the simulation is actually complete\n   (by updating xcpExtmodeSimulationComplete variable)\n \n   The function returns the 32bit XCP Timestamp counter value \n   (in XCP_TIMESTAMP_UNITs) corresponding to the given newTime\n \n   Note: the newTime input represents the model simulation time in base rate ticks */\nstatic uint32_T updateTime(extmodeSimulationTime_T newTime, extmodeEventId_T eventId)\n{\n    uint32_T timestamp = 0;\n\n    XCP_MUTEX_LOCK(xcpExtModeLock);\n    \n    if (eventId == EXTMODE_BASE_RATE_EVENT_ID) {\n        /* Absolute time variables are only updated when \n           base rate thread is executed */\n        extmodeSimulationTime_T ticksIncrement;\n        extmodeSimulationTime_T newCounterTicks;\n\n        /* Detect increment (in ticks) */\n        if (newTime >= xcpBaseRateSimulationTime) {\n            ticksIncrement = newTime - xcpBaseRateSimulationTime;\n        } else {\n            ticksIncrement = newTime + EXTMODE_MAX_BASE_RATE_SIMULATION_TIME - xcpBaseRateSimulationTime + 1;\n        }\n    \n        /* Update xcpTicksCounterL and xcpTicksCounterH tick counters */\n        newCounterTicks = xcpTicksCounterL + ticksIncrement;\n    \n        if (newCounterTicks < xcpTicksCounterL) {\n            xcpTicksCounterH++;\n        }\n        xcpTicksCounterL = newCounterTicks;\n\n        /* Update absolute simulation time values */\n        xcpCopyTimeValue(xcpCurrentSimulationTimeInTicks, xcpTicksCounterL, xcpTicksCounterH);\n\n        /* Save last received base rate simulation time */\n        xcpBaseRateSimulationTime = newTime;\n    \n        /* Update the 32bit XCP Timestamp counter for the base rate, using 32bit unsigned integer arithmetic */\n        xcpBaseRateSimulationTimestamp += ticksIncrement * EXTMODE_STEP_SIZE_IN_MICROSECONDS * XCP_TIMESTAMP_UNITS_PER_MICROSECOND;\n\n        timestamp = xcpBaseRateSimulationTimestamp;\n        \n        /* Check if simulation is complete */\n        if ((xcpExtmodeFinalSimulationTime != EXTMODE_SIMULATION_RUN_FOREVER) &&\n            (xcpExtmodeFinalSimulationTime != EXTMODE_SIMULATION_TIME_NOT_INITIALIZED)) {\n            /* By default, assuming EXTMODE_SIMULATION_RUN_FOREVER */\n            xcpExtmodeSimulationComplete = (xcpTicksCounterL >= xcpExtmodeFinalSimulationTime);\n        }\n    } else {\n        /* For threads different from the base rate, if the execution is\n           really concurrent, the simulationTime value might be different \n           from xcpBaseRateSimulationTime (ahead or behind).\n           The resulting timestamp value is calculated starting from \n           xcpBaseRateSimulationTimestamp and adding/subtracting the \n           difference */\n        extmodeSimulationTime_T ticksIncrement = 0;\n        extmodeSimulationTime_T ticksDecrement = 0;\n        \n        if (xcpExtModeMaxBaseRateSimulationTime < MAX_extmodeSimulationTime_T) {\n            /* If the size of extmodeSimulationTime_T data type allows\n               the representation of numbers bigger than EXTMODE_MAX_BASE_RATE_SIMULATION_TIME\n               then the newTime value needs to be \"converted\" to just use the same\n               amount of bits as the Base Rate (ClockTick0)\n               Note: this happens for example when ClockTicks are uint16_T and\n               extmodeSimulationTime_T is uint32_T. If the first subrate is half\n               of the base rate then\n                   newTime = ClockTick1 * 2\n               and this time would end up being bigger than EXTMODE_MAX_BASE_RATE_SIMULATION_TIME */\n            newTime = newTime % (xcpExtModeMaxBaseRateSimulationTime + 1);\n        }\n\n        if (newTime >= xcpBaseRateSimulationTime) {\n            /* We need to identify one of the two cases:\n               - newTime is ahead of xcpBaseRateSimulationTime\n               - newTime is behind but an overflow occurred\n             */\n            ticksIncrement = newTime - xcpBaseRateSimulationTime;\n            ticksDecrement = xcpBaseRateSimulationTime + EXTMODE_MAX_BASE_RATE_SIMULATION_TIME - newTime + 1;\n\n            if (ticksDecrement <= ticksIncrement) {\n                /* Assuming that newTime is behind and an overflow has occurred */\n                ticksIncrement = 0;\n            } else {\n            \t/* assuming that newTime is ahead */\n                ticksDecrement = 0;\n            }\n        } else {\n            /* We need to identify one of the two cases:\n               - newTime is behind of xcpBaseRateSimulationTime\n               - newTime is ahead but an overflow occurred\n             */\n            ticksIncrement = newTime + EXTMODE_MAX_BASE_RATE_SIMULATION_TIME - xcpBaseRateSimulationTime + 1;\n            ticksDecrement = xcpBaseRateSimulationTime - newTime;\n\n            if (ticksDecrement <= ticksIncrement) {\n                /* Assuming that newTime is behind, as more likely */\n                ticksIncrement = 0;\n            } else {\n            \t/* assuming that newTime is ahead and an overflow has occurred */\n                ticksDecrement = 0;\n            }\n        }\n\n        if (ticksIncrement > 0) {\n            timestamp = xcpBaseRateSimulationTimestamp +\n                        (ticksIncrement * EXTMODE_STEP_SIZE_IN_MICROSECONDS * XCP_TIMESTAMP_UNITS_PER_MICROSECOND);\n        } else {\n            timestamp = xcpBaseRateSimulationTimestamp -\n                        (ticksDecrement * EXTMODE_STEP_SIZE_IN_MICROSECONDS * XCP_TIMESTAMP_UNITS_PER_MICROSECOND);\n        }\n    }\n\n    XCP_MUTEX_UNLOCK(xcpExtModeLock);\n    \n    return timestamp;\n}\n\n/* Update absolute simulation time variables\n   and detect if the simulation is actually complete\n\n   Note: the newTime input represents the current model simulation time */\nvoid xcpExtModeUpdateTime(extmodeSimulationTime_T newTime, extmodeEventId_T eventId)\n{\n    updateTime(newTime, eventId);\n}\n\n/* In addition to updating absolute simulation time variables\n   and detecting if the simulation is actually complete, \n   the function returns the 32bit XCP Timestamp counter value\n   (in XCP_TIMESTAMP_UNITs) corresponding to the given newTime\n\n   Note: the newTime input represents the model simulation time */\nuint32_T xcpExtModeGetUpdatedTimestamp(extmodeSimulationTime_T newTime, extmodeEventId_T eventId)\n{\n    return updateTime(newTime, eventId);\n}\n\n\n#ifdef XCP_TIMESTAMP_BASED_ON_SIMULATION_TIME\n\n/* Return value in XCP_TIMESTAMP_UNITs, based on the current model simulation time */\nuint32_T xcpGetTimestamp(void)\n{\n    uint32_T timestamp;\n\n    /* @note: theoretically the base thread could pre-preempt any thread during the\n       read operation. Since the read of a 32bit value may not be atomic\n       in some architectures we have to protect it with a mutex.\n       We may be able to remove this lock if we extend the Platform Abstraction Layer\n       to include atomic read operations */\n    XCP_MUTEX_LOCK(xcpExtModeLock);\n\n    timestamp = xcpBaseRateSimulationTimestamp;\n\n    XCP_MUTEX_UNLOCK(xcpExtModeLock);\n\n    return timestamp;\n}\n\n#endif /* XCP_TIMESTAMP_BASED_ON_SIMULATION_TIME */\n\n#else /* INTEGER_CODE == 0 */\n\n/* Define the XCP_TIMESTAMP_UNITS_PER_SECOND value based on the\n   selected XCP_TIMESTAMP_UNIT */\n#if (XCP_TIMESTAMP_UNIT == XCP_TIMESTAMP_UNIT_1NS)\n#define XCP_TIMESTAMP_UNITS_PER_SECOND          1e9\n#elif (XCP_TIMESTAMP_UNIT == XCP_TIMESTAMP_UNIT_10NS)\n#define XCP_TIMESTAMP_UNITS_PER_SECOND          1e8\n#elif (XCP_TIMESTAMP_UNIT == XCP_TIMESTAMP_UNIT_100NS)\n#define XCP_TIMESTAMP_UNITS_PER_SECOND          1e7\n#elif (XCP_TIMESTAMP_UNIT == XCP_TIMESTAMP_UNIT_1US)\n#define XCP_TIMESTAMP_UNITS_PER_SECOND          1e6\n#elif (XCP_TIMESTAMP_UNIT == XCP_TIMESTAMP_UNIT_10US)\n#define XCP_TIMESTAMP_UNITS_PER_SECOND          1e5\n#elif (XCP_TIMESTAMP_UNIT == XCP_TIMESTAMP_UNIT_100US)\n#define XCP_TIMESTAMP_UNITS_PER_SECOND          1e4\n#elif (XCP_TIMESTAMP_UNIT == XCP_TIMESTAMP_UNIT_1MS)\n#define XCP_TIMESTAMP_UNITS_PER_SECOND          1e3\n#elif (XCP_TIMESTAMP_UNIT == XCP_TIMESTAMP_UNIT_10MS)\n#define XCP_TIMESTAMP_UNITS_PER_SECOND          1e2\n#elif (XCP_TIMESTAMP_UNIT == XCP_TIMESTAMP_UNIT_100MS)\n#define XCP_TIMESTAMP_UNITS_PER_SECOND          1e1\n#elif (XCP_TIMESTAMP_UNIT == XCP_TIMESTAMP_UNIT_1S)\n#define XCP_TIMESTAMP_UNITS_PER_SECOND            1\n#elif (XCP_TIMESTAMP_UNIT == XCP_TIMESTAMP_UNIT_1PS)\n#define XCP_TIMESTAMP_UNITS_PER_SECOND         1e12\n#elif (XCP_TIMESTAMP_UNIT == XCP_TIMESTAMP_UNIT_10PS)\n#define XCP_TIMESTAMP_UNITS_PER_SECOND         1e11\n#elif (XCP_TIMESTAMP_UNIT == XCP_TIMESTAMP_UNIT_100PS)\n#define XCP_TIMESTAMP_UNITS_PER_SECOND         1e10\n#else\n#error \"invalid XCP_TIMESTAMP_UNIT value\"\n#endif\n\n\n/* Update absolute simulation time variable xcpCurrentSimulationTimeInMs\n   and detect if the simulation is actually complete\n   (by updating xcpExtmodeSimulationComplete variable)\n\n   The function returns the 32bit XCP Timestamp counter value\n   (in XCP_TIMESTAMP_UNITs) corresponding to the given newTime\n\n   Note: the newTime input represents the model simulation time in seconds */\nvoid xcpExtModeUpdateTime(extmodeSimulationTime_T newTime, extmodeEventId_T eventId)\n{\n    if (eventId == EXTMODE_BASE_RATE_EVENT_ID) {\n        /* Absolute time variables are only updated when base rate\n           thread is executed, no need to use any lock */\n        real_T   timeInMs = newTime * 1000.0;\n        uint32_T timeInMsL = (uint32_T)fmod(timeInMs, (extmodeSimulationTime_T) XCP_UINT32_MAX + 1);\n        uint32_T timeInMsH = 0;\n\n        if (timeInMs > XCP_UINT32_MAX) {\n            /* cast truncates, rounding to zero */\n            timeInMsH = (uint32_T)(timeInMs / XCP_UINT32_MAX);\n        }\n\n        /* Update absolute simulation time variables */\n        xcpCopyTimeValue(xcpCurrentSimulationTimeInMs, timeInMsL, timeInMsH);\n\n        /* Check if simulation is complete */\n        if ((xcpExtmodeFinalSimulationTime != EXTMODE_SIMULATION_RUN_FOREVER) &&\n            (xcpExtmodeFinalSimulationTime != EXTMODE_SIMULATION_TIME_NOT_INITIALIZED)) {\n            /* By default, assuming EXTMODE_SIMULATION_RUN_FOREVER */\n           xcpExtmodeSimulationComplete = (xcpExtmodeFinalSimulationTime - newTime) <\n                                          (newTime * (DBL_EPSILON));\n        }\n\n        /* Update the current simulation time */\n        xcpBaseRateSimulationTime = newTime;\n    }\n}\n\n/* In addition to updating absolute simulation time variables\n   and detecting if the simulation is actually complete, \n   the function returns the 32bit XCP Timestamp counter value\n   (in XCP_TIMESTAMP_UNITs) corresponding to the given newTime\n\n   Note: the newTime input represents the model simulation time */\nuint32_T xcpExtModeGetUpdatedTimestamp(extmodeSimulationTime_T newTime, extmodeEventId_T eventId)\n{\n    uint32_T timestamp = 0;\n\n    xcpExtModeUpdateTime(newTime, eventId);\n\n    /* Convert the newTime into the 32 bits XCP Timestamp counter, based on XCP configuration */\n    timestamp = (uint32_T)fmod(newTime * (extmodeSimulationTime_T) XCP_TIMESTAMP_UNITS_PER_SECOND + 0.5, \n                              (extmodeSimulationTime_T)XCP_UINT32_MAX + 1);\n\n    return timestamp;\n}\n\n\n#ifdef XCP_TIMESTAMP_BASED_ON_SIMULATION_TIME\n\n/* This function is supposed to return the value of the XCP Timestamp in XCP_TIMESTAMP_UNITs.\n   Specifically it is invoked within the xcpEvent().\n   When XCP_TIMESTAMP_BASED_ON_SIMULATION_TIME is defined, both extmodeEvent() and \n   rtExtModeUpload() use xcpEventExternalTimestamp() instead, so we should never hit this function.\n   However we need to provide a dummy implementation as the function is required by the \n   Platform Abstraction Layer. */\nuint32_T xcpGetTimestamp(void)\n{\n    return 0;\n}\n\n#endif /* XCP_TIMESTAMP_BASED_ON_SIMULATION_TIME */\n\n#endif /* INTEGER_CODE == 1 */\n\n\nuint32_T xcpExtModeGetSimulationTime(void)\n{  \n#ifdef XCP_TIMESTAMP_BASED_ON_SIMULATION_TIME\n    /* Even if not thread-safe, this implementation has been added for backward compatibility \n       as Code Execution Profiling was invoking the xcpEvent() API directly */\n    return xcpExtModeGetUpdatedTimestamp(xcpBaseRateSimulationTime, EXTMODE_BASE_RATE_EVENT_ID);\n#else\n    return 0;\n#endif\n}\n\n\nXcpErrorCode xcpExtModeInit(void)\n{\n    int_T parNumber = 0;\n    void **parList = NULL;\n    XcpErrorCode errorCode = XCP_SUCCESS;\n    \n#if !defined(INTEGER_CODE) || INTEGER_CODE == 0\n    /* Use dummy variable to prevent optimization in some compilers */\n    xcpDummyDoubleVariable = (extmodeDouble_T) 0;\n#endif\n\n#if defined(INTEGER_CODE) && INTEGER_CODE == 1\n    XCP_MUTEX_INIT(xcpExtModeLock);\n#endif\n\n#ifdef XCP_CUSTOM_ADDRESS_TRANSLATION\n    xcpInitCustomAddressGet();\n#endif\n\n    /* Retrieve XCP Transport Layer initialization parameters */\n    xcpTransportGetInitParameters(&parNumber, &parList);\n\n    /* Initialize XCP Transport Layer */\n    errorCode = xcpTransportInit(parNumber, parList);\n    if (errorCode != XCP_SUCCESS) {\n        XCP_PRINTF(\"xcpExtModeInit: xcpTransportInit error\\n\");\n        return errorCode;\n    }\n\n    /* Retrieve XCP Protocol Layer initialization parameters */\n    xcpGetInitParameters(&parNumber, &parList);\n\n    /* Initialize XCP Protocol layer */\n    errorCode = xcpInit(parNumber, parList);\n    if (errorCode != XCP_SUCCESS) {\n        XCP_PRINTF(\"xcpExtModeInit: xcpInit error: code %d\\n\", errorCode);\n    }\n\n    return errorCode;\n}\n\n\nXcpErrorCode xcpExtModeRunBackground(boolean_T flushAllData)\n{\n    XcpErrorCode errorCode = XCP_SUCCESS;\n    boolean_T done = false;\n\n    /* Add a dummy delay, that forces the task to pause the execution\n       (leaving the 'running' state). This gives Simulink the opportunity\n       to run when connecting to host-based targets in External Mode */\n    XCP_SLEEP(0, 0);\n\n    do {\n        boolean_T dataAvailable = false;\n\n        /* Retrieve a new Rx packet from interface */\n        errorCode = xcpTransportRx();\n\n        if ((errorCode != XCP_SUCCESS) && (errorCode != XCP_EMPTY)) {\n            XCP_PRINTF(\"xcpExtModeRunBackground: xcpTransportRx error, code %d\\n\", errorCode);\n            done = true;\n        } else {\n            dataAvailable = dataAvailable || (errorCode != XCP_EMPTY);\n        }\n\n        if (!done) {\n            /* Process it within the protocol layer.\n               By checking the return code value, diagnostic info on\n               XCP packet processing can be collected.\n               Every run corresponds to the processing of one single XCP packet */\n            errorCode = xcpRun();\n\n            if ((errorCode != XCP_SUCCESS) && (errorCode != XCP_EMPTY)) {\n                XCP_PRINTF(\"xcpExtModeRunBackground: xcpRun error, code %d\\n\", errorCode);\n                done = true;\n            } else {\n                dataAvailable = dataAvailable || (errorCode != XCP_EMPTY);\n            }\n        }\n\n        if (!done) {\n            /* Send one of the pending Tx packets over the network */\n            errorCode = xcpTransportTx();\n            if ((errorCode != XCP_SUCCESS) && (errorCode != XCP_EMPTY)) {\n                XCP_PRINTF(\"xcpExtModeRunBackground: xcpTransportTx error, code %d\\n\", errorCode);\n                done = true;\n            } else {\n                dataAvailable = dataAvailable || (errorCode != XCP_EMPTY);\n            }\n        }\n\n        if (flushAllData) {\n#if EXTMODE_FLUSH_ALL_DATA_DELAY_TIME_IN_MICROSECONDS > 0\n            /* Dummy delay, that forces the background task to pause the execution\n               and reduces the packets transmission rate, for host-based targets. */\n            XCP_SLEEP(0, EXTMODE_FLUSH_ALL_DATA_DELAY_TIME_IN_MICROSECONDS);\n#endif\n            /* The xcpExtModeRunBackground will continue to process packets until\n               the TX and RX queues are empty or an error occurred. */\n            done = done || !dataAvailable;\n        } else {\n            /* The xcpExtModeRunBackground will only carry out one iteration and then return.\n               The remaining packets will be processed at the next round. */\n            done = true;\n        }\n    } while (!done);\n\n    return errorCode;\n}\n\n\nXcpErrorCode xcpExtModeReset(void)\n{\n    XcpErrorCode errorCode = XCP_SUCCESS;\n    extmodeRealTime_T elapsedTime;\n    XcpStatus status;\n\n    if (xcpExtmodeSimulationComplete) {\n        /* When DAQ Packed Mode is enabled, if we reached the nominal end of the\n           simulation we trigger the transmission of a packet containing the samples \n           received so far. The trailing '0's will be removed and not displayed\n           in the output of the simulation */\n        xcpPackedModeEventsFlush(0);\n    }\n\n    /* Wait for the XCP client to complete the clean disconnection procedure */\n    status = xcpGetStatus();\n\n    elapsedTime = 0;\n    while ((elapsedTime < EXTMODE_SHUTDOWN_TIMEOUT_IN_MICROSECONDS) &&\n           (status != XCP_DISCONNECTED)) {\n\n        XCP_SLEEP(0, EXTMODE_RETRY_TIME_IN_MICROSECONDS);\n        elapsedTime += EXTMODE_RETRY_TIME_IN_MICROSECONDS;\n\n        /* Run the XCP Stack to keep the communication 'alive',\n           forcing the flush of all data */\n        xcpExtModeRunBackground(true);\n\n        /* Check the XCP stack status again */\n        status = xcpGetStatus();\n    }\n\n    /* Reset XCP Protocol Layer */\n    errorCode = xcpReset();\n    if (errorCode != XCP_SUCCESS) {\n        XCP_PRINTF(\"xcpReset error: code %d\\n\", errorCode);\n    }\n\n    /* Reset XCP Transport Layer */\n    errorCode = xcpTransportReset();\n    if (errorCode != XCP_SUCCESS) {\n        XCP_PRINTF(\"xcpTransportReset error: code %d\\n\", errorCode);\n    }\n\n    /* Restore the global variables to the default value */\n#if defined(ON_TARGET_WAIT_FOR_START) && ON_TARGET_WAIT_FOR_START == 1\n    xcpModelStartRequest = false;\n#else\n    xcpModelStartRequest = true;\n#endif\n\n    xcpModelStopRequest = false;\n\n    xcpModelChecksum0   = 0;\n    xcpModelChecksum1   = 0;\n    xcpModelChecksum2   = 0;\n    xcpModelChecksum3   = 0;\n    xcpModelIntegerCode = 0;\n\n#if defined(INTEGER_CODE) && INTEGER_CODE == 1\n    xcpExtmodeFinalSimulationTime = EXTMODE_SIMULATION_RUN_FOREVER;\n\n    xcpBaseRateSimulationTime = 0;\n\n    xcpTicksCounterL = 0;\n    xcpTicksCounterH = 0;\n\n    xcpBaseRateSimulationTimestamp = 0;\n#else\n    xcpExtmodeFinalSimulationTime = EXTMODE_SIMULATION_TIME_NOT_INITIALIZED;\n#endif\n\n    xcpExtmodeSimulationComplete  = false;\n\n#if (defined(INTEGER_CODE) && INTEGER_CODE == 1) || defined(XCP_EXTMODE_SIMULATION_TIME_IN_TICKS)\n    XCP_MEMSET(xcpCurrentSimulationTimeInTicks, 0, sizeof(xcpCurrentSimulationTimeInTicks));\n\n    xcpBaseRateSimulationTime = 0;\n\n    xcpTicksCounterL = 0;\n    xcpTicksCounterH = 0;\n\n    xcpBaseRateSimulationTimestamp = 0;\n#else\n    XCP_MEMSET(xcpCurrentSimulationTimeInMs, 0, sizeof(xcpCurrentSimulationTimeInMs));\n    xcpBaseRateSimulationTime = 0;\n#endif\n\n    return errorCode;\n}\n"},{"name":"xcp_ext_mode.c","type":"source","group":"legacy","path":"C:\\Users\\Sophie\\Documents\\Hochschule\\Master\\Systeme und Programme\\toolbox\\coder\\xcp\\src\\target\\ext_mode\\src","tag":"","groupDisplay":"Other files","code":"/*\n * Copyright 2017-2023 The MathWorks, Inc.\n *\n * File: xcp_ext_mode.c\n *\n * Abstract:\n *  The file provides the implementation of the ext_mode.h interface\n *  based on XCP communication protocol\n */\n\n#if !defined(EXTMODE_DISABLE_ARGS_PROCESSING)\n#include <stdio.h>\n#endif\n\n#include <string.h>        /* optional for strcmp */\n\n#include \"xcp_ext_common.h\"\n#include \"xcp_ext_param.h\"\n#include \"xcp_internal.h\"\n#include \"ext_mode.h\"\n\n\n#ifdef EXTMODE_XCP_TRIGGER_SUPPORT\n\n#include \"xcp_ext_classic_trigger.h\"\n\n#ifndef EXTMODE_XCP_MAX_TRIGGER_NUMBER\n#if defined(XCP_MEM_DAQ_RESERVED_POOLS_NUMBER) && (XCP_MEM_DAQ_RESERVED_POOLS_NUMBER > 0)\n/* If XCP_MEM_DAQ_RESERVED_POOLS_NUMBER is defined, the value of this macro should be at least\n   equal to the number of sample times in the model. This can be one more than the number of DAQ\n   lists that use reserved pools if Tid 0 and 1 are mapped to the same DAQ list. */\n#define EXTMODE_XCP_MAX_TRIGGER_NUMBER XCP_MEM_DAQ_RESERVED_POOLS_NUMBER + 1\n#else\n#define EXTMODE_XCP_MAX_TRIGGER_NUMBER EXTMODE_MAX_EVENT_ID\n#endif\n#endif /* EXTMODE_XCP_MAX_TRIGGER_NUMBER */\n\n#if (EXTMODE_XCP_MAX_TRIGGER_NUMBER > EXTMODE_MAX_EVENT_ID) || (EXTMODE_XCP_MAX_TRIGGER_NUMBER < 1)\n#error Invalid EXTMODE_XCP_MAX_TRIGGER_NUMBER value.\n#endif\n\nstatic extmodeEventTriggerEnable xcpCustomTriggerFunction[EXTMODE_XCP_MAX_TRIGGER_NUMBER];\n\n#endif\n\n\nextmodeErrorCode_T extmodeParseArgs(int_T   argc,\n                                    const char_T *argv[])\n{\n    extmodeErrorCode_T errorCode = EXTMODE_SUCCESS;\n\n#ifdef  EXTMODE_DISABLE_ARGS_PROCESSING\n    /* Some targets do not support command line args */\n    UNUSED_PARAMETER(argc);\n    UNUSED_PARAMETER(argv);\n#else\n    boolean_T  parseError = false;\n    int_T  count = 1;\n\n    if (argc < 0) {\n        XCP_PRINTF(\"extmodeParseArgs: argc must be a positive number\\n\");\n        return EXTMODE_INV_ARG;\n    }\n\n    if ((argc > 0) && (argv == NULL)) {\n        XCP_PRINTF(\"extmodeParseArgs: invalid argv value\\n\");\n        return EXTMODE_INV_ARG;\n    }\n\n    /*\n     * Parse the External Mode Platform-independent Abstraction Layer parameters.\n     * Let all unrecognized parameters pass through to the XCP External Mode \n     * Platform-specific Abstraction Layer.\n     * NULL out all args handled so that they can ignored by the lower layer.\n     */\n    while (count < argc) {\n        const char_T *option = argv[count++];\n\n        if (option != NULL) {\n            /* final time */\n            if ((strcmp(option, \"-tf\") == 0) && (count != argc)) {\n                const char_T *timeValueString = argv[count++];\n                extmodeSimulationTime_T  timeValue = 0;\n                char_T        stringBuffer[201];\n\n                XCP_MEMSET(stringBuffer, 0, sizeof(stringBuffer));\n\n                sscanf(timeValueString, \"%200s\", stringBuffer);\n                if (strcmp(stringBuffer, \"inf\") == 0) {\n                    timeValue = EXTMODE_SIMULATION_RUN_FOREVER;\n                }\n                else {\n                    char_T tmpString[2];\n\n#if (defined(INTEGER_CODE) && INTEGER_CODE == 1) || defined(XCP_EXTMODE_SIMULATION_TIME_IN_TICKS)\n                    int tmpValue;\n\n                    if ((sscanf(stringBuffer, \"%d%1s\", &tmpValue, tmpString) != 1) ||\n                        (tmpValue < 0)) {\n                        XCP_PRINTF(\"External mode final simulation time must be a positive, integer value or inf\\n\");\n                        parseError = true;\n                        break;\n                    }\n                    timeValue = (extmodeSimulationTime_T) tmpValue;\n#else\n                    if ((sscanf(stringBuffer, \"%lf%1s\", &timeValue, tmpString) != 1) ||\n                        (timeValue < (extmodeSimulationTime_T)0)) {\n                        XCP_PRINTF(\"External mode final simulation time must be a positive, real value or inf\\n\");\n                        parseError = true;\n                        break;\n                    }\n#endif\n                }\n                xcpExtmodeFinalSimulationTime = timeValue;\n\n                argv[count - 2] = NULL;\n                argv[count - 1] = NULL;\n            }\n            /* -w (wait for packet from host) option */\n            else if (strcmp(option, \"-w\") == 0) {\n                xcpModelStartRequest = false;\n                argv[count - 1] = NULL;\n            }\n        }\n    }\n\n    if (parseError) {\n        XCP_PRINTF(\"\\nUsage: model_name -option1 val1 -option2 val2 -option3 \"\n            \"...\\n\\n\");\n\n#if (defined(INTEGER_CODE) && INTEGER_CODE == 1) || defined(XCP_EXTMODE_SIMULATION_TIME_IN_TICKS)\n        XCP_PRINTF(\"\\t-tf 20 - sets final time to 20 ticks\\n\");\n#else\n        XCP_PRINTF(\"\\t-tf 20 - sets final time to 20 seconds\\n\");\n#endif\n\n        return EXTMODE_INV_ARG;\n    }\n\n    /* Extract XCP specific initialization parameters, by invoking the \n       XCP External Mode Platform-specific Abstraction Layer API */\n    xcpExtModeParseArgs(argc, argv);\n\n    /*\n     * Check for unprocessed (\"unhandled\") args.\n     */\n    {\n        int i;\n        for (i = 1; i<argc; i++) {\n            if (argv[i] != NULL) {\n                XCP_PRINTF(\"Unexpected command line argument: %s\\n\", argv[i]);\n                return EXTMODE_INV_ARG;\n            }\n        }\n    }\n\n#endif /* EXTMODE_DISABLE_ARGS_PROCESSING */\n\n    return errorCode;\n}\n\n\nextmodeErrorCode_T extmodeInit(RTWExtModeInfo *extmodeInfo, extmodeSimulationTime_T *finalTime)\n{\n    XcpErrorCode errorCode = XCP_SUCCESS;\n\n    if (extmodeInfo == NULL) {\n        XCP_PRINTF(\"extmodeInit: invalid extmodeInfo\\n\");\n        return EXTMODE_INV_ARG;\n    }\n\n    if (finalTime == NULL) {\n        XCP_PRINTF(\"extmodeInit: invalid finalTime variable\\n\");\n        return EXTMODE_INV_ARG;\n    }\n\n    if (xcpExtmodeFinalSimulationTime == EXTMODE_SIMULATION_TIME_NOT_INITIALIZED) {\n#if (defined(INTEGER_CODE) && INTEGER_CODE == 1)  || defined(XCP_EXTMODE_SIMULATION_TIME_IN_TICKS)\n        /* If the model final simulation time in External Mode has NOT been initialized,\n           then EXTMODE_SIMULATION_RUN_FOREVER is assumed, as the Real-time Model\n           structure doesn't contain any final time information when PurelyIntegerCode\n           is selected */\n        xcpExtmodeFinalSimulationTime = EXTMODE_SIMULATION_RUN_FOREVER;\n#else\n        /* If the model final simulation time in External Mode has NOT been initialized,\n           then the finalTime argument is considered an INPUT */\n        xcpExtmodeFinalSimulationTime = *finalTime;\n#endif\n    }\n    else {\n        /* If the model final simulation time in External Mode has been initialized\n           (e.g.via '-tf ' parameter detected by extmodeParseArgs() or\n            via explicit call of extmodeSetFinalSimulationTime())\n           then the finalTime argument is considered an OUTPUT */\n        *finalTime = xcpExtmodeFinalSimulationTime;\n    }\n\n    if (xcpExtmodeFinalSimulationTime == EXTMODE_SIMULATION_RUN_FOREVER) {\n        XCP_PRINTF(\"\\n**warning: the simulation will run with no stop time due \"\n            \"to external mode infinite final simulation time.\\n\");\n    }\n\n    /* Initialize the model checksum information */\n    xcpModelChecksum0 = rteiGetChecksum0(extmodeInfo);\n    xcpModelChecksum1 = rteiGetChecksum1(extmodeInfo);\n    xcpModelChecksum2 = rteiGetChecksum2(extmodeInfo);\n    xcpModelChecksum3 = rteiGetChecksum3(extmodeInfo);\n\n#if defined(INTEGER_CODE) && INTEGER_CODE == 1\n    xcpModelIntegerCode = 1;\n#else\n    xcpModelIntegerCode = 0;\n#endif\n\n#ifdef EXTMODE_XCP_TRIGGER_SUPPORT\n    xcpExtModeClassicTriggerInit();\n\n    /* By default, use Classic Triggering */\n    {\n        unsigned i = 0;\n        for (i = 0; i < EXTMODE_XCP_MAX_TRIGGER_NUMBER; i++) {\n            xcpCustomTriggerFunction[i] = xcpExtModeClassicTriggerEnabled;\n        }\n    }\n#endif\n\n    /* Initialize the platform abstraction layer common services */\n    errorCode = xcpExtModeInit();\n    \n    if (errorCode == XCP_SUCCESS) {\n        xcpModelStatus = XCP_EXTMODE_STATUS_INITIALIZED;\n    }\n\n    return XCP_TO_EXTMODE_ERROR_CODE(errorCode);\n}\n\n\nextmodeErrorCode_T extmodeWaitForHostRequest(extmodeRealTime_T timeoutInMicroseconds)\n{\n    extmodeErrorCode_T errorCode = EXTMODE_SUCCESS;\n    extmodeRealTime_T elapsedTime = 0;\n    boolean_T timeoutExpired = false;\n    boolean_T waitForHostRequest = !xcpModelStartRequest;\n    xcpModelStatus = XCP_EXTMODE_STATUS_WAITING_TO_START;\n\n    timeoutExpired = (timeoutInMicroseconds == 0) && !xcpModelStartRequest && !xcpModelStopRequest;\n\n    /*\n     * Pause until the XCP client modifies the xcpModelStartRequest value\n     * or a stop request has been issued\n     */\n    while (!xcpModelStartRequest && !xcpModelStopRequest && !timeoutExpired) {\n        XCP_SLEEP(0L, EXTMODE_RETRY_TIME_IN_MICROSECONDS);\n        elapsedTime += EXTMODE_RETRY_TIME_IN_MICROSECONDS;\n\n        timeoutExpired = (timeoutInMicroseconds != EXTMODE_WAIT_FOREVER) &&\n                         (elapsedTime > timeoutInMicroseconds);\n\n        xcpExtModeRunBackground(DEFAULT_XCP_EXTMODE_RUN_BACKGROUND_FLUSH);\n    }\n\n    xcpModelStatus = XCP_EXTMODE_STATUS_READY_TO_RUN;\n\n    if (timeoutExpired) {\n        errorCode = EXTMODE_TIMEOUT_ERROR;\n    }\n\n#ifdef EXTMODE_XCP_TRIGGER_SUPPORT\n    /* Avoid missing logged data points at t = 0 in concurrent execution workflows. */\n    if (waitForHostRequest) {\n        xcpExtModeClassicTriggerForceEnableStatusUpdate();\n    }\n#endif\n    return errorCode;\n}\n\n\nextmodeErrorCode_T extmodeEvent(extmodeEventId_T eventId, extmodeSimulationTime_T simulationTime)\n{\n    XcpErrorCode errorCode  = XCP_SUCCESS;\n    boolean_T triggerEnable = true;\n\n#if (!defined(INTEGER_CODE) || (INTEGER_CODE == 0)) && (!defined(XCP_EXTMODE_SIMULATION_TIME_IN_TICKS))\n    if (simulationTime < 0) {\n        XCP_PRINTF(\"extmodeEvent error: invalid simulationTime, must be non-negative\\n\");\n        return EXTMODE_INV_ARG;\n    }\n#endif\n\n    if (eventId > EXTMODE_MAX_EVENT_ID) {\n        XCP_PRINTF(\"extmodeEvent error: invalid eventId (%d), must be less than %d\\n\", eventId, EXTMODE_MAX_EVENT_ID);\n        return EXTMODE_INV_ARG;\n    }\n    \n    if ((xcpModelStatus == XCP_EXTMODE_STATUS_READY_TO_RUN) ||\n        (xcpModelStatus == XCP_EXTMODE_STATUS_INITIALIZED)) {\n        /* Update model status, as soon as the extmodeEvent() gets invoked */\n        xcpModelStatus = XCP_EXTMODE_STATUS_RUNNING;\n    }\n\n#ifdef EXTMODE_XCP_TRIGGER_SUPPORT\n    if ((eventId < EXTMODE_XCP_MAX_TRIGGER_NUMBER) &&\n        (xcpCustomTriggerFunction[eventId] != NULL)) {\n        /* Trigger logic should be applied only when the synchronous\n           data transfer is active */\n        XcpStatus xcpStatus = xcpGetStatus();\n        if (xcpStatus == XCP_SYNC_DATA_TRANSFER) {\n            triggerEnable = xcpCustomTriggerFunction[eventId](eventId);\n        }\n    }\n#endif\n    {\n        XcpEventIdType xcpEventId = (XcpEventIdType) eventId;\n\n#ifdef XCP_TIMESTAMP_BASED_ON_SIMULATION_TIME\n        /* Update local absolute time variables*/\n        uint32_T timestampBasedOnSimTime = xcpExtModeGetUpdatedTimestamp(simulationTime, eventId);\n#else\n        /* Update local absolute time variables*/\n        xcpExtModeUpdateTime(simulationTime, eventId);\n#endif\n\n        if (triggerEnable) {\n#ifdef XCP_TIMESTAMP_BASED_ON_SIMULATION_TIME\n            /* Notify XCP Stack about the eventId */\n            errorCode = xcpEventExternalTimestamp(xcpEventId, timestampBasedOnSimTime);\n#else\n            /* Notify XCP Stack about the eventId, using the timestamp read\n               from the HW timer supported by XCP Platform Abstraction layer */\n            errorCode = xcpEvent(xcpEventId);\n#endif\n        } else {\n            /* reset pending packed DAQ lists if the trigger did not fire so that we do not send\n               packets with non-consecutive samples */\n            xcpPackedModeEventReset(xcpEventId);\n        }\n    }\n\n    if (errorCode != XCP_SUCCESS) {\n        XCP_PRINTF(\"extmodeEvent error: code %d\\n\", errorCode);\n    }\n\n    return XCP_TO_EXTMODE_ERROR_CODE(errorCode);\n}\n\n\nextmodeErrorCode_T extmodeBackgroundRun(void)\n{\n    XcpErrorCode errorCode = XCP_SUCCESS;\n\n    errorCode = xcpExtModeRunBackground(DEFAULT_XCP_EXTMODE_RUN_BACKGROUND_FLUSH);\n\n    return XCP_TO_EXTMODE_ERROR_CODE(errorCode);\n}\n\n\nextmodeErrorCode_T extmodeReset(void)\n{\n    XcpErrorCode errorCode = XCP_SUCCESS;\n\n    xcpModelStatus = XCP_EXTMODE_STATUS_RESETTING;\n    \n    errorCode = xcpExtModeReset();\n\n#ifdef EXTMODE_XCP_TRIGGER_SUPPORT\n    XCP_MEMSET(xcpCustomTriggerFunction, 0, sizeof(xcpCustomTriggerFunction));\n\n    xcpExtModeClassicTriggerReset();\n#endif\n\n    xcpModelStatus = XCP_EXTMODE_STATUS_RESET;\n    \n    return XCP_TO_EXTMODE_ERROR_CODE(errorCode);\n}\n\nboolean_T extmodeStopRequested(void)\n{\n    return xcpModelStopRequest;\n}\n\nboolean_T extmodeStartRequested(void)\n{\n    return xcpModelStartRequest;\n}\n\n\nboolean_T extmodeSimulationComplete(void)\n{\n    return xcpExtmodeSimulationComplete;\n}\n\nextmodeErrorCode_T extmodeGetFinalSimulationTime(extmodeSimulationTime_T *finalTime)\n{\n    if (finalTime == NULL) {\n        XCP_PRINTF(\"extmodeGetFinalSimulationTime: invalid finalTime variable\\n\");\n        return EXTMODE_INV_ARG;\n    }\n\n    if (xcpExtmodeFinalSimulationTime == EXTMODE_SIMULATION_TIME_NOT_INITIALIZED) {\n        XCP_PRINTF(\"extmodeGetFinalSimulationTime: finalTime not initialized\\n\");\n        return EXTMODE_NOT_INITIALIZED;\n    }\n\n    *finalTime = xcpExtmodeFinalSimulationTime;\n\n    return EXTMODE_SUCCESS;\n}\n\nextmodeErrorCode_T extmodeSetFinalSimulationTime(extmodeSimulationTime_T finalTime)\n{\n#if (!defined(INTEGER_CODE) || (INTEGER_CODE == 0)) && (!defined(XCP_EXTMODE_SIMULATION_TIME_IN_TICKS))\n    if ((finalTime < 0) && (finalTime != EXTMODE_SIMULATION_RUN_FOREVER)) {\n        XCP_PRINTF(\"extmodeSetFinalSimulationTime: invalid finalTime value\\n\");\n        return EXTMODE_INV_ARG;\n    }\n#endif\n\n    xcpExtmodeFinalSimulationTime = finalTime;\n\n    return EXTMODE_SUCCESS;\n}\n\n#ifdef EXTMODE_XCP_TRIGGER_SUPPORT\n\nextmodeErrorCode_T extmodeGetEventTriggerEnable(extmodeEventId_T eventId, extmodeEventTriggerEnable *triggerEnable)\n{\n    if (eventId >= EXTMODE_XCP_MAX_TRIGGER_NUMBER) {\n        XCP_PRINTF(\"extmodeGetEventTriggerEnable: invalid eventId value\\n\");\n        return EXTMODE_INV_ARG;\n    }\n\n    if (triggerEnable == NULL) {\n        XCP_PRINTF(\"extmodeGetEventTriggerEnable: invalid triggerEnabled value\\n\");\n        return EXTMODE_INV_ARG;\n    }\n\n    *triggerEnable = xcpCustomTriggerFunction[eventId];\n\n    return EXTMODE_SUCCESS;\n}\n\nextmodeErrorCode_T extmodeSetEventTriggerEnable(extmodeEventId_T eventId, extmodeEventTriggerEnable triggerEnable)\n{\n    if (eventId >= EXTMODE_XCP_MAX_TRIGGER_NUMBER) {\n        XCP_PRINTF(\"extmodeSetEventTriggerEnable: invalid eventId value\\n\");\n        return EXTMODE_INV_ARG;\n    }\n\n    xcpCustomTriggerFunction[eventId] = triggerEnable;\n    return EXTMODE_SUCCESS;\n}\n\n#else\n\nextmodeErrorCode_T extmodeGetEventTriggerEnable(extmodeEventId_T eventId, extmodeEventTriggerEnable *triggerEnable)\n{\n    UNUSED_PARAMETER(eventId);\n\n    if (triggerEnable != NULL) {\n        *triggerEnable = NULL;\n    }\n\n    return EXTMODE_SUCCESS;\n}\n\nextmodeErrorCode_T extmodeSetEventTriggerEnable(extmodeEventId_T eventId, extmodeEventTriggerEnable triggerEnable)\n{\n    UNUSED_PARAMETER(eventId);\n    UNUSED_PARAMETER(triggerEnable);\n\n    return EXTMODE_SUCCESS;\n}\n\n#endif\n"},{"name":"xcp_ext_param_default_serial.c","type":"source","group":"legacy","path":"C:\\Users\\Sophie\\Documents\\Hochschule\\Master\\Systeme und Programme\\toolbox\\coder\\xcp\\src\\target\\ext_mode\\src","tag":"","groupDisplay":"Other files","code":"/*\n * Copyright 2017-2022 The MathWorks, Inc.\n *\n * File: xcp_ext_param_default_serial.c     \n *\n * Abstract:\n *  The file provides the implementation of the xcp_ext_param.h \n *  interface specific for the XCP Default Platform Abstraction Layer\n *  for the Serial transport layer.\n */\n\n#include \"rtwtypes.h\"\n\n#include \"rtw_extmode.h\"\n\n#include \"xcp_common.h\"\n#include \"xcp_ext_param.h\"\n\n#ifndef EXTMODE_DISABLE_ARGS_PROCESSING\n\n /** Transport Layer initialization parameters \n     @note the default values can be overwritten when parsing the\n           External Mode command line arguments */\nstatic const void* xcpTransportLayerParams[] =\n{\n    \"-port\", \"1\",\n    \"-baud\", \"57600\",\n    \"-verbose\", \"0\",\n};\n\n#endif /* EXTMODE_DISABLE_ARGS_PROCESSING */\n\nvoid xcpExtModeParseArgs(int_T argc, const char_T *argv[])\n{\n#ifdef  EXTMODE_DISABLE_ARGS_PROCESSING\n    /* Some targets do not support command line args */\n    UNUSED_PARAMETER(argc);\n    UNUSED_PARAMETER(argv);\n#else\n    if ((argv != NULL) && (argc > 0)) {\n        int_T optionId = 1;\n        uint_T idx;\n\n        while (optionId < argc) {\n            const char_T *option = argv[optionId];\n\n            optionId++;\n\n            if ((option != NULL) && (optionId != argc)) {\n                boolean_T isXcpOption = false;\n\n                for (idx = 0; idx < sizeof(xcpTransportLayerParams)/sizeof(xcpTransportLayerParams[0]); idx = idx + 2){\n                    if (strcmp(option, xcpTransportLayerParams[idx]) == 0) {\n                        xcpTransportLayerParams[idx+1] = argv[optionId];\n                        isXcpOption = true;\n                        break;\n                    }\n                }\n\n                if (isXcpOption) {\n                    /* Mark arguments as \"processed\" */\n                    argv[optionId - 1] = NULL;\n                    argv[optionId] = NULL;\n                }\n                \n                optionId++;\n            }\n        }\n    }\n#endif\n}\n\nvoid xcpTransportGetInitParameters(int_T *parNumber, void **parList[])\n{\n#ifdef  EXTMODE_DISABLE_ARGS_PROCESSING\n    if ((parNumber != NULL) && (parList != NULL)) {\n        /* No Transport Layer parameters defined (assuming rtiostream default) */\n        *parNumber = 0;\n        *parList = NULL;\n    }\n#else    \n    if ((parNumber != NULL) && (parList != NULL)) {\n        *parNumber = XCP_ELEMENTS_NUMBER(xcpTransportLayerParams);\n        *parList = (void **) &xcpTransportLayerParams;\n    }\n#endif\n}\n\nvoid xcpGetInitParameters(int_T *parNumber, void **parList[])\n{\n    if ((parNumber != NULL) && (parList != NULL)) {\n        /* No Protocol Layer parameters available at the moment */\n        *parNumber = 0;\n        *parList = NULL;\n    }\n}\n\n\n"},{"name":"xcp_fifo.c","type":"source","group":"legacy","path":"C:\\Users\\Sophie\\Documents\\Hochschule\\Master\\Systeme und Programme\\toolbox\\coder\\xcp\\src\\target\\server\\transport\\src","tag":"","groupDisplay":"Other files","code":"/*\n* Copyright 2016-2020 The MathWorks, Inc.\n*\n* File: xcp_fifo.c\n*\n* Abstract:\n*  Implementation of FIFO data structure based on single linked list\n*/\n\n#include \"xcp_common.h\"\n#include \"xcp_fifo.h\"\n\n\nvoid xcpFifoInit(struct xcpFifo * fifo)\n{\n    fifo->first = NULL;\n    fifo->last = &(fifo)->first;\n}\n\n\nvoid xcpFifoEnqueue(struct xcpFifo *fifo, struct xcpFifoEntry *element)\n{\n    element->next = NULL;\n    *(fifo)->last = element;\n    fifo->last = &(element->next);\n}\n\n\nvoid xcpFifoDequeue(struct xcpFifo *fifo, struct xcpFifoEntry **element)\n{\n    *element = fifo->first;\n\n    if (fifo->first != NULL) {\n        fifo->first = fifo->first->next;\n\n        if (fifo->first == NULL)\n            fifo->last = &(fifo)->first;\n    }\n}\n\n\nvoid xcpFifoEnqueueHead(struct xcpFifo *fifo, struct xcpFifoEntry *element)\n{\n    element->next = (fifo)->first;\n\n    if ((fifo)->first == NULL) {\n        (fifo)->last = &(element->next);\n    }\n\n    (fifo)->first = element;\n}\n\n\nvoid xcpFifoSpliceHead(struct xcpFifo *dstFifo, struct xcpFifo *srcFifo)\n{\n    if (srcFifo->first != NULL) {\n        *(srcFifo->last) = dstFifo->first;\n        dstFifo->first = srcFifo->first;\n         \n        srcFifo->first = NULL;\n        srcFifo->last = &(srcFifo)->first;\n    }\n}\n\n\nboolean_T xcpFifoEmpty(struct xcpFifo *fifo)\n{\n    return ((fifo)->first == NULL);\n}\n\n\nvoid xcpFifoReset(struct xcpFifo * fifo)\n{\n    xcpFifoInit(fifo);\n}\n"},{"name":"xcp_frame_serial.c","type":"source","group":"legacy","path":"C:\\Users\\Sophie\\Documents\\Hochschule\\Master\\Systeme und Programme\\toolbox\\coder\\xcp\\src\\target\\server\\transport\\src","tag":"","groupDisplay":"Other files","code":"/*\n* Copyright 2016-2023 The MathWorks, Inc.\n*\n* File: xcp_frame_serial.c\n*\n* Abstract:\n*  XCP Frame Handler implementation for the Serial transport layer.\n*/\n\n#include \"xcp_common.h\"\n#include \"xcp.h\"\n#include \"xcp_frame.h\"\n#include \"xcp_frame_serial.h\"\n#include \"xcp_drv.h\"\n#include \"xcp_mem.h\"\n#include \"xcp_types.h\"\n\n\n/* Frame Handler internal counters */\n#if XCP_SERIAL_USES_CTR\nstatic uintCTR_T txCounter = 0;\nstatic uintCTR_T rxCounter = 0;\nstatic int       firstRxCounterReceived = 0;\n#endif\n\n/* true if the Frame Handler has been successfully initialized */\nstatic boolean_T initialized = false;\n\n/* ID for of the memory pool reserved for the allocation of\n    CTO XCP Packets */\nstatic xcpPoolId_T xcpCtoReservedMemPoolId = -1;\n\n\nuint16_T xcpSxiHtons(uint16_T hostShort)\n{\n#ifndef XCP_BIG_ENDIAN\n    return hostShort;\n#else\n    return ((hostShort & 0xFF00) >> 8) | ((hostShort & 0x00FF) << 8);\n#endif\n}\n\n\nuint16_T xcpSxiNtohs(uint16_T networkShort)\n{\n    return xcpSxiHtons(networkShort);\n}\n\n#if XCP_SERIAL_USES_CS\n /*\n  * Checksum is calculated for all octets in a target memory location.\n  * length : number of target memory locations.\n  */\n#if XCP_ADDRESS_GRANULARITY == XCP_ADDRESS_GRANULARITY_BYTE\n    uintCS_T xcpSxiChecksum(const void *buffer, uintLEN_T length){\n        const uint8_T *buf = buffer;\n        uintCS_T checkSum = 0;\n        while (length-- > 0) {\n            /* buf is a uint8_T* so endian transformation is not required. */\n            checkSum += *buf++;\n        }\n        return checkSum;\n    }\n#elif XCP_ADDRESS_GRANULARITY == XCP_ADDRESS_GRANULARITY_WORD\n    uintCS_T xcpSxiChecksum(const void *buffer, uintLEN_T length){\n        const uint16_T *buf = buffer;\n        uintCS_T checkSum = 0;\n        while (length-- > 0){\n            checkSum += *buf & 0x00FF;\n            checkSum += (*buf++) >> 8;\n        }\n        return checkSum;\n    }\n#endif\n\n#endif\n\nXcpErrorCode xcpFrameInit(\n    int   argc,   /**< [in] number of init parameters              */\n    void *argv[]  /**< [in] array of parameters values (C strings) */\n    )\n{\n    XcpErrorCode errorCode = XCP_SUCCESS;\n\n    XCP_ERROR_IF(initialized, XCP_ERROR, \"xcpFrameInit: frame handler already initialized\\n\");\n\n    /* Open the XCP driver */\n    errorCode = xcpDrvOpen(argc, argv);\n    if (errorCode == XCP_SUCCESS) {\n#if XCP_SERIAL_USES_CTR\n        txCounter = 0;\n        rxCounter = 0;\n        firstRxCounterReceived = 0;\n#endif\n        initialized = true;\n    }\n\n    return errorCode;\n}\n\n\nXcpErrorCode xcpFrameMsgSend(\n    void    *msgBuffer,  /**< [in] pointer to the base address of the buffer where the message is stored */\n    size_t   msgOffset,  /**< [in] offset (from base address in AG units) where the XCP message frame is stored */\n    size_t   msgSize     /**< [in] size (in AG units) of XCP message frame */\n    )\n{\n    /* This function works properly only if the XCP_SERIAL_HEADER_FORMAT is LEN_WORD_CTR_WORD and \n     * XCP_SERIAL_TAIL_FORMAT is CHECKSUM_WORD.\n     */\n    uint8_T *bufferPtr = NULL;\n    struct XcpHeader *header = NULL;\n    uintLEN_T lengthInBytes = 0;\n    XcpErrorCode errorCode = XCP_SUCCESS;\n\n#if XCP_SERIAL_USES_CS\n    uintCS_T checksum;\n    struct XcpTail *tail;\n#endif\n\n    XCP_ERROR_IF(msgBuffer == NULL, XCP_INV_ARG, \"xcpFrameMsgSend: invalid msgBuffer\\n\");\n    XCP_ERROR_IF(msgSize < sizeof(struct XcpHeader) + XCP_IN_AG(XCP_SERIAL_TAIL_SIZE), XCP_INV_ARG, \"xcpFrameMsgSend: invalid msgSize\\n\");\n    XCP_ERROR_IF(!initialized, XCP_NOT_INITIALIZED, \"xcpFrameMsgSend: frame handler not initialized\\n\");\n\n    bufferPtr = (uint8_T *) msgBuffer + msgOffset;\n\n    header = (struct XcpHeader *) bufferPtr;\n    lengthInBytes = LenSxiNtoH(header->length);\n\n    if ( ( lengthInBytes == 0 ) ||\n         ( msgSize < ( sizeof(struct XcpHeader) + XCP_IN_AG(XCP_SERIAL_TAIL_SIZE) + XCP_IN_AG(lengthInBytes) ) )\n       ) {\n        XCP_PRINTF(\"xcpFrameMsgSend: invalid message format detected\\n\");\n        return XCP_INV_MSG_FORMAT;\n    }\n\n#if XCP_SERIAL_USES_CTR\n    /* Set the value of the transport layer txCounter immediately before\n     * sending the message so that it reflects the correct order for the\n     * sequence of frames that are sent rather than the sequence in which\n     * they are constructed (which could be different in the case where\n     * there are multiple prioritized queues). */\n    header->counter = CtrSxiHtoN(txCounter);\n#endif\n\n#if XCP_SERIAL_USES_CS\n    tail = (struct XcpTail *) ((char *) header + sizeof(struct XcpHeader) + XCP_IN_AG(lengthInBytes));\n    checksum = CsSxiHtoN(xcpSxiChecksum(header, sizeof(struct XcpHeader) + XCP_IN_AG(lengthInBytes)));\n    XCP_MEMCPY(&tail->cs, &checksum, sizeof(tail->cs));\n#endif\n\n    /* Send the XCP Frame Header\n     * If the xcpDrvSend() is blocking, the return code should be XCP_SUCCESS\n     * If the xcpDrvSend() is non-blocking, the return code could be XCP_SUCCESS or XCP_BUSY.\n     * If something went wrong we should get XCP_ERROR or XCP_PKT_TX_TIMEOUT_ERROR */\n    errorCode = xcpDrvSend(bufferPtr, XCP_SERIAL_HEADER_SIZE);\n    if(errorCode != XCP_SUCCESS){\n        return errorCode;\n    }\n    bufferPtr += XCP_IN_AG(XCP_SERIAL_HEADER_SIZE);\n\n    /* Since have already started sending the packet, we should wait until \n     * the remaining part is sent, or a XCP_PKT_TX_TIMEOUT_ERROR has occurred.\n     * For this reason we force the subsequent xcpDrvRecv to be blocking */\n    xcpDrvIoctl(XCP_DRV_FORCE_BLOCKING);\n\n    /* Send the XCP Packet */\n    errorCode = xcpDrvSend(bufferPtr, lengthInBytes);\n    if(errorCode != XCP_SUCCESS){\n        goto txError;\n    }\n    bufferPtr += XCP_IN_AG(lengthInBytes);\n\n    /* Send the XCP Frame Tail */\n    errorCode = xcpDrvSend(bufferPtr, XCP_SERIAL_TAIL_SIZE);\n    if (errorCode != XCP_SUCCESS){\n        goto txError;\n    }\n\n    /* If successfully sent, the buffer can be freed */\n    if (errorCode == XCP_SUCCESS) {\n        xcpMemFree(msgBuffer);\n    }\n\n#if XCP_SERIAL_USES_CTR\n    /* Don't increment the counter if the transfer of the packet is delayed\n       due to the transport layer being busy. */\n    if (errorCode != XCP_BUSY) {\n        txCounter++;\n    }\n#endif\n\ntxError:\n    /* The packet has been sent, or an error occurred. In any case\n     * we can restore the default blocking/non-blocking behavior */\n    xcpDrvIoctl(XCP_DRV_RESTORE_DEFAULT_BLOCKING_SETUP);\n\n    return errorCode;\n}\n\n\nXcpErrorCode xcpFrameMsgRecv(\n    void  **msgBuffer,  /**< [out] pointer to the base address of the buffer where the message is stored */\n    size_t  msgOffset,  /**< [in] offset (from base address in AG units) where the XCP message frame is stored */\n    size_t *msgSize     /**< [out] size (in AG units) of the XCP message frame that has been received */\n    )\n{\n    XcpErrorCode errorCode = XCP_SUCCESS;\n    struct XcpHeader rxHeader;\n    uintLEN_T lengthInBytes = 0;\n    uint8_T *buffer;\n    uint8_T *bufferPtr;\n\n    XCP_ERROR_IF(msgBuffer == NULL, XCP_INV_ARG, \"xcpFrameMsgRecv: invalid msgBuffer pointer\\n\");\n    XCP_ERROR_IF(msgSize == NULL, XCP_INV_ARG, \"xcpFrameMsgRecv: invalid msgSize pointer\\n\");\n    XCP_ERROR_IF(!initialized, XCP_NOT_INITIALIZED, \"xcpFrameMsgRecv: frame handler not initialized\\n\");\n\n    /* Receive message header first.\n     * If the xcpDrvRecv() is blocking, the return code should be XCP_SUCCESS\n     * If the xcpDrvRecv() is non-blocking, the return code could be XCP_SUCCESS or XCP_EMPTY\n     * If something went wrong we should get XCP_ERROR or XCP_PKT_RX_TIMEOUT_ERROR */\n    errorCode = xcpDrvRecv(&rxHeader, XCP_SERIAL_HEADER_SIZE);\n    if (errorCode != XCP_SUCCESS) {\n        return errorCode;\n    }\n\n    /* Infer the number of BYTES in the XCP Packet from the received header.\n     * This may not be a multiple of XCP_ADDRESS_GRANULARITY */\n    lengthInBytes = LenSxiNtoH(rxHeader.length);\n    if (lengthInBytes == 0) {\n        XCP_PRINTF(\"xcpFrameMsgRecv: invalid message format detected\\n\");\n        errorCode = XCP_INV_MSG_FORMAT;\n        return errorCode;\n    }\n\n    /* Request to the XCP allocator the memory for the message to be received.\n     * STIM packets are not supported at the moment. For this reason\n     * the XCP Server can only receive CTOs */\n    buffer = xcpMemAllocFromPool(xcpCtoReservedMemPoolId,\n                msgOffset\n                + XCP_IN_AG(XCP_SERIAL_HEADER_SIZE)\n                + XCP_IN_AG(lengthInBytes)\n                + XCP_IN_AG(XCP_SERIAL_TAIL_SIZE) );\n\n    if (buffer == NULL) {\n        errorCode = XCP_NO_MEMORY;\n        return errorCode;\n    }\n\n    bufferPtr = buffer;\n\n    /* Initialize the header part */\n    XCP_MEMSET(bufferPtr, 0, msgOffset);\n    bufferPtr += msgOffset;\n\n    XCP_MEMCPY(bufferPtr, &rxHeader, sizeof(rxHeader));\n    bufferPtr += sizeof(rxHeader);\n\n    /* Since have already started receiving the packet, we should wait until\n     * the remaining part is received, or a XCP_PKT_RX_TIMEOUT_ERROR has occurred.\n     * For this reason we force the subsequent xcpDrvRecv to be blocking */\n    xcpDrvIoctl(XCP_DRV_FORCE_BLOCKING);\n\n    /* Receive the XCP packet */\n    errorCode = xcpDrvRecv(bufferPtr, lengthInBytes);\n    if (errorCode != XCP_SUCCESS) {\n        XCP_PRINTF(\"xcpFrameMsgRecv: received XCP header, but XCP packet is not available or packet size is incorrect\\n\");\n        errorCode = XCP_INV_MSG_FORMAT;\n        goto rxError;\n    }\n\n    bufferPtr  += XCP_IN_AG(lengthInBytes);\n\n    /* Receive the XCP packet */\n    errorCode = xcpDrvRecv(bufferPtr, XCP_SERIAL_TAIL_SIZE);\n\n    if (errorCode != XCP_SUCCESS) {\n        XCP_PRINTF(\"xcpFrameMsgRecv: received XCP header and XCP packet, but XCP tail is not available or packet size is incorrect\\n\");\n        errorCode = XCP_INV_MSG_FORMAT;\n        goto rxError;\n    }\n\n    /* The packet has been received, so we can restore\n     * the default blocking/non-blocking behavior */\n    xcpDrvIoctl(XCP_DRV_RESTORE_DEFAULT_BLOCKING_SETUP);\n\n    *msgBuffer = buffer;\n    *msgSize = sizeof(rxHeader) + XCP_IN_AG(lengthInBytes) + XCP_IN_AG(XCP_SERIAL_TAIL_SIZE);\n\n    return errorCode;\n\nrxError:\n    /* An error occurred while receiving a packet, so we can restore\n     * the default blocking/non-blocking behavior */\n    xcpDrvIoctl(XCP_DRV_RESTORE_DEFAULT_BLOCKING_SETUP);\n\n    *msgBuffer = NULL;\n    *msgSize = 0;\n    xcpMemFree(buffer);\n\n    return errorCode;\n}\n\n\nXcpErrorCode xcpFrameCreateMsg(\n    void        *msgFrame,           /**< [out] pointer to the buffer containing the full message frame */\n    size_t       msgFrameBufferSize, /**< [in]  max size (in AG units) of the buffer where the message frame is copied */\n    size_t      *msgFrameSize,       /**< [out] size (in AG units) of the generated msg frame */\n    size_t       xcpPacketSize       /**< [in]  size (in BYTEs) of the XCP packet. */\n    )\n{\n    struct XcpHeader *header = (struct XcpHeader *) msgFrame;\n\n    /* Input parameters validation */\n    XCP_ERROR_IF(msgFrame == NULL, XCP_INV_ARG, \"xcpFrameCreateMsg: invalid msgFrame buffer\\n\");\n    XCP_ERROR_IF(msgFrameSize == NULL, XCP_INV_ARG, \"xcpFrameCreateMsg: invalid msgFrameSize pointer\\n\");\n    XCP_ERROR_IF(xcpPacketSize == 0, XCP_INV_ARG, \"xcpFrameCreateMsg: invalid xcpPacketSize\\n\");\n    XCP_ERROR_IF(msgFrameBufferSize < (XCP_IN_AG(xcpPacketSize) + sizeof(struct XcpHeader) + XCP_IN_AG(XCP_SERIAL_TAIL_SIZE)), XCP_INV_ARG, \"xcpFrameCreateMsg: invalid msgFrameBufferSize\\n\");\n\n    /* update XCP header */\n    /* header->length = number of BYTES in the XCP Packet */\n    header->length = LenSxiHtoN((uint16_T)xcpPacketSize);\n\n    *msgFrameSize = XCP_IN_AG(xcpPacketSize) + sizeof(struct XcpHeader) + XCP_IN_AG(XCP_SERIAL_TAIL_SIZE);\n\n    return XCP_SUCCESS;\n}\n\n\nXcpErrorCode xcpFrameExtractPacket(\n    const void  *msgFrame,      /**< [in]  pointer to the buffer containing full message frame content */\n    size_t       msgFrameSize,  /**< [in]  size (in AG units) of the full message frame */\n    size_t      *xcpPacketSize  /**< [out] size (in BYTEs) of the XCP packet that has been processed */\n    )\n{\n    const struct XcpHeader *header = (const struct XcpHeader *) msgFrame;\n    uintLEN_T length = 0;\n#if XCP_SERIAL_USES_CTR\n    uintCTR_T counter = 0;\n#endif\n#if XCP_SERIAL_USES_CS\n    const struct XcpTail *tail;\n    uintCS_T checksum = 0;\n#endif\n    XcpErrorCode errorCode = XCP_SUCCESS;\n\n    /* Input parameters validation */\n    XCP_ERROR_IF(msgFrame == NULL, XCP_INV_ARG, \"xcpFrameExtractPacket: invalid msgFrame\\n\");\n    XCP_ERROR_IF(xcpPacketSize == NULL, XCP_INV_ARG, \"xcpFrameExtractPacket: invalid xcpPacketSize pointer\\n\");\n    XCP_ERROR_IF(msgFrameSize <= sizeof(struct XcpHeader), XCP_INV_ARG, \"xcpFrameExtractPacket: invalid msgFrameSize\\n\");\n    XCP_ERROR_IF(!initialized, XCP_NOT_INITIALIZED, \"xcpFrameExtractPacket: frame handler not initialized\\n\");\n\n    /* Extract info from the received message */\n    length = LenSxiNtoH(header->length);\n#if XCP_SERIAL_USES_CTR\n    counter = CtrSxiNtoH(header->counter);\n#endif\n\n    /* Check message length */\n    if (msgFrameSize != (XCP_IN_AG(length) + XCP_IN_AG(XCP_SERIAL_HEADER_SIZE) + XCP_IN_AG(XCP_SERIAL_TAIL_SIZE))) {\n        XCP_PRINTF(\"xcpFrameExtractPacket: Xcp packet has an invalid size\\n\");\n        return XCP_INV_MSG_FORMAT;\n    }\n\n#if XCP_SERIAL_USES_CTR\n    /* Check message counter */\n    if (!firstRxCounterReceived) {\n        /* No checks can be carried out the first time */\n        firstRxCounterReceived = 1;\n    }\n    else {\n        if (counter < (rxCounter + 1)) {\n            errorCode = XCP_PKT_OUT_OF_SEQUENCE;\n        }\n        else if (counter >(rxCounter + 1)) {\n            errorCode = XCP_PKT_LOST;\n        }\n    }\n    rxCounter = counter;\n#endif\n\n    /* Verify the checksum */\n#if XCP_SERIAL_USES_CS\n    tail = (const struct XcpTail *) ((const char *) msgFrame + sizeof(struct XcpHeader) + XCP_IN_AG(length));\n    XCP_MEMCPY(&checksum, &tail->cs, sizeof(checksum));\n    checksum = CsSxiNtoH(checksum);\n    XCP_ERROR_IF(checksum != xcpSxiChecksum(header, sizeof(struct XcpHeader) + XCP_IN_AG(length)), XCP_PKT_CHECKSUM_ERROR, \"xcpFrameExtractPacket: invalid checksum\\n\");\n#endif\n    *xcpPacketSize = length;\n\n    return errorCode;\n}\n\n/* Returns the number of BYTEs in an XCP Frame Header */\nsize_t xcpFrameHeaderSize(void)\n{\n    return XCP_SERIAL_HEADER_SIZE;\n}\n\n/* Returns the number of BYTEs in an XCP Tail */\nsize_t xcpFrameTailSize(void)\n{\n    return XCP_SERIAL_TAIL_SIZE;\n}\n\n\nsize_t xcpFrameMaxDtoSize(void)\n{\n    return XCP_MAX_DTO_SIZE;\n}\n\n\nsize_t xcpFrameMaxCtoSize(void)\n{\n    return XCP_MAX_CTO_SIZE;\n}\n\n\nXcpErrorCode xcpFrameRestart(void)\n{\n#if XCP_SERIAL_USES_CTR\n    txCounter = 0;\n    rxCounter = 0;\n    firstRxCounterReceived = 0;\n#endif\n\n    return XCP_SUCCESS;\n}\n\n\nvoid xcpFrameSetCtoReservedMemPoolId(xcpPoolId_T poolId)\n{\n    xcpCtoReservedMemPoolId = poolId;\n}\n\n\nXcpErrorCode xcpFrameReset(void)\n{\n    XcpErrorCode errorCode = XCP_SUCCESS;\n\n    if (!initialized) {\n        XCP_PRINTF(\"xcpFrameReset: frame handler already reset\\n\");\n        return XCP_SUCCESS; /* Nothing to do: just printing out a warning message*/\n    }\n\n    /* Close the actual communication channel */\n    errorCode = xcpDrvClose();\n    if (errorCode == XCP_SUCCESS) {\n#if XCP_SERIAL_USES_CTR\n        txCounter = 0;\n        rxCounter = 0;\n        firstRxCounterReceived = 0;\n#endif\n        initialized = false;\n    } else {\n        XCP_PRINTF(\"xcpFrameReset: xcpDrvClose error\\n\");\n    }\n\n    return errorCode;\n}\n"},{"name":"xcp_mem_default.c","type":"source","group":"legacy","path":"C:\\Users\\Sophie\\Documents\\Hochschule\\Master\\Systeme und Programme\\toolbox\\coder\\xcp\\src\\target\\server\\platform\\default","tag":"","groupDisplay":"Other files","code":"/*\n* Copyright 2016-2023 The MathWorks, Inc.\n*\n* File: xcp_mem_default.c\n*\n* Abstract:\n*  Implementation of default XCP Server memory allocator\n*/\n\n#include \"xcp_common.h\"\n#include \"xcp_mem.h\"\n#include \"xcp_mem_default.h\"\n#include \"xcp_utils.h\"\n\n#define PADDING (XCP_MEM_ALIGNMENT-1)\n\n/* Array of XcpMemPoolDescriptor for each block size to allow freeing and\n   allocating blocks.\n\n   @note this includes both the Main Memory area and the Reserved Pools\n         Memory Area */\nstatic XcpMemPoolDescriptor xcpMemPoolDescriptors[XCP_MEM_MAIN_RESERVED_POOL_NUMBER];\n\n/* xcpMemCustomPoolDescriptor stores the custom memory functions to allocate and\n   free memory for a specific memory pool */\nstatic XcpMemCustomPoolDescriptor xcpMemCustomPoolDescriptors[XCP_MEM_CUSTOM_POOL_MAX_NUMBER];\n\n\n/* Main memory chunk from which blocks are allocated using the xcpMemAlloc\n * This may not be aligned to XCP_MEM_ALIGNMENT depending on the compiler \n * and/or build flags.\n * Add padding bytes to the end to enable aligning blocks in xcpMemMainChunk\n * to aligned addresses if needed.\n */\nXCP_MEM_DATA_SECTION_BEGIN\nstatic uint8_T xcpMemMainChunk[XCP_MEM_MAIN_TOTAL_SIZE + PADDING];\nXCP_MEM_DATA_SECTION_END\n\n\n/* Reserved pools memory chunk from which pool blocks are allocated using the\n * xcpMemAllocFromPool()\n * Also refer to comments in xcpMemMainChunk\n */\nXCP_MEM_DATA_SECTION_BEGIN\nstatic uint8_T xcpMemReservedPoolsChunk[XCP_MEM_RESERVED_POOLS_TOTAL_SIZE + PADDING];\nXCP_MEM_DATA_SECTION_END\n\nstatic size_t  xcpMemReservedPoolsChunkUsedBytes;\n\n/* Mutex to prevent concurrent access to xcpMemPoolDescriptors, xcpMemMainChunk\n   and xcpMemReservedPoolsChunk\n   @note: the insertion/removal of blocks within each reserved pool is protected by a dedicated\n          lock, to reduce the interference between threads in multi-core applications */\nstatic XCP_MUTEX_DEFINE(xcpMemLock);\n\n\n/* Initialize pool's memory chunk, by creating the pool's memory blocks and as a linked list */\nstatic void xcpInitializePoolMemoryArea(uint8_T *memoryPtr, size_t blockSize, size_t blocksNumber)\n{\n    if (memoryPtr != NULL) {\n        XcpMemHeader *p, *prev = NULL;\n        size_t i;\n        /* Initialize memory to zero */\n        size_t totSize = XCP_MEM_BLOCK_SIZE_WITH_OVERHEAD(blockSize) * blocksNumber;\n        XCP_MEMSET(memoryPtr,  0, totSize);\n\n        for(i = 0 ; i < blocksNumber; ++i) {\n            p = (XcpMemHeader*) memoryPtr;\n            p -> next = NULL;\n            p -> poolId = XCP_FREE_POOL_ID;\n            if (prev) {\n                prev -> next = p;\n            }\n            memoryPtr += XCP_MEM_BLOCK_SIZE_WITH_OVERHEAD(blockSize);\n            prev = p;\n        }\n    }\n}\n\nXcpErrorCode xcpMemInit(void)\n{\n    uint8_T poolIdx;\n    uint8_T *memoryPtr = (uint8_T *)XCP_ALIGNED(xcpMemMainChunk);\n\n    XCP_MUTEX_INIT(xcpMemLock);\n\n\n#ifndef XCP_NO_MAIN_MEM_ALLOCATED\n    /* Sort main memory block */\n    xcpSortArray(xcpMemMainBlockSizes, xcpMemMainBlocksNumber, (size_t)XCP_MEM_MAIN_POOLS_NUMBER);\n\n    /* Initialize Main memory */\n    for(poolIdx = 0; poolIdx < XCP_MEM_MAIN_POOLS_NUMBER; ++poolIdx) {\n        size_t blocksCount = xcpMemMainBlocksNumber[poolIdx];\n        size_t blockSize = xcpMemMainBlockSizes[poolIdx];\n\n        xcpMemPoolDescriptors[poolIdx].head = (XcpMemHeader*) memoryPtr;\n        xcpMemPoolDescriptors[poolIdx].totalBlocksCount = blocksCount;\n        xcpMemPoolDescriptors[poolIdx].freeBlocksCount = blocksCount;\n        xcpMemPoolDescriptors[poolIdx].blockSize = blockSize;\n        xcpMemPoolDescriptors[poolIdx].poolSize =\n            blocksCount * XCP_MEM_BLOCK_SIZE_WITH_OVERHEAD(blockSize);\n#ifdef XCP_MEM_RESERVED_POOLS_LOCKLESS_SUPPORT\n        xcpMemPoolDescriptors[poolIdx].deferredFreeHead = NULL;\n        xcpMemPoolDescriptors[poolIdx].deferredFreeTail = NULL;\n        xcpMemPoolDescriptors[poolIdx].deferredFreeBlocksCount = 0;\n#else\n        XCP_MUTEX_INIT(xcpMemPoolDescriptors[poolIdx].lock);\n#endif\n\n        xcpInitializePoolMemoryArea(memoryPtr, blockSize, blocksCount);\n        memoryPtr += xcpMemPoolDescriptors[poolIdx].poolSize;\n    }\n#else\n    (void)memoryPtr;\n#endif\n\n    /* Initialize Reserved pools memory\n       @note since the allocation of the memory pools is dynamic,\n             the creation of the blocks for each pool is deferred\n             and carried out within the xcpMemReservedPoolCreate() */\n    XCP_MEMSET(xcpMemReservedPoolsChunk, 0, sizeof(xcpMemReservedPoolsChunk));\n    xcpMemReservedPoolsChunkUsedBytes = 0;\n\n    for(poolIdx = XCP_MEM_MAIN_POOLS_NUMBER; poolIdx < XCP_MEM_MAIN_RESERVED_POOL_NUMBER; ++poolIdx) {\n        xcpMemPoolDescriptors[poolIdx].head = XCP_FREE_POOL;\n        xcpMemPoolDescriptors[poolIdx].totalBlocksCount = 0;\n        xcpMemPoolDescriptors[poolIdx].freeBlocksCount = 0;\n        xcpMemPoolDescriptors[poolIdx].blockSize = 0;\n        xcpMemPoolDescriptors[poolIdx].poolSize = 0;\n#ifdef XCP_MEM_RESERVED_POOLS_LOCKLESS_SUPPORT\n        xcpMemPoolDescriptors[poolIdx].deferredFreeHead = NULL;\n        xcpMemPoolDescriptors[poolIdx].deferredFreeTail = NULL;\n        xcpMemPoolDescriptors[poolIdx].deferredFreeBlocksCount = 0;\n#else\n        XCP_MUTEX_INIT(xcpMemPoolDescriptors[poolIdx].lock);\n#endif\n    }\n\n    for(poolIdx = 0; poolIdx < XCP_MEM_CUSTOM_POOL_MAX_NUMBER; poolIdx++) {\n        xcpMemCustomPoolDescriptors[poolIdx].allocHandler = NULL;\n        xcpMemCustomPoolDescriptors[poolIdx].freeHandler = NULL;\n    }\n\n    return XCP_SUCCESS;\n}\n\n\nvoid* xcpMemAlloc(size_t size)\n{\n\n#ifndef XCP_NO_MAIN_MEM_ALLOCATED\n\n    uint8_T poolIdx;\n    size_t blockSize = 0;\n    XcpMemHeader *poolHead = NULL;\n\n    /* a size of 0 is considered an invalid argument */\n    if (size == 0) {\n        return NULL;\n    }\n\n    XCP_MUTEX_LOCK(xcpMemLock);\n\n    /* find the first large enough pool */\n    for(poolIdx = 0; poolIdx <  XCP_MEM_MAIN_POOLS_NUMBER; ++poolIdx) {\n        blockSize = xcpMemMainBlockSizes[poolIdx];\n        if ((size <= blockSize) && (xcpMemPoolDescriptors[poolIdx].freeBlocksCount > 0)) {\n            poolHead = xcpMemPoolDescriptors[poolIdx].head;\n            break;\n        }\n    }\n\n    if (!poolHead) { /* size is too large, or there are no more free blocks */\n       XCP_MUTEX_UNLOCK(xcpMemLock);\n       return NULL;\n    }\n\n    xcpMemPoolDescriptors[poolIdx].head = poolHead->next;\n    (xcpMemPoolDescriptors[poolIdx].freeBlocksCount)--;\n    poolHead->poolId = poolIdx;\n\n    XCP_MUTEX_UNLOCK(xcpMemLock);\n\n    /* return a pointer past just the poolId */\n    return ((uint8_T*) poolHead) + XCP_MEM_POOLID_SIZE;\n\n#else\n\n    (void)size;\n    return NULL;\n\n#endif\n\n}\n\n\nvoid xcpMemFree(void *ptr)\n{\n    if (ptr) {\n        /* the XcpMemHeader cell is 'behind' the user's pointer */\n        XcpMemHeader *hd = (XcpMemHeader*) ((uint8_T*)ptr - XCP_MEM_POOLID_SIZE);\n        uint8_T poolIdx = hd -> poolId;\n\n        if (poolIdx >= XCP_MEM_CUSTOM_POOLS_OFFSET && poolIdx < XCP_MEM_CUSTOM_POOLS_UPPER_BOUND) {\n            poolIdx = poolIdx - XCP_MEM_CUSTOM_POOLS_OFFSET;\n            if (xcpMemCustomPoolDescriptors[poolIdx].freeHandler) {\n                /* For custom memory pools, protection against concurrent\n                   exclusion must be guaranteed within the custom free method */\n                xcpMemCustomPoolDescriptors[poolIdx].freeHandler((uint8_T*)ptr - XCP_MEM_POOLID_SIZE);\n            }\n            return;\n        }\n\n        if ((poolIdx == XCP_FREE_POOL_ID) || (poolIdx >= XCP_MEM_MAIN_RESERVED_POOL_NUMBER)){\n            /* ill-formed block or already freed pointer */\n            XCP_PRINTF(\"xcpMemFree: invalid or double-freed pointer %p\\n\", ptr);\n            return;\n        }\n\n#ifndef XCP_NO_MAIN_MEM_ALLOCATED\n        /* insert the new free block in the front of the pool */\n        if (poolIdx < XCP_MEM_MAIN_POOLS_NUMBER) {\n            XCP_MUTEX_LOCK(xcpMemLock);\n\n            hd -> poolId = XCP_FREE_POOL_ID;\n            hd -> next = xcpMemPoolDescriptors[poolIdx].head;\n\n            xcpMemPoolDescriptors[poolIdx].head = hd;\n            ++(xcpMemPoolDescriptors[poolIdx].freeBlocksCount);\n\n            XCP_MUTEX_UNLOCK(xcpMemLock);\n        }\n        else\n#endif\n        {\n        #ifdef XCP_MEM_RESERVED_POOLS_LOCKLESS_SUPPORT\n            /* If lockless support is enabled, the freed memory block is\n               not immediately available for subsequent allocations,\n               until xcpMemReservedPoolFlushFreeMem is invoked */\n            hd -> poolId = XCP_FREE_POOL_ID;\n            hd -> next = xcpMemPoolDescriptors[poolIdx].deferredFreeHead;\n\n            if (xcpMemPoolDescriptors[poolIdx].deferredFreeTail == NULL) {\n                /* Let's save a reference to the first block in the pool\n                   that has been freed */\n                xcpMemPoolDescriptors[poolIdx].deferredFreeTail = hd;\n            }\n\n            xcpMemPoolDescriptors[poolIdx].deferredFreeHead = hd;\n            ++(xcpMemPoolDescriptors[poolIdx].deferredFreeBlocksCount);\n        #else\n            XCP_MUTEX_LOCK(xcpMemPoolDescriptors[poolIdx].lock);\n\n            hd -> poolId = XCP_FREE_POOL_ID;\n            hd -> next = xcpMemPoolDescriptors[poolIdx].head;\n\n            xcpMemPoolDescriptors[poolIdx].head = hd;\n            ++(xcpMemPoolDescriptors[poolIdx].freeBlocksCount);\n            XCP_MUTEX_UNLOCK(xcpMemPoolDescriptors[poolIdx].lock);\n        #endif\n        }\n    }\n}\n\n\nXcpErrorCode xcpMemReservedPoolCreate(size_t blockSize, size_t blocksNumber, xcpPoolId_T* poolId)\n{\n    uint8_T poolIdx;\n    uint8_T *currentHead = (uint8_T *) XCP_ALIGNED(xcpMemReservedPoolsChunk);\n    XcpErrorCode errorCode = XCP_SUCCESS;\n\n    xcpPoolId_T pool = XCP_INVALID_POOL_ID;\n    size_t requestedPoolSize;\n\n    if ((poolId == NULL) || (blockSize == 0) || (blocksNumber == 0)) {\n        XCP_PRINTF(\"xcpMemReservedPoolCreate: invalid input parameter\\n\");\n        return XCP_INV_ARG;\n    }\n\n    /* blockSize needs to be a multiple of XCP_MEM_ALIGNMENT in order to align blocks to aligned addresses.\n     * If the size is not a multiple, adjustment is done here.\n     */\n    blockSize = (size_t) XCP_ALIGNED(blockSize);\n\n    requestedPoolSize = blocksNumber * XCP_MEM_BLOCK_SIZE_WITH_OVERHEAD(blockSize);\n\n    XCP_MUTEX_LOCK(xcpMemLock);\n\n    for(poolIdx = XCP_MEM_MAIN_POOLS_NUMBER; poolIdx < XCP_MEM_MAIN_RESERVED_POOL_NUMBER; ++poolIdx) {\n        if (xcpMemPoolDescriptors[poolIdx].head == XCP_FREE_POOL) {\n            /* The pool is free, let's check if it is big enough */\n            if ((xcpMemPoolDescriptors[poolIdx].poolSize) == 0) {\n                /* The pool has never been allocated before, so this must be the last\n                   usable pool in the list */\n                if (requestedPoolSize <= (XCP_MEM_RESERVED_POOLS_TOTAL_SIZE - xcpMemReservedPoolsChunkUsedBytes)) {\n                    /* It is big enough, so let's mark it as allocated */\n                    xcpMemPoolDescriptors[poolIdx].head = (XcpMemHeader*) currentHead;\n                    xcpMemPoolDescriptors[poolIdx].totalBlocksCount = blocksNumber;\n                    xcpMemPoolDescriptors[poolIdx].freeBlocksCount = blocksNumber;\n                    xcpMemPoolDescriptors[poolIdx].blockSize = blockSize;\n                    xcpMemPoolDescriptors[poolIdx].poolSize = requestedPoolSize;\n                #ifdef XCP_MEM_RESERVED_POOLS_LOCKLESS_SUPPORT\n                    xcpMemPoolDescriptors[poolIdx].deferredFreeHead = NULL;\n                    xcpMemPoolDescriptors[poolIdx].deferredFreeTail = NULL;\n                    xcpMemPoolDescriptors[poolIdx].deferredFreeBlocksCount = 0;\n                #endif\n\n                    xcpInitializePoolMemoryArea(currentHead, blockSize, blocksNumber);\n                    xcpMemReservedPoolsChunkUsedBytes += requestedPoolSize;\n\n                    pool = poolIdx;\n                }\n                break; /* No more pools to process, exit from the loop */\n            } else {\n                /* The pool has already been allocated so it can't be re-sized */\n                if (requestedPoolSize <= xcpMemPoolDescriptors[poolIdx].poolSize) {\n                    /* It is big enough, so let's mark it as allocated */\n                    xcpMemPoolDescriptors[poolIdx].head = (XcpMemHeader*) currentHead;\n                    xcpMemPoolDescriptors[poolIdx].totalBlocksCount = blocksNumber;\n                    xcpMemPoolDescriptors[poolIdx].freeBlocksCount = blocksNumber;\n                    xcpMemPoolDescriptors[poolIdx].blockSize = blockSize;\n                #ifdef XCP_MEM_RESERVED_POOLS_LOCKLESS_SUPPORT\n                    xcpMemPoolDescriptors[poolIdx].deferredFreeHead = NULL;\n                    xcpMemPoolDescriptors[poolIdx].deferredFreeTail = NULL;\n                    xcpMemPoolDescriptors[poolIdx].deferredFreeBlocksCount = 0;\n                #endif\n\n                    xcpInitializePoolMemoryArea(currentHead, blockSize, blocksNumber);\n                    pool = poolIdx;\n                    break; /* We found what we were looking for, exit from the loop */\n                }\n            }\n        }\n\n        /* Let's continue to see if there are bigger memory areas available */\n        currentHead += xcpMemPoolDescriptors[poolIdx].poolSize;\n    }\n\n    XCP_MUTEX_UNLOCK(xcpMemLock);\n\n    if (pool == XCP_INVALID_POOL_ID) {\n        errorCode = XCP_NO_MEMORY;\n    }\n\n    *poolId = pool;\n\n    return errorCode;\n}\n\n\nXcpErrorCode xcpMemReservedPoolDestroy(xcpPoolId_T poolId)\n{\n    uint8_T poolIdx;\n    boolean_T isLastPool = true;\n\n    if ((poolId < XCP_MEM_MAIN_POOLS_NUMBER) || (poolId >= XCP_MEM_MAIN_RESERVED_POOL_NUMBER)) {\n        XCP_PRINTF(\"xcpMemReservedPoolDestroy: invalid input parameter\\n\");\n        return XCP_INV_ARG;\n    }\n\n    XCP_MUTEX_LOCK(xcpMemLock);\n\n    /* Check if the pool is the last one (i.e. the used pool with the highest id) */\n    for(poolIdx = (XCP_MEM_MAIN_RESERVED_POOL_NUMBER - 1); poolIdx > poolId; --poolIdx) {\n        if ((xcpMemPoolDescriptors[poolIdx].head != XCP_FREE_POOL) ||\n            (xcpMemPoolDescriptors[poolIdx].poolSize != 0)) {\n            isLastPool = false;\n            break; /* the pool is not the last, exit from the loop */\n        }\n    }\n\n    xcpMemPoolDescriptors[poolId].head = XCP_FREE_POOL;\n    xcpMemPoolDescriptors[poolId].totalBlocksCount = 0;\n    xcpMemPoolDescriptors[poolId].freeBlocksCount = 0;\n    xcpMemPoolDescriptors[poolId].blockSize = 0;\n\n#ifdef XCP_MEM_RESERVED_POOLS_LOCKLESS_SUPPORT\n    xcpMemPoolDescriptors[poolId].deferredFreeHead = NULL;\n    xcpMemPoolDescriptors[poolId].deferredFreeTail = NULL;\n    xcpMemPoolDescriptors[poolId].deferredFreeBlocksCount = 0;\n#endif\n\n    if (isLastPool) {\n        /* If it's the last pool we can de-allocate the memory, taking into account this pool\n           as well as the previous ones that have already been deallocated (out of order) */\n        for(poolIdx = XCP_MEM_MAIN_POOLS_NUMBER; poolIdx < XCP_MEM_MAIN_RESERVED_POOL_NUMBER; ++poolIdx) {\n            if ((xcpMemPoolDescriptors[poolIdx].head == XCP_FREE_POOL) &&\n                (xcpMemPoolDescriptors[poolIdx].poolSize != 0)) {\n                xcpMemReservedPoolsChunkUsedBytes -= xcpMemPoolDescriptors[poolIdx].poolSize;\n                xcpMemPoolDescriptors[poolIdx].poolSize = 0;\n            }\n        }\n    }\n\n    XCP_MUTEX_UNLOCK(xcpMemLock);\n\n    return XCP_SUCCESS;\n}\n\n\nXcpErrorCode xcpMemCustomPoolCreate(XcpCustomAllocHandler allocHandler, XcpCustomFreeHandler freeHandler, xcpPoolId_T* poolId)\n{\n    XcpErrorCode errorCode = XCP_SUCCESS;\n    uint8_T poolIdx;\n\n    xcpPoolId_T pool = XCP_INVALID_POOL_ID;\n\n    if ((poolId == NULL) || (allocHandler == NULL) || (freeHandler == NULL)) {\n        XCP_PRINTF(\"xcpMemCustomPoolCreate: invalid input parameter\\n\");\n        return XCP_INV_ARG;\n    }\n\n    XCP_MUTEX_LOCK(xcpMemLock);\n\n    for (poolIdx = 0; poolIdx < XCP_MEM_CUSTOM_POOL_MAX_NUMBER; poolIdx++) {\n        if (xcpMemCustomPoolDescriptors[poolIdx].allocHandler == NULL && xcpMemCustomPoolDescriptors[poolIdx].freeHandler == NULL) {\n            pool = poolIdx + XCP_MEM_CUSTOM_POOLS_OFFSET;\n            xcpMemCustomPoolDescriptors[poolIdx].allocHandler = allocHandler;\n            xcpMemCustomPoolDescriptors[poolIdx].freeHandler = freeHandler;\n            break;\n        }\n    }\n\n    XCP_MUTEX_UNLOCK(xcpMemLock);\n\n    if (pool == XCP_INVALID_POOL_ID) {\n        errorCode = XCP_NO_MEMORY;\n    }\n\n    *poolId = pool;\n\n    return errorCode;\n}\n\n\nXcpErrorCode xcpMemCustomPoolDestroy(xcpPoolId_T poolId)\n{\n    if (poolId < XCP_MEM_CUSTOM_POOLS_OFFSET || poolId >= XCP_MEM_CUSTOM_POOLS_UPPER_BOUND) {\n        XCP_PRINTF(\"xcpMemCustomPoolDestroy: invalid poolId\\n\");\n        return XCP_INV_ARG;\n    }\n\n    XCP_MUTEX_LOCK(xcpMemLock);\n\n    xcpMemCustomPoolDescriptors[poolId - XCP_MEM_CUSTOM_POOLS_OFFSET].allocHandler = NULL;\n    xcpMemCustomPoolDescriptors[poolId - XCP_MEM_CUSTOM_POOLS_OFFSET].freeHandler = NULL;\n\n    XCP_MUTEX_UNLOCK(xcpMemLock);\n\n    return XCP_SUCCESS;\n}\n\n\nvoid* xcpMemAllocFromPool(xcpPoolId_T poolId, size_t size)\n{\n    XcpMemHeader *poolHead = NULL;\n\n    /* a size of 0 is considered an invalid argument */\n    if (size == 0) {\n        return NULL;\n    }\n\n    /* Check if memory allocation is delegated to a custom handler.\n       For custom memory pools, protection against concurrent execution must be\n       implemented withing the allocation method */\n    if (poolId >= XCP_MEM_CUSTOM_POOLS_OFFSET && poolId < XCP_MEM_CUSTOM_POOLS_UPPER_BOUND) {\n        if (xcpMemCustomPoolDescriptors[poolId - XCP_MEM_CUSTOM_POOLS_OFFSET].allocHandler) {\n            /* Memory must be added explicitly to store the pool ID */\n            poolHead = (XcpMemHeader *) xcpMemCustomPoolDescriptors[poolId - XCP_MEM_CUSTOM_POOLS_OFFSET].allocHandler(size + XCP_MEM_POOLID_SIZE);\n            if (!poolHead) {\n                return NULL;\n            }\n            poolHead->poolId = (uint8_T) poolId;\n            return ((uint8_T*) poolHead) + XCP_MEM_POOLID_SIZE;\n        }\n        return NULL;\n    }\n    \n    if ((poolId < XCP_MEM_MAIN_POOLS_NUMBER) || (poolId >= XCP_MEM_MAIN_RESERVED_POOL_NUMBER) ||\n        (xcpMemPoolDescriptors[poolId].head == XCP_FREE_POOL) ||\n        (xcpMemPoolDescriptors[poolId].blockSize < size)) {\n        /* No memory block of the given size is available from this pool */\n        return NULL;\n    }\n\n#ifndef XCP_MEM_RESERVED_POOLS_LOCKLESS_SUPPORT\n    XCP_MUTEX_LOCK(xcpMemPoolDescriptors[poolId].lock);\n#endif\n\n    if (xcpMemPoolDescriptors[poolId].freeBlocksCount > 0) {\n        poolHead = xcpMemPoolDescriptors[poolId].head;\n    }\n\n    if (!poolHead){ /* there are no more free blocks */\n#ifndef XCP_MEM_RESERVED_POOLS_LOCKLESS_SUPPORT\n       XCP_MUTEX_UNLOCK(xcpMemPoolDescriptors[poolId].lock);\n#endif\n       return NULL;\n    }\n\n    xcpMemPoolDescriptors[poolId].head = poolHead->next;\n    (xcpMemPoolDescriptors[poolId].freeBlocksCount)--;\n    poolHead->poolId = (uint8_T) poolId;\n\n#ifndef XCP_MEM_RESERVED_POOLS_LOCKLESS_SUPPORT\n    XCP_MUTEX_UNLOCK(xcpMemPoolDescriptors[poolId].lock);\n#endif\n\n    /* return a pointer past just the poolId */\n    return ((uint8_T*) poolHead) + XCP_MEM_POOLID_SIZE;\n\n}\n\n\n#ifdef XCP_MEM_RESERVED_POOLS_LOCKLESS_SUPPORT\nvoid xcpMemReservedPoolFlushFreeMem(xcpPoolId_T poolId)\n{\n    if ((poolId >= XCP_MEM_MAIN_POOLS_NUMBER) &&\n        (poolId < XCP_MEM_MAIN_RESERVED_POOL_NUMBER) &&\n        (xcpMemPoolDescriptors[poolId].deferredFreeTail != NULL)) {\n        /* Let's move the deferred free blocks to the list of free blocks\n           available for subsequent allocations */\n        xcpMemPoolDescriptors[poolId].deferredFreeTail->next = xcpMemPoolDescriptors[poolId].head;\n        xcpMemPoolDescriptors[poolId].head = xcpMemPoolDescriptors[poolId].deferredFreeHead;\n        xcpMemPoolDescriptors[poolId].freeBlocksCount += xcpMemPoolDescriptors[poolId].deferredFreeBlocksCount;\n        xcpMemPoolDescriptors[poolId].deferredFreeBlocksCount = 0;\n        xcpMemPoolDescriptors[poolId].deferredFreeTail = NULL;\n    }\n}\n#endif\n\n\nXcpErrorCode xcpMemReset(void){\n    XCP_MEMSET(xcpMemMainChunk,          0, sizeof(xcpMemMainChunk));\n    XCP_MEMSET(xcpMemReservedPoolsChunk, 0, sizeof(xcpMemReservedPoolsChunk));\n    xcpMemReservedPoolsChunkUsedBytes = 0;\n\n    XCP_MEMSET(xcpMemPoolDescriptors,    0, sizeof(xcpMemPoolDescriptors));\n\n    XCP_MEMSET(xcpMemCustomPoolDescriptors, 0, sizeof(xcpMemCustomPoolDescriptors));\n\n    return XCP_SUCCESS;\n}\n\n#ifdef XCP_DEBUG_SUPPORT\n\nvoid xcpMemPrintDiagnostics(void)\n{\n    uint8_T poolIdx;\n    XCP_PRINTF(\"#############################\\n\");\n    XCP_PRINTF(\"             Header size: %7zu B\\n\", XCP_MEM_HEADER_SIZE);\n    XCP_PRINTF(\"             Offset size: %7zu B\\n\", XCP_MEM_POOLID_SIZE);\n    XCP_PRINTF(\"      Main System memory: %7zu B\\n\", XCP_MEM_MAIN_SYSTEM_SIZE);\n    XCP_PRINTF(\"        Main User memory: %7zu B\\n\", XCP_MEM_MAIN_USER_SIZE);\n    XCP_PRINTF(\"       Main Total memory: %7zu B\\n\", XCP_MEM_MAIN_TOTAL_SIZE);\n\n    for(poolIdx = 0 ; poolIdx < XCP_MEM_MAIN_POOLS_NUMBER ; ++poolIdx) {\n        size_t bsThisPool = xcpMemMainBlockSizes[poolIdx];\n        size_t nbBlocksThisPool = xcpMemPoolDescriptors[poolIdx].totalBlocksCount;\n        size_t nbFreeBlocksThisPool = xcpMemPoolDescriptors[poolIdx].freeBlocksCount;\n        XCP_PRINTF(\"%6zu B blocks: %4zu/%-4zu\\n\", bsThisPool, nbFreeBlocksThisPool, nbBlocksThisPool);\n    }\n    XCP_PRINTF(\"               (free)/(total)\\n\");\n    XCP_PRINTF(\"#############################\\n\");\n\n    XCP_PRINTF(\"        Res Pools Number: %7d   \\n\", XCP_MEM_RESERVED_POOLS_NUMBER);\n    XCP_PRINTF(\"  Res Pools Total memory: %7zu B\\n\", (size_t)XCP_MEM_RESERVED_POOLS_TOTAL_SIZE);\n    XCP_PRINTF(\"   Res Pools Used memory: %7zu B\\n\", xcpMemReservedPoolsChunkUsedBytes);\n\n    for(poolIdx = XCP_MEM_MAIN_POOLS_NUMBER ; poolIdx < XCP_MEM_MAIN_RESERVED_POOL_NUMBER ; ++poolIdx) {\n        size_t nbBlocksThisPool = xcpMemPoolDescriptors[poolIdx].totalBlocksCount;\n        size_t nbFreeBlocksThisPool = xcpMemPoolDescriptors[poolIdx].freeBlocksCount;\n        size_t sizeBlocksThisPool = xcpMemPoolDescriptors[poolIdx].blockSize;\n        XCP_PRINTF(\"Pool %3d blocks: %4zu/%-4zu of size %7zu\\n\", poolIdx, nbFreeBlocksThisPool, nbBlocksThisPool, sizeBlocksThisPool);\n    }\n    XCP_PRINTF(\"               (free)/(total)\\n\");\n}\n\n#endif\n\n#ifdef XCP_MEM_BYTE_COPY_SUPPORT\n/* xcpMemcpyByte() currently supports byte-wise copy on WORD (HW_AG=2) addressable targets only */\nvoid xcpMemcpyByte(void *pDst, uint8_T dstOffsetBytes, void const* pSrc, uint8_T srcOffsetBytes, size_t numOfBytes)\n{\n    uint16_T *dst = (uint16_T *)pDst;\n    uint16_T const* src = (uint16_T const*)pSrc;\n\n    if (numOfBytes >= 1) {\n        size_t numOfAGUnits = ((numOfBytes + 1) >> 1);\n        \n        if ((dstOffsetBytes == 0) && (srcOffsetBytes == 0)){\n            if (numOfBytes % 2){\n                numOfAGUnits--;\n                XCP_MEMCPY(dst, src, numOfAGUnits);\n                dst[numOfAGUnits] &= 0xff00;\n                dst[numOfAGUnits] |= (src[numOfAGUnits] & 0x00ff);\n            }\n            else {\n                XCP_MEMCPY(dst, src, numOfAGUnits);\n            }\n        }\n        else if ((dstOffsetBytes == 1) && (srcOffsetBytes == 0)){\n            uint32_T i = 0;\n            dst[0] &= 0x00ff;\n            dst[0] |= ((src[0] & 0x00ff) << 8);\n            for (i = 1; i < numOfAGUnits; i++){\n                dst[i]  = ((src[i-1] & 0xff00) >> 8);\n                dst[i] |= ((src[i] & 0x00ff) << 8);\n            }\n            if ((numOfBytes % 2) == 0){\n                dst[i] &= 0xff00;\n                dst[i] |= ((src[i-1] & 0xff00) >> 8);\n            }\n        }\n        else if ((dstOffsetBytes == 0) && (srcOffsetBytes == 1)){\n            uint32_T i = 0;\n            dst[0] = ((src[0] & 0xff00) >> 8);\n            if (numOfBytes >= 2) {\n                dst[0] |= ((src[1] & 0x00ff) << 8);\n                for (i = 1; i < numOfAGUnits-1; i++){\n                    dst[i]  = ((src[i] & 0xff00) >> 8);\n                    dst[i] |= ((src[i+1] & 0x00ff) << 8);\n                }\n                if (numOfBytes % 2){\n                    dst[i] &= 0xff00;\n                    dst[i] |= ((src[i] & 0xff00) >> 8);\n                }\n            }\n        }\n        else if ((dstOffsetBytes == 1) && (srcOffsetBytes == 1)){\n            dst[0] &= 0x00ff;\n            dst[0] |= (src[0] & 0xff00);\n            numOfBytes--;\n            numOfAGUnits--;\n            dst++;\n            src++;\n            XCP_MEMCPY(dst, src, numOfAGUnits);\n            if ((numOfBytes % 2) != 0){\n                dst[numOfAGUnits] &= 0xff00;\n                dst[numOfAGUnits] |= (src[numOfAGUnits] & 0x00ff);\n            }\n        }\n    }\n}\n\n#endif\n"},{"name":"xcp_standard.c","type":"source","group":"legacy","path":"C:\\Users\\Sophie\\Documents\\Hochschule\\Master\\Systeme und Programme\\toolbox\\coder\\xcp\\src\\target\\server\\protocol\\src","tag":"","groupDisplay":"Other files","code":"/*\n* Copyright 2016-2022 The MathWorks, Inc.\n*\n* File: xcp_standard.c\n*\n* Abstract:\n*  Implementation of XCP Protocol Layer standard commands\n*/\n\n#include \"xcp_common.h\"\n#include \"xcp.h\"\n#include \"xcp_cfg.h\"\n#include \"xcp_types.h\"\n#include \"xcp_transport_internal.h\"\n#include \"xcp_daq.h\"\n#include \"xcp_standard.h\"\n#include \"xcp_standard_ext.h\"\n#include \"xcp_standard_types.h\"\n\n\n/*****************************************************************************\n    Internal Variables\n******************************************************************************/\nstatic XcpAddress xcpMta = {0,0};   /* MTA and MTA extension in same format as in SET_MTA packet, used by (SHORT)_UPLOAD, (SHORT)_DOWNLOAD */\nstatic uint8_T xcpUploadSize = 0;\n\n\n/*****************************************************************************\n    Internal Utility Functions\n******************************************************************************/\nstatic boolean_T isValidUploadSize(uint8_T size)\n{\n    size_t addressGranularity = XCP_ADDRESS_GRANULARITY_BYTES_NUMBER;\n    size_t maxCtoSize = xcpTransportMaxCtoSize();\n\n    return (size < ((maxCtoSize) / addressGranularity));\n}\n\n/** memcpy function used to copy data from MTA address to the packet */\nstatic void xcpMemcpyFromMTA(uint8_T *pktData, uint8_T dstOffsetBytes)\n{\n    /* Retrieve memory address */\n    uint8_T *xcpMTARawPointer = xcpStandardGetAddressFromMta();\n\n    XCP_PRINTF(\"reading at address %p\\n\", xcpMTARawPointer);\n\n#ifdef XCP_EMULATE_BYTE_ADDRESSABLE_TARGET\n{\n    uint32_T address;\n    uint8_T addressExtension;\n    uint8_T srcOffsetBytes;\n    xcpStandardGetMta(&address, &addressExtension);\n    srcOffsetBytes = XCP_BYTE_OFFSET_GET(address);\n    if (dstOffsetBytes) { pktData--; }\n    xcpMemcpyByte(pktData, dstOffsetBytes, xcpMTARawPointer, srcOffsetBytes, xcpUploadSize);\n}\n#else\n    XCP_UNUSED_PARAM(dstOffsetBytes);\n    XCP_MEMCPY(pktData, xcpMTARawPointer, xcpUploadSize);\n#endif\n\n}\n\n/*****************************************************************************\n    XCP CONNECT\n******************************************************************************/\n#define XCP_NO_RESOURCES  0x00\n\nstatic const uint8_T xcpResourceValue = (\n    XCP_NO_RESOURCES\n#ifdef XCP_DAQ_SUPPORT\n    | XCP_RESOURCE_DAQ_MASK\n#endif\n#ifdef XCP_STIM_SUPPORT\n    | XCP_RESOURCE_STIM_MASK\n#endif\n#ifdef XCP_PGM_SUPPORT\n    | XCP_RESOURCE_PGM_MASK\n#endif\n#ifdef XCP_CALIBRATION_SUPPORT\n    | XCP_RESOURCE_CAL_PAG_MASK\n#endif\n    );\n\nstatic const uint8_T xcpCommModeBaseValue = (\n    (XCP_ADDRESS_GRANULARITY << XCP_COMM_MODE_ADDRESS_GRANULARITY_OFFSET)\n#if (XCP_BYTE_ORDER != 0)\n    | XCP_COMM_MODE_BYTE_ORDER_MASK\n#endif\n#ifdef XCP_BLOCK_MODE_SUPPORT\n    | XCP_COMM_MODE_SLAVE_BLOCK_MODE_MASK\n#endif\n#ifdef XCP_COMM_MODE_INFO_SUPPORT\n    | XCP_COMM_MODE_OPTIONAL_MASK\n#endif\n    );\n\nstatic XcpProtoErrorCode connectInputPacketHandler(void   *msgBuffer,\n                                                   size_t  xcpPacketOffset,\n                                                   size_t *outputPacketSize)\n{\n    XcpProtoErrorCode protoErrorCode = XCP_PROTO_SUCCESS;\n    uint8_T *packet = (uint8_T *)msgBuffer + xcpPacketOffset;\n    XcpConnectCmdPacketFrame *frame = (XcpConnectCmdPacketFrame *) packet;\n    boolean_T ok = false;\n\n    /* If DAQ List support is enabled, reset the status of dynamic DAQ list data structures */\n    ok = xcpResetDaqListStatus();\n\n    XCP_INPUT_PKT_ERROR_IF(!ok, XCP_PROTO_BUSY,\n        (\"CONNECT: DAQ lists reset cannot be carried out, as an event was processed\\n\"));\n\n    /* Validate command inputs */\n    ok = (frame->mode == XCP_CONNECT_MODE_NORMAL) || (frame->mode == XCP_CONNECT_MODE_USER_DEFINED);\n    XCP_INPUT_PKT_ERROR_IF(!ok, XCP_PROTO_OUT_OF_RANGE,\n                          (\"CONNECT: invalid mode detected %xH\\n\", frame->mode));\n\n    /* Everything is fine -> updating the Protocol Layer status */\n    XCP_PRINTF(\"CONNECT: entering XCP_CONNECTED status\\n\");\n    xcpStatusSet(XCP_CONNECTED);\n\n    protoErrorCode = XCP_PROTO_SUCCESS;\n    *outputPacketSize = XCP_CONNECT_RES_PACKET_SIZE_IN_BYTES;\n\n    return protoErrorCode;\n}\n\nstatic void connectOutputPacketHandler(XcpProtoErrorCode inputCode, void *packet, size_t packetSize)\n{\n    if (inputCode == XCP_PROTO_SUCCESS) {\n        /* Fill connect response */\n        XcpConnectResPacketFrame *frame = (XcpConnectResPacketFrame *)packet;\n        XCP_MEMSET(frame, 0, sizeof(*frame));\n\n        frame->PID = XCP_PID_RES;\n\n        /* Update resource field */\n        frame->resource = xcpResourceValue;\n\n        /* Update commModeBasic field */\n        frame->commModeBasic = xcpCommModeBaseValue;\n\n        /* Update Max CTO and DTO fields */\n        frame->maxCtoSize = (uint8_T)xcpTransportMaxCtoSize();\n        frame->maxDtoSize = (uint16_T)xcpTransportMaxDtoSize();\n\n        /* Update Protocol and Transport Version fields */\n        frame->xcpProtocolVersion  = XCP_MAJOR_NUMBER(XCP_PROTOCOL_LAYER_VERSION);\n        frame->xcpTransportVersion = XCP_MAJOR_NUMBER(XCP_TRANSPORT_LAYER_VERSION);\n\n        XCP_PRINTF(\"* Resource:          %xH\\n\", frame->resource);\n        XCP_PRINTF(\"* Comm Mode Basic:   %xH\\n\", frame->commModeBasic);\n        XCP_PRINTF(\"* Max CTO size:      %d\\n\",  frame->maxCtoSize);\n        XCP_PRINTF(\"* Max DTO size:      %d\\n\",  frame->maxDtoSize);\n        XCP_PRINTF(\"* Protocol Version:  %d\\n\",  frame->xcpProtocolVersion);\n        XCP_PRINTF(\"* Transport Version: %d\\n\",  frame->xcpTransportVersion);\n    }\n    else {\n        genericOutputPacketHandler(inputCode, packet, packetSize);\n    }\n}\n\n/*****************************************************************************\n    XCP DISCONNECT\n******************************************************************************/\nstatic XcpProtoErrorCode disconnectInputPacketHandler(void   *msgBuffer,\n                                                      size_t  xcpPacketOffset,\n                                                      size_t *outputPacketSize)\n{\n    boolean_T ok = true;\n\n    XCP_UNUSED_PARAM(msgBuffer);\n    XCP_UNUSED_PARAM(xcpPacketOffset);\n\n    /* If DAQ List support is enabled, reset the status of dynamic DAQ list data structures */\n    ok = xcpResetDaqListStatus();\n\n    XCP_INPUT_PKT_ERROR_IF(!ok, XCP_PROTO_BUSY,\n        (\"DISCONNECT: DAQ lists reset cannot be carried out, as an event was processed\\n\"));\n\n    /* Everything is fine -> proceed with the status update */\n    XCP_PRINTF(\"DISCONNECT: entering XCP_DISCONNECTED status\\n\");\n    xcpStatusSet(XCP_DISCONNECTED);\n\n    *outputPacketSize = XCP_GENERIC_RES_PACKET_SIZE_IN_BYTES;\n\n    return XCP_PROTO_SUCCESS;\n}\n\n/*****************************************************************************\n    XCP GET_STATUS\n******************************************************************************/\nstatic XcpProtoErrorCode getStatusInputPacketHandler(void   *msgBuffer,\n                                                     size_t  xcpPacketOffset,\n                                                     size_t *outputPacketSize)\n{\n    XCP_UNUSED_PARAM(msgBuffer);\n    XCP_UNUSED_PARAM(xcpPacketOffset);\n\n    XCP_PRINTF(\"GET STATUS\\n\");\n\n    *outputPacketSize = XCP_GET_STATUS_RES_PACKET_SIZE_IN_BYTES;\n\n    return XCP_PROTO_SUCCESS;\n}\n\nstatic void getStatusOutputPacketHandler(XcpProtoErrorCode inputCode, void *packet, size_t packetSize)\n{\n    XcpGetStatusResPacketFrame *frame = (XcpGetStatusResPacketFrame *)packet;\n\n    XCP_UNUSED_PARAM(inputCode);\n    XCP_UNUSED_PARAM(packetSize);\n\n    /* Fill Get Status response */\n    XCP_MEMSET(frame, 0, sizeof(*frame));\n\n    frame->PID                      = XCP_PID_RES;\n    frame->sessionStatus            = xcpSessionStatusGet();\n    frame->resourceProtectionStatus = xcpResourceProtectionStatusGet();\n    frame->sessionConfigurationId   = xcpSessionConfigurationIdGet();\n\n    XCP_PRINTF(\"* Session Status:              %xH\\n\", frame->sessionStatus);\n    XCP_PRINTF(\"* Resource Protection Status:  %xH\\n\", frame->resourceProtectionStatus);\n    XCP_PRINTF(\"* Session Config Id:           %d\\n\", frame->sessionConfigurationId);\n}\n\n/*****************************************************************************\n    XCP SYNCH\n******************************************************************************/\n#define XCP_SYNC_RES_PACKET_SIZE_IN_BYTES 2\n\nstatic XcpProtoErrorCode synchInputPacketHandler(void   *msgBuffer,\n                                                 size_t  xcpPacketOffset,\n                                                 size_t *outputPacketSize)\n{\n    boolean_T locked = false;\n\n    XCP_UNUSED_PARAM(msgBuffer);\n    XCP_UNUSED_PARAM(xcpPacketOffset);\n\n    XCP_PRINTF(\"SYNCH\\n\");\n\n    /* Make sure that no DAQ list is currently\n       in the process of sending packets */\n    locked = xcpDaqLock();\n\n    if (locked) {\n        /* Re-synchronizing the transport layer, by flushing the TX packets currently\n           in the TX FIFO and restarting the frame handler */\n        xcpTransportResynch();\n\n        xcpDaqUnlock();\n    }\n\n    *outputPacketSize = XCP_SYNC_RES_PACKET_SIZE_IN_BYTES;\n\n    return XCP_PROTO_SYNCH;\n}\n\n\n#if XCP_SET_MTA_ENABLE == 1\n/*****************************************************************************\n    XCP SET_MTA\n******************************************************************************/\n    static XcpProtoErrorCode setMTAInputPacketHandler(void  *msgBuffer, \n        size_t  xcpPacketOffset, \n        size_t *outputPacketSize) {\n\n        XcpProtoErrorCode protoErrorCode = XCP_PROTO_SUCCESS;\n        uint8_T *packet = (uint8_T *)msgBuffer + xcpPacketOffset;\n        XcpSetMTACmdPacketFrame *frame = (XcpSetMTACmdPacketFrame *)packet;\n        boolean_T ok = false;\n\n        /* Check if the memory address is valid and set the MTA pointer */\n        ok = xcpStandardSetMta(frame->address, (uint8_T)frame->addressExtension);\n        XCP_INPUT_PKT_ERROR_IF(!ok, XCP_PROTO_ACCESS_DENIED, (\"SET_MTA: invalid address\\n\"));\n        \n        XCP_PRINTF(\"SET_MTA: setting MTA value to %x and extension %x\\n\", frame->address, frame->addressExtension);    \n\n        *outputPacketSize = sizeof(XcpGenericResPacketFrame);\n\n        return protoErrorCode;\n    }\n\n/*****************************************************************************\n    XCP UPLOAD\n******************************************************************************/\n    static XcpProtoErrorCode uploadInputPacketHandler(void   *msgBuffer,\n        size_t  xcpPacketOffset,\n        size_t *outputPacketSize) {\n\n        XcpProtoErrorCode protoErrorCode = XCP_PROTO_SUCCESS;\n        uint8_T *packet = (uint8_T *)msgBuffer + xcpPacketOffset;\n        XcpUploadCmdPacketFrame *frame = (XcpUploadCmdPacketFrame *)packet;\n        boolean_T ok = false;\n        uint8_T *xcpMTARawPointer = xcpStandardGetAddressFromMta();\n\n        /* Check if the number of data elements is valid */\n        ok = isValidUploadSize((uint8_T)frame->size);\n        XCP_INPUT_PKT_ERROR_IF(!ok, XCP_PROTO_OUT_OF_RANGE,\n            (\"UPLOAD: invalid number of data elements (%d)\\n\", (uint8_T)frame->size));\n        \n        /* Check if a valid MTA address is available */\n        XCP_INPUT_PKT_ERROR_IF(xcpMTARawPointer == 0, XCP_PROTO_ACCESS_DENIED,\n            (\"UPLOAD: invalid address\\n\"));\n        \n        xcpUploadSize = (uint8_T)frame->size;\n        *outputPacketSize = XCP_UPLOAD_RES_PACKET_SIZE_IN_BYTES + XCP_IN_BYTES(xcpUploadSize);\n\n        return protoErrorCode;\n    }\n\n    \n    static void uploadOutputPacketHandler(XcpProtoErrorCode inputCode, void *packet, size_t packetSize) {\n        \n        if (inputCode == XCP_PROTO_SUCCESS) {\n\n            /* Fill Upload response */\n            uint8_T *xcpMTARawPointer = xcpStandardGetAddressFromMta();\n            XcpUploadResPacketFrame *frame = (XcpUploadResPacketFrame *)packet;\n            XCP_MEMSET(frame, 0, sizeof(*frame));\n            frame->PID = XCP_PID_RES;\n\n            if ((xcpMTARawPointer != NULL) &&\n                (packetSize == (XCP_UPLOAD_RES_PACKET_SIZE_IN_BYTES + XCP_IN_BYTES(xcpUploadSize)))\n                ) {\n                uint8_T *pktData = (uint8_T *)packet + XCP_IN_AG(XCP_UPLOAD_RES_PACKET_SIZE_IN_BYTES);\n                uint8_T dstOffsetBytes = (XCP_UPLOAD_RES_PACKET_SIZE_IN_BYTES % XCP_HARDWARE_ADDRESS_GRANULARITY_BYTES_NUMBER);\n\n                XCP_PRINTF(\"UPLOAD: \");\n                \n                /* Copy the memory content to the packet data area */\n                xcpMemcpyFromMTA(pktData, dstOffsetBytes);\n\n                /* Post-increment MTA by the frame size in address granularity units */\n                xcpStandardIncrementMta(xcpUploadSize);\n                xcpUploadSize = 0;\n            }\n            else {\n                /* This is a software error and it should never happen */\n                XCP_PRINTF(\"UPLOAD: invalid data detected\\n\");\n            }\n        }\n        else {\n            genericOutputPacketHandler(inputCode, packet, packetSize);\n        }\n    }\n#endif  /* XCP_SET_MTA_ENABLE == 1  */\n\n\n/*****************************************************************************\n    XCP SHORT_UPLOAD\n******************************************************************************/\nstatic XcpProtoErrorCode shortUploadInputPacketHandler(void   *msgBuffer,\n    size_t  xcpPacketOffset,\n    size_t *outputPacketSize)\n{\n    XcpProtoErrorCode protoErrorCode = XCP_PROTO_SUCCESS;\n    uint8_T *packet = (uint8_T *)msgBuffer + xcpPacketOffset;\n    XcpShortUploadCmdPacketFrame *frame = (XcpShortUploadCmdPacketFrame *)packet;\n    boolean_T ok = false;\n\n    /* Check if the number of data elements is valid */\n    ok = isValidUploadSize((uint8_T)frame->size);\n    XCP_INPUT_PKT_ERROR_IF(!ok, XCP_PROTO_OUT_OF_RANGE,\n        (\"SHORT_UPLOAD: invalid number of data elements (%d)\\n\", (uint8_T)frame->size));\n\n    /* Check if the memory address is valid and set the MTA pointer */\n    ok = xcpStandardSetMta(frame->address, (uint8_T)frame->addressExtension);\n    XCP_INPUT_PKT_ERROR_IF(!ok, XCP_PROTO_ACCESS_DENIED, (\"SHORT_UPLOAD: invalid address\\n\"));\n\n    xcpUploadSize = (uint8_T)frame->size;\n\n    *outputPacketSize = XCP_SHORT_UPLOAD_RES_PACKET_SIZE_IN_BYTES + XCP_IN_BYTES(xcpUploadSize);\n\n    return protoErrorCode;\n}\n\nstatic void shortUploadOutputPacketHandler(XcpProtoErrorCode inputCode, void *packet, size_t packetSize)\n{    \n    if (inputCode == XCP_PROTO_SUCCESS) {\n\n        /* Fill Short Upload response */\n        uint8_T *xcpMTARawPointer = xcpStandardGetAddressFromMta();\n        XcpShortUploadResPacketFrame *frame = (XcpShortUploadResPacketFrame *)packet;\n        XCP_MEMSET(frame, 0, sizeof(*frame));\n\n        frame->PID = XCP_PID_RES;\n\n        if ((xcpMTARawPointer != NULL) &&\n            (packetSize == XCP_SHORT_UPLOAD_RES_PACKET_SIZE_IN_BYTES + XCP_IN_BYTES(xcpUploadSize) )\n           ) {\n            uint8_T *pktData = (uint8_T *)packet + XCP_IN_AG(XCP_SHORT_UPLOAD_RES_PACKET_SIZE_IN_BYTES);\n            uint8_T dstOffsetBytes = (XCP_SHORT_UPLOAD_RES_PACKET_SIZE_IN_BYTES % XCP_HARDWARE_ADDRESS_GRANULARITY_BYTES_NUMBER);\n\n            XCP_PRINTF(\"SHORT_UPLOAD: \");\n\n            /* Copy the memory content to the packet data area */\n            xcpMemcpyFromMTA(pktData, dstOffsetBytes);\n\n            /* Post-increment MTA by the frame size in address granularity units */\n            xcpStandardIncrementMta(xcpUploadSize);\n\n            xcpUploadSize = 0;\n        }\n        else {\n            /* This is a software error and it should never happen */\n            XCP_PRINTF(\"SHORT_UPLOAD: invalid data detected\\n\");\n        }\n    }\n    else {\n        genericOutputPacketHandler(inputCode, packet, packetSize);\n    }\n}\n\n\n/** This table contains the list of supported Rx packets and the corresponding handlers */\nstatic const XcpPacketHandlers standardSupportedRxPacket[] =\n{\n    { XCP_PID_CONNECT,      connectInputPacketHandler,     connectOutputPacketHandler },\n    { XCP_PID_DISCONNECT,   disconnectInputPacketHandler,  genericOutputPacketHandler },\n    { XCP_PID_GET_STATUS,   getStatusInputPacketHandler,   getStatusOutputPacketHandler },\n    { XCP_PID_SYNCH,        synchInputPacketHandler,       genericOutputPacketHandler },\n#if XCP_SET_MTA_ENABLE == 1  \n    { XCP_PID_SET_MTA,      setMTAInputPacketHandler,      genericOutputPacketHandler },\n    { XCP_PID_UPLOAD,       uploadInputPacketHandler,      uploadOutputPacketHandler},\n#endif\n    { XCP_PID_SHORT_UPLOAD, shortUploadInputPacketHandler, shortUploadOutputPacketHandler }\n};\n\n\n\n/*****************************************************************************\n    XCP Packet Lookup Function for basic standard commands\n******************************************************************************/\n\n/* Default Standard Packet Lookup function, supporting only basic commands\n   listed in the table above */\nstatic const XcpPacketHandlers* getPacket(XcpRxPidCode pid)\n{\n    return xcpFindPacket(pid, standardSupportedRxPacket,\n                         XCP_ELEMENTS_NUMBER(standardSupportedRxPacket));\n}\n\nstatic XcpPacketLookupFunction packetLookup = NULL;\n\n\n\n/*****************************************************************************\n    Public Functions (invoked within the Protocol Layer)\n******************************************************************************/\nvoid xcpStandardInit(void)\n{\n    /* Initialize the packet lookup function to support only basic\n       standard commands */\n    xcpStandardSetPacketLookup(getPacket);\n\n    /* Initialize support for the extended list of Standard commands\n       @note this may override the default Packet lookup function\n             by adding support for more (optional) commands */\n    xcpStandardExtendedInit();\n}\n\n\nXcpPacketLookupFunction xcpStandardGetPacketLookup(void)\n{\n    return packetLookup;\n}\n\n\nvoid xcpStandardSetPacketLookup(XcpPacketLookupFunction getPacketFcn)\n{\n    packetLookup = getPacketFcn;\n}\n\n\nvoid xcpStandardReset(void)\n{\n    /* reset support for the extended list of Standard commands */\n    xcpStandardExtendedReset();\n\n    /* Restore the original value for the lookup function */\n    xcpStandardSetPacketLookup(NULL);\n}\n\n\nuint8_T* xcpStandardGetAddressFromMta(void) {\n    return XCP_ADDRESS_GET_WRITE(xcpMta.addressExtension, xcpMta.address);\n}\n\n\nboolean_T xcpStandardSetMta(uint32_T address, uint8_T addressExtension) {\n    if ((addressExtension == 0) && (address == 0)) {\n        return false;\n    } else {\n        xcpMta.address = address;\n        xcpMta.addressExtension = addressExtension;\n        return true;\n    }\n}\n\n\nvoid xcpStandardGetMta(uint32_T *address, uint8_T *addressExtension) {\n    *address = xcpMta.address;\n    *addressExtension = xcpMta.addressExtension;\n}\n\n\nvoid xcpStandardIncrementMta(uint8_T incr) {\n    xcpMta.address += incr;\n}\n\n\n#ifndef XCP_STANDARD_EXTENDED_SUPPORT\n\nvoid xcpStandardExtendedInit(void) {}\nvoid xcpStandardExtendedReset(void) {}\n\n#endif\n"},{"name":"xcp_transport.c","type":"source","group":"legacy","path":"C:\\Users\\Sophie\\Documents\\Hochschule\\Master\\Systeme und Programme\\toolbox\\coder\\xcp\\src\\target\\server\\transport\\src","tag":"","groupDisplay":"Other files","code":"/*\n* Copyright 2016-2021 The MathWorks, Inc.\n*\n* File: xcp_transport.c\n*\n* Abstract:\n*  Implementation of XCP Transport Layer.\n*  The file contains the common part that is responsible for the handling\n*  of Tx/Rx buffers and relies on the Xcp Driver and Xcp Frame Handler layers\n*  for sending and receiving data to/from the supported transport layer specification\n*/\n\n#include \"xcp_common.h\"\n#include \"xcp.h\"\n#include \"xcp_transport.h\"\n#include \"xcp_transport_types.h\"\n#include \"xcp_transport_internal.h\"\n#include \"xcp_frame.h\"\n#include \"xcp_fifo.h\"\n#include \"xcp_mem.h\"\n#ifdef XCP_LOCKLESS_SYNC_DATA_TRANSFER_SUPPORT\n#include \"xcp_daq_types.h\"\n#endif\n\n/** Number of supported Tx queues */\n\n#define XCP_TRANSPORT_TX_QUEUES_TYPES_NUMBER     2\n\n/** Number of supported Rx queues */\n#define XCP_TRANSPORT_RX_QUEUES_TYPES_NUMBER  1\n\n\n/* In this Transport Layer implementation, the memory buffer associated with a generic\n   XCP message has the following format:\n\n   --------------      +---->  --------------\n  | xcpFifoEntry | ----+      | xcpFifoEntry |\n   --------------              --------------\n  | XCP Header   |            | XCP Header   |\n   --------------              --------------\n  | XCP Packet   |            | XCP Packet   |\n   --------------              --------------\n\n  xcpFifoEntry is an internal data structure used to implement a FIFO through a single linked list\n*/\n\n\n\n/* Transmit FIFOs */\nstatic struct xcpFifo txFifo[XCP_TRANSPORT_TX_QUEUES_TYPES_NUMBER];\n\nstatic XCP_MUTEX_DEFINE(txLock);\n\n/* Receive FIFOs */\nstatic struct xcpFifo rxFifo[XCP_TRANSPORT_RX_QUEUES_TYPES_NUMBER];\n\nstatic XCP_MUTEX_DEFINE(rxLock);\n\n\n#ifdef XCP_LOCKLESS_SYNC_DATA_TRANSFER_SUPPORT\n\n#if XCP_MEM_DAQ_RESERVED_POOLS_NUMBER <= 0\n#error  \"XCP_LOCKLESS_SYNC_DATA_TRANSFER_SUPPORT requires a XCP_MEM_DAQ_RESERVED_POOLS_NUMBER value greater than 0\"\n#endif\n\nstatic struct xcpFifo daqDeferredTxFifo[XCP_MEM_DAQ_RESERVED_POOLS_NUMBER];\nstatic struct xcpFifo daqTxFifo[XCP_MEM_DAQ_RESERVED_POOLS_NUMBER];\nstatic boolean_T      daqTxRequest[XCP_MEM_DAQ_RESERVED_POOLS_NUMBER];\nstatic uint16_T       lastDaqIdTx = 0xFFFF;\n\n#endif\n\n\n/* true if the Transport Layer has been successfully initialized */\nstatic boolean_T  initialized = false;\n\n/* ID of the memory pool reserved for the allocation of\n    CTO XCP Packets */\nstatic xcpPoolId_T xcpCtoReservedMemPoolId = -1;\n\n\n#ifdef XCP_DEBUG_SUPPORT\nstatic const char *xcpTransportDiagDataString[XCP_TRANSPORT_COUNTERS_NUMBER] = {\n    \"XCP_TRANSPORT_INIT_COUNTER               \",\n    \"XCP_TRANSPORT_TX_COUNTER                 \",\n    \"XCP_TRANSPORT_TX_PACKET_SET_COUNTER      \",\n    \"XCP_TRANSPORT_RX_PACKET_GET_COUNTER      \",\n    \"XCP_TRANSPORT_RX_COUNTER                 \",\n    \"XCP_TRANSPORT_RESTART_COUNTER            \",\n    \"XCP_TRANSPORT_RESYNCH_COUNTER            \",\n    \"XCP_TRANSPORT_RESET_COUNTER              \",\n    \"XCP_TRANSPORT_MEM_INIT_ERROR             \",\n    \"XCP_TRANSPORT_MEM_RESET_ERROR            \",\n    \"XCP_TRANSPORT_FRAME_INIT_ERROR           \",\n    \"XCP_TRANSPORT_FRAME_CREATE_MSG_ERROR     \",\n    \"XCP_TRANSPORT_FRAME_SEND_ERROR           \",\n    \"XCP_TRANSPORT_FRAME_RECV_ERROR           \",\n    \"XCP_TRANSPORT_FRAME_EXTRACT_PACKET_ERROR \",\n    \"XCP_TRANSPORT_FRAME_RESTART_ERROR        \",\n    \"XCP_TRANSPORT_FRAME_RESET_ERROR          \",\n    \"XCP_TRANSPORT_TX_PACKET_IN_COUNTER       \",\n    \"XCP_TRANSPORT_TX_PACKET_OUT_COUNTER      \",\n    \"XCP_TRANSPORT_TX_PACKET_FREED_COUNTER    \",\n    \"XCP_TRANSPORT_TX_IS_EMPTY_COUNTER        \",\n    \"XCP_TRANSPORT_RX_PACKET_IN_COUNTER       \",\n    \"XCP_TRANSPORT_RX_PACKET_OUT_COUNTER      \",\n    \"XCP_TRANSPORT_RX_PACKET_FREED_COUNTER    \",\n    \"XCP_TRANSPORT_RX_IS_EMPTY_COUNTER        \"\n};\n\nstatic XcpTransportDiagnostic xcpTransportDiagnostic;\n\n\nvoid xcpTransportDiagnosticReset(void)\n{\n    XCP_MEMSET(&xcpTransportDiagnostic, 0, sizeof(xcpTransportDiagnostic));\n}\n\n\nvoid xcpTransportDiagnosticGet(XcpTransportDiagnostic *diag)\n{\n    XCP_MEMCPY(diag, &xcpTransportDiagnostic, sizeof(xcpTransportDiagnostic));\n}\n\n\nvoid xcpTransportDiagnosticPrint(const XcpTransportDiagnostic *diag)\n{\n    if (diag != NULL) {\n        int i = 0;\n        for (i = 0; i < XCP_TRANSPORT_COUNTERS_NUMBER; i++) {\n            XCP_PRINTF(\"%s = %lu\\n\", xcpTransportDiagDataString[i], (unsigned long) xcpTransportDiagnostic.data[i]);\n        }\n    }\n}\n\n#define XCP_DIAG_UPDATE(counterId)     xcpTransportDiagnostic.data[counterId]++\n\n#else\n\n#define XCP_DIAG_UPDATE(counterId) \n\n#endif\n\n/* Empty the TX FIFO by deleting the existing packets */\nstatic void xcpTransportEmptyTxFifo(void)\n{\n    struct xcpFifoEntry *msgBufferHeader = NULL;\n    uint16_T i = 0;\n\n    XCP_MUTEX_LOCK(txLock);\n\n    for (i = 0; i < XCP_TRANSPORT_TX_QUEUES_TYPES_NUMBER; i++) {\n        do {\n            xcpFifoDequeue(&txFifo[i], &msgBufferHeader);\n\n            if (msgBufferHeader != NULL) {\n                xcpMemFree(msgBufferHeader);\n                XCP_DIAG_UPDATE(XCP_TRANSPORT_TX_PACKET_FREED_COUNTER);\n            }\n        } while (msgBufferHeader != NULL);\n    }\n\n    XCP_MUTEX_UNLOCK(txLock);\n\n#ifdef XCP_LOCKLESS_SYNC_DATA_TRANSFER_SUPPORT\n    for (i = 0; i < XCP_MEM_DAQ_RESERVED_POOLS_NUMBER; i++) {\n        do {\n            xcpFifoDequeue(&daqTxFifo[i], &msgBufferHeader);\n\n            if (msgBufferHeader != NULL) {\n                xcpMemFree(msgBufferHeader);\n                XCP_DIAG_UPDATE(XCP_TRANSPORT_TX_PACKET_FREED_COUNTER);\n            }\n        } while (msgBufferHeader != NULL);\n\n        do {\n            xcpFifoDequeue(&daqDeferredTxFifo[i], &msgBufferHeader);\n\n            if (msgBufferHeader != NULL) {\n                xcpMemFree(msgBufferHeader);\n                XCP_DIAG_UPDATE(XCP_TRANSPORT_TX_PACKET_FREED_COUNTER);\n            }\n        } while (msgBufferHeader != NULL);\n\n        daqTxRequest[i] = false;\n    }\n    lastDaqIdTx = 0xFFFF;\n#endif\n}\n\n\n/* Empty the RX FIFO by deleting the existing packets */\nstatic void xcpTransportEmptyRxFifo(void)\n{\n    struct xcpFifoEntry *msgBufferHeader = NULL;\n    XcpTransportQueueType_T i = 0;\n\n    XCP_MUTEX_LOCK(rxLock);\n\n    for (i = 0; i < XCP_TRANSPORT_RX_QUEUES_TYPES_NUMBER; i++) {\n        do {\n            xcpFifoDequeue(&rxFifo[i], &msgBufferHeader);\n\n            if (msgBufferHeader != NULL) {\n                xcpMemFree(msgBufferHeader);\n                XCP_DIAG_UPDATE(XCP_TRANSPORT_RX_PACKET_FREED_COUNTER);\n            }\n        } while (msgBufferHeader != NULL);\n    }\n\n    XCP_MUTEX_UNLOCK(rxLock);\n}\n\n\nXcpErrorCode xcpTransportInit(int argc, void * argv[])\n{\n    XcpErrorCode errorCode = XCP_SUCCESS;\n    uint16_T i = 0;\n\n    XCP_ERROR_IF(initialized, XCP_ERROR, \"xcpTransportInit: transport layer already initialized\\n\");\n\n    XCP_DIAG_UPDATE(XCP_TRANSPORT_INIT_COUNTER);\n\n    /* Initialize Tx and Rx data structures*/\n    for (i = 0; i < XCP_TRANSPORT_TX_QUEUES_TYPES_NUMBER; i++) {\n        xcpFifoInit(&txFifo[i]);\n    }\n    XCP_MUTEX_INIT(txLock);\n\n#ifdef XCP_LOCKLESS_SYNC_DATA_TRANSFER_SUPPORT\n    for (i = 0; i < XCP_MEM_DAQ_RESERVED_POOLS_NUMBER; i++) {\n        xcpFifoInit(&daqTxFifo[i]);\n        xcpFifoInit(&daqDeferredTxFifo[i]);\n        daqTxRequest[i] = false;\n    }\n    lastDaqIdTx = 0xFFFF;\n#endif\n\n    for (i = 0; i < XCP_TRANSPORT_RX_QUEUES_TYPES_NUMBER; i++) {\n        xcpFifoInit(&rxFifo[i]);\n    }\n    XCP_MUTEX_INIT(rxLock);\n\n    /* Initialize XCP memory allocator */\n    errorCode = xcpMemInit();\n    if (errorCode != XCP_SUCCESS) {\n        XCP_PRINTF(\"xcpTransportInit: error (%d) detected during memory allocator initialization\\n\", errorCode);\n        XCP_DIAG_UPDATE(XCP_TRANSPORT_MEM_INIT_ERROR);\n        return errorCode;\n    }\n\n    {\n        /* Allocate the memory pool reserved for the allocation\n           of CTO, EV and SERV XCP Packets */\n        size_t maxCtoSize = xcpTransportMaxCtoSize();\n        size_t maxBufferSize = xcpTransportMsgBufferSize(maxCtoSize, XCP_CTO);\n\n        errorCode = xcpMemReservedPoolCreate(maxBufferSize, XCP_MEM_CTO_RESERVED_POOL_BLOCKS_NUMBER,\n                                             &xcpCtoReservedMemPoolId);\n\n        if (errorCode != XCP_SUCCESS) {\n            XCP_PRINTF(\"xcpTransportInit: error (%d) detected during allocation of reserved memory pool\\n\", errorCode);\n            XCP_DIAG_UPDATE(XCP_TRANSPORT_MEM_INIT_ERROR);\n            return errorCode;\n        }\n\n        xcpFrameSetCtoReservedMemPoolId(xcpCtoReservedMemPoolId);\n    }\n\n    /* Initialize XCP Frame handler */\n    errorCode = xcpFrameInit(argc, argv);\n    if (errorCode != XCP_SUCCESS) {\n        XCP_PRINTF(\"xcpTransportInit: error (%d) detected during frame handler initialization\\n\", errorCode);\n        XCP_DIAG_UPDATE(XCP_TRANSPORT_FRAME_INIT_ERROR);\n        return errorCode;\n    }\n\n    initialized = true;\n\n    return errorCode;\n}\n\n\n#ifdef XCP_LOCKLESS_SYNC_DATA_TRANSFER_SUPPORT\n\nboolean_T xcpTransportTxReady(\n    XcpTransportQueueType_T queueType, /**< [in] type of the TX queue the packet has to be sent to */\n\tuint16_T daqId                     /**< [in] id of the DAQ list the packet refers to */\n)\n{\n    boolean_T ready = true;\n    /* In the lockless implementation we enqueue data only\n       if the previous transmission has been completed */\n    if ((queueType == XCP_TRANSPORT_TX_DEFAULT_QUEUE) &&\n        (daqId <  XCP_MEM_DAQ_RESERVED_POOLS_NUMBER)) {\n        ready = !daqTxRequest[daqId];\n    }\n\n    return ready;\n}\n\n\n/** If lockless streaming is enabled, trigger the transmission of\n    packets previously enqueued (by invoking xcpTransportTxPacketSet.\n    The function returns XCP_BUSY if the TX request is already\n    in progress */\nXcpErrorCode  xcpTransportTxTrigger(\n    XcpTransportQueueType_T queueType, /**< [in] type of the TX queue the packet has to be sent to */\n    uint16_T daqId                     /**< [in] id of the DAQ list the packet refers to */\n)\n{\n    XcpErrorCode errorCode = XCP_SUCCESS;\n\n    if ((queueType != XCP_TRANSPORT_TX_DEFAULT_QUEUE) ||\n        (daqId >= XCP_MEM_DAQ_RESERVED_POOLS_NUMBER)) {\n        return XCP_INV_ARG;\n    }\n\n    if (!daqTxRequest[daqId]) {\n        if (!xcpFifoEmpty(daqDeferredTxFifo)) {\n            /* If the transmission of any packets was deferred \n               from previous run, we need to enqueue them at the\n               head of the daqTxFifo, as they need to be sent first */\n            xcpFifoSpliceHead(daqTxFifo, daqDeferredTxFifo);\n        }\n\n        XCP_MEM_BARRIER();\n        daqTxRequest[daqId] = true;\n    } else {\n        errorCode = XCP_BUSY;\n    }\n\n    return errorCode;\n}\n\n#else\n\nboolean_T xcpTransportTxReady(\n    XcpTransportQueueType_T queueType, /**< [in] type of the TX queue the packet has to be sent to */\n    uint16_T daqId                     /**< [in] id of the DAQ list the packet refers to */\n)\n{\n    XCP_UNUSED_PARAM(queueType);\n    XCP_UNUSED_PARAM(daqId);\n\n    /* In the standard (mutex-based) implementation we can always enqueue\n       new packets and therefore TX is always ready*/\n    return true;\n}\n\n\nXcpErrorCode  xcpTransportTxTrigger(\n    XcpTransportQueueType_T queueType, /**< [in] type of the TX queue the packet has to be sent to */\n    uint16_T daqId                     /**< [in] id of the DAQ list the packet refers to */\n)\n{\n    /* In the standard (mutex-based) implementation the transmission\n       is always in progress, as long as there are samples in the TX fifo.\n       For this reasons this method has no effect in this case */\n    XCP_UNUSED_PARAM(queueType);\n    XCP_UNUSED_PARAM(daqId);\n\n    return XCP_SUCCESS;\n}\n\n#endif\n\n\nXcpErrorCode xcpTransportTxPacketSet(\n    XcpTransportQueueType_T queueType, /**< [in] id of the TX queue the packet has to be sent to */\n    uint16_T daqId,       /**< [in] id of the DAQ list the packet refers to */\n    void  *msgBuffer,       /* [in] pointer to the buffer containing the full XCP message */\n    size_t msgBufferSize,   /* [in] size (in AG units) of the buffer */\n    size_t xcpPktOffset,    /* [in] offset (in AG units) where the actual XCP packet content has been copied (within xcpMsg buffer)  */\n    size_t xcpPktSize       /* [in] size (in BYTEs) of the XCP packet */\n    )\n{\n    struct xcpFifoEntry *msgBufferHeader = NULL;\n    uint8_T *msgFrame = NULL;\n    size_t msgFrameMaxSize = 0;\n    size_t msgFrameSize = 0;\n    XcpErrorCode errorCode = XCP_SUCCESS;\n#ifdef XCP_LOCKLESS_SYNC_DATA_TRANSFER_SUPPORT\n    /* Lock must be excluded for DAQ lists associated to reserved memory pools */\n    boolean_T locklessTx = ((queueType == XCP_TRANSPORT_TX_DEFAULT_QUEUE)   ||\n                            (queueType == XCP_TRANSPORT_DEFERRED_TX_QUEUE)) &&\n                            (daqId < XCP_MEM_DAQ_RESERVED_POOLS_NUMBER);\n#else\n    XCP_UNUSED_PARAM(daqId);\n#endif\n\n    /* Input parameters validation */\n    XCP_ERROR_IF((queueType != XCP_TRANSPORT_DEFERRED_TX_QUEUE) && \n                 ((queueType < 0) || (queueType >= XCP_TRANSPORT_TX_QUEUES_TYPES_NUMBER)), \n                 XCP_INV_ARG, \"xcpTransportTxPacketSet: invalid queueType\\n\");\n    XCP_ERROR_IF(msgBuffer == NULL, XCP_INV_ARG, \"xcpTransportTxPacketSet: invalid msgBuffer\\n\");\n    XCP_ERROR_IF(xcpPktOffset != xcpTransportPacketOffset(), XCP_INV_ARG, \"xcpTransportTxPacketSet: invalid packet offset\\n\");\n    XCP_ERROR_IF(xcpPktSize == 0, XCP_INV_ARG, \"xcpTransportTxPacketSet: invalid packet size\\n\");\n    XCP_ERROR_IF(msgBufferSize < (xcpPktOffset + XCP_IN_HW_AG(xcpPktSize)), XCP_INV_ARG, \"xcpTransportTxPacketSet: invalid msgBufferSize\\n\");\n    XCP_ERROR_IF(!initialized, XCP_NOT_INITIALIZED, \"xcpTransportTxPacketSet: transport layer not initialized\\n\");\n\n    XCP_DIAG_UPDATE(XCP_TRANSPORT_TX_PACKET_SET_COUNTER);\n\n    msgBufferHeader = (struct xcpFifoEntry *) msgBuffer;\n    msgFrame = (uint8_T *)msgBuffer + sizeof(struct xcpFifoEntry);\n    msgFrameMaxSize = msgBufferSize - sizeof(struct xcpFifoEntry);\n\n#ifdef XCP_LOCKLESS_SYNC_DATA_TRANSFER_SUPPORT\n    if (!locklessTx) {\n#endif\n    /* Now fill the XCP frame content \n       @note the lock is used to protect the txFifo data structures from concurrent execution */\n    XCP_MUTEX_LOCK(txLock);\n\n#ifdef XCP_LOCKLESS_SYNC_DATA_TRANSFER_SUPPORT\n    }\n#endif\n\n    errorCode = xcpFrameCreateMsg(msgFrame, msgFrameMaxSize, &msgFrameSize, xcpPktSize);\n    if (errorCode != XCP_SUCCESS) {\n        XCP_PRINTF(\"xcpTransportTxPacketSet: xcpFrameCreateMsg failure detected (%d)\\n\", errorCode);\n        XCP_DIAG_UPDATE(XCP_TRANSPORT_FRAME_CREATE_MSG_ERROR);\n        goto error;\n    }\n\n    msgBufferHeader->msgFrameSize = msgFrameSize;\n\n#ifdef XCP_LOCKLESS_SYNC_DATA_TRANSFER_SUPPORT\n    if (!locklessTx) {\n#endif\n        /* Now that the packet has been created, we can add it to the txFifo for transmission */\n        xcpFifoEnqueue(&txFifo[queueType], msgBufferHeader);\n\n#ifdef XCP_LOCKLESS_SYNC_DATA_TRANSFER_SUPPORT\n    } else {\n        if (queueType == XCP_TRANSPORT_DEFERRED_TX_QUEUE) {\n            xcpFifoEnqueue(&daqDeferredTxFifo[daqId], msgBufferHeader);\n        } else {\n         xcpFifoEnqueue(&daqTxFifo[daqId], msgBufferHeader);\n        }\n    }\n#endif\n\n    XCP_DIAG_UPDATE(XCP_TRANSPORT_TX_PACKET_IN_COUNTER);\n\nerror:\n#ifdef XCP_LOCKLESS_SYNC_DATA_TRANSFER_SUPPORT\n    if (!locklessTx) {\n#endif\n    XCP_MUTEX_UNLOCK(txLock);\n#ifdef XCP_LOCKLESS_SYNC_DATA_TRANSFER_SUPPORT\n    }\n#endif\n\n    return errorCode;\n}\n\n\nXcpErrorCode xcpTransportTx(void)\n{\n    XcpErrorCode errorCode = XCP_SUCCESS;\n    size_t msgFrameSize = 0;\n    struct xcpFifoEntry *msgBufferHeader = NULL;\n    XcpTransportQueueType_T queueType = XCP_TRANSPORT_TX_HIGHEST_PRIO_QUEUE;\n#ifdef XCP_LOCKLESS_SYNC_DATA_TRANSFER_SUPPORT\n    /* Lock must be excluded for DAQ lists associated to reserved memory pools */\n    boolean_T locklessTx = false;\n#endif\n\n    XCP_ERROR_IF(!initialized, XCP_NOT_INITIALIZED, \"xcpTransportTx: transport layer not initialized\\n\");\n\n    XCP_DIAG_UPDATE(XCP_TRANSPORT_TX_COUNTER);\n\n    XCP_MUTEX_LOCK(txLock);\n    /* Extract the message from the Fifos, starting from the highest priority */\n    xcpFifoDequeue(&txFifo[queueType], &msgBufferHeader);\n\n    XCP_MUTEX_UNLOCK(txLock);\n\n#ifdef XCP_LOCKLESS_SYNC_DATA_TRANSFER_SUPPORT\n    if (msgBufferHeader == NULL) {\n        uint16_T i = 0;\n        /* If the highest priority is empty, check if one of the DAQ-specific ones\n           has a pending request */\n        for (i = 0; (i < XCP_MEM_DAQ_RESERVED_POOLS_NUMBER) && !locklessTx; i++) {\n            lastDaqIdTx = (lastDaqIdTx + 1) %  XCP_MEM_DAQ_RESERVED_POOLS_NUMBER;\n            if (daqTxRequest[lastDaqIdTx]) {\n                xcpFifoDequeue(&daqTxFifo[lastDaqIdTx], &msgBufferHeader);\n                if (msgBufferHeader == NULL) {\n                    /* if no data are available, we can acknowledge the request\n                       straight away */\n                    daqTxRequest[lastDaqIdTx] = false;\n                } else {\n                    locklessTx = true;\n                }\n            }\n        }\n    }\n#endif\n    if (msgBufferHeader == NULL) {\n        /* If the highest priority is empty, and no DAQ packets are available\n           try the default queue */\n        XCP_MUTEX_LOCK(txLock);\n\n        queueType = XCP_TRANSPORT_TX_DEFAULT_QUEUE;\n        xcpFifoDequeue(&txFifo[queueType], &msgBufferHeader);\n        XCP_MUTEX_UNLOCK(txLock);\n    }\n\n    if (msgBufferHeader != NULL) {\n        msgFrameSize = msgBufferHeader->msgFrameSize;\n\n        /* Trying to send one XCP message via the frame handler\n           @note The frame handler will be responsible for releasing\n                 the message buffer if the data has been successfully sent\n                 (return code XCP_SUCCESS).\n                 If not, the memory area won't be freed and the message\n                 will need to go back to the FIFO. */\n        errorCode = xcpFrameMsgSend(msgBufferHeader, sizeof(struct xcpFifoEntry), msgFrameSize);\n\n        if (errorCode != XCP_SUCCESS) {\n            XCP_DIAG_UPDATE(XCP_TRANSPORT_FRAME_SEND_ERROR);\n\n#ifdef XCP_LOCKLESS_SYNC_DATA_TRANSFER_SUPPORT\n            if (!locklessTx) {\n#endif\n            XCP_MUTEX_LOCK(txLock);\n\n            xcpFifoEnqueueHead(&txFifo[queueType], msgBufferHeader);\n\n            XCP_MUTEX_UNLOCK(txLock);\n#ifdef XCP_LOCKLESS_SYNC_DATA_TRANSFER_SUPPORT\n            } else {\n                xcpFifoEnqueueHead(&daqTxFifo[lastDaqIdTx], msgBufferHeader);\n            }\n#endif\n        } else {\n            XCP_DIAG_UPDATE(XCP_TRANSPORT_TX_PACKET_OUT_COUNTER);\n\n#ifdef XCP_LOCKLESS_SYNC_DATA_TRANSFER_SUPPORT\n            if (locklessTx && xcpFifoEmpty(&daqTxFifo[lastDaqIdTx])) {\n                /* All packets in the queue have been sent,\n                   the request can be acknowledged */\n                XCP_MEM_BARRIER();\n                daqTxRequest[lastDaqIdTx] = false;\n            }\n#endif\n        }\n    } else {\n        errorCode = XCP_EMPTY;\n        XCP_DIAG_UPDATE(XCP_TRANSPORT_TX_IS_EMPTY_COUNTER);\n    }\n\n    return errorCode;\n}\n\n\nXcpErrorCode xcpTransportRx(void)\n{\n    XcpErrorCode errorCode = XCP_SUCCESS;\n    size_t msgFrameSize = 0;\n    struct xcpFifoEntry *msgBufferHeader = NULL;\n\n    XCP_ERROR_IF(!initialized, XCP_NOT_INITIALIZED, \"xcpTransportRx: transport layer not initialized\\n\");\n\n    XCP_DIAG_UPDATE(XCP_TRANSPORT_RX_COUNTER);\n\n#ifdef XCP_LOCKLESS_SYNC_DATA_TRANSFER_SUPPORT\n    /* Make sure that the blocks associated to the CTO reserved memory\n       pool are made available for subsequent allocations */\n    xcpMemReservedPoolFlushFreeMem(xcpCtoReservedMemPoolId);\n#endif\n\n    /* Trying to receive one XCP message via the frame handler\n       @note The frame handler is also responsible for allocating the\n             memory area and it is no longer responsible for the ownership\n             of the memory if the function has been successfully executed\n             (error code XCP_SUCCESS)\n             If there are no messages available, the return code is XCP_EMPTY */\n    errorCode = xcpFrameMsgRecv((void**) &msgBufferHeader, sizeof(struct xcpFifoEntry), &msgFrameSize);\n\n    if (errorCode == XCP_SUCCESS) {\n        /* Add the message to the Fifo */\n        msgBufferHeader->msgFrameSize = msgFrameSize;\n\n        XCP_MUTEX_LOCK(rxLock);\n\n        /* Only one RX queue available */\n        xcpFifoEnqueue(&rxFifo[XCP_TRANSPORT_RX_DEFAULT_QUEUE], msgBufferHeader);\n        XCP_DIAG_UPDATE(XCP_TRANSPORT_RX_PACKET_IN_COUNTER);\n\n        XCP_MUTEX_UNLOCK(rxLock);\n    } else if (errorCode == XCP_EMPTY) {\n        XCP_DIAG_UPDATE(XCP_TRANSPORT_RX_IS_EMPTY_COUNTER);\n    } else {\n        XCP_DIAG_UPDATE(XCP_TRANSPORT_FRAME_RECV_ERROR);\n    }\n\n    return errorCode;\n}\n\n\nXcpErrorCode xcpTransportRxPacketGet(\n    XcpTransportQueueType_T queueType, /**< [in] id of the RX queue the packet has to be received from */\n    void  **msgBuffer,     /* [out] pointer to the buffer containing the full XCP message that has been extracted */\n    size_t *msgBufferSize, /* [out] size (in AG units) of the buffer */\n    size_t *xcpPktOffset,  /* [out] offset (in AG units) of the XCP packet within the message buffer */\n    size_t *xcpPktSize     /* [out] size (in BYTEs) of the XCP packet */\n    )\n{\n    struct xcpFifoEntry *msgBufferHeader = NULL;\n    uint8_T *msgFrame = NULL;\n    size_t msgFrameSize = 0;\n    XcpErrorCode errorCode = XCP_SUCCESS;\n\n    /* Input parameters validation */\n    XCP_ERROR_IF((queueType < 0) || (queueType >= XCP_TRANSPORT_RX_QUEUES_TYPES_NUMBER), XCP_INV_ARG, \"xcpTransportRxPacketGet: invalid queueType\\n\");\n    XCP_ERROR_IF(msgBuffer == NULL, XCP_INV_ARG, \"xcpTransportRxPacketGet: invalid msgBuffer pointer\\n\");\n    XCP_ERROR_IF(msgBufferSize == NULL, XCP_INV_ARG, \"xcpTransportRxPacketGet: invalid msgBufferSize pointer\\n\");\n    XCP_ERROR_IF(xcpPktOffset == NULL, XCP_INV_ARG, \"xcpTransportRxPacketGet: invalid xcpPktOffset pointer\\n\");\n    XCP_ERROR_IF(xcpPktSize == NULL, XCP_INV_ARG, \"xcpTransportRxPacketGet: invalid xcpPktSize pointer\\n\");\n    XCP_ERROR_IF(!initialized, XCP_NOT_INITIALIZED, \"xcpTransportRxPacketGet: transport layer not initialized\\n\");\n\n    XCP_DIAG_UPDATE(XCP_TRANSPORT_RX_PACKET_GET_COUNTER);\n\n    XCP_MUTEX_LOCK(rxLock);\n\n    xcpFifoDequeue(&rxFifo[queueType], &msgBufferHeader);\n\n    XCP_MUTEX_UNLOCK(rxLock);\n\n    if (msgBufferHeader == NULL) {\n        return XCP_EMPTY; /* No messages in the FIFO */\n    }\n    else {\n        XCP_DIAG_UPDATE(XCP_TRANSPORT_RX_PACKET_OUT_COUNTER);\n    }\n\n    msgFrame = (uint8_T *) msgBufferHeader + sizeof(struct xcpFifoEntry);\n    msgFrameSize = msgBufferHeader->msgFrameSize;\n\n    /* Extract a new XCP packet from the XCP message, and carry out all the relevant checks in the frame format */\n    errorCode = xcpFrameExtractPacket(msgFrame, msgFrameSize, xcpPktSize);\n    if (errorCode != XCP_SUCCESS) {\n        XCP_DIAG_UPDATE(XCP_TRANSPORT_FRAME_EXTRACT_PACKET_ERROR);\n    }\n\n    *msgBuffer = msgBufferHeader;\n    *msgBufferSize = msgBufferHeader->msgFrameSize + sizeof(struct xcpFifoEntry);\n    *xcpPktOffset = xcpTransportPacketOffset();\n\n    return errorCode;\n}\n\n\nsize_t xcpTransportPacketOffset(void)\n{\n    size_t size = sizeof(struct xcpFifoEntry);\n\n    size += XCP_IN_HW_AG(xcpFrameHeaderSize());\n\n    return size;\n}\n\n/* xcpPacketSize is the number of octets in the XCP Packet\n * Return value the buffer size in terms of target memory granularity needed to contain this packet.\n * On 32-bit address granularity processor, a packet of 6 contiguous BYTEs, we require 2 memory\n *  locations to contain it.\n */\nsize_t xcpTransportMsgBufferSize(size_t xcpPacketSize, XcpPacketType pktType)\n{\n    size_t size = 0;\n    size_t maxPacketSize = 0;\n    \n    maxPacketSize = (pktType == XCP_CTO) ? xcpFrameMaxCtoSize() : xcpFrameMaxDtoSize();\n\n    if (xcpPacketSize > maxPacketSize) {\n        XCP_PRINTF(\"xcpTransportMsgSize: invalid xcpPacketSize\\n\");\n        return 0;\n    }\n\n    size = sizeof(struct xcpFifoEntry);\n\n    size += XCP_IN_HW_AG(xcpFrameHeaderSize());\n    size += XCP_IN_HW_AG(xcpPacketSize);\n    size += XCP_IN_HW_AG(xcpFrameTailSize());\n\n    return size;\n}\n\n\nsize_t xcpTransportMaxDtoSize(void)\n{\n    return xcpFrameMaxDtoSize();\n}\n\n\nsize_t xcpTransportMaxCtoSize(void)\n{\n    return xcpFrameMaxCtoSize();\n}\n\n\nXcpErrorCode xcpTransportRestart(void)\n{\n    XcpErrorCode errorCode = XCP_SUCCESS;\n\n    XCP_DIAG_UPDATE(XCP_TRANSPORT_RESTART_COUNTER);\n\n    /* Restart Frame Handler */\n    errorCode = xcpFrameRestart();\n    if (errorCode != XCP_SUCCESS) {\n        XCP_PRINTF(\"xcpTransportRestart: error (%d) detected during frame handler restart\\n\", errorCode);\n        XCP_DIAG_UPDATE(XCP_TRANSPORT_FRAME_RESTART_ERROR);\n        return errorCode;\n    }\n\n    /* Empty TX and RX fifos */\n    xcpTransportEmptyTxFifo();\n    xcpTransportEmptyRxFifo();\n\n    return errorCode;\n}\n\n\nXcpErrorCode xcpTransportResynch(void)\n{\n    XcpErrorCode errorCode = XCP_SUCCESS;\n\n    XCP_DIAG_UPDATE(XCP_TRANSPORT_RESYNCH_COUNTER);\n\n    /* Restart Frame Handler */\n    errorCode = xcpFrameRestart();\n    if (errorCode != XCP_SUCCESS) {\n        XCP_PRINTF(\"xcpTransportRestart: error (%d) detected during frame handler restart\\n\", errorCode);\n        XCP_DIAG_UPDATE(XCP_TRANSPORT_FRAME_RESTART_ERROR);\n        return errorCode;\n    }\n\n    /* Empty TX FIFO */\n    xcpTransportEmptyTxFifo();\n\n    return errorCode;\n}\n\n\nxcpPoolId_T xcpTransportCtoReservedMemPoolId(void)\n{\n    return xcpCtoReservedMemPoolId;\n}\n\n\nXcpErrorCode xcpTransportReset(void)\n{\n    XcpErrorCode errorCode = XCP_SUCCESS;\n    XcpTransportQueueType_T i = 0;\n\n    if (!initialized) {\n        XCP_PRINTF(\"xcpTransportReset: transport layer already reset\\n\");\n        return XCP_SUCCESS; /* Nothing to do: just printing out a warning message*/\n    }\n\n    XCP_DIAG_UPDATE(XCP_TRANSPORT_RESET_COUNTER);\n\n    /* Reset XCP Frame handler */\n    errorCode = xcpFrameReset();\n    if (errorCode != XCP_SUCCESS) {\n        XCP_PRINTF(\"xcpTransportReset: error (%d) detected during frame handler reset\\n\", errorCode);\n        XCP_DIAG_UPDATE(XCP_TRANSPORT_FRAME_RESET_ERROR);\n        return errorCode;\n    }\n\n    /* Before resetting the txFifo and rxFifo, all the message buffers still enqueued need to be freed\n    as the ownership of the memory area was explicitly given to the Transport Layer */\n    xcpTransportEmptyTxFifo();\n    xcpTransportEmptyRxFifo();\n\n    /* Destroy the reserved memory pool */\n    xcpMemReservedPoolDestroy(xcpCtoReservedMemPoolId);\n\n    /* Reset XCP memory allocator */\n    errorCode = xcpMemReset();\n    if (errorCode != XCP_SUCCESS) {\n        XCP_PRINTF(\"xcpTransportReset: error (%d) detected during memory allocator reset\\n\", errorCode);\n        XCP_DIAG_UPDATE(XCP_TRANSPORT_MEM_RESET_ERROR);\n        return errorCode;\n    }\n\n    /* Now we can reset Tx and Rx Fifos */\n    /* Initialize Tx and Rx data structures*/\n    for (i = 0; i < XCP_TRANSPORT_TX_QUEUES_TYPES_NUMBER; i++) {\n        xcpFifoReset(&txFifo[i]);\n    }\n    for (i = 0; i < XCP_TRANSPORT_RX_QUEUES_TYPES_NUMBER; i++) {\n        xcpFifoReset(&rxFifo[i]);\n    }\n\n#ifdef XCP_LOCKLESS_SYNC_DATA_TRANSFER_SUPPORT\n    for (i = 0; i < XCP_MEM_DAQ_RESERVED_POOLS_NUMBER; i++) {\n        xcpFifoReset(&daqTxFifo[i]);\n        xcpFifoReset(&daqDeferredTxFifo[i]);\n        daqTxRequest[i] = false;\n    }\n    lastDaqIdTx = 0xFFFF;\n#endif\n\n    initialized = false;\n\n    return errorCode;\n}\n\n\n"},{"name":"xcp_utils.c","type":"source","group":"legacy","path":"C:\\Users\\Sophie\\Documents\\Hochschule\\Master\\Systeme und Programme\\toolbox\\coder\\xcp\\src\\target\\server\\common","tag":"","groupDisplay":"Other files","code":"/* Copyright 2022 The MathWorks, Inc. */\n\n#include \"xcp_utils.h\"\n\n/**\n * Sort elements in `toSort` in ascending order, keeping the correspondence with elements of\n * `toKeepAligned`.\n **/\nvoid xcpSortArray(size_t *toSort, size_t *toKeepAligned, size_t size)\n{\n    unsigned char sorted = size == 0; /* an empty array is already sorted */\n    size_t idx = 0;\n\n    while (!sorted) {\n        sorted = 1;\n        for (idx = 0; idx < size - 1; ++idx) {\n            if (toSort[idx + 1] < toSort[idx]) {\n                size_t tempToSort = toSort[idx];\n                size_t tempToKeepAligned = toKeepAligned[idx];\n\n                sorted = 0;\n\n                toKeepAligned[idx] = toKeepAligned[idx + 1];\n                toKeepAligned[idx + 1] = tempToKeepAligned;\n\n                toSort[idx] = toSort[idx + 1];\n                toSort[idx + 1] =  tempToSort;\n            }\n        }\n    }\n}\n"}],"coverage":[{"id":"SimulinkCoverage","name":"Simulink Coverage","files":[]},{"id":"Bullseye","name":"Bullseye Coverage","files":[]},{"id":"LDRA","name":"LDRA Testbed","files":[]}],"features":{"annotation":false,"coverage":true,"profiling":true,"tooltip":true,"coverageTooltip":true,"showJustificationLinks":true,"useMWTable":false,"showProfilingInfo":true,"showTaskSummary":true,"showProtectedV2Report":true}};