/*
 * Abstandsensor.c
 *
 * Academic License - for use in teaching, academic research, and meeting
 * course requirements at degree granting institutions only.  Not for
 * government, commercial, or other organizational use.
 *
 * Code generation for model "Abstandsensor".
 *
 * Model version              : 10.15
 * Simulink Coder version : 24.1 (R2024a) 19-Nov-2023
 * C source code generated on : Mon Jan 13 17:19:51 2025
 *
 * Target selection: ert.tlc
 * Embedded hardware selection: Atmel->AVR
 * Code generation objectives: Unspecified
 * Validation result: Not run
 */

#include "Abstandsensor.h"
#include "Abstandsensor_types.h"
#include "rtwtypes.h"
#include <math.h>
#include <string.h>
#include "Abstandsensor_private.h"

/* Block signals (default storage) */
B_Abstandsensor_T Abstandsensor_B;

/* Block states (default storage) */
DW_Abstandsensor_T Abstandsensor_DW;

/* Real-time model */
static RT_MODEL_Abstandsensor_T Abstandsensor_M_;
RT_MODEL_Abstandsensor_T *const Abstandsensor_M = &Abstandsensor_M_;

/* Forward declaration for local functions */
static void Abstan_MedianFilterCG_resetImpl(c_dsp_internal_MedianFilterCG_T *obj);
static void A_MedianFilterCG_trickleDownMax(c_dsp_internal_MedianFilterCG_T *obj,
  real_T i);
static void A_MedianFilterCG_trickleDownMin(c_dsp_internal_MedianFilterCG_T *obj,
  real_T i);
real_T look1_binlxpw(real_T u0, const real_T bp0[], const real_T table[],
                     uint32_T maxIndex)
{
  real_T frac;
  real_T yL_0d0;
  uint32_T bpIdx;
  uint32_T iLeft;
  uint32_T iRght;

  /* Column-major Lookup 1-D
     Search method: 'binary'
     Use previous index: 'off'
     Interpolation method: 'Linear point-slope'
     Extrapolation method: 'Linear'
     Use last breakpoint for index at or above upper limit: 'off'
     Remove protection against out-of-range input in generated code: 'off'
   */
  /* Prelookup - Index and Fraction
     Index Search method: 'binary'
     Extrapolation method: 'Linear'
     Use previous index: 'off'
     Use last breakpoint for index at or above upper limit: 'off'
     Remove protection against out-of-range input in generated code: 'off'
   */
  if (u0 <= bp0[0UL]) {
    iLeft = 0UL;
    frac = (u0 - bp0[0UL]) / (bp0[1UL] - bp0[0UL]);
  } else if (u0 < bp0[maxIndex]) {
    /* Binary Search */
    bpIdx = maxIndex >> 1UL;
    iLeft = 0UL;
    iRght = maxIndex;
    while (iRght - iLeft > 1UL) {
      if (u0 < bp0[bpIdx]) {
        iRght = bpIdx;
      } else {
        iLeft = bpIdx;
      }

      bpIdx = (iRght + iLeft) >> 1UL;
    }

    frac = (u0 - bp0[iLeft]) / (bp0[iLeft + 1UL] - bp0[iLeft]);
  } else {
    iLeft = maxIndex - 1UL;
    frac = (u0 - bp0[maxIndex - 1UL]) / (bp0[maxIndex] - bp0[maxIndex - 1UL]);
  }

  /* Column-major Interpolation 1-D
     Interpolation method: 'Linear point-slope'
     Use last breakpoint for index at or above upper limit: 'off'
     Overflow mode: 'portable wrapping'
   */
  yL_0d0 = table[iLeft];
  return (table[iLeft + 1UL] - yL_0d0) * frac + yL_0d0;
}

static void Abstan_MedianFilterCG_resetImpl(c_dsp_internal_MedianFilterCG_T *obj)
{
  real_T cnt1;
  real_T cnt2;
  int16_T i;
  memset(&obj->pBuf[0], 0, 30U * sizeof(real_T));
  memset(&obj->pPos[0], 0, 30U * sizeof(real_T));
  memset(&obj->pHeap[0], 0, 30U * sizeof(real_T));

  /* Start for MATLABSystem: '<Root>/Median Filter' */
  obj->pWinLen = 30.0;
  obj->pIdx = obj->pWinLen;

  /* Start for MATLABSystem: '<Root>/Median Filter' */
  obj->pMidHeap = ceil((obj->pWinLen + 1.0) / 2.0);
  cnt1 = (obj->pWinLen - 1.0) / 2.0;

  /* Start for MATLABSystem: '<Root>/Median Filter' */
  if (cnt1 < 0.0) {
    obj->pMinHeapLength = ceil(cnt1);
  } else {
    obj->pMinHeapLength = floor(cnt1);
  }

  cnt1 = obj->pWinLen / 2.0;

  /* Start for MATLABSystem: '<Root>/Median Filter' */
  if (cnt1 < 0.0) {
    obj->pMaxHeapLength = ceil(cnt1);
  } else {
    obj->pMaxHeapLength = floor(cnt1);
  }

  cnt1 = 1.0;
  cnt2 = obj->pWinLen;
  for (i = 0; i < 30; i++) {
    /* Start for MATLABSystem: '<Root>/Median Filter' */
    if (fmod(30.0 - (real_T)i, 2.0) == 0.0) {
      obj->pPos[29 - i] = cnt1;
      cnt1++;
    } else {
      obj->pPos[29 - i] = cnt2;
      cnt2--;
    }

    obj->pHeap[(int16_T)obj->pPos[29 - i] - 1] = 30.0 - (real_T)i;
  }
}

static void A_MedianFilterCG_trickleDownMax(c_dsp_internal_MedianFilterCG_T *obj,
  real_T i)
{
  real_T ind2;
  real_T temp;
  real_T tmp;
  real_T u_tmp;
  boolean_T exitg1;
  exitg1 = false;
  while ((!exitg1) && (i >= -obj->pMaxHeapLength)) {
    if ((i < -1.0) && (i > -obj->pMaxHeapLength) && (obj->pBuf[(int16_T)
         obj->pHeap[(int16_T)(i + obj->pMidHeap) - 1] - 1] < obj->pBuf[(int16_T)
         obj->pHeap[(int16_T)((i - 1.0) + obj->pMidHeap) - 1] - 1])) {
      i--;
    }

    u_tmp = i / 2.0;
    if (u_tmp < 0.0) {
      temp = ceil(u_tmp);
    } else {
      temp = floor(u_tmp);
    }

    ind2 = i + obj->pMidHeap;
    tmp = obj->pHeap[(int16_T)ind2 - 1];
    if (!(obj->pBuf[(int16_T)obj->pHeap[(int16_T)(temp + obj->pMidHeap) - 1] - 1]
          < obj->pBuf[(int16_T)tmp - 1])) {
      exitg1 = true;
    } else {
      if (u_tmp < 0.0) {
        temp = ceil(u_tmp);
      } else {
        temp = floor(u_tmp);
      }

      u_tmp = temp + obj->pMidHeap;
      temp = obj->pHeap[(int16_T)u_tmp - 1];
      obj->pHeap[(int16_T)u_tmp - 1] = tmp;
      obj->pHeap[(int16_T)ind2 - 1] = temp;
      obj->pPos[(int16_T)obj->pHeap[(int16_T)u_tmp - 1] - 1] = u_tmp;
      obj->pPos[(int16_T)obj->pHeap[(int16_T)ind2 - 1] - 1] = ind2;
      i *= 2.0;
    }
  }
}

static void A_MedianFilterCG_trickleDownMin(c_dsp_internal_MedianFilterCG_T *obj,
  real_T i)
{
  real_T ind1;
  real_T tmp;
  real_T tmp_0;
  real_T u_tmp;
  boolean_T exitg1;
  exitg1 = false;
  while ((!exitg1) && (i <= obj->pMinHeapLength)) {
    if ((i > 1.0) && (i < obj->pMinHeapLength) && (obj->pBuf[(int16_T)obj->
         pHeap[(int16_T)((i + 1.0) + obj->pMidHeap) - 1] - 1] < obj->pBuf
         [(int16_T)obj->pHeap[(int16_T)(i + obj->pMidHeap) - 1] - 1])) {
      i++;
    }

    u_tmp = i / 2.0;
    if (u_tmp < 0.0) {
      tmp = ceil(u_tmp);
    } else {
      tmp = floor(u_tmp);
    }

    ind1 = i + obj->pMidHeap;
    tmp_0 = obj->pHeap[(int16_T)ind1 - 1];
    if (!(obj->pBuf[(int16_T)tmp_0 - 1] < obj->pBuf[(int16_T)obj->pHeap[(int16_T)
          (tmp + obj->pMidHeap) - 1] - 1])) {
      exitg1 = true;
    } else {
      if (u_tmp < 0.0) {
        tmp = ceil(u_tmp);
      } else {
        tmp = floor(u_tmp);
      }

      u_tmp = tmp + obj->pMidHeap;
      obj->pHeap[(int16_T)ind1 - 1] = obj->pHeap[(int16_T)u_tmp - 1];
      obj->pHeap[(int16_T)u_tmp - 1] = tmp_0;
      obj->pPos[(int16_T)obj->pHeap[(int16_T)ind1 - 1] - 1] = ind1;
      obj->pPos[(int16_T)obj->pHeap[(int16_T)u_tmp - 1] - 1] = u_tmp;
      i *= 2.0;
    }
  }
}

/* Model step function */
void Abstandsensor_step(void)
{
  real_T LED3;
  real_T temp;
  real_T tmp;
  int16_T LED5;
  uint16_T b_varargout_1;
  boolean_T exitg1;

  /* MATLABSystem: '<Root>/IR_Signal_roh' */
  if (Abstandsensor_DW.obj_b.SampleTime !=
      Abstandsensor_P.IR_Signal_roh_SampleTime) {
    Abstandsensor_DW.obj_b.SampleTime = Abstandsensor_P.IR_Signal_roh_SampleTime;
  }

  Abstandsensor_DW.obj_b.AnalogInDriverObj.MW_ANALOGIN_HANDLE =
    MW_AnalogIn_GetHandle(14UL);
  MW_AnalogInSingle_ReadResult
    (Abstandsensor_DW.obj_b.AnalogInDriverObj.MW_ANALOGIN_HANDLE, &b_varargout_1,
     MW_ANALOGIN_UINT16);

  /* MATLABSystem: '<Root>/Median Filter' incorporates:
   *  DataTypeConversion: '<Root>/Data Type Conversion'
   *  MATLABSystem: '<Root>/IR_Signal_roh'
   * */
  if (Abstandsensor_DW.obj.pMID.isInitialized != 1L) {
    Abstandsensor_DW.obj.pMID.isInitialized = 1L;
    Abstandsensor_DW.obj.pMID.isSetupComplete = true;
    Abstan_MedianFilterCG_resetImpl(&Abstandsensor_DW.obj.pMID);
  }

  Abstandsensor_B.vprev = Abstandsensor_DW.obj.pMID.pBuf[(int16_T)
    Abstandsensor_DW.obj.pMID.pIdx - 1];
  Abstandsensor_DW.obj.pMID.pBuf[(int16_T)Abstandsensor_DW.obj.pMID.pIdx - 1] =
    b_varargout_1;
  Abstandsensor_B.p = Abstandsensor_DW.obj.pMID.pPos[(int16_T)
    Abstandsensor_DW.obj.pMID.pIdx - 1];
  Abstandsensor_DW.obj.pMID.pIdx++;
  if (Abstandsensor_DW.obj.pMID.pWinLen + 1.0 == Abstandsensor_DW.obj.pMID.pIdx)
  {
    Abstandsensor_DW.obj.pMID.pIdx = 1.0;
  }

  if (Abstandsensor_B.p > Abstandsensor_DW.obj.pMID.pMidHeap) {
    if (Abstandsensor_B.vprev < b_varargout_1) {
      A_MedianFilterCG_trickleDownMin(&Abstandsensor_DW.obj.pMID,
        (Abstandsensor_B.p - Abstandsensor_DW.obj.pMID.pMidHeap) * 2.0);
    } else {
      Abstandsensor_B.vprev = Abstandsensor_B.p -
        Abstandsensor_DW.obj.pMID.pMidHeap;
      exitg1 = false;
      while ((!exitg1) && (Abstandsensor_B.vprev > 0.0)) {
        Abstandsensor_B.p = Abstandsensor_B.vprev +
          Abstandsensor_DW.obj.pMID.pMidHeap;
        LED3 = floor(Abstandsensor_B.vprev / 2.0) +
          Abstandsensor_DW.obj.pMID.pMidHeap;
        tmp = Abstandsensor_DW.obj.pMID.pHeap[(int16_T)Abstandsensor_B.p - 1];
        temp = Abstandsensor_DW.obj.pMID.pHeap[(int16_T)LED3 - 1];
        if (!(Abstandsensor_DW.obj.pMID.pBuf[(int16_T)tmp - 1] <
              Abstandsensor_DW.obj.pMID.pBuf[(int16_T)temp - 1])) {
          exitg1 = true;
        } else {
          Abstandsensor_DW.obj.pMID.pHeap[(int16_T)Abstandsensor_B.p - 1] = temp;
          Abstandsensor_DW.obj.pMID.pHeap[(int16_T)LED3 - 1] = tmp;
          Abstandsensor_DW.obj.pMID.pPos[(int16_T)
            Abstandsensor_DW.obj.pMID.pHeap[(int16_T)Abstandsensor_B.p - 1] - 1]
            = Abstandsensor_B.p;
          Abstandsensor_DW.obj.pMID.pPos[(int16_T)
            Abstandsensor_DW.obj.pMID.pHeap[(int16_T)LED3 - 1] - 1] = LED3;
          Abstandsensor_B.vprev = floor(Abstandsensor_B.vprev / 2.0);
        }
      }

      if (Abstandsensor_B.vprev == 0.0) {
        A_MedianFilterCG_trickleDownMax(&Abstandsensor_DW.obj.pMID, -1.0);
      }
    }
  } else if (Abstandsensor_B.p < Abstandsensor_DW.obj.pMID.pMidHeap) {
    if (b_varargout_1 < Abstandsensor_B.vprev) {
      A_MedianFilterCG_trickleDownMax(&Abstandsensor_DW.obj.pMID,
        (Abstandsensor_B.p - Abstandsensor_DW.obj.pMID.pMidHeap) * 2.0);
    } else {
      Abstandsensor_B.vprev = Abstandsensor_B.p -
        Abstandsensor_DW.obj.pMID.pMidHeap;
      exitg1 = false;
      while ((!exitg1) && (Abstandsensor_B.vprev < 0.0)) {
        temp = Abstandsensor_B.vprev / 2.0;
        if (temp < 0.0) {
          Abstandsensor_B.p = ceil(temp);
        } else {
          Abstandsensor_B.p = -0.0;
        }

        LED3 = Abstandsensor_B.vprev + Abstandsensor_DW.obj.pMID.pMidHeap;
        tmp = Abstandsensor_DW.obj.pMID.pHeap[(int16_T)LED3 - 1];
        if (!(Abstandsensor_DW.obj.pMID.pBuf[(int16_T)
              Abstandsensor_DW.obj.pMID.pHeap[(int16_T)(Abstandsensor_B.p +
              Abstandsensor_DW.obj.pMID.pMidHeap) - 1] - 1] <
              Abstandsensor_DW.obj.pMID.pBuf[(int16_T)tmp - 1])) {
          exitg1 = true;
        } else {
          if (temp < 0.0) {
            Abstandsensor_B.p = ceil(temp);
            Abstandsensor_B.vprev = Abstandsensor_B.p;
          } else {
            Abstandsensor_B.p = -0.0;
            Abstandsensor_B.vprev = -0.0;
          }

          Abstandsensor_B.p += Abstandsensor_DW.obj.pMID.pMidHeap;
          temp = Abstandsensor_DW.obj.pMID.pHeap[(int16_T)Abstandsensor_B.p - 1];
          Abstandsensor_DW.obj.pMID.pHeap[(int16_T)Abstandsensor_B.p - 1] = tmp;
          Abstandsensor_DW.obj.pMID.pHeap[(int16_T)LED3 - 1] = temp;
          Abstandsensor_DW.obj.pMID.pPos[(int16_T)
            Abstandsensor_DW.obj.pMID.pHeap[(int16_T)Abstandsensor_B.p - 1] - 1]
            = Abstandsensor_B.p;
          Abstandsensor_DW.obj.pMID.pPos[(int16_T)
            Abstandsensor_DW.obj.pMID.pHeap[(int16_T)LED3 - 1] - 1] = LED3;
        }
      }

      if (Abstandsensor_B.vprev == 0.0) {
        A_MedianFilterCG_trickleDownMin(&Abstandsensor_DW.obj.pMID, 1.0);
      }
    }
  } else {
    if (Abstandsensor_DW.obj.pMID.pMaxHeapLength != 0.0) {
      A_MedianFilterCG_trickleDownMax(&Abstandsensor_DW.obj.pMID, -1.0);
    }

    if (Abstandsensor_DW.obj.pMID.pMinHeapLength > 0.0) {
      A_MedianFilterCG_trickleDownMin(&Abstandsensor_DW.obj.pMID, 1.0);
    }
  }

  /* MATLABSystem: '<Root>/Median Filter' */
  Abstandsensor_B.MedianFilter = (Abstandsensor_DW.obj.pMID.pBuf[(int16_T)
    Abstandsensor_DW.obj.pMID.pHeap[(int16_T)(Abstandsensor_DW.obj.pMID.pMidHeap
    - 1.0) - 1] - 1] + Abstandsensor_DW.obj.pMID.pBuf[(int16_T)
    Abstandsensor_DW.obj.pMID.pHeap[(int16_T)Abstandsensor_DW.obj.pMID.pMidHeap
    - 1] - 1]) / 2.0;

  /* Product: '<Root>/Divide' incorporates:
   *  Constant: '<Root>/Constant'
   *  Lookup_n-D: '<Root>/1-D Lookup Table'
   *  MATLABSystem: '<Root>/Median Filter'
   */
  Abstandsensor_B.Divide = Abstandsensor_P.Constant_Value / look1_binlxpw
    (Abstandsensor_B.MedianFilter, Abstandsensor_P.uDLookupTable_bp01Data,
     Abstandsensor_P.uDLookupTable_tableData, 7UL);

  /* MATLAB Function: '<Root>/controlLED' */
  /* MATLAB Function 'controlLED': '<S1>:1' */
  /* '<S1>:1:30' [LED1, LED2, LED3, LED4, LED5] = deal(0, 0, 0, 0, 0); */
  Abstandsensor_B.vprev = 0.0;
  Abstandsensor_B.p = 0.0;
  LED3 = 0.0;
  temp = 0.0;
  LED5 = 0;

  /* '<S1>:1:33' if sensorValue <= 1.58*10^-5 */
  if (Abstandsensor_B.Divide <= 1.5799999999999998E-5) {
    /* '<S1>:1:34' [LED1, LED2, LED3, LED4, LED5] = deal(255, 0, 0, 0, 0); */
    Abstandsensor_B.vprev = 255.0;
  } else if (Abstandsensor_B.Divide <= 1.61E-5) {
    /* '<S1>:1:35' elseif sensorValue <= 1.61*10^-5 */
    /* '<S1>:1:36' [LED1, LED2, LED3, LED4, LED5] = deal(0, 255, 0, 0, 0); */
    Abstandsensor_B.p = 255.0;
  } else if (Abstandsensor_B.Divide <= 1.64E-5) {
    /* '<S1>:1:37' elseif sensorValue <= 1.64*10^-5 */
    /* '<S1>:1:38' [LED1, LED2, LED3, LED4, LED5] = deal(0, 0, 255, 0, 0); */
    LED3 = 255.0;
  } else if (Abstandsensor_B.Divide <= 1.6999999999999996E-5) {
    /* '<S1>:1:39' elseif sensorValue <= 1.70*10^-5 */
    /* '<S1>:1:40' [LED1, LED2, LED3, LED4, LED5] = deal(0, 0, 0, 255, 0); */
    temp = 255.0;
  } else if (Abstandsensor_B.Divide > 1.6999999999999996E-5) {
    /* '<S1>:1:41' elseif sensorValue > 1.70*10^-5 */
    /* '<S1>:1:42' [LED1, LED2, LED3, LED4, LED5] = deal(0, 0, 0, 0, 255); */
    LED5 = 255;
  }

  /* End of MATLAB Function: '<Root>/controlLED' */

  /* MATLABSystem: '<Root>/LED1_rotVielzuschwer' */
  writeDigitalPin(3, (uint8_T)Abstandsensor_B.vprev);

  /* MATLABSystem: '<Root>/LED2_gelbZuschwer' */
  writeDigitalPin(4, (uint8_T)Abstandsensor_B.p);

  /* MATLABSystem: '<Root>/LED3_gruenPassend' */
  writeDigitalPin(5, (uint8_T)LED3);

  /* MATLABSystem: '<Root>/LED4_gelbZuleicht' */
  writeDigitalPin(6, (uint8_T)temp);

  /* MATLABSystem: '<Root>/LED5_rotVielzuleicht' */
  writeDigitalPin(7, (uint8_T)LED5);

  /* Update absolute time for base rate */
  /* The "clockTick0" counts the number of times the code of this task has
   * been executed. The absolute time is the multiplication of "clockTick0"
   * and "Timing.stepSize0". Size of "clockTick0" ensures timer will not
   * overflow during the application lifespan selected.
   * Timer of this task consists of two 32 bit unsigned integers.
   * The two integers represent the low bits Timing.clockTick0 and the high bits
   * Timing.clockTickH0. When the low bit overflows to 0, the high bits increment.
   */
  if (!(++Abstandsensor_M->Timing.clockTick0)) {
    ++Abstandsensor_M->Timing.clockTickH0;
  }

  Abstandsensor_M->Timing.taskTime0 = Abstandsensor_M->Timing.clockTick0 *
    Abstandsensor_M->Timing.stepSize0 + Abstandsensor_M->Timing.clockTickH0 *
    Abstandsensor_M->Timing.stepSize0 * 4294967296.0;
}

/* Model initialize function */
void Abstandsensor_initialize(void)
{
  /* Registration code */

  /* initialize real-time model */
  (void) memset((void *)Abstandsensor_M, 0,
                sizeof(RT_MODEL_Abstandsensor_T));
  rtmSetTFinal(Abstandsensor_M, -1);
  Abstandsensor_M->Timing.stepSize0 = 0.2;

  /* External mode info */
  Abstandsensor_M->Sizes.checksums[0] = (2049694028U);
  Abstandsensor_M->Sizes.checksums[1] = (2300151249U);
  Abstandsensor_M->Sizes.checksums[2] = (1223485843U);
  Abstandsensor_M->Sizes.checksums[3] = (3579557617U);

  {
    static const sysRanDType rtAlwaysEnabled = SUBSYS_RAN_BC_ENABLE;
    static RTWExtModeInfo rt_ExtModeInfo;
    static const sysRanDType *systemRan[9];
    Abstandsensor_M->extModeInfo = (&rt_ExtModeInfo);
    rteiSetSubSystemActiveVectorAddresses(&rt_ExtModeInfo, systemRan);
    systemRan[0] = &rtAlwaysEnabled;
    systemRan[1] = &rtAlwaysEnabled;
    systemRan[2] = &rtAlwaysEnabled;
    systemRan[3] = &rtAlwaysEnabled;
    systemRan[4] = &rtAlwaysEnabled;
    systemRan[5] = &rtAlwaysEnabled;
    systemRan[6] = &rtAlwaysEnabled;
    systemRan[7] = &rtAlwaysEnabled;
    systemRan[8] = &rtAlwaysEnabled;
    rteiSetModelMappingInfoPtr(Abstandsensor_M->extModeInfo,
      &Abstandsensor_M->SpecialInfo.mappingInfo);
    rteiSetChecksumsPtr(Abstandsensor_M->extModeInfo,
                        Abstandsensor_M->Sizes.checksums);
    rteiSetTPtr(Abstandsensor_M->extModeInfo, rtmGetTPtr(Abstandsensor_M));
  }

  /* block I/O */
  (void) memset(((void *) &Abstandsensor_B), 0,
                sizeof(B_Abstandsensor_T));

  /* states (dwork) */
  (void) memset((void *)&Abstandsensor_DW, 0,
                sizeof(DW_Abstandsensor_T));

  /* Start for MATLABSystem: '<Root>/IR_Signal_roh' */
  Abstandsensor_DW.obj_b.matlabCodegenIsDeleted = false;
  Abstandsensor_DW.obj_b.SampleTime = Abstandsensor_P.IR_Signal_roh_SampleTime;
  Abstandsensor_DW.obj_b.isInitialized = 1L;
  Abstandsensor_DW.obj_b.AnalogInDriverObj.MW_ANALOGIN_HANDLE =
    MW_AnalogInSingle_Open(14UL);
  Abstandsensor_DW.obj_b.isSetupComplete = true;

  /* Start for MATLABSystem: '<Root>/Median Filter' */
  Abstandsensor_DW.obj.matlabCodegenIsDeleted = false;
  Abstandsensor_DW.obj.isInitialized = 1L;
  Abstandsensor_DW.obj.NumChannels = 1L;
  Abstandsensor_DW.obj.pMID.isInitialized = 0L;
  Abstandsensor_DW.obj.isSetupComplete = true;

  /* Start for MATLABSystem: '<Root>/LED1_rotVielzuschwer' */
  Abstandsensor_DW.obj_o.matlabCodegenIsDeleted = false;
  Abstandsensor_DW.obj_o.isInitialized = 1L;
  digitalIOSetup(3, 1);
  Abstandsensor_DW.obj_o.isSetupComplete = true;

  /* Start for MATLABSystem: '<Root>/LED2_gelbZuschwer' */
  Abstandsensor_DW.obj_p.matlabCodegenIsDeleted = false;
  Abstandsensor_DW.obj_p.isInitialized = 1L;
  digitalIOSetup(4, 1);
  Abstandsensor_DW.obj_p.isSetupComplete = true;

  /* Start for MATLABSystem: '<Root>/LED3_gruenPassend' */
  Abstandsensor_DW.obj_l.matlabCodegenIsDeleted = false;
  Abstandsensor_DW.obj_l.isInitialized = 1L;
  digitalIOSetup(5, 1);
  Abstandsensor_DW.obj_l.isSetupComplete = true;

  /* Start for MATLABSystem: '<Root>/LED4_gelbZuleicht' */
  Abstandsensor_DW.obj_e.matlabCodegenIsDeleted = false;
  Abstandsensor_DW.obj_e.isInitialized = 1L;
  digitalIOSetup(6, 1);
  Abstandsensor_DW.obj_e.isSetupComplete = true;

  /* Start for MATLABSystem: '<Root>/LED5_rotVielzuleicht' */
  Abstandsensor_DW.obj_n.matlabCodegenIsDeleted = false;
  Abstandsensor_DW.obj_n.isInitialized = 1L;
  digitalIOSetup(7, 1);
  Abstandsensor_DW.obj_n.isSetupComplete = true;
}

/* Model terminate function */
void Abstandsensor_terminate(void)
{
  /* Terminate for MATLABSystem: '<Root>/IR_Signal_roh' */
  if (!Abstandsensor_DW.obj_b.matlabCodegenIsDeleted) {
    Abstandsensor_DW.obj_b.matlabCodegenIsDeleted = true;
    if ((Abstandsensor_DW.obj_b.isInitialized == 1L) &&
        Abstandsensor_DW.obj_b.isSetupComplete) {
      Abstandsensor_DW.obj_b.AnalogInDriverObj.MW_ANALOGIN_HANDLE =
        MW_AnalogIn_GetHandle(14UL);
      MW_AnalogIn_Close
        (Abstandsensor_DW.obj_b.AnalogInDriverObj.MW_ANALOGIN_HANDLE);
    }
  }

  /* End of Terminate for MATLABSystem: '<Root>/IR_Signal_roh' */

  /* Terminate for MATLABSystem: '<Root>/Median Filter' */
  if (!Abstandsensor_DW.obj.matlabCodegenIsDeleted) {
    Abstandsensor_DW.obj.matlabCodegenIsDeleted = true;
    if ((Abstandsensor_DW.obj.isInitialized == 1L) &&
        Abstandsensor_DW.obj.isSetupComplete) {
      Abstandsensor_DW.obj.NumChannels = -1L;
      if (Abstandsensor_DW.obj.pMID.isInitialized == 1L) {
        Abstandsensor_DW.obj.pMID.isInitialized = 2L;
      }
    }
  }

  /* End of Terminate for MATLABSystem: '<Root>/Median Filter' */

  /* Terminate for MATLABSystem: '<Root>/LED1_rotVielzuschwer' */
  if (!Abstandsensor_DW.obj_o.matlabCodegenIsDeleted) {
    Abstandsensor_DW.obj_o.matlabCodegenIsDeleted = true;
  }

  /* End of Terminate for MATLABSystem: '<Root>/LED1_rotVielzuschwer' */

  /* Terminate for MATLABSystem: '<Root>/LED2_gelbZuschwer' */
  if (!Abstandsensor_DW.obj_p.matlabCodegenIsDeleted) {
    Abstandsensor_DW.obj_p.matlabCodegenIsDeleted = true;
  }

  /* End of Terminate for MATLABSystem: '<Root>/LED2_gelbZuschwer' */

  /* Terminate for MATLABSystem: '<Root>/LED3_gruenPassend' */
  if (!Abstandsensor_DW.obj_l.matlabCodegenIsDeleted) {
    Abstandsensor_DW.obj_l.matlabCodegenIsDeleted = true;
  }

  /* End of Terminate for MATLABSystem: '<Root>/LED3_gruenPassend' */

  /* Terminate for MATLABSystem: '<Root>/LED4_gelbZuleicht' */
  if (!Abstandsensor_DW.obj_e.matlabCodegenIsDeleted) {
    Abstandsensor_DW.obj_e.matlabCodegenIsDeleted = true;
  }

  /* End of Terminate for MATLABSystem: '<Root>/LED4_gelbZuleicht' */

  /* Terminate for MATLABSystem: '<Root>/LED5_rotVielzuleicht' */
  if (!Abstandsensor_DW.obj_n.matlabCodegenIsDeleted) {
    Abstandsensor_DW.obj_n.matlabCodegenIsDeleted = true;
  }

  /* End of Terminate for MATLABSystem: '<Root>/LED5_rotVielzuleicht' */
}
