% Autor:           Jan Steffens, Lukas Berkemeier
% Datum:           06.02.2025
% Datei:           AuswertungFSR.m
% Version:         Matlab R2024b
% Funktion:        Messwerte Visuell darstellen 
%                  Standardabweichung über (1 σ) ermitteln und darstellen
% Letzte Änderung: 06.02.2025

%% 
close all; clc;
load("FSRMessung.mat")

%% Messdaten visuell darstellen
Zeit=FSRMessung.time;
Ref = [0.41 1.27 2.11 3.98 7.32 8.95 13.39 16.73 25.46 38.06];
for i=1:length(Zeit)
    Kraft(i)=FSRMessung.signals.values(i);
end

plot(Zeit,Kraft,'r.')
title('Messdaten FSR402')
xlabel('Zeit in s')
ylabel('Kraft in N')

%%
% Messwerte für Referenzdaten in ein Array schreiben und Standardabweichung
%  (1 σ) berechnen

Ref2 = vertcat(Kraft(500:1000), Kraft(2500:3000), Kraft(4500:5000), Kraft(4600:5100), Kraft(5750:6250),  Kraft(8000:8500),  Kraft(10500:11000),  Kraft(13500:14000),  Kraft(17500:18000), Kraft(22500:23000));
for i=1:length(Ref)
    Messunsicherheit(i) = std(Ref2(:,i));
end

% Standardabwichung über den Messbereich ausgeben
figure
for i=1:length(Ref)
plot(Ref(i), Messunsicherheit(i),'rx')
hold on 
end

xlabel('Messbereich in N ')
ylabel('Messunsicherheit (1 σ) in N')
title('Messunsicherheit (1 σ)')
hold off