%               Hochschule Hamm-Lippstadt                       *
%****************************************************************
% Modul : System Design Engineering                             *
%                                                               *
% Datum : 13-06-2020                                            *
%                                                               *
% Funktion : Testskript - Auswertung                            *
%                                                               *
% Implementation : MATLAB R2020a                                *
%                                                               *                                                             
% Author : Dominik Hermelingmeier & Isaac Mpidi Bita            *
%                                                               *                                                              
%****************************************************************


%% MATLAB Bereinigen
clear all; close all; clc; 

%% Parameter initialisieren
Gierrate_value = 0;
Querbeschleunigung_value = 0;
Kraeftesumme_X_value = 0;
Kraeftesumme_Y_value = 0;
Langsgeschwindigkeit_value = 0;
Schwimmwinkel_value = 0; 

%% Parameter Testskript
nAnzahlTest = 2;

% Zufallvariable intervalle
a = -100; 
b = 100; 

r = (b-a).*rand(1,1) + a;

%% Modell-Parameter
Simulationszeit = 10; % in [s]

%% Simulink-Modell öffnen
open_system('Testumgebug_Ausgabe.slx'); 

%% Testschleife

input = zeros(nAnzahlTest, 2); 

for iDurchlauf = 1:1:nAnzahlTest
    %% Simulation der Testumgebung
    output = sim('Testumgebug_Ausgabe.slx');
    
    %% Eingangspeichern
    input(iDurchlauf, 1) = Gierrate_value;
    input(iDurchlauf, 2) = Querbeschleunigung_value;
    input(iDurchlauf, 3) = Kraeftesumme_X_value;
    input(iDurchlauf, 4) = Kraeftesumme_Y_value;
    input(iDurchlauf, 5) = Schwimmwinkel_value;
    input(iDurchlauf, 6) = Langsgeschwindigkeit_value;
    
    %% Output Speichern
    SimErgebnisse(iDurchlauf) = output;
    
    %% Eingangsgroeße Variieren
    Gierrate_value = (b-a).*rand(1,1) + a; 
    Querbeschleunigung_value = (b-a).*rand(1,1) + a;
    Kraeftesumme_X_value = (b-a).*rand(1,1) + a; 
    Kraeftesumme_Y_value = (b-a).*rand(1,1) + a;
    Schwimmwinkel_value = (b-a).*rand(1,1) + a; 
    Langsgeschwindigkeit_value = (b-a).*rand(1,1) + a;
    
end

%% Überprüfung

Test1_1 = isequal(input(1,1), SimErgebnisse(1).simout.signal1.Data); 
Test1_2 = isequal(input(1,2), SimErgebnisse(1).simout.signal2.Data);
Test1_3 = isequal(input(1,3), SimErgebnisse(1).simout.signal3.Data); 
Test1_4 = isequal(input(1,4), SimErgebnisse(1).simout.signal4.Data);
Test1_5 = isequal(input(1,5), SimErgebnisse(1).simout.signal5.Data); 
Test1_6 = isequal(input(1,6), SimErgebnisse(1).simout.signal6.Data);

if Test1_1 == 1 && Test1_2 == 1
    if Test1_3 == 1 && Test1_4 == 1
        if Test1_5 == 1 && Test1_6 == 1
            disp('Test 1 = i.O.');
        end
    end
else
    disp('Test 1 = n.i.O.');
end


Test2_1 = isequal(input(2,1), SimErgebnisse(2).simout.signal1.Data); 
Test2_2 = isequal(input(2,2), SimErgebnisse(2).simout.signal2.Data);
Test2_3 = isequal(input(2,3), SimErgebnisse(2).simout.signal3.Data); 
Test2_4 = isequal(input(2,4), SimErgebnisse(2).simout.signal4.Data); 
Test2_5 = isequal(input(2,5), SimErgebnisse(2).simout.signal5.Data); 
Test2_6 = isequal(input(2,6), SimErgebnisse(2).simout.signal6.Data); 


if Test2_1 == 1 && Test2_2 == 1
    if Test2_3 == 1 && Test2_4 == 1
        if Test2_5 == 1 && Test2_6 == 1
             disp('Test 2 = i.O.');
        end 
    end 
else
    disp('Test 2 = n.i.O.');
end

% figure; 
% subplot(1,2,1)
% plot(SimErgebnisse(1).simout.signal1.Time, SimErgebnisse(1).simout.signal1.Data); 
% hold on
% plot(SimErgebnisse(1).simout.signal2.Time, SimErgebnisse(1).simout.signal2.Data); 
% 
% subplot(1,2,2)
% plot(SimErgebnisse(2).simout.signal1.Time, SimErgebnisse(2).simout.signal1.Data); 
% hold on
% plot(SimErgebnisse(2).simout.signal2.Time, SimErgebnisse(2).simout.signal2.Data); 

