%               Hochschule Hamm-Lippstadt                       *
%****************************************************************
% Modul : System Design Engineering                             *
%                                                               *
% Datum : 10-06-2020                                            *
%                                                               *
% Funktion : Testskript - Auswertung                            *
%                                                               *
% Implementation : MATLAB R2020a                                *
%                                                               *
% Author : Dominik Hermelingmeier & Isaac Mpidi Bita            *
%                                                               *
%****************************************************************


%% MATLAB Bereinigen
clear all; close all; clc;

%% Parameter initialisieren
Schwimmwinkel_value = 0;
Fahrerlenkwinkel_v_value = 0;
Geschwindigkeit_value = 1;
Gierrate_value = 0;
Achsschraeglaufwinkel_v_value = 0;

lv = 0;
cv = 0;

nAnzahlTest = 2;

%% Zufallvariable intervalle
a = -100;
b = 100;

r = (b-a).*rand(1,1) + a;

%% Simulink-Modell öffnen
open_system('Testumgebung_Vorder_Achse.slx');

%% Testschleife
input = zeros(nAnzahlTest, 2);
for iDurchlauf = 1:1:nAnzahlTest
    %% Eingangsgroeße Variieren
    if iDurchlauf == 2
        Schwimmwinkel_value  = (b-a).*rand(1,1) + a;
        Fahrerlenkwinkel_v_value = (b-a).*rand(1,1) + a;
        Geschwindigkeit_value = (b-a).*rand(1,1) + a;
        Gierrate_value = (b-a).*rand(1,1) + a;
        Achsschraeglaufwinkel_v_value = (b-a).*rand(1,1) + a;
        
        lv = (b-a).*rand(1,1) + a;
        cv = (b-a).*rand(1,1) + a;
    end 
    %% Berechnung der Größen
    
    % Achschwimmwinkel_beta_v
    beta_v = Schwimmwinkel_value + ((lv * Gierrate_value)/Geschwindigkeit_value);
    
    % Achslaufschräglaufwinkel_vorne
    alpha_v = Fahrerlenkwinkel_v_value - beta_v;
    
    % Seitenführungskraft_vorne
    R_Fy_v = cv * alpha_v;
    
    %% Simulation der Testumgebung
    output = sim('Testumgebung_Vorder_Achse.slx');
    
    %% Eingang speichern
    input(iDurchlauf, 1) = Schwimmwinkel_value ;
    input(iDurchlauf, 2) = Fahrerlenkwinkel_v_value;
    input(iDurchlauf, 3) = Geschwindigkeit_value;
    input(iDurchlauf, 4) = Gierrate_value;
    input(iDurchlauf, 5) = Achsschraeglaufwinkel_v_value;
    
    
    %% Erwartete Ergebnis speichern
    Erw_Erg(iDurchlauf, 1) = beta_v;
    Erw_Erg(iDurchlauf, 2) = alpha_v;
    Erw_Erg(iDurchlauf, 3) = R_Fy_v;
    
    %% Output Speichern
    SimErgebnisse(iDurchlauf) = output;
    

    
end

%% Überprüfung

Test1_1 = isequal(Erw_Erg(1, 2), SimErgebnisse(1).simout.Achsschr_glaufwinkel_Vorderachse_Alpha_v.Data);
Test1_2 = isequal(Erw_Erg(1, 2), SimErgebnisse(1).simout.Seitenf_hrungskraft_vorderachse_RFyv.Data);
if Test1_1 == 1 && Test1_2 == 1
    disp('Test 1 = i.O.');
else
    disp('Test 1 = n.i.O.');
end


Test2_1 = isequal(Erw_Erg(1, 2), SimErgebnisse(2).simout.Achsschr_glaufwinkel_Vorderachse_Alpha_v.Data);
Test2_2 = isequal(Erw_Erg(1, 2), SimErgebnisse(2).simout.Seitenf_hrungskraft_vorderachse_RFyv.Data);
if Test2_1 == 1 && Test2_2 == 1
    disp('Test 2 = i.O.');
else
    disp('Test 2 = n.i.O.');
end

% figure;
% subplot(1,2,1)
% plot(SimErgebnisse(1).simout.signal1.Time, SimErgebnisse(1).simout.signal1.Data);
% hold on
% plot(SimErgebnisse(1).simout.signal2.Time, SimErgebnisse(1).simout.signal2.Data);
%
% subplot(1,2,2)
% plot(SimErgebnisse(2).simout.signal1.Time, SimErgebnisse(2).simout.signal1.Data);
% hold on
% plot(SimErgebnisse(2).simout.signal2.Time, SimErgebnisse(2).simout.signal2.Data);

