%               Hochschule Hamm-Lippstadt                       *
%****************************************************************
% Modul : System Design Engineering                             *
%                                                               *
% Datum : 10-06-2020                                            *
%                                                               *
% Funktion : Testskript - Vorderachse                           *
%                                                               *
% Implementation : MATLAB R2020a                                *
%                                                               *
% Author : Dominik Hermelingmeier & Isaac Mpidi Bita            *
%                                                               *
%****************************************************************
%% MATLAB Bereinigen
close all; clear; clc; 

%% Parameter initialisieren
Schwimmwinkel_value = 1.3;
Fahrerlenkwinkel_v_value = 0.3;
Geschwindigkeit_value = 8.33;
Gierrate_value = 2;
Achsschraeglaufwinkel_v_value = 1;
% Fahrzeugparameter
lv = 1.5;
cv = 80000;
% Simulinkparameter
Simulationszeit = 10; % in [s]

%% Testumgebung öffnen
open_system('Testumgebung_Vorder_Achse.slx'); 

%% Berechnung der erwarteten Ergebnis
% Achschwimmwinkel_beta_v
beta_v = Schwimmwinkel_value + ((lv * Gierrate_value)/Geschwindigkeit_value);

% Achslaufschräglaufwinkel_vorne
m_alpha_v = Fahrerlenkwinkel_v_value - beta_v;

% Seitenführungskraft_vorne
m_R_Fy_v = cv * m_alpha_v;

%% Simulation der Testumgebung
output = sim('Testumgebung_Vorder_Achse.slx');

%% Überprüfung
% Outputergebnis des Testumgebung abgreifen
s_alpha_v = output.simout.Achsschr_glaufwinkel_Vorderachse_Alpha_v.Data; 
s_R_Fy_v = output.simout.Seitenf_hrungskraft_vorderachse_RFyv.Data; 

% Ergebnisvergleich 
TestErgebnis_1 = isequal(m_alpha_v, s_alpha_v); 
TestErgebnis_2 = isequal(m_R_Fy_v, s_R_Fy_v); 

% Testergebnis
if TestErgebnis_1 == 1 && TestErgebnis_2 == 1
    disp('Test Vorderachse = i.O.');
else
    disp('Test Vorderachse = n.i.O.');
end