%               Hochschule Hamm-Lippstadt                       *
%****************************************************************
% Modul : System Design Engineering                             *
%                                                               *
% Datum : 10-06-2020                                            *
%                                                               *
% Funktion : Testskript - Auswertung                            *
%                                                               *
% Implementation : MATLAB R2020a                                *
%                                                               *
% Author : Dominik Hermelingmeier & Isaac Mpidi Bita            *
%                                                               *
%****************************************************************


%% MATLAB Bereinigen
clear all; close all; clc;

%% Parameter initialisieren
Fahrerlenkwinkel_value = 0;
Seitenfuerungskraft_K_v_value = 0;
Seitenfuerungskraft_K_h_value = 0;
Seitenfuerungskraft_R_v_value = 0;
Seitenfuerungskraft_R_h_value = 0;
Gierrate_value = 0;
Querbeschleunigung_value = 0;
Laengsgeschwindigkeit_value = 1;
% Fahrzeugparameter
lv = 0;
lh = 0;
Jzz = 1;
m = 1;

nAnzahlTest = 2;

%% Modell-Parameter
Simulationszeit = 10; % in [s]

%% Zufallvariable intervalle
a = -100;
b = 100;

r = (b-a).*rand(1,1) + a;
%% Simulink-Modell öffnen
open_system('Testumgebung_Karosserie.slx');

%% Testschleife

input = zeros(nAnzahlTest, 2);

for iDurchlauf = 1:1:nAnzahlTest
    %% Eingangsgroeße Variieren
    if iDurchlauf == 2
        Fahrerlenkwinkel_value = (b-a).*rand(1,1) + a;
        Seitenfuerungskraft_K_v_value = (b-a).*rand(1,1) + a;
        Seitenfuerungskraft_K_h_value = (b-a).*rand(1,1) + a;
        Seitenfuerungskraft_R_v_value = (b-a).*rand(1,1) + a;
        Seitenfuerungskraft_R_h_value = (b-a).*rand(1,1) + a;
        Gierrate_value = (b-a).*rand(1,1) + a;
        Querbeschleunigung_value = (b-a).*rand(1,1) + a;
        Laengsgeschwindigkeit_value = (b-a).*rand(1,1) + a;
        
        lv = (b-a).*rand(1,1) + a;
        lh = (b-a).*rand(1,1) + a;
        Jzz = (b-a).*rand(1,1) + a;
        m = (b-a).*rand(1,1) + a;
    end
    
    %% Berechnung der Größen
    % Gierdynamik
    % -----------
    % Gierbeschleunigung nach Formel (1.29)
    psi_pp = ((lv*Seitenfuerungskraft_K_v_value)-(lh*Seitenfuerungskraft_K_h_value))/Jzz;
    
    % Gierrate
    psi_p = psi_pp * Simulationszeit;
    
    % Querbeschleunigung
    % ------------------
    % Querbeschleunigung nach Formel (1.28)
    KaCy = (Seitenfuerungskraft_K_v_value + Seitenfuerungskraft_K_h_value)/m;
    
    % Schwimmwinkel Berechnung
    % ------------------------
    % Schwimmgeschwindigkeit
    beta_p = (Querbeschleunigung_value / Laengsgeschwindigkeit_value) - Gierrate_value;
    
    % Schwimmwinkel
    beta = beta_p * Simulationszeit;
    
    % Berechnung der Kräftesumme
    % ---------------------------
    % Transformation der Reifenkräfte in Körperkoordinatensystem
    KFxv = sin(Fahrerlenkwinkel_value) * Seitenfuerungskraft_R_v_value;
    
    KFxh = 0 * Seitenfuerungskraft_R_h_value;
    
    KFyv = cos(Fahrerlenkwinkel_value) * Seitenfuerungskraft_R_v_value;
    
    KFyh = cos(0)* Seitenfuerungskraft_R_h_value;
    
    % Summekraft
    KFCx = KFxv + KFxh;
    KFCy = KFyv + KFyh;
    
    %% Simulation der Testumgebung
    output = sim('Testumgebung_Karosserie.slx');
    
    %% Eingangspeichern
    input(iDurchlauf, 1) = Fahrerlenkwinkel_value;
    input(iDurchlauf, 2) = Seitenfuerungskraft_K_v_value;
    input(iDurchlauf, 3) = Seitenfuerungskraft_K_h_value;
    input(iDurchlauf, 4) = Seitenfuerungskraft_R_v_value;
    input(iDurchlauf, 5) = Seitenfuerungskraft_R_h_value;
    input(iDurchlauf, 6) = Gierrate_value;
    input(iDurchlauf, 8) = Querbeschleunigung_value;
    input(iDurchlauf, 9) = Laengsgeschwindigkeit_value;
    input(iDurchlauf, 10) = lv;
    input(iDurchlauf, 11) = lh;
    input(iDurchlauf, 12) = Jzz;
    input(iDurchlauf, 13) = m;
    
    
    %% Erwartete Ergebnis speichern
    Erw_Erg(iDurchlauf, 1) = psi_pp;
    Erw_Erg(iDurchlauf, 2) = psi_p;
    Erw_Erg(iDurchlauf, 3) = KaCy;
    Erw_Erg(iDurchlauf, 4) = beta_p;
    Erw_Erg(iDurchlauf, 5) = beta;
    Erw_Erg(iDurchlauf, 6) = KFxv;
    Erw_Erg(iDurchlauf, 7) = KFxh;
    Erw_Erg(iDurchlauf, 8) = KFyv;
    Erw_Erg(iDurchlauf, 9) = KFyh;
    Erw_Erg(iDurchlauf, 10) = KFCx;
    Erw_Erg(iDurchlauf, 11) = KFCy;

    %% Output Speichern
    SimErgebnisse(iDurchlauf) = output;
    
    
end

%% Überprüfung
% m - steht für MATLAB
% s - steht für Simulink

% Test 1
% ------
% Gierdynamik
m_psi_pp = Erw_Erg(1,1); 
m_psi_p = Erw_Erg(1,2); 

s_psi_pp = SimErgebnisse(1).Psipp.Data; 
s_psi_p = SimErgebnisse(1).simout.Gierrate_K_psi_punkt.Data(end); 

Test_1_Psi_pp = isequal(m_psi_pp,s_psi_pp);
dif_psi_p = m_psi_p - s_psi_p; 
if dif_psi_p < 0.0001 && dif_psi_p > -0.0001
    Test_1_Psi_p = true; 
else
    Test_1_Psi_p = false; 
end

if Test_1_Psi_p == 1 && Test_1_Psi_pp == 1
    disp('Gierdynamik-Test Nr.1 - i.O.')
else
    disp('Gierdynamik-Test Nr.1 - n.i.O.')
end 
 
% Kräftesumme
m_KFCx = Erw_Erg(1,10); 
m_KFCy = Erw_Erg(1,11); 

s_KFCx = SimErgebnisse(1).simout.Summenkraft_KFcx.Data;
s_KFCy = SimErgebnisse(1).simout.Summenkraft_KFcy.Data;

Test_1_KFCx = isequal(m_KFCx, s_KFCx); 
Test_1_KFCy = isequal(m_KFCy, s_KFCy);

if Test_1_KFCx == 1 && Test_1_KFCy == 1
    disp('Kräftesumme-Test Nr.1 - i.O.')
else
    disp('Kräftesumme-Test Nr.1 - n.i.O.')
end 

% Querbeschleunigung
m_KaCy = Erw_Erg(1,3); 
s_KaCy = SimErgebnisse(1).simout.Querbeschleunigung_KaCy.Data; 
Test_1_KaCy = isequal(m_KaCy, s_KaCy); 

if Test_1_KFCx == 1
    disp('Querbeschleunigung-Test Nr.1 - i.O.')
else
    disp('Querbeschleunigung-Test Nr.1 - n.i.O.')
end 
    
% Schwimmwinkel
m_beta_p = Erw_Erg(1,4); 
m_beta = Erw_Erg(1,5);

s_beta_p = SimErgebnisse(1).betap.Data; 
s_beta = SimErgebnisse(1).simout.Schwimmwinkel_beta.Data(end); 

Test_1_Beta_p = isequal(m_beta_p,s_beta_p);

dif_beta = m_beta - s_beta; 
if (dif_beta < 0.0001) && (dif_beta > -0.0001)
    Test_1_Beta = 1; 
else
    Test_1_Beta = 0; 
end

if Test_1_Beta == 1 && Test_1_Beta_p == 1
    disp('Schwimmwinkel-Test Nr.1 - i.O.')
else
    disp('Schwimmwinkel-Test Nr.1 - n.i.O.')
end

% Test 2
% ------
% Gierdynamik
m_psi_pp = Erw_Erg(2,1); 
m_psi_p = Erw_Erg(2,2); 

s_psi_pp = SimErgebnisse(2).Psipp.Data; 
s_psi_p = SimErgebnisse(2).simout.Gierrate_K_psi_punkt.Data(end); 

Test_2_Psi_pp = isequal(m_psi_pp,s_psi_pp);


dif_psi_p = m_psi_p - s_psi_p; 
if dif_psi_p < 0.0001 && dif_psi_p > -0.0001
    Test_2_Psi_p = true; 
else
    Test_2_Psi_p = false; 
end

if Test_2_Psi_p == 1 && Test_2_Psi_pp == 1
    disp('Gierdynamik-Test Nr.2 - i.O.')
else
    disp('Gierdynamik-Test Nr.2 - n.i.O.')
end 
 
% Kräftesumme
m_KFCx = Erw_Erg(2,10); 
m_KFCy = Erw_Erg(2,11); 

s_KFCx = SimErgebnisse(2).simout.Summenkraft_KFcx.Data;
s_KFCy = SimErgebnisse(2).simout.Summenkraft_KFcy.Data;

Test_2_KFCx = isequal(m_KFCx, s_KFCx); 
Test_2_KFCy = isequal(m_KFCy, s_KFCy);

if Test_2_KFCx == 1 && Test_2_KFCy == 1
    disp('Kräftesumme-Test Nr.2 - i.O.')
else
    disp('Kräftesumme-Test Nr.2 - n.i.O.')
end 

% Querbeschleunigung
m_KaCy = Erw_Erg(2,3); 
s_KaCy = SimErgebnisse(2).simout.Querbeschleunigung_KaCy.Data; 
Test_2_KaCy = isequal(m_KaCy, s_KaCy); 

if Test_1_KFCx == 1
    disp('Querbeschleunigung-Test Nr.2 - i.O.')
else
    disp('Querbeschleunigung-Test Nr.2 - n.i.O.')
end 

% Schwimmwinkel
m_beta_p = Erw_Erg(2,4); 
m_beta = Erw_Erg(2,5);

s_beta_p = SimErgebnisse(2).betap.Data; 
s_beta = SimErgebnisse(2).simout.Schwimmwinkel_beta.Data(end); 

Test_2_Beta_p = isequal(m_beta_p,s_beta_p);

dif_beta = m_beta - s_beta; 
if (dif_beta < 0.0001) && (dif_beta > -0.0001)
    Test_2_Beta = true; 
else
    Test_2_Beta = false; 
end

if Test_2_Beta == 1 && Test_1_Beta_p == 1
    disp('Schwimmwinkel-Test Nr.2 - i.O.')
else
    disp('Schwimmwinkel-Test Nr.2 - n.i.O.')
end