%               Hochschule Hamm-Lippstadt                       *
%****************************************************************
% Modul : System Design Engineering                             *
%                                                               *
% Datum : 10-06-2020                                            *
%                                                               *
% Funktion : Testskript - Karosserie                            *
%                                                               *
% Implementation : MATLAB R2020a                                *
%                                                               *
% Author : Dominik Hermelingmeier & Isaac Mpidi Bita            *
%                                                               *
%****************************************************************
%% MATLAB Bereinigen
close all; clear; clc; 

%% Parameter initialisieren
Fahrerlenkwinkel_value = 1.3;
Seitenfuerungskraft_K_v_value = 80000;
Seitenfuerungskraft_K_h_value = 100000;
Seitenfuerungskraft_R_v_value = 80000;
Seitenfuerungskraft_R_h_value = 100000;
Gierrate_value = 2;
Querbeschleunigung_value = 3;
Laengsgeschwindigkeit_value = 8.33;
% Fahrzeugparameter
lv = 1.3;
lh = 1.3;
Jzz = 1;
m = 1500;
% Simulinkparameter
Simulationszeit = 10; % in [s]

%% Testumgebung öffnen
open_system('Testumgebung_Karosserie.slx');

%% Berechnung der erwarteten Ergebnis
% Gierdynamik
% -----------
% Gierbeschleunigung nach Formel (1.29)
m_psi_pp = ((lv*Seitenfuerungskraft_K_v_value)-(lh*Seitenfuerungskraft_K_h_value))/Jzz;

% Gierrate
m_psi_p = m_psi_pp * Simulationszeit;

% Querbeschleunigung
% ------------------
% Querbeschleunigung nach Formel (1.28)
m_KaCy = (Seitenfuerungskraft_K_v_value + Seitenfuerungskraft_K_h_value)/m;

% Schwimmwinkel Berechnung
% ------------------------
% Schwimmgeschwindigkeit
m_beta_p = (Querbeschleunigung_value / Laengsgeschwindigkeit_value) - Gierrate_value;

% Schwimmwinkel
m_beta = m_beta_p * Simulationszeit;

% Berechnung der Kräftesumme
% ---------------------------
% Transformation der Reifenkräfte in Körperkoordinatensystem
m_KFxv = sin(Fahrerlenkwinkel_value) * Seitenfuerungskraft_R_v_value;

m_KFxh = 0 * Seitenfuerungskraft_R_h_value;

m_KFyv = cos(Fahrerlenkwinkel_value) * Seitenfuerungskraft_R_v_value;

m_KFyh = cos(0)* Seitenfuerungskraft_R_h_value;

% Summekraft
m_KFCx = m_KFxv + m_KFxh;
m_KFCy = m_KFyv + m_KFyh;

%% Simulation der Testumgebung
output = sim('Testumgebung_Karosserie.slx');

%% Überprüfung
% m - steht für MATLAB
% s - steht für Simulink

% Test 1
% ------
% Gierdynamik
s_psi_pp = output.Psipp.Data; 
s_psi_p = output.simout.Gierrate_K_psi_punkt.Data(end); 

Test_1_Psi_pp = isequal(m_psi_pp,s_psi_pp);
dif_psi_p = m_psi_p - s_psi_p; 
if dif_psi_p < 0.0001 && dif_psi_p > -0.0001
    Test_1_Psi_p = true; 
else
    Test_1_Psi_p = false; 
end

if Test_1_Psi_p == 1 && Test_1_Psi_pp == 1
    disp('Gierdynamik-Test Nr.1 - i.O.')
else
    disp('Gierdynamik-Test Nr.1 - n.i.O.')
end 
 
% Kräftesumme 
s_KFCx = output.simout.Summenkraft_KFcx.Data;
s_KFCy = output.simout.Summenkraft_KFcy.Data;

Test_1_KFCx = isequal(m_KFCx, s_KFCx); 
Test_1_KFCy = isequal(m_KFCy, s_KFCy);

if Test_1_KFCx == 1 && Test_1_KFCy == 1
    disp('Kräftesumme-Test Nr.1 - i.O.')
else
    disp('Kräftesumme-Test Nr.1 - n.i.O.')
end 

% Querbeschleunigung
s_KaCy = output.simout.Querbeschleunigung_KaCy.Data; 
Test_1_KaCy = isequal(m_KaCy, s_KaCy); 

if Test_1_KFCx == 1
    disp('Querbeschleunigung-Test Nr.1 - i.O.')
else
    disp('Querbeschleunigung-Test Nr.1 - n.i.O.')
end 
    
% Schwimmwinkel
s_beta_p = output.betap.Data; 
s_beta = output.simout.Schwimmwinkel_beta.Data(end); 

Test_1_Beta_p = isequal(m_beta_p,s_beta_p);

dif_beta = m_beta - s_beta; 
if (dif_beta < 0.0001) && (dif_beta > -0.0001)
    Test_1_Beta = 1; 
else
    Test_1_Beta = 0; 
end

if Test_1_Beta == 1 && Test_1_Beta_p == 1
    disp('Schwimmwinkel-Test Nr.1 - i.O.')
else
    disp('Schwimmwinkel-Test Nr.1 - n.i.O.')
end