%               Hochschule Hamm-Lippstadt                       *
%****************************************************************
% Modul : System Design Engineering                             *
%                                                               *
% Datum : 10-06-2020                                            *
%                                                               *
% Funktion : Testskript - Auswertung                            *
%                                                               *
% Implementation : MATLAB R2020a                                *
%                                                               *                                                             
% Author : Dominik Hermelingmeier & Isaac Mpidi Bita            *
%                                                               *                                                              
%****************************************************************


%% MATLAB Bereinigen
clear all; close all; clc; 

%% Parameter initialisieren
Laengsgeschwindigkeit_value = 1;
Schwimmwinkel_value = 0;
Gierrate_value = 0;
Achslaufschraegwinkel_h_value = 0;

lh = 0; 
ch = 0;
theta_h = 0; % Lenkwinkel

nAnzahlTest = 2;

%% Zufallvariable intervalle
a = -100; 
b = 100; 

r = (b-a).*rand(1,1) + a;

%% Modell-Parameter
Simulationszeit = 10; % in [s]

%% Simulink-Modell öffnen
open_system('Testumgebung_Hinter_Achse.slx'); 

%% Testschleife

input = zeros(nAnzahlTest, 2); 

for iDurchlauf = 1:1:nAnzahlTest
    %% Eingangsgroeße Variieren
    if iDurchlauf == 2
        
        Schwimmwinkel_value = (b-a).*rand(1,1) + a;
        Laengsgeschwindigkeit_value = (b-a).*rand(1,1) + a;
        Gierrate_value = (b-a).*rand(1,1) + a;
        Achslaufschraegwinkel_h_value = (b-a).*rand(1,1) + a;
        
        lh = (b-a).*rand(1,1) + a;
        lc = (b-a).*rand(1,1) + a;
    
    end
    
    %% Berechnung der Größen
    % Schwimmwinkel hinten
    beta_h = Schwimmwinkel_value...
        -((lh*Gierrate_value)/Laengsgeschwindigkeit_value);
    % Achslaufschräglaufwinkel_hinten 
    alpha_h = theta_h - beta_h; 
    
    % Seitenführungskraft_hinten
    R_Fy_h = ch * alpha_h;
    
    %% Simulation der Testumgebung
    output = sim('Testumgebung_Hinter_Achse.slx');
    
    %% Eingang speichern
    input(iDurchlauf, 1) = Schwimmwinkel_value;
    input(iDurchlauf, 2) = Laengsgeschwindigkeit_value;
    input(iDurchlauf, 3) = Gierrate_value;
    input(iDurchlauf, 4) = Achslaufschraegwinkel_h_value;
    
    %% Erwartete Ergebnis speichern
    Erw_Erg(iDurchlauf, 1) = beta_h; 
    Erw_Erg(iDurchlauf, 2) = alpha_h; 
    Erw_Erg(iDurchlauf, 3) = R_Fy_h; 
    
    %% Output Speichern
    SimErgebnisse(iDurchlauf) = output;
    
end

%% Überprüfung
Test1_1 = isequal(Erw_Erg(1, 2), SimErgebnisse(1).simout.Alpha_h.Data); 
Test1_2 = isequal(Erw_Erg(1, 3), SimErgebnisse(1).simout.Seitenf_hrungskraft_Hinterachse_RFyv.Data);
if Test1_1 == 1 && Test1_2 == 1
    disp('Test 1 = i.O.');
else
    disp('Test 1 = n.i.O.');
    
end


Test2_1 = isequal(Erw_Erg(2, 2), SimErgebnisse(2).simout.Alpha_h.Data); 
Test2_2 = isequal(Erw_Erg(2, 3), SimErgebnisse(2).simout.Seitenf_hrungskraft_Hinterachse_RFyv.Data); 
if Test2_1 == 1 && Test2_2 == 1
    disp('Test 2 = i.O.');
else
    disp('Test 2 = n.i.O.');
end

% figure; 
% subplot(1,2,1)
% plot(SimErgebnisse(1).simout.signal1.Time, SimErgebnisse(1).simout.signal1.Data); 
% hold on
% plot(SimErgebnisse(1).simout.signal2.Time, SimErgebnisse(1).simout.signal2.Data); 
% 
% subplot(1,2,2)
% plot(SimErgebnisse(2).simout.signal1.Time, SimErgebnisse(2).simout.signal1.Data); 
% hold on
% plot(SimErgebnisse(2).simout.signal2.Time, SimErgebnisse(2).simout.signal2.Data); 

