%               Hochschule Hamm-Lippstadt                       *
%****************************************************************
% Modul : System Design Engineering                             *
%                                                               *
% Datum : 10-06-2020                                            *
%                                                               *
% Funktion : Testskript - Hinterachse                           *
%                                                               *
% Implementation : MATLAB R2020a                                *
%                                                               *                                                             
% Author : Dominik Hermelingmeier & Isaac Mpidi Bita            *
%                                                               *                                                              
%****************************************************************
%% MATLAB Bereinigen
close all; clear; clc; 

%% Parameter initialisieren
Laengsgeschwindigkeit_value = 8.33;
Schwimmwinkel_value = 1.3;
Gierrate_value = 2;
Achslaufschraegwinkel_h_value = 1;

lh = 1.3; 
ch = 100000;
theta_h = 1300; % Lenkwinkel

Simulationszeit = 10; % in [s]

%% Testumgebung öffnen
open_system('Testumgebung_Hinter_Achse.slx'); 

%% Berechnung der erwarteten Ergebnis
% Schwimmwinkel hinten
m_beta_h = Schwimmwinkel_value...
    -((lh*Gierrate_value)/Laengsgeschwindigkeit_value);
% Achslaufschräglaufwinkel_hinten
m_alpha_h = theta_h - m_beta_h;

% Seitenführungskraft_hinten
m_R_Fy_h = ch * m_alpha_h;

%% Simulation der Testumgebung
output = sim('Testumgebung_Hinter_Achse.slx');

%% Überprüfung 
% Outputergebnis des Testumgebung abgreifen
s_alpha_h = output.simout.Alpha_h.Data; 
s_R_Fy_h = output.simout.Seitenf_hrungskraft_Hinterachse_RFyv.Data; 

% Ergebnisvergleich 
TestErgebnis_1 = isequal(m_alpha_h, s_alpha_h); 
TestErgebnis_2 = isequal(m_R_Fy_h, s_R_Fy_h); 

% Testergebnis
if TestErgebnis_1 == 1 && TestErgebnis_2 == 1
    disp('Test Hinterachse = i.O.');
else
    disp('Test Hinterachse = n.i.O.');
end