%               Hochschule Hamm-Lippstadt                       *
%****************************************************************
% Modul : System Design Engineering                             *
%                                                               *
% Datum : 10-06-2020                                            *
%                                                               *
% Funktion : Testskript - Manoeverauswahl                       *
%                                                               *
% Implementation : MATLAB R2020a                                *
%                                                               *                                                             
% Author : Dominik Hermelingmeier & Isaac Mpidi Bita            *
%                                                               *                                                              
%****************************************************************


%% MATLAB Bereinigen
clear all; close all; clc; 


%% Parameter Testskript
nAnzahlTest = 2;

c = [0;0];

%% Zufallvariable intervalle
a = -100; 
b = 100; 

r = (b-a).*rand(1,1) + a;

%% Modell-Parameter
Simulationszeit = 10; % in [s]

%% Simulink-Modell öffnen
open_system('Testumgebung_Manoeverauswahl.slx'); 

%% Testschleife

input = zeros(nAnzahlTest, 2); 

for iDurchlauf = 1:1:nAnzahlTest
   %% Eingangsgroeße Variieren
   if iDurchlauf == 2
       
       c(1) = (b-a).*rand(1,1) + a;
       c(2) = (b-a).*rand(1,1) + a;
       
   end
    %% Simulation der Testumgebung
    output = sim('Testumgebung_Manoeverauswahl.slx');
    
    %% Eingangspeichern
    input(iDurchlauf, 1) = c(1);
    input(iDurchlauf, 2) = c(2);

    %% Output Speichern
    SimErgebnisse(iDurchlauf) = output;
        
end

%% Überprüfung

Test1_1 = isequal(input(1,1), SimErgebnisse(1).simout.Fahrerlenkwinkel_teta_v.Data); 
Test1_2 = isequal(input(1,2), SimErgebnisse(1).simout.Fahrzeugl_ngsgeschwindigkeit_KvCx.Data);
if Test1_1 == 1 && Test1_2 == 1
    disp('Test 1 = i.O.');
else
    disp('Test 1 = n.i.O.');
end


Test2_1 = isequal(input(2,1), SimErgebnisse(2).simout.Fahrerlenkwinkel_teta_v.Data); 
Test2_2 = isequal(input(2,2), SimErgebnisse(2).simout.Fahrzeugl_ngsgeschwindigkeit_KvCx.Data); 
if Test2_1 == 1 && Test2_2 == 1
    disp('Test 2 = i.O.');
else
    disp('Test 2 = n.i.O.');
end


