#include <SPI.h>
#include <Adafruit_GFX.h>
#include <Adafruit_ILI9341.h>

#define TFT_CS 10
#define TFT_DC 8
#define TFT_RST 9

Adafruit_ILI9341 tft = Adafruit_ILI9341(TFT_CS, TFT_DC, TFT_RST);

void setup() {
  delay(150);
  tft.begin();
  tft.setRotation(1);

  // Solid color fills
  tft.fillScreen(ILI9341_RED);
  delay(500);
  tft.fillScreen(ILI9341_GREEN);
  delay(500);
  tft.fillScreen(ILI9341_BLUE);
  delay(500);
  tft.fillScreen(ILI9341_BLACK);

  // Color bars
  tft.fillRect(0, 0, 80, 240, ILI9341_RED);
  tft.fillRect(80, 0, 80, 240, ILI9341_GREEN);
  tft.fillRect(160, 0, 80, 240, ILI9341_BLUE);
  delay(1000);

  // Gradient test
  for (int y = 0; y < tft.height(); y++) {
    uint16_t color = tft.color565(y, 0, 255 - y);
    tft.drawFastHLine(0, y, tft.width(), color);
  }
  delay(1000);

  // Text test
  tft.fillScreen(ILI9341_BLACK);
  tft.setCursor(10, 20);
  tft.setTextColor(ILI9341_WHITE);
  tft.setTextSize(2);
  tft.println("ILI9341 Text Test");

  tft.setTextColor(ILI9341_YELLOW);
  tft.setTextSize(3);
  tft.println("Colors OK");

  tft.setTextColor(ILI9341_CYAN);
  tft.setTextSize(2);
  tft.println("Scroll wheel ready!");
}

void loop() {
}