// Tasten und LEDs Test

// Eingänge (Taster)
const int switchPin1 = 7;  // Taster für ON/OFF (rote LED)
const int switchPin2 = 6;  // Taster für Reset (blaue LED)

// Ausgänge (LEDs)
const int redLedPin = 13;  
const int blueLedPin = 8;  

// Zustände
bool toggledState = false;
int lastState1 = HIGH;
int lastState2 = HIGH;

// Zeitsteuerung (Entprellung & Cooldown)
unsigned long lastDebounceTime1 = 0;
unsigned long lastDebounceTime2 = 0;
unsigned long debounceDelay = 50;  // Entprellzeit in Millisekunden
unsigned long cooldown = 2000;     // Mindestabstand zwischen gültigen Klicks

void setup() {
  pinMode(switchPin1, INPUT_PULLUP);  // interner Pullup: Taster gegen GND
  pinMode(switchPin2, INPUT_PULLUP);
  pinMode(redLedPin, OUTPUT);
  pinMode(blueLedPin, OUTPUT);

  Serial.begin(9600);
  Serial.println("Systemstart: Zwei-Taster-Steuerung aktiv.");
}

void loop() {
  int reading1 = digitalRead(switchPin1);
  int reading2 = digitalRead(switchPin2);
  unsigned long currentTime = millis();

  // Taster 1: Toggle rote LED
  if (reading1 == LOW && lastState1 == HIGH) {
    if (currentTime - lastDebounceTime1 > cooldown) {
      toggledState = !toggledState;
      digitalWrite(redLedPin, toggledState ? HIGH : LOW);
      Serial.println(toggledState ? "Rote LED: EIN" : "Rote LED: AUS");
      lastDebounceTime1 = currentTime;
    }
  }

  // Taster 2: Reset
  if (reading2 == LOW && lastState2 == HIGH) {
    if (currentTime - lastDebounceTime2 > cooldown) {
      Serial.println("Reset gedrückt: Komponenten werden zurückgesetzt (Platzhalter).");

      // Blaue LED blinkt kurz als Reset-Indikator
      digitalWrite(blueLedPin, HIGH);
      delay(200);
      digitalWrite(blueLedPin, LOW);

      lastDebounceTime2 = currentTime;
    }
  }

  // Zustände für nächste Schleife merken
  lastState1 = reading1;
  lastState2 = reading2;
}