// Encoder 1
const int clk1 = 2;
const int dt1  = 3;

// Encoder 2
const int clk2 = 4;
const int dt2  = 5;

// Encoder 3
const int clk3 = 6;
const int dt3  = 7;

// State tracking
int lastClk1 = HIGH, lastClk2 = HIGH, lastClk3 = HIGH;
int val1 = 0, val2 = 0, val3 = 0;

void setup() {
  Serial.begin(9600);

  pinMode(clk1, INPUT_PULLUP);
  pinMode(dt1, INPUT_PULLUP);

  pinMode(clk2, INPUT_PULLUP);
  pinMode(dt2, INPUT_PULLUP);

  pinMode(clk3, INPUT_PULLUP);
  pinMode(dt3, INPUT_PULLUP);

  Serial.println("Encoder Endless Scroll Test Started");
}

void loop() {
  // Encoder 1
  int clkState1 = digitalRead(clk1);
  if (lastClk1 == HIGH && clkState1 == LOW) {
    if (digitalRead(dt1) == HIGH) val1++;
    else val1--;
    Serial.print("Encoder 1 - "); Serial.println(val1);
  }
  lastClk1 = clkState1;

  // Encoder 2
  int clkState2 = digitalRead(clk2);
  if (lastClk2 == HIGH && clkState2 == LOW) {
    if (digitalRead(dt2) == HIGH) val2++;
    else val2--;
    Serial.print("Encoder 2 - "); Serial.println(val2);
  }
  lastClk2 = clkState2;

  // Encoder 3
  int clkState3 = digitalRead(clk3);
  if (lastClk3 == HIGH && clkState3 == LOW) {
    if (digitalRead(dt3) == HIGH) val3++;
    else val3--;
    Serial.print("Encoder 3 - "); Serial.println(val3);
  }
  lastClk3 = clkState3;
}