// Piezo Buzzer Sound Test

// Pin assignment
const int buzzerPin = 10;  

void setup() {
  pinMode(buzzerPin, OUTPUT);
  Serial.begin(9600);
  Serial.println("Piezo Buzzer Sound Test gestartet...");
}

void loop() {

  // gameOnSound();
  // gameWonSound();
  // resetSound();
  // errorSound();
  // countdownSound();
  // shortBeep();
  longBeep();

  while (true);
}

// Sound Functions

// Game On
void gameOnSound() {
  Serial.println("Game On Sound");
  tone(buzzerPin, 400, 200);
  delay(250);
  tone(buzzerPin, 600, 200);
  delay(250);
  tone(buzzerPin, 800, 200);
  delay(250);
  noTone(buzzerPin);
}

// Game Won
void gameWonSound() {
  Serial.println("Game Won Sound");
  tone(buzzerPin, 523, 200);  // C5
  delay(250);
  tone(buzzerPin, 659, 200);  // E5
  delay(250);
  tone(buzzerPin, 784, 400);  // G5
  delay(500);
  tone(buzzerPin, 1046, 600);  // C6
  delay(700);
  noTone(buzzerPin);
}

// Reset
void resetSound() {
  Serial.println("Reset Sound");
  tone(buzzerPin, 500, 150);
  delay(200);
  tone(buzzerPin, 500, 150);
  delay(200);
  noTone(buzzerPin);
}

// Error
void errorSound() {
  Serial.println("Error Sound");
  tone(buzzerPin, 200, 600);
  delay(700);
  noTone(buzzerPin);
}

// Countdown
void countdownSound() {
  Serial.println("Countdown Sound");
  for (int i = 0; i < 5; i++) {
    tone(buzzerPin, 1000, 100);
    delay(500);
  }
  noTone(buzzerPin);
}

// Simple short beep
void shortBeep() {
  Serial.println("Short Beep");
  tone(buzzerPin, 1000, 100);
  delay(200);
  noTone(buzzerPin);
}

// Simple long beep
void longBeep() {
  Serial.println("Long Beep");
  tone(buzzerPin, 1000, 800);
  delay(1000);
  noTone(buzzerPin);
}