classdef Morsecode < matlab.System ...
        & coder.ExternalDependency ...
        & matlabshared.sensors.simulink.internal.BlockSampleTime

    % Aufteilung LEDs
    %#codegen
    %#ok<*EMCA>

    properties

    end

    properties(Access = protected)
        Logo = 'IO Device Builder';
    end

    properties (Nontunable)

    end

    properties (Access = private)


    end

    methods
        % Constructor
        function obj = Morsecode(varargin)
            setProperties(obj,nargin,varargin{:});
        end
    end

    methods (Access=protected)
        function setupImpl(obj)
            if ~coder.target('MATLAB')
                coder.cinclude('Morsecode.h');
                coder.ceval('setupFunctionMorsecode');
            end
        end

        function validateInputsImpl(obj,varargin)
            %  Check the input size
            if nargin ~=0

                validateattributes(varargin{1},{'logical'},{'2d','size',[1,1]},'','Sensor');

            end
        end

        function [Led1,Led2,Led3,Led4,Led5] = stepImpl(obj ,Sensor)
            Led1 = boolean(zeros(1,1));
            Led2 = boolean(zeros(1,1));
            Led3 = boolean(zeros(1,1));
            Led4 = boolean(zeros(1,1));
            Led5 = boolean(zeros(1,1));
            if isempty(coder.target)
            else
                coder.ceval('stepFunctionMorsecode',coder.ref(Led1),1,coder.ref(Led2),1,coder.ref(Led3),1,coder.ref(Led4),1,coder.ref(Led5),1, Sensor,1);
            end
        end

        function releaseImpl(obj)
            if isempty(coder.target)
            else

            end
        end
    end

    methods (Access=protected)
        %% Define output properties
        function num = getNumInputsImpl(~)
            num = 1;
        end

        function num = getNumOutputsImpl(~)
            num = 5;
        end

        function varargout = getInputNamesImpl(obj)
            varargout{1} = 'Sensor';

        end

        function varargout = getOutputNamesImpl(obj)
            varargout{1} = 'Led1';
            varargout{2} = 'Led2';
            varargout{3} = 'Led3';
            varargout{4} = 'Led4';
            varargout{5} = 'Led5';
        end

        function flag = isOutputSizeLockedImpl(~,~)
            flag = true;
        end

        function varargout = isOutputFixedSizeImpl(~,~)
            varargout{1} = true;
            varargout{2} = true;
            varargout{3} = true;
            varargout{4} = true;
            varargout{5} = true;
        end

        function varargout = isOutputComplexImpl(~)
            varargout{1} = false;
            varargout{2} = false;
            varargout{3} = false;
            varargout{4} = false;
            varargout{5} = false;
        end

        function varargout = getOutputSizeImpl(~)
            varargout{1} = [1,1];
            varargout{2} = [1,1];
            varargout{3} = [1,1];
            varargout{4} = [1,1];
            varargout{5} = [1,1];
        end

        function varargout = getOutputDataTypeImpl(~)
            varargout{1} = 'boolean';
            varargout{2} = 'boolean';
            varargout{3} = 'boolean';
            varargout{4} = 'boolean';
            varargout{5} = 'boolean';
        end

        function maskDisplayCmds = getMaskDisplayImpl(obj)
            outport_label = [];
            num = getNumOutputsImpl(obj);
            if num > 0
                outputs = cell(1,num);
                [outputs{1:num}] = getOutputNamesImpl(obj);
                for i = 1:num
                    outport_label = [outport_label 'port_label(''output'',' num2str(i) ',''' outputs{i} ''');' ]; %#ok<AGROW>
                end
            end
            inport_label = [];
            num = getNumInputsImpl(obj);
            if num > 0
                inputs = cell(1,num);
                [inputs{1:num}] = getInputNamesImpl(obj);
                for i = 1:num
                    inport_label = [inport_label 'port_label(''input'',' num2str(i) ',''' inputs{i} ''');' ]; %#ok<AGROW>
                end
            end
            icon = 'Morsecode';
            maskDisplayCmds = [ ...
                ['color(''white'');',...
                'plot([100,100,100,100]*1,[100,100,100,100]*1);',...
                'plot([100,100,100,100]*0,[100,100,100,100]*0);',...
                'color(''blue'');', ...
                ['text(38, 92, ','''',obj.Logo,'''',',''horizontalAlignment'', ''right'');',newline],...
                'color(''black'');'], ...
                ['text(52,50,' [''' ' icon ''',''horizontalAlignment'',''center'');' newline]]   ...
                inport_label ...
                outport_label
                ];
        end

        function sts = getSampleTimeImpl(obj)
            sts = getSampleTimeImpl@matlabshared.sensors.simulink.internal.BlockSampleTime(obj);
        end
    end

    methods (Static, Access=protected)
        function simMode = getSimulateUsingImpl(~)
            simMode = 'Interpreted execution';
        end

        function isVisible = showSimulateUsingImpl
            isVisible = false;
        end
    end

    methods (Static)
        function name = getDescriptiveName()
            name = 'Morsecode';
        end

        function b = isSupportedContext(context)
            b = context.isCodeGenTarget('rtw');
        end

        function updateBuildInfo(buildInfo, context)
            coder.extrinsic('codertarget.targethardware.getTargetHardware');
            hCS = coder.const(getActiveConfigSet(bdroot));
            targetInfo = coder.const(codertarget.targethardware.getTargetHardware(hCS));

            % Added this env variable to fetch the comm libraries required only for Arduino target.
            % The env variable is cleared at the end of
            % "GenerateWrapperMakefile.m" file.
            if contains(targetInfo.TargetName,'arduinotarget')
                setenv('Arduino_ML_Codegen_I2C', 'Y');
            end

            buildInfo.addIncludePaths('C:\Users\noname\Desktop\Programm\temp_LCD\LCD_matlab');
            buildInfo.addIncludePaths('C:\Users\noname\Desktop\Programm\temp_LCD\LCD_matlab\libs');

            buildInfo.addIncludePaths('C:\Users\noname\Desktop\Programm');
            addSourceFiles(buildInfo,'LiquidCrystal_I2C.cpp','C:\Users\noname\Desktop\Programm\temp_LCD\LCD_matlab\libs');
            addSourceFiles(buildInfo,'Morsecode.cpp','C:\Users\noname\Desktop\Programm');

        end
    end
end
