/*
 * Academic License - for use in teaching, academic research, and meeting
 * course requirements at degree granting institutions only.  Not for
 * government, commercial, or other organizational use.
 *
 * File: Labyrinth.c
 *
 * Code generated for Simulink model 'Labyrinth'.
 *
 * Model version                  : 1.1
 * Simulink Coder version         : 23.2 (R2023b) 01-Aug-2023
 * C/C++ source code generated on : Mon Jan  6 16:40:09 2025
 *
 * Target selection: ert.tlc
 * Embedded hardware selection: Atmel->AVR
 * Code generation objectives: Unspecified
 * Validation result: Not run
 */

#include "Labyrinth.h"
#include "rtwtypes.h"
#include "Labyrinth_private.h"
#include "zero_crossing_types.h"
#include <math.h>

/* Named constants for Chart: '<Root>/Labyrinth' */
#define Labyrinth_IN_Antwort1          (1UL)
#define Labyrinth_IN_Antwort2          (2UL)
#define Labyrinth_IN_Antwort3          (3UL)
#define Labyrinth_IN_Antwort4          (4UL)
#define Labyrinth_IN_Aus               (1UL)
#define Labyrinth_IN_FalscheAntwort    (5UL)
#define Labyrinth_IN_Fertig            (6UL)
#define Labyrinth_IN_Frage1            (7UL)
#define Labyrinth_IN_Frage2            (8UL)
#define Labyrinth_IN_Frage3            (9UL)
#define Labyrinth_IN_Frage4            (10UL)
#define Labyrinth_IN_INIT              (11UL)
#define Labyrinth_IN_NO_ACTIVE_CHILD   ((uint8_T)0U)
#define Labyrinth_IN_Rot               (2UL)
#define Labyrinth_IN_TasterEntprellen1 (12UL)
#define Labyrinth_IN_TasterEntprellen2 (13UL)
#define Labyrinth_IN_TasterEntprellen3 (14UL)
#define Labyrinth_IN_TasterEntprellen4 (15UL)
#define Labyrinth_IN_Warten1           (16UL)
#define Labyrinth_IN_Warten2           (17UL)
#define Labyrinth_IN_Warten3           (18UL)
#define Labyrinth_event_Taster1Aus     (1L)
#define Labyrinth_event_Taster1Ein     (2L)
#define Labyrinth_event_Taster2Aus     (3L)
#define Labyrinth_event_Taster2Ein     (4L)
#define Labyrinth_event_Taster3Aus     (5L)
#define Labyrinth_event_Taster3Ein     (6L)
#define Labyrinth_event_Taster4Aus     (7L)
#define Labyrinth_event_Taster4Ein     (8L)
#define Labyrinth_event_Timer          (0L)

/* Named constants for Chart: '<Root>/TimerBaustein' */
#define Labyrinth_IN_TimerIdle         (1UL)
#define Labyrinth_IN_TimerRunning      (2UL)

/* Block signals (default storage) */
B_Labyrinth_T Labyrinth_B;

/* Block states (default storage) */
DW_Labyrinth_T Labyrinth_DW;

/* Previous zero-crossings (trigger) states */
PrevZCX_Labyrinth_T Labyrinth_PrevZCX;

/* Real-time model */
static RT_MODEL_Labyrinth_T Labyrinth_M_;
RT_MODEL_Labyrinth_T *const Labyrinth_M = &Labyrinth_M_;

/* Forward declaration for local functions */
static void Labyrinth_FalscheAntwort(const int32_T *sfEvent_j);
static void Labyrint_chartstep_c3_Labyrinth(const int32_T *sfEvent_j);
uint16_T look1_iu16lu32n16_binlcse(uint16_T u0, const uint16_T bp0[], const
  uint16_T table[], uint32_T maxIndex)
{
  uint32_T frac;
  uint32_T iLeft;
  uint32_T iRght;
  uint16_T bpLeftVar;
  uint16_T y;
  uint16_T yL_0d0;

  /* Column-major Lookup 1-D
     Search method: 'binary'
     Use previous index: 'off'
     Interpolation method: 'Linear point-slope'
     Extrapolation method: 'Clip'
     Use last breakpoint for index at or above upper limit: 'off'
     Remove protection against out-of-range input in generated code: 'off'
     Rounding mode: 'simplest'
   */
  /* Prelookup - Index and Fraction
     Index Search method: 'binary'
     Extrapolation method: 'Clip'
     Use previous index: 'off'
     Use last breakpoint for index at or above upper limit: 'off'
     Remove protection against out-of-range input in generated code: 'off'
     Rounding mode: 'simplest'
   */
  if (u0 <= bp0[0UL]) {
    iLeft = 0UL;
    frac = 0UL;
  } else if (u0 < bp0[maxIndex]) {
    /* Binary Search */
    frac = maxIndex >> 1UL;
    iLeft = 0UL;
    iRght = maxIndex;
    while (iRght - iLeft > 1UL) {
      if (u0 < bp0[frac]) {
        iRght = frac;
      } else {
        iLeft = frac;
      }

      frac = (iRght + iLeft) >> 1UL;
    }

    bpLeftVar = bp0[iLeft];
    frac = ((uint32_T)(u0 - bpLeftVar) << 16) / (bp0[iLeft + 1UL] - bpLeftVar);
  } else {
    iLeft = maxIndex - 1UL;
    frac = 65536UL;
  }

  /* Column-major Interpolation 1-D
     Interpolation method: 'Linear point-slope'
     Use last breakpoint for index at or above upper limit: 'off'
     Rounding mode: 'simplest'
     Overflow mode: 'wrapping'
   */
  bpLeftVar = table[iLeft + 1UL];
  yL_0d0 = table[iLeft];
  if (bpLeftVar >= yL_0d0) {
    y = (uint16_T)(((bpLeftVar - yL_0d0) * frac) >> 16) + yL_0d0;
  } else {
    y = yL_0d0 - (uint16_T)(((yL_0d0 - bpLeftVar) * frac) >> 16);
  }

  return y;
}

/* Function for Chart: '<Root>/Labyrinth' */
static void Labyrinth_FalscheAntwort(const int32_T *sfEvent_j)
{
  if (Labyrinth_DW.is_FalscheAntwort == Labyrinth_IN_Aus) {
    Labyrinth_B.LED1rot = 0.0;
    Labyrinth_B.LED2rot = 0.0;
    if (Labyrinth_DW.Frage == 2.0) {
      Labyrinth_B.LED1blau = 1.0;
      Labyrinth_DW.is_FalscheAntwort = Labyrinth_IN_NO_ACTIVE_CHILD;
      Labyrinth_DW.is_c3_Labyrinth = Labyrinth_IN_Frage2;
    } else if (Labyrinth_DW.Frage == 1.0) {
      Labyrinth_DW.is_FalscheAntwort = Labyrinth_IN_NO_ACTIVE_CHILD;
      Labyrinth_DW.is_c3_Labyrinth = Labyrinth_IN_Frage1;
      Labyrinth_B.LED3rot = 0.0;
      Labyrinth_B.LED4rot = 0.0;
    } else if (Labyrinth_DW.Frage == 4.0) {
      Labyrinth_B.LED3rot = 255.0;
      Labyrinth_B.LED3gruen = 45.0;
      Labyrinth_B.LED1blau = 1.0;
      Labyrinth_B.LED2gruen = 1.0;
      Labyrinth_DW.is_FalscheAntwort = Labyrinth_IN_NO_ACTIVE_CHILD;
      Labyrinth_DW.is_c3_Labyrinth = Labyrinth_IN_Frage4;
    } else if (Labyrinth_DW.Frage == 3.0) {
      Labyrinth_B.LED1blau = 1.0;
      Labyrinth_B.LED2gruen = 1.0;
      Labyrinth_DW.is_FalscheAntwort = Labyrinth_IN_NO_ACTIVE_CHILD;
      Labyrinth_DW.is_c3_Labyrinth = Labyrinth_IN_Frage3;
    }
  } else {
    /* case IN_Rot: */
    Labyrinth_B.LED1rot = 1.0;
    Labyrinth_B.LED2rot = 1.0;
    if (*sfEvent_j == Labyrinth_event_Timer) {
      Labyrinth_DW.is_FalscheAntwort = Labyrinth_IN_Aus;
      Labyrinth_B.LED1rot = 0.0;
      Labyrinth_B.LED2rot = 0.0;
      Labyrinth_B.LED3rot = 0.0;
      Labyrinth_B.LED4rot = 0.0;
    }
  }
}

/* Function for Chart: '<Root>/Labyrinth' */
static void Labyrint_chartstep_c3_Labyrinth(const int32_T *sfEvent_j)
{
  switch (Labyrinth_DW.is_c3_Labyrinth) {
   case Labyrinth_IN_Antwort1:
    if (*sfEvent_j == Labyrinth_event_Taster2Aus) {
      Labyrinth_B.StartTimer = 50U;
      Labyrinth_DW.is_c3_Labyrinth = Labyrinth_IN_TasterEntprellen1;
    }
    break;

   case Labyrinth_IN_Antwort2:
    if (*sfEvent_j == Labyrinth_event_Taster2Aus) {
      Labyrinth_B.StartTimer = 50U;
      Labyrinth_DW.is_c3_Labyrinth = Labyrinth_IN_TasterEntprellen2;
    }
    break;

   case Labyrinth_IN_Antwort3:
    if (*sfEvent_j == Labyrinth_event_Taster1Aus) {
      Labyrinth_B.StartTimer = 50U;
      Labyrinth_DW.is_c3_Labyrinth = Labyrinth_IN_TasterEntprellen3;
    }
    break;

   case Labyrinth_IN_Antwort4:
    if (*sfEvent_j == Labyrinth_event_Taster4Aus) {
      Labyrinth_B.StartTimer = 50U;
      Labyrinth_DW.is_c3_Labyrinth = Labyrinth_IN_TasterEntprellen4;
    }
    break;

   case Labyrinth_IN_FalscheAntwort:
    Labyrinth_FalscheAntwort(sfEvent_j);
    break;

   case Labyrinth_IN_Fertig:
    break;

   case Labyrinth_IN_Frage1:
    Labyrinth_B.LED1rot = 0.0;
    Labyrinth_B.LED2rot = 0.0;
    if ((*sfEvent_j == Labyrinth_event_Taster1Ein) || (*sfEvent_j ==
         Labyrinth_event_Taster3Ein) || (*sfEvent_j ==
         Labyrinth_event_Taster4Ein)) {
      Labyrinth_B.StartTimer = 1000U;
      Labyrinth_DW.is_c3_Labyrinth = Labyrinth_IN_FalscheAntwort;
      Labyrinth_DW.is_FalscheAntwort = Labyrinth_IN_Rot;
      Labyrinth_B.LED1rot = 1.0;
      Labyrinth_B.LED1blau = 0.0;
      Labyrinth_B.LED2rot = 1.0;
      Labyrinth_B.LED2gruen = 0.0;
      Labyrinth_B.LED3rot = 1.0;
      Labyrinth_B.LED3gruen = 0.0;
      Labyrinth_B.LED4rot = 1.0;
      Labyrinth_B.LED4blau = 0.0;
    } else if (*sfEvent_j == Labyrinth_event_Taster2Ein) {
      Labyrinth_B.LED1blau = 1.0;
      Labyrinth_DW.is_c3_Labyrinth = Labyrinth_IN_Antwort1;
    }
    break;

   case Labyrinth_IN_Frage2:
    if ((*sfEvent_j == Labyrinth_event_Taster1Ein) || (*sfEvent_j ==
         Labyrinth_event_Taster3Ein) || (*sfEvent_j ==
         Labyrinth_event_Taster4Ein)) {
      Labyrinth_B.StartTimer = 1000U;
      Labyrinth_DW.is_c3_Labyrinth = Labyrinth_IN_FalscheAntwort;
      Labyrinth_DW.is_FalscheAntwort = Labyrinth_IN_Rot;
      Labyrinth_B.LED1rot = 1.0;
      Labyrinth_B.LED1blau = 0.0;
      Labyrinth_B.LED2rot = 1.0;
      Labyrinth_B.LED2gruen = 0.0;
      Labyrinth_B.LED3rot = 1.0;
      Labyrinth_B.LED3gruen = 0.0;
      Labyrinth_B.LED4rot = 1.0;
      Labyrinth_B.LED4blau = 0.0;
    } else if (*sfEvent_j == Labyrinth_event_Taster2Ein) {
      Labyrinth_B.LED2gruen = 1.0;
      Labyrinth_DW.is_c3_Labyrinth = Labyrinth_IN_Antwort2;
    }
    break;

   case Labyrinth_IN_Frage3:
    if (*sfEvent_j == Labyrinth_event_Taster1Ein) {
      Labyrinth_B.LED3rot = 1.0;
      Labyrinth_B.LED3gruen = 45.0;
      Labyrinth_DW.is_c3_Labyrinth = Labyrinth_IN_Antwort3;
    } else if ((*sfEvent_j == Labyrinth_event_Taster2Ein) || (*sfEvent_j ==
                Labyrinth_event_Taster3Ein) || (*sfEvent_j ==
                Labyrinth_event_Taster4Ein)) {
      Labyrinth_B.StartTimer = 1000U;
      Labyrinth_DW.is_c3_Labyrinth = Labyrinth_IN_FalscheAntwort;
      Labyrinth_DW.is_FalscheAntwort = Labyrinth_IN_Rot;
      Labyrinth_B.LED1rot = 1.0;
      Labyrinth_B.LED1blau = 0.0;
      Labyrinth_B.LED2rot = 1.0;
      Labyrinth_B.LED2gruen = 0.0;
      Labyrinth_B.LED3rot = 1.0;
      Labyrinth_B.LED3gruen = 0.0;
      Labyrinth_B.LED4rot = 1.0;
      Labyrinth_B.LED4blau = 0.0;
    }
    break;

   case Labyrinth_IN_Frage4:
    if ((*sfEvent_j == Labyrinth_event_Taster1Ein) || (*sfEvent_j ==
         Labyrinth_event_Taster2Ein) || (*sfEvent_j ==
         Labyrinth_event_Taster3Ein)) {
      Labyrinth_B.StartTimer = 1000U;
      Labyrinth_DW.is_c3_Labyrinth = Labyrinth_IN_FalscheAntwort;
      Labyrinth_DW.is_FalscheAntwort = Labyrinth_IN_Rot;
      Labyrinth_B.LED1rot = 1.0;
      Labyrinth_B.LED1blau = 0.0;
      Labyrinth_B.LED2rot = 1.0;
      Labyrinth_B.LED2gruen = 0.0;
      Labyrinth_B.LED3rot = 1.0;
      Labyrinth_B.LED3gruen = 0.0;
      Labyrinth_B.LED4rot = 1.0;
      Labyrinth_B.LED4blau = 0.0;
    } else if (*sfEvent_j == Labyrinth_event_Taster4Ein) {
      Labyrinth_B.LED4rot = 1.0;
      Labyrinth_B.LED4blau = 70.0;
      Labyrinth_DW.is_c3_Labyrinth = Labyrinth_IN_Antwort4;
    }
    break;

   case Labyrinth_IN_INIT:
    Labyrinth_B.LED1rot = 1.0;
    Labyrinth_B.LED2rot = 1.0;
    if (*sfEvent_j == Labyrinth_event_Timer) {
      Labyrinth_DW.is_c3_Labyrinth = Labyrinth_IN_Frage1;
      Labyrinth_DW.Frage = 1.0;
      Labyrinth_B.LED1rot = 0.0;
      Labyrinth_B.LED2rot = 0.0;
      Labyrinth_B.LED3rot = 0.0;
      Labyrinth_B.LED4rot = 0.0;
    }
    break;

   case Labyrinth_IN_TasterEntprellen1:
    switch (*sfEvent_j) {
     case Labyrinth_event_Timer:
      Labyrinth_DW.is_c3_Labyrinth = Labyrinth_IN_Warten1;
      Labyrinth_B.StartTimer = 1000U;
      break;

     case Labyrinth_event_Taster2Ein:
      Labyrinth_DW.is_c3_Labyrinth = Labyrinth_IN_Antwort1;
      break;
    }
    break;

   case Labyrinth_IN_TasterEntprellen2:
    switch (*sfEvent_j) {
     case Labyrinth_event_Timer:
      Labyrinth_DW.is_c3_Labyrinth = Labyrinth_IN_Warten2;
      Labyrinth_B.StartTimer = 1000U;
      break;

     case Labyrinth_event_Taster2Ein:
      Labyrinth_DW.is_c3_Labyrinth = Labyrinth_IN_Antwort2;
      break;
    }
    break;

   case Labyrinth_IN_TasterEntprellen3:
    switch (*sfEvent_j) {
     case Labyrinth_event_Taster1Ein:
      Labyrinth_DW.is_c3_Labyrinth = Labyrinth_IN_Antwort3;
      break;

     case Labyrinth_event_Timer:
      Labyrinth_DW.is_c3_Labyrinth = Labyrinth_IN_Warten3;
      Labyrinth_B.StartTimer = 1000U;
      break;
    }
    break;

   case Labyrinth_IN_TasterEntprellen4:
    switch (*sfEvent_j) {
     case Labyrinth_event_Taster4Ein:
      Labyrinth_DW.is_c3_Labyrinth = Labyrinth_IN_Antwort4;
      break;

     case Labyrinth_event_Timer:
      Labyrinth_DW.is_c3_Labyrinth = Labyrinth_IN_Fertig;
      break;
    }
    break;

   case Labyrinth_IN_Warten1:
    if (*sfEvent_j == Labyrinth_event_Timer) {
      Labyrinth_DW.is_c3_Labyrinth = Labyrinth_IN_Frage2;
      Labyrinth_DW.Frage = 2.0;
    }
    break;

   case Labyrinth_IN_Warten2:
    if (*sfEvent_j == Labyrinth_event_Timer) {
      Labyrinth_DW.is_c3_Labyrinth = Labyrinth_IN_Frage3;
      Labyrinth_DW.Frage = 3.0;
    }
    break;

   default:
    /* case IN_Warten3: */
    if (*sfEvent_j == Labyrinth_event_Timer) {
      Labyrinth_DW.is_c3_Labyrinth = Labyrinth_IN_Frage4;
      Labyrinth_DW.Frage = 4.0;
    }
    break;
  }
}

real_T rt_roundd_snf(real_T u)
{
  real_T y;
  if (fabs(u) < 4.503599627370496E+15) {
    if (u >= 0.5) {
      y = floor(u + 0.5);
    } else if (u > -0.5) {
      y = u * 0.0;
    } else {
      y = ceil(u - 0.5);
    }
  } else {
    y = u;
  }

  return y;
}

/* Model step function */
void Labyrinth_step(void)
{
  real_T y;
  int32_T sfEvent_j;
  int16_T i;
  uint16_T rtb_LookUp1;
  uint16_T rtb_Taster4_o;
  uint8_T tmp;
  boolean_T zcEvent[9];
  boolean_T rtb_Compare;
  boolean_T rtb_Compare_a;
  boolean_T rtb_Compare_d;
  boolean_T rtb_Compare_f;
  boolean_T rtb_Compare_i;
  boolean_T rtb_Compare_o;
  boolean_T zcEvent_0;

  /* Reset subsysRan breadcrumbs */
  srClearBC(Labyrinth_DW.Labyrinth_SubsysRanBC);

  /* Reset subsysRan breadcrumbs */
  srClearBC(Labyrinth_DW.TimerBaustein_SubsysRanBC);

  /* MATLABSystem: '<Root>/PWM' */
  Labyrinth_DW.obj_e.PWMDriverObj.MW_PWM_HANDLE = MW_PWM_GetHandle(11UL);

  /* Start for MATLABSystem: '<Root>/PWM' incorporates:
   *  Constant: '<Root>/Constant'
   */
  if (Labyrinth_P.Constant_Value <= 255.0) {
    y = Labyrinth_P.Constant_Value;
  } else {
    y = 255.0;
  }

  if (!(y >= 0.0)) {
    y = 0.0;
  }

  /* MATLABSystem: '<Root>/PWM' */
  MW_PWM_SetDutyCycle(Labyrinth_DW.obj_e.PWMDriverObj.MW_PWM_HANDLE, y);

  /* MATLABSystem: '<Root>/Taster1' */
  if (Labyrinth_DW.obj_b.SampleTime != Labyrinth_P.Taster1_SampleTime) {
    Labyrinth_DW.obj_b.SampleTime = Labyrinth_P.Taster1_SampleTime;
  }

  Labyrinth_DW.obj_b.AnalogInDriverObj.MW_ANALOGIN_HANDLE =
    MW_AnalogIn_GetHandle(14UL);
  MW_AnalogInSingle_ReadResult
    (Labyrinth_DW.obj_b.AnalogInDriverObj.MW_ANALOGIN_HANDLE, &rtb_Taster4_o,
     MW_ANALOGIN_UINT16);

  /* Lookup_n-D: '<Root>/LookUp1' incorporates:
   *  MATLABSystem: '<Root>/Taster1'
   * */
  rtb_LookUp1 = look1_iu16lu32n16_binlcse(rtb_Taster4_o,
    Labyrinth_P.LookUp1_bp01Data, Labyrinth_P.LookUp1_tableData, 1UL);

  /* RelationalOperator: '<S2>/Compare' incorporates:
   *  Constant: '<S2>/Constant'
   */
  rtb_Compare = (rtb_LookUp1 == Labyrinth_P.Constant_Value_m);

  /* MATLABSystem: '<Root>/Taster2' */
  if (Labyrinth_DW.obj_l.SampleTime != Labyrinth_P.Taster2_SampleTime) {
    Labyrinth_DW.obj_l.SampleTime = Labyrinth_P.Taster2_SampleTime;
  }

  Labyrinth_DW.obj_l.AnalogInDriverObj.MW_ANALOGIN_HANDLE =
    MW_AnalogIn_GetHandle(15UL);
  MW_AnalogInSingle_ReadResult
    (Labyrinth_DW.obj_l.AnalogInDriverObj.MW_ANALOGIN_HANDLE, &rtb_Taster4_o,
     MW_ANALOGIN_UINT16);

  /* Lookup_n-D: '<Root>/LookUp2' incorporates:
   *  MATLABSystem: '<Root>/Taster2'
   * */
  rtb_Taster4_o = look1_iu16lu32n16_binlcse(rtb_Taster4_o,
    Labyrinth_P.LookUp2_bp01Data, Labyrinth_P.LookUp2_tableData, 1UL);

  /* RelationalOperator: '<S4>/Compare' incorporates:
   *  Constant: '<S4>/Constant'
   */
  Labyrinth_B.Compare = (rtb_Taster4_o == Labyrinth_P.Constant_Value_l);

  /* MATLABSystem: '<Root>/Timer' */
  if (Labyrinth_DW.obj_c.SampleTime != Labyrinth_P.Timer_SampleTime) {
    Labyrinth_DW.obj_c.SampleTime = Labyrinth_P.Timer_SampleTime;
  }

  /* MATLABSystem: '<Root>/Timer' */
  Labyrinth_B.Timer_g = readDigitalPin(12);

  /* UnitDelay: '<Root>/Unit Delay1' */
  Labyrinth_B.UnitDelay1 = Labyrinth_DW.UnitDelay1_DSTATE;

  /* Chart: '<Root>/TimerBaustein' incorporates:
   *  TriggerPort: '<S10>/CLOCK'
   */
  if (Labyrinth_B.Timer_g && (Labyrinth_PrevZCX.TimerBaustein_Trig_ZCE !=
       POS_ZCSIG)) {
    /* Chart: '<Root>/TimerBaustein' incorporates:
     *  TriggerPort: '<S10>/CLOCK'
     */
    Labyrinth_B.CLOCK = 1;
    if (Labyrinth_DW.temporalCounter_i1 < MAX_uint32_T) {
      Labyrinth_DW.temporalCounter_i1++;
    }

    if (Labyrinth_DW.is_c1_Labyrinth == Labyrinth_IN_TimerIdle) {
      if (Labyrinth_B.UnitDelay1 != 0U) {
        Labyrinth_DW.timerValue = Labyrinth_B.UnitDelay1;
        Labyrinth_B.Timer = false;
        Labyrinth_DW.temporalCounter_i1 = 0UL;
        Labyrinth_DW.is_c1_Labyrinth = Labyrinth_IN_TimerRunning;
      }

      /* case IN_TimerRunning: */
    } else if (Labyrinth_B.UnitDelay1 != Labyrinth_DW.timerValue) {
      if (Labyrinth_B.UnitDelay1 != 0U) {
        Labyrinth_DW.timerValue = Labyrinth_B.UnitDelay1;
        Labyrinth_B.Timer = false;
        Labyrinth_DW.temporalCounter_i1 = 0UL;
        Labyrinth_DW.is_c1_Labyrinth = Labyrinth_IN_TimerRunning;
      } else {
        Labyrinth_DW.is_c1_Labyrinth = Labyrinth_IN_TimerIdle;
      }
    } else if (Labyrinth_DW.temporalCounter_i1 >= Labyrinth_B.UnitDelay1) {
      Labyrinth_B.Timer = true;
      Labyrinth_DW.is_c1_Labyrinth = Labyrinth_IN_TimerIdle;
    }

    Labyrinth_DW.TimerBaustein_SubsysRanBC = 4;
  }

  Labyrinth_PrevZCX.TimerBaustein_Trig_ZCE = Labyrinth_B.Timer_g;

  /* RelationalOperator: '<S3>/Compare' incorporates:
   *  Constant: '<S3>/Constant'
   */
  rtb_Compare_i = (rtb_LookUp1 > Labyrinth_P.Constant_Value_o);

  /* RelationalOperator: '<S5>/Compare' incorporates:
   *  Constant: '<S5>/Constant'
   */
  Labyrinth_B.Compare_m = (rtb_Taster4_o > Labyrinth_P.Constant_Value_b);

  /* MATLABSystem: '<Root>/Taster 3' */
  if (Labyrinth_DW.obj_p.SampleTime != Labyrinth_P.Taster3_SampleTime) {
    Labyrinth_DW.obj_p.SampleTime = Labyrinth_P.Taster3_SampleTime;
  }

  Labyrinth_DW.obj_p.AnalogInDriverObj.MW_ANALOGIN_HANDLE =
    MW_AnalogIn_GetHandle(16UL);
  MW_AnalogInSingle_ReadResult
    (Labyrinth_DW.obj_p.AnalogInDriverObj.MW_ANALOGIN_HANDLE, &rtb_Taster4_o,
     MW_ANALOGIN_UINT16);

  /* Lookup_n-D: '<Root>/LookUp3' incorporates:
   *  MATLABSystem: '<Root>/Taster 3'
   * */
  rtb_Taster4_o = look1_iu16lu32n16_binlcse(rtb_Taster4_o,
    Labyrinth_P.LookUp3_bp01Data, Labyrinth_P.LookUp3_tableData, 1UL);

  /* RelationalOperator: '<S6>/Compare' incorporates:
   *  Constant: '<S6>/Constant'
   */
  rtb_Compare_a = (rtb_Taster4_o == Labyrinth_P.Constant_Value_g);

  /* RelationalOperator: '<S7>/Compare' incorporates:
   *  Constant: '<S7>/Constant'
   */
  rtb_Compare_o = (rtb_Taster4_o > Labyrinth_P.Constant_Value_gl);

  /* MATLABSystem: '<Root>/Taster4' */
  if (Labyrinth_DW.obj.SampleTime != Labyrinth_P.Taster4_SampleTime) {
    Labyrinth_DW.obj.SampleTime = Labyrinth_P.Taster4_SampleTime;
  }

  Labyrinth_DW.obj.AnalogInDriverObj.MW_ANALOGIN_HANDLE = MW_AnalogIn_GetHandle
    (17UL);
  MW_AnalogInSingle_ReadResult
    (Labyrinth_DW.obj.AnalogInDriverObj.MW_ANALOGIN_HANDLE, &rtb_Taster4_o,
     MW_ANALOGIN_UINT16);

  /* Lookup_n-D: '<Root>/LookUp4' incorporates:
   *  MATLABSystem: '<Root>/Taster4'
   * */
  rtb_Taster4_o = look1_iu16lu32n16_binlcse(rtb_Taster4_o,
    Labyrinth_P.LookUp4_bp01Data, Labyrinth_P.LookUp4_tableData, 1UL);

  /* RelationalOperator: '<S8>/Compare' incorporates:
   *  Constant: '<S8>/Constant'
   */
  rtb_Compare_f = (rtb_Taster4_o == Labyrinth_P.Constant_Value_i);

  /* RelationalOperator: '<S9>/Compare' incorporates:
   *  Constant: '<S9>/Constant'
   */
  rtb_Compare_d = (rtb_Taster4_o > Labyrinth_P.Constant_Value_p);

  /* Chart: '<Root>/Labyrinth' incorporates:
   *  TriggerPort: '<S1>/input events'
   */
  zcEvent[0] = (Labyrinth_B.Timer && (Labyrinth_PrevZCX.Labyrinth_Trig_ZCE[0] !=
    POS_ZCSIG));
  zcEvent[1] = (rtb_Compare && (Labyrinth_PrevZCX.Labyrinth_Trig_ZCE[1] !=
    POS_ZCSIG));
  zcEvent[2] = (rtb_Compare_i && (Labyrinth_PrevZCX.Labyrinth_Trig_ZCE[2] !=
    POS_ZCSIG));
  zcEvent[3] = (Labyrinth_B.Compare && (Labyrinth_PrevZCX.Labyrinth_Trig_ZCE[3]
    != POS_ZCSIG));
  zcEvent[4] = (Labyrinth_B.Compare_m && (Labyrinth_PrevZCX.Labyrinth_Trig_ZCE[4]
    != POS_ZCSIG));
  zcEvent[5] = (rtb_Compare_a && (Labyrinth_PrevZCX.Labyrinth_Trig_ZCE[5] !=
    POS_ZCSIG));
  zcEvent[6] = (rtb_Compare_o && (Labyrinth_PrevZCX.Labyrinth_Trig_ZCE[6] !=
    POS_ZCSIG));
  zcEvent[7] = (rtb_Compare_f && (Labyrinth_PrevZCX.Labyrinth_Trig_ZCE[7] !=
    POS_ZCSIG));
  zcEvent[8] = (rtb_Compare_d && (Labyrinth_PrevZCX.Labyrinth_Trig_ZCE[8] !=
    POS_ZCSIG));
  zcEvent_0 = false;
  for (i = 0; i < 9; i++) {
    zcEvent_0 = (zcEvent_0 || zcEvent[i]);
  }

  if (zcEvent_0) {
    /* Chart: '<Root>/Labyrinth' incorporates:
     *  TriggerPort: '<S1>/input events'
     */
    for (i = 0; i < 9; i++) {
      Labyrinth_B.inputevents[i] = (int8_T)zcEvent[i];
    }

    if (Labyrinth_B.inputevents[0UL] == 1) {
      sfEvent_j = Labyrinth_event_Timer;
      Labyrint_chartstep_c3_Labyrinth(&sfEvent_j);
    }

    if (Labyrinth_B.inputevents[1UL] == 1) {
      sfEvent_j = Labyrinth_event_Taster1Aus;
      Labyrint_chartstep_c3_Labyrinth(&sfEvent_j);
    }

    if (Labyrinth_B.inputevents[2UL] == 1) {
      sfEvent_j = Labyrinth_event_Taster1Ein;
      Labyrint_chartstep_c3_Labyrinth(&sfEvent_j);
    }

    if (Labyrinth_B.inputevents[3UL] == 1) {
      sfEvent_j = Labyrinth_event_Taster2Aus;
      Labyrint_chartstep_c3_Labyrinth(&sfEvent_j);
    }

    if (Labyrinth_B.inputevents[4UL] == 1) {
      sfEvent_j = Labyrinth_event_Taster2Ein;
      Labyrint_chartstep_c3_Labyrinth(&sfEvent_j);
    }

    if (Labyrinth_B.inputevents[5UL] == 1) {
      sfEvent_j = Labyrinth_event_Taster3Aus;
      Labyrint_chartstep_c3_Labyrinth(&sfEvent_j);
    }

    if (Labyrinth_B.inputevents[6UL] == 1) {
      sfEvent_j = Labyrinth_event_Taster3Ein;
      Labyrint_chartstep_c3_Labyrinth(&sfEvent_j);
    }

    if (Labyrinth_B.inputevents[7UL] == 1) {
      sfEvent_j = Labyrinth_event_Taster4Aus;
      Labyrint_chartstep_c3_Labyrinth(&sfEvent_j);
    }

    if (Labyrinth_B.inputevents[8UL] == 1) {
      sfEvent_j = Labyrinth_event_Taster4Ein;
      Labyrint_chartstep_c3_Labyrinth(&sfEvent_j);
    }

    Labyrinth_DW.Labyrinth_SubsysRanBC = 4;
  }

  Labyrinth_PrevZCX.Labyrinth_Trig_ZCE[0] = Labyrinth_B.Timer;
  Labyrinth_PrevZCX.Labyrinth_Trig_ZCE[1] = rtb_Compare;
  Labyrinth_PrevZCX.Labyrinth_Trig_ZCE[2] = rtb_Compare_i;
  Labyrinth_PrevZCX.Labyrinth_Trig_ZCE[3] = Labyrinth_B.Compare;
  Labyrinth_PrevZCX.Labyrinth_Trig_ZCE[4] = Labyrinth_B.Compare_m;
  Labyrinth_PrevZCX.Labyrinth_Trig_ZCE[5] = rtb_Compare_a;
  Labyrinth_PrevZCX.Labyrinth_Trig_ZCE[6] = rtb_Compare_o;
  Labyrinth_PrevZCX.Labyrinth_Trig_ZCE[7] = rtb_Compare_f;
  Labyrinth_PrevZCX.Labyrinth_Trig_ZCE[8] = rtb_Compare_d;

  /* MATLABSystem: '<Root>/LED1blau' */
  y = rt_roundd_snf(Labyrinth_B.LED1blau);
  if (y < 256.0) {
    if (y >= 0.0) {
      tmp = (uint8_T)y;
    } else {
      tmp = 0U;
    }
  } else {
    tmp = MAX_uint8_T;
  }

  writeDigitalPin(3, tmp);

  /* End of MATLABSystem: '<Root>/LED1blau' */

  /* MATLABSystem: '<Root>/LED1rot' */
  y = rt_roundd_snf(Labyrinth_B.LED1rot);
  if (y < 256.0) {
    if (y >= 0.0) {
      tmp = (uint8_T)y;
    } else {
      tmp = 0U;
    }
  } else {
    tmp = MAX_uint8_T;
  }

  writeDigitalPin(2, tmp);

  /* End of MATLABSystem: '<Root>/LED1rot' */

  /* MATLABSystem: '<Root>/LED2gruen' */
  y = rt_roundd_snf(Labyrinth_B.LED2gruen);
  if (y < 256.0) {
    if (y >= 0.0) {
      tmp = (uint8_T)y;
    } else {
      tmp = 0U;
    }
  } else {
    tmp = MAX_uint8_T;
  }

  writeDigitalPin(5, tmp);

  /* End of MATLABSystem: '<Root>/LED2gruen' */

  /* MATLABSystem: '<Root>/LED2rot' */
  y = rt_roundd_snf(Labyrinth_B.LED2rot);
  if (y < 256.0) {
    if (y >= 0.0) {
      tmp = (uint8_T)y;
    } else {
      tmp = 0U;
    }
  } else {
    tmp = MAX_uint8_T;
  }

  writeDigitalPin(4, tmp);

  /* End of MATLABSystem: '<Root>/LED2rot' */

  /* MATLABSystem: '<Root>/LED3rot' */
  y = rt_roundd_snf(Labyrinth_B.LED3rot);
  if (y < 256.0) {
    if (y >= 0.0) {
      tmp = (uint8_T)y;
    } else {
      tmp = 0U;
    }
  } else {
    tmp = MAX_uint8_T;
  }

  writeDigitalPin(6, tmp);

  /* End of MATLABSystem: '<Root>/LED3rot' */

  /* MATLABSystem: '<Root>/LED4blau' */
  Labyrinth_DW.obj_j.PWMDriverObj.MW_PWM_HANDLE = MW_PWM_GetHandle(10UL);

  /* Start for MATLABSystem: '<Root>/LED4blau' */
  if (Labyrinth_B.LED4blau <= 255.0) {
    y = Labyrinth_B.LED4blau;
  } else {
    y = 255.0;
  }

  if (!(y >= 0.0)) {
    y = 0.0;
  }

  /* MATLABSystem: '<Root>/LED4blau' */
  MW_PWM_SetDutyCycle(Labyrinth_DW.obj_j.PWMDriverObj.MW_PWM_HANDLE, y);

  /* MATLABSystem: '<Root>/LED4rot' */
  y = rt_roundd_snf(Labyrinth_B.LED4rot);
  if (y < 256.0) {
    if (y >= 0.0) {
      tmp = (uint8_T)y;
    } else {
      tmp = 0U;
    }
  } else {
    tmp = MAX_uint8_T;
  }

  writeDigitalPin(7, tmp);

  /* End of MATLABSystem: '<Root>/LED4rot' */

  /* MATLABSystem: '<Root>/LEED3gruen' */
  Labyrinth_DW.obj_bs.PWMDriverObj.MW_PWM_HANDLE = MW_PWM_GetHandle(9UL);

  /* Start for MATLABSystem: '<Root>/LEED3gruen' */
  if (Labyrinth_B.LED3gruen <= 255.0) {
    y = Labyrinth_B.LED3gruen;
  } else {
    y = 255.0;
  }

  if (!(y >= 0.0)) {
    y = 0.0;
  }

  /* MATLABSystem: '<Root>/LEED3gruen' */
  MW_PWM_SetDutyCycle(Labyrinth_DW.obj_bs.PWMDriverObj.MW_PWM_HANDLE, y);

  /* Update for UnitDelay: '<Root>/Unit Delay1' */
  Labyrinth_DW.UnitDelay1_DSTATE = Labyrinth_B.StartTimer;

  {                                    /* Sample time: [0.0s, 0.0s] */
    extmodeErrorCode_T errorCode = EXTMODE_SUCCESS;
    extmodeSimulationTime_T currentTime = (extmodeSimulationTime_T)
      ((Labyrinth_M->Timing.clockTick0 * 1) + 0)
      ;

    /* Trigger External Mode event */
    errorCode = extmodeEvent(0,currentTime);
    if (errorCode != EXTMODE_SUCCESS) {
      /* Code to handle External Mode event errors
         may be added here */
    }
  }

  {                                    /* Sample time: [0.001s, 0.0s] */
    extmodeErrorCode_T errorCode = EXTMODE_SUCCESS;
    extmodeSimulationTime_T currentTime = (extmodeSimulationTime_T)
      ((Labyrinth_M->Timing.clockTick1 * 1) + 0)
      ;

    /* Trigger External Mode event */
    errorCode = extmodeEvent(1,currentTime);
    if (errorCode != EXTMODE_SUCCESS) {
      /* Code to handle External Mode event errors
         may be added here */
    }
  }

  /* Update absolute time for base rate */
  /* The "clockTick0" counts the number of times the code of this task has
   * been executed. The absolute time is the multiplication of "clockTick0"
   * and "Timing.stepSize0". Size of "clockTick0" ensures timer will not
   * overflow during the application lifespan selected.
   */
  Labyrinth_M->Timing.t[0] =
    ((time_T)(++Labyrinth_M->Timing.clockTick0)) * Labyrinth_M->Timing.stepSize0;

  {
    /* Update absolute timer for sample time: [0.001s, 0.0s] */
    /* The "clockTick1" counts the number of times the code of this task has
     * been executed. The resolution of this integer timer is 0.001, which is the step size
     * of the task. Size of "clockTick1" ensures timer will not overflow during the
     * application lifespan selected.
     */
    Labyrinth_M->Timing.clockTick1++;
  }
}

/* Model initialize function */
void Labyrinth_initialize(void)
{
  /* Registration code */
  {
    /* Setup solver object */
    rtsiSetSimTimeStepPtr(&Labyrinth_M->solverInfo,
                          &Labyrinth_M->Timing.simTimeStep);
    rtsiSetTPtr(&Labyrinth_M->solverInfo, &rtmGetTPtr(Labyrinth_M));
    rtsiSetStepSizePtr(&Labyrinth_M->solverInfo, &Labyrinth_M->Timing.stepSize0);
    rtsiSetErrorStatusPtr(&Labyrinth_M->solverInfo, (&rtmGetErrorStatus
      (Labyrinth_M)));
    rtsiSetRTModelPtr(&Labyrinth_M->solverInfo, Labyrinth_M);
  }

  rtsiSetSimTimeStep(&Labyrinth_M->solverInfo, MAJOR_TIME_STEP);
  rtsiSetSolverName(&Labyrinth_M->solverInfo,"FixedStepDiscrete");
  rtmSetTPtr(Labyrinth_M, &Labyrinth_M->Timing.tArray[0]);
  rtmSetTFinal(Labyrinth_M, -1);
  Labyrinth_M->Timing.stepSize0 = 0.001;

  /* External mode info */
  Labyrinth_M->Sizes.checksums[0] = (978293434U);
  Labyrinth_M->Sizes.checksums[1] = (624783262U);
  Labyrinth_M->Sizes.checksums[2] = (3294595823U);
  Labyrinth_M->Sizes.checksums[3] = (572152387U);

  {
    static const sysRanDType rtAlwaysEnabled = SUBSYS_RAN_BC_ENABLE;
    static RTWExtModeInfo rt_ExtModeInfo;
    static const sysRanDType *systemRan[17];
    Labyrinth_M->extModeInfo = (&rt_ExtModeInfo);
    rteiSetSubSystemActiveVectorAddresses(&rt_ExtModeInfo, systemRan);
    systemRan[0] = &rtAlwaysEnabled;
    systemRan[1] = &rtAlwaysEnabled;
    systemRan[2] = &rtAlwaysEnabled;
    systemRan[3] = &rtAlwaysEnabled;
    systemRan[4] = &rtAlwaysEnabled;
    systemRan[5] = &rtAlwaysEnabled;
    systemRan[6] = &rtAlwaysEnabled;
    systemRan[7] = &rtAlwaysEnabled;
    systemRan[8] = &rtAlwaysEnabled;
    systemRan[9] = (sysRanDType *)&Labyrinth_DW.Labyrinth_SubsysRanBC;
    systemRan[10] = &rtAlwaysEnabled;
    systemRan[11] = &rtAlwaysEnabled;
    systemRan[12] = &rtAlwaysEnabled;
    systemRan[13] = &rtAlwaysEnabled;
    systemRan[14] = &rtAlwaysEnabled;
    systemRan[15] = &rtAlwaysEnabled;
    systemRan[16] = (sysRanDType *)&Labyrinth_DW.TimerBaustein_SubsysRanBC;
    rteiSetModelMappingInfoPtr(Labyrinth_M->extModeInfo,
      &Labyrinth_M->SpecialInfo.mappingInfo);
    rteiSetChecksumsPtr(Labyrinth_M->extModeInfo, Labyrinth_M->Sizes.checksums);
    rteiSetTPtr(Labyrinth_M->extModeInfo, rtmGetTPtr(Labyrinth_M));
  }

  {
    int16_T i;
    for (i = 0; i < 9; i++) {
      Labyrinth_PrevZCX.Labyrinth_Trig_ZCE[i] = POS_ZCSIG;
    }

    Labyrinth_PrevZCX.TimerBaustein_Trig_ZCE = POS_ZCSIG;

    /* InitializeConditions for UnitDelay: '<Root>/Unit Delay1' */
    Labyrinth_DW.UnitDelay1_DSTATE = Labyrinth_P.UnitDelay1_InitialCondition;

    /* Chart: '<Root>/TimerBaustein' */
    Labyrinth_DW.is_active_c1_Labyrinth = 1U;
    Labyrinth_DW.is_c1_Labyrinth = Labyrinth_IN_TimerIdle;

    /* Chart: '<Root>/Labyrinth' */
    Labyrinth_DW.is_active_c3_Labyrinth = 1U;
    Labyrinth_DW.is_c3_Labyrinth = Labyrinth_IN_INIT;
    Labyrinth_B.LED1rot = 1.0;
    Labyrinth_B.LED2rot = 1.0;
    Labyrinth_B.LED3rot = 1.0;
    Labyrinth_B.LED4rot = 1.0;
    Labyrinth_B.StartTimer = 1000U;

    /* Start for MATLABSystem: '<Root>/PWM' */
    Labyrinth_DW.obj_e.matlabCodegenIsDeleted = false;
    Labyrinth_DW.obj_e.isInitialized = 1L;
    Labyrinth_DW.obj_e.PWMDriverObj.MW_PWM_HANDLE = MW_PWM_Open(11UL, 0.0, 0.0);
    Labyrinth_DW.obj_e.isSetupComplete = true;

    /* Start for MATLABSystem: '<Root>/Taster1' */
    Labyrinth_DW.obj_b.matlabCodegenIsDeleted = false;
    Labyrinth_DW.obj_b.SampleTime = Labyrinth_P.Taster1_SampleTime;
    Labyrinth_DW.obj_b.isInitialized = 1L;
    Labyrinth_DW.obj_b.AnalogInDriverObj.MW_ANALOGIN_HANDLE =
      MW_AnalogInSingle_Open(14UL);
    Labyrinth_DW.obj_b.isSetupComplete = true;

    /* Start for MATLABSystem: '<Root>/Taster2' */
    Labyrinth_DW.obj_l.matlabCodegenIsDeleted = false;
    Labyrinth_DW.obj_l.SampleTime = Labyrinth_P.Taster2_SampleTime;
    Labyrinth_DW.obj_l.isInitialized = 1L;
    Labyrinth_DW.obj_l.AnalogInDriverObj.MW_ANALOGIN_HANDLE =
      MW_AnalogInSingle_Open(15UL);
    Labyrinth_DW.obj_l.isSetupComplete = true;

    /* Start for MATLABSystem: '<Root>/Timer' */
    Labyrinth_DW.obj_c.matlabCodegenIsDeleted = false;
    Labyrinth_DW.obj_c.SampleTime = Labyrinth_P.Timer_SampleTime;
    Labyrinth_DW.obj_c.isInitialized = 1L;
    digitalIOSetup(12, 0);
    Labyrinth_DW.obj_c.isSetupComplete = true;

    /* Start for MATLABSystem: '<Root>/Taster 3' */
    Labyrinth_DW.obj_p.matlabCodegenIsDeleted = false;
    Labyrinth_DW.obj_p.SampleTime = Labyrinth_P.Taster3_SampleTime;
    Labyrinth_DW.obj_p.isInitialized = 1L;
    Labyrinth_DW.obj_p.AnalogInDriverObj.MW_ANALOGIN_HANDLE =
      MW_AnalogInSingle_Open(16UL);
    Labyrinth_DW.obj_p.isSetupComplete = true;

    /* Start for MATLABSystem: '<Root>/Taster4' */
    Labyrinth_DW.obj.matlabCodegenIsDeleted = false;
    Labyrinth_DW.obj.SampleTime = Labyrinth_P.Taster4_SampleTime;
    Labyrinth_DW.obj.isInitialized = 1L;
    Labyrinth_DW.obj.AnalogInDriverObj.MW_ANALOGIN_HANDLE =
      MW_AnalogInSingle_Open(17UL);
    Labyrinth_DW.obj.isSetupComplete = true;

    /* Start for MATLABSystem: '<Root>/LED1blau' */
    Labyrinth_DW.obj_n.matlabCodegenIsDeleted = false;
    Labyrinth_DW.obj_n.isInitialized = 1L;
    digitalIOSetup(3, 1);
    Labyrinth_DW.obj_n.isSetupComplete = true;

    /* Start for MATLABSystem: '<Root>/LED1rot' */
    Labyrinth_DW.obj_fk.matlabCodegenIsDeleted = false;
    Labyrinth_DW.obj_fk.isInitialized = 1L;
    digitalIOSetup(2, 1);
    Labyrinth_DW.obj_fk.isSetupComplete = true;

    /* Start for MATLABSystem: '<Root>/LED2gruen' */
    Labyrinth_DW.obj_m.matlabCodegenIsDeleted = false;
    Labyrinth_DW.obj_m.isInitialized = 1L;
    digitalIOSetup(5, 1);
    Labyrinth_DW.obj_m.isSetupComplete = true;

    /* Start for MATLABSystem: '<Root>/LED2rot' */
    Labyrinth_DW.obj_o.matlabCodegenIsDeleted = false;
    Labyrinth_DW.obj_o.isInitialized = 1L;
    digitalIOSetup(4, 1);
    Labyrinth_DW.obj_o.isSetupComplete = true;

    /* Start for MATLABSystem: '<Root>/LED3rot' */
    Labyrinth_DW.obj_f.matlabCodegenIsDeleted = false;
    Labyrinth_DW.obj_f.isInitialized = 1L;
    digitalIOSetup(6, 1);
    Labyrinth_DW.obj_f.isSetupComplete = true;

    /* Start for MATLABSystem: '<Root>/LED4blau' */
    Labyrinth_DW.obj_j.matlabCodegenIsDeleted = false;
    Labyrinth_DW.obj_j.isInitialized = 1L;
    Labyrinth_DW.obj_j.PWMDriverObj.MW_PWM_HANDLE = MW_PWM_Open(10UL, 0.0, 0.0);
    Labyrinth_DW.obj_j.isSetupComplete = true;

    /* Start for MATLABSystem: '<Root>/LED4rot' */
    Labyrinth_DW.obj_d.matlabCodegenIsDeleted = false;
    Labyrinth_DW.obj_d.isInitialized = 1L;
    digitalIOSetup(7, 1);
    Labyrinth_DW.obj_d.isSetupComplete = true;

    /* Start for MATLABSystem: '<Root>/LEED3gruen' */
    Labyrinth_DW.obj_bs.matlabCodegenIsDeleted = false;
    Labyrinth_DW.obj_bs.isInitialized = 1L;
    Labyrinth_DW.obj_bs.PWMDriverObj.MW_PWM_HANDLE = MW_PWM_Open(9UL, 0.0, 0.0);
    Labyrinth_DW.obj_bs.isSetupComplete = true;
  }
}

/* Model terminate function */
void Labyrinth_terminate(void)
{
  /* Terminate for MATLABSystem: '<Root>/PWM' */
  if (!Labyrinth_DW.obj_e.matlabCodegenIsDeleted) {
    Labyrinth_DW.obj_e.matlabCodegenIsDeleted = true;
    if ((Labyrinth_DW.obj_e.isInitialized == 1L) &&
        Labyrinth_DW.obj_e.isSetupComplete) {
      Labyrinth_DW.obj_e.PWMDriverObj.MW_PWM_HANDLE = MW_PWM_GetHandle(11UL);
      MW_PWM_SetDutyCycle(Labyrinth_DW.obj_e.PWMDriverObj.MW_PWM_HANDLE, 0.0);
      Labyrinth_DW.obj_e.PWMDriverObj.MW_PWM_HANDLE = MW_PWM_GetHandle(11UL);
      MW_PWM_Close(Labyrinth_DW.obj_e.PWMDriverObj.MW_PWM_HANDLE);
    }
  }

  /* End of Terminate for MATLABSystem: '<Root>/PWM' */

  /* Terminate for MATLABSystem: '<Root>/Taster1' */
  if (!Labyrinth_DW.obj_b.matlabCodegenIsDeleted) {
    Labyrinth_DW.obj_b.matlabCodegenIsDeleted = true;
    if ((Labyrinth_DW.obj_b.isInitialized == 1L) &&
        Labyrinth_DW.obj_b.isSetupComplete) {
      Labyrinth_DW.obj_b.AnalogInDriverObj.MW_ANALOGIN_HANDLE =
        MW_AnalogIn_GetHandle(14UL);
      MW_AnalogIn_Close(Labyrinth_DW.obj_b.AnalogInDriverObj.MW_ANALOGIN_HANDLE);
    }
  }

  /* End of Terminate for MATLABSystem: '<Root>/Taster1' */

  /* Terminate for MATLABSystem: '<Root>/Taster2' */
  if (!Labyrinth_DW.obj_l.matlabCodegenIsDeleted) {
    Labyrinth_DW.obj_l.matlabCodegenIsDeleted = true;
    if ((Labyrinth_DW.obj_l.isInitialized == 1L) &&
        Labyrinth_DW.obj_l.isSetupComplete) {
      Labyrinth_DW.obj_l.AnalogInDriverObj.MW_ANALOGIN_HANDLE =
        MW_AnalogIn_GetHandle(15UL);
      MW_AnalogIn_Close(Labyrinth_DW.obj_l.AnalogInDriverObj.MW_ANALOGIN_HANDLE);
    }
  }

  /* End of Terminate for MATLABSystem: '<Root>/Taster2' */

  /* Terminate for MATLABSystem: '<Root>/Timer' */
  if (!Labyrinth_DW.obj_c.matlabCodegenIsDeleted) {
    Labyrinth_DW.obj_c.matlabCodegenIsDeleted = true;
  }

  /* End of Terminate for MATLABSystem: '<Root>/Timer' */

  /* Terminate for MATLABSystem: '<Root>/Taster 3' */
  if (!Labyrinth_DW.obj_p.matlabCodegenIsDeleted) {
    Labyrinth_DW.obj_p.matlabCodegenIsDeleted = true;
    if ((Labyrinth_DW.obj_p.isInitialized == 1L) &&
        Labyrinth_DW.obj_p.isSetupComplete) {
      Labyrinth_DW.obj_p.AnalogInDriverObj.MW_ANALOGIN_HANDLE =
        MW_AnalogIn_GetHandle(16UL);
      MW_AnalogIn_Close(Labyrinth_DW.obj_p.AnalogInDriverObj.MW_ANALOGIN_HANDLE);
    }
  }

  /* End of Terminate for MATLABSystem: '<Root>/Taster 3' */

  /* Terminate for MATLABSystem: '<Root>/Taster4' */
  if (!Labyrinth_DW.obj.matlabCodegenIsDeleted) {
    Labyrinth_DW.obj.matlabCodegenIsDeleted = true;
    if ((Labyrinth_DW.obj.isInitialized == 1L) &&
        Labyrinth_DW.obj.isSetupComplete) {
      Labyrinth_DW.obj.AnalogInDriverObj.MW_ANALOGIN_HANDLE =
        MW_AnalogIn_GetHandle(17UL);
      MW_AnalogIn_Close(Labyrinth_DW.obj.AnalogInDriverObj.MW_ANALOGIN_HANDLE);
    }
  }

  /* End of Terminate for MATLABSystem: '<Root>/Taster4' */

  /* Terminate for MATLABSystem: '<Root>/LED1blau' */
  if (!Labyrinth_DW.obj_n.matlabCodegenIsDeleted) {
    Labyrinth_DW.obj_n.matlabCodegenIsDeleted = true;
  }

  /* End of Terminate for MATLABSystem: '<Root>/LED1blau' */

  /* Terminate for MATLABSystem: '<Root>/LED1rot' */
  if (!Labyrinth_DW.obj_fk.matlabCodegenIsDeleted) {
    Labyrinth_DW.obj_fk.matlabCodegenIsDeleted = true;
  }

  /* End of Terminate for MATLABSystem: '<Root>/LED1rot' */

  /* Terminate for MATLABSystem: '<Root>/LED2gruen' */
  if (!Labyrinth_DW.obj_m.matlabCodegenIsDeleted) {
    Labyrinth_DW.obj_m.matlabCodegenIsDeleted = true;
  }

  /* End of Terminate for MATLABSystem: '<Root>/LED2gruen' */

  /* Terminate for MATLABSystem: '<Root>/LED2rot' */
  if (!Labyrinth_DW.obj_o.matlabCodegenIsDeleted) {
    Labyrinth_DW.obj_o.matlabCodegenIsDeleted = true;
  }

  /* End of Terminate for MATLABSystem: '<Root>/LED2rot' */

  /* Terminate for MATLABSystem: '<Root>/LED3rot' */
  if (!Labyrinth_DW.obj_f.matlabCodegenIsDeleted) {
    Labyrinth_DW.obj_f.matlabCodegenIsDeleted = true;
  }

  /* End of Terminate for MATLABSystem: '<Root>/LED3rot' */

  /* Terminate for MATLABSystem: '<Root>/LED4blau' */
  if (!Labyrinth_DW.obj_j.matlabCodegenIsDeleted) {
    Labyrinth_DW.obj_j.matlabCodegenIsDeleted = true;
    if ((Labyrinth_DW.obj_j.isInitialized == 1L) &&
        Labyrinth_DW.obj_j.isSetupComplete) {
      Labyrinth_DW.obj_j.PWMDriverObj.MW_PWM_HANDLE = MW_PWM_GetHandle(10UL);
      MW_PWM_SetDutyCycle(Labyrinth_DW.obj_j.PWMDriverObj.MW_PWM_HANDLE, 0.0);
      Labyrinth_DW.obj_j.PWMDriverObj.MW_PWM_HANDLE = MW_PWM_GetHandle(10UL);
      MW_PWM_Close(Labyrinth_DW.obj_j.PWMDriverObj.MW_PWM_HANDLE);
    }
  }

  /* End of Terminate for MATLABSystem: '<Root>/LED4blau' */

  /* Terminate for MATLABSystem: '<Root>/LED4rot' */
  if (!Labyrinth_DW.obj_d.matlabCodegenIsDeleted) {
    Labyrinth_DW.obj_d.matlabCodegenIsDeleted = true;
  }

  /* End of Terminate for MATLABSystem: '<Root>/LED4rot' */

  /* Terminate for MATLABSystem: '<Root>/LEED3gruen' */
  if (!Labyrinth_DW.obj_bs.matlabCodegenIsDeleted) {
    Labyrinth_DW.obj_bs.matlabCodegenIsDeleted = true;
    if ((Labyrinth_DW.obj_bs.isInitialized == 1L) &&
        Labyrinth_DW.obj_bs.isSetupComplete) {
      Labyrinth_DW.obj_bs.PWMDriverObj.MW_PWM_HANDLE = MW_PWM_GetHandle(9UL);
      MW_PWM_SetDutyCycle(Labyrinth_DW.obj_bs.PWMDriverObj.MW_PWM_HANDLE, 0.0);
      Labyrinth_DW.obj_bs.PWMDriverObj.MW_PWM_HANDLE = MW_PWM_GetHandle(9UL);
      MW_PWM_Close(Labyrinth_DW.obj_bs.PWMDriverObj.MW_PWM_HANDLE);
    }
  }

  /* End of Terminate for MATLABSystem: '<Root>/LEED3gruen' */
}

/*
 * File trailer for generated code.
 *
 * [EOF]
 */
