classdef Arduino_Mega_Hauptprogramm < matlab.System ...
        & coder.ExternalDependency ...
        & matlabshared.sensors.simulink.internal.BlockSampleTime

    % Per Arduino Code Interrupt, Display ausgabe, Berechnungen usw ausgeführt
    %#codegen
    %#ok<*EMCA>

    properties

    end

    properties(Access = protected)
        Logo = 'IO Device Builder';
    end

    properties (Nontunable)

    end

    properties (Access = private)


    end

    methods
        % Constructor
        function obj = Arduino_Mega_Hauptprogramm(varargin)
            setProperties(obj,nargin,varargin{:});
        end
    end

    methods (Access=protected)
        function setupImpl(obj)
            if ~coder.target('MATLAB')
                coder.cinclude('Arduino_Mega_Hauptprogramm.h');
                coder.ceval('setupFunctionArduino_Mega_Hauptprogramm');
            end
        end

        function validateInputsImpl(obj,varargin)
            %  Check the input size
            if nargin ~=0

                validateattributes(varargin{1},{'uint16'},{'2d','size',[1,1]},'','PotiOne');
                validateattributes(varargin{2},{'uint16'},{'2d','size',[1,1]},'','PotiTwo');
                validateattributes(varargin{3},{'uint16'},{'2d','size',[1,1]},'','PotiThree');

            end
        end

        function [RedOne,GreenOne,BlueOne,RedTwo,GreenTwo,BlueTwo,ServoWinkel] = stepImpl(obj ,PotiOne,PotiTwo,PotiThree)
            RedOne = uint16(zeros(1,1));
            GreenOne = uint16(zeros(1,1));
            BlueOne = uint16(zeros(1,1));
            RedTwo = uint16(zeros(1,1));
            GreenTwo = uint16(zeros(1,1));
            BlueTwo = uint16(zeros(1,1));
            ServoWinkel = uint16(zeros(1,1));
            if isempty(coder.target)
            else
                coder.ceval('stepFunctionArduino_Mega_Hauptprogramm',coder.ref(RedOne),1,coder.ref(GreenOne),1,coder.ref(BlueOne),1,coder.ref(RedTwo),1,coder.ref(GreenTwo),1,coder.ref(BlueTwo),1,coder.ref(ServoWinkel),1, PotiOne,1, PotiTwo,1, PotiThree,1);
            end
        end

        function releaseImpl(obj)
            if isempty(coder.target)
            else

            end
        end
    end

    methods (Access=protected)
        %% Define output properties
        function num = getNumInputsImpl(~)
            num = 3;
        end

        function num = getNumOutputsImpl(~)
            num = 7;
        end

        function varargout = getInputNamesImpl(obj)
            varargout{1} = 'PotiOne';
            varargout{2} = 'PotiTwo';
            varargout{3} = 'PotiThree';

        end

        function varargout = getOutputNamesImpl(obj)
            varargout{1} = 'RedOne';
            varargout{2} = 'GreenOne';
            varargout{3} = 'BlueOne';
            varargout{4} = 'RedTwo';
            varargout{5} = 'GreenTwo';
            varargout{6} = 'BlueTwo';
            varargout{7} = 'ServoWinkel';
        end

        function flag = isOutputSizeLockedImpl(~,~)
            flag = true;
        end

        function varargout = isOutputFixedSizeImpl(~,~)
            varargout{1} = true;
            varargout{2} = true;
            varargout{3} = true;
            varargout{4} = true;
            varargout{5} = true;
            varargout{6} = true;
            varargout{7} = true;
        end

        function varargout = isOutputComplexImpl(~)
            varargout{1} = false;
            varargout{2} = false;
            varargout{3} = false;
            varargout{4} = false;
            varargout{5} = false;
            varargout{6} = false;
            varargout{7} = false;
        end

        function varargout = getOutputSizeImpl(~)
            varargout{1} = [1,1];
            varargout{2} = [1,1];
            varargout{3} = [1,1];
            varargout{4} = [1,1];
            varargout{5} = [1,1];
            varargout{6} = [1,1];
            varargout{7} = [1,1];
        end

        function varargout = getOutputDataTypeImpl(~)
            varargout{1} = 'uint16';
            varargout{2} = 'uint16';
            varargout{3} = 'uint16';
            varargout{4} = 'uint16';
            varargout{5} = 'uint16';
            varargout{6} = 'uint16';
            varargout{7} = 'uint16';
        end

        function maskDisplayCmds = getMaskDisplayImpl(obj)
            outport_label = [];
            num = getNumOutputsImpl(obj);
            if num > 0
                outputs = cell(1,num);
                [outputs{1:num}] = getOutputNamesImpl(obj);
                for i = 1:num
                    outport_label = [outport_label 'port_label(''output'',' num2str(i) ',''' outputs{i} ''');' ]; %#ok<AGROW>
                end
            end
            inport_label = [];
            num = getNumInputsImpl(obj);
            if num > 0
                inputs = cell(1,num);
                [inputs{1:num}] = getInputNamesImpl(obj);
                for i = 1:num
                    inport_label = [inport_label 'port_label(''input'',' num2str(i) ',''' inputs{i} ''');' ]; %#ok<AGROW>
                end
            end
            icon = 'Arduino_Mega_Hauptprogramm';
            maskDisplayCmds = [ ...
                ['color(''white'');',...
                'plot([100,100,100,100]*1,[100,100,100,100]*1);',...
                'plot([100,100,100,100]*0,[100,100,100,100]*0);',...
                'color(''blue'');', ...
                ['text(38, 92, ','''',obj.Logo,'''',',''horizontalAlignment'', ''right'');',newline],...
                'color(''black'');'], ...
                ['text(52,50,' [''' ' icon ''',''horizontalAlignment'',''center'');' newline]]   ...
                inport_label ...
                outport_label
                ];
        end

        function sts = getSampleTimeImpl(obj)
            sts = getSampleTimeImpl@matlabshared.sensors.simulink.internal.BlockSampleTime(obj);
        end
    end

    methods (Static, Access=protected)
        function simMode = getSimulateUsingImpl(~)
            simMode = 'Interpreted execution';
        end

        function isVisible = showSimulateUsingImpl
            isVisible = false;
        end
    end

    methods (Static)
        function name = getDescriptiveName(~)
            name = 'Arduino_Mega_Hauptprogramm';
        end

        function tf = isSupportedContext(~)
            tf = true;
        end

        function updateBuildInfo(buildInfo, context)
            coder.extrinsic('codertarget.targethardware.getTargetHardware');
            hCS = coder.const(getActiveConfigSet(bdroot));
            targetInfo = coder.const(codertarget.targethardware.getTargetHardware(hCS));

            % Added this env variable to fetch the comm libraries required only for Arduino target.
            % The env variable is cleared at the end of
            % "GenerateWrapperMakefile.m" file.
            if contains(targetInfo.TargetName,'arduinotarget')
                setenv('Arduino_ML_Codegen_I2C', 'Y');
            end

            buildInfo.addIncludePaths('C:\Users\kumar\OneDrive\Desktop\Projekt_Relevant\HauptprogrammBibs');

            buildInfo.addIncludePaths('C:\Users\kumar\OneDrive\Desktop\Projekt_Relevant\HauptprogrammBibs');
            addSourceFiles(buildInfo,'Adafruit_NeoPixel.cpp','C:\Users\kumar\OneDrive\Desktop\Projekt_Relevant\HauptprogrammBibs');
            addSourceFiles(buildInfo,'DefaultFonts.c','C:\Users\kumar\OneDrive\Desktop\Projekt_Relevant\HauptprogrammBibs');
            addSourceFiles(buildInfo,'SSD1306Ascii.cpp','C:\Users\kumar\OneDrive\Desktop\Projekt_Relevant\HauptprogrammBibs');
            addSourceFiles(buildInfo,'TFT_22_ILI9225.cpp','C:\Users\kumar\OneDrive\Desktop\Projekt_Relevant\HauptprogrammBibs');
            addSourceFiles(buildInfo,'esp.c','C:\Users\kumar\OneDrive\Desktop\Projekt_Relevant\HauptprogrammBibs');
            addSourceFiles(buildInfo,'esp8266.c','C:\Users\kumar\OneDrive\Desktop\Projekt_Relevant\HauptprogrammBibs');
            addSourceFiles(buildInfo,'kendyte_k210.c','C:\Users\kumar\OneDrive\Desktop\Projekt_Relevant\HauptprogrammBibs');
            addSourceFiles(buildInfo,'Arduino_Mega_Hauptprogramm.cpp','C:\Users\kumar\OneDrive\Desktop\Projekt_Relevant\HauptprogrammBibs');

        end
    end
end
