/********************************************************************************************************
                        Fachpraktikum Mechatronik WS2024/25 

   Aufgabe       :       Hauptprogramm_Arduino_IDE_Basiert_v2.ino

   Betreuer      :       Marc Ebmeyer

   Autor         :       Anivesh Kumar && Marius Hoffknecht 

   Datum         :       Lippstadt,den 27.12.2024

   Letzte Änderung:       Lippstadt,den 27.12.2024

   Software       :       Arduino IDE 2.3.4

   Hardware       :       Arduino Mega 2560

   Anmerkung      :     **Potis müssen langsam gedreht werden damit die werte bei dem übergang von hohere stellige Zahl zu eine Niedriger Stellige Zahl auf dem kleinere OLED Displays nicht überschreibt
                        , Dieses Programm wird teilweise in eine Simulink Modell Verwendet
                        , Dieses Programm dient als eine zweite Lösung wenn der Anwender kein Matlab/Simulink auf ihrem Rechner hat**

   Quellen        :    TFT_22_ILI9225.h bibliothek von Nkawu -> https://github.com/Nkawu/TFT_22_ILI9225
                       SSD1306Ascii.h && SSD1306AsciiWire.h bibliotheken von Bill Greiman -> https://github.com/greiman/SSD1306Ascii
                       Adafruit_NeoPixel.h bibliothek von Adafruit -> https://github.com/adafruit/Adafruit_NeoPixel
                       Servo.h bibliothek von Arduino, Michael Margolis -> https://github.com/arduino-libraries/Servo

  Status          :     Fertig

 *******************************************************************************************************/


int BRIGHTNESS_u16 = 255; //helligkeit von rgb led streife

#include <Adafruit_NeoPixel.h> // einbindung Neopixel bibliothek
const int PIN_u16 = 9; // Pin für rgb led streife

const int NUMPIXELS_u16 = 8; // Max anzahl von rgb leds auf rgb led streife

Adafruit_NeoPixel pixels(NUMPIXELS_u16, PIN_u16, NEO_GRB + NEO_KHZ800); // objekt von rgb led streife

// Notwendige bibliotheken für alle displays

#include "SSD1306Ascii.h"
#include "SSD1306AsciiWire.h"
#include "SPI.h"
#include "TFT_22_ILI9225.h" 

// servo bibliothek und objekt

#include <Servo.h>
Servo Deckel; // servo objekt

// Servo pin anlegung

const int Servo_Pin_u16 = 10; // servo pin 

// oled displays objekte

SSD1306AsciiWire oled1;
SSD1306AsciiWire oled2;

// Pinbelegung von TFT display

const int TFT_RST = 28;
const int TFT_RS  = 22;
const int TFT_CS  = 36;  // SS
const int TFT_SDI = 51;  // MOSI
const int TFT_CLK = 52;  // SCK
const int TFT_LED = 0;   // 0 if wired to +5V directly



const int TFT_BRIGHTNESS = 200;   // display helligkeit auf 200 

TFT_22_ILI9225 tft = TFT_22_ILI9225(TFT_RST, TFT_RS, TFT_CS, TFT_LED, TFT_BRIGHTNESS); // TFT display objekt

// Pinbelegung und eingangswerte von Potis 1,2,3
const int Poti_1_u16 = A0; 
int Poti_1_Val_u16 = 0;

const int Poti_2_u16 = A1;
int Poti_2_Val_u16 = 0;

const int Poti_3_u16 = A2;
int Poti_3_Val_u16 = 0;

// Variable für Jede Abschnitt von Code 

volatile int Task_u16 = 0;

// Globale variablen für die Haupt Farben am RGB LEDs

int Rot_u16= 0;
int Gruen_u16 = 0;
int Blau_u16 = 0;


//int Text_Farbe = 0;

//Zusatzvariable für Displays zu Löschen

bool Clear_Display = 0;

// Setup Schleife

void setup() {
  
  pixels.begin(); //initialisierung von RGB LED streife 
  pixels.show();            // anzeige an alle einzelnen LEDs
  pixels.setBrightness(100); // Helligkeit einstellung 

  pinMode(2,INPUT_PULLUP); // taster an Pin 2 pinmode einstellung 
  attachInterrupt(digitalPinToInterrupt(2), Button_Reset, FALLING); // Reset button ISR einknupfen

  

  Wire.begin(); // I2C schnittstelle für OLED displays 
  Wire.setClock(400000L); //I2C clock einstellung 

  tft.begin(); //tft initialisieren

  oled1.begin(&Adafruit128x32, 0x3D); //OLED 1 einbindung an I2C adresse 0x3D
  oled2.begin(&Adafruit128x32, 0x3C); //OLED 2 einbindung an I2C adresse 0x3C
  oled1.setFont(System5x7); //Gleiche font einstellung für beide displays 
  oled2.setFont(System5x7);

  //TFT Text orientation
  tft.setOrientation(3);
  tft.setFont(Terminal12x16); // TFT font einstellung 

  Deckel.attach(Servo_Pin_u16); // einbindung von Servo objekt an servo pin 
}

// Loop schleife 

void loop() {
  
  Poti_1_Val_u16 = analogRead(Poti_1_u16); //Potiwerte ablesen
  BRIGHTNESS_u16 = map(Poti_1_Val_u16,0,1023,0,255); //Potiwerte an Helligkeit übergeben
  pixels.setBrightness(BRIGHTNESS_u16);  //RGB LED Streife helligkeit einstellen
  // Program ablaüfe gekennzeichnet mit Task_u16
  if (Task_u16 == 0) // bei 0 einführen 
  {
    Servo_geschlossen(); // Deckel geschlossen 
    Clear_Display = 1; // displays aufräumen
    tft.clear();
    oled1.clear();
    oled2.clear();
    Clear_Display = 0; //Gar nix mehr aufräumen
    //Strings für ausgang an Displays 
    String D1_1 = "Arduino Basierte";
    String D1_2 = "";
    String D1_3 = "";
    String D1_4 = "";
    String D1_5 = "Quiz Box";
    String D1_6 = "";
    String D1_7 = "";
    String D1_8 = "";
    String D2 = "LOS";
    String D3 = "GEHTS!!!";
    // Strings ausgang an TFT display 
    tft.drawText(5, 10, D1_1.c_str(), COLOR_BLUE);
    tft.drawText(5, 30, D1_2.c_str(), COLOR_BLUE);
    tft.drawText(5, 50, D1_3.c_str(), COLOR_BLUE);
    tft.drawText(5, 70, D1_4.c_str(), COLOR_BLUE);
    tft.drawText(5, 90, D1_5.c_str(), COLOR_BLUE);
    tft.drawText(5, 110, D1_6.c_str(), COLOR_BLUE);
    tft.drawText(5, 130, D1_7.c_str(), COLOR_BLUE);
    tft.drawText(5, 150, D1_8.c_str(), COLOR_BLUE);
    
    
    // Strings ausgang an OLED displays 
    oled1.setCursor(1,1);
    oled2.setCursor(1,1);
    oled1.print(D2);
    oled2.print(D3);
    // farbe an RGB LED PLATine und 2 RGB LEDs
    RGB_LED_PLATINE_Color_Set1(255, 20 , 146);
    RGB_LED_PLATINE_Color_Set2(255, 20 , 146);
    RGB_LED1(0, 255, 0);
    RGB_LED2(0, 255, 0);
    delay(5000); // 5s warten
    Clear_Display = 1; // displays aufräumen
    tft.clear();
    oled1.clear();
    oled2.clear();
    Task_u16++; // Program ablauf erhöhen
  }
  // Bei Program ablauf am 1 
  else if (Task_u16 == 1)
  {
    Clear_Display = 0; //Displays nicht aufräumen
    // strings für ausgang am displays  
    String D1_1 = "Raetsel 1: ";
    String D1_2 = "";
    String D1_3 = "fuer Rot";
    String D1_4 = "";
    String D1_5 = "250+5*e^x=y";
    String D1_6 = " ";
    String D1_7 = "Was ist y bei x=0";
    String D1_8 = " ";
    // ausgang am TFT
    tft.drawText(5, 10, D1_1.c_str(), COLOR_RED);
    tft.drawText(5, 30, D1_2.c_str(), COLOR_RED);
    tft.drawText(5, 50, D1_3.c_str(), COLOR_RED);
    tft.drawText(5, 70, D1_4.c_str(), COLOR_RED);
    tft.drawText(5, 90, D1_5.c_str(), COLOR_RED);
    tft.drawText(5, 110, D1_6.c_str(), COLOR_RED);
    tft.drawText(5, 130, D1_7.c_str(), COLOR_RED);
    tft.drawText(5, 150, D1_8.c_str(), COLOR_RED);
    //Potis werte ablesen
    Poti_2_Val_u16 = analogRead(Poti_2_u16);
    Poti_3_Val_u16 = analogRead(Poti_3_u16);
    Poti_2_Val_u16 = map(Poti_2_Val_u16,0,1023,0,256);
    Poti_3_Val_u16 = map(Poti_3_Val_u16,0,1023,0,256);
    // werte an RGB LED streife und 2 RGB leds übergeben 
    RGB_LED_PLATINE_Color_Set1(Poti_2_Val_u16, 0 , 0);
    RGB_LED_PLATINE_Color_Set2(Poti_3_Val_u16, 0 , 0);
    RGB_LED1(Poti_2_Val_u16, 0, 0);
    RGB_LED2(Poti_3_Val_u16, 0, 0);
    // strings und ausgang am OLED display 
    String D2 = String(Poti_2_Val_u16);
    String D3 = String(Poti_3_Val_u16);
    OLED1_Display_Output(Poti_2_Val_u16, D2);
    OLED2_Display_Output(Poti_3_Val_u16, D3);
    
    //Wenn Linke Player schneller ist 
    if (Poti_2_Val_u16 == 255)
    {
      Clear_Display = 0; // nicht aufräumen

      RGB_LED1(0, 255, 0); // grün
      RGB_LED2(255, 0, 0); // rot 
      Rot_u16 = Poti_2_Val_u16; //hauptfarbe speichern
      // Farbe an RGB LED streife 
      RGB_LED_PLATINE_Color_Set1(Rot_u16, 0 , 0);
      RGB_LED_PLATINE_Color_Set2(Rot_u16, 0 , 0);
      Clear_Display = 1; // dislpay aufräumen
      tft.clear();
      oled1.clear();
      oled2.clear();
      delay(1000); //1s delay 
      Task_u16++; //program ablauf erhöhen
    }
    // Wenn Rechte player Schneller ist 
    else if (Poti_3_Val_u16 == 255)
    {
      Clear_Display = 0; //Nicht aufräumen
      RGB_LED2(0, 255, 0); //Grün
      RGB_LED1(255, 0, 0); //Rot 
      Rot_u16 = Poti_3_Val_u16; //Hauptfarbe speichern
      //Farbe an RGBLED Streife übergeben
      RGB_LED_PLATINE_Color_Set1(Rot_u16, 0 , 0);
      RGB_LED_PLATINE_Color_Set2(Rot_u16, 0 , 0);
      Clear_Display = 1; //Aufräumen
      tft.clear();
      oled1.clear();
      oled2.clear();
      delay(1000); //1s delay 
      Task_u16++; //Task erhöhen
    }


  }
  else if (Task_u16 == 2) //Wenn Program ablauf auf 2 ist 
  {

    Clear_Display = 0; //Nicht aufräumen
    //TFT relevante strings und ausgang
    String D1_1 = "Raetsel 2: "; 
    String D1_2 = "";
    String D1_3 = "fuer Gruen";
    String D1_4 = "";
    String D1_5 = "(34+56+20+12+45+3)";
    String D1_6 = "/2 = x";
    String D1_7 = "";
    String D1_8 = "Was ist x ?";
    tft.drawText(5, 10, D1_1.c_str(), COLOR_GREEN);
    tft.drawText(5, 30, D1_2.c_str(), COLOR_GREEN);
    tft.drawText(5, 50, D1_3.c_str(), COLOR_GREEN);
    tft.drawText(5, 70, D1_4.c_str(), COLOR_GREEN);
    tft.drawText(5, 90, D1_5.c_str(), COLOR_GREEN);
    tft.drawText(5, 110, D1_6.c_str(), COLOR_GREEN);
    tft.drawText(5, 130, D1_7.c_str(), COLOR_GREEN);
    tft.drawText(5, 150, D1_8.c_str(), COLOR_GREEN);
    //Potis und Die werte ablesen und Mappen
    Poti_2_Val_u16 = analogRead(Poti_2_u16);
    Poti_3_Val_u16 = analogRead(Poti_3_u16);
    Poti_2_Val_u16 = map(Poti_2_Val_u16,0,1023,0,256);
    Poti_3_Val_u16 = map(Poti_3_Val_u16,0,1023,0,256);
    //Werte an RGB LED Streife und LEDS übertragen 
    RGB_LED_PLATINE_Color_Set1(Rot_u16, Poti_2_Val_u16 , 0);
    RGB_LED_PLATINE_Color_Set2(Rot_u16, Poti_3_Val_u16 , 0);
    RGB_LED1(0, Poti_2_Val_u16, 0);
    RGB_LED2(0, Poti_3_Val_u16, 0);
    // Strings und ausgabe an OLED displays 
    String D2 = String(Poti_2_Val_u16);
    String D3 = String(Poti_3_Val_u16);
    OLED1_Display_Output(Poti_2_Val_u16, D2);
    OLED2_Display_Output(Poti_3_Val_u16, D3);
    // wenn Player 1 schneller ist 
    if (Poti_2_Val_u16 == 20)
    {
      Clear_Display = 0; //Nicht aufräumen
      RGB_LED1(0, 255, 0); //grün
      RGB_LED2(255, 0, 0); //rot 
      Gruen_u16 = Poti_2_Val_u16; //Hauptfarbe speichern und an RGBLED streife übergeben
      RGB_LED_PLATINE_Color_Set1(Rot_u16, Gruen_u16 , 0); 
      RGB_LED_PLATINE_Color_Set2(Rot_u16, Gruen_u16 , 0);
      Clear_Display = 1; //Display aufräumen 
      tft.clear();
      oled1.clear();
      oled2.clear();
      delay(1000); //1s warten 
      Task_u16++; //Task erhöhen
    }
    // wenn Palyer 2 schneller ist 
    else if (Poti_3_Val_u16 == 20)
    {
      Clear_Display = 0; //Nicht aufräumen
      RGB_LED2(0, 255, 0); //grün 
      RGB_LED1(255, 0, 0); //rot 
      Gruen_u16 = Poti_3_Val_u16; //haupt farbe speichern und an RGB LED sTreife übergeben
      RGB_LED_PLATINE_Color_Set1(Rot_u16, Gruen_u16 , 0);
      RGB_LED_PLATINE_Color_Set2(Rot_u16, Gruen_u16 , 0);
      Clear_Display = 1; //Display aufräumen
      tft.clear();
      oled1.clear();
      oled2.clear(); 
      delay(1000); //delay 1s
      Task_u16++; //task erhöhen 
    }

  }
  // Wenn Programm ablauf 3 ist 
  else if (Task_u16 == 3)
  {
    
    Clear_Display = 0; //Display nicht aufräumen
    //TFT relevante Strings und Ausgabe
    String D1_1 = "Raetsel 3: ";
    String D1_2 = "";
    String D1_3 = "fuer Blau";
    String D1_4 = "";
    String D1_5 = "100 + x/2 =196";
    String D1_6 = " ";
    String D1_7 = " Was ist x ";
    String D1_8 = " ";
    tft.drawText(5, 10, D1_1.c_str(), COLOR_BLUE);
    tft.drawText(5, 30, D1_2.c_str(), COLOR_BLUE);
    tft.drawText(5, 50, D1_3.c_str(), COLOR_BLUE);
    tft.drawText(5, 70, D1_4.c_str(), COLOR_BLUE);
    tft.drawText(5, 90, D1_5.c_str(), COLOR_BLUE);
    tft.drawText(5, 110, D1_6.c_str(), COLOR_BLUE);
    tft.drawText(5, 130, D1_7.c_str(), COLOR_BLUE);
    tft.drawText(5, 150, D1_8.c_str(), COLOR_BLUE);
    // Poti_Werte ablesen speichern und mappen und an RGB LED Streife und an RGB LEDs übergeben
    Poti_2_Val_u16 = analogRead(Poti_2_u16);
    Poti_3_Val_u16 = analogRead(Poti_3_u16);
    Poti_2_Val_u16 = map(Poti_2_Val_u16,0,1023,0,256);
    Poti_3_Val_u16 = map(Poti_3_Val_u16,0,1023,0,256);
    RGB_LED_PLATINE_Color_Set1(Rot_u16, Gruen_u16 , Poti_2_Val_u16);
    RGB_LED_PLATINE_Color_Set2(Rot_u16, Gruen_u16 , Poti_3_Val_u16);
    RGB_LED1(0, 0, Poti_2_Val_u16);
    RGB_LED2(0, 0, Poti_3_Val_u16);
    //OLED Displays relevante Strings und Ausgabe
    String D2 = String(Poti_2_Val_u16);
    String D3 = String(Poti_3_Val_u16);
    OLED1_Display_Output(Poti_2_Val_u16, D2);
    OLED2_Display_Output(Poti_3_Val_u16, D3);
  // Wenn Player 1 schneller ist 
    if (Poti_2_Val_u16 == 146)
        {
          Clear_Display = 0; //Nicht aufräumen
          RGB_LED1(0, 255, 0); //grün
          RGB_LED2(255, 0, 0); //rot
          Blau_u16 = Poti_2_Val_u16; //Hauptfarbe speichern und an RGB LED streife übergeben
          RGB_LED_PLATINE_Color_Set1(Rot_u16, Gruen_u16 , Blau_u16);
          RGB_LED_PLATINE_Color_Set2(Rot_u16, Gruen_u16 , Blau_u16);
          Clear_Display = 1; //Displays aufräumen
          tft.clear();
          oled1.clear();
          oled2.clear();
          delay(1000); //1s delay 
          Task_u16++; //Task erhöhen
        }
        // Wenn Player 2 schneller ist 
        else if (Poti_3_Val_u16 == 146)
        {
          Clear_Display = 0; //Nicht aufräumen
          RGB_LED2(0, 255, 0); //grün
          RGB_LED1(255, 0, 0); //rot 
          Blau_u16 = Poti_3_Val_u16; // Haupt farbe speichern und an RGB LED streife übergeben
          RGB_LED_PLATINE_Color_Set1(Rot_u16, Gruen_u16 , Blau_u16);
          RGB_LED_PLATINE_Color_Set2(Rot_u16, Gruen_u16 , Blau_u16);
          Clear_Display = 1; //Display aufräumen 
          tft.clear();
          oled1.clear();
          oled2.clear();
          delay(1000); // 1s delay 
          Task_u16++; //Task erhöhen
        }


  }
  // Wenn Programm Ablauf 4 ist 
  else if (Task_u16 == 4)
  {

    Clear_Display = 0; //nicht aufräumen
    // TFT Relevante Strings und Ausgabe  
    String D1_1 = "Farbkombination: ";
    String D1_2 = "";
    String D1_3 = "Rot: 255";
    String D1_4 = "";
    String D1_5 = "Gruen: 20";
    String D1_6 = " ";
    String D1_7 = " Blau: 146";
    String D1_8 = " ";
    tft.drawText(5, 10, D1_1.c_str(), COLOR_BLUE);
    tft.drawText(5, 30, D1_2.c_str(), COLOR_BLUE);
    tft.drawText(5, 50, D1_3.c_str(), COLOR_BLUE);
    tft.drawText(5, 70, D1_4.c_str(), COLOR_BLUE);
    tft.drawText(5, 90, D1_5.c_str(), COLOR_BLUE);
    tft.drawText(5, 110, D1_6.c_str(), COLOR_BLUE);
    tft.drawText(5, 130, D1_7.c_str(), COLOR_BLUE);
    tft.drawText(5, 150, D1_8.c_str(), COLOR_BLUE);
    //OLED Display relevante Strings und Ausgabe
    String D2 = "SERVO WIRD";
    String D3 = "GEOEFFNET";
    OLED1_Display_Output(0, D2);
    OLED2_Display_Output(0, D3);

    

    Servo_offen(); //Deckel Öffnen
    delay(15000); //15s delay 
    Servo_geschlossen(); //Deckel schließen
    Clear_Display = 1; //Displays aufräumen
    tft.clear();
    oled1.clear();
    oled2.clear();
    Task_u16 = 0; //Programm Ablauf auf 0 setzen

  }

  

}


// Funktion für RGBLED streife für player 1
void RGB_LED_PLATINE_Color_Set1(int R, int G, int B) 
  {
    for(int i = 0; i<4; i++) // for loop
  {
    
    pixels.setPixelColor(i, pixels.Color(R, G, B)); // jede einzelne led mit farbe setzen
    pixels.show(); // led mit farbe anzeigen 
  }
  }
// Funktion für RGBLED streife für player 2
void RGB_LED_PLATINE_Color_Set2(int r, int g, int b) 
  {
    for(int j = 4; j<8; j++) // for loop 
  {
    
    pixels.setPixelColor(j, pixels.Color(r, g, b)); // jede einzelne led mit farbe setzen 
    pixels.show(); // led mit farbe anzeigen 
  }
  }

// Funktion für die Farbeinstellung von RGB LED 1
void RGB_LED1(int R, int G, int B) 
{
  analogWrite(3,R); // ausgang an pin 3
  analogWrite(4,G); // ausgang an pin 4
  analogWrite(5,B); // ausgang an pin 5
}
// Funktion für die Farbeinstellung von RGB LED 2 
void RGB_LED2(int r, int g, int b)
{
  analogWrite(6,r); // ausgang an pin 6 
  analogWrite(7,g); // ausgang an pin 7
  analogWrite(8,b); // ausgang an pin 8
}

// Funktion für die Schlauer Säuberung von OLED Display 1 
void OLED1_Display_Output(int x, String y)
{
 oled1.setCursor(2,1); //Cursor punkt einstellen
  if(x == 9 || x == 10 || x == 99|| x == 100|| x == 999 || x == 1000) //Wenn diese werte trifft 
  { 

    oled1.print(y); //String anzeigen
    oled1.clear(); //Display aufräumen
  }
  else // sonst
  {
  oled1.print(y); //String anzeigen
  }
}
// Funktion für die Schlauer Säuberung von OLED Display 2
void OLED2_Display_Output(int x, String y)
{
 oled2.setCursor(2,1); // Cursor punkt einstellen
  if(x == 9 || x == 10 || x == 99|| x == 100|| x == 999 || x == 1000) // Wenn diese Werte Trifft
  {
    oled2.print(y); // String anzeigen
    oled2.clear(); //Display aufräumen
  }
  else // Sonst
  {
  oled2.print(y); //String anzeigen
  }
}

// Funktion für die Deckel zu Öffnen
void Servo_offen()
{
  Deckel.write(0); // servo winkel 0 grad
}

// Funktion für die Deckel zu Schließen
void Servo_geschlossen()
{
  Deckel.write(90); // servo winkel 90 grad 
}

void Button_Reset()  // Reset Button ISR
{
  Task_u16 = 0; // Programm ablauf auf 0 setzen
}

