/********************************************************************************************************
                        Fachpraktikum Mechatronik WS2024/25 

   Aufgabe       :       Hauptprogramm_Arduino_IDE_Basiert.ino

   Betreuer      :       Marc Ebmeyer

   Autor         :       Anivesh Kumar && Marius Hoffknecht 

   Datum         :       Lippstadt,den 15.12.2024

   Letzte Änderung:       Lippstadt,den 16.12.2024

   Anmerkung      :     **Potis müssen langsam gedreht werden damit die werte bei dem übergang von hohere stellige Zahl zu eine Niedriger Stellige Zahl auf dem kleinere OLED Displays nicht überschreibt
                        , Dieses Programm wird teilweise in eine Simulink Modell Verwendet
                        , Dieses Programm dient als eine zweite Lösung wenn der Anwender kein Matlab/Simulink auf ihrem Rechner hat**

   Quellen        :    TFT_22_ILI9225.h bibliothek von Nkawu -> https://github.com/Nkawu/TFT_22_ILI9225
                       SSD1306Ascii.h && SSD1306AsciiWire.h bibliotheken von Bill Greiman -> https://github.com/greiman/SSD1306Ascii
                       FastLED_NeoPixel.h bibliothek von David Madison -> https://github.com/dmadison/FastLED_NeoPixel

  Status          :     in Bearbeitung

 *******************************************************************************************************/

#include <FastLED_NeoPixel.h>
const int DATA_PIN = 9;
const int NUM_LEDS = 8; // (0-29)
int BRIGHTNESS = 255; //0-255



#include "SSD1306Ascii.h"
#include "SSD1306AsciiWire.h"
#include "SPI.h"
#include "TFT_22_ILI9225.h" 

SSD1306AsciiWire oled1;
SSD1306AsciiWire oled2;

const int TFT_RST = 28;
const int TFT_RS  = 22;
const int TFT_CS  = 36;  // SS
const int TFT_SDI = 51;  // MOSI
const int TFT_CLK = 52;  // SCK
const int TFT_LED = 0;   // 0 if wired to +5V directly

const int TFT_BRIGHTNESS = 200;   // 0 if wired to +5V directly

TFT_22_ILI9225 tft = TFT_22_ILI9225(TFT_RST, TFT_RS, TFT_CS, TFT_LED, TFT_BRIGHTNESS);
FastLED_NeoPixel<NUM_LEDS, DATA_PIN, NEO_GRB> RGB_LED_Platine;

const int Poti_1 = A0;
int Poti_1_Val = 0;

const int Poti_2 = A1;
int Poti_2_Val = 0;

const int Poti_3 = A2;
int Poti_3_Val = 0;

float Task = 0;

int Rot= 0;
int Gruen = 0;
int Blau = 0;

bool Clear_Display = 0;

void setup() {
  // put your setup code here, to run once:

  RGB_LED_Platine.begin();
  RGB_LED_Platine.setBrightness(BRIGHTNESS);

  Wire.begin();
  Wire.setClock(400000L);

  tft.begin();

  oled1.begin(&Adafruit128x32, 0x3D);
  oled2.begin(&Adafruit128x32, 0x3C);
  oled1.setFont(System5x7);
  oled2.setFont(System5x7);

  tft.setOrientation(3);
  tft.setFont(Terminal12x16);
}

void loop() {
  // put your main code here, to run repeatedly:
  /*Poti_2_Val = analogRead(Poti_2);
  Poti_3_Val = analogRead(Poti_3);
  int R1 = map(Poti_2_Val,0,1023,0,255); 
  int G1 = map(Poti_3_Val,0,1023,0,255);

  for(int i = 0; i<NUM_LEDS; i++)
  {
    RGB_LED_Platine.setPixelColor(i, RGB_LED_Platine.Color(R1, G1, 0));  // set pixel 0 to blue
	  RGB_LED_Platine.show();
  }*/
  Poti_1_Val = analogRead(Poti_1);
  BRIGHTNESS = map(Poti_1_Val,0,1023,0,255);
  RGB_LED_Platine.setBrightness(BRIGHTNESS);

  if (Task == 0)
  {
    Clear_Display = 0; //For Simulink display io blocks 
    String D1_1 = "Arduino Basierte";
    String D1_2 = "Quiz Box";
    String D1_3 = " ";
    String D1_4 = " ";
    String D2 = "LOS";
    String D3 = "GEHTS!!!";
    tft.drawText(10, 10, D1_1.c_str(), COLOR_BLUE);
    tft.drawText(10, 50, D1_2.c_str(), COLOR_BLUE);
    tft.drawText(10, 90, D1_3.c_str(), COLOR_BLUE);
    tft.drawText(10, 110, D1_4.c_str(), COLOR_BLUE);
    oled1.setCursor(1,1);
    oled2.setCursor(1,1);
    oled1.print(D2);
    oled2.print(D3);
    RGB_LED_PLATINE_Color_Set1(255, 20 , 146);
    RGB_LED_PLATINE_Color_Set2(255, 20 , 146);
    RGB_LED1(0, 255, 0);
    RGB_LED2(0, 255, 0);
    delay(5000);
    Clear_Display = 1; //For Simulink display io blocks 
    tft.clear();
    oled1.clear();
    oled2.clear();
    Task = 0.1;
  }
  else if (Task == 0.1)
  {
    Clear_Display = 0; //For Simulink display io blocks 
    String D1_1 = "Arduino Basierte";
    String D1_2 = "Quiz Box";
    String D1_3 = "";
    String D1_4 = "";
    String D2 = "LOS";
    String D3 = "GEHTS!!!";
    tft.drawText(10, 10, D1_1.c_str(), COLOR_BLUE);
    tft.drawText(10, 50, D1_2.c_str(), COLOR_BLUE);
    tft.drawText(10, 90, D1_3.c_str(), COLOR_BLUE);
    tft.drawText(10, 110, D1_4.c_str(), COLOR_BLUE);
    oled1.setCursor(2,1);
    oled2.setCursor(2,1);
    oled1.print(D2);
    oled2.print(D3);
    RGB_LED_PLATINE_Color_Set1(0, 0 , 0);
    RGB_LED_PLATINE_Color_Set2(0, 0 , 0);
    RGB_LED1(0, 0, 0);
    RGB_LED2(0, 0, 0);
    delay(5000);
    Clear_Display = 1; //For Simulink display io blocks 
    tft.clear();
    oled1.clear();
    oled2.clear();
    Task = 1;
  }
  else if (Task == 1)
  {
    Clear_Display = 0; //For Simulink display io blocks 
    String D1_1 = "Raetsel 1: ";
    String D1_2 = "fuer Rot";
    String D1_3 = "250+5*e^x=y";
    String D1_4 = "was ist y";
    tft.drawText(10, 10, D1_1.c_str(), COLOR_BLUE);
    tft.drawText(10, 50, D1_2.c_str(), COLOR_BLUE);
    tft.drawText(10, 90, D1_3.c_str(), COLOR_BLUE);
    tft.drawText(10, 110, D1_4.c_str(), COLOR_BLUE);
    Poti_2_Val = analogRead(Poti_2);
    Poti_3_Val = analogRead(Poti_3);
    Poti_2_Val = map(Poti_2_Val,0,1023,0,256);
    Poti_3_Val = map(Poti_3_Val,0,1023,0,256);
    RGB_LED_PLATINE_Color_Set1(Poti_2_Val, 0 , 0);
    RGB_LED_PLATINE_Color_Set2(Poti_3_Val, 0 , 0);
    String D2 = String(Poti_2_Val);
    String D3 = String(Poti_3_Val);
    OLED1_Display_Output(Poti_2_Val, D2);
    OLED2_Display_Output(Poti_3_Val, D3);
    if (Poti_2_Val == 255)
    {
      Clear_Display = 0; //For Simulink display io blocks 
      RGB_LED1(0, 255, 0);
      RGB_LED2(255, 0, 0);
      Rot = Poti_2_Val;
      RGB_LED_PLATINE_Color_Set1(Rot, 0 , 0);
      RGB_LED_PLATINE_Color_Set2(Rot, 0 , 0);
      Clear_Display = 1; //For Simulink display io blocks 
      Task = 2;
    }
    else if (Poti_3_Val == 255)
    {
      Clear_Display = 0; //For Simulink display io blocks 
      RGB_LED2(0, 255, 0);
      RGB_LED1(255, 0, 0);
      Rot = Poti_3_Val;
      Clear_Display = 1; //For Simulink display io blocks 
      Task = 2;
    }


  }

  

}

void RGB_LED_PLATINE_Color_Set1(int R, int G , int B)
  {
    for(int i = 0; i<4; i++)
  {
    RGB_LED_Platine.setPixelColor(i, RGB_LED_Platine.Color(R, G, B));  // set pixel 0 to blue
	  RGB_LED_Platine.show();
  }
  }

void RGB_LED_PLATINE_Color_Set2(int R, int G , int B)
  {
    for(int i = 4; i<8; i++)
  {
    RGB_LED_Platine.setPixelColor(i, RGB_LED_Platine.Color(R, G, B));  // set pixel 0 to blue
	  RGB_LED_Platine.show();
  }
  }

void RGB_LED1(int R, int G, int B)
{
  analogWrite(3,R);
  analogWrite(4,G);
  analogWrite(5,B);
}

void RGB_LED2(int r, int g, int b)
{
  analogWrite(6,r);
  analogWrite(7,g);
  analogWrite(8,b);
}

void OLED1_Display_Output(int x, String y)
{
 oled1.setCursor(2,1);
  if(x == 9 || x == 10 || x == 99|| x == 100|| x == 999 || x == 1000)
  { 

    oled1.print(y);
    oled1.clear();
  }
  else
  {
  oled1.print(y);
  }
}
void OLED2_Display_Output(int x, String y)
{
 oled2.setCursor(2,1);
  if(x == 9 || x == 10 || x == 99|| x == 100|| x == 999 || x == 1000)
  {
    oled2.print(y);
    oled2.clear();
  }
  else
  {
  oled2.print(y);
  }
}
