% parameter_EEZ initialisiert alle benötigten Parameter für das Modul EEZ
% ***********************************************************\
%
% Modul : parameter_EEZ.m
%
% Datum : 15. Mai 20233
%
% Implementierung : MATLAB R2022a
%
% Toolbox : -
%
% Autor : Daniel Gosedopp & Junjie Lyu
%
% Bemerkung : Code-Review noch ausstehend
%
% Letzte ¨Anderung : 15. Mai 2023
%
%************************************************************/

%% Allgemein
% Wirkungsgrad der Anlage je nach Neigungswinkel und Ausrichtung
% Ausrichtung Süden
PAR_EEZ_NeigungswinkelS_f64 = [0 45 90];
PAR_EEZ_NeigungsfaktorS_f64 = [0.9 1 0.7];

% Ausrichtung Osten oder Westen
PAR_EEZ_NeigungswinkelWO_f64 = [0 45 90];
PAR_EEZ_NeigungsfaktorWO_f64 = [0.9 0.75 0.5];


%% Sonnenstrahlung
% Vektoren, um vom Tag im Jahr auf den Monat zu schließen (Tag 1-31 ist
% Januar (1), Tag 32-59 ist Februar (2) usw.)
PAR_EEZ_Monatstage = [1, 31, 32, 59, 60, 90, 91, 120, 121, 151, 152, 181, 182, 212, 213, 243, 244, 273, 274, 304, 305, 334, 335, 365];
PAR_EEZ_Monat = [1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12];

% Vektor für Stunden 0 - 23
PAR_EEZ_Stunden = [0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23];

% Vektor für Monate Januar bis Dezember
PAR_EEZ_Monate = [1;2;3;4;5;6;7;8;9;10;11;12];

% Strahlungsdaten in Lippstadt für jeden Monat (Spalten) und jede Stunde
% (Zeilen)
PAR_EEZ_StrahlungLippstadt = [0 0 0 0 0 0 0 0 0 0 0 0;
               0 0 0 0 0 0 0 0 0 0 0 0;
               0 0 0 0 0 0 0 0 0 0 0 0;
               0 0 0 0 0 0 0 0 0 0 0 0;
               0 0 0 0 0 5 0 0 0 0 0 0;
               0 0 0 0 66 107 72 0 0 0 0 0;
               0 0 0 91 181 183 160 127 19 0 0 0;
               0 0 61 227 252 238 221 217 172 52 0 0;
               0 63 214 293 310 294 281 279 250 195 42 0;
               116 205 261 333 339 332 317 327 288 243 157 97;
               162 227 287 348 353 357 334 330 295 257 185 149;
               181 246 298 351 352 356 330 335 301 268 204 169;
               191 259 315 353 353 347 330 336 308 282 203 179;
               188 265 321 352 339 336 317 326 290 264 191 164;
               162 243 283 326 316 321 303 300 268 232 164 135;
               122 210 252 293 301 307 285 272 241 197 114 67;
               22 145 231 265 273 283 260 250 214 127 3 0;
               0 2 138 221 229 244 224 210 135 3 0 0;
               0 0 1 109 170 202 179 140 5 0 0 0;
               0 0 0 0 53 117 101 12 0 0 0 0;
               0 0 0 0 0 10 2 0 0 0 0 0;
               0 0 0 0 0 0 0 0 0 0 0 0;
               0 0 0 0 0 0 0 0 0 0 0 0;
               0 0 0 0 0 0 0 0 0 0 0 0];



%% Photovoltaik
PAR_EEZ_PVWirkungsgrad_f64 = 0.19;
PAR_EEZ_PVModullaenge_f64 = 1.68; % [m] Standardgröße
PAR_EEZ_PVModulbreite_f64 = 0.99; % [m] Standardgröße
% süden
PAR_EEZ_PVNeigungswinkel_S = 45; %[°]
PAR_EEZ_PVAnzahlModule_S = 27;
% westen
PAR_EEZ_PVNeigungswinkel_W = 45; %[°]
PAR_EEZ_PVAnzahlModule_W = 0;
% osten
PAR_EEZ_PVNeigungswinkel_O = 45; %[°]
PAR_EEZ_PVAnzahlModule_O = 0;


%% Warmwasserkollektor
% HP 30 :
% https://www.wolf-online-shop.de/Vakkum-Roehrenkollektor-Heatpipe-Typ-HP30-mit-30-Roehren::309993.html 
PAR_EEZ_WWKNeigungswinkel_f64 = 45; % 15° ~ 50°
PAR_EEZ_WWKAnzahlModule_f64 = 1; % geeigenet für 4-5 Personen
PAR_EEZ_WWKModullaenge_f64 = 2.455; % [m]
PAR_EEZ_WWKModulbreite_f64 = 1.99; % [m] Absorberfläche: 3.68 m^2
PAR_EEZ_WWKTransmissionskoefffizient_f64 = 0.8; % < 0.8
PAR_EEZ_WWKAbsorptionskoeffizient_f64 = 0.94; % > 0.94


%% Wechselrichter
PAR_EEZ_DCACWirkungsgrad = 0.95; % der europäische Wirkungsgrad

