clear all; close all; clc; % Initialisierung
%****************************************************************
%                   Hochschule Hamm-Lippstadt                   *
%****************************************************************
% Modul	          : ky040_auslesen.m                            *
%                                                               *
% Datum           : 10.11.2025                                  *
%                                                               *
% Funktion        : Auslesen der CLK und DT Pins des KY-040     *
%                   Drehgeber Moduls, um damit ein Simulink-    *
%                   Modell erstellen zu können                  *           
%                                                               *
% Implementation  : MATLAB 2024b                                *
%                                                               *
% Req. Toolbox    : MATLAB Support Package for Arduino Hardware *
%                                                               *
% Author          : Kilian Engelhardt, Daniel Block             *
%                                                               *
% Bemerkung       :                                             *
%                                                               *
% Notw. Dateien   :                                             *
%                                                               *
% Letzte Änderung : 10-Nov-2025                                 *
%                                                               *
%***************************************************************/
%% Initialisierung der Objekte + Variablen
% Überprüfung, ob das Arduino-Objekt bereits existiert
if exist('arduinoObj') == 0
    % Arduino-Objekt erstellen falls es nicht existiert
    arduinoObj = arduino("COM6", "Mega2560");
end

%% Messschleife
figure; hold on
tic                         % Start der Zeitmessung
for i = 1:500
    t(i) = toc;
    CLK(i) = readDigitalPin(arduinoObj,'D22');
    DT(i) = readDigitalPin(arduinoObj,'D23');
    plot(t,CLK);
    plot(t,DT);
end

save("ky040_uhrzeigersinn", "CLK", "DT", "t")
%save("ky040_gegenuhrzeigersinn", "CLK", "DT", "t")

