clear; close all; clc
%**************************************************************************
%                   Hochschule Hamm-Lippstadt                             *
%**************************************************************************
% Modul	          : K_Faktor_Bestimmung.m                                 *
%                                                                         *
% Datum           : 01.01.2026                                            *
%                                                                         *
% Funktion        : Dieses Skript berechnet den K-Faktor für die          *  
%                   Übertragungsfunktion des Kugel-Balancierers basierend *
%                   auf der Sprungantwort                                 *
%                                                                         *
% Implementation  : Matlab R2024b                                         *
%                                                                         *
% Toolbox         :                                                       *
%                                                                         *
% Author          : Kilian Engelhardt, Daniel Block                       *
%                                                                         *
% Bemerkung       :                                                       *
%                                                                         *
% Letzte Änderung : 01 Jan 2026                                           *
%                                                                         *
%**************************************************************************
% Laden der Messdaten
load("Regelstrecke_10.mat")

% Zeit- und Positionsdaten aus dem timeseries-Objekt extrahieren
t_raw = Regelstrecke_10.Time;
x_raw = Regelstrecke_10.Data;

% Den relevanten Zeitraum isolieren (Bereich, in dem die Kugel rollt)
index = find(t_raw >= 10 & t_raw <= 11.36);
t_crop = t_raw(index);
x_crop = x_raw(index);

% Daten normieren: Zeit und Weg bei 0 starten lassen
t_fit = t_crop - t_crop(1); 
x_fit = x_crop - x_crop(1);

% Mathematische Modellbildung: Polynom 2. Grades an die Messdaten fitten (Parabel)
% p(1) ist der Koeffizient vor t^2, p(2) vor t, p(3) ist die Konstante
p = polyfit(t_fit, x_fit, 2);

% Physikalische Beschleunigung berechnen (Umkehrung von s = 1/2 * a * t^2)
a_messung = 2 * p(1);

% Rekonstruktion der Kurve basierend auf dem Fit für den grafischen Vergleich
x_rekonstruiert = polyval(p, t_fit);

% Ergebnissdarstellung
figure;
plot(t_fit, x_fit, 'bo', 'DisplayName', 'Messdaten'); hold on; % Originaldaten als Punkte
plot(t_fit, x_rekonstruiert, 'r-', 'LineWidth', 2, 'DisplayName', 'Parabel-Fit'); % Fit als Linie
xlabel('Zeit [s]');
ylabel('Weg [cm]');
legend;
title(['Beschleunigung a = ', num2str(a_messung), ' cm/s^2']);

% Berechnung der Streckenverstärkung K für die Regelstrecke
winkel_deg = 10; % Eingestellter Sprungwinkel in Grad
winkel_rad = winkel_deg * (pi/180); % Umrechnung in Radiant für die Übertragungsfunktion

% Bestimmung des K-Faktors
K_identifiziert = a_messung / winkel_rad;