clear all; close all; clc; % Initialisierung
%****************************************************************
%                   Hochschule Hamm-Lippstadt                   *
%****************************************************************
% Modul	          : IR_auslesen.m                               *
%                                                               *
% Datum           : 10.11.2025                                  *
%                                                               *
% Funktion        : Auslesen der Ausgangsspannung des           *
%                   Sharp GP2Y0A41SK0F IR Sensors               *           
%                                                               *
% Implementation  : MATLAB 2024b                                *
%                                                               *
% Req. Toolbox    : MATLAB Support Package for Arduino Hardware *
%                                                               *
% Author          : Kilian Engelhardt, Daniel Block             *
%                                                               *
% Bemerkung       :                                             *
%                                                               *
% Notw. Dateien   :                                             *
%                                                               *
% Letzte Änderung : 10-Nov-2025                                 *
%                                                               *
%***************************************************************/
%% Initialisierung der Objekte + Variablen
% Überprüfung, ob das Arduino-Objekt bereits existiert
if exist('arduinoObj') == 0
    % Arduino-Objekt erstellen falls es nicht existiert
    arduinoObj = arduino("COM5", "Mega2560");
end

%% Messschleife
figure; hold on
tic                         % Start der Zeitmessung
for i = 1:10000
    t(i) = toc;
    ir_out(i) = readVoltage(arduinoObj, "A0");
    plot(t,ir_out);
end

save("IR_out","ir_out", "t")


