%****************************************************************
%                   Hochschule Hamm-Lippstadt                   *
%****************************************************************
% Modul	          : Standardunsicherheit_IR_Sensor.m            *
%                                                               *
%                                                               *
% Datum           : 25-Nov-2025                                 *
%                                                               *
% Funktion        : Bestimmung der Standardunsicherheit         *
%                   eines Sharp Infrarotsensors                 *
%                                                               *
% Implementation  : MATLAB 2024b                                *
%                                                               *
% Req. Toolbox    : keine                                       *
%                                                               *
% Author          : Daniel Block, Kilian Engelhardt             *
%                                                               *
% Bemerkung       : Modifizierung                               *
%                                                               *
% Letzte Änderung : 25-Nov-2025                                 *
%                                                               *
%***************************************************************/

%% Einlesen der Messwerte

load("IR_Messung.mat")

A = [distance.Data; voltage.Data] % Speichern der Messwerte

n = length(A) % Anzahl der Messwerte

%% Berechnung der Standardabweichung der Messwerte
% Berechnung des Mittelwerts
Rmean = mean(A);

% Berechnung der empirischen Standardabweichung
s = std(A);


%% Bestimmung der Standardunsicherheit vom Typ A
alpha = 0.95;         % Vertrauensniveau 95 %
p = 1 - alpha;        % Fehlerwahrscheinlichkeit
t = tinv(1 - p/2, n-1); % t-Faktor für zweiseitiges Konfidenzintervall
uA = s / sqrt(n);     % Typ A Unsicherheit

%% Bestimmung der Standardunsicherheit vom Typ B
uB = a / sqrt(3);     % Gleichverteilte Unsicherheit

%% Bestimmung der kombinierten Standardunsicherheit Typ C
uC = sqrt(uA^2 + uB^2);

%% Vollständiges Messergebnis
k = 1; % Vertrauensfaktor 
uAbs = k * uC; % absolute Messunsicherheit
uRel = (uAbs / Rmean) * 100; % relative Messunsicherheit in % 

%% Ergebnisdarstellung
figure;
hold on;

% Achsenbegrenzung
x = linspace(1, n, n);
y = Rmean;
plot(x,y,'b')

% Horizontale Linien für Mittelwert und Unsicherheitsbereich
yline(Rmean, 'b', 'Mittelwert', 'LabelHorizontalAlignment', 'left');
yline(Rmean + uAbs, 'r', 'Unsicherheit Typ C', 'LabelHorizontalAlignment', 'left');
yline(Rmean - uAbs, 'r');

% Achsenbeschriftung
xlabel('Anzahl der Messwerte');
ylabel('Widerstand in \Omega');
legend({'Mittelwert', 'Unsicherheit Typ C'}, 'Location', 'best');
grid on;

% Titel mit vollständigem Messergebnis
title(['Messergebnis : R = ', sprintf('%.3f', Rmean), ' ± ', ...
    sprintf('%.5f', uAbs), ' \Omega   \Omega = ', ...
    sprintf('%.3f', Rmean), ' \Omega ± ', sprintf('%.6f', uRel), '%']);