Gewicht = out.Gewicht
Rohdaten = out.Rohdaten


% Daten werden aus simout (Gewicht, digitalwert) geladen
Daten = Rohdaten;  % Hier Daten extrahieren
DWert = Gewicht;  % Hier Daten extrahieren

% Datenverarbeitung
n = length(Daten);  % Anzahl der Datenpunkte ermitteln
Rm = mean(Daten);  % Durchschnitt berechnen
sE = std(Daten);  % Standardabweichung berechnen

% Parameter des Arduino Uno R3
Bit = 24;  % Auflösung 24 bit
Uref = 615669;  % Referenzcounts
lsb = Uref / (2^Bit - 1);  % Mindestauflösung, Einheit: g (Quantisierungsfehler)

% Berechnen der Standardunsicherheit Typ A
alpha = 1 - 0.6827;  % Messunsicherheit mit 68,27% Prozent Aussagesicherheit, da Messtechnnik
p = 1 - (alpha / 2);  % Wahrscheinlichkeit für zweiseitiges t-Verteilungsintervall
t = tinv(p, n - 1);  % t-Wert für Student-t-Verteilung bei n-1 Freiheitsgraden
uA = sE * t / sqrt(n);  % Standardunsicherheit Typ A

% Berechnen der Standardunsicherheit Typ B
uB = lsb / sqrt(12);  % gleichverteilte (rechteckige) Verteilung

% Berechnen der Standardunsicherheit Typ C
uC = sqrt(uA^2 + uB^2);  % Kombination der Unsicherheiten Typ A und Typ B

% Berechnen der absoluten Messunsicherheit
k = 2;  % Vertrauensfaktor (Vertrauensniveau 0.9545)
uAbs = k * uC;  % absolute Messunsicherheit 
uRel = 100 * uAbs / Rm;  % relative Messunsicherheit in %

% Vollständiges Messergebnis ausgeben
disp(['Vollständige Messergebnis: m = ', num2str(Rm), ' ± ', num2str(uAbs), ' g ']);  % Ergebnis mit Unsicherheit anzeigen

% Maximal- und Minimalwerte sowie Bereich erstellen
Max = max(Daten);  % Den Maximalwert im Daten-Array finden
Min = min(Daten);  % Den Minimalwert im Daten-Array finden
x = Min:0.02:Max;  % Einen Bereich vom Minimalwert bis zum Maximalwert erstellen

% Grafik erstellen
h = gcf;  % Aktuelle Figur holen
set(h, 'Name', 'Ergebnisdarstellung', 'NumberTitle', 'off');  % Figur benennen
xlabel('Anzahl der Messwerte')  % x-Achsenbeschriftung
ylabel('Gewicht in g')  % y-Achsenbeschriftung
hold on

% Daten und Unsicherheiten plotten
p1 = plot(Daten, 'r.-');  % Messwerte plotten
p2 = yline(Rm, 'LineWidth', 2);  % Mittelwert als Linie plotten
p3 = yline(Rm + uC, 'Color', 'blue');  % Obere Grenze der Unsicherheit Typ C plotten
yline(Rm - uC, 'Color', 'blue');  % Untere Grenze der Unsicherheit Typ C plotten

% Titel und Legende 
title(['Messergebnis: Mittelwert = ', num2str(Rm), ' \pm ', num2str(sE), ',Counts , Counts = ', num2str(mean(Daten)), ' \pm ', num2str(uRel), '%'])  % Titel hinzufügen
hLegend = legend([p1, p2, p3], "Messwerte", "Mittelwert", "Unsicherheit Typ C", 'Location', 'northeast');  % Legende hinzufügen
hold off  % Halten des Plots beenden