
#include "HX711.h"

const int LOADCELL_DOUT_PIN = 5;
const int LOADCELL_SCK_PIN = 4;
const float CALIBRATION_FACTOR = -828.53; // Ermittelten Kalibrierungsfaktor hier einsetzen

HX711 scale;

void setup() {
  Serial.begin(9600);
  scale.begin(LOADCELL_DOUT_PIN, LOADCELL_SCK_PIN);
  scale.set_scale(CALIBRATION_FACTOR);
  scale.tare(); // Nullpunkt setzen
}

void loop() {
  if (scale.is_ready()) {
    float reading = scale.get_units(10); // Durchschnitt aus 10 Messungen
    Serial.print("Gewicht: ");
    Serial.print(reading, 2);
    Serial.println(" g");
  } else {
    Serial.println("HX711 not found.");
  }
  delay(100);
}
