
/*
 * Include Files
 *
 */
#if defined(MATLAB_MEX_FILE)
#include "tmwtypes.h"
#include "simstruc_types.h"
#else
#define SIMPLIFIED_RTWTYPES_COMPATIBILITY
#include "rtwtypes.h"
#undef SIMPLIFIED_RTWTYPES_COMPATIBILITY
#endif



/* %%%-SFUNWIZ_wrapper_includes_Changes_BEGIN --- EDIT HERE TO _END */
/***************************************************************************
%                   Hochschule Hamm-Lippstadt                             *
//**************************************************************************
% Modul	          :                                                       *
%                                                                         *
% Datum           : 15.01.2024                                            *
%                                                                         *
% Funktion        : Treiberfunktionalitt fr NRF24L01+ als Sender        *
%                                                                         *
% Implementation  : MATLAB/Simulink 2023b                                 *
%                                                                         *
% Req. Toolbox    : ------                                                *
%                                                                         *
% Author          : Daniel Hilger und Daniel Block                        *
%                                                                         *
% Bemerkung       :                                                       *
%                                                                         *
% Letzte nderung : 15-Jan-2024                                           *
%                                                                         *
%**************************************************************************/
#ifndef MATLAB_MEX_FILE

#define ARDUINO 100

#include <SPI.h>
#include <nRF24L01.h>
#include <RF24.h>

#include <Wire.h>

RF24 radio(7, 6); // CE, CSN
// Erstellung des Structs, welches gesendet wird
struct Data {
  float temp = 0;
  float humid = 0;
  double pressure = 0;
  float windspeed = 0;  
};
// Anlegen einer Variablen von dem Struct
Data sendData;

#endif
/* %%%-SFUNWIZ_wrapper_includes_Changes_END --- EDIT HERE TO _BEGIN */
#define u_width 1
#define u_1_width 1
#define u_2_width 1
#define u_3_width 1

/*
 * Create external references here.  
 *
 */
/* %%%-SFUNWIZ_wrapper_externs_Changes_BEGIN --- EDIT HERE TO _END */
/* extern double func(double a); */
/* %%%-SFUNWIZ_wrapper_externs_Changes_END --- EDIT HERE TO _BEGIN */

/*
 * Start function
 *
 */
void nRF24L01_Start_wrapper(real_T *xD)
{
/* %%%-SFUNWIZ_wrapper_Start_Changes_BEGIN --- EDIT HERE TO _END */
#ifndef MATLAB_MEX_FILE
    Serial.begin(9600);
    // Definieren der Adresse fr das NRF24L01 Modul. Diese Adresse wird verwendet, um Kommunikation zwischen zwei Modulen zu ermglichen.
    const byte address[6] = "00001";
    // Starten des NRF24L01 Moduls.
    radio.begin();
    // ffnen eines Schreibkanals auf dem NRF24L01 Modul.
    // Die Verwendung von 'address' legt fest, an welche Adresse gesendet wird.
    radio.openWritingPipe(address);
    // Festlegen der Sendeleistung des Funkmoduls.
    // RF24_PA_HIGH ist eine hohe Leistungsstufe, die eine grere Reichweite ermglicht.
    radio.setPALevel(RF24_PA_HIGH);
    // Beenden des Zuhrmodus.
    // Da das Modul in diesem Fall zum Senden von Daten verwendet wird, sollte es nicht gleichzeitig zuhren.
    radio.stopListening();
#endif
/* %%%-SFUNWIZ_wrapper_Start_Changes_END --- EDIT HERE TO _BEGIN */
}
/*
 * Output function
 *
 */
void nRF24L01_Outputs_wrapper(const real32_T *temp,
			const real32_T *humid,
			const real_T *pressure,
			const real32_T *windspeed,
			const real_T *xD)
{
/* %%%-SFUNWIZ_wrapper_Outputs_Changes_BEGIN --- EDIT HERE TO _END */
#ifndef MATLAB_MEX_FILE
    // Zuweisung von Sensordaten zu einer Struktur namens 'sendData'.
    // Diese Struktur wird dann ber das NRF24L01 Modul gesendet.
    sendData.temp = temp[0];
    sendData.humid = humid[0];
    sendData.pressure = pressure[0];
    sendData.windspeed = windspeed[0];
    // Senden der 'sendData' Struktur ber das NRF24L01 Funkmodul.
    // Die 'write' Funktion nimmt die Adresse der zu sendenden Daten und deren Gre.
    // Sie sorgt dafr, dass die gesamte Struktur korrekt bertragen wird.
    radio.write(&sendData, sizeof(Data));
#endif
/* %%%-SFUNWIZ_wrapper_Outputs_Changes_END --- EDIT HERE TO _BEGIN */
}

/*
 * Updates function
 *
 */
void nRF24L01_Update_wrapper(const real32_T *temp,
			const real32_T *humid,
			const real_T *pressure,
			const real32_T *windspeed,
			real_T *xD)
{
/* %%%-SFUNWIZ_wrapper_Update_Changes_BEGIN --- EDIT HERE TO _END */
 
/* %%%-SFUNWIZ_wrapper_Update_Changes_END --- EDIT HERE TO _BEGIN */
}

