%**************************************************************************
%                   Hochschule Hamm-Lippstadt                             *
%**************************************************************************
% Modul	          : Berechnung.m                                          *
%                                                                         *
% Datum           : 17.07.2024                                            *
%                                                                         *
% Funktion        : Auslesen Sensordaten zur Berechnung der Unsicherheiten*
%                                                                         *
% Implementation  : MATLAB 2023b                                          *
%                                                                         *
% Req. Toolbox    : DSP System Toolbox                                    *
%                                                                         *
% Author          : Ken Hilz                                              *
%                                                                         *
% Bemerkung       :                                                       *
%                                                                         *
% Letzte Änderung : 25-07-2024                                            *
%                                                                         *
%**************************************************************************
%% open('Feuchtigkeitssensor')

% Daten werden aus simout (Voltage, Digitalwert) geholt, das ein Array ist
Volt = Voltage;  % Hier Daten extrahieren
DWert = Digitalwert;  % Hier Daten extrahieren

% Datenverarbeitung
n = length(Volt);  % Anzahl der Datenpunkte ermitteln
Rm = mean(Volt);  % Durchschnitt berechnen
sE = std(Volt);  % Standardabweichung berechnen

% Parameter des Arduino Uno R3
Bit = 10;  % Auflösung 10 bit
Uref = 5;  % Referenzspannung in V
lsb = Uref / (2^Bit - 1);  % Mindestauflösung, Einheit: V (Quantisierungsfehler)

% Berechnen der Standardunsicherheit Typ A
alpha = 1 - 0.6827;  % Messunsicherheit mit 68,27% Prozent Aussagesicherheit, da Messtechnnik
p = 1 - (alpha / 2);  % Wahrscheinlichkeit für zweiseitiges t-Verteilungsintervall
t = tinv(p, n - 1);  % t-Wert für Student-t-Verteilung bei n-1 Freiheitsgraden
uA = sE * t / sqrt(n);  % Standardunsicherheit Typ A

% Berechnen der Standardunsicherheit Typ B
uB = lsb / sqrt(12);  % gleichverteilte (rechteckige) Verteilung

% Berechnen der Standardunsicherheit Typ C
uC = sqrt(uA^2 + uB^2);  % Kombination der Unsicherheiten Typ A und Typ B

% Berechnen der absoluten Messunsicherheit
k = 2;  % Vertrauensfaktor (Vertrauensniveau 0.9545)
uAbs = k * uC;  % absolute Messunsicherheit 
uRel = 100 * uAbs / Rm;  % relative Messunsicherheit in %

% Vollständiges Messergebnis ausgeben
disp(['Vollständige Messergebnis: U = ', num2str(Rm), ' ± ', num2str(uAbs), ' V ']);  % Ergebnis mit Unsicherheit anzeigen

% Maximal- und Minimalwerte sowie Bereich erstellen
Max = max(Volt);  % Den Maximalwert im Daten-Array finden
Min = min(Volt);  % Den Minimalwert im Daten-Array finden
x = Min:0.0001:Max;  % Einen Bereich vom Minimalwert bis zum Maximalwert erstellen

% Grafik erstellen
h = gcf;  % Aktuelle Figur holen
set(h, 'Name', 'Ergebnisdarstellung', 'NumberTitle', 'off');  % Figur benennen
xlabel('Anzahl der Messwerte')  % x-Achsenbeschriftung
ylabel('Spannung in V')  % y-Achsenbeschriftung
hold on

% Daten und Unsicherheiten plotten
p1 = plot(Volt, 'r.-');  % Messwerte plotten
p2 = yline(Rm, 'LineWidth', 2);  % Mittelwert als Linie plotten
p3 = yline(Rm + uC, 'Color', 'blue');  % Obere Grenze der Unsicherheit Typ C plotten
yline(Rm - uC, 'Color', 'blue');  % Untere Grenze der Unsicherheit Typ C plotten

% Titel und Legende 
title(['Messergebnis: Mittelwert = ', num2str(Rm), ' \pm ', num2str(sE), ' V, Spannung = ', num2str(mean(Volt)), ' \pm ', num2str(uRel), '%'])  % Titel hinzufügen
hLegend = legend([p1, p2, p3], "Messwerte", "Mittelwert", "Unsicherheit Typ C", 'Location', 'northeast');  % Legende hinzufügen
hold off  % Halten des Plots beenden



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

Max = max(Volt);  %% Den Maximalwert im Daten-Array finden
Min = min(Volt);  %% Den Minimalwert im Daten-Array finden
x = Min:0.0001:Max;%% Einen Bereich vom Minimalwert bis zum Maximalwert erstellen

h = gcf;
set(h, 'Name', 'Ergebnisdarstellung', 'NumberTitle', 'off');
xlabel('Anzahl der Messwerte')
ylabel('Spannung in V')
hold on

p1 = plot(Volt,'r.-');
p2 = yline(Rm, 'LineWidth', 2);
p3 = yline(Rm + uC, 'Color', 'blue');
yline(Rm - uC, 'Color', 'blue');
title(['Messergebnis: Mittelwert = ', num2str(Rm), ' \pm ', num2str(sE), ' V, Spannung = ', num2str(mean(Volt)), ' \pm ', num2str(uRel), '%'])

% Legende
hLegend = legend([p1, p2, p3], "Messwerte", "Mittelwert", "Unsicherheit Typ C", 'Location', 'northeast');
hold off

%% Berechnung des maximalen und minimalen Digitalwertes des Sensors

Max = max(DWert);  %% Den Maximalwert im Daten-Array finden
Min = min(DWert);  %% Den Minimalwert im Daten-Array finden
fprintf('Max Digitalwert: %.15f\n', Max); %% Darstellung Maximalwert
fprintf('Min Digitalwert: %.15f\n', Min); %% Darstellung Minimalwert

%% Berechnung der maximalen und minimalen Spannung des Sensors

Uamax = lsb * Max; % Berechnung der maximalen Spannung
Uamin = lsb * Min; % Berechnung der minimalen Spannung
format long  % Darstellung des Ergebnisses mit Nachkommastellen
fprintf('Uamax ohne Rundung: %.15f\n', Uamax); %% Darstellung Maximalwert
fprintf('Uamin ohne Rundung: %.15f\n', Uamin); %% Darstellung Minimalwert


